# coding: utf-8

"""
    Fireblocks API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 1.6.2
    Contact: support@fireblocks.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Union
from typing_extensions import Annotated
from fireblocks.models.validation_key_dto import ValidationKeyDto
from typing import Optional, Set
from typing_extensions import Self

class CreateValidationKeyResponseDto(BaseModel):
    """
    CreateValidationKeyResponseDto
    """ # noqa: E501
    validation_key: ValidationKeyDto = Field(description="Created validation key", alias="validationKey")
    admins: List[StrictStr] = Field(description="Admins who have to approve the validation key addition")
    approval_threshold: Union[Annotated[float, Field(strict=True, ge=0)], Annotated[int, Field(strict=True, ge=0)]] = Field(description="Minimal number of approvers required. 0 for all", alias="approvalThreshold")
    request_id: Union[StrictFloat, StrictInt] = Field(description="Approval request id. Can be cancelled", alias="requestId")
    __properties: ClassVar[List[str]] = ["validationKey", "admins", "approvalThreshold", "requestId"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CreateValidationKeyResponseDto from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of validation_key
        if self.validation_key:
            _dict['validationKey'] = self.validation_key.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CreateValidationKeyResponseDto from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "validationKey": ValidationKeyDto.from_dict(obj["validationKey"]) if obj.get("validationKey") is not None else None,
            "admins": obj.get("admins"),
            "approvalThreshold": obj.get("approvalThreshold"),
            "requestId": obj.get("requestId")
        })
        return _obj


