# coding: utf-8

"""
    Fireblocks API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 1.6.2
    Contact: support@fireblocks.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from fireblocks.models.create_token_request_dto_create_params import CreateTokenRequestDtoCreateParams
from typing import Optional, Set
from typing_extensions import Self

class CreateTokenRequestDto(BaseModel):
    """
    CreateTokenRequestDto
    """ # noqa: E501
    blockchain_id: Optional[StrictStr] = Field(default=None, description="The id of the blockchain the request was initiated on", alias="blockchainId")
    asset_id: Optional[StrictStr] = Field(default=None, description="The base asset identifier of the blockchain you want to deploy to", alias="assetId")
    vault_account_id: StrictStr = Field(description="The id of the vault account that initiated the request to issue the token", alias="vaultAccountId")
    create_params: CreateTokenRequestDtoCreateParams = Field(alias="createParams")
    display_name: Optional[StrictStr] = Field(default=None, alias="displayName")
    __properties: ClassVar[List[str]] = ["blockchainId", "assetId", "vaultAccountId", "createParams", "displayName"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CreateTokenRequestDto from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of create_params
        if self.create_params:
            _dict['createParams'] = self.create_params.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CreateTokenRequestDto from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "blockchainId": obj.get("blockchainId"),
            "assetId": obj.get("assetId"),
            "vaultAccountId": obj.get("vaultAccountId"),
            "createParams": CreateTokenRequestDtoCreateParams.from_dict(obj["createParams"]) if obj.get("createParams") is not None else None,
            "displayName": obj.get("displayName")
        })
        return _obj


