# coding: utf-8

"""
    Fireblocks API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 1.6.2
    Contact: support@fireblocks.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List
from typing_extensions import Annotated
from typing import Optional, Set
from typing_extensions import Self

class CreateSigningKeyDto(BaseModel):
    """
    CreateSigningKeyDto
    """ # noqa: E501
    signing_device_key_id: Annotated[str, Field(strict=True, max_length=256)] = Field(description="The ID, name or label of the key specified on the customer's signing device.", alias="signingDeviceKeyId")
    signed_cert_pem: StrictStr = Field(description="The signed certificate that includes the public key PEM of the signing key, signed by a validation key.", alias="signedCertPem")
    agent_user_id: Annotated[str, Field(min_length=36, strict=True, max_length=36)] = Field(description="Id of user to which this key belongs", alias="agentUserId")
    __properties: ClassVar[List[str]] = ["signingDeviceKeyId", "signedCertPem", "agentUserId"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CreateSigningKeyDto from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CreateSigningKeyDto from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "signingDeviceKeyId": obj.get("signingDeviceKeyId"),
            "signedCertPem": obj.get("signedCertPem"),
            "agentUserId": obj.get("agentUserId")
        })
        return _obj


