# coding: utf-8

"""
    Fireblocks API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 1.6.2
    Contact: support@fireblocks.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from fireblocks.models.function_doc import FunctionDoc
from typing import Optional, Set
from typing_extensions import Self

class ContractDoc(BaseModel):
    """
    ContractDoc
    """ # noqa: E501
    details: Optional[StrictStr] = Field(default=None, description="A description of the contract")
    events: Optional[StrictStr] = Field(default=None, description="A description of the contract`s events")
    kind: StrictStr = Field(description="Is it devdoc or userdoc")
    methods: Dict[str, FunctionDoc] = Field(description="The description of the contract functions")
    version: StrictStr = Field(description="The version of the contract")
    __properties: ClassVar[List[str]] = ["details", "events", "kind", "methods", "version"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ContractDoc from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each value in methods (dict)
        _field_dict = {}
        if self.methods:
            for _key in self.methods:
                if self.methods[_key]:
                    _field_dict[_key] = self.methods[_key].to_dict()
            _dict['methods'] = _field_dict
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ContractDoc from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "details": obj.get("details"),
            "events": obj.get("events"),
            "kind": obj.get("kind"),
            "methods": dict(
                (_k, FunctionDoc.from_dict(_v))
                for _k, _v in obj["methods"].items()
            )
            if obj.get("methods") is not None
            else None,
            "version": obj.get("version")
        })
        return _obj


