# coding: utf-8

"""
    Fireblocks API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 1.6.2
    Contact: support@fireblocks.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from fireblocks.models.aml_registration_result import AmlRegistrationResult
from fireblocks.models.compliance_screening_result import ComplianceScreeningResult
from typing import Optional, Set
from typing_extensions import Self

class ComplianceResult(BaseModel):
    """
    The result of the Compliance AML/Travel Rule screening.
    """ # noqa: E501
    aml: Optional[List[ComplianceScreeningResult]] = Field(default=None, description="The end result of the AML screening.")
    tr: Optional[List[ComplianceScreeningResult]] = Field(default=None, description="The result of the Travel Rule screening.")
    aml_list: Optional[List[ComplianceScreeningResult]] = Field(default=None, description="The list of all results of the AML screening.", alias="amlList")
    status: Optional[StrictStr] = Field(default=None, description="Status of compliance result screening.")
    aml_registration: Optional[List[AmlRegistrationResult]] = Field(default=None, description="The results of the AML address registration.", alias="amlRegistration")
    __properties: ClassVar[List[str]] = ["aml", "tr", "amlList", "status", "amlRegistration"]

    @field_validator('status')
    def status_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['Started', 'AMLStarted', 'AMLCompleted', 'AMLFailed', 'AMLInBackground', 'TRStarted', 'TRCompleted', 'TRFailed', 'Completed', 'RegistrationStarted', 'AMLRegistrationStarted', 'AMLRegistrationCompleted', 'TRUpdateStarted', 'TRUpdateCompleted', 'UpdateCompleted', 'IncomingStarted', 'AMLIncomingStarted', 'AMLIncomingCompleted', 'AMLIncomingFailed', 'AMLIncomingInBackground', 'TRIncomingStarted', 'TRIncomingCompleted', 'TRIncomingFailed', 'IncomingCompleted']):
            raise ValueError("must be one of enum values ('Started', 'AMLStarted', 'AMLCompleted', 'AMLFailed', 'AMLInBackground', 'TRStarted', 'TRCompleted', 'TRFailed', 'Completed', 'RegistrationStarted', 'AMLRegistrationStarted', 'AMLRegistrationCompleted', 'TRUpdateStarted', 'TRUpdateCompleted', 'UpdateCompleted', 'IncomingStarted', 'AMLIncomingStarted', 'AMLIncomingCompleted', 'AMLIncomingFailed', 'AMLIncomingInBackground', 'TRIncomingStarted', 'TRIncomingCompleted', 'TRIncomingFailed', 'IncomingCompleted')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ComplianceResult from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in aml (list)
        _items = []
        if self.aml:
            for _item in self.aml:
                if _item:
                    _items.append(_item.to_dict())
            _dict['aml'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in tr (list)
        _items = []
        if self.tr:
            for _item in self.tr:
                if _item:
                    _items.append(_item.to_dict())
            _dict['tr'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in aml_list (list)
        _items = []
        if self.aml_list:
            for _item in self.aml_list:
                if _item:
                    _items.append(_item.to_dict())
            _dict['amlList'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in aml_registration (list)
        _items = []
        if self.aml_registration:
            for _item in self.aml_registration:
                if _item:
                    _items.append(_item.to_dict())
            _dict['amlRegistration'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ComplianceResult from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "aml": [ComplianceScreeningResult.from_dict(_item) for _item in obj["aml"]] if obj.get("aml") is not None else None,
            "tr": [ComplianceScreeningResult.from_dict(_item) for _item in obj["tr"]] if obj.get("tr") is not None else None,
            "amlList": [ComplianceScreeningResult.from_dict(_item) for _item in obj["amlList"]] if obj.get("amlList") is not None else None,
            "status": obj.get("status"),
            "amlRegistration": [AmlRegistrationResult.from_dict(_item) for _item in obj["amlRegistration"]] if obj.get("amlRegistration") is not None else None
        })
        return _obj


