# coding: utf-8

"""
    Fireblocks API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 1.6.2
    Contact: support@fireblocks.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class AuditLogData(BaseModel):
    """
    AuditLogData
    """ # noqa: E501
    id: Optional[StrictStr] = Field(default=None, description="The unique identifier of the audit log")
    timestamp: Optional[StrictStr] = Field(default=None, description="The timestamp of the audit log")
    created_at: Optional[StrictStr] = Field(default=None, description="The timestamp of the audit log creation", alias="createdAt")
    user: Optional[StrictStr] = Field(default=None, description="The user who performed the action")
    subject: Optional[StrictStr] = Field(default=None, description="The subject of the action")
    event: Optional[StrictStr] = Field(default=None, description="The event that was performed")
    tenant_id: Optional[StrictStr] = Field(default=None, description="The tenant ID of the audit log", alias="tenantId")
    user_id: Optional[StrictStr] = Field(default=None, description="The user ID of the audit log", alias="userId")
    __properties: ClassVar[List[str]] = ["id", "timestamp", "createdAt", "user", "subject", "event", "tenantId", "userId"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of AuditLogData from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of AuditLogData from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "timestamp": obj.get("timestamp"),
            "createdAt": obj.get("createdAt"),
            "user": obj.get("user"),
            "subject": obj.get("subject"),
            "event": obj.get("event"),
            "tenantId": obj.get("tenantId"),
            "userId": obj.get("userId")
        })
        return _obj


