# coding: utf-8

"""
    Fireblocks API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 1.6.2
    Contact: support@fireblocks.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class AssetWallet(BaseModel):
    """
    AssetWallet
    """ # noqa: E501
    vault_id: Optional[StrictStr] = Field(default=None, description="ID of the vault account. You can [get the vault account by this ID](https://developers.fireblocks.com/reference/get_vault-accounts-vaultaccountid) to retrieve vault properties such as its name, auto fueling, hidden on UI or customer reference ID.", alias="vaultId")
    asset_id: Optional[StrictStr] = Field(default=None, description="ID of the asset. You can get more information about this asset by using the [supported assets API](https://developers.fireblocks.com/reference/get_supported-assets)", alias="assetId")
    available: Optional[StrictStr] = Field(default=None, description="Available balance, available to use in a transaction.")
    total: Optional[StrictStr] = Field(default=None, description="Total balance at the asset wallet, as seen at the blockchain explorers. This includes balance available, and any kind of unavailable balance such as locked, frozen, or others.")
    pending: Optional[StrictStr] = Field(default=None, description="Pending balance.")
    staked: Optional[StrictStr] = Field(default=None, description="Staked balance.")
    frozen: Optional[StrictStr] = Field(default=None, description="Funds frozen due to the anti-money laundering policy at this workspace.")
    locked_amount: Optional[StrictStr] = Field(default=None, description="Locked balance.", alias="lockedAmount")
    block_height: Optional[StrictStr] = Field(default=None, description="The height (number) of the block of the balance. Can by empty.", alias="blockHeight")
    block_hash: Optional[StrictStr] = Field(default=None, description="The hash of the block of the balance. Can by empty.", alias="blockHash")
    creation_timestamp: Optional[StrictStr] = Field(default=None, description="Unix timestamp of the time the asset wallet was created.", alias="creationTimestamp")
    __properties: ClassVar[List[str]] = ["vaultId", "assetId", "available", "total", "pending", "staked", "frozen", "lockedAmount", "blockHeight", "blockHash", "creationTimestamp"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of AssetWallet from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of AssetWallet from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "vaultId": obj.get("vaultId"),
            "assetId": obj.get("assetId"),
            "available": obj.get("available"),
            "total": obj.get("total"),
            "pending": obj.get("pending"),
            "staked": obj.get("staked"),
            "frozen": obj.get("frozen"),
            "lockedAmount": obj.get("lockedAmount"),
            "blockHeight": obj.get("blockHeight"),
            "blockHash": obj.get("blockHash"),
            "creationTimestamp": obj.get("creationTimestamp")
        })
        return _obj


