# coding: utf-8

"""
    Fireblocks API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 1.6.2
    Contact: support@fireblocks.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictFloat, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Union
from typing import Optional, Set
from typing_extensions import Self

class AssetPriceResponse(BaseModel):
    """
    AssetPriceResponse
    """ # noqa: E501
    legacy_id: StrictStr = Field(description="The ID of the asset", alias="legacyId")
    last_update_at: Union[StrictFloat, StrictInt] = Field(description="Time of last price update", alias="lastUpdateAt")
    currency: StrictStr = Field(description="Currency (according to ISO 4217 currency codes)")
    price: Union[StrictFloat, StrictInt] = Field(description="Price in currency")
    source: StrictStr = Field(description="Source of the price data")
    __properties: ClassVar[List[str]] = ["legacyId", "lastUpdateAt", "currency", "price", "source"]

    @field_validator('source')
    def source_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['PUBLIC', 'PRIVATE']):
            raise ValueError("must be one of enum values ('PUBLIC', 'PRIVATE')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of AssetPriceResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of AssetPriceResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "legacyId": obj.get("legacyId"),
            "lastUpdateAt": obj.get("lastUpdateAt"),
            "currency": obj.get("currency"),
            "price": obj.get("price"),
            "source": obj.get("source")
        })
        return _obj


