# coding: utf-8

"""
    Fireblocks API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 1.6.2
    Contact: support@fireblocks.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing import Optional, Set
from typing_extensions import Self

class AssetMetadataDto(BaseModel):
    """
    AssetMetadataDto
    """ # noqa: E501
    asset_id: StrictStr = Field(description="The Fireblocks` asset id", alias="assetId")
    name: Optional[StrictStr] = Field(default=None, description="The name of the token")
    symbol: Optional[StrictStr] = Field(default=None, description="The symbol of the token")
    network_protocol: Optional[StrictStr] = Field(default=None, description="The network protocol of the token", alias="networkProtocol")
    total_supply: Optional[StrictStr] = Field(default=None, description="The total supply of the token", alias="totalSupply")
    holders_count: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="The number of holders of the token", alias="holdersCount")
    type: Optional[StrictStr] = Field(default=None, description="The type of the token")
    contract_address: Optional[StrictStr] = Field(default=None, description="The address of the token contract", alias="contractAddress")
    issuer_address: Optional[StrictStr] = Field(default=None, description="In case of Stellar or Ripple, the address of the issuer of the token", alias="issuerAddress")
    testnet: Optional[StrictBool] = Field(default=None, description="Is it deployed on testnet or to mainnet")
    blockchain: Optional[StrictStr] = Field(default=None, description="The blockchain native asset id which the token is deployed on")
    decimals: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="The number of decimals of the token")
    vault_account_id: Optional[StrictStr] = Field(default=None, description="The id of the vault account that initiated the request to issue the token. Will be empty if token was issued outside of Fireblocks.", alias="vaultAccountId")
    __properties: ClassVar[List[str]] = ["assetId", "name", "symbol", "networkProtocol", "totalSupply", "holdersCount", "type", "contractAddress", "issuerAddress", "testnet", "blockchain", "decimals", "vaultAccountId"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of AssetMetadataDto from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of AssetMetadataDto from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "assetId": obj.get("assetId"),
            "name": obj.get("name"),
            "symbol": obj.get("symbol"),
            "networkProtocol": obj.get("networkProtocol"),
            "totalSupply": obj.get("totalSupply"),
            "holdersCount": obj.get("holdersCount"),
            "type": obj.get("type"),
            "contractAddress": obj.get("contractAddress"),
            "issuerAddress": obj.get("issuerAddress"),
            "testnet": obj.get("testnet"),
            "blockchain": obj.get("blockchain"),
            "decimals": obj.get("decimals"),
            "vaultAccountId": obj.get("vaultAccountId")
        })
        return _obj


