"""
    Fireblocks API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 1.6.2
    Contact: support@fireblocks.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

import json
import jwt
import uuid
import time
from hashlib import sha256
from typing import Dict, Optional


class BearerTokenProvider:
    def __init__(self, api_key: str, secret_key: str):
        self._api_key = api_key
        self._secret_key = secret_key

    def get_token(self, method: str, path: str, body: Optional[Dict]) -> str:
        if not self._is_payload_signature_required(method):
            body = None
        return self._sign_jwt(path, body)

    def _is_payload_signature_required(self, method: str) -> bool:
        return method.upper() in ["POST", "PATCH", "PUT"]

    def _sign_jwt(self, path, body_json):
        timestamp_secs = int(time.time())
        nonce = str(uuid.uuid4())
        body_hash = sha256(
            (json.dumps(body_json) if body_json is not None else "").encode("utf-8")
        ).hexdigest()
        token_expiration_time = 55  # Token expiration time in seconds

        token = {
            "uri": path,
            "nonce": nonce,
            "iat": timestamp_secs,
            "exp": timestamp_secs + token_expiration_time,
            "sub": self._api_key,
            "bodyHash": body_hash,
        }

        return jwt.encode(token, key=self._secret_key, algorithm="RS256")
