# coding: utf-8

"""
    Fireblocks API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 1.6.2
    Contact: support@fireblocks.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

import warnings
from concurrent.futures import Future
from pydantic import validate_call, Field, StrictFloat, StrictStr, StrictInt
from typing import Any, Dict, List, Optional, Tuple, Union
from typing_extensions import Annotated

from pydantic import Field, StrictStr, field_validator
from typing import List, Optional
from typing_extensions import Annotated
from fireblocks.models.cancel_transaction_response import CancelTransactionResponse
from fireblocks.models.create_transaction_response import CreateTransactionResponse
from fireblocks.models.drop_transaction_request import DropTransactionRequest
from fireblocks.models.drop_transaction_response import DropTransactionResponse
from fireblocks.models.estimated_network_fee_response import EstimatedNetworkFeeResponse
from fireblocks.models.estimated_transaction_fee_response import EstimatedTransactionFeeResponse
from fireblocks.models.freeze_transaction_response import FreezeTransactionResponse
from fireblocks.models.set_confirmations_threshold_request import SetConfirmationsThresholdRequest
from fireblocks.models.set_confirmations_threshold_response import SetConfirmationsThresholdResponse
from fireblocks.models.transaction_request import TransactionRequest
from fireblocks.models.transaction_response import TransactionResponse
from fireblocks.models.unfreeze_transaction_response import UnfreezeTransactionResponse
from fireblocks.models.validate_address_response import ValidateAddressResponse

from fireblocks.api_client import ApiClient, RequestSerialized
from fireblocks.api_response import ApiResponse
from fireblocks.rest import RESTResponseType
from fireblocks.validation_utils import validate_not_empty_string


class TransactionsApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client


    @validate_call
    def cancel_transaction(
        self,
        tx_id: Annotated[StrictStr, Field(description="The ID of the transaction to cancel")],
        x_end_user_wallet_id: Annotated[Optional[StrictStr], Field(description="Unique ID of the End-User wallet to the API request. Required for end-user wallet operations.")] = None,
        idempotency_key: Annotated[Optional[StrictStr], Field(description="A unique identifier for the request. If the request is sent multiple times with the same idempotency key, the server will return the same response as the first request. The idempotency key is valid for 24 hours.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> Future[ApiResponse[CancelTransactionResponse]]:
        """Cancel a transaction

        Cancels a transaction by ID.

        :param tx_id: The ID of the transaction to cancel (required)
        :type tx_id: str
        :param x_end_user_wallet_id: Unique ID of the End-User wallet to the API request. Required for end-user wallet operations.
        :type x_end_user_wallet_id: str
        :param idempotency_key: A unique identifier for the request. If the request is sent multiple times with the same idempotency key, the server will return the same response as the first request. The idempotency key is valid for 24 hours.
        :type idempotency_key: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        validate_not_empty_string(function_name="cancel_transaction", param_name="tx_id", param_value=tx_id)

        _param = self._cancel_transaction_serialize(
            tx_id=tx_id,
            x_end_user_wallet_id=x_end_user_wallet_id,
            idempotency_key=idempotency_key,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CancelTransactionResponse",
            'default': "ErrorSchema",
        }

        return self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout,
            _response_types_map=_response_types_map,
        )

    def _cancel_transaction_serialize(
        self,
        tx_id,
        x_end_user_wallet_id,
        idempotency_key,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if tx_id is not None:
            _path_params['txId'] = tx_id
        # process the query parameters
        # process the header parameters
        if x_end_user_wallet_id is not None:
            _header_params['X-End-User-Wallet-Id'] = x_end_user_wallet_id
        if idempotency_key is not None:
            _header_params['Idempotency-Key'] = idempotency_key
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/json'
            ]
        )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/transactions/{txId}/cancel',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def create_transaction(
        self,
        x_end_user_wallet_id: Annotated[Optional[StrictStr], Field(description="Unique ID of the End-User wallet to the API request. Required for end-user wallet operations.")] = None,
        idempotency_key: Annotated[Optional[StrictStr], Field(description="A unique identifier for the request. If the request is sent multiple times with the same idempotency key, the server will return the same response as the first request. The idempotency key is valid for 24 hours.")] = None,
        transaction_request: Optional[TransactionRequest] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> Future[ApiResponse[CreateTransactionResponse]]:
        """Create a new transaction

        Creates a new transaction.

        :param x_end_user_wallet_id: Unique ID of the End-User wallet to the API request. Required for end-user wallet operations.
        :type x_end_user_wallet_id: str
        :param idempotency_key: A unique identifier for the request. If the request is sent multiple times with the same idempotency key, the server will return the same response as the first request. The idempotency key is valid for 24 hours.
        :type idempotency_key: str
        :param transaction_request:
        :type transaction_request: TransactionRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501


        _param = self._create_transaction_serialize(
            x_end_user_wallet_id=x_end_user_wallet_id,
            idempotency_key=idempotency_key,
            transaction_request=transaction_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CreateTransactionResponse",
            'default': "ErrorSchema",
        }

        return self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout,
            _response_types_map=_response_types_map,
        )

    def _create_transaction_serialize(
        self,
        x_end_user_wallet_id,
        idempotency_key,
        transaction_request,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        if x_end_user_wallet_id is not None:
            _header_params['X-End-User-Wallet-Id'] = x_end_user_wallet_id
        if idempotency_key is not None:
            _header_params['Idempotency-Key'] = idempotency_key
        # process the form parameters
        # process the body parameter
        if transaction_request is not None:
            _body_params = transaction_request


        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/json'
            ]
        )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/transactions',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def drop_transaction(
        self,
        tx_id: Annotated[StrictStr, Field(description="The ID of the transaction")],
        x_end_user_wallet_id: Annotated[Optional[StrictStr], Field(description="Unique ID of the End-User wallet to the API request. Required for end-user wallet operations.")] = None,
        idempotency_key: Annotated[Optional[StrictStr], Field(description="A unique identifier for the request. If the request is sent multiple times with the same idempotency key, the server will return the same response as the first request. The idempotency key is valid for 24 hours.")] = None,
        drop_transaction_request: Optional[DropTransactionRequest] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> Future[ApiResponse[DropTransactionResponse]]:
        """Drop ETH transaction by ID

        Drops a stuck ETH transaction and creates a replacement transaction.

        :param tx_id: The ID of the transaction (required)
        :type tx_id: str
        :param x_end_user_wallet_id: Unique ID of the End-User wallet to the API request. Required for end-user wallet operations.
        :type x_end_user_wallet_id: str
        :param idempotency_key: A unique identifier for the request. If the request is sent multiple times with the same idempotency key, the server will return the same response as the first request. The idempotency key is valid for 24 hours.
        :type idempotency_key: str
        :param drop_transaction_request:
        :type drop_transaction_request: DropTransactionRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        validate_not_empty_string(function_name="drop_transaction", param_name="tx_id", param_value=tx_id)

        _param = self._drop_transaction_serialize(
            tx_id=tx_id,
            x_end_user_wallet_id=x_end_user_wallet_id,
            idempotency_key=idempotency_key,
            drop_transaction_request=drop_transaction_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DropTransactionResponse",
            'default': "ErrorSchema",
        }

        return self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout,
            _response_types_map=_response_types_map,
        )

    def _drop_transaction_serialize(
        self,
        tx_id,
        x_end_user_wallet_id,
        idempotency_key,
        drop_transaction_request,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if tx_id is not None:
            _path_params['txId'] = tx_id
        # process the query parameters
        # process the header parameters
        if x_end_user_wallet_id is not None:
            _header_params['X-End-User-Wallet-Id'] = x_end_user_wallet_id
        if idempotency_key is not None:
            _header_params['Idempotency-Key'] = idempotency_key
        # process the form parameters
        # process the body parameter
        if drop_transaction_request is not None:
            _body_params = drop_transaction_request


        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/json'
            ]
        )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/transactions/{txId}/drop',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def estimate_network_fee(
        self,
        asset_id: Annotated[StrictStr, Field(description="The asset for which to estimate the fee")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> Future[ApiResponse[EstimatedNetworkFeeResponse]]:
        """Estimate the required fee for an asset

        Gets the estimated required fee for an asset. For UTXO based assets, the response will contain the suggested fee per byte, for ETH/ETC based assets, the suggested gas price, and for XRP/XLM, the transaction fee.

        :param asset_id: The asset for which to estimate the fee (required)
        :type asset_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        validate_not_empty_string(function_name="estimate_network_fee", param_name="asset_id", param_value=asset_id)

        _param = self._estimate_network_fee_serialize(
            asset_id=asset_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "EstimatedNetworkFeeResponse",
            'default': "ErrorSchema",
        }

        return self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout,
            _response_types_map=_response_types_map,
        )

    def _estimate_network_fee_serialize(
        self,
        asset_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if asset_id is not None:
            
            _query_params.append(('assetId', asset_id))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/json'
            ]
        )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/estimate_network_fee',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def estimate_transaction_fee(
        self,
        idempotency_key: Annotated[Optional[StrictStr], Field(description="A unique identifier for the request. If the request is sent multiple times with the same idempotency key, the server will return the same response as the first request. The idempotency key is valid for 24 hours.")] = None,
        transaction_request: Optional[TransactionRequest] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> Future[ApiResponse[EstimatedTransactionFeeResponse]]:
        """Estimate transaction fee

        Estimates the transaction fee for a transaction request. * Note: Supports all Fireblocks assets except ZCash (ZEC).

        :param idempotency_key: A unique identifier for the request. If the request is sent multiple times with the same idempotency key, the server will return the same response as the first request. The idempotency key is valid for 24 hours.
        :type idempotency_key: str
        :param transaction_request:
        :type transaction_request: TransactionRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501


        _param = self._estimate_transaction_fee_serialize(
            idempotency_key=idempotency_key,
            transaction_request=transaction_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "EstimatedTransactionFeeResponse",
            'default': "ErrorSchema",
        }

        return self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout,
            _response_types_map=_response_types_map,
        )

    def _estimate_transaction_fee_serialize(
        self,
        idempotency_key,
        transaction_request,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        if idempotency_key is not None:
            _header_params['Idempotency-Key'] = idempotency_key
        # process the form parameters
        # process the body parameter
        if transaction_request is not None:
            _body_params = transaction_request


        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/json'
            ]
        )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/transactions/estimate_fee',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def freeze_transaction(
        self,
        tx_id: Annotated[StrictStr, Field(description="The ID of the transaction to freeze")],
        x_end_user_wallet_id: Annotated[Optional[StrictStr], Field(description="Unique ID of the End-User wallet to the API request. Required for end-user wallet operations.")] = None,
        idempotency_key: Annotated[Optional[StrictStr], Field(description="A unique identifier for the request. If the request is sent multiple times with the same idempotency key, the server will return the same response as the first request. The idempotency key is valid for 24 hours.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> Future[ApiResponse[FreezeTransactionResponse]]:
        """Freeze a transaction

        Freezes a transaction by ID.

        :param tx_id: The ID of the transaction to freeze (required)
        :type tx_id: str
        :param x_end_user_wallet_id: Unique ID of the End-User wallet to the API request. Required for end-user wallet operations.
        :type x_end_user_wallet_id: str
        :param idempotency_key: A unique identifier for the request. If the request is sent multiple times with the same idempotency key, the server will return the same response as the first request. The idempotency key is valid for 24 hours.
        :type idempotency_key: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        validate_not_empty_string(function_name="freeze_transaction", param_name="tx_id", param_value=tx_id)

        _param = self._freeze_transaction_serialize(
            tx_id=tx_id,
            x_end_user_wallet_id=x_end_user_wallet_id,
            idempotency_key=idempotency_key,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "FreezeTransactionResponse",
        }

        return self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout,
            _response_types_map=_response_types_map,
        )

    def _freeze_transaction_serialize(
        self,
        tx_id,
        x_end_user_wallet_id,
        idempotency_key,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if tx_id is not None:
            _path_params['txId'] = tx_id
        # process the query parameters
        # process the header parameters
        if x_end_user_wallet_id is not None:
            _header_params['X-End-User-Wallet-Id'] = x_end_user_wallet_id
        if idempotency_key is not None:
            _header_params['Idempotency-Key'] = idempotency_key
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/json'
            ]
        )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/transactions/{txId}/freeze',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def get_transaction(
        self,
        tx_id: Annotated[StrictStr, Field(description="The ID of the transaction to return")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> Future[ApiResponse[TransactionResponse]]:
        """Find a specific transaction by Fireblocks transaction ID

        Returns a transaction by ID.

        :param tx_id: The ID of the transaction to return (required)
        :type tx_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        validate_not_empty_string(function_name="get_transaction", param_name="tx_id", param_value=tx_id)

        _param = self._get_transaction_serialize(
            tx_id=tx_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "TransactionResponse",
            '400': "ErrorSchema",
            'default': "ErrorSchema",
        }

        return self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout,
            _response_types_map=_response_types_map,
        )

    def _get_transaction_serialize(
        self,
        tx_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if tx_id is not None:
            _path_params['txId'] = tx_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/json'
            ]
        )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/transactions/{txId}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def get_transaction_by_external_id(
        self,
        external_tx_id: Annotated[StrictStr, Field(description="The external ID of the transaction to return")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> Future[ApiResponse[TransactionResponse]]:
        """Find a specific transaction by external transaction ID

        Returns transaction by external transaction ID.

        :param external_tx_id: The external ID of the transaction to return (required)
        :type external_tx_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        validate_not_empty_string(function_name="get_transaction_by_external_id", param_name="external_tx_id", param_value=external_tx_id)

        _param = self._get_transaction_by_external_id_serialize(
            external_tx_id=external_tx_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "TransactionResponse",
            'default': "ErrorSchema",
        }

        return self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout,
            _response_types_map=_response_types_map,
        )

    def _get_transaction_by_external_id_serialize(
        self,
        external_tx_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if external_tx_id is not None:
            _path_params['externalTxId'] = external_tx_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/json'
            ]
        )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/transactions/external_tx_id/{externalTxId}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def get_transactions(
        self,
        before: Annotated[Optional[StrictStr], Field(description="Unix timestamp in milliseconds. Returns only transactions created before the specified date")] = None,
        after: Annotated[Optional[StrictStr], Field(description="Unix timestamp in milliseconds. Returns only transactions created after the specified date")] = None,
        status: Annotated[Optional[StrictStr], Field(description="You can filter by one of the statuses.")] = None,
        order_by: Annotated[Optional[StrictStr], Field(description="The field to order the results by  **Note**: Ordering by a field that is not createdAt may result with transactions that receive updates as you request the next or previous pages of results, resulting with missing those transactions.")] = None,
        sort: Annotated[Optional[StrictStr], Field(description="The direction to order the results by")] = None,
        limit: Annotated[Optional[Annotated[int, Field(strict=True, ge=1)]], Field(description="Limits the number of results. If not provided, a limit of 200 will be used. The maximum allowed limit is 500")] = None,
        source_type: Annotated[Optional[StrictStr], Field(description="The source type of the transaction")] = None,
        source_id: Annotated[Optional[StrictStr], Field(description="The source ID of the transaction")] = None,
        dest_type: Annotated[Optional[StrictStr], Field(description="The destination type of the transaction")] = None,
        dest_id: Annotated[Optional[StrictStr], Field(description="The destination ID of the transaction")] = None,
        assets: Annotated[Optional[StrictStr], Field(description="A list of assets to filter by, seperated by commas")] = None,
        tx_hash: Annotated[Optional[StrictStr], Field(description="Returns only results with a specified txHash")] = None,
        source_wallet_id: Annotated[Optional[StrictStr], Field(description="Returns only results where the source is a specific end user wallet")] = None,
        dest_wallet_id: Annotated[Optional[StrictStr], Field(description="Returns only results where the destination is a specific end user wallet")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> Future[ApiResponse[List[TransactionResponse]]]:
        """List transaction history

        Lists the transaction history for your workspace.

        :param before: Unix timestamp in milliseconds. Returns only transactions created before the specified date
        :type before: str
        :param after: Unix timestamp in milliseconds. Returns only transactions created after the specified date
        :type after: str
        :param status: You can filter by one of the statuses.
        :type status: str
        :param order_by: The field to order the results by  **Note**: Ordering by a field that is not createdAt may result with transactions that receive updates as you request the next or previous pages of results, resulting with missing those transactions.
        :type order_by: str
        :param sort: The direction to order the results by
        :type sort: str
        :param limit: Limits the number of results. If not provided, a limit of 200 will be used. The maximum allowed limit is 500
        :type limit: int
        :param source_type: The source type of the transaction
        :type source_type: str
        :param source_id: The source ID of the transaction
        :type source_id: str
        :param dest_type: The destination type of the transaction
        :type dest_type: str
        :param dest_id: The destination ID of the transaction
        :type dest_id: str
        :param assets: A list of assets to filter by, seperated by commas
        :type assets: str
        :param tx_hash: Returns only results with a specified txHash
        :type tx_hash: str
        :param source_wallet_id: Returns only results where the source is a specific end user wallet
        :type source_wallet_id: str
        :param dest_wallet_id: Returns only results where the destination is a specific end user wallet
        :type dest_wallet_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501


        _param = self._get_transactions_serialize(
            before=before,
            after=after,
            status=status,
            order_by=order_by,
            sort=sort,
            limit=limit,
            source_type=source_type,
            source_id=source_id,
            dest_type=dest_type,
            dest_id=dest_id,
            assets=assets,
            tx_hash=tx_hash,
            source_wallet_id=source_wallet_id,
            dest_wallet_id=dest_wallet_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[TransactionResponse]",
            'default': "ErrorSchema",
        }

        return self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout,
            _response_types_map=_response_types_map,
        )

    def _get_transactions_serialize(
        self,
        before,
        after,
        status,
        order_by,
        sort,
        limit,
        source_type,
        source_id,
        dest_type,
        dest_id,
        assets,
        tx_hash,
        source_wallet_id,
        dest_wallet_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if before is not None:
            
            _query_params.append(('before', before))
            
        if after is not None:
            
            _query_params.append(('after', after))
            
        if status is not None:
            
            _query_params.append(('status', status))
            
        if order_by is not None:
            
            _query_params.append(('orderBy', order_by))
            
        if sort is not None:
            
            _query_params.append(('sort', sort))
            
        if limit is not None:
            
            _query_params.append(('limit', limit))
            
        if source_type is not None:
            
            _query_params.append(('sourceType', source_type))
            
        if source_id is not None:
            
            _query_params.append(('sourceId', source_id))
            
        if dest_type is not None:
            
            _query_params.append(('destType', dest_type))
            
        if dest_id is not None:
            
            _query_params.append(('destId', dest_id))
            
        if assets is not None:
            
            _query_params.append(('assets', assets))
            
        if tx_hash is not None:
            
            _query_params.append(('txHash', tx_hash))
            
        if source_wallet_id is not None:
            
            _query_params.append(('sourceWalletId', source_wallet_id))
            
        if dest_wallet_id is not None:
            
            _query_params.append(('destWalletId', dest_wallet_id))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/json'
            ]
        )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/transactions',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def set_confirmation_threshold_by_transaction_hash(
        self,
        tx_hash: Annotated[StrictStr, Field(description="The TxHash")],
        idempotency_key: Annotated[Optional[StrictStr], Field(description="A unique identifier for the request. If the request is sent multiple times with the same idempotency key, the server will return the same response as the first request. The idempotency key is valid for 24 hours.")] = None,
        set_confirmations_threshold_request: Optional[SetConfirmationsThresholdRequest] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> Future[ApiResponse[SetConfirmationsThresholdResponse]]:
        """Set confirmation threshold by transaction hash

        Overrides the required number of confirmations for transaction completion by transaction hash.

        :param tx_hash: The TxHash (required)
        :type tx_hash: str
        :param idempotency_key: A unique identifier for the request. If the request is sent multiple times with the same idempotency key, the server will return the same response as the first request. The idempotency key is valid for 24 hours.
        :type idempotency_key: str
        :param set_confirmations_threshold_request:
        :type set_confirmations_threshold_request: SetConfirmationsThresholdRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        validate_not_empty_string(function_name="set_confirmation_threshold_by_transaction_hash", param_name="tx_hash", param_value=tx_hash)

        _param = self._set_confirmation_threshold_by_transaction_hash_serialize(
            tx_hash=tx_hash,
            idempotency_key=idempotency_key,
            set_confirmations_threshold_request=set_confirmations_threshold_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "SetConfirmationsThresholdResponse",
            'default': "ErrorSchema",
        }

        return self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout,
            _response_types_map=_response_types_map,
        )

    def _set_confirmation_threshold_by_transaction_hash_serialize(
        self,
        tx_hash,
        idempotency_key,
        set_confirmations_threshold_request,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if tx_hash is not None:
            _path_params['txHash'] = tx_hash
        # process the query parameters
        # process the header parameters
        if idempotency_key is not None:
            _header_params['Idempotency-Key'] = idempotency_key
        # process the form parameters
        # process the body parameter
        if set_confirmations_threshold_request is not None:
            _body_params = set_confirmations_threshold_request


        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/json'
            ]
        )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/txHash/{txHash}/set_confirmation_threshold',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def set_transaction_confirmation_threshold(
        self,
        tx_id: Annotated[StrictStr, Field(description="The ID of the transaction")],
        idempotency_key: Annotated[Optional[StrictStr], Field(description="A unique identifier for the request. If the request is sent multiple times with the same idempotency key, the server will return the same response as the first request. The idempotency key is valid for 24 hours.")] = None,
        set_confirmations_threshold_request: Optional[SetConfirmationsThresholdRequest] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> Future[ApiResponse[SetConfirmationsThresholdResponse]]:
        """Set confirmation threshold by transaction ID

        Overrides the required number of confirmations for transaction completion by transaction ID.

        :param tx_id: The ID of the transaction (required)
        :type tx_id: str
        :param idempotency_key: A unique identifier for the request. If the request is sent multiple times with the same idempotency key, the server will return the same response as the first request. The idempotency key is valid for 24 hours.
        :type idempotency_key: str
        :param set_confirmations_threshold_request:
        :type set_confirmations_threshold_request: SetConfirmationsThresholdRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        validate_not_empty_string(function_name="set_transaction_confirmation_threshold", param_name="tx_id", param_value=tx_id)

        _param = self._set_transaction_confirmation_threshold_serialize(
            tx_id=tx_id,
            idempotency_key=idempotency_key,
            set_confirmations_threshold_request=set_confirmations_threshold_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "SetConfirmationsThresholdResponse",
            'default': "ErrorSchema",
        }

        return self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout,
            _response_types_map=_response_types_map,
        )

    def _set_transaction_confirmation_threshold_serialize(
        self,
        tx_id,
        idempotency_key,
        set_confirmations_threshold_request,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if tx_id is not None:
            _path_params['txId'] = tx_id
        # process the query parameters
        # process the header parameters
        if idempotency_key is not None:
            _header_params['Idempotency-Key'] = idempotency_key
        # process the form parameters
        # process the body parameter
        if set_confirmations_threshold_request is not None:
            _body_params = set_confirmations_threshold_request


        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/json'
            ]
        )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/transactions/{txId}/set_confirmation_threshold',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def unfreeze_transaction(
        self,
        tx_id: Annotated[StrictStr, Field(description="The ID of the transaction to unfreeze")],
        x_end_user_wallet_id: Annotated[Optional[StrictStr], Field(description="Unique ID of the End-User wallet to the API request. Required for end-user wallet operations.")] = None,
        idempotency_key: Annotated[Optional[StrictStr], Field(description="A unique identifier for the request. If the request is sent multiple times with the same idempotency key, the server will return the same response as the first request. The idempotency key is valid for 24 hours.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> Future[ApiResponse[UnfreezeTransactionResponse]]:
        """Unfreeze a transaction

        Unfreezes a transaction by ID and makes the transaction available again.

        :param tx_id: The ID of the transaction to unfreeze (required)
        :type tx_id: str
        :param x_end_user_wallet_id: Unique ID of the End-User wallet to the API request. Required for end-user wallet operations.
        :type x_end_user_wallet_id: str
        :param idempotency_key: A unique identifier for the request. If the request is sent multiple times with the same idempotency key, the server will return the same response as the first request. The idempotency key is valid for 24 hours.
        :type idempotency_key: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        validate_not_empty_string(function_name="unfreeze_transaction", param_name="tx_id", param_value=tx_id)

        _param = self._unfreeze_transaction_serialize(
            tx_id=tx_id,
            x_end_user_wallet_id=x_end_user_wallet_id,
            idempotency_key=idempotency_key,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "UnfreezeTransactionResponse",
        }

        return self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout,
            _response_types_map=_response_types_map,
        )

    def _unfreeze_transaction_serialize(
        self,
        tx_id,
        x_end_user_wallet_id,
        idempotency_key,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if tx_id is not None:
            _path_params['txId'] = tx_id
        # process the query parameters
        # process the header parameters
        if x_end_user_wallet_id is not None:
            _header_params['X-End-User-Wallet-Id'] = x_end_user_wallet_id
        if idempotency_key is not None:
            _header_params['Idempotency-Key'] = idempotency_key
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/json'
            ]
        )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/transactions/{txId}/unfreeze',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def validate_address(
        self,
        asset_id: Annotated[StrictStr, Field(description="The asset of the address")],
        address: Annotated[StrictStr, Field(description="The address to validate")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> Future[ApiResponse[ValidateAddressResponse]]:
        """Validate destination address

        Checks if an address is valid (for XRP, DOT, XLM, and EOS).

        :param asset_id: The asset of the address (required)
        :type asset_id: str
        :param address: The address to validate (required)
        :type address: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        validate_not_empty_string(function_name="validate_address", param_name="asset_id", param_value=asset_id)
        validate_not_empty_string(function_name="validate_address", param_name="address", param_value=address)

        _param = self._validate_address_serialize(
            asset_id=asset_id,
            address=address,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ValidateAddressResponse",
            'default': "ErrorSchema",
        }

        return self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout,
            _response_types_map=_response_types_map,
        )

    def _validate_address_serialize(
        self,
        asset_id,
        address,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if asset_id is not None:
            _path_params['assetId'] = asset_id
        if address is not None:
            _path_params['address'] = address
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            [
                'application/json'
            ]
        )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/transactions/validate_address/{assetId}/{address}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )


