import * as cdk from 'aws-cdk-lib';
import * as constructs from 'constructs';
/**
 * Manage a Fastly service.
 *
 * @schema CfnServiceProps
 */
export interface CfnServiceProps {
    /**
     * @schema CfnServiceProps#Name
     */
    readonly name: string;
    /**
     * @schema CfnServiceProps#Comment
     */
    readonly comment?: string;
    /**
     * @schema CfnServiceProps#Paused
     */
    readonly paused?: boolean;
    /**
     * @schema CfnServiceProps#Id
     */
    readonly id?: string;
    /**
     * @schema CfnServiceProps#Type
     */
    readonly type?: Type;
    /**
     * @schema CfnServiceProps#CustomerId
     */
    readonly customerId?: string;
    /**
     * @schema CfnServiceProps#CreatedAt
     */
    readonly createdAt?: Date;
    /**
     * @schema CfnServiceProps#UpdatedAt
     */
    readonly updatedAt?: Date;
    /**
     * @schema CfnServiceProps#DeletedAt
     */
    readonly deletedAt?: Date;
}
/**
 * Converts an object of type 'CfnServiceProps' to JSON representation.
 */
export declare function toJson_CfnServiceProps(obj: CfnServiceProps | undefined): Record<string, any> | undefined;
/**
 * The type of this service.
 *
 * @schema Type
 */
export declare enum Type {
    /** vcl */
    VCL = "vcl",
    /** wasm */
    WASM = "wasm"
}
/**
 * A CloudFormation `Fastly::Services::Service`
 *
 * @cloudformationResource Fastly::Services::Service
 * @stability external
 * @link https://github.com/aws-ia/cloudformation-fastly-resource-providers.git
 */
export declare class CfnService extends cdk.CfnResource {
    /**
    * The CloudFormation resource type name for this resource class.
    */
    static readonly CFN_RESOURCE_TYPE_NAME = "Fastly::Services::Service";
    /**
     * Resource props.
     */
    readonly props: CfnServiceProps;
    /**
     * Attribute `Fastly::Services::Service.ActiveVersionId`
     * @link https://github.com/aws-ia/cloudformation-fastly-resource-providers.git
     */
    readonly attrActiveVersionId: string;
    /**
     * Attribute `Fastly::Services::Service.LatestVersionId`
     * @link https://github.com/aws-ia/cloudformation-fastly-resource-providers.git
     */
    readonly attrLatestVersionId: string;
    /**
     * Create a new `Fastly::Services::Service`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: constructs.Construct, id: string, props: CfnServiceProps);
}
