# -*- coding: utf-8 -*-
from setuptools import setup

modules = \
['linkbacks']
install_requires = \
['beautifulsoup4>=4.8.2,<5.0.0', 'requests>=2.22.0,<3.0.0']

setup_kwargs = {
    'name': 'pelican-plugin-linkbacks',
    'version': '1.0.2',
    'description': 'Pelican plugin implementing Linkback protocols, on the linking server side',
    'long_description': '[![Pull Requests Welcome](https://img.shields.io/badge/PRs-welcome-brightgreen.svg?style=flat)](http://makeapullrequest.com)\n[![build status](https://github.com/pelican-plugins/linkbacks/workflows/build/badge.svg)](https://github.com/pelican-plugins/linkbacks/actions?query=workflow%3Abuild)\n[![Pypi latest version](https://img.shields.io/pypi/v/pelican-plugin-linkbacks.svg)](https://pypi.python.org/pypi/pelican-plugin-linkbacks)\n[![License: AGPL v3](https://img.shields.io/badge/License-AGPL%20v3-blue.svg)](https://www.gnu.org/licenses/agpl-3.0)\n\n[Pelican](https://getpelican.com) plugin implementing [Linkback](https://en.wikipedia.org/wiki/Linkback) protocols,\non the linking server side.\n\nProtocols currently implemented:\n- [x] XMLRPC Pingback: [protocol spec](http://www.hixie.ch/specs/pingback/pingback)\n- [x] [Webmention](https://indieweb.org/Webmention): [protocol spec](https://github.com/converspace/webmention) - [W3C Recommendation](https://www.w3.org/TR/2017/REC-webmention-20170112/)\n\n❌ Refback: won\'t be implemented because it requires to retrieve the HTTP `Referer` header,\nwhich cannot be done by Pelican, a static blog engine\n\n❌ TalkBack: won\'t be implemented because it did not gain enough popularity / traction since its birth in 2011\n\n❌ Trackback ([protocol spec](http://archive.cweiske.de/trackback/trackback-1.2.html)):\nwon\'t be implemented because it does not seem widely used,\nand requires to parse embedded RDF documents (enclosed in HTML comments as a fallback),\nwhich seems a poor design in an era of HTML5 / [RDFa](https://fr.wikipedia.org/wiki/RDFa)\n\nDo not hesitate to suggest other protocols, or report your experience with this plugin, by submitting an _issue_.\n\n## What are linkbacks?\n\n> A linkback is a method for Web authors to obtain notifications when other authors link to one of their documents.\n> This enables authors to keep track of who is linking to, or referring to, their articles.\n> The four methods (Refback, Trackback, Pingback and Webmention) differ in how they accomplish this task.\n\nI invite you to read this Wikipedia page for more information & links: [Linkback](https://en.wikipedia.org/wiki/Linkback)\n\n\n## What does this plugin do?\nFor every hyperlink in your articles, this plugin will notify their hosting websites\n(just those supporting a Linkback protocol) of those references.\n\nThis plugin **does not** perform inclusion of Linkbacks **in your articles / as comments**,\nfor every website referencing your content following a Linkback protocol,\nbecause this cannot be performed by a static website generator like Pelican.\n\nWhen you enable this plugin the first time, it will process all the hyperlinks of your existing articles.\nIt will do it only once, and then create a cache file to avoid processing those links next time.\nStill, because the `publish` step will be longer than usual the first time you enable this plugin,\nI recommend to use `pelican -D` flag to get debug logs, and hence follow the plugin progress.\n\n\n## Installation / setup instructions\nTo enable this plugin:\n1. Install the package from Pypi: `pip install pelican-plugin-linkbacks`\n2. Add the plugin to your `publishconf.py`:\n```python\nPLUGINS = [..., \'linkbacks\']\n```\n\n### Cache\nIn order to avoid the repetitive CPU / bandwidth cost of repeatedly performing links parsing & linkback notifications,\nthis hook only proceed to do so once, the first time an article is published.\n\nIn order to do so, it uses a very simple and small cache that contains the list of all hyperlinks already parsed,\nper article `slug`. <!-- Note: alternatively, we could cache only article slugs and consider them entirely processed -->\n\nTo remove a blog entry from cache, in order for the plugin to retry sending a linkback:\n\n    jq "del(.[\'$slug\'])" pelican-plugin-linkbacks.json | sponge pelican-plugin-linkbacks.json\n\n\n### Configuration\nAvailable options:\n\n- `LINKBACKS_CACHEPATH` (optional, default: `$CACHE_PATH/pelican-plugin-linkbacks.json`,\nwhere `$CACHE_PATH` is [a Pelican setting](https://docs.getpelican.com/en/latest/settings.html)) :\n  the path to the JSON file containg this plugin cache (a list of URLs already processed).\n- `LINKBACKS_USERAGENT` (optional, default: `pelican-plugin-linkbacks`) :\n  the `User-Agent` HTTP header to use while sending notifications.\n- `LINKBACKS_CERT_VERIFY` (optional, default: `False`) :\n  enforce HTTPS certificates verification when sending linkbacks\n- `LINKBACKS_REQUEST_TIMEOUT` (optional, in seconds, default: `3`) :\n  time in seconds allowed for each HTTP linkback request before abandon\n\n\n## Contributing\n\nContributions are welcome and much appreciated. Every little bit helps. You can contribute by improving the documentation,\nadding missing features, and fixing bugs. You can also help out by reviewing and commenting on [existing issues](https://github.com/pelican-plugins/linkbacks/issues).\n\nTo start contributing to this plugin, review the [Contributing to Pelican](https://docs.getpelican.com/en/latest/contribute.html) documentation,\nbeginning with the **Contributing Code** section.\n\n\n### Releasing a new version\nWith a valid `~/.pypirc`:\n\n1. update `CHANGELOG.md`\n2. bump version in `pyproject.toml`\n3. `poetry build && poetry publish`\n4. perform a release on GitGub, including the description added to `CHANGELOG.md`\n\n\n## Linter & tests\nTo execute them:\n\n    pylint *linkbacks.py\n    pytest\n\n### Integration tests\n\nYou\'ll find some advices & resources on [indieweb.org](https://indieweb.org):\n[pingback page](https://indieweb.org/pingback), [webmention page](https://indieweb.org/Webmention).\n\nFor WebMentions specifically, the [webmention.io](https://webmention.io) service can be useful.\n\nFor Pingbacks, I used for my tests a Wordpress instance launched with Docker:\n\n    docker run --rm -p 80:80 -e WORDPRESS_DB_HOST=host.docker.internal -e WORDPRESS_DB_USER=... -e WORDPRESS_DB_PASSWORD=... wordpress\n\nFrom my experience, you\'ll also have to:\n- configure a local MySQL database to accept connections from `$WORDPRESS_DB_USER:$WORDPRESS_DB_PASSWORD`\n- configure the `xmlrpc_pingback_error` Wordpress filter to be _passthrough_, to get useful error messages\n- configure the `http_request_host_is_external` Wordpress filter to always return `true`,\n  so that it won\'t reject `host.docker.internal` links\n\nWordpress client source code related to XML-RPC pingbacks can be found there:\n- [wp-includes/comment.php](https://github.com/WordPress/WordPress/blob/master/wp-includes/comment.php)\n- [wp-includes/class-wp-xmlrpc-server.php](https://github.com/WordPress/WordPress/blob/master/wp-includes/class-wp-xmlrpc-server.php)\n',
    'author': 'Lucas Cimon',
    'author_email': 'lucas.cimon@gmail.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/pelican-plugins/linkbacks',
    'py_modules': modules,
    'install_requires': install_requires,
    'python_requires': '>=3.6,<4.0',
}


setup(**setup_kwargs)
