![Logo: random data visualization](https://raw.githubusercontent.com/hakavlad/tird/main/images/logo.png)

# tird

`tird` *(an acronym for "this is random data")* is a tool for writing random bytes, encrypting file contents, and hiding encrypted data.

`tird` can create files with random data, overwrite file contents with random data, encrypt file contents and comments, hide encrypted data among random data, minimize metadata leakage, and can provide some forms of [plausible deniability](https://en.wikipedia.org/wiki/Plausible_deniability#Use_in_cryptography).

## Goals

- Providing protection for individual files, including:
  - symmetric encryption;
  - reducing metadata leakage;
  - hiding encrypted data;
  - plausible deniability.
- Providing a stable encryption format with no [cryptographic agility](https://en.wikipedia.org/wiki/Cryptographic_agility) for long-term data storage.
- Simplicity and no [feature creep](https://en.wikipedia.org/wiki/Feature_creep): refusal to implement features that are not directly related to primary security goals.

## Cryptographic primitives

`tird` uses the following cryptographic primitives:
- `BLAKE2` ([RFC 7693](https://datatracker.ietf.org/doc/html/rfc7693.html)):
  - salted and personalized `BLAKE2b` for hashing keyfiles and passphrases;
  - keyed `BLAKE2b` for message authentication.
- `Argon2` memory-hard function ([RFC 9106](https://datatracker.ietf.org/doc/html/rfc9106/)) for key stretching and key derivation.
- `ChaCha20` cipher ([RFC 7539](https://datatracker.ietf.org/doc/html/rfc7539)) for data encryption.

## Encrypted file format

`tird` encrypted files (cryptoblobs) are indistinguishable from uniform random data and have no identifiable headers. `tird` produces cryptoblobs contain bilateral [randomized padding](https://en.wikipedia.org/wiki/Padding_(cryptography)#Randomized_padding) with uniform random data ([PURBs](https://en.wikipedia.org/wiki/PURB_(cryptography))). This minimizes metadata leaks from the file format and makes it possible to hide cryptoblobs among other random data.

Cryptoblob structure:

```
                     512 B        0+ B
                 +——————————+———————————————+
                 | Comments | File contents |
                 +——————————+———————————————+
  16 B    0+ B   |     Plaintext/Payload    |  64 B      0+ B     16 B
+——————+—————————+——————————————————————————+—————————+—————————+——————+
| Salt | Padding |        Ciphertext        | MAC tag | Padding | Salt |
+——————+—————————+——————————————————————————+—————————+—————————+——————+
|  Random bytes  |     Random-looking bytes           |  Random bytes  |
+————————————————+————————————————————————————————————+————————————————+
```

## Tradeoffs and limitations

- `tird` does not support public-key cryptography.
- `tird` does not support file compression.
- `tird` does not support ASCII armored output.
- `tird` does not support Reed–Solomon error correction.
- `tird` does not support splitting the output into chunks.
- `tird` does not support low-level device reading and writing when used on MS Windows (devices cannot be used as keyfiles, cannot be overwritten, cannot be encrypted or hidden).
- `tird` does not provide a graphical user interface.
- `tird` does not provide a password generator.
- `tird` does not wipe sensitive data from the heap.
- `tird` can only encrypt one file per iteration. Encryption of directories and multiple files is not supported.
- `tird` does not fake file timestamps (atime, mtime, ctime).
- `tird` encryption speed is not very fast: up to 180 MiB/s (in my tests).

## Warnings

- ⚠️ The author is not a cryptographer.
- ⚠️ `tird` has not been independently audited.
- ⚠️ `tird` probably won't help much when used in a compromised environment.
- ⚠️ `tird` probably won't help much when used with short and predictable keys.
- ⚠️ Keys may leak into the swap space.
- ⚠️ `tird` always releases unverified plaintext (violates [The Cryptographic Doom Principle](https://moxie.org/2011/12/13/the-cryptographic-doom-principle.html)).
- ⚠️ `tird` does not sort digests of keyfiles and passphrases in constant time.
- ⚠️ Development is not complete, there may be backward compatibility issues in the future.

## Usage

You don't need to remember command line options to use `tird`.

Just start `tird`, select a menu option, and then answer the questions that `tird` will ask:

```bash
$ tird
```

![screenshot: MENU](https://i.imgur.com/h2KG9iy.png)

## Debug

Start `tird` with the option `--debug` or `-d` to look under the hood while the program is running:

```bash
$ tird -d
```

Enabling debug messages additionally shows:
- opening and closing file descriptors;
- real paths to opened files;
- moving file pointers using the seek() method;
- salts, passphrases, digests, keys, nonces, tags;
- some other info.

## Tutorial

See [here](https://github.com/hakavlad/tird/blob/main/docs/tutorial/README.md).

## Requirements

- Python >= 3.6
- [PyNaCl](https://pypi.org/project/PyNaCl/) >= 1.2.0 (provides `Argon2`)
- [PyCryptodomex](https://pypi.org/project/pycryptodomex/) >= 3.6.2 (provides `ChaCha20`)

## Install

Install `python3` and `python3-pip` (or `python-pip`), then run

```bash
$ pip install tird
```

Standalone executables (made with [PyInstaller](https://pyinstaller.org/en/stable/)) are also available (see [Releases](https://github.com/hakavlad/tird/releases)).

![tird.exe](https://i.imgur.com/3ls7OOe.png)

## TODO

Write documentation:
- Features;
- User guide;
- Specification;
- Design rationale.

## Feedback

Feel free to post any questions, feedback or criticisms to the [Discussions](https://github.com/hakavlad/tird/discussions).

## License

This project is licensed under the terms of the [Creative Commons Zero v1.0 Universal License](https://github.com/hakavlad/tird/blob/main/LICENSE) (Public Domain Dedication).
