Hex = {
		'aliceblue':            '#F0F8FF',
		'antiquewhite':         '#FAEBD7',
		'aqua':                 '#00FFFF',
		'aquamarine':           '#7FFFD4',
		'azure':                '#F0FFFF',
		'beige':                '#F5F5DC',
		'bisque':               '#FFE4C4',
		'black':                '#000000',
		'blanchedalmond':       '#FFEBCD',
		'blue':                 '#0000FF',
		'blueviolet':           '#8A2BE2',
		'brown':                '#A52A2A',
		'burlywood':            '#DEB887',
		'cadetblue':            '#5F9EA0',
		'chartreuse':           '#7FFF00',
		'chocolate':            '#D2691E',
		'coral':                '#FF7F50',
		'cornflowerblue':       '#6495ED',
		'cornsilk':             '#FFF8DC',
		'crimson':              '#DC143C',
		'cyan':                 '#00FFFF',
		'darkblue':             '#00008B',
		'darkcyan':             '#008B8B',
		'darkgoldenrod':        '#B8860B',
		'darkgray':             '#A9A9A9',
		'darkgreen':            '#006400',
		'darkkhaki':            '#BDB76B',
		'darkmagenta':          '#8B008B',
		'darkolivegreen':       '#556B2F',
		'darkorange':           '#FF8C00',
		'darkorchid':           '#9932CC',
		'darkred':              '#8B0000',
		'darksalmon':           '#E9967A',
		'darkseagreen':         '#8FBC8F',
		'darkslateblue':        '#483D8B',
		'darkslategray':        '#2F4F4F',
		'darkturquoise':        '#00CED1',
		'darkviolet':           '#9400D3',
		'deeppink':             '#FF1493',
		'deepskyblue':          '#00BFFF',
		'dimgray':              '#696969',
		'dodgerblue':           '#1E90FF',
		'firebrick':            '#B22222',
		'floralwhite':          '#FFFAF0',
		'forestgreen':          '#228B22',
		'fuchsia':              '#FF00FF',
		'gainsboro':            '#DCDCDC',
		'ghostwhite':           '#F8F8FF',
		'gold':                 '#FFD700',
		'goldenrod':            '#DAA520',
		'gray':                 '#808080',
		'green':                '#008000',
		'greenyellow':          '#ADFF2F',
		'honeydew':             '#F0FFF0',
		'hotpink':              '#FF69B4',
		'indianred':            '#CD5C5C',
		'indigo':               '#4B0082',
		'ivory':                '#FFFFF0',
		'khaki':                '#F0E68C',
		'lavender':             '#E6E6FA',
		'lavenderblush':        '#FFF0F5',
		'lawngreen':            '#7CFC00',
		'lemonchiffon':         '#FFFACD',
		'lightblue':            '#ADD8E6',
		'lightcoral':           '#F08080',
		'lightcyan':            '#E0FFFF',
		'lightgoldenrodyellow': '#FAFAD2',
		'lightgreen':           '#90EE90',
		'lightgray':            '#D3D3D3',
		'lightpink':            '#FFB6C1',
		'lightsalmon':          '#FFA07A',
		'lightseagreen':        '#20B2AA',
		'lightskyblue':         '#87CEFA',
		'lightslategray':       '#778899',
		'lightsteelblue':       '#B0C4DE',
		'lightyellow':          '#FFFFE0',
		'lime':                 '#00FF00',
		'limegreen':            '#32CD32',
		'linen':                '#FAF0E6',
		'magenta':              '#FF00FF',
		'maroon':               '#800000',
		'mediumaquamarine':     '#66CDAA',
		'mediumblue':           '#0000CD',
		'mediumorchid':         '#BA55D3',
		'mediumpurple':         '#9370DB',
		'mediumseagreen':       '#3CB371',
		'mediumslateblue':      '#7B68EE',
		'mediumspringgreen':    '#00FA9A',
		'mediumturquoise':      '#48D1CC',
		'mediumvioletred':      '#C71585',
		'midnightblue':         '#191970',
		'mintcream':            '#F5FFFA',
		'mistyrose':            '#FFE4E1',
		'moccasin':             '#FFE4B5',
		'navajowhite':          '#FFDEAD',
		'navy':                 '#000080',
		'oldlace':              '#FDF5E6',
		'olive':                '#808000',
		'olivedrab':            '#6B8E23',
		'orange':               '#FFA500',
		'orangered':            '#FF4500',
		'orchid':               '#DA70D6',
		'palegoldenrod':        '#EEE8AA',
		'palegreen':            '#98FB98',
		'paleturquoise':        '#AFEEEE',
		'palevioletred':        '#DB7093',
		'papayawhip':           '#FFEFD5',
		'peachpuff':            '#FFDAB9',
		'peru':                 '#CD853F',
		'pink':                 '#FFC0CB',
		'plum':                 '#DDA0DD',
		'powderblue':           '#B0E0E6',
		'purple':               '#800080',
		'red':                  '#FF0000',
		'rosybrown':            '#BC8F8F',
		'royalblue':            '#4169E1',
		'saddlebrown':          '#8B4513',
		'salmon':               '#FA8072',
		'sandybrown':           '#FAA460',
		'seagreen':             '#2E8B57',
		'seashell':             '#FFF5EE',
		'sienna':               '#A0522D',
		'silver':               '#C0C0C0',
		'skyblue':              '#87CEEB',
		'slateblue':            '#6A5ACD',
		'slategray':            '#708090',
		'snow':                 '#FFFAFA',
		'springgreen':          '#00FF7F',
		'steelblue':            '#4682B4',
		'tan':                  '#D2B48C',
		'teal':                 '#008080',
		'thistle':              '#D8BFD8',
		'tomato':               '#FF6347',
		'turquoise':            '#40E0D0',
		'violet':               '#EE82EE',
		'wheat':                '#F5DEB3',
		'white':                '#FFFFFF',
		'whitesmoke':           '#F5F5F5',
		'yellow':               '#FFFF00',
		'yellowgreen':          '#9ACD32'
		}


OrderedHex = {
		"#f9ebea":(249, 235, 234),
		"#f2d7d5":(242, 215, 213),
		"#e6b0aa":(230, 176, 170),
		"#d98880":(217, 136, 128),
		"#cd6155":(205,  97,  85),
		"#c0392b":(192,  57,  43),
		"#a93226":(169,  50,  38),
		"#922b21":(146,  43,  33),
		"#7b241c":(123,  36,  28),
		"#641e16":(100,  30,  22),
		"#fdedec":(253, 237, 236),
		"#fadbd8":(250, 219, 216),
		"#f5b7b1":(245, 183, 177),
		"#f1948a":(241, 148, 138),
		"#ec7063":(236, 112,  99),
		"#e74c3c":(231,  76,  60),
		"#cb4335":(203,  67,  53),
		"#b03a2e":(176,  58,  46),
		"#943126":(148,  49,  38),
		"#78281f":(120,  40,  31),
		"#f5eef8":(245, 238, 248),
		"#ebdef0":(235, 222, 240),
		"#d7bde2":(215, 189, 226),
		"#c39bd3":(195, 155, 211),
		"#af7ac5":(175, 122, 197),
		"#9b59b6":(155,  89, 182),
		"#884ea0":(136,  78, 160),
		"#76448a":(118,  68, 138),
		"#633974":( 99,  57, 116),
		"#512e5f":( 81,  46,  95),
		"#f4ecf7":(244, 236, 247),
		"#e8daef":(232, 218, 239),
		"#d2b4de":(210, 180, 222),
		"#bb8fce":(187, 143, 206),
		"#a569bd":(165, 105, 189),
		"#8e44ad":(142,  68, 173),
		"#7d3c98":(125,  60, 152),
		"#6c3483":(108,  52, 131),
		"#5b2c6f":( 91,  44, 111),
		"#4a235a":( 74,  35,  90),
		"#eaf2f8":(234, 242, 248),
		"#d4e6f1":(212, 230, 241),
		"#a9cce3":(169, 204, 227),
		"#7fb3d5":(127, 179, 213),
		"#5499c7":( 84, 153, 199),
		"#2980b9":( 41, 128, 185),
		"#2471a3":( 36, 113, 163),
		"#1f618d":( 31,  97, 141),
		"#1a5276":( 26,  82, 118),
		"#154360":( 21,  67,  96),
		"#ebf5fb":(235, 245, 251),
		"#d6eaf8":(214, 234, 248),
		"#aed6f1":(174, 214, 241),
		"#85c1e9":(133, 193, 233),
		"#5dade2":( 93, 173, 226),
		"#3498db":( 52, 152, 219),
		"#2e86c1":( 46, 134, 193),
		"#2874a6":( 40, 116, 166),
		"#21618c":( 33,  97, 140),
		"#1b4f72":( 27,  79, 114),
		"#e8f8f5":(232, 248, 245),
		"#d1f2eb":(209, 242, 235),
		"#a3e4d7":(163, 228, 215),
		"#76d7c4":(118, 215, 196),
		"#48c9b0":( 72, 201, 176),
		"#1abc9c":( 26, 188, 156),
		"#17a589":( 23, 165, 137),
		"#148f77":( 20, 143, 119),
		"#117864":( 17, 120, 100),
		"#0e6251":( 14,  98,  81),
		"#e8f6f3":(232, 246, 243),
		"#d0ece7":(208, 236, 231),
		"#a2d9ce":(162, 217, 206),
		"#73c6b6":(115, 198, 182),
		"#45b39d":( 69, 179, 157),
		"#16a085":( 22, 160, 133),
		"#138d75":( 19, 141, 117),
		"#117a65":( 17, 122, 101),
		"#0e6655":( 14, 102,  85),
		"#0b5345":( 11,  83,  69),
		"#e9f7ef":(233, 247, 239),
		"#d4efdf":(212, 239, 223),
		"#a9dfbf":(169, 223, 191),
		"#7dcea0":(125, 206, 160),
		"#52be80":( 82, 190, 128),
		"#27ae60":( 39, 174,  96),
		"#229954":( 34, 153,  84),
		"#1e8449":( 30, 132,  73),
		"#196f3d":( 25, 111,  61),
		"#145a32":( 20,  90,  50),
		"#eafaf1":(234, 250, 241),
		"#d5f5e3":(213, 245, 227),
		"#abebc6":(171, 235, 198),
		"#82e0aa":(130, 224, 170),
		"#58d68d":( 88, 214, 141),
		"#2ecc71":( 46, 204, 113),
		"#28b463":( 40, 180,  99),
		"#239b56":( 35, 155,  86),
		"#1d8348":( 29, 131,  72),
		"#186a3b":( 24, 106,  59),
		"#fef9e7":(254, 249, 231),
		"#fcf3cf":(252, 243, 207),
		"#f9e79f":(249, 231, 159),
		"#f7dc6f":(247, 220, 111),
		"#f4d03f":(244, 208,  63),
		"#f1c40f":(241, 196,  15),
		"#d4ac0d":(212, 172,  13),
		"#b7950b":(183, 149,  11),
		"#9a7d0a":(154, 125,  10),
		"#7d6608":(125, 102,   8),
		"#fef5e7":(254, 245, 231),
		"#fdebd0":(253, 235, 208),
		"#fad7a0":(250, 215, 160),
		"#f8c471":(248, 196, 113),
		"#f5b041":(245, 176,  65),
		"#f39c12":(243, 156,  18),
		"#d68910":(214, 137,  16),
		"#b9770e":(185, 119,  14),
		"#9c640c":(156, 100,  12),
		"#7e5109":(126,  81,   9),
		"#fdf2e9":(253, 242, 233),
		"#fae5d3":(250, 229, 211),
		"#f5cba7":(245, 203, 167),
		"#f0b27a":(240, 178, 122),
		"#eb984e":(235, 152,  78),
		"#e67e22":(230, 126,  34),
		"#ca6f1e":(202, 111,  30),
		"#af601a":(175,  96,  26),
		"#935116":(147,  81,  22),
		"#784212":(120,  66,  18),
		"#fbeee6":(251, 238, 230),
		"#f6ddcc":(246, 221, 204),
		"#edbb99":(237, 187, 153),
		"#e59866":(229, 152, 102),
		"#dc7633":(220, 118,  51),
		"#d35400":(211,  84,   0),
		"#ba4a00":(186,  74,   0),
		"#a04000":(160,  64,   0),
		"#873600":(135,  54,   0),
		"#6e2c00":(110,  44,   0),
		"#fdfefe":(253, 254, 254),
		"#fbfcfc":(251, 252, 252),
		"#f7f9f9":(247, 249, 249),
		"#f4f6f7":(244, 246, 247),
		"#f0f3f4":(240, 243, 244),
		"#ecf0f1":(236, 240, 241),
		"#d0d3d4":(208, 211, 212),
		"#b3b6b7":(179, 182, 183),
		"#979a9a":(151, 154, 154),
		"#7b7d7d":(123, 125, 125),
		"#f8f9f9":(248, 249, 249),
		"#f2f3f4":(242, 243, 244),
		"#e5e7e9":(229, 231, 233),
		"#d7dbdd":(215, 219, 221),
		"#cacfd2":(202, 207, 210),
		"#bdc3c7":(189, 195, 199),
		"#a6acaf":(166, 172, 175),
		"#909497":(144, 148, 151),
		"#797d7f":(121, 125, 127),
		"#626567":( 98, 101, 103),
		"#f4f6f6":(244, 246, 246),
		"#eaeded":(234, 237, 237),
		"#d5dbdb":(213, 219, 219),
		"#bfc9ca":(191, 201, 202),
		"#aab7b8":(170, 183, 184),
		"#95a5a6":(149, 165, 166),
		"#839192":(131, 145, 146),
		"#717d7e":(113, 125, 126),
		"#5f6a6a":( 95, 106, 106),
		"#4d5656":( 77,  86,  86),
		"#f2f4f4":(242, 244, 244),
		"#e5e8e8":(229, 232, 232),
		"#ccd1d1":(204, 209, 209),
		"#b2babb":(178, 186, 187),
		"#99a3a4":(153, 163, 164),
		"#7f8c8d":(127, 140, 141),
		"#707b7c":(112, 123, 124),
		"#616a6b":( 97, 106, 107),
		"#515a5a":( 81,  90,  90),
		"#424949":( 66,  73,  73),
		"#ebedef":(235, 237, 239),
		"#d6dbdf":(214, 219, 223),
		"#aeb6bf":(174, 182, 191),
		"#85929e":(133, 146, 158),
		"#5d6d7e":( 93, 109, 126),
		"#34495e":( 52,  73,  94),
		"#2e4053":( 46,  64,  83),
		"#283747":( 40,  55,  71),
		"#212f3c":( 33,  47,  60),
		"#1b2631":( 27,  38,  49),
		"#eaecee":(234, 236, 238),
		"#d5d8dc":(213, 216, 220),
		"#abb2b9":(171, 178, 185),
		"#808b96":(128, 139, 150),
		"#566573":( 86, 101, 115),
		"#2c3e50":( 44,  62,  80),
		"#273746":( 39,  55,  70),
		"#212f3d":( 33,  47,  61),
		"#1c2833":( 28,  40,  51),
		"#17202a":( 23,  32,  42)
}


all_colors = (
	{'indian red': {'hex': '#B0171F', 'rgb': ('176', '23', '31')}},
	{'crimson': {'hex': '#DC143C', 'rgb': ('220', '20', '60')}},
	{'lightpink': {'hex': '#FFB6C1', 'rgb': ('255', '182', '193')}},
	{'lightpink 1': {'hex': '#FFAEB9', 'rgb': ('255', '174', '185')}},
	{'lightpink 2': {'hex': '#EEA2AD', 'rgb': ('238', '162', '173')}},
	{'lightpink 3': {'hex': '#CD8C95', 'rgb': ('205', '140', '149')}},
	{'lightpink 4': {'hex': '#8B5F65', 'rgb': ('139', '95', '101')}},
	{'pink': {'hex': '#FFC0CB', 'rgb': ('255', '192', '203')}},
	{'pink 1': {'hex': '#FFB5C5', 'rgb': ('255', '181', '197')}},
	{'pink 2': {'hex': '#EEA9B8', 'rgb': ('238', '169', '184')}},
	{'pink 3': {'hex': '#CD919E', 'rgb': ('205', '145', '158')}},
	{'pink 4': {'hex': '#8B636C', 'rgb': ('139', '99', '108')}},
	{'palevioletred': {'hex': '#DB7093', 'rgb': ('219', '112', '147')}},
	{'palevioletred 1': {'hex': '#FF82AB', 'rgb': ('255', '130', '171')}},
	{'palevioletred 2': {'hex': '#EE799F', 'rgb': ('238', '121', '159')}},
	{'palevioletred 3': {'hex': '#CD6889', 'rgb': ('205', '104', '137')}},
	{'palevioletred 4': {'hex': '#8B475D', 'rgb': ('139', '71', '93')}},
	{'lavenderblush 1 (lavenderblush)': {'hex': '#FFF0F5', 'rgb': ('255', '240', '245')}},
	{'lavenderblush 2': {'hex': '#EEE0E5', 'rgb': ('238', '224', '229')}},
	{'lavenderblush 3': {'hex': '#CDC1C5', 'rgb': ('205', '193', '197')}},
	{'lavenderblush 4': {'hex': '#8B8386', 'rgb': ('139', '131', '134')}},
	{'violetred 1': {'hex': '#FF3E96', 'rgb': ('255', '62', '150')}},
	{'violetred 2': {'hex': '#EE3A8C', 'rgb': ('238', '58', '140')}},
	{'violetred 3': {'hex': '#CD3278', 'rgb': ('205', '50', '120')}},
	{'violetred 4': {'hex': '#8B2252', 'rgb': ('139', '34', '82')}},
	{'hotpink': {'hex': '#FF69B4', 'rgb': ('255', '105', '180')}},
	{'hotpink 1': {'hex': '#FF6EB4', 'rgb': ('255', '110', '180')}},
	{'hotpink 2': {'hex': '#EE6AA7', 'rgb': ('238', '106', '167')}},
	{'hotpink 3': {'hex': '#CD6090', 'rgb': ('205', '96', '144')}},
	{'hotpink 4': {'hex': '#8B3A62', 'rgb': ('139', '58', '98')}},
	{'raspberry': {'hex': '#872657', 'rgb': ('135', '38', '87')}},
	{'deeppink 1 (deeppink)': {'hex': '#FF1493', 'rgb': ('255', '20', '147')}},
	{'deeppink 2': {'hex': '#EE1289', 'rgb': ('238', '18', '137')}},
	{'deeppink 3': {'hex': '#CD1076', 'rgb': ('205', '16', '118')}},
	{'deeppink 4': {'hex': '#8B0A50', 'rgb': ('139', '10', '80')}},
	{'maroon 1': {'hex': '#FF34B3', 'rgb': ('255', '52', '179')}},
	{'maroon 2': {'hex': '#EE30A7', 'rgb': ('238', '48', '167')}},
	{'maroon 3': {'hex': '#CD2990', 'rgb': ('205', '41', '144')}},
	{'maroon 4': {'hex': '#8B1C62', 'rgb': ('139', '28', '98')}},
	{'mediumvioletred': {'hex': '#C71585', 'rgb': ('199', '21', '133')}},
	{'violetred': {'hex': '#D02090', 'rgb': ('208', '32', '144')}},
	{'orchid': {'hex': '#DA70D6', 'rgb': ('218', '112', '214')}},
	{'orchid 1': {'hex': '#FF83FA', 'rgb': ('255', '131', '250')}},
	{'orchid 2': {'hex': '#EE7AE9', 'rgb': ('238', '122', '233')}},
	{'orchid 3': {'hex': '#CD69C9', 'rgb': ('205', '105', '201')}},
	{'orchid 4': {'hex': '#8B4789', 'rgb': ('139', '71', '137')}},
	{'thistle': {'hex': '#D8BFD8', 'rgb': ('216', '191', '216')}},
	{'thistle 1': {'hex': '#FFE1FF', 'rgb': ('255', '225', '255')}},
	{'thistle 2': {'hex': '#EED2EE', 'rgb': ('238', '210', '238')}},
	{'thistle 3': {'hex': '#CDB5CD', 'rgb': ('205', '181', '205')}},
	{'thistle 4': {'hex': '#8B7B8B', 'rgb': ('139', '123', '139')}},
	{'plum 1': {'hex': '#FFBBFF', 'rgb': ('255', '187', '255')}},
	{'plum 2': {'hex': '#EEAEEE', 'rgb': ('238', '174', '238')}},
	{'plum 3': {'hex': '#CD96CD', 'rgb': ('205', '150', '205')}},
	{'plum 4': {'hex': '#8B668B', 'rgb': ('139', '102', '139')}},
	{'plum': {'hex': '#DDA0DD', 'rgb': ('221', '160', '221')}},
	{'violet': {'hex': '#EE82EE', 'rgb': ('238', '130', '238')}},
	{'magenta (fuchsia)': {'hex': '#FF00FF', 'rgb': ('255', '0', '255')}},
	{'magenta 2': {'hex': '#EE00EE', 'rgb': ('238', '0', '238')}},
	{'magenta 3': {'hex': '#CD00CD', 'rgb': ('205', '0', '205')}},
	{'magenta 4 (darkmagenta)': {'hex': '#8B008B', 'rgb': ('139', '0', '139')}},
	{'purple': {'hex': '#800080', 'rgb': ('128', '0', '128')}},
	{'mediumorchid': {'hex': '#BA55D3', 'rgb': ('186', '85', '211')}},
	{'mediumorchid 1': {'hex': '#E066FF', 'rgb': ('224', '102', '255')}},
	{'mediumorchid 2': {'hex': '#D15FEE', 'rgb': ('209', '95', '238')}},
	{'mediumorchid 3': {'hex': '#B452CD', 'rgb': ('180', '82', '205')}},
	{'mediumorchid 4': {'hex': '#7A378B', 'rgb': ('122', '55', '139')}},
	{'darkviolet': {'hex': '#9400D3', 'rgb': ('148', '0', '211')}},
	{'darkorchid': {'hex': '#9932CC', 'rgb': ('153', '50', '204')}},
	{'darkorchid 1': {'hex': '#BF3EFF', 'rgb': ('191', '62', '255')}},
	{'darkorchid 2': {'hex': '#B23AEE', 'rgb': ('178', '58', '238')}},
	{'darkorchid 3': {'hex': '#9A32CD', 'rgb': ('154', '50', '205')}},
	{'darkorchid 4': {'hex': '#68228B', 'rgb': ('104', '34', '139')}},
	{'indigo': {'hex': '#4B0082', 'rgb': ('75', '0', '130')}},
	{'blueviolet': {'hex': '#8A2BE2', 'rgb': ('138', '43', '226')}},
	{'purple 1': {'hex': '#9B30FF', 'rgb': ('155', '48', '255')}},
	{'purple 2': {'hex': '#912CEE', 'rgb': ('145', '44', '238')}},
	{'purple 3': {'hex': '#7D26CD', 'rgb': ('125', '38', '205')}},
	{'purple 4': {'hex': '#551A8B', 'rgb': ('85', '26', '139')}},
	{'mediumpurple': {'hex': '#9370DB', 'rgb': ('147', '112', '219')}},
	{'mediumpurple 1': {'hex': '#AB82FF', 'rgb': ('171', '130', '255')}},
	{'mediumpurple 2': {'hex': '#9F79EE', 'rgb': ('159', '121', '238')}},
	{'mediumpurple 3': {'hex': '#8968CD', 'rgb': ('137', '104', '205')}},
	{'mediumpurple 4': {'hex': '#5D478B', 'rgb': ('93', '71', '139')}},
	{'darkslateblue': {'hex': '#483D8B', 'rgb': ('72', '61', '139')}},
	{'lightslateblue': {'hex': '#8470FF', 'rgb': ('132', '112', '255')}},
	{'mediumslateblue': {'hex': '#7B68EE', 'rgb': ('123', '104', '238')}},
	{'slateblue': {'hex': '#6A5ACD', 'rgb': ('106', '90', '205')}},
	{'slateblue 1': {'hex': '#836FFF', 'rgb': ('131', '111', '255')}},
	{'slateblue 2': {'hex': '#7A67EE', 'rgb': ('122', '103', '238')}},
	{'slateblue 3': {'hex': '#6959CD', 'rgb': ('105', '89', '205')}},
	{'slateblue 4': {'hex': '#473C8B', 'rgb': ('71', '60', '139')}},
	{'ghostwhite': {'hex': '#F8F8FF', 'rgb': ('248', '248', '255')}},
	{'lavender': {'hex': '#E6E6FA', 'rgb': ('230', '230', '250')}},
	{'blue': {'hex': '#0000FF', 'rgb': ('0', '0', '255')}},
	{'blue 2': {'hex': '#0000EE', 'rgb': ('0', '0', '238')}},
	{'blue 3 (mediumblue)': {'hex': '#0000CD', 'rgb': ('0', '0', '205')}},
	{'blue 4 (darkblue)': {'hex': '#00008B', 'rgb': ('0', '0', '139')}},
	{'navy': {'hex': '#000080', 'rgb': ('0', '0', '128')}},
	{'midnightblue': {'hex': '#191970', 'rgb': ('25', '25', '112')}},
	{'cobalt': {'hex': '#3D59AB', 'rgb': ('61', '89', '171')}},
	{'royalblue': {'hex': '#4169E1', 'rgb': ('65', '105', '225')}},
	{'royalblue 1': {'hex': '#4876FF', 'rgb': ('72', '118', '255')}},
	{'royalblue 2': {'hex': '#436EEE', 'rgb': ('67', '110', '238')}},
	{'royalblue 3': {'hex': '#3A5FCD', 'rgb': ('58', '95', '205')}},
	{'royalblue 4': {'hex': '#27408B', 'rgb': ('39', '64', '139')}},
	{'cornflowerblue': {'hex': '#6495ED', 'rgb': ('100', '149', '237')}},
	{'lightsteelblue': {'hex': '#B0C4DE', 'rgb': ('176', '196', '222')}},
	{'lightsteelblue 1': {'hex': '#CAE1FF', 'rgb': ('202', '225', '255')}},
	{'lightsteelblue 2': {'hex': '#BCD2EE', 'rgb': ('188', '210', '238')}},
	{'lightsteelblue 3': {'hex': '#A2B5CD', 'rgb': ('162', '181', '205')}},
	{'lightsteelblue 4': {'hex': '#6E7B8B', 'rgb': ('110', '123', '139')}},
	{'lightslategray': {'hex': '#778899', 'rgb': ('119', '136', '153')}},
	{'slategray': {'hex': '#708090', 'rgb': ('112', '128', '144')}},
	{'slategray 1': {'hex': '#C6E2FF', 'rgb': ('198', '226', '255')}},
	{'slategray 2': {'hex': '#B9D3EE', 'rgb': ('185', '211', '238')}},
	{'slategray 3': {'hex': '#9FB6CD', 'rgb': ('159', '182', '205')}},
	{'slategray 4': {'hex': '#6C7B8B', 'rgb': ('108', '123', '139')}},
	{'dodgerblue 1 (dodgerblue)': {'hex': '#1E90FF', 'rgb': ('30', '144', '255')}},
	{'dodgerblue 2': {'hex': '#1C86EE', 'rgb': ('28', '134', '238')}},
	{'dodgerblue 3': {'hex': '#1874CD', 'rgb': ('24', '116', '205')}},
	{'dodgerblue 4': {'hex': '#104E8B', 'rgb': ('16', '78', '139')}},
	{'aliceblue': {'hex': '#F0F8FF', 'rgb': ('240', '248', '255')}},
	{'steelblue': {'hex': '#4682B4', 'rgb': ('70', '130', '180')}},
	{'steelblue 1': {'hex': '#63B8FF', 'rgb': ('99', '184', '255')}},
	{'steelblue 2': {'hex': '#5CACEE', 'rgb': ('92', '172', '238')}},
	{'steelblue 3': {'hex': '#4F94CD', 'rgb': ('79', '148', '205')}},
	{'steelblue 4': {'hex': '#36648B', 'rgb': ('54', '100', '139')}},
	{'lightskyblue': {'hex': '#87CEFA', 'rgb': ('135', '206', '250')}},
	{'lightskyblue 1': {'hex': '#B0E2FF', 'rgb': ('176', '226', '255')}},
	{'lightskyblue 2': {'hex': '#A4D3EE', 'rgb': ('164', '211', '238')}},
	{'lightskyblue 3': {'hex': '#8DB6CD', 'rgb': ('141', '182', '205')}},
	{'lightskyblue 4': {'hex': '#607B8B', 'rgb': ('96', '123', '139')}},
	{'skyblue 1': {'hex': '#87CEFF', 'rgb': ('135', '206', '255')}},
	{'skyblue 2': {'hex': '#7EC0EE', 'rgb': ('126', '192', '238')}},
	{'skyblue 3': {'hex': '#6CA6CD', 'rgb': ('108', '166', '205')}},
	{'skyblue 4': {'hex': '#4A708B', 'rgb': ('74', '112', '139')}},
	{'skyblue': {'hex': '#87CEEB', 'rgb': ('135', '206', '235')}},
	{'deepskyblue 1 (deepskyblue)': {'hex': '#00BFFF', 'rgb': ('0', '191', '255')}},
	{'deepskyblue 2': {'hex': '#00B2EE', 'rgb': ('0', '178', '238')}},
	{'deepskyblue 3': {'hex': '#009ACD', 'rgb': ('0', '154', '205')}},
	{'deepskyblue 4': {'hex': '#00688B', 'rgb': ('0', '104', '139')}},
	{'peacock': {'hex': '#33A1C9', 'rgb': ('51', '161', '201')}},
	{'lightblue': {'hex': '#ADD8E6', 'rgb': ('173', '216', '230')}},
	{'lightblue 1': {'hex': '#BFEFFF', 'rgb': ('191', '239', '255')}},
	{'lightblue 2': {'hex': '#B2DFEE', 'rgb': ('178', '223', '238')}},
	{'lightblue 3': {'hex': '#9AC0CD', 'rgb': ('154', '192', '205')}},
	{'lightblue 4': {'hex': '#68838B', 'rgb': ('104', '131', '139')}},
	{'powderblue': {'hex': '#B0E0E6', 'rgb': ('176', '224', '230')}},
	{'cadetblue 1': {'hex': '#98F5FF', 'rgb': ('152', '245', '255')}},
	{'cadetblue 2': {'hex': '#8EE5EE', 'rgb': ('142', '229', '238')}},
	{'cadetblue 3': {'hex': '#7AC5CD', 'rgb': ('122', '197', '205')}},
	{'cadetblue 4': {'hex': '#53868B', 'rgb': ('83', '134', '139')}},
	{'turquoise 1': {'hex': '#00F5FF', 'rgb': ('0', '245', '255')}},
	{'turquoise 2': {'hex': '#00E5EE', 'rgb': ('0', '229', '238')}},
	{'turquoise 3': {'hex': '#00C5CD', 'rgb': ('0', '197', '205')}},
	{'turquoise 4': {'hex': '#00868B', 'rgb': ('0', '134', '139')}},
	{'cadetblue': {'hex': '#5F9EA0', 'rgb': ('95', '158', '160')}},
	{'darkturquoise': {'hex': '#00CED1', 'rgb': ('0', '206', '209')}},
	{'azure 1 (azure)': {'hex': '#F0FFFF', 'rgb': ('240', '255', '255')}},
	{'azure 2': {'hex': '#E0EEEE', 'rgb': ('224', '238', '238')}},
	{'azure 3': {'hex': '#C1CDCD', 'rgb': ('193', '205', '205')}},
	{'azure 4': {'hex': '#838B8B', 'rgb': ('131', '139', '139')}},
	{'lightcyan 1 (lightcyan)': {'hex': '#E0FFFF', 'rgb': ('224', '255', '255')}},
	{'lightcyan 2': {'hex': '#D1EEEE', 'rgb': ('209', '238', '238')}},
	{'lightcyan 3': {'hex': '#B4CDCD', 'rgb': ('180', '205', '205')}},
	{'lightcyan 4': {'hex': '#7A8B8B', 'rgb': ('122', '139', '139')}},
	{'paleturquoise 1': {'hex': '#BBFFFF', 'rgb': ('187', '255', '255')}},
	{'paleturquoise 2 (paleturquoise)': {'hex': '#AEEEEE', 'rgb': ('174', '238', '238')}},
	{'paleturquoise 3': {'hex': '#96CDCD', 'rgb': ('150', '205', '205')}},
	{'paleturquoise 4': {'hex': '#668B8B', 'rgb': ('102', '139', '139')}},
	{'darkslategray': {'hex': '#2F4F4F', 'rgb': ('47', '79', '79')}},
	{'darkslategray 1': {'hex': '#97FFFF', 'rgb': ('151', '255', '255')}},
	{'darkslategray 2': {'hex': '#8DEEEE', 'rgb': ('141', '238', '238')}},
	{'darkslategray 3': {'hex': '#79CDCD', 'rgb': ('121', '205', '205')}},
	{'darkslategray 4': {'hex': '#528B8B', 'rgb': ('82', '139', '139')}},
	{'cyan / aqua': {'hex': '#00FFFF', 'rgb': ('0', '255', '255')}},
	{'cyan 2': {'hex': '#00EEEE', 'rgb': ('0', '238', '238')}},
	{'cyan 3': {'hex': '#00CDCD', 'rgb': ('0', '205', '205')}},
	{'cyan 4 (darkcyan)': {'hex': '#008B8B', 'rgb': ('0', '139', '139')}},
	{'teal': {'hex': '#008080', 'rgb': ('0', '128', '128')}},
	{'mediumturquoise': {'hex': '#48D1CC', 'rgb': ('72', '209', '204')}},
	{'lightseagreen': {'hex': '#20B2AA', 'rgb': ('32', '178', '170')}},
	{'manganeseblue': {'hex': '#03A89E', 'rgb': ('3', '168', '158')}},
	{'turquoise': {'hex': '#40E0D0', 'rgb': ('64', '224', '208')}},
	{'coldgrey': {'hex': '#808A87', 'rgb': ('128', '138', '135')}},
	{'turquoiseblue': {'hex': '#00C78C', 'rgb': ('0', '199', '140')}},
	{'aquamarine 1 (aquamarine)': {'hex': '#7FFFD4', 'rgb': ('127', '255', '212')}},
	{'aquamarine 2': {'hex': '#76EEC6', 'rgb': ('118', '238', '198')}},
	{'aquamarine 3 (mediumaquamarine)': {'hex': '#66CDAA', 'rgb': ('102', '205', '170')}},
	{'aquamarine 4': {'hex': '#458B74', 'rgb': ('69', '139', '116')}},
	{'mediumspringgreen': {'hex': '#00FA9A', 'rgb': ('0', '250', '154')}},
	{'mintcream': {'hex': '#F5FFFA', 'rgb': ('245', '255', '250')}},
	{'springgreen': {'hex': '#00FF7F', 'rgb': ('0', '255', '127')}},
	{'springgreen 1': {'hex': '#00EE76', 'rgb': ('0', '238', '118')}},
	{'springgreen 2': {'hex': '#00CD66', 'rgb': ('0', '205', '102')}},
	{'springgreen 3': {'hex': '#008B45', 'rgb': ('0', '139', '69')}},
	{'mediumseagreen': {'hex': '#3CB371', 'rgb': ('60', '179', '113')}},
	{'seagreen 1': {'hex': '#54FF9F', 'rgb': ('84', '255', '159')}},
	{'seagreen 2': {'hex': '#4EEE94', 'rgb': ('78', '238', '148')}},
	{'seagreen 3': {'hex': '#43CD80', 'rgb': ('67', '205', '128')}},
	{'seagreen 4 (seagreen)': {'hex': '#2E8B57', 'rgb': ('46', '139', '87')}},
	{'emeraldgreen': {'hex': '#00C957', 'rgb': ('0', '201', '87')}},
	{'mint': {'hex': '#BDFCC9', 'rgb': ('189', '252', '201')}},
	{'cobaltgreen': {'hex': '#3D9140', 'rgb': ('61', '145', '64')}},
	{'honeydew 1 (honeydew)': {'hex': '#F0FFF0', 'rgb': ('240', '255', '240')}},
	{'honeydew 2': {'hex': '#E0EEE0', 'rgb': ('224', '238', '224')}},
	{'honeydew 3': {'hex': '#C1CDC1', 'rgb': ('193', '205', '193')}},
	{'honeydew 4': {'hex': '#838B83', 'rgb': ('131', '139', '131')}},
	{'darkseagreen': {'hex': '#8FBC8F', 'rgb': ('143', '188', '143')}},
	{'darkseagreen 1': {'hex': '#C1FFC1', 'rgb': ('193', '255', '193')}},
	{'darkseagreen 2': {'hex': '#B4EEB4', 'rgb': ('180', '238', '180')}},
	{'darkseagreen 3': {'hex': '#9BCD9B', 'rgb': ('155', '205', '155')}},
	{'darkseagreen 4': {'hex': '#698B69', 'rgb': ('105', '139', '105')}},
	{'palegreen': {'hex': '#98FB98', 'rgb': ('152', '251', '152')}},
	{'palegreen 1': {'hex': '#9AFF9A', 'rgb': ('154', '255', '154')}},
	{'palegreen 2 (lightgreen)': {'hex': '#90EE90', 'rgb': ('144', '238', '144')}},
	{'palegreen 3': {'hex': '#7CCD7C', 'rgb': ('124', '205', '124')}},
	{'palegreen 4': {'hex': '#548B54', 'rgb': ('84', '139', '84')}},
	{'limegreen': {'hex': '#32CD32', 'rgb': ('50', '205', '50')}},
	{'forestgreen': {'hex': '#228B22', 'rgb': ('34', '139', '34')}},
	{'green 1 (lime)': {'hex': '#00FF00', 'rgb': ('0', '255', '0')}},
	{'green 2': {'hex': '#00EE00', 'rgb': ('0', '238', '0')}},
	{'green 3': {'hex': '#00CD00', 'rgb': ('0', '205', '0')}},
	{'green 4': {'hex': '#008B00', 'rgb': ('0', '139', '0')}},
	{'green': {'hex': '#008000', 'rgb': ('0', '128', '0')}},
	{'darkgreen': {'hex': '#006400', 'rgb': ('0', '100', '0')}},
	{'sapgreen': {'hex': '#308014', 'rgb': ('48', '128', '20')}},
	{'lawngreen': {'hex': '#7CFC00', 'rgb': ('124', '252', '0')}},
	{'chartreuse 1 (chartreuse)': {'hex': '#7FFF00', 'rgb': ('127', '255', '0')}},
	{'chartreuse 2': {'hex': '#76EE00', 'rgb': ('118', '238', '0')}},
	{'chartreuse 3': {'hex': '#66CD00', 'rgb': ('102', '205', '0')}},
	{'chartreuse 4': {'hex': '#458B00', 'rgb': ('69', '139', '0')}},
	{'greenyellow': {'hex': '#ADFF2F', 'rgb': ('173', '255', '47')}},
	{'darkolivegreen 1': {'hex': '#CAFF70', 'rgb': ('202', '255', '112')}},
	{'darkolivegreen 2': {'hex': '#BCEE68', 'rgb': ('188', '238', '104')}},
	{'darkolivegreen 3': {'hex': '#A2CD5A', 'rgb': ('162', '205', '90')}},
	{'darkolivegreen 4': {'hex': '#6E8B3D', 'rgb': ('110', '139', '61')}},
	{'darkolivegreen': {'hex': '#556B2F', 'rgb': ('85', '107', '47')}},
	{'olivedrab': {'hex': '#6B8E23', 'rgb': ('107', '142', '35')}},
	{'olivedrab 1': {'hex': '#C0FF3E', 'rgb': ('192', '255', '62')}},
	{'olivedrab 2': {'hex': '#B3EE3A', 'rgb': ('179', '238', '58')}},
	{'olivedrab 3 (yellowgreen)': {'hex': '#9ACD32', 'rgb': ('154', '205', '50')}},
	{'olivedrab 4': {'hex': '#698B22', 'rgb': ('105', '139', '34')}},
	{'ivory 1 (ivory)': {'hex': '#FFFFF0', 'rgb': ('255', '255', '240')}},
	{'ivory 2': {'hex': '#EEEEE0', 'rgb': ('238', '238', '224')}},
	{'ivory 3': {'hex': '#CDCDC1', 'rgb': ('205', '205', '193')}},
	{'ivory 4': {'hex': '#8B8B83', 'rgb': ('139', '139', '131')}},
	{'beige': {'hex': '#F5F5DC', 'rgb': ('245', '245', '220')}},
	{'lightyellow 1 (lightyellow)': {'hex': '#FFFFE0', 'rgb': ('255', '255', '224')}},
	{'lightyellow 2': {'hex': '#EEEED1', 'rgb': ('238', '238', '209')}},
	{'lightyellow 3': {'hex': '#CDCDB4', 'rgb': ('205', '205', '180')}},
	{'lightyellow 4': {'hex': '#8B8B7A', 'rgb': ('139', '139', '122')}},
	{'lightgoldenrodyellow': {'hex': '#FAFAD2', 'rgb': ('250', '250', '210')}},
	{'yellow 1 (yellow)': {'hex': '#FFFF00', 'rgb': ('255', '255', '0')}},
	{'yellow 2': {'hex': '#EEEE00', 'rgb': ('238', '238', '0')}},
	{'yellow 3': {'hex': '#CDCD00', 'rgb': ('205', '205', '0')}},
	{'yellow 4': {'hex': '#8B8B00', 'rgb': ('139', '139', '0')}},
	{'warmgrey': {'hex': '#808069', 'rgb': ('128', '128', '105')}},
	{'olive': {'hex': '#808000', 'rgb': ('128', '128', '0')}},
	{'darkkhaki': {'hex': '#BDB76B', 'rgb': ('189', '183', '107')}},
	{'khaki 1': {'hex': '#FFF68F', 'rgb': ('255', '246', '143')}},
	{'khaki 2': {'hex': '#EEE685', 'rgb': ('238', '230', '133')}},
	{'khaki 3': {'hex': '#CDC673', 'rgb': ('205', '198', '115')}},
	{'khaki 4': {'hex': '#8B864E', 'rgb': ('139', '134', '78')}},
	{'khaki': {'hex': '#F0E68C', 'rgb': ('240', '230', '140')}},
	{'palegoldenrod': {'hex': '#EEE8AA', 'rgb': ('238', '232', '170')}},
	{'lemonchiffon 1 (lemonchiffon)': {'hex': '#FFFACD', 'rgb': ('255', '250', '205')}},
	{'lemonchiffon 2': {'hex': '#EEE9BF', 'rgb': ('238', '233', '191')}},
	{'lemonchiffon 3': {'hex': '#CDC9A5', 'rgb': ('205', '201', '165')}},
	{'lemonchiffon 4': {'hex': '#8B8970', 'rgb': ('139', '137', '112')}},
	{'lightgoldenrod 1': {'hex': '#FFEC8B', 'rgb': ('255', '236', '139')}},
	{'lightgoldenrod 2': {'hex': '#EEDC82', 'rgb': ('238', '220', '130')}},
	{'lightgoldenrod 3': {'hex': '#CDBE70', 'rgb': ('205', '190', '112')}},
	{'lightgoldenrod 4': {'hex': '#8B814C', 'rgb': ('139', '129', '76')}},
	{'banana': {'hex': '#E3CF57', 'rgb': ('227', '207', '87')}},
	{'gold 1 (gold)': {'hex': '#FFD700', 'rgb': ('255', '215', '0')}},
	{'gold 2': {'hex': '#EEC900', 'rgb': ('238', '201', '0')}},
	{'gold 3': {'hex': '#CDAD00', 'rgb': ('205', '173', '0')}},
	{'gold 4': {'hex': '#8B7500', 'rgb': ('139', '117', '0')}},
	{'cornsilk 1 (cornsilk)': {'hex': '#FFF8DC', 'rgb': ('255', '248', '220')}},
	{'cornsilk 2': {'hex': '#EEE8CD', 'rgb': ('238', '232', '205')}},
	{'cornsilk 3': {'hex': '#CDC8B1', 'rgb': ('205', '200', '177')}},
	{'cornsilk 4': {'hex': '#8B8878', 'rgb': ('139', '136', '120')}},
	{'goldenrod': {'hex': '#DAA520', 'rgb': ('218', '165', '32')}},
	{'goldenrod 1': {'hex': '#FFC125', 'rgb': ('255', '193', '37')}},
	{'goldenrod 2': {'hex': '#EEB422', 'rgb': ('238', '180', '34')}},
	{'goldenrod 3': {'hex': '#CD9B1D', 'rgb': ('205', '155', '29')}},
	{'goldenrod 4': {'hex': '#8B6914', 'rgb': ('139', '105', '20')}},
	{'darkgoldenrod': {'hex': '#B8860B', 'rgb': ('184', '134', '11')}},
	{'darkgoldenrod 1': {'hex': '#FFB90F', 'rgb': ('255', '185', '15')}},
	{'darkgoldenrod 2': {'hex': '#EEAD0E', 'rgb': ('238', '173', '14')}},
	{'darkgoldenrod 3': {'hex': '#CD950C', 'rgb': ('205', '149', '12')}},
	{'darkgoldenrod 4': {'hex': '#8B6508', 'rgb': ('139', '101', '8')}},
	{'orange 1 (orange)': {'hex': '#FFA500', 'rgb': ('255', '165', '0')}},
	{'orange 2': {'hex': '#EE9A00', 'rgb': ('238', '154', '0')}},
	{'orange 3': {'hex': '#CD8500', 'rgb': ('205', '133', '0')}},
	{'orange 4': {'hex': '#8B5A00', 'rgb': ('139', '90', '0')}},
	{'floralwhite': {'hex': '#FFFAF0', 'rgb': ('255', '250', '240')}},
	{'oldlace': {'hex': '#FDF5E6', 'rgb': ('253', '245', '230')}},
	{'wheat': {'hex': '#F5DEB3', 'rgb': ('245', '222', '179')}},
	{'wheat 1': {'hex': '#FFE7BA', 'rgb': ('255', '231', '186')}},
	{'wheat 2': {'hex': '#EED8AE', 'rgb': ('238', '216', '174')}},
	{'wheat 3': {'hex': '#CDBA96', 'rgb': ('205', '186', '150')}},
	{'wheat 4': {'hex': '#8B7E66', 'rgb': ('139', '126', '102')}},
	{'moccasin': {'hex': '#FFE4B5', 'rgb': ('255', '228', '181')}},
	{'papayawhip': {'hex': '#FFEFD5', 'rgb': ('255', '239', '213')}},
	{'blanchedalmond': {'hex': '#FFEBCD', 'rgb': ('255', '235', '205')}},
	{'navajowhite 1 (navajowhite)': {'hex': '#FFDEAD', 'rgb': ('255', '222', '173')}},
	{'navajowhite 2': {'hex': '#EECFA1', 'rgb': ('238', '207', '161')}},
	{'navajowhite 3': {'hex': '#CDB38B', 'rgb': ('205', '179', '139')}},
	{'navajowhite 4': {'hex': '#8B795E', 'rgb': ('139', '121', '94')}},
	{'eggshell': {'hex': '#FCE6C9', 'rgb': ('252', '230', '201')}},
	{'tan': {'hex': '#D2B48C', 'rgb': ('210', '180', '140')}},
	{'brick': {'hex': '#9C661F', 'rgb': ('156', '102', '31')}},
	{'cadmiumyellow': {'hex': '#FF9912', 'rgb': ('255', '153', '18')}},
	{'antiquewhite': {'hex': '#FAEBD7', 'rgb': ('250', '235', '215')}},
	{'antiquewhite 1': {'hex': '#FFEFDB', 'rgb': ('255', '239', '219')}},
	{'antiquewhite 2': {'hex': '#EEDFCC', 'rgb': ('238', '223', '204')}},
	{'antiquewhite 3': {'hex': '#CDC0B0', 'rgb': ('205', '192', '176')}},
	{'antiquewhite 4': {'hex': '#8B8378', 'rgb': ('139', '131', '120')}},
	{'burlywood': {'hex': '#DEB887', 'rgb': ('222', '184', '135')}},
	{'burlywood 1': {'hex': '#FFD39B', 'rgb': ('255', '211', '155')}},
	{'burlywood 2': {'hex': '#EEC591', 'rgb': ('238', '197', '145')}},
	{'burlywood 3': {'hex': '#CDAA7D', 'rgb': ('205', '170', '125')}},
	{'burlywood 4': {'hex': '#8B7355', 'rgb': ('139', '115', '85')}},
	{'bisque 1 (bisque)': {'hex': '#FFE4C4', 'rgb': ('255', '228', '196')}},
	{'bisque 2': {'hex': '#EED5B7', 'rgb': ('238', '213', '183')}},
	{'bisque 3': {'hex': '#CDB79E', 'rgb': ('205', '183', '158')}},
	{'bisque 4': {'hex': '#8B7D6B', 'rgb': ('139', '125', '107')}},
	{'melon': {'hex': '#E3A869', 'rgb': ('227', '168', '105')}},
	{'carrot': {'hex': '#ED9121', 'rgb': ('237', '145', '33')}},
	{'darkorange': {'hex': '#FF8C00', 'rgb': ('255', '140', '0')}},
	{'darkorange 1': {'hex': '#FF7F00', 'rgb': ('255', '127', '0')}},
	{'darkorange 2': {'hex': '#EE7600', 'rgb': ('238', '118', '0')}},
	{'darkorange 3': {'hex': '#CD6600', 'rgb': ('205', '102', '0')}},
	{'darkorange 4': {'hex': '#8B4500', 'rgb': ('139', '69', '0')}},
	{'orange': {'hex': '#FF8000', 'rgb': ('255', '128', '0')}},
	{'tan 1': {'hex': '#FFA54F', 'rgb': ('255', '165', '79')}},
	{'tan 2': {'hex': '#EE9A49', 'rgb': ('238', '154', '73')}},
	{'tan 3 (peru)': {'hex': '#CD853F', 'rgb': ('205', '133', '63')}},
	{'tan 4': {'hex': '#8B5A2B', 'rgb': ('139', '90', '43')}},
	{'linen': {'hex': '#FAF0E6', 'rgb': ('250', '240', '230')}},
	{'peachpuff 1 (peachpuff)': {'hex': '#FFDAB9', 'rgb': ('255', '218', '185')}},
	{'peachpuff 2': {'hex': '#EECBAD', 'rgb': ('238', '203', '173')}},
	{'peachpuff 3': {'hex': '#CDAF95', 'rgb': ('205', '175', '149')}},
	{'peachpuff 4': {'hex': '#8B7765', 'rgb': ('139', '119', '101')}},
	{'seashell 1 (seashell)': {'hex': '#FFF5EE', 'rgb': ('255', '245', '238')}},
	{'seashell 2': {'hex': '#EEE5DE', 'rgb': ('238', '229', '222')}},
	{'seashell 3': {'hex': '#CDC5BF', 'rgb': ('205', '197', '191')}},
	{'seashell 4': {'hex': '#8B8682', 'rgb': ('139', '134', '130')}},
	{'sandybrown': {'hex': '#F4A460', 'rgb': ('244', '164', '96')}},
	{'rawsienna': {'hex': '#C76114', 'rgb': ('199', '97', '20')}},
	{'chocolate': {'hex': '#D2691E', 'rgb': ('210', '105', '30')}},
	{'chocolate 1': {'hex': '#FF7F24', 'rgb': ('255', '127', '36')}},
	{'chocolate 2': {'hex': '#EE7621', 'rgb': ('238', '118', '33')}},
	{'chocolate 3': {'hex': '#CD661D', 'rgb': ('205', '102', '29')}},
	{'chocolate 4 (saddlebrown)': {'hex': '#8B4513', 'rgb': ('139', '69', '19')}},
	{'ivoryblack': {'hex': '#292421', 'rgb': ('41', '36', '33')}},
	{'flesh': {'hex': '#FF7D40', 'rgb': ('255', '125', '64')}},
	{'cadmiumorange': {'hex': '#FF6103', 'rgb': ('255', '97', '3')}},
	{'burntsienna': {'hex': '#8A360F', 'rgb': ('138', '54', '15')}},
	{'sienna': {'hex': '#A0522D', 'rgb': ('160', '82', '45')}},
	{'sienna 1': {'hex': '#FF8247', 'rgb': ('255', '130', '71')}},
	{'sienna 2': {'hex': '#EE7942', 'rgb': ('238', '121', '66')}},
	{'sienna 3': {'hex': '#CD6839', 'rgb': ('205', '104', '57')}},
	{'sienna 4': {'hex': '#8B4726', 'rgb': ('139', '71', '38')}},
	{'lightsalmon 1 (lightsalmon)': {'hex': '#FFA07A', 'rgb': ('255', '160', '122')}},
	{'lightsalmon 2': {'hex': '#EE9572', 'rgb': ('238', '149', '114')}},
	{'lightsalmon 3': {'hex': '#CD8162', 'rgb': ('205', '129', '98')}},
	{'lightsalmon 4': {'hex': '#8B5742', 'rgb': ('139', '87', '66')}},
	{'coral': {'hex': '#FF7F50', 'rgb': ('255', '127', '80')}},
	{'orangered 1 (orangered)': {'hex': '#FF4500', 'rgb': ('255', '69', '0')}},
	{'orangered 2': {'hex': '#EE4000', 'rgb': ('238', '64', '0')}},
	{'orangered 3': {'hex': '#CD3700', 'rgb': ('205', '55', '0')}},
	{'orangered 4': {'hex': '#8B2500', 'rgb': ('139', '37', '0')}},
	{'sepia': {'hex': '#5E2612', 'rgb': ('94', '38', '18')}},
	{'darksalmon': {'hex': '#E9967A', 'rgb': ('233', '150', '122')}},
	{'salmon 1': {'hex': '#FF8C69', 'rgb': ('255', '140', '105')}},
	{'salmon 2': {'hex': '#EE8262', 'rgb': ('238', '130', '98')}},
	{'salmon 3': {'hex': '#CD7054', 'rgb': ('205', '112', '84')}},
	{'salmon 4': {'hex': '#8B4C39', 'rgb': ('139', '76', '57')}},
	{'coral 1': {'hex': '#FF7256', 'rgb': ('255', '114', '86')}},
	{'coral 2': {'hex': '#EE6A50', 'rgb': ('238', '106', '80')}},
	{'coral 3': {'hex': '#CD5B45', 'rgb': ('205', '91', '69')}},
	{'coral 4': {'hex': '#8B3E2F', 'rgb': ('139', '62', '47')}},
	{'burntumber': {'hex': '#8A3324', 'rgb': ('138', '51', '36')}},
	{'tomato 1 (tomato)': {'hex': '#FF6347', 'rgb': ('255', '99', '71')}},
	{'tomato 2': {'hex': '#EE5C42', 'rgb': ('238', '92', '66')}},
	{'tomato 3': {'hex': '#CD4F39', 'rgb': ('205', '79', '57')}},
	{'tomato 4': {'hex': '#8B3626', 'rgb': ('139', '54', '38')}},
	{'salmon': {'hex': '#FA8072', 'rgb': ('250', '128', '114')}},
	{'mistyrose 1 (mistyrose)': {'hex': '#FFE4E1', 'rgb': ('255', '228', '225')}},
	{'mistyrose 2': {'hex': '#EED5D2', 'rgb': ('238', '213', '210')}},
	{'mistyrose 3': {'hex': '#CDB7B5', 'rgb': ('205', '183', '181')}},
	{'mistyrose 4': {'hex': '#8B7D7B', 'rgb': ('139', '125', '123')}},
	{'snow 1 (snow)': {'hex': '#FFFAFA', 'rgb': ('255', '250', '250')}},
	{'snow 2': {'hex': '#EEE9E9', 'rgb': ('238', '233', '233')}},
	{'snow 3': {'hex': '#CDC9C9', 'rgb': ('205', '201', '201')}},
	{'snow 4': {'hex': '#8B8989', 'rgb': ('139', '137', '137')}},
	{'rosybrown': {'hex': '#BC8F8F', 'rgb': ('188', '143', '143')}},
	{'rosybrown 1': {'hex': '#FFC1C1', 'rgb': ('255', '193', '193')}},
	{'rosybrown 2': {'hex': '#EEB4B4', 'rgb': ('238', '180', '180')}},
	{'rosybrown 3': {'hex': '#CD9B9B', 'rgb': ('205', '155', '155')}},
	{'rosybrown 4': {'hex': '#8B6969', 'rgb': ('139', '105', '105')}},
	{'lightcoral': {'hex': '#F08080', 'rgb': ('240', '128', '128')}},
	{'indianred': {'hex': '#CD5C5C', 'rgb': ('205', '92', '92')}},
	{'indianred 1': {'hex': '#FF6A6A', 'rgb': ('255', '106', '106')}},
	{'indianred 2': {'hex': '#EE6363', 'rgb': ('238', '99', '99')}},
	{'indianred 4': {'hex': '#8B3A3A', 'rgb': ('139', '58', '58')}},
	{'indianred 3': {'hex': '#CD5555', 'rgb': ('205', '85', '85')}},
	{'brown': {'hex': '#A52A2A', 'rgb': ('165', '42', '42')}},
	{'brown 1': {'hex': '#FF4040', 'rgb': ('255', '64', '64')}},
	{'brown 2': {'hex': '#EE3B3B', 'rgb': ('238', '59', '59')}},
	{'brown 3': {'hex': '#CD3333', 'rgb': ('205', '51', '51')}},
	{'brown 4': {'hex': '#8B2323', 'rgb': ('139', '35', '35')}},
	{'firebrick': {'hex': '#B22222', 'rgb': ('178', '34', '34')}},
	{'firebrick 1': {'hex': '#FF3030', 'rgb': ('255', '48', '48')}},
	{'firebrick 2': {'hex': '#EE2C2C', 'rgb': ('238', '44', '44')}},
	{'firebrick 3': {'hex': '#CD2626', 'rgb': ('205', '38', '38')}},
	{'firebrick 4': {'hex': '#8B1A1A', 'rgb': ('139', '26', '26')}},
	{'red 1 (red)': {'hex': '#FF0000', 'rgb': ('255', '0', '0')}},
	{'red 2': {'hex': '#EE0000', 'rgb': ('238', '0', '0')}},
	{'red 3': {'hex': '#CD0000', 'rgb': ('205', '0', '0')}},
	{'red 4 (darkred)': {'hex': '#8B0000', 'rgb': ('139', '0', '0')}},
	{'maroon': {'hex': '#800000', 'rgb': ('128', '0', '0')}},
	{'sgi beet': {'hex': '#8E388E', 'rgb': ('142', '56', '142')}},
	{'sgi slateblue': {'hex': '#7171C6', 'rgb': ('113', '113', '198')}},
	{'sgi lightblue': {'hex': '#7D9EC0', 'rgb': ('125', '158', '192')}},
	{'sgi teal': {'hex': '#388E8E', 'rgb': ('56', '142', '142')}},
	{'sgi chartreuse': {'hex': '#71C671', 'rgb': ('113', '198', '113')}},
	{'sgi olivedrab': {'hex': '#8E8E38', 'rgb': ('142', '142', '56')}},
	{'sgi brightgray': {'hex': '#C5C1AA', 'rgb': ('197', '193', '170')}},
	{'sgi salmon': {'hex': '#C67171', 'rgb': ('198', '113', '113')}},
	{'sgi darkgray': {'hex': '#555555', 'rgb': ('85', '85', '85')}},
	{'sgi gray 12': {'hex': '#1E1E1E', 'rgb': ('30', '30', '30')}},
	{'sgi gray 16': {'hex': '#282828', 'rgb': ('40', '40', '40')}},
	{'sgi gray 32': {'hex': '#515151', 'rgb': ('81', '81', '81')}},
	{'sgi gray 36': {'hex': '#5B5B5B', 'rgb': ('91', '91', '91')}},
	{'sgi gray 52': {'hex': '#848484', 'rgb': ('132', '132', '132')}},
	{'sgi gray 56': {'hex': '#8E8E8E', 'rgb': ('142', '142', '142')}},
	{'sgi lightgray': {'hex': '#AAAAAA', 'rgb': ('170', '170', '170')}},
	{'sgi gray 72': {'hex': '#B7B7B7', 'rgb': ('183', '183', '183')}},
	{'sgi gray 76': {'hex': '#C1C1C1', 'rgb': ('193', '193', '193')}},
	{'sgi gray 92': {'hex': '#EAEAEA', 'rgb': ('234', '234', '234')}},
	{'sgi gray 96': {'hex': '#F4F4F4', 'rgb': ('244', '244', '244')}},
	{'white': {'hex': '#FFFFFF', 'rgb': ('255', '255', '255')}},
	{'white smoke (gray 96)': {'hex': '#F5F5F5', 'rgb': ('245', '245', '245')}},
	{'gainsboro': {'hex': '#DCDCDC', 'rgb': ('220', '220', '220')}},
	{'lightgrey': {'hex': '#D3D3D3', 'rgb': ('211', '211', '211')}},
	{'silver': {'hex': '#C0C0C0', 'rgb': ('192', '192', '192')}},
	{'darkgray': {'hex': '#A9A9A9', 'rgb': ('169', '169', '169')}},
	{'gray': {'hex': '#808080', 'rgb': ('128', '128', '128')}},
	{'dimgray (gray 42)': {'hex': '#696969', 'rgb': ('105', '105', '105')}},
	{'black': {'hex': '#000000', 'rgb': ('0', '0', '0')}},
	{'gray 99': {'hex': '#FCFCFC', 'rgb': ('252', '252', '252')}},
	{'gray 98': {'hex': '#FAFAFA', 'rgb': ('250', '250', '250')}},
	{'gray 97': {'hex': '#F7F7F7', 'rgb': ('247', '247', '247')}},
	{'white smoke (gray 96)': {'hex': '#F5F5F5', 'rgb': ('245', '245', '245')}},
	{'gray 95': {'hex': '#F2F2F2', 'rgb': ('242', '242', '242')}},
	{'gray 94': {'hex': '#F0F0F0', 'rgb': ('240', '240', '240')}},
	{'gray 93': {'hex': '#EDEDED', 'rgb': ('237', '237', '237')}},
	{'gray 92': {'hex': '#EBEBEB', 'rgb': ('235', '235', '235')}},
	{'gray 91': {'hex': '#E8E8E8', 'rgb': ('232', '232', '232')}},
	{'gray 90': {'hex': '#E5E5E5', 'rgb': ('229', '229', '229')}},
	{'gray 89': {'hex': '#E3E3E3', 'rgb': ('227', '227', '227')}},
	{'gray 88': {'hex': '#E0E0E0', 'rgb': ('224', '224', '224')}},
	{'gray 87': {'hex': '#DEDEDE', 'rgb': ('222', '222', '222')}},
	{'gray 86': {'hex': '#DBDBDB', 'rgb': ('219', '219', '219')}},
	{'gray 85': {'hex': '#D9D9D9', 'rgb': ('217', '217', '217')}},
	{'gray 84': {'hex': '#D6D6D6', 'rgb': ('214', '214', '214')}},
	{'gray 83': {'hex': '#D4D4D4', 'rgb': ('212', '212', '212')}},
	{'gray 82': {'hex': '#D1D1D1', 'rgb': ('209', '209', '209')}},
	{'gray 81': {'hex': '#CFCFCF', 'rgb': ('207', '207', '207')}},
	{'gray 80': {'hex': '#CCCCCC', 'rgb': ('204', '204', '204')}},
	{'gray 79': {'hex': '#C9C9C9', 'rgb': ('201', '201', '201')}},
	{'gray 78': {'hex': '#C7C7C7', 'rgb': ('199', '199', '199')}},
	{'gray 77': {'hex': '#C4C4C4', 'rgb': ('196', '196', '196')}},
	{'gray 76': {'hex': '#C2C2C2', 'rgb': ('194', '194', '194')}},
	{'gray 75': {'hex': '#BFBFBF', 'rgb': ('191', '191', '191')}},
	{'gray 74': {'hex': '#BDBDBD', 'rgb': ('189', '189', '189')}},
	{'gray 73': {'hex': '#BABABA', 'rgb': ('186', '186', '186')}},
	{'gray 72': {'hex': '#B8B8B8', 'rgb': ('184', '184', '184')}},
	{'gray 71': {'hex': '#B5B5B5', 'rgb': ('181', '181', '181')}},
	{'gray 70': {'hex': '#B3B3B3', 'rgb': ('179', '179', '179')}},
	{'gray 69': {'hex': '#B0B0B0', 'rgb': ('176', '176', '176')}},
	{'gray 68': {'hex': '#ADADAD', 'rgb': ('173', '173', '173')}},
	{'gray 67': {'hex': '#ABABAB', 'rgb': ('171', '171', '171')}},
	{'gray 66': {'hex': '#A8A8A8', 'rgb': ('168', '168', '168')}},
	{'gray 65': {'hex': '#A6A6A6', 'rgb': ('166', '166', '166')}},
	{'gray 64': {'hex': '#A3A3A3', 'rgb': ('163', '163', '163')}},
	{'gray 63': {'hex': '#A1A1A1', 'rgb': ('161', '161', '161')}},
	{'gray 62': {'hex': '#9E9E9E', 'rgb': ('158', '158', '158')}},
	{'gray 61': {'hex': '#9C9C9C', 'rgb': ('156', '156', '156')}},
	{'gray 60': {'hex': '#999999', 'rgb': ('153', '153', '153')}},
	{'gray 59': {'hex': '#969696', 'rgb': ('150', '150', '150')}},
	{'gray 58': {'hex': '#949494', 'rgb': ('148', '148', '148')}},
	{'gray 57': {'hex': '#919191', 'rgb': ('145', '145', '145')}},
	{'gray 56': {'hex': '#8F8F8F', 'rgb': ('143', '143', '143')}},
	{'gray 55': {'hex': '#8C8C8C', 'rgb': ('140', '140', '140')}},
	{'gray 54': {'hex': '#8A8A8A', 'rgb': ('138', '138', '138')}},
	{'gray 53': {'hex': '#878787', 'rgb': ('135', '135', '135')}},
	{'gray 52': {'hex': '#858585', 'rgb': ('133', '133', '133')}},
	{'gray 51': {'hex': '#828282', 'rgb': ('130', '130', '130')}},
	{'gray 50': {'hex': '#7F7F7F', 'rgb': ('127', '127', '127')}},
	{'gray 49': {'hex': '#7D7D7D', 'rgb': ('125', '125', '125')}},
	{'gray 48': {'hex': '#7A7A7A', 'rgb': ('122', '122', '122')}},
	{'gray 47': {'hex': '#787878', 'rgb': ('120', '120', '120')}},
	{'gray 46': {'hex': '#757575', 'rgb': ('117', '117', '117')}},
	{'gray 45': {'hex': '#737373', 'rgb': ('115', '115', '115')}},
	{'gray 44': {'hex': '#707070', 'rgb': ('112', '112', '112')}},
	{'gray 43': {'hex': '#6E6E6E', 'rgb': ('110', '110', '110')}},
	{'gray 42': {'hex': '#6B6B6B', 'rgb': ('107', '107', '107')}},
	{'dimgray (gray 42)': {'hex': '#696969', 'rgb': ('105', '105', '105')}},
	{'gray 40': {'hex': '#666666', 'rgb': ('102', '102', '102')}},
	{'gray 39': {'hex': '#636363', 'rgb': ('99', '99', '99')}},
	{'gray 38': {'hex': '#616161', 'rgb': ('97', '97', '97')}},
	{'gray 37': {'hex': '#5E5E5E', 'rgb': ('94', '94', '94')}},
	{'gray 36': {'hex': '#5C5C5C', 'rgb': ('92', '92', '92')}},
	{'gray 35': {'hex': '#595959', 'rgb': ('89', '89', '89')}},
	{'gray 34': {'hex': '#575757', 'rgb': ('87', '87', '87')}},
	{'gray 33': {'hex': '#545454', 'rgb': ('84', '84', '84')}},
	{'gray 32': {'hex': '#525252', 'rgb': ('82', '82', '82')}},
	{'gray 31': {'hex': '#4F4F4F', 'rgb': ('79', '79', '79')}},
	{'gray 30': {'hex': '#4D4D4D', 'rgb': ('77', '77', '77')}},
	{'gray 29': {'hex': '#4A4A4A', 'rgb': ('74', '74', '74')}},
	{'gray 28': {'hex': '#474747', 'rgb': ('71', '71', '71')}},
	{'gray 27': {'hex': '#454545', 'rgb': ('69', '69', '69')}},
	{'gray 26': {'hex': '#424242', 'rgb': ('66', '66', '66')}},
	{'gray 25': {'hex': '#404040', 'rgb': ('64', '64', '64')}},
	{'gray 24': {'hex': '#3D3D3D', 'rgb': ('61', '61', '61')}},
	{'gray 23': {'hex': '#3B3B3B', 'rgb': ('59', '59', '59')}},
	{'gray 22': {'hex': '#383838', 'rgb': ('56', '56', '56')}},
	{'gray 21': {'hex': '#363636', 'rgb': ('54', '54', '54')}},
	{'gray 20': {'hex': '#333333', 'rgb': ('51', '51', '51')}},
	{'gray 19': {'hex': '#303030', 'rgb': ('48', '48', '48')}},
	{'gray 18': {'hex': '#2E2E2E', 'rgb': ('46', '46', '46')}},
	{'gray 17': {'hex': '#2B2B2B', 'rgb': ('43', '43', '43')}},
	{'gray 16': {'hex': '#292929', 'rgb': ('41', '41', '41')}},
	{'gray 15': {'hex': '#262626', 'rgb': ('38', '38', '38')}},
	{'gray 14': {'hex': '#242424', 'rgb': ('36', '36', '36')}},
	{'gray 13': {'hex': '#212121', 'rgb': ('33', '33', '33')}},
	{'gray 12': {'hex': '#1F1F1F', 'rgb': ('31', '31', '31')}},
	{'gray 11': {'hex': '#1C1C1C', 'rgb': ('28', '28', '28')}},
	{'gray 10': {'hex': '#1A1A1A', 'rgb': ('26', '26', '26')}},
	{'gray 9': {'hex': '#171717', 'rgb': ('23', '23', '23')}},
	{'gray 8': {'hex': '#141414', 'rgb': ('20', '20', '20')}},
	{'gray 7': {'hex': '#121212', 'rgb': ('18', '18', '18')}},
	{'gray 6': {'hex': '#0F0F0F', 'rgb': ('15', '15', '15')}},
	{'gray 5': {'hex': '#0D0D0D', 'rgb': ('13', '13', '13')}},
	{'gray 4': {'hex': '#0A0A0A', 'rgb': ('10', '10', '10')}},
	{'gray 3': {'hex': '#080808', 'rgb': ('8', '8', '8')}},
	{'gray 2': {'hex': '#050505', 'rgb': ('5', '5', '5')}},
	{'gray 1': {'hex': '#030303', 'rgb': ('3', '3', '3')}},
)

named_colors = (
	{'lightpink': {'hex': '#FFB6C1', 'rgb': ('255', '182', '193')}},
	{'pink': {'hex': '#FFC0CB', 'rgb': ('255', '192', '203')}},
	{'crimson': {'hex': '#DC143C', 'rgb': ('220', '20', '60')}},
	{'lavenderblush': {'hex': '#FFF0F5', 'rgb': ('255', '240', '245')}},
	{'palevioletred': {'hex': '#DB7093', 'rgb': ('219', '112', '147')}},
	{'hotpink': {'hex': '#FF69B4', 'rgb': ('255', '105', '180')}},
	{'deeppink': {'hex': '#FF1493', 'rgb': ('255', '20', '147')}},
	{'mediumvioletred': {'hex': '#C71585', 'rgb': ('199', '21', '133')}},
	{'orchid': {'hex': '#DA70D6', 'rgb': ('218', '112', '214')}},
	{'thistle': {'hex': '#D8BFD8', 'rgb': ('216', '191', '216')}},
	{'plum': {'hex': '#DDA0DD', 'rgb': ('221', '160', '221')}},
	{'violet': {'hex': '#EE82EE', 'rgb': ('238', '130', '238')}},
	{'fuchsia': {'hex': '#FF00FF', 'rgb': ('255', '0', '255')}},
	{'fuchsia': {'hex': '#FF00FF', 'rgb': ('255', '0', '255')}},
	{'darkmagenta': {'hex': '#8B008B', 'rgb': ('139', '0', '139')}},
	{'purple': {'hex': '#800080', 'rgb': ('128', '0', '128')}},
	{'mediumorchid': {'hex': '#BA55D3', 'rgb': ('186', '85', '211')}},
	{'darkviolet': {'hex': '#9400D3', 'rgb': ('148', '0', '211')}},
	{'darkorchid': {'hex': '#9932CC', 'rgb': ('153', '50', '204')}},
	{'indigo': {'hex': '#4B0082', 'rgb': ('75', '0', '130')}},
	{'blueviolet': {'hex': '#8A2BE2', 'rgb': ('138', '43', '226')}},
	{'mediumpurple': {'hex': '#9370DB', 'rgb': ('147', '112', '219')}},
	{'mediumslateblue': {'hex': '#7B68EE', 'rgb': ('123', '104', '238')}},
	{'slateblue': {'hex': '#6A5ACD', 'rgb': ('106', '90', '205')}},
	{'darkslateblue': {'hex': '#483D8B', 'rgb': ('72', '61', '139')}},
	{'ghostwhite': {'hex': '#F8F8FF', 'rgb': ('248', '248', '255')}},
	{'lavender': {'hex': '#E6E6FA', 'rgb': ('230', '230', '250')}},
	{'blue': {'hex': '#0000FF', 'rgb': ('0', '0', '255')}},
	{'mediumblue': {'hex': '#0000CD', 'rgb': ('0', '0', '205')}},
	{'darkblue': {'hex': '#00008B', 'rgb': ('0', '0', '139')}},
	{'navy': {'hex': '#000080', 'rgb': ('0', '0', '128')}},
	{'midnightblue': {'hex': '#191970', 'rgb': ('25', '25', '112')}},
	{'royalblue': {'hex': '#4169E1', 'rgb': ('65', '105', '225')}},
	{'cornflowerblue': {'hex': '#6495ED', 'rgb': ('100', '149', '237')}},
	{'lightsteelblue': {'hex': '#B0C4DE', 'rgb': ('176', '196', '222')}},
	{'lightslategray': {'hex': '#778899', 'rgb': ('119', '136', '153')}},
	{'slategray': {'hex': '#708090', 'rgb': ('112', '128', '144')}},
	{'dodgerblue': {'hex': '#1E90FF', 'rgb': ('30', '144', '255')}},
	{'aliceblue': {'hex': '#F0F8FF', 'rgb': ('240', '248', '255')}},
	{'steelblue': {'hex': '#4682B4', 'rgb': ('70', '130', '180')}},
	{'lightskyblue': {'hex': '#87CEFA', 'rgb': ('135', '206', '250')}},
	{'skyblue': {'hex': '#87CEEB', 'rgb': ('135', '206', '235')}},
	{'deepskyblue': {'hex': '#00BFFF', 'rgb': ('0', '191', '255')}},
	{'lightblue': {'hex': '#ADD8E6', 'rgb': ('173', '216', '230')}},
	{'powderblue': {'hex': '#B0E0E6', 'rgb': ('176', '224', '230')}},
	{'cadetblue': {'hex': '#5F9EA0', 'rgb': ('95', '158', '160')}},
	{'darkturquoise': {'hex': '#00CED1', 'rgb': ('0', '206', '209')}},
	{'azure': {'hex': '#F0FFFF', 'rgb': ('240', '255', '255')}},
	{'lightcyan': {'hex': '#E0FFFF', 'rgb': ('224', '255', '255')}},
	{'paleturquoise': {'hex': '#AFEEEE', 'rgb': ('175', '238', '238')}},
	{'aqua': {'hex': '#00FFFF', 'rgb': ('0', '255', '255')}},
	{'aqua': {'hex': '#00FFFF', 'rgb': ('0', '255', '255')}},
	{'darkcyan': {'hex': '#008B8B', 'rgb': ('0', '139', '139')}},
	{'teal': {'hex': '#008080', 'rgb': ('0', '128', '128')}},
	{'darkslategray': {'hex': '#2F4F4F', 'rgb': ('47', '79', '79')}},
	{'mediumturquoise': {'hex': '#48D1CC', 'rgb': ('72', '209', '204')}},
	{'lightseagreen': {'hex': '#20B2AA', 'rgb': ('32', '178', '170')}},
	{'turquoise': {'hex': '#40E0D0', 'rgb': ('64', '224', '208')}},
	{'aquamarine': {'hex': '#7FFFD4', 'rgb': ('127', '255', '212')}},
	{'mediumaquamarine': {'hex': '#66CDAA', 'rgb': ('102', '205', '170')}},
	{'mediumspringgreen': {'hex': '#00FA9A', 'rgb': ('0', '250', '154')}},
	{'mintcream': {'hex': '#F5FFFA', 'rgb': ('245', '255', '250')}},
	{'springgreen': {'hex': '#00FF7F', 'rgb': ('0', '255', '127')}},
	{'mediumseagreen': {'hex': '#3CB371', 'rgb': ('60', '179', '113')}},
	{'seagreen': {'hex': '#2E8B57', 'rgb': ('46', '139', '87')}},
	{'honeydew': {'hex': '#F0FFF0', 'rgb': ('240', '255', '240')}},
	{'darkseagreen': {'hex': '#8FBC8F', 'rgb': ('143', '188', '143')}},
	{'palegreen': {'hex': '#98FB98', 'rgb': ('152', '251', '152')}},
	{'lightgreen': {'hex': '#90EE90', 'rgb': ('144', '238', '144')}},
	{'limegreen': {'hex': '#32CD32', 'rgb': ('50', '205', '50')}},
	{'lime': {'hex': '#00FF00', 'rgb': ('0', '255', '0')}},
	{'forestgreen': {'hex': '#228B22', 'rgb': ('34', '139', '34')}},
	{'green': {'hex': '#008000', 'rgb': ('0', '128', '0')}},
	{'darkgreen': {'hex': '#006400', 'rgb': ('0', '100', '0')}},
	{'lawngreen': {'hex': '#7CFC00', 'rgb': ('124', '252', '0')}},
	{'chartreuse': {'hex': '#7FFF00', 'rgb': ('127', '255', '0')}},
	{'greenyellow': {'hex': '#ADFF2F', 'rgb': ('173', '255', '47')}},
	{'darkolivegreen': {'hex': '#556B2F', 'rgb': ('85', '107', '47')}},
	{'yellowgreen': {'hex': '#9ACD32', 'rgb': ('154', '205', '50')}},
	{'olivedrab': {'hex': '#6B8E23', 'rgb': ('107', '142', '35')}},
	{'ivory': {'hex': '#FFFFF0', 'rgb': ('255', '255', '240')}},
	{'beige': {'hex': '#F5F5DC', 'rgb': ('245', '245', '220')}},
	{'lightyellow': {'hex': '#FFFFE0', 'rgb': ('255', '255', '224')}},
	{'lightgoldenrodyellow': {'hex': '#FAFAD2', 'rgb': ('250', '250', '210')}},
	{'yellow': {'hex': '#FFFF00', 'rgb': ('255', '255', '0')}},
	{'olive': {'hex': '#808000', 'rgb': ('128', '128', '0')}},
	{'darkkhaki': {'hex': '#BDB76B', 'rgb': ('189', '183', '107')}},
	{'palegoldenrod': {'hex': '#EEE8AA', 'rgb': ('238', '232', '170')}},
	{'lemonchiffon': {'hex': '#FFFACD', 'rgb': ('255', '250', '205')}},
	{'khaki': {'hex': '#F0E68C', 'rgb': ('240', '230', '140')}},
	{'gold': {'hex': '#FFD700', 'rgb': ('255', '215', '0')}},
	{'cornsilk': {'hex': '#FFF8DC', 'rgb': ('255', '248', '220')}},
	{'goldenrod': {'hex': '#DAA520', 'rgb': ('218', '165', '32')}},
	{'darkgoldenrod': {'hex': '#B8860B', 'rgb': ('184', '134', '11')}},
	{'floralwhite': {'hex': '#FFFAF0', 'rgb': ('255', '250', '240')}},
	{'oldlace': {'hex': '#FDF5E6', 'rgb': ('253', '245', '230')}},
	{'wheat': {'hex': '#F5DEB3', 'rgb': ('245', '222', '179')}},
	{'orange': {'hex': '#FFA500', 'rgb': ('255', '165', '0')}},
	{'moccasin': {'hex': '#FFE4B5', 'rgb': ('255', '228', '181')}},
	{'papayawhip': {'hex': '#FFEFD5', 'rgb': ('255', '239', '213')}},
	{'blanchedalmond': {'hex': '#FFEBCD', 'rgb': ('255', '235', '205')}},
	{'navajowhite': {'hex': '#FFDEAD', 'rgb': ('255', '222', '173')}},
	{'antiquewhite': {'hex': '#FAEBD7', 'rgb': ('250', '235', '215')}},
	{'tan': {'hex': '#D2B48C', 'rgb': ('210', '180', '140')}},
	{'burlywood': {'hex': '#DEB887', 'rgb': ('222', '184', '135')}},
	{'darkorange': {'hex': '#FF8C00', 'rgb': ('255', '140', '0')}},
	{'bisque': {'hex': '#FFE4C4', 'rgb': ('255', '228', '196')}},
	{'linen': {'hex': '#FAF0E6', 'rgb': ('250', '240', '230')}},
	{'peru': {'hex': '#CD853F', 'rgb': ('205', '133', '63')}},
	{'peachpuff': {'hex': '#FFDAB9', 'rgb': ('255', '218', '185')}},
	{'sandybrown': {'hex': '#F4A460', 'rgb': ('244', '164', '96')}},
	{'chocolate': {'hex': '#D2691E', 'rgb': ('210', '105', '30')}},
	{'saddlebrown': {'hex': '#8B4513', 'rgb': ('139', '69', '19')}},
	{'seashell': {'hex': '#FFF5EE', 'rgb': ('255', '245', '238')}},
	{'sienna': {'hex': '#A0522D', 'rgb': ('160', '82', '45')}},
	{'lightsalmon': {'hex': '#FFA07A', 'rgb': ('255', '160', '122')}},
	{'coral': {'hex': '#FF7F50', 'rgb': ('255', '127', '80')}},
	{'orangered': {'hex': '#FF4500', 'rgb': ('255', '69', '0')}},
	{'darksalmon': {'hex': '#E9967A', 'rgb': ('233', '150', '122')}},
	{'tomato': {'hex': '#FF6347', 'rgb': ('255', '99', '71')}},
	{'salmon': {'hex': '#FA8072', 'rgb': ('250', '128', '114')}},
	{'mistyrose': {'hex': '#FFE4E1', 'rgb': ('255', '228', '225')}},
	{'lightcoral': {'hex': '#F08080', 'rgb': ('240', '128', '128')}},
	{'snow': {'hex': '#FFFAFA', 'rgb': ('255', '250', '250')}},
	{'rosybrown': {'hex': '#BC8F8F', 'rgb': ('188', '143', '143')}},
	{'indianred': {'hex': '#CD5C5C', 'rgb': ('205', '92', '92')}},
	{'red': {'hex': '#FF0000', 'rgb': ('255', '0', '0')}},
	{'brown': {'hex': '#A52A2A', 'rgb': ('165', '42', '42')}},
	{'firebrick': {'hex': '#B22222', 'rgb': ('178', '34', '34')}},
	{'darkred': {'hex': '#8B0000', 'rgb': ('139', '0', '0')}},
	{'maroon': {'hex': '#800000', 'rgb': ('128', '0', '0')}},
	{'white': {'hex': '#FFFFFF', 'rgb': ('255', '255', '255')}},
	{'whitesmoke': {'hex': '#F5F5F5', 'rgb': ('245', '245', '245')}},
	{'gainsboro': {'hex': '#DCDCDC', 'rgb': ('220', '220', '220')}},
	{'lightgrey': {'hex': '#D3D3D3', 'rgb': ('211', '211', '211')}},
	{'silver': {'hex': '#C0C0C0', 'rgb': ('192', '192', '192')}},
	{'darkgray': {'hex': '#A9A9A9', 'rgb': ('169', '169', '169')}},
	{'gray': {'hex': '#808080', 'rgb': ('128', '128', '128')}},
	{'dimgray': {'hex': '#696969', 'rgb': ('105', '105', '105')}},
	{'black': {'hex': '#000000', 'rgb': ('0', '0', '0')}},
)

hue_color = (
	{'hex': '#993366', 'rgb': ('153', '51', '102')},
	{'hex': '#CC6699', 'rgb': ('204', '102', '153')},
	{'hex': '#FF99CC', 'rgb': ('255', '153', '204')},
	{'hex': '#FF0099', 'rgb': ('255', '0', '153')},
	{'hex': '#990066', 'rgb': ('153', '0', '102')},
	{'hex': '#CC3399', 'rgb': ('204', '51', '153')},
	{'hex': '#FF66CC', 'rgb': ('255', '102', '204')},
	{'hex': '#CC0099', 'rgb': ('204', '0', '153')},
	{'hex': '#FF33CC', 'rgb': ('255', '51', '204')},
	{'hex': '#FF00CC', 'rgb': ('255', '0', '204')},
	{'hex': '#FF00FF', 'rgb': ('255', '0', '255')},
	{'hex': '#CC00CC', 'rgb': ('204', '0', '204')},
	{'hex': '#FF33FF', 'rgb': ('255', '51', '255')},
	{'hex': '#990099', 'rgb': ('153', '0', '153')},
	{'hex': '#CC33CC', 'rgb': ('204', '51', '204')},
	{'hex': '#FF66FF', 'rgb': ('255', '102', '255')},
	{'hex': '#660066', 'rgb': ('102', '0', '102')},
	{'hex': '#993399', 'rgb': ('153', '51', '153')},
	{'hex': '#CC66CC', 'rgb': ('204', '102', '204')},
	{'hex': '#FF99FF', 'rgb': ('255', '153', '255')},
	{'hex': '#330033', 'rgb': ('51', '0', '51')},
	{'hex': '#663366', 'rgb': ('102', '51', '102')},
	{'hex': '#996699', 'rgb': ('153', '102', '153')},
	{'hex': '#CC99CC', 'rgb': ('204', '153', '204')},
	{'hex': '#FFCCFF', 'rgb': ('255', '204', '255')},
	{'hex': '#CC00FF', 'rgb': ('204', '0', '255')},
	{'hex': '#9900CC', 'rgb': ('153', '0', '204')},
	{'hex': '#CC33FF', 'rgb': ('204', '51', '255')},
	{'hex': '#660099', 'rgb': ('102', '0', '153')},
	{'hex': '#9933CC', 'rgb': ('153', '51', '204')},
	{'hex': '#CC66FF', 'rgb': ('204', '102', '255')},
	{'hex': '#9900FF', 'rgb': ('153', '0', '255')},
	{'hex': '#330066', 'rgb': ('51', '0', '102')},
	{'hex': '#663399', 'rgb': ('102', '51', '153')},
	{'hex': '#9966CC', 'rgb': ('153', '102', '204')},
	{'hex': '#CC99FF', 'rgb': ('204', '153', '255')},
	{'hex': '#6600CC', 'rgb': ('102', '0', '204')},
	{'hex': '#9933FF', 'rgb': ('153', '51', '255')},
	{'hex': '#6600FF', 'rgb': ('102', '0', '255')},
	{'hex': '#330099', 'rgb': ('51', '0', '153')},
	{'hex': '#6633CC', 'rgb': ('102', '51', '204')},
	{'hex': '#9966FF', 'rgb': ('153', '102', '255')},
	{'hex': '#3300CC', 'rgb': ('51', '0', '204')},
	{'hex': '#6633FF', 'rgb': ('102', '51', '255')},
	{'hex': '#3300FF', 'rgb': ('51', '0', '255')},
	{'hex': '#0000FF', 'rgb': ('0', '0', '255')},
	{'hex': '#0000CC', 'rgb': ('0', '0', '204')},
	{'hex': '#000099', 'rgb': ('0', '0', '153')},
	{'hex': '#000066', 'rgb': ('0', '0', '102')},
	{'hex': '#000033', 'rgb': ('0', '0', '51')},
	{'hex': '#3333FF', 'rgb': ('51', '51', '255')},
	{'hex': '#3333CC', 'rgb': ('51', '51', '204')},
	{'hex': '#333399', 'rgb': ('51', '51', '153')},
	{'hex': '#333366', 'rgb': ('51', '51', '102')},
	{'hex': '#6666FF', 'rgb': ('102', '102', '255')},
	{'hex': '#6666CC', 'rgb': ('102', '102', '204')},
	{'hex': '#666699', 'rgb': ('102', '102', '153')},
	{'hex': '#9999FF', 'rgb': ('153', '153', '255')},
	{'hex': '#9999CC', 'rgb': ('153', '153', '204')},
	{'hex': '#CCCCFF', 'rgb': ('204', '204', '255')},
	{'hex': '#0033FF', 'rgb': ('0', '51', '255')},
	{'hex': '#0033CC', 'rgb': ('0', '51', '204')},
	{'hex': '#3366FF', 'rgb': ('51', '102', '255')},
	{'hex': '#003399', 'rgb': ('0', '51', '153')},
	{'hex': '#3366CC', 'rgb': ('51', '102', '204')},
	{'hex': '#6699FF', 'rgb': ('102', '153', '255')},
	{'hex': '#0066FF', 'rgb': ('0', '102', '255')},
	{'hex': '#0066CC', 'rgb': ('0', '102', '204')},
	{'hex': '#3399FF', 'rgb': ('51', '153', '255')},
	{'hex': '#003366', 'rgb': ('0', '51', '102')},
	{'hex': '#336699', 'rgb': ('51', '102', '153')},
	{'hex': '#6699CC', 'rgb': ('102', '153', '204')},
	{'hex': '#99CCFF', 'rgb': ('153', '204', '255')},
	{'hex': '#0099FF', 'rgb': ('0', '153', '255')},
	{'hex': '#006699', 'rgb': ('0', '102', '153')},
	{'hex': '#3399CC', 'rgb': ('51', '153', '204')},
	{'hex': '#66CCFF', 'rgb': ('102', '204', '255')},
	{'hex': '#0099CC', 'rgb': ('0', '153', '204')},
	{'hex': '#33CCFF', 'rgb': ('51', '204', '255')},
	{'hex': '#00CCFF', 'rgb': ('0', '204', '255')},
	{'hex': '#00FFFF', 'rgb': ('0', '255', '255')},
	{'hex': '#00CCCC', 'rgb': ('0', '204', '204')},
	{'hex': '#009999', 'rgb': ('0', '153', '153')},
	{'hex': '#006666', 'rgb': ('0', '102', '102')},
	{'hex': '#003333', 'rgb': ('0', '51', '51')},
	{'hex': '#33FFFF', 'rgb': ('51', '255', '255')},
	{'hex': '#33CCCC', 'rgb': ('51', '204', '204')},
	{'hex': '#339999', 'rgb': ('51', '153', '153')},
	{'hex': '#336666', 'rgb': ('51', '102', '102')},
	{'hex': '#66FFFF', 'rgb': ('102', '255', '255')},
	{'hex': '#66CCCC', 'rgb': ('102', '204', '204')},
	{'hex': '#669999', 'rgb': ('102', '153', '153')},
	{'hex': '#99FFFF', 'rgb': ('153', '255', '255')},
	{'hex': '#99CCCC', 'rgb': ('153', '204', '204')},
	{'hex': '#CCFFFF', 'rgb': ('204', '255', '255')},
	{'hex': '#00FFCC', 'rgb': ('0', '255', '204')},
	{'hex': '#00CC99', 'rgb': ('0', '204', '153')},
	{'hex': '#33FFCC', 'rgb': ('51', '255', '204')},
	{'hex': '#009966', 'rgb': ('0', '153', '102')},
	{'hex': '#33CC99', 'rgb': ('51', '204', '153')},
	{'hex': '#66FFCC', 'rgb': ('102', '255', '204')},
	{'hex': '#00FF99', 'rgb': ('0', '255', '153')},
	{'hex': '#006633', 'rgb': ('0', '102', '51')},
	{'hex': '#339966', 'rgb': ('51', '153', '102')},
	{'hex': '#66CC99', 'rgb': ('102', '204', '153')},
	{'hex': '#99FFCC', 'rgb': ('153', '255', '204')},
	{'hex': '#00CC66', 'rgb': ('0', '204', '102')},
	{'hex': '#33FF99', 'rgb': ('51', '255', '153')},
	{'hex': '#00FF66', 'rgb': ('0', '255', '102')},
	{'hex': '#009933', 'rgb': ('0', '153', '51')},
	{'hex': '#33CC66', 'rgb': ('51', '204', '102')},
	{'hex': '#66FF99', 'rgb': ('102', '255', '153')},
	{'hex': '#00CC33', 'rgb': ('0', '204', '51')},
	{'hex': '#33FF66', 'rgb': ('51', '255', '102')},
	{'hex': '#00FF33', 'rgb': ('0', '255', '51')},
	{'hex': '#00FF00', 'rgb': ('0', '255', '0')},
	{'hex': '#00CC00', 'rgb': ('0', '204', '0')},
	{'hex': '#009900', 'rgb': ('0', '153', '0')},
	{'hex': '#006600', 'rgb': ('0', '102', '0')},
	{'hex': '#003300', 'rgb': ('0', '51', '0')},
	{'hex': '#33FF33', 'rgb': ('51', '255', '51')},
	{'hex': '#33CC33', 'rgb': ('51', '204', '51')},
	{'hex': '#339933', 'rgb': ('51', '153', '51')},
	{'hex': '#336633', 'rgb': ('51', '102', '51')},
	{'hex': '#66FF66', 'rgb': ('102', '255', '102')},
	{'hex': '#66CC66', 'rgb': ('102', '204', '102')},
	{'hex': '#669966', 'rgb': ('102', '153', '102')},
	{'hex': '#99FF99', 'rgb': ('153', '255', '153')},
	{'hex': '#99CC99', 'rgb': ('153', '204', '153')},
	{'hex': '#CCFFCC', 'rgb': ('204', '255', '204')},
	{'hex': '#33FF00', 'rgb': ('51', '255', '0')},
	{'hex': '#33CC00', 'rgb': ('51', '204', '0')},
	{'hex': '#66FF33', 'rgb': ('102', '255', '51')},
	{'hex': '#339900', 'rgb': ('51', '153', '0')},
	{'hex': '#66CC33', 'rgb': ('102', '204', '51')},
	{'hex': '#99FF66', 'rgb': ('153', '255', '102')},
	{'hex': '#66FF00', 'rgb': ('102', '255', '0')},
	{'hex': '#66CC00', 'rgb': ('102', '204', '0')},
	{'hex': '#99FF33', 'rgb': ('153', '255', '51')},
	{'hex': '#336600', 'rgb': ('51', '102', '0')},
	{'hex': '#669933', 'rgb': ('102', '153', '51')},
	{'hex': '#99CC66', 'rgb': ('153', '204', '102')},
	{'hex': '#CCFF99', 'rgb': ('204', '255', '153')},
	{'hex': '#99FF00', 'rgb': ('153', '255', '0')},
	{'hex': '#669900', 'rgb': ('102', '153', '0')},
	{'hex': '#99CC33', 'rgb': ('153', '204', '51')},
	{'hex': '#CCFF66', 'rgb': ('204', '255', '102')},
	{'hex': '#99CC00', 'rgb': ('153', '204', '0')},
	{'hex': '#CCFF33', 'rgb': ('204', '255', '51')},
	{'hex': '#CCFF00', 'rgb': ('204', '255', '0')},
	{'hex': '#FFFF00', 'rgb': ('255', '255', '0')},
	{'hex': '#CCCC00', 'rgb': ('204', '204', '0')},
	{'hex': '#999900', 'rgb': ('153', '153', '0')},
	{'hex': '#666600', 'rgb': ('102', '102', '0')},
	{'hex': '#333300', 'rgb': ('51', '51', '0')},
	{'hex': '#FFFF33', 'rgb': ('255', '255', '51')},
	{'hex': '#CCCC33', 'rgb': ('204', '204', '51')},
	{'hex': '#999933', 'rgb': ('153', '153', '51')},
	{'hex': '#666633', 'rgb': ('102', '102', '51')},
	{'hex': '#FFFF66', 'rgb': ('255', '255', '102')},
	{'hex': '#CCCC66', 'rgb': ('204', '204', '102')},
	{'hex': '#999966', 'rgb': ('153', '153', '102')},
	{'hex': '#FFFF99', 'rgb': ('255', '255', '153')},
	{'hex': '#CCCC99', 'rgb': ('204', '204', '153')},
	{'hex': '#FFFFCC', 'rgb': ('255', '255', '204')},
	{'hex': '#FFCC00', 'rgb': ('255', '204', '0')},
	{'hex': '#CC9900', 'rgb': ('204', '153', '0')},
	{'hex': '#FFCC33', 'rgb': ('255', '204', '51')},
	{'hex': '#996600', 'rgb': ('153', '102', '0')},
	{'hex': '#CC9933', 'rgb': ('204', '153', '51')},
	{'hex': '#FFCC66', 'rgb': ('255', '204', '102')},
	{'hex': '#FF9900', 'rgb': ('255', '153', '0')},
	{'hex': '#663300', 'rgb': ('102', '51', '0')},
	{'hex': '#996633', 'rgb': ('153', '102', '51')},
	{'hex': '#CC9966', 'rgb': ('204', '153', '102')},
	{'hex': '#FFCC99', 'rgb': ('255', '204', '153')},
	{'hex': '#CC6600', 'rgb': ('204', '102', '0')},
	{'hex': '#FF9933', 'rgb': ('255', '153', '51')},
	{'hex': '#FF6600', 'rgb': ('255', '102', '0')},
	{'hex': '#993300', 'rgb': ('153', '51', '0')},
	{'hex': '#CC6633', 'rgb': ('204', '102', '51')},
	{'hex': '#FF9966', 'rgb': ('255', '153', '102')},
	{'hex': '#CC3300', 'rgb': ('204', '51', '0')},
	{'hex': '#FF6633', 'rgb': ('255', '102', '51')},
	{'hex': '#FF3300', 'rgb': ('255', '51', '0')},
	{'hex': '#FF0000', 'rgb': ('255', '0', '0')},
	{'hex': '#CC0000', 'rgb': ('204', '0', '0')},
	{'hex': '#990000', 'rgb': ('153', '0', '0')},
	{'hex': '#660000', 'rgb': ('102', '0', '0')},
	{'hex': '#330000', 'rgb': ('51', '0', '0')},
	{'hex': '#FF3333', 'rgb': ('255', '51', '51')},
	{'hex': '#CC3333', 'rgb': ('204', '51', '51')},
	{'hex': '#993333', 'rgb': ('153', '51', '51')},
	{'hex': '#663333', 'rgb': ('102', '51', '51')},
	{'hex': '#FF6666', 'rgb': ('255', '102', '102')},
	{'hex': '#CC6666', 'rgb': ('204', '102', '102')},
	{'hex': '#996666', 'rgb': ('153', '102', '102')},
	{'hex': '#FF9999', 'rgb': ('255', '153', '153')},
	{'hex': '#CC9999', 'rgb': ('204', '153', '153')},
	{'hex': '#FFCCCC', 'rgb': ('255', '204', '204')},
	{'hex': '#FF0033', 'rgb': ('255', '0', '51')},
	{'hex': '#CC0033', 'rgb': ('204', '0', '51')},
	{'hex': '#FF3366', 'rgb': ('255', '51', '102')},
	{'hex': '#990033', 'rgb': ('153', '0', '51')},
	{'hex': '#CC3366', 'rgb': ('204', '51', '102')},
	{'hex': '#FF6699', 'rgb': ('255', '102', '153')},
	{'hex': '#FF0066', 'rgb': ('255', '0', '102')},
	{'hex': '#CC0066', 'rgb': ('204', '0', '102')},
	{'hex': '#FF3399', 'rgb': ('255', '51', '153')},
	{'hex': '#660033', 'rgb': ('102', '0', '51')},
	{'hex': '#FFFFFF', 'rgb': ('255', '255', '255')},
	{'hex': '#CCCCCC', 'rgb': ('204', '204', '204')},
	{'hex': '#999999', 'rgb': ('153', '153', '153')},
	{'hex': '#666666', 'rgb': ('102', '102', '102')},
	{'hex': '#333333', 'rgb': ('51', '51', '51')},
	{'hex': '#000000', 'rgb': ('0', '0', '0')},
)