# captcha_pc

Biblioteca com a finalidade de "quebrar" Captchas e reCaptchas.

É necessário ter uma conta DeathByCaptcha [https://www.deathbycaptcha.com/]

## Começando

Para utilizar a biblioteca é necessário:

- Python 3+
- Desinstalar a biblioteca "deathbycaptcha" (se estiver instalada): `pip uninstall deathbycaptcha`
- Instalar o pacote "captcha_pc": `pip install captcha-pc`

## Utilização

Essa biblioteca possui 2 métodos:

1. **resolver_captcha_tipo1**

Esse método é utilizado para "quebrar" Captchas onde se deve reconhecer caracteres em uma imagem.

<p align="center">
  <img src="imagens/115740paulista_captcha.jpeg" />
</p>
<p align="center">
  <img src="imagens/631544caxias_captcha.jpeg" />
</p>
<p align="center">
  <img src="imagens/959551sp_captcha.jpeg" />
</p>

| Variável | Tipo    | Exemplo                               | Descrição                                                                               |
| -------- | ------- | ------------------------------------- | --------------------------------------------------------------------------------------- |
| username | string  | "usuario.prime"                       | Usuário da conta DeathByCaptcha.                                                        |
| password | string  | "12345Ax.#dd"                         | Senha da conta DeathByCaptcha.                                                          |
| token    | string  | "asjdior76dgd092bsk"                  | Token gerado pela conta DeathByCaptcha.                                                 |
| imagem   | string  | "C:\Pasta_imagem\captcha_imagem.jpeg" | Caminho absoluto da imagem contendo os caracteres.                                      |
| timeout  | inteiro | 60                                    | Tempo máximo, em segundos, que a API utilizará para reconhecer os caracteres da imagem. |

- Python

```python
import captcha_pc

username = "<usário_da_conta>"
password = "<senha_da_conta>"
token = "<token_gerado_pela_conta>"
imagem = "<path_do_caminho_da_imagem>"

retorno_texto = captcha_pc.resolver_captcha_tipo1(username, password, token, imagem, 30)
# retorno_texto => caracteres reconhecidos na imagem
```

- Robot Framework

```Robot
Library   captcha_pc

${username}=  Set Variable  <usário_da_conta>
${password}=  Set Variable  <senha_da_conta>
${token}=  Set Variable  <token_gerado_pela_conta>
${imagem}=  Set Variable  <path_do_caminho_da_imagem>

${retorno_texto}   captcha_pc.Resolver Captcha Tipo1   ${username}   ${password}   ${token}   ${imagem}   ${30}
# ${retorno_texto} => caracteres reconhecidos na imagem

```

2. **resolver_captcha_tipo5**

Esse método é utilizado para "quebrar" reCaptchas.

<p align="center">
  <img src="imagens/recaptcha_imagem_2.PNG" />
</p>

| Variável | Tipo   | Exemplo                                                                              | Descrição                                                                                                                                 |
| -------- | ------ | ------------------------------------------------------------------------------------ | ----------------------------------------------------------------------------------------------------------------------------------------- |
| username | string | "usuario.prime"                                                                      | Usuário da conta DeathByCaptcha.                                                                                                          |
| password | string | "12345Ax.#dd"                                                                        | Senha da conta DeathByCaptcha.                                                                                                            |
| token    | string | "asjdior76dgd092bsk"                                                                 | Token gerado pela conta DeathByCaptcha.                                                                                                   |
| key      | string | "6LcT2zQUAAAAABRp8qIQR2R0Y2LWYTafR0A8WFbr"                                           | Data-sitekey da página alvo. Pode ser encontrada como primeiro argumento da função (javascript) "grecaptcha" inspecionando a página alvo. |
| pageurl  | string | "https://servicosweb.sefaz.salvador.ba.gov.br/IPTU_TL/servicos_DamIptuTL.asp?Tipo=D" | Url da página. Se o captcha estiver dentro de um _**iframe**_, verificar se o mesmo possui uma url específica.                            |
| action   | string | "social"                                                                             | Pode ser encontrada como segundo argumento da função (javascript) "grecaptcha" inspecionando a página alvo.                               |

- Python

```python
import captcha_pc

username = "<usário_da_conta>"
password = "<senha_da_conta>"
token = "<token_gerado_pela_conta>"
key = "<path_do_caminho_da_imagem>"
pageurl = "<path_do_caminho_da_imagem>"
action = "<path_do_caminho_da_imagem>"

retorno_token = captcha_pc.resolver_captcha_tipo5(username, password, token, key, pageurl, action)
# retorno_token => Token gerado pelo quebra reCaptcha
```

- Robot Framework

```Robot
Library   captcha_pc

${username}=  Set Variable  <usário_da_conta>
${password}=  Set Variable  <senha_da_conta>
${token}=  Set Variable  <token_gerado_pela_conta>
${imagem}=  Set Variable  <path_do_caminho_da_imagem>
${key} =  Set Variable   <path_do_caminho_da_imagem>
${pageurl} = Set Variable   <path_do_caminho_da_imagem>
${action} = Set Variable   <path_do_caminho_da_imagem>

${retorno_token}   captcha_pc.Resolver Captcha Tipo5   ${username}   ${password}   ${token}   ${key}   ${pageurl}   ${action}
# ${retorno_token} => Token gerado pelo quebra reCaptcha

```

Após capturado o token, o mesmo deve ser inserido no atributo **value** cujo id é _g-recaptcha-response_ da página alvo.

### CI/CD

Especificar TWINE_USERNAME and TWINE_PASSWORD
