# generated by datamodel-codegen:
#   filename:  <stdin>
#   timestamp: 2021-11-12T10:24:42+00:00

from __future__ import annotations

from typing import Optional

from pydantic import AnyUrl, BaseModel, Field


class OutOfStock(BaseModel):
    sku: str = Field(..., description="The over-allocated SKU.")
    quantity: int = Field(
        ..., description="The amount of over-allocation for this SKU."
    )


class PositiveSKUQuantity(BaseModel):
    sku: str = Field(..., description="Reference to the affected SKU.")
    quantity: int = Field(
        ..., description="The delta of the inventory adjustment.", ge=1.0
    )
    comment: Optional[str] = Field(
        None, description="A comment about the reason of the adjustment."
    )


class SKUQuantity(BaseModel):
    sku: str = Field(..., description="Reference to the affected SKU.")
    quantity: int = Field(..., description="The delta of the inventory adjustment.")
    comment: Optional[str] = Field(
        None, description="A comment about the reason of the adjustment."
    )


class Stock(BaseModel):
    sku: str = Field(..., description="The SKU regarding this stock quantity.")
    quantity: int = Field(..., description="The current stock quantity for this SKU.")


class PaginatedStockList(BaseModel):
    count: Optional[int] = Field(None, example=123)
    next: Optional[AnyUrl] = Field(
        None, example="http://api.example.org/accounts/?offset=400&limit=100"
    )
    previous: Optional[AnyUrl] = Field(
        None, example="http://api.example.org/accounts/?offset=200&limit=100"
    )
    results: Optional[list[Stock]] = None
