# coding: utf-8

"""
    Intrinio API

    Welcome to the Intrinio API! Through our Financial Data Marketplace, we offer a wide selection of financial data feed APIs sourced by our own proprietary processes as well as from many data vendors. For a complete API request / response reference please view the [Intrinio API documentation](https://intrinio.com/documentation/api_v2). If you need additional help in using the API, please visit the [Intrinio website](https://intrinio.com) and click on the chat icon in the lower right corner.  # noqa: E501

    OpenAPI spec version: 2.23.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six


class ETF(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'id': 'str',
        'name': 'str',
        'ticker': 'str',
        'figi_ticker': 'str',
        'ric': 'str',
        'isin': 'str',
        'sedol': 'str',
        'exchange_mic': 'str',
        'sponsor': 'str',
        'type': 'str',
        'description': 'str',
        'inception_date': 'date',
        'data_change_date': 'date',
        'close_date': 'date',
        'is_live_listed': 'bool',
        'legal_structure': 'str',
        'intraday_nav_ticker': 'str',
        'primary_ticker': 'str',
        'primary_ticker_country_code': 'str',
        'primary_listing_region': 'str',
        'net_expense_ratio': 'float',
        'asset_class': 'str',
        'other_asset_types': 'str',
        'market_cap_range': 'str',
        'holds_only_nyse_stocks': 'bool',
        'holds_only_nasdaq_stocks': 'bool',
        'growth_value_tilt': 'str',
        'growth_type': 'str',
        'value_type': 'str',
        'sector': 'str',
        'industry': 'str',
        'sub_industry': 'str',
        'cross_sector_theme': 'str',
        'natural_resources_type': 'str',
        'excludes_financials': 'bool',
        'excludes_technology': 'bool',
        'us_or_excludes_us': 'str',
        'developed_emerging': 'str',
        'specialized_region': 'str',
        'continent': 'str',
        'latin_america_sub_group': 'str',
        'europe_sub_group': 'str',
        'asia_sub_group': 'str',
        'specific_country': 'str',
        'china_listing_location': 'str',
        'us_state': 'str',
        'real_estate': 'str',
        'index_weighting_scheme': 'str',
        'market_cap_weighting_type': 'str',
        'fundamental_weighting_type': 'str',
        'dividend_weighting_type': 'str',
        'bond_type': 'str',
        'government_bond_types': 'str',
        'municipal_bond_region': 'str',
        'municipal_vrdo': 'bool',
        'mortgage_bond_types': 'str',
        'bond_tax_status': 'str',
        'credit_quality': 'str',
        'average_maturity': 'str',
        'specific_maturity_year': 'int',
        'bond_currency_denomination': 'str',
        'laddered': 'bool',
        'zero_coupon': 'bool',
        'floating_rate': 'bool',
        'build_america_bonds': 'bool',
        'commodity_types': 'str',
        'energy_type': 'str',
        'agricultural_type': 'str',
        'metal_type': 'str',
        'inverse_leveraged': 'str',
        'target_date_multi_asset_type': 'str',
        'currency_hedged': 'bool',
        'currency_pair': 'str',
        'social_environmental_type': 'str',
        'clean_energy_type': 'str',
        'dividend_type': 'str',
        'regular_dividend_payor_type': 'str',
        'holds_ml_ps': 'bool',
        'holds_preferred_stock': 'bool',
        'holds_closed_end_funds': 'bool',
        'quant_strategies_type': 'str',
        'other_quant_models': 'str',
        'hedge_fund_type': 'str',
        'derivatives_based': 'str',
        'holds_ad_rs': 'bool',
        'index_linked': 'str',
        'includes_short_exposure': 'bool',
        'index_name': 'str',
        'parent_index': 'str',
        'index_family': 'str',
        'broader_index_family': 'str',
        'index_provider': 'str',
        'fund_family': 'str',
        'index_ticker': 'str',
        'etn_issuing_bank': 'str',
        'etn_maturity_date': 'date',
        'livestock': 'str',
        'dynamic_futures_roll': 'bool',
        'index_provider_code': 'str',
        'single_category_designation': 'str',
        'registered_countries': 'str',
        'issuing_entity_country_code': 'str',
        'ucits': 'bool',
        'replication_structure': 'str',
        'domicile': 'str',
        'base_currency': 'str',
        'listing_currency': 'str',
        'fund_listing_date': 'date',
        'listing_country_code': 'str',
        'listing_region': 'str',
        'smartvs_traditional_beta': 'str',
        'smartvs_traditional_beta_level2': 'str',
        'income_category': 'str',
        'etp_structure_type': 'str',
        'month_end_assets': 'float',
        'etf_portfolio_turnover': 'float',
        'firstbridge_id': 'str',
        'firstbridge_parent_id': 'str',
        'number_of_holdings': 'int'
    }

    attribute_map = {
        'id': 'id',
        'name': 'name',
        'ticker': 'ticker',
        'figi_ticker': 'figi_ticker',
        'ric': 'ric',
        'isin': 'isin',
        'sedol': 'sedol',
        'exchange_mic': 'exchange_mic',
        'sponsor': 'sponsor',
        'type': 'type',
        'description': 'description',
        'inception_date': 'inception_date',
        'data_change_date': 'data_change_date',
        'close_date': 'close_date',
        'is_live_listed': 'is_live_listed',
        'legal_structure': 'legal_structure',
        'intraday_nav_ticker': 'intraday_nav_ticker',
        'primary_ticker': 'primary_ticker',
        'primary_ticker_country_code': 'primary_ticker_country_code',
        'primary_listing_region': 'primary_listing_region',
        'net_expense_ratio': 'net_expense_ratio',
        'asset_class': 'asset_class',
        'other_asset_types': 'other_asset_types',
        'market_cap_range': 'market_cap_range',
        'holds_only_nyse_stocks': 'holds_only_nyse_stocks',
        'holds_only_nasdaq_stocks': 'holds_only_nasdaq_stocks',
        'growth_value_tilt': 'growth_value_tilt',
        'growth_type': 'growth_type',
        'value_type': 'value_type',
        'sector': 'sector',
        'industry': 'industry',
        'sub_industry': 'sub_industry',
        'cross_sector_theme': 'cross_sector_theme',
        'natural_resources_type': 'natural_resources_type',
        'excludes_financials': 'excludes_financials',
        'excludes_technology': 'excludes_technology',
        'us_or_excludes_us': 'us_or_excludes_us',
        'developed_emerging': 'developed_emerging',
        'specialized_region': 'specialized_region',
        'continent': 'continent',
        'latin_america_sub_group': 'latin_america_sub_group',
        'europe_sub_group': 'europe_sub_group',
        'asia_sub_group': 'asia_sub_group',
        'specific_country': 'specific_country',
        'china_listing_location': 'china_listing_location',
        'us_state': 'us_state',
        'real_estate': 'real_estate',
        'index_weighting_scheme': 'index_weighting_scheme',
        'market_cap_weighting_type': 'market_cap_weighting_type',
        'fundamental_weighting_type': 'fundamental_weighting_type',
        'dividend_weighting_type': 'dividend_weighting_type',
        'bond_type': 'bond_type',
        'government_bond_types': 'government_bond_types',
        'municipal_bond_region': 'municipal_bond_region',
        'municipal_vrdo': 'municipal_vrdo',
        'mortgage_bond_types': 'mortgage_bond_types',
        'bond_tax_status': 'bond_tax_status',
        'credit_quality': 'credit_quality',
        'average_maturity': 'average_maturity',
        'specific_maturity_year': 'specific_maturity_year',
        'bond_currency_denomination': 'bond_currency_denomination',
        'laddered': 'laddered',
        'zero_coupon': 'zero_coupon',
        'floating_rate': 'floating_rate',
        'build_america_bonds': 'build_america_bonds',
        'commodity_types': 'commodity_types',
        'energy_type': 'energy_type',
        'agricultural_type': 'agricultural_type',
        'metal_type': 'metal_type',
        'inverse_leveraged': 'inverse_leveraged',
        'target_date_multi_asset_type': 'target_date_multi_asset_type',
        'currency_hedged': 'currency_hedged',
        'currency_pair': 'currency_pair',
        'social_environmental_type': 'social_environmental_type',
        'clean_energy_type': 'clean_energy_type',
        'dividend_type': 'dividend_type',
        'regular_dividend_payor_type': 'regular_dividend_payor_type',
        'holds_ml_ps': 'holds_ml_ps',
        'holds_preferred_stock': 'holds_preferred_stock',
        'holds_closed_end_funds': 'holds_closed_end_funds',
        'quant_strategies_type': 'quant_strategies_type',
        'other_quant_models': 'other_quant_models',
        'hedge_fund_type': 'hedge_fund_type',
        'derivatives_based': 'derivatives_based',
        'holds_ad_rs': 'holds_ad_rs',
        'index_linked': 'index_linked',
        'includes_short_exposure': 'includes_short_exposure',
        'index_name': 'index_name',
        'parent_index': 'parent_index',
        'index_family': 'index_family',
        'broader_index_family': 'broader_index_family',
        'index_provider': 'index_provider',
        'fund_family': 'fund_family',
        'index_ticker': 'index_ticker',
        'etn_issuing_bank': 'etn_issuing_bank',
        'etn_maturity_date': 'etn_maturity_date',
        'livestock': 'livestock',
        'dynamic_futures_roll': 'dynamic_futures_roll',
        'index_provider_code': 'index_provider_code',
        'single_category_designation': 'single_category_designation',
        'registered_countries': 'registered_countries',
        'issuing_entity_country_code': 'issuing_entity_country_code',
        'ucits': 'ucits',
        'replication_structure': 'replication_structure',
        'domicile': 'domicile',
        'base_currency': 'base_currency',
        'listing_currency': 'listing_currency',
        'fund_listing_date': 'fund_listing_date',
        'listing_country_code': 'listing_country_code',
        'listing_region': 'listing_region',
        'smartvs_traditional_beta': 'smartvs_traditional_beta',
        'smartvs_traditional_beta_level2': 'smartvs_traditional_beta_level2',
        'income_category': 'income_category',
        'etp_structure_type': 'etp_structure_type',
        'month_end_assets': 'month_end_assets',
        'etf_portfolio_turnover': 'etf_portfolio_turnover',
        'firstbridge_id': 'firstbridge_id',
        'firstbridge_parent_id': 'firstbridge_parent_id',
        'number_of_holdings': 'number_of_holdings'
    }

    def __init__(self, id=None, name=None, ticker=None, figi_ticker=None, ric=None, isin=None, sedol=None, exchange_mic=None, sponsor=None, type=None, description=None, inception_date=None, data_change_date=None, close_date=None, is_live_listed=None, legal_structure=None, intraday_nav_ticker=None, primary_ticker=None, primary_ticker_country_code=None, primary_listing_region=None, net_expense_ratio=None, asset_class=None, other_asset_types=None, market_cap_range=None, holds_only_nyse_stocks=None, holds_only_nasdaq_stocks=None, growth_value_tilt=None, growth_type=None, value_type=None, sector=None, industry=None, sub_industry=None, cross_sector_theme=None, natural_resources_type=None, excludes_financials=None, excludes_technology=None, us_or_excludes_us=None, developed_emerging=None, specialized_region=None, continent=None, latin_america_sub_group=None, europe_sub_group=None, asia_sub_group=None, specific_country=None, china_listing_location=None, us_state=None, real_estate=None, index_weighting_scheme=None, market_cap_weighting_type=None, fundamental_weighting_type=None, dividend_weighting_type=None, bond_type=None, government_bond_types=None, municipal_bond_region=None, municipal_vrdo=None, mortgage_bond_types=None, bond_tax_status=None, credit_quality=None, average_maturity=None, specific_maturity_year=None, bond_currency_denomination=None, laddered=None, zero_coupon=None, floating_rate=None, build_america_bonds=None, commodity_types=None, energy_type=None, agricultural_type=None, metal_type=None, inverse_leveraged=None, target_date_multi_asset_type=None, currency_hedged=None, currency_pair=None, social_environmental_type=None, clean_energy_type=None, dividend_type=None, regular_dividend_payor_type=None, holds_ml_ps=None, holds_preferred_stock=None, holds_closed_end_funds=None, quant_strategies_type=None, other_quant_models=None, hedge_fund_type=None, derivatives_based=None, holds_ad_rs=None, index_linked=None, includes_short_exposure=None, index_name=None, parent_index=None, index_family=None, broader_index_family=None, index_provider=None, fund_family=None, index_ticker=None, etn_issuing_bank=None, etn_maturity_date=None, livestock=None, dynamic_futures_roll=None, index_provider_code=None, single_category_designation=None, registered_countries=None, issuing_entity_country_code=None, ucits=None, replication_structure=None, domicile=None, base_currency=None, listing_currency=None, fund_listing_date=None, listing_country_code=None, listing_region=None, smartvs_traditional_beta=None, smartvs_traditional_beta_level2=None, income_category=None, etp_structure_type=None, month_end_assets=None, etf_portfolio_turnover=None, firstbridge_id=None, firstbridge_parent_id=None, number_of_holdings=None):  # noqa: E501
        """ETF - a model defined in Swagger"""  # noqa: E501

        self._id = None
        self._name = None
        self._ticker = None
        self._figi_ticker = None
        self._ric = None
        self._isin = None
        self._sedol = None
        self._exchange_mic = None
        self._sponsor = None
        self._type = None
        self._description = None
        self._inception_date = None
        self._data_change_date = None
        self._close_date = None
        self._is_live_listed = None
        self._legal_structure = None
        self._intraday_nav_ticker = None
        self._primary_ticker = None
        self._primary_ticker_country_code = None
        self._primary_listing_region = None
        self._net_expense_ratio = None
        self._asset_class = None
        self._other_asset_types = None
        self._market_cap_range = None
        self._holds_only_nyse_stocks = None
        self._holds_only_nasdaq_stocks = None
        self._growth_value_tilt = None
        self._growth_type = None
        self._value_type = None
        self._sector = None
        self._industry = None
        self._sub_industry = None
        self._cross_sector_theme = None
        self._natural_resources_type = None
        self._excludes_financials = None
        self._excludes_technology = None
        self._us_or_excludes_us = None
        self._developed_emerging = None
        self._specialized_region = None
        self._continent = None
        self._latin_america_sub_group = None
        self._europe_sub_group = None
        self._asia_sub_group = None
        self._specific_country = None
        self._china_listing_location = None
        self._us_state = None
        self._real_estate = None
        self._index_weighting_scheme = None
        self._market_cap_weighting_type = None
        self._fundamental_weighting_type = None
        self._dividend_weighting_type = None
        self._bond_type = None
        self._government_bond_types = None
        self._municipal_bond_region = None
        self._municipal_vrdo = None
        self._mortgage_bond_types = None
        self._bond_tax_status = None
        self._credit_quality = None
        self._average_maturity = None
        self._specific_maturity_year = None
        self._bond_currency_denomination = None
        self._laddered = None
        self._zero_coupon = None
        self._floating_rate = None
        self._build_america_bonds = None
        self._commodity_types = None
        self._energy_type = None
        self._agricultural_type = None
        self._metal_type = None
        self._inverse_leveraged = None
        self._target_date_multi_asset_type = None
        self._currency_hedged = None
        self._currency_pair = None
        self._social_environmental_type = None
        self._clean_energy_type = None
        self._dividend_type = None
        self._regular_dividend_payor_type = None
        self._holds_ml_ps = None
        self._holds_preferred_stock = None
        self._holds_closed_end_funds = None
        self._quant_strategies_type = None
        self._other_quant_models = None
        self._hedge_fund_type = None
        self._derivatives_based = None
        self._holds_ad_rs = None
        self._index_linked = None
        self._includes_short_exposure = None
        self._index_name = None
        self._parent_index = None
        self._index_family = None
        self._broader_index_family = None
        self._index_provider = None
        self._fund_family = None
        self._index_ticker = None
        self._etn_issuing_bank = None
        self._etn_maturity_date = None
        self._livestock = None
        self._dynamic_futures_roll = None
        self._index_provider_code = None
        self._single_category_designation = None
        self._registered_countries = None
        self._issuing_entity_country_code = None
        self._ucits = None
        self._replication_structure = None
        self._domicile = None
        self._base_currency = None
        self._listing_currency = None
        self._fund_listing_date = None
        self._listing_country_code = None
        self._listing_region = None
        self._smartvs_traditional_beta = None
        self._smartvs_traditional_beta_level2 = None
        self._income_category = None
        self._etp_structure_type = None
        self._month_end_assets = None
        self._etf_portfolio_turnover = None
        self._firstbridge_id = None
        self._firstbridge_parent_id = None
        self._number_of_holdings = None
        self.discriminator = None

        if id is not None:
            self.id = id
        if name is not None:
            self.name = name
        if ticker is not None:
            self.ticker = ticker
        if figi_ticker is not None:
            self.figi_ticker = figi_ticker
        if ric is not None:
            self.ric = ric
        if isin is not None:
            self.isin = isin
        if sedol is not None:
            self.sedol = sedol
        if exchange_mic is not None:
            self.exchange_mic = exchange_mic
        if sponsor is not None:
            self.sponsor = sponsor
        if type is not None:
            self.type = type
        if description is not None:
            self.description = description
        if inception_date is not None:
            self.inception_date = inception_date
        if data_change_date is not None:
            self.data_change_date = data_change_date
        if close_date is not None:
            self.close_date = close_date
        if is_live_listed is not None:
            self.is_live_listed = is_live_listed
        if legal_structure is not None:
            self.legal_structure = legal_structure
        if intraday_nav_ticker is not None:
            self.intraday_nav_ticker = intraday_nav_ticker
        if primary_ticker is not None:
            self.primary_ticker = primary_ticker
        if primary_ticker_country_code is not None:
            self.primary_ticker_country_code = primary_ticker_country_code
        if primary_listing_region is not None:
            self.primary_listing_region = primary_listing_region
        if net_expense_ratio is not None:
            self.net_expense_ratio = net_expense_ratio
        if asset_class is not None:
            self.asset_class = asset_class
        if other_asset_types is not None:
            self.other_asset_types = other_asset_types
        if market_cap_range is not None:
            self.market_cap_range = market_cap_range
        if holds_only_nyse_stocks is not None:
            self.holds_only_nyse_stocks = holds_only_nyse_stocks
        if holds_only_nasdaq_stocks is not None:
            self.holds_only_nasdaq_stocks = holds_only_nasdaq_stocks
        if growth_value_tilt is not None:
            self.growth_value_tilt = growth_value_tilt
        if growth_type is not None:
            self.growth_type = growth_type
        if value_type is not None:
            self.value_type = value_type
        if sector is not None:
            self.sector = sector
        if industry is not None:
            self.industry = industry
        if sub_industry is not None:
            self.sub_industry = sub_industry
        if cross_sector_theme is not None:
            self.cross_sector_theme = cross_sector_theme
        if natural_resources_type is not None:
            self.natural_resources_type = natural_resources_type
        if excludes_financials is not None:
            self.excludes_financials = excludes_financials
        if excludes_technology is not None:
            self.excludes_technology = excludes_technology
        if us_or_excludes_us is not None:
            self.us_or_excludes_us = us_or_excludes_us
        if developed_emerging is not None:
            self.developed_emerging = developed_emerging
        if specialized_region is not None:
            self.specialized_region = specialized_region
        if continent is not None:
            self.continent = continent
        if latin_america_sub_group is not None:
            self.latin_america_sub_group = latin_america_sub_group
        if europe_sub_group is not None:
            self.europe_sub_group = europe_sub_group
        if asia_sub_group is not None:
            self.asia_sub_group = asia_sub_group
        if specific_country is not None:
            self.specific_country = specific_country
        if china_listing_location is not None:
            self.china_listing_location = china_listing_location
        if us_state is not None:
            self.us_state = us_state
        if real_estate is not None:
            self.real_estate = real_estate
        if index_weighting_scheme is not None:
            self.index_weighting_scheme = index_weighting_scheme
        if market_cap_weighting_type is not None:
            self.market_cap_weighting_type = market_cap_weighting_type
        if fundamental_weighting_type is not None:
            self.fundamental_weighting_type = fundamental_weighting_type
        if dividend_weighting_type is not None:
            self.dividend_weighting_type = dividend_weighting_type
        if bond_type is not None:
            self.bond_type = bond_type
        if government_bond_types is not None:
            self.government_bond_types = government_bond_types
        if municipal_bond_region is not None:
            self.municipal_bond_region = municipal_bond_region
        if municipal_vrdo is not None:
            self.municipal_vrdo = municipal_vrdo
        if mortgage_bond_types is not None:
            self.mortgage_bond_types = mortgage_bond_types
        if bond_tax_status is not None:
            self.bond_tax_status = bond_tax_status
        if credit_quality is not None:
            self.credit_quality = credit_quality
        if average_maturity is not None:
            self.average_maturity = average_maturity
        if specific_maturity_year is not None:
            self.specific_maturity_year = specific_maturity_year
        if bond_currency_denomination is not None:
            self.bond_currency_denomination = bond_currency_denomination
        if laddered is not None:
            self.laddered = laddered
        if zero_coupon is not None:
            self.zero_coupon = zero_coupon
        if floating_rate is not None:
            self.floating_rate = floating_rate
        if build_america_bonds is not None:
            self.build_america_bonds = build_america_bonds
        if commodity_types is not None:
            self.commodity_types = commodity_types
        if energy_type is not None:
            self.energy_type = energy_type
        if agricultural_type is not None:
            self.agricultural_type = agricultural_type
        if metal_type is not None:
            self.metal_type = metal_type
        if inverse_leveraged is not None:
            self.inverse_leveraged = inverse_leveraged
        if target_date_multi_asset_type is not None:
            self.target_date_multi_asset_type = target_date_multi_asset_type
        if currency_hedged is not None:
            self.currency_hedged = currency_hedged
        if currency_pair is not None:
            self.currency_pair = currency_pair
        if social_environmental_type is not None:
            self.social_environmental_type = social_environmental_type
        if clean_energy_type is not None:
            self.clean_energy_type = clean_energy_type
        if dividend_type is not None:
            self.dividend_type = dividend_type
        if regular_dividend_payor_type is not None:
            self.regular_dividend_payor_type = regular_dividend_payor_type
        if holds_ml_ps is not None:
            self.holds_ml_ps = holds_ml_ps
        if holds_preferred_stock is not None:
            self.holds_preferred_stock = holds_preferred_stock
        if holds_closed_end_funds is not None:
            self.holds_closed_end_funds = holds_closed_end_funds
        if quant_strategies_type is not None:
            self.quant_strategies_type = quant_strategies_type
        if other_quant_models is not None:
            self.other_quant_models = other_quant_models
        if hedge_fund_type is not None:
            self.hedge_fund_type = hedge_fund_type
        if derivatives_based is not None:
            self.derivatives_based = derivatives_based
        if holds_ad_rs is not None:
            self.holds_ad_rs = holds_ad_rs
        if index_linked is not None:
            self.index_linked = index_linked
        if includes_short_exposure is not None:
            self.includes_short_exposure = includes_short_exposure
        if index_name is not None:
            self.index_name = index_name
        if parent_index is not None:
            self.parent_index = parent_index
        if index_family is not None:
            self.index_family = index_family
        if broader_index_family is not None:
            self.broader_index_family = broader_index_family
        if index_provider is not None:
            self.index_provider = index_provider
        if fund_family is not None:
            self.fund_family = fund_family
        if index_ticker is not None:
            self.index_ticker = index_ticker
        if etn_issuing_bank is not None:
            self.etn_issuing_bank = etn_issuing_bank
        if etn_maturity_date is not None:
            self.etn_maturity_date = etn_maturity_date
        if livestock is not None:
            self.livestock = livestock
        if dynamic_futures_roll is not None:
            self.dynamic_futures_roll = dynamic_futures_roll
        if index_provider_code is not None:
            self.index_provider_code = index_provider_code
        if single_category_designation is not None:
            self.single_category_designation = single_category_designation
        if registered_countries is not None:
            self.registered_countries = registered_countries
        if issuing_entity_country_code is not None:
            self.issuing_entity_country_code = issuing_entity_country_code
        if ucits is not None:
            self.ucits = ucits
        if replication_structure is not None:
            self.replication_structure = replication_structure
        if domicile is not None:
            self.domicile = domicile
        if base_currency is not None:
            self.base_currency = base_currency
        if listing_currency is not None:
            self.listing_currency = listing_currency
        if fund_listing_date is not None:
            self.fund_listing_date = fund_listing_date
        if listing_country_code is not None:
            self.listing_country_code = listing_country_code
        if listing_region is not None:
            self.listing_region = listing_region
        if smartvs_traditional_beta is not None:
            self.smartvs_traditional_beta = smartvs_traditional_beta
        if smartvs_traditional_beta_level2 is not None:
            self.smartvs_traditional_beta_level2 = smartvs_traditional_beta_level2
        if income_category is not None:
            self.income_category = income_category
        if etp_structure_type is not None:
            self.etp_structure_type = etp_structure_type
        if month_end_assets is not None:
            self.month_end_assets = month_end_assets
        if etf_portfolio_turnover is not None:
            self.etf_portfolio_turnover = etf_portfolio_turnover
        if firstbridge_id is not None:
            self.firstbridge_id = firstbridge_id
        if firstbridge_parent_id is not None:
            self.firstbridge_parent_id = firstbridge_parent_id
        if number_of_holdings is not None:
            self.number_of_holdings = number_of_holdings

    @property
    def id(self):
        """Gets the id of this ETF.  # noqa: E501

        The Intrinio ID of the ETF  # noqa: E501

        :return: The id of this ETF.  # noqa: E501
        :rtype: str
        """
        return self._id
        
    @property
    def id_dict(self):
        """Gets the id of this ETF.  # noqa: E501

        The Intrinio ID of the ETF as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The id of this ETF.  # noqa: E501
        :rtype: str
        """

        result = None

        value = self.id
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'id': value }

        
        return result
        

    @id.setter
    def id(self, id):
        """Sets the id of this ETF.

        The Intrinio ID of the ETF  # noqa: E501

        :param id: The id of this ETF.  # noqa: E501
        :type: str
        """

        self._id = id

    @property
    def name(self):
        """Gets the name of this ETF.  # noqa: E501

        The common name of the ETF  # noqa: E501

        :return: The name of this ETF.  # noqa: E501
        :rtype: str
        """
        return self._name
        
    @property
    def name_dict(self):
        """Gets the name of this ETF.  # noqa: E501

        The common name of the ETF as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The name of this ETF.  # noqa: E501
        :rtype: str
        """

        result = None

        value = self.name
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'name': value }

        
        return result
        

    @name.setter
    def name(self, name):
        """Sets the name of this ETF.

        The common name of the ETF  # noqa: E501

        :param name: The name of this ETF.  # noqa: E501
        :type: str
        """

        self._name = name

    @property
    def ticker(self):
        """Gets the ticker of this ETF.  # noqa: E501

        The common ticker symbol for the ETF  # noqa: E501

        :return: The ticker of this ETF.  # noqa: E501
        :rtype: str
        """
        return self._ticker
        
    @property
    def ticker_dict(self):
        """Gets the ticker of this ETF.  # noqa: E501

        The common ticker symbol for the ETF as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The ticker of this ETF.  # noqa: E501
        :rtype: str
        """

        result = None

        value = self.ticker
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'ticker': value }

        
        return result
        

    @ticker.setter
    def ticker(self, ticker):
        """Sets the ticker of this ETF.

        The common ticker symbol for the ETF  # noqa: E501

        :param ticker: The ticker of this ETF.  # noqa: E501
        :type: str
        """

        self._ticker = ticker

    @property
    def figi_ticker(self):
        """Gets the figi_ticker of this ETF.  # noqa: E501

        The OpenFIGI ticker for the ETF  # noqa: E501

        :return: The figi_ticker of this ETF.  # noqa: E501
        :rtype: str
        """
        return self._figi_ticker
        
    @property
    def figi_ticker_dict(self):
        """Gets the figi_ticker of this ETF.  # noqa: E501

        The OpenFIGI ticker for the ETF as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The figi_ticker of this ETF.  # noqa: E501
        :rtype: str
        """

        result = None

        value = self.figi_ticker
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'figi_ticker': value }

        
        return result
        

    @figi_ticker.setter
    def figi_ticker(self, figi_ticker):
        """Sets the figi_ticker of this ETF.

        The OpenFIGI ticker for the ETF  # noqa: E501

        :param figi_ticker: The figi_ticker of this ETF.  # noqa: E501
        :type: str
        """

        self._figi_ticker = figi_ticker

    @property
    def ric(self):
        """Gets the ric of this ETF.  # noqa: E501

        Reuters Instrument Code (RIC) for the ETF  # noqa: E501

        :return: The ric of this ETF.  # noqa: E501
        :rtype: str
        """
        return self._ric
        
    @property
    def ric_dict(self):
        """Gets the ric of this ETF.  # noqa: E501

        Reuters Instrument Code (RIC) for the ETF as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The ric of this ETF.  # noqa: E501
        :rtype: str
        """

        result = None

        value = self.ric
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'ric': value }

        
        return result
        

    @ric.setter
    def ric(self, ric):
        """Sets the ric of this ETF.

        Reuters Instrument Code (RIC) for the ETF  # noqa: E501

        :param ric: The ric of this ETF.  # noqa: E501
        :type: str
        """

        self._ric = ric

    @property
    def isin(self):
        """Gets the isin of this ETF.  # noqa: E501

        International Securities Identification Number (ISIN) for the ETF  # noqa: E501

        :return: The isin of this ETF.  # noqa: E501
        :rtype: str
        """
        return self._isin
        
    @property
    def isin_dict(self):
        """Gets the isin of this ETF.  # noqa: E501

        International Securities Identification Number (ISIN) for the ETF as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The isin of this ETF.  # noqa: E501
        :rtype: str
        """

        result = None

        value = self.isin
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'isin': value }

        
        return result
        

    @isin.setter
    def isin(self, isin):
        """Sets the isin of this ETF.

        International Securities Identification Number (ISIN) for the ETF  # noqa: E501

        :param isin: The isin of this ETF.  # noqa: E501
        :type: str
        """

        self._isin = isin

    @property
    def sedol(self):
        """Gets the sedol of this ETF.  # noqa: E501

        Stock Exchange Daily Official List (SEDOL) for the ETF  # noqa: E501

        :return: The sedol of this ETF.  # noqa: E501
        :rtype: str
        """
        return self._sedol
        
    @property
    def sedol_dict(self):
        """Gets the sedol of this ETF.  # noqa: E501

        Stock Exchange Daily Official List (SEDOL) for the ETF as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The sedol of this ETF.  # noqa: E501
        :rtype: str
        """

        result = None

        value = self.sedol
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'sedol': value }

        
        return result
        

    @sedol.setter
    def sedol(self, sedol):
        """Sets the sedol of this ETF.

        Stock Exchange Daily Official List (SEDOL) for the ETF  # noqa: E501

        :param sedol: The sedol of this ETF.  # noqa: E501
        :type: str
        """

        self._sedol = sedol

    @property
    def exchange_mic(self):
        """Gets the exchange_mic of this ETF.  # noqa: E501

        The exchange Market Identifier Code (MIC) from the International Standards Organization (ISO)  # noqa: E501

        :return: The exchange_mic of this ETF.  # noqa: E501
        :rtype: str
        """
        return self._exchange_mic
        
    @property
    def exchange_mic_dict(self):
        """Gets the exchange_mic of this ETF.  # noqa: E501

        The exchange Market Identifier Code (MIC) from the International Standards Organization (ISO) as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The exchange_mic of this ETF.  # noqa: E501
        :rtype: str
        """

        result = None

        value = self.exchange_mic
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'exchange_mic': value }

        
        return result
        

    @exchange_mic.setter
    def exchange_mic(self, exchange_mic):
        """Sets the exchange_mic of this ETF.

        The exchange Market Identifier Code (MIC) from the International Standards Organization (ISO)  # noqa: E501

        :param exchange_mic: The exchange_mic of this ETF.  # noqa: E501
        :type: str
        """

        self._exchange_mic = exchange_mic

    @property
    def sponsor(self):
        """Gets the sponsor of this ETF.  # noqa: E501

        The fund manager (ETF) or issuing bank (ETN)  # noqa: E501

        :return: The sponsor of this ETF.  # noqa: E501
        :rtype: str
        """
        return self._sponsor
        
    @property
    def sponsor_dict(self):
        """Gets the sponsor of this ETF.  # noqa: E501

        The fund manager (ETF) or issuing bank (ETN) as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The sponsor of this ETF.  # noqa: E501
        :rtype: str
        """

        result = None

        value = self.sponsor
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'sponsor': value }

        
        return result
        

    @sponsor.setter
    def sponsor(self, sponsor):
        """Sets the sponsor of this ETF.

        The fund manager (ETF) or issuing bank (ETN)  # noqa: E501

        :param sponsor: The sponsor of this ETF.  # noqa: E501
        :type: str
        """

        self._sponsor = sponsor

    @property
    def type(self):
        """Gets the type of this ETF.  # noqa: E501

        High-level classification for the ETF based on its intended investment objective  # noqa: E501

        :return: The type of this ETF.  # noqa: E501
        :rtype: str
        """
        return self._type
        
    @property
    def type_dict(self):
        """Gets the type of this ETF.  # noqa: E501

        High-level classification for the ETF based on its intended investment objective as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The type of this ETF.  # noqa: E501
        :rtype: str
        """

        result = None

        value = self.type
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'type': value }

        
        return result
        

    @type.setter
    def type(self, type):
        """Sets the type of this ETF.

        High-level classification for the ETF based on its intended investment objective  # noqa: E501

        :param type: The type of this ETF.  # noqa: E501
        :type: str
        """

        self._type = type

    @property
    def description(self):
        """Gets the description of this ETF.  # noqa: E501

        The ETF description as published by the ETF sponsor  # noqa: E501

        :return: The description of this ETF.  # noqa: E501
        :rtype: str
        """
        return self._description
        
    @property
    def description_dict(self):
        """Gets the description of this ETF.  # noqa: E501

        The ETF description as published by the ETF sponsor as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The description of this ETF.  # noqa: E501
        :rtype: str
        """

        result = None

        value = self.description
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'description': value }

        
        return result
        

    @description.setter
    def description(self, description):
        """Sets the description of this ETF.

        The ETF description as published by the ETF sponsor  # noqa: E501

        :param description: The description of this ETF.  # noqa: E501
        :type: str
        """

        self._description = description

    @property
    def inception_date(self):
        """Gets the inception_date of this ETF.  # noqa: E501

        Inception Date for the ETF as published by the ETF sponsor  # noqa: E501

        :return: The inception_date of this ETF.  # noqa: E501
        :rtype: date
        """
        return self._inception_date
        
    @property
    def inception_date_dict(self):
        """Gets the inception_date of this ETF.  # noqa: E501

        Inception Date for the ETF as published by the ETF sponsor as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The inception_date of this ETF.  # noqa: E501
        :rtype: date
        """

        result = None

        value = self.inception_date
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'inception_date': value }

        
        return result
        

    @inception_date.setter
    def inception_date(self, inception_date):
        """Sets the inception_date of this ETF.

        Inception Date for the ETF as published by the ETF sponsor  # noqa: E501

        :param inception_date: The inception_date of this ETF.  # noqa: E501
        :type: date
        """

        self._inception_date = inception_date

    @property
    def data_change_date(self):
        """Gets the data_change_date of this ETF.  # noqa: E501

        The last date on which there was a change in a classifications data field for this ETF  # noqa: E501

        :return: The data_change_date of this ETF.  # noqa: E501
        :rtype: date
        """
        return self._data_change_date
        
    @property
    def data_change_date_dict(self):
        """Gets the data_change_date of this ETF.  # noqa: E501

        The last date on which there was a change in a classifications data field for this ETF as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The data_change_date of this ETF.  # noqa: E501
        :rtype: date
        """

        result = None

        value = self.data_change_date
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'data_change_date': value }

        
        return result
        

    @data_change_date.setter
    def data_change_date(self, data_change_date):
        """Sets the data_change_date of this ETF.

        The last date on which there was a change in a classifications data field for this ETF  # noqa: E501

        :param data_change_date: The data_change_date of this ETF.  # noqa: E501
        :type: date
        """

        self._data_change_date = data_change_date

    @property
    def close_date(self):
        """Gets the close_date of this ETF.  # noqa: E501

        The date on which this ETF was de-listed if it is no longer listed  # noqa: E501

        :return: The close_date of this ETF.  # noqa: E501
        :rtype: date
        """
        return self._close_date
        
    @property
    def close_date_dict(self):
        """Gets the close_date of this ETF.  # noqa: E501

        The date on which this ETF was de-listed if it is no longer listed as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The close_date of this ETF.  # noqa: E501
        :rtype: date
        """

        result = None

        value = self.close_date
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'close_date': value }

        
        return result
        

    @close_date.setter
    def close_date(self, close_date):
        """Sets the close_date of this ETF.

        The date on which this ETF was de-listed if it is no longer listed  # noqa: E501

        :param close_date: The close_date of this ETF.  # noqa: E501
        :type: date
        """

        self._close_date = close_date

    @property
    def is_live_listed(self):
        """Gets the is_live_listed of this ETF.  # noqa: E501

        If true, the ETF is still listed on an exchange; if false, the ETF is no longer listed  # noqa: E501

        :return: The is_live_listed of this ETF.  # noqa: E501
        :rtype: bool
        """
        return self._is_live_listed
        
    @property
    def is_live_listed_dict(self):
        """Gets the is_live_listed of this ETF.  # noqa: E501

        If true, the ETF is still listed on an exchange; if false, the ETF is no longer listed as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The is_live_listed of this ETF.  # noqa: E501
        :rtype: bool
        """

        result = None

        value = self.is_live_listed
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'is_live_listed': value }

        
        return result
        

    @is_live_listed.setter
    def is_live_listed(self, is_live_listed):
        """Sets the is_live_listed of this ETF.

        If true, the ETF is still listed on an exchange; if false, the ETF is no longer listed  # noqa: E501

        :param is_live_listed: The is_live_listed of this ETF.  # noqa: E501
        :type: bool
        """

        self._is_live_listed = is_live_listed

    @property
    def legal_structure(self):
        """Gets the legal_structure of this ETF.  # noqa: E501

        The legal structure as defined in the prospectus  # noqa: E501

        :return: The legal_structure of this ETF.  # noqa: E501
        :rtype: str
        """
        return self._legal_structure
        
    @property
    def legal_structure_dict(self):
        """Gets the legal_structure of this ETF.  # noqa: E501

        The legal structure as defined in the prospectus as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The legal_structure of this ETF.  # noqa: E501
        :rtype: str
        """

        result = None

        value = self.legal_structure
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'legal_structure': value }

        
        return result
        

    @legal_structure.setter
    def legal_structure(self, legal_structure):
        """Sets the legal_structure of this ETF.

        The legal structure as defined in the prospectus  # noqa: E501

        :param legal_structure: The legal_structure of this ETF.  # noqa: E501
        :type: str
        """

        self._legal_structure = legal_structure

    @property
    def intraday_nav_ticker(self):
        """Gets the intraday_nav_ticker of this ETF.  # noqa: E501

        Intra-day NAV ticker for the Exchange Traded Fund (ETF)  # noqa: E501

        :return: The intraday_nav_ticker of this ETF.  # noqa: E501
        :rtype: str
        """
        return self._intraday_nav_ticker
        
    @property
    def intraday_nav_ticker_dict(self):
        """Gets the intraday_nav_ticker of this ETF.  # noqa: E501

        Intra-day NAV ticker for the Exchange Traded Fund (ETF) as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The intraday_nav_ticker of this ETF.  # noqa: E501
        :rtype: str
        """

        result = None

        value = self.intraday_nav_ticker
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'intraday_nav_ticker': value }

        
        return result
        

    @intraday_nav_ticker.setter
    def intraday_nav_ticker(self, intraday_nav_ticker):
        """Sets the intraday_nav_ticker of this ETF.

        Intra-day NAV ticker for the Exchange Traded Fund (ETF)  # noqa: E501

        :param intraday_nav_ticker: The intraday_nav_ticker of this ETF.  # noqa: E501
        :type: str
        """

        self._intraday_nav_ticker = intraday_nav_ticker

    @property
    def primary_ticker(self):
        """Gets the primary_ticker of this ETF.  # noqa: E501

        The primary ticker field is used for Exchange Traded Products (ETPs) that have multiple listings and share classes. If an ETP has multiple listings or share classes, the same primary ticker is assigned to all the listings and share classes  # noqa: E501

        :return: The primary_ticker of this ETF.  # noqa: E501
        :rtype: str
        """
        return self._primary_ticker
        
    @property
    def primary_ticker_dict(self):
        """Gets the primary_ticker of this ETF.  # noqa: E501

        The primary ticker field is used for Exchange Traded Products (ETPs) that have multiple listings and share classes. If an ETP has multiple listings or share classes, the same primary ticker is assigned to all the listings and share classes as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The primary_ticker of this ETF.  # noqa: E501
        :rtype: str
        """

        result = None

        value = self.primary_ticker
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'primary_ticker': value }

        
        return result
        

    @primary_ticker.setter
    def primary_ticker(self, primary_ticker):
        """Sets the primary_ticker of this ETF.

        The primary ticker field is used for Exchange Traded Products (ETPs) that have multiple listings and share classes. If an ETP has multiple listings or share classes, the same primary ticker is assigned to all the listings and share classes  # noqa: E501

        :param primary_ticker: The primary_ticker of this ETF.  # noqa: E501
        :type: str
        """

        self._primary_ticker = primary_ticker

    @property
    def primary_ticker_country_code(self):
        """Gets the primary_ticker_country_code of this ETF.  # noqa: E501

        2 letter ISO country code for the country of the primary listing  # noqa: E501

        :return: The primary_ticker_country_code of this ETF.  # noqa: E501
        :rtype: str
        """
        return self._primary_ticker_country_code
        
    @property
    def primary_ticker_country_code_dict(self):
        """Gets the primary_ticker_country_code of this ETF.  # noqa: E501

        2 letter ISO country code for the country of the primary listing as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The primary_ticker_country_code of this ETF.  # noqa: E501
        :rtype: str
        """

        result = None

        value = self.primary_ticker_country_code
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'primary_ticker_country_code': value }

        
        return result
        

    @primary_ticker_country_code.setter
    def primary_ticker_country_code(self, primary_ticker_country_code):
        """Sets the primary_ticker_country_code of this ETF.

        2 letter ISO country code for the country of the primary listing  # noqa: E501

        :param primary_ticker_country_code: The primary_ticker_country_code of this ETF.  # noqa: E501
        :type: str
        """

        self._primary_ticker_country_code = primary_ticker_country_code

    @property
    def primary_listing_region(self):
        """Gets the primary_listing_region of this ETF.  # noqa: E501

        Geographic region in the country of the primary listing falls  # noqa: E501

        :return: The primary_listing_region of this ETF.  # noqa: E501
        :rtype: str
        """
        return self._primary_listing_region
        
    @property
    def primary_listing_region_dict(self):
        """Gets the primary_listing_region of this ETF.  # noqa: E501

        Geographic region in the country of the primary listing falls as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The primary_listing_region of this ETF.  # noqa: E501
        :rtype: str
        """

        result = None

        value = self.primary_listing_region
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'primary_listing_region': value }

        
        return result
        

    @primary_listing_region.setter
    def primary_listing_region(self, primary_listing_region):
        """Sets the primary_listing_region of this ETF.

        Geographic region in the country of the primary listing falls  # noqa: E501

        :param primary_listing_region: The primary_listing_region of this ETF.  # noqa: E501
        :type: str
        """

        self._primary_listing_region = primary_listing_region

    @property
    def net_expense_ratio(self):
        """Gets the net_expense_ratio of this ETF.  # noqa: E501

        Gross expense net of Fee Waivers, as a percentage of net assets as published by the ETF Sponsor  # noqa: E501

        :return: The net_expense_ratio of this ETF.  # noqa: E501
        :rtype: float
        """
        return self._net_expense_ratio
        
    @property
    def net_expense_ratio_dict(self):
        """Gets the net_expense_ratio of this ETF.  # noqa: E501

        Gross expense net of Fee Waivers, as a percentage of net assets as published by the ETF Sponsor as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The net_expense_ratio of this ETF.  # noqa: E501
        :rtype: float
        """

        result = None

        value = self.net_expense_ratio
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'net_expense_ratio': value }

        
        return result
        

    @net_expense_ratio.setter
    def net_expense_ratio(self, net_expense_ratio):
        """Sets the net_expense_ratio of this ETF.

        Gross expense net of Fee Waivers, as a percentage of net assets as published by the ETF Sponsor  # noqa: E501

        :param net_expense_ratio: The net_expense_ratio of this ETF.  # noqa: E501
        :type: float
        """

        self._net_expense_ratio = net_expense_ratio

    @property
    def asset_class(self):
        """Gets the asset_class of this ETF.  # noqa: E501

        Captures the underlying nature of the securities in the Exchanged Traded Product (ETP)  # noqa: E501

        :return: The asset_class of this ETF.  # noqa: E501
        :rtype: str
        """
        return self._asset_class
        
    @property
    def asset_class_dict(self):
        """Gets the asset_class of this ETF.  # noqa: E501

        Captures the underlying nature of the securities in the Exchanged Traded Product (ETP) as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The asset_class of this ETF.  # noqa: E501
        :rtype: str
        """

        result = None

        value = self.asset_class
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'asset_class': value }

        
        return result
        

    @asset_class.setter
    def asset_class(self, asset_class):
        """Sets the asset_class of this ETF.

        Captures the underlying nature of the securities in the Exchanged Traded Product (ETP)  # noqa: E501

        :param asset_class: The asset_class of this ETF.  # noqa: E501
        :type: str
        """

        self._asset_class = asset_class

    @property
    def other_asset_types(self):
        """Gets the other_asset_types of this ETF.  # noqa: E501

        If 'asset_class' field is classified as 'Other Asset Types' this field captures the specific category of the underlying assets  # noqa: E501

        :return: The other_asset_types of this ETF.  # noqa: E501
        :rtype: str
        """
        return self._other_asset_types
        
    @property
    def other_asset_types_dict(self):
        """Gets the other_asset_types of this ETF.  # noqa: E501

        If 'asset_class' field is classified as 'Other Asset Types' this field captures the specific category of the underlying assets as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The other_asset_types of this ETF.  # noqa: E501
        :rtype: str
        """

        result = None

        value = self.other_asset_types
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'other_asset_types': value }

        
        return result
        

    @other_asset_types.setter
    def other_asset_types(self, other_asset_types):
        """Sets the other_asset_types of this ETF.

        If 'asset_class' field is classified as 'Other Asset Types' this field captures the specific category of the underlying assets  # noqa: E501

        :param other_asset_types: The other_asset_types of this ETF.  # noqa: E501
        :type: str
        """

        self._other_asset_types = other_asset_types

    @property
    def market_cap_range(self):
        """Gets the market_cap_range of this ETF.  # noqa: E501

        Equity ETFs are classified as falling into categories based on the description of their investment strategy in the prospectus.  Examples ('Mega Cap', 'Large Cap', 'Mid Cap', etc.)  # noqa: E501

        :return: The market_cap_range of this ETF.  # noqa: E501
        :rtype: str
        """
        return self._market_cap_range
        
    @property
    def market_cap_range_dict(self):
        """Gets the market_cap_range of this ETF.  # noqa: E501

        Equity ETFs are classified as falling into categories based on the description of their investment strategy in the prospectus.  Examples ('Mega Cap', 'Large Cap', 'Mid Cap', etc.) as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The market_cap_range of this ETF.  # noqa: E501
        :rtype: str
        """

        result = None

        value = self.market_cap_range
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'market_cap_range': value }

        
        return result
        

    @market_cap_range.setter
    def market_cap_range(self, market_cap_range):
        """Sets the market_cap_range of this ETF.

        Equity ETFs are classified as falling into categories based on the description of their investment strategy in the prospectus.  Examples ('Mega Cap', 'Large Cap', 'Mid Cap', etc.)  # noqa: E501

        :param market_cap_range: The market_cap_range of this ETF.  # noqa: E501
        :type: str
        """

        self._market_cap_range = market_cap_range

    @property
    def holds_only_nyse_stocks(self):
        """Gets the holds_only_nyse_stocks of this ETF.  # noqa: E501

        If true, the ETF is an equity ETF and holds only stocks listed on NYSE  # noqa: E501

        :return: The holds_only_nyse_stocks of this ETF.  # noqa: E501
        :rtype: bool
        """
        return self._holds_only_nyse_stocks
        
    @property
    def holds_only_nyse_stocks_dict(self):
        """Gets the holds_only_nyse_stocks of this ETF.  # noqa: E501

        If true, the ETF is an equity ETF and holds only stocks listed on NYSE as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The holds_only_nyse_stocks of this ETF.  # noqa: E501
        :rtype: bool
        """

        result = None

        value = self.holds_only_nyse_stocks
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'holds_only_nyse_stocks': value }

        
        return result
        

    @holds_only_nyse_stocks.setter
    def holds_only_nyse_stocks(self, holds_only_nyse_stocks):
        """Sets the holds_only_nyse_stocks of this ETF.

        If true, the ETF is an equity ETF and holds only stocks listed on NYSE  # noqa: E501

        :param holds_only_nyse_stocks: The holds_only_nyse_stocks of this ETF.  # noqa: E501
        :type: bool
        """

        self._holds_only_nyse_stocks = holds_only_nyse_stocks

    @property
    def holds_only_nasdaq_stocks(self):
        """Gets the holds_only_nasdaq_stocks of this ETF.  # noqa: E501

        If false, the ETF is an equity ETF and holds only stocks listed on Nasdaq  # noqa: E501

        :return: The holds_only_nasdaq_stocks of this ETF.  # noqa: E501
        :rtype: bool
        """
        return self._holds_only_nasdaq_stocks
        
    @property
    def holds_only_nasdaq_stocks_dict(self):
        """Gets the holds_only_nasdaq_stocks of this ETF.  # noqa: E501

        If false, the ETF is an equity ETF and holds only stocks listed on Nasdaq as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The holds_only_nasdaq_stocks of this ETF.  # noqa: E501
        :rtype: bool
        """

        result = None

        value = self.holds_only_nasdaq_stocks
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'holds_only_nasdaq_stocks': value }

        
        return result
        

    @holds_only_nasdaq_stocks.setter
    def holds_only_nasdaq_stocks(self, holds_only_nasdaq_stocks):
        """Sets the holds_only_nasdaq_stocks of this ETF.

        If false, the ETF is an equity ETF and holds only stocks listed on Nasdaq  # noqa: E501

        :param holds_only_nasdaq_stocks: The holds_only_nasdaq_stocks of this ETF.  # noqa: E501
        :type: bool
        """

        self._holds_only_nasdaq_stocks = holds_only_nasdaq_stocks

    @property
    def growth_value_tilt(self):
        """Gets the growth_value_tilt of this ETF.  # noqa: E501

        Classifies equity ETFs as either 'Growth' or Value' based on the stated style tilt in the ETF prospectus. Equity ETFs that do not have a stated style tilt are classified as 'Core / Blend'  # noqa: E501

        :return: The growth_value_tilt of this ETF.  # noqa: E501
        :rtype: str
        """
        return self._growth_value_tilt
        
    @property
    def growth_value_tilt_dict(self):
        """Gets the growth_value_tilt of this ETF.  # noqa: E501

        Classifies equity ETFs as either 'Growth' or Value' based on the stated style tilt in the ETF prospectus. Equity ETFs that do not have a stated style tilt are classified as 'Core / Blend' as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The growth_value_tilt of this ETF.  # noqa: E501
        :rtype: str
        """

        result = None

        value = self.growth_value_tilt
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'growth_value_tilt': value }

        
        return result
        

    @growth_value_tilt.setter
    def growth_value_tilt(self, growth_value_tilt):
        """Sets the growth_value_tilt of this ETF.

        Classifies equity ETFs as either 'Growth' or Value' based on the stated style tilt in the ETF prospectus. Equity ETFs that do not have a stated style tilt are classified as 'Core / Blend'  # noqa: E501

        :param growth_value_tilt: The growth_value_tilt of this ETF.  # noqa: E501
        :type: str
        """

        self._growth_value_tilt = growth_value_tilt

    @property
    def growth_type(self):
        """Gets the growth_type of this ETF.  # noqa: E501

        For ETFs that are classified as 'Growth' in 'growth_value_tilt', this field further identifies those where the stocks in the ETF are both selected and weighted based on their growth (style factor) scores  # noqa: E501

        :return: The growth_type of this ETF.  # noqa: E501
        :rtype: str
        """
        return self._growth_type
        
    @property
    def growth_type_dict(self):
        """Gets the growth_type of this ETF.  # noqa: E501

        For ETFs that are classified as 'Growth' in 'growth_value_tilt', this field further identifies those where the stocks in the ETF are both selected and weighted based on their growth (style factor) scores as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The growth_type of this ETF.  # noqa: E501
        :rtype: str
        """

        result = None

        value = self.growth_type
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'growth_type': value }

        
        return result
        

    @growth_type.setter
    def growth_type(self, growth_type):
        """Sets the growth_type of this ETF.

        For ETFs that are classified as 'Growth' in 'growth_value_tilt', this field further identifies those where the stocks in the ETF are both selected and weighted based on their growth (style factor) scores  # noqa: E501

        :param growth_type: The growth_type of this ETF.  # noqa: E501
        :type: str
        """

        self._growth_type = growth_type

    @property
    def value_type(self):
        """Gets the value_type of this ETF.  # noqa: E501

        For ETFs that are classified as 'Value' in 'growth_value_tilt', this field further identifies those where the stocks in the ETF are both selected and weighted based on their value (style factor) scores  # noqa: E501

        :return: The value_type of this ETF.  # noqa: E501
        :rtype: str
        """
        return self._value_type
        
    @property
    def value_type_dict(self):
        """Gets the value_type of this ETF.  # noqa: E501

        For ETFs that are classified as 'Value' in 'growth_value_tilt', this field further identifies those where the stocks in the ETF are both selected and weighted based on their value (style factor) scores as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The value_type of this ETF.  # noqa: E501
        :rtype: str
        """

        result = None

        value = self.value_type
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'value_type': value }

        
        return result
        

    @value_type.setter
    def value_type(self, value_type):
        """Sets the value_type of this ETF.

        For ETFs that are classified as 'Value' in 'growth_value_tilt', this field further identifies those where the stocks in the ETF are both selected and weighted based on their value (style factor) scores  # noqa: E501

        :param value_type: The value_type of this ETF.  # noqa: E501
        :type: str
        """

        self._value_type = value_type

    @property
    def sector(self):
        """Gets the sector of this ETF.  # noqa: E501

        For equity ETFs that aim to provide targeted exposure to a sector or industry, this field identifies the Sector that it provides the exposure to  # noqa: E501

        :return: The sector of this ETF.  # noqa: E501
        :rtype: str
        """
        return self._sector
        
    @property
    def sector_dict(self):
        """Gets the sector of this ETF.  # noqa: E501

        For equity ETFs that aim to provide targeted exposure to a sector or industry, this field identifies the Sector that it provides the exposure to as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The sector of this ETF.  # noqa: E501
        :rtype: str
        """

        result = None

        value = self.sector
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'sector': value }

        
        return result
        

    @sector.setter
    def sector(self, sector):
        """Sets the sector of this ETF.

        For equity ETFs that aim to provide targeted exposure to a sector or industry, this field identifies the Sector that it provides the exposure to  # noqa: E501

        :param sector: The sector of this ETF.  # noqa: E501
        :type: str
        """

        self._sector = sector

    @property
    def industry(self):
        """Gets the industry of this ETF.  # noqa: E501

        For equity ETFs that aim to provide targeted exposure to an industry, this field identifies the Industry that it provides the exposure to.  # noqa: E501

        :return: The industry of this ETF.  # noqa: E501
        :rtype: str
        """
        return self._industry
        
    @property
    def industry_dict(self):
        """Gets the industry of this ETF.  # noqa: E501

        For equity ETFs that aim to provide targeted exposure to an industry, this field identifies the Industry that it provides the exposure to. as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The industry of this ETF.  # noqa: E501
        :rtype: str
        """

        result = None

        value = self.industry
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'industry': value }

        
        return result
        

    @industry.setter
    def industry(self, industry):
        """Sets the industry of this ETF.

        For equity ETFs that aim to provide targeted exposure to an industry, this field identifies the Industry that it provides the exposure to.  # noqa: E501

        :param industry: The industry of this ETF.  # noqa: E501
        :type: str
        """

        self._industry = industry

    @property
    def sub_industry(self):
        """Gets the sub_industry of this ETF.  # noqa: E501

        For equity ETFs that aim to provide targeted exposure to a sub-industry, this field identifies the sub-industry that it provides the exposure to  # noqa: E501

        :return: The sub_industry of this ETF.  # noqa: E501
        :rtype: str
        """
        return self._sub_industry
        
    @property
    def sub_industry_dict(self):
        """Gets the sub_industry of this ETF.  # noqa: E501

        For equity ETFs that aim to provide targeted exposure to a sub-industry, this field identifies the sub-industry that it provides the exposure to as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The sub_industry of this ETF.  # noqa: E501
        :rtype: str
        """

        result = None

        value = self.sub_industry
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'sub_industry': value }

        
        return result
        

    @sub_industry.setter
    def sub_industry(self, sub_industry):
        """Sets the sub_industry of this ETF.

        For equity ETFs that aim to provide targeted exposure to a sub-industry, this field identifies the sub-industry that it provides the exposure to  # noqa: E501

        :param sub_industry: The sub_industry of this ETF.  # noqa: E501
        :type: str
        """

        self._sub_industry = sub_industry

    @property
    def cross_sector_theme(self):
        """Gets the cross_sector_theme of this ETF.  # noqa: E501

        For equity ETFs that aim to provide targeted exposure to a specific investment theme that cuts across GICS sectors, this field identifies the specific cross-sector theme.  Examples ('Agri-business', 'Natural Resources', 'Green Investing', etc.)  # noqa: E501

        :return: The cross_sector_theme of this ETF.  # noqa: E501
        :rtype: str
        """
        return self._cross_sector_theme
        
    @property
    def cross_sector_theme_dict(self):
        """Gets the cross_sector_theme of this ETF.  # noqa: E501

        For equity ETFs that aim to provide targeted exposure to a specific investment theme that cuts across GICS sectors, this field identifies the specific cross-sector theme.  Examples ('Agri-business', 'Natural Resources', 'Green Investing', etc.) as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The cross_sector_theme of this ETF.  # noqa: E501
        :rtype: str
        """

        result = None

        value = self.cross_sector_theme
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'cross_sector_theme': value }

        
        return result
        

    @cross_sector_theme.setter
    def cross_sector_theme(self, cross_sector_theme):
        """Sets the cross_sector_theme of this ETF.

        For equity ETFs that aim to provide targeted exposure to a specific investment theme that cuts across GICS sectors, this field identifies the specific cross-sector theme.  Examples ('Agri-business', 'Natural Resources', 'Green Investing', etc.)  # noqa: E501

        :param cross_sector_theme: The cross_sector_theme of this ETF.  # noqa: E501
        :type: str
        """

        self._cross_sector_theme = cross_sector_theme

    @property
    def natural_resources_type(self):
        """Gets the natural_resources_type of this ETF.  # noqa: E501

        For ETFs that are classified as 'Natural Resources' in the 'cross_sector_theme' field, this field provides further detail on the type of Natural Resources exposure.  # noqa: E501

        :return: The natural_resources_type of this ETF.  # noqa: E501
        :rtype: str
        """
        return self._natural_resources_type
        
    @property
    def natural_resources_type_dict(self):
        """Gets the natural_resources_type of this ETF.  # noqa: E501

        For ETFs that are classified as 'Natural Resources' in the 'cross_sector_theme' field, this field provides further detail on the type of Natural Resources exposure. as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The natural_resources_type of this ETF.  # noqa: E501
        :rtype: str
        """

        result = None

        value = self.natural_resources_type
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'natural_resources_type': value }

        
        return result
        

    @natural_resources_type.setter
    def natural_resources_type(self, natural_resources_type):
        """Sets the natural_resources_type of this ETF.

        For ETFs that are classified as 'Natural Resources' in the 'cross_sector_theme' field, this field provides further detail on the type of Natural Resources exposure.  # noqa: E501

        :param natural_resources_type: The natural_resources_type of this ETF.  # noqa: E501
        :type: str
        """

        self._natural_resources_type = natural_resources_type

    @property
    def excludes_financials(self):
        """Gets the excludes_financials of this ETF.  # noqa: E501

        For equity ETFs, identifies those ETFs where the underlying fund holdings will not hold financials stocks, based on the funds intended objective  # noqa: E501

        :return: The excludes_financials of this ETF.  # noqa: E501
        :rtype: bool
        """
        return self._excludes_financials
        
    @property
    def excludes_financials_dict(self):
        """Gets the excludes_financials of this ETF.  # noqa: E501

        For equity ETFs, identifies those ETFs where the underlying fund holdings will not hold financials stocks, based on the funds intended objective as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The excludes_financials of this ETF.  # noqa: E501
        :rtype: bool
        """

        result = None

        value = self.excludes_financials
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'excludes_financials': value }

        
        return result
        

    @excludes_financials.setter
    def excludes_financials(self, excludes_financials):
        """Sets the excludes_financials of this ETF.

        For equity ETFs, identifies those ETFs where the underlying fund holdings will not hold financials stocks, based on the funds intended objective  # noqa: E501

        :param excludes_financials: The excludes_financials of this ETF.  # noqa: E501
        :type: bool
        """

        self._excludes_financials = excludes_financials

    @property
    def excludes_technology(self):
        """Gets the excludes_technology of this ETF.  # noqa: E501

        For equity ETFs, identifies those ETFs where the underlying fund holdings will not hold technology stocks, based on the funds intended objective  # noqa: E501

        :return: The excludes_technology of this ETF.  # noqa: E501
        :rtype: bool
        """
        return self._excludes_technology
        
    @property
    def excludes_technology_dict(self):
        """Gets the excludes_technology of this ETF.  # noqa: E501

        For equity ETFs, identifies those ETFs where the underlying fund holdings will not hold technology stocks, based on the funds intended objective as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The excludes_technology of this ETF.  # noqa: E501
        :rtype: bool
        """

        result = None

        value = self.excludes_technology
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'excludes_technology': value }

        
        return result
        

    @excludes_technology.setter
    def excludes_technology(self, excludes_technology):
        """Sets the excludes_technology of this ETF.

        For equity ETFs, identifies those ETFs where the underlying fund holdings will not hold technology stocks, based on the funds intended objective  # noqa: E501

        :param excludes_technology: The excludes_technology of this ETF.  # noqa: E501
        :type: bool
        """

        self._excludes_technology = excludes_technology

    @property
    def us_or_excludes_us(self):
        """Gets the us_or_excludes_us of this ETF.  # noqa: E501

        Takes the value of 'Domestic' for US exposure, 'International' for non-US exposure and 'Global' for exposure that includes all regions including the US  # noqa: E501

        :return: The us_or_excludes_us of this ETF.  # noqa: E501
        :rtype: str
        """
        return self._us_or_excludes_us
        
    @property
    def us_or_excludes_us_dict(self):
        """Gets the us_or_excludes_us of this ETF.  # noqa: E501

        Takes the value of 'Domestic' for US exposure, 'International' for non-US exposure and 'Global' for exposure that includes all regions including the US as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The us_or_excludes_us of this ETF.  # noqa: E501
        :rtype: str
        """

        result = None

        value = self.us_or_excludes_us
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'us_or_excludes_us': value }

        
        return result
        

    @us_or_excludes_us.setter
    def us_or_excludes_us(self, us_or_excludes_us):
        """Sets the us_or_excludes_us of this ETF.

        Takes the value of 'Domestic' for US exposure, 'International' for non-US exposure and 'Global' for exposure that includes all regions including the US  # noqa: E501

        :param us_or_excludes_us: The us_or_excludes_us of this ETF.  # noqa: E501
        :type: str
        """

        self._us_or_excludes_us = us_or_excludes_us

    @property
    def developed_emerging(self):
        """Gets the developed_emerging of this ETF.  # noqa: E501

        This field identifies the stage of development of the markets that the ETF provides exposure to  # noqa: E501

        :return: The developed_emerging of this ETF.  # noqa: E501
        :rtype: str
        """
        return self._developed_emerging
        
    @property
    def developed_emerging_dict(self):
        """Gets the developed_emerging of this ETF.  # noqa: E501

        This field identifies the stage of development of the markets that the ETF provides exposure to as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The developed_emerging of this ETF.  # noqa: E501
        :rtype: str
        """

        result = None

        value = self.developed_emerging
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'developed_emerging': value }

        
        return result
        

    @developed_emerging.setter
    def developed_emerging(self, developed_emerging):
        """Sets the developed_emerging of this ETF.

        This field identifies the stage of development of the markets that the ETF provides exposure to  # noqa: E501

        :param developed_emerging: The developed_emerging of this ETF.  # noqa: E501
        :type: str
        """

        self._developed_emerging = developed_emerging

    @property
    def specialized_region(self):
        """Gets the specialized_region of this ETF.  # noqa: E501

        This field is populated if the ETF provides targeted exposure to a specific type of geography-based grouping that does not fall into a specific country or continent grouping.  Examples ('BRIC', 'Chindia', etc.)  # noqa: E501

        :return: The specialized_region of this ETF.  # noqa: E501
        :rtype: str
        """
        return self._specialized_region
        
    @property
    def specialized_region_dict(self):
        """Gets the specialized_region of this ETF.  # noqa: E501

        This field is populated if the ETF provides targeted exposure to a specific type of geography-based grouping that does not fall into a specific country or continent grouping.  Examples ('BRIC', 'Chindia', etc.) as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The specialized_region of this ETF.  # noqa: E501
        :rtype: str
        """

        result = None

        value = self.specialized_region
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'specialized_region': value }

        
        return result
        

    @specialized_region.setter
    def specialized_region(self, specialized_region):
        """Sets the specialized_region of this ETF.

        This field is populated if the ETF provides targeted exposure to a specific type of geography-based grouping that does not fall into a specific country or continent grouping.  Examples ('BRIC', 'Chindia', etc.)  # noqa: E501

        :param specialized_region: The specialized_region of this ETF.  # noqa: E501
        :type: str
        """

        self._specialized_region = specialized_region

    @property
    def continent(self):
        """Gets the continent of this ETF.  # noqa: E501

        This field is populated if the ETF provides targeted exposure to a specific continent or country within that Continent  # noqa: E501

        :return: The continent of this ETF.  # noqa: E501
        :rtype: str
        """
        return self._continent
        
    @property
    def continent_dict(self):
        """Gets the continent of this ETF.  # noqa: E501

        This field is populated if the ETF provides targeted exposure to a specific continent or country within that Continent as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The continent of this ETF.  # noqa: E501
        :rtype: str
        """

        result = None

        value = self.continent
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'continent': value }

        
        return result
        

    @continent.setter
    def continent(self, continent):
        """Sets the continent of this ETF.

        This field is populated if the ETF provides targeted exposure to a specific continent or country within that Continent  # noqa: E501

        :param continent: The continent of this ETF.  # noqa: E501
        :type: str
        """

        self._continent = continent

    @property
    def latin_america_sub_group(self):
        """Gets the latin_america_sub_group of this ETF.  # noqa: E501

        For ETFs that are classified as 'Latin America' in the 'continent' field, this field provides further detail on the type of regional exposure  # noqa: E501

        :return: The latin_america_sub_group of this ETF.  # noqa: E501
        :rtype: str
        """
        return self._latin_america_sub_group
        
    @property
    def latin_america_sub_group_dict(self):
        """Gets the latin_america_sub_group of this ETF.  # noqa: E501

        For ETFs that are classified as 'Latin America' in the 'continent' field, this field provides further detail on the type of regional exposure as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The latin_america_sub_group of this ETF.  # noqa: E501
        :rtype: str
        """

        result = None

        value = self.latin_america_sub_group
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'latin_america_sub_group': value }

        
        return result
        

    @latin_america_sub_group.setter
    def latin_america_sub_group(self, latin_america_sub_group):
        """Sets the latin_america_sub_group of this ETF.

        For ETFs that are classified as 'Latin America' in the 'continent' field, this field provides further detail on the type of regional exposure  # noqa: E501

        :param latin_america_sub_group: The latin_america_sub_group of this ETF.  # noqa: E501
        :type: str
        """

        self._latin_america_sub_group = latin_america_sub_group

    @property
    def europe_sub_group(self):
        """Gets the europe_sub_group of this ETF.  # noqa: E501

        For ETFs that are classified as 'Europe' in the 'continent' field, this field provides further detail on the type of regional exposure  # noqa: E501

        :return: The europe_sub_group of this ETF.  # noqa: E501
        :rtype: str
        """
        return self._europe_sub_group
        
    @property
    def europe_sub_group_dict(self):
        """Gets the europe_sub_group of this ETF.  # noqa: E501

        For ETFs that are classified as 'Europe' in the 'continent' field, this field provides further detail on the type of regional exposure as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The europe_sub_group of this ETF.  # noqa: E501
        :rtype: str
        """

        result = None

        value = self.europe_sub_group
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'europe_sub_group': value }

        
        return result
        

    @europe_sub_group.setter
    def europe_sub_group(self, europe_sub_group):
        """Sets the europe_sub_group of this ETF.

        For ETFs that are classified as 'Europe' in the 'continent' field, this field provides further detail on the type of regional exposure  # noqa: E501

        :param europe_sub_group: The europe_sub_group of this ETF.  # noqa: E501
        :type: str
        """

        self._europe_sub_group = europe_sub_group

    @property
    def asia_sub_group(self):
        """Gets the asia_sub_group of this ETF.  # noqa: E501

        For ETFs that are classified as 'Asia' in the 'continent' field, this field provides further detail on the type of regional exposure  # noqa: E501

        :return: The asia_sub_group of this ETF.  # noqa: E501
        :rtype: str
        """
        return self._asia_sub_group
        
    @property
    def asia_sub_group_dict(self):
        """Gets the asia_sub_group of this ETF.  # noqa: E501

        For ETFs that are classified as 'Asia' in the 'continent' field, this field provides further detail on the type of regional exposure as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The asia_sub_group of this ETF.  # noqa: E501
        :rtype: str
        """

        result = None

        value = self.asia_sub_group
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'asia_sub_group': value }

        
        return result
        

    @asia_sub_group.setter
    def asia_sub_group(self, asia_sub_group):
        """Sets the asia_sub_group of this ETF.

        For ETFs that are classified as 'Asia' in the 'continent' field, this field provides further detail on the type of regional exposure  # noqa: E501

        :param asia_sub_group: The asia_sub_group of this ETF.  # noqa: E501
        :type: str
        """

        self._asia_sub_group = asia_sub_group

    @property
    def specific_country(self):
        """Gets the specific_country of this ETF.  # noqa: E501

        This field is populated if the ETF provides targeted exposure to a specific country  # noqa: E501

        :return: The specific_country of this ETF.  # noqa: E501
        :rtype: str
        """
        return self._specific_country
        
    @property
    def specific_country_dict(self):
        """Gets the specific_country of this ETF.  # noqa: E501

        This field is populated if the ETF provides targeted exposure to a specific country as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The specific_country of this ETF.  # noqa: E501
        :rtype: str
        """

        result = None

        value = self.specific_country
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'specific_country': value }

        
        return result
        

    @specific_country.setter
    def specific_country(self, specific_country):
        """Sets the specific_country of this ETF.

        This field is populated if the ETF provides targeted exposure to a specific country  # noqa: E501

        :param specific_country: The specific_country of this ETF.  # noqa: E501
        :type: str
        """

        self._specific_country = specific_country

    @property
    def china_listing_location(self):
        """Gets the china_listing_location of this ETF.  # noqa: E501

        For ETFs that are classified as 'China' in the 'country' field, this field provides further detail on the type of exposure in the underlying securities  # noqa: E501

        :return: The china_listing_location of this ETF.  # noqa: E501
        :rtype: str
        """
        return self._china_listing_location
        
    @property
    def china_listing_location_dict(self):
        """Gets the china_listing_location of this ETF.  # noqa: E501

        For ETFs that are classified as 'China' in the 'country' field, this field provides further detail on the type of exposure in the underlying securities as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The china_listing_location of this ETF.  # noqa: E501
        :rtype: str
        """

        result = None

        value = self.china_listing_location
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'china_listing_location': value }

        
        return result
        

    @china_listing_location.setter
    def china_listing_location(self, china_listing_location):
        """Sets the china_listing_location of this ETF.

        For ETFs that are classified as 'China' in the 'country' field, this field provides further detail on the type of exposure in the underlying securities  # noqa: E501

        :param china_listing_location: The china_listing_location of this ETF.  # noqa: E501
        :type: str
        """

        self._china_listing_location = china_listing_location

    @property
    def us_state(self):
        """Gets the us_state of this ETF.  # noqa: E501

        Takes the value of a US state if the ETF provides targeted exposure to the municipal bonds or equities of companies operating in a specific state in the US  # noqa: E501

        :return: The us_state of this ETF.  # noqa: E501
        :rtype: str
        """
        return self._us_state
        
    @property
    def us_state_dict(self):
        """Gets the us_state of this ETF.  # noqa: E501

        Takes the value of a US state if the ETF provides targeted exposure to the municipal bonds or equities of companies operating in a specific state in the US as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The us_state of this ETF.  # noqa: E501
        :rtype: str
        """

        result = None

        value = self.us_state
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'us_state': value }

        
        return result
        

    @us_state.setter
    def us_state(self, us_state):
        """Sets the us_state of this ETF.

        Takes the value of a US state if the ETF provides targeted exposure to the municipal bonds or equities of companies operating in a specific state in the US  # noqa: E501

        :param us_state: The us_state of this ETF.  # noqa: E501
        :type: str
        """

        self._us_state = us_state

    @property
    def real_estate(self):
        """Gets the real_estate of this ETF.  # noqa: E501

        For ETFs that provide targeted real estate exposure, this field is populated if the ETF provides targeted exposure to a specific segment of the real estate market  # noqa: E501

        :return: The real_estate of this ETF.  # noqa: E501
        :rtype: str
        """
        return self._real_estate
        
    @property
    def real_estate_dict(self):
        """Gets the real_estate of this ETF.  # noqa: E501

        For ETFs that provide targeted real estate exposure, this field is populated if the ETF provides targeted exposure to a specific segment of the real estate market as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The real_estate of this ETF.  # noqa: E501
        :rtype: str
        """

        result = None

        value = self.real_estate
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'real_estate': value }

        
        return result
        

    @real_estate.setter
    def real_estate(self, real_estate):
        """Sets the real_estate of this ETF.

        For ETFs that provide targeted real estate exposure, this field is populated if the ETF provides targeted exposure to a specific segment of the real estate market  # noqa: E501

        :param real_estate: The real_estate of this ETF.  # noqa: E501
        :type: str
        """

        self._real_estate = real_estate

    @property
    def index_weighting_scheme(self):
        """Gets the index_weighting_scheme of this ETF.  # noqa: E501

        For ETFs that track an underlying index, this field provides detail on the index weighting type  # noqa: E501

        :return: The index_weighting_scheme of this ETF.  # noqa: E501
        :rtype: str
        """
        return self._index_weighting_scheme
        
    @property
    def index_weighting_scheme_dict(self):
        """Gets the index_weighting_scheme of this ETF.  # noqa: E501

        For ETFs that track an underlying index, this field provides detail on the index weighting type as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The index_weighting_scheme of this ETF.  # noqa: E501
        :rtype: str
        """

        result = None

        value = self.index_weighting_scheme
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'index_weighting_scheme': value }

        
        return result
        

    @index_weighting_scheme.setter
    def index_weighting_scheme(self, index_weighting_scheme):
        """Sets the index_weighting_scheme of this ETF.

        For ETFs that track an underlying index, this field provides detail on the index weighting type  # noqa: E501

        :param index_weighting_scheme: The index_weighting_scheme of this ETF.  # noqa: E501
        :type: str
        """

        self._index_weighting_scheme = index_weighting_scheme

    @property
    def market_cap_weighting_type(self):
        """Gets the market_cap_weighting_type of this ETF.  # noqa: E501

        For ETFs that take the value 'Market Cap Weighted' in the 'index_weighting_scheme' field, this field provides detail on the market cap weighting type  # noqa: E501

        :return: The market_cap_weighting_type of this ETF.  # noqa: E501
        :rtype: str
        """
        return self._market_cap_weighting_type
        
    @property
    def market_cap_weighting_type_dict(self):
        """Gets the market_cap_weighting_type of this ETF.  # noqa: E501

        For ETFs that take the value 'Market Cap Weighted' in the 'index_weighting_scheme' field, this field provides detail on the market cap weighting type as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The market_cap_weighting_type of this ETF.  # noqa: E501
        :rtype: str
        """

        result = None

        value = self.market_cap_weighting_type
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'market_cap_weighting_type': value }

        
        return result
        

    @market_cap_weighting_type.setter
    def market_cap_weighting_type(self, market_cap_weighting_type):
        """Sets the market_cap_weighting_type of this ETF.

        For ETFs that take the value 'Market Cap Weighted' in the 'index_weighting_scheme' field, this field provides detail on the market cap weighting type  # noqa: E501

        :param market_cap_weighting_type: The market_cap_weighting_type of this ETF.  # noqa: E501
        :type: str
        """

        self._market_cap_weighting_type = market_cap_weighting_type

    @property
    def fundamental_weighting_type(self):
        """Gets the fundamental_weighting_type of this ETF.  # noqa: E501

        For ETFs that take the value ‘Fundamental Weighted’ in the 'index_weighting_scheme' field, this field provides detail on the fundamental weighting methodology  # noqa: E501

        :return: The fundamental_weighting_type of this ETF.  # noqa: E501
        :rtype: str
        """
        return self._fundamental_weighting_type
        
    @property
    def fundamental_weighting_type_dict(self):
        """Gets the fundamental_weighting_type of this ETF.  # noqa: E501

        For ETFs that take the value ‘Fundamental Weighted’ in the 'index_weighting_scheme' field, this field provides detail on the fundamental weighting methodology as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The fundamental_weighting_type of this ETF.  # noqa: E501
        :rtype: str
        """

        result = None

        value = self.fundamental_weighting_type
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'fundamental_weighting_type': value }

        
        return result
        

    @fundamental_weighting_type.setter
    def fundamental_weighting_type(self, fundamental_weighting_type):
        """Sets the fundamental_weighting_type of this ETF.

        For ETFs that take the value ‘Fundamental Weighted’ in the 'index_weighting_scheme' field, this field provides detail on the fundamental weighting methodology  # noqa: E501

        :param fundamental_weighting_type: The fundamental_weighting_type of this ETF.  # noqa: E501
        :type: str
        """

        self._fundamental_weighting_type = fundamental_weighting_type

    @property
    def dividend_weighting_type(self):
        """Gets the dividend_weighting_type of this ETF.  # noqa: E501

        For ETFs that take the value 'Dividend Weighted' in the 'index_weighting_scheme' field, this field provides detail on the dividend weighting methodology  # noqa: E501

        :return: The dividend_weighting_type of this ETF.  # noqa: E501
        :rtype: str
        """
        return self._dividend_weighting_type
        
    @property
    def dividend_weighting_type_dict(self):
        """Gets the dividend_weighting_type of this ETF.  # noqa: E501

        For ETFs that take the value 'Dividend Weighted' in the 'index_weighting_scheme' field, this field provides detail on the dividend weighting methodology as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The dividend_weighting_type of this ETF.  # noqa: E501
        :rtype: str
        """

        result = None

        value = self.dividend_weighting_type
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'dividend_weighting_type': value }

        
        return result
        

    @dividend_weighting_type.setter
    def dividend_weighting_type(self, dividend_weighting_type):
        """Sets the dividend_weighting_type of this ETF.

        For ETFs that take the value 'Dividend Weighted' in the 'index_weighting_scheme' field, this field provides detail on the dividend weighting methodology  # noqa: E501

        :param dividend_weighting_type: The dividend_weighting_type of this ETF.  # noqa: E501
        :type: str
        """

        self._dividend_weighting_type = dividend_weighting_type

    @property
    def bond_type(self):
        """Gets the bond_type of this ETF.  # noqa: E501

        For ETFs where 'asset_class_type' is 'Bonds', this field provides detail on the type of bonds held in the ETF  # noqa: E501

        :return: The bond_type of this ETF.  # noqa: E501
        :rtype: str
        """
        return self._bond_type
        
    @property
    def bond_type_dict(self):
        """Gets the bond_type of this ETF.  # noqa: E501

        For ETFs where 'asset_class_type' is 'Bonds', this field provides detail on the type of bonds held in the ETF as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The bond_type of this ETF.  # noqa: E501
        :rtype: str
        """

        result = None

        value = self.bond_type
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'bond_type': value }

        
        return result
        

    @bond_type.setter
    def bond_type(self, bond_type):
        """Sets the bond_type of this ETF.

        For ETFs where 'asset_class_type' is 'Bonds', this field provides detail on the type of bonds held in the ETF  # noqa: E501

        :param bond_type: The bond_type of this ETF.  # noqa: E501
        :type: str
        """

        self._bond_type = bond_type

    @property
    def government_bond_types(self):
        """Gets the government_bond_types of this ETF.  # noqa: E501

        For bond ETFs that take the value 'Treasury & Government' in 'bond_type', this field provides detail on the exposure  # noqa: E501

        :return: The government_bond_types of this ETF.  # noqa: E501
        :rtype: str
        """
        return self._government_bond_types
        
    @property
    def government_bond_types_dict(self):
        """Gets the government_bond_types of this ETF.  # noqa: E501

        For bond ETFs that take the value 'Treasury & Government' in 'bond_type', this field provides detail on the exposure as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The government_bond_types of this ETF.  # noqa: E501
        :rtype: str
        """

        result = None

        value = self.government_bond_types
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'government_bond_types': value }

        
        return result
        

    @government_bond_types.setter
    def government_bond_types(self, government_bond_types):
        """Sets the government_bond_types of this ETF.

        For bond ETFs that take the value 'Treasury & Government' in 'bond_type', this field provides detail on the exposure  # noqa: E501

        :param government_bond_types: The government_bond_types of this ETF.  # noqa: E501
        :type: str
        """

        self._government_bond_types = government_bond_types

    @property
    def municipal_bond_region(self):
        """Gets the municipal_bond_region of this ETF.  # noqa: E501

        For bond ETFs that take the value 'Municipal' in 'bond_type', this field provides additional detail on the geographic exposure  # noqa: E501

        :return: The municipal_bond_region of this ETF.  # noqa: E501
        :rtype: str
        """
        return self._municipal_bond_region
        
    @property
    def municipal_bond_region_dict(self):
        """Gets the municipal_bond_region of this ETF.  # noqa: E501

        For bond ETFs that take the value 'Municipal' in 'bond_type', this field provides additional detail on the geographic exposure as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The municipal_bond_region of this ETF.  # noqa: E501
        :rtype: str
        """

        result = None

        value = self.municipal_bond_region
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'municipal_bond_region': value }

        
        return result
        

    @municipal_bond_region.setter
    def municipal_bond_region(self, municipal_bond_region):
        """Sets the municipal_bond_region of this ETF.

        For bond ETFs that take the value 'Municipal' in 'bond_type', this field provides additional detail on the geographic exposure  # noqa: E501

        :param municipal_bond_region: The municipal_bond_region of this ETF.  # noqa: E501
        :type: str
        """

        self._municipal_bond_region = municipal_bond_region

    @property
    def municipal_vrdo(self):
        """Gets the municipal_vrdo of this ETF.  # noqa: E501

        For bond ETFs that take the value 'Municipal' in 'bond_type', this field identifies those ETFs that specifically provide exposure to Variable Rate Demand Obligations  # noqa: E501

        :return: The municipal_vrdo of this ETF.  # noqa: E501
        :rtype: bool
        """
        return self._municipal_vrdo
        
    @property
    def municipal_vrdo_dict(self):
        """Gets the municipal_vrdo of this ETF.  # noqa: E501

        For bond ETFs that take the value 'Municipal' in 'bond_type', this field identifies those ETFs that specifically provide exposure to Variable Rate Demand Obligations as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The municipal_vrdo of this ETF.  # noqa: E501
        :rtype: bool
        """

        result = None

        value = self.municipal_vrdo
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'municipal_vrdo': value }

        
        return result
        

    @municipal_vrdo.setter
    def municipal_vrdo(self, municipal_vrdo):
        """Sets the municipal_vrdo of this ETF.

        For bond ETFs that take the value 'Municipal' in 'bond_type', this field identifies those ETFs that specifically provide exposure to Variable Rate Demand Obligations  # noqa: E501

        :param municipal_vrdo: The municipal_vrdo of this ETF.  # noqa: E501
        :type: bool
        """

        self._municipal_vrdo = municipal_vrdo

    @property
    def mortgage_bond_types(self):
        """Gets the mortgage_bond_types of this ETF.  # noqa: E501

        For bond ETFs that take the value 'Mortgage' in 'bond_type', this field provides additional detail on the type of underlying securities  # noqa: E501

        :return: The mortgage_bond_types of this ETF.  # noqa: E501
        :rtype: str
        """
        return self._mortgage_bond_types
        
    @property
    def mortgage_bond_types_dict(self):
        """Gets the mortgage_bond_types of this ETF.  # noqa: E501

        For bond ETFs that take the value 'Mortgage' in 'bond_type', this field provides additional detail on the type of underlying securities as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The mortgage_bond_types of this ETF.  # noqa: E501
        :rtype: str
        """

        result = None

        value = self.mortgage_bond_types
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'mortgage_bond_types': value }

        
        return result
        

    @mortgage_bond_types.setter
    def mortgage_bond_types(self, mortgage_bond_types):
        """Sets the mortgage_bond_types of this ETF.

        For bond ETFs that take the value 'Mortgage' in 'bond_type', this field provides additional detail on the type of underlying securities  # noqa: E501

        :param mortgage_bond_types: The mortgage_bond_types of this ETF.  # noqa: E501
        :type: str
        """

        self._mortgage_bond_types = mortgage_bond_types

    @property
    def bond_tax_status(self):
        """Gets the bond_tax_status of this ETF.  # noqa: E501

        For all US bond ETFs, this field provides additional detail on the tax treatment of the underlying securities  # noqa: E501

        :return: The bond_tax_status of this ETF.  # noqa: E501
        :rtype: str
        """
        return self._bond_tax_status
        
    @property
    def bond_tax_status_dict(self):
        """Gets the bond_tax_status of this ETF.  # noqa: E501

        For all US bond ETFs, this field provides additional detail on the tax treatment of the underlying securities as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The bond_tax_status of this ETF.  # noqa: E501
        :rtype: str
        """

        result = None

        value = self.bond_tax_status
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'bond_tax_status': value }

        
        return result
        

    @bond_tax_status.setter
    def bond_tax_status(self, bond_tax_status):
        """Sets the bond_tax_status of this ETF.

        For all US bond ETFs, this field provides additional detail on the tax treatment of the underlying securities  # noqa: E501

        :param bond_tax_status: The bond_tax_status of this ETF.  # noqa: E501
        :type: str
        """

        self._bond_tax_status = bond_tax_status

    @property
    def credit_quality(self):
        """Gets the credit_quality of this ETF.  # noqa: E501

        For all bond ETFs, this field helps to identify if the ETF provides targeted exposure to securities of a specific credit quality range  # noqa: E501

        :return: The credit_quality of this ETF.  # noqa: E501
        :rtype: str
        """
        return self._credit_quality
        
    @property
    def credit_quality_dict(self):
        """Gets the credit_quality of this ETF.  # noqa: E501

        For all bond ETFs, this field helps to identify if the ETF provides targeted exposure to securities of a specific credit quality range as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The credit_quality of this ETF.  # noqa: E501
        :rtype: str
        """

        result = None

        value = self.credit_quality
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'credit_quality': value }

        
        return result
        

    @credit_quality.setter
    def credit_quality(self, credit_quality):
        """Sets the credit_quality of this ETF.

        For all bond ETFs, this field helps to identify if the ETF provides targeted exposure to securities of a specific credit quality range  # noqa: E501

        :param credit_quality: The credit_quality of this ETF.  # noqa: E501
        :type: str
        """

        self._credit_quality = credit_quality

    @property
    def average_maturity(self):
        """Gets the average_maturity of this ETF.  # noqa: E501

        For all bond ETFs, this field helps to identify if the ETF provides targeted exposure to securities of a specific maturity range  # noqa: E501

        :return: The average_maturity of this ETF.  # noqa: E501
        :rtype: str
        """
        return self._average_maturity
        
    @property
    def average_maturity_dict(self):
        """Gets the average_maturity of this ETF.  # noqa: E501

        For all bond ETFs, this field helps to identify if the ETF provides targeted exposure to securities of a specific maturity range as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The average_maturity of this ETF.  # noqa: E501
        :rtype: str
        """

        result = None

        value = self.average_maturity
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'average_maturity': value }

        
        return result
        

    @average_maturity.setter
    def average_maturity(self, average_maturity):
        """Sets the average_maturity of this ETF.

        For all bond ETFs, this field helps to identify if the ETF provides targeted exposure to securities of a specific maturity range  # noqa: E501

        :param average_maturity: The average_maturity of this ETF.  # noqa: E501
        :type: str
        """

        self._average_maturity = average_maturity

    @property
    def specific_maturity_year(self):
        """Gets the specific_maturity_year of this ETF.  # noqa: E501

        For all bond ETFs that take the value 'Specific Maturity Year' in the 'average_maturity' field, this field specifies the calendar year  # noqa: E501

        :return: The specific_maturity_year of this ETF.  # noqa: E501
        :rtype: int
        """
        return self._specific_maturity_year
        
    @property
    def specific_maturity_year_dict(self):
        """Gets the specific_maturity_year of this ETF.  # noqa: E501

        For all bond ETFs that take the value 'Specific Maturity Year' in the 'average_maturity' field, this field specifies the calendar year as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The specific_maturity_year of this ETF.  # noqa: E501
        :rtype: int
        """

        result = None

        value = self.specific_maturity_year
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'specific_maturity_year': value }

        
        return result
        

    @specific_maturity_year.setter
    def specific_maturity_year(self, specific_maturity_year):
        """Sets the specific_maturity_year of this ETF.

        For all bond ETFs that take the value 'Specific Maturity Year' in the 'average_maturity' field, this field specifies the calendar year  # noqa: E501

        :param specific_maturity_year: The specific_maturity_year of this ETF.  # noqa: E501
        :type: int
        """

        self._specific_maturity_year = specific_maturity_year

    @property
    def bond_currency_denomination(self):
        """Gets the bond_currency_denomination of this ETF.  # noqa: E501

        For all bond ETFs, this field provides additional detail on the currency denomination of the underlying securities  # noqa: E501

        :return: The bond_currency_denomination of this ETF.  # noqa: E501
        :rtype: str
        """
        return self._bond_currency_denomination
        
    @property
    def bond_currency_denomination_dict(self):
        """Gets the bond_currency_denomination of this ETF.  # noqa: E501

        For all bond ETFs, this field provides additional detail on the currency denomination of the underlying securities as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The bond_currency_denomination of this ETF.  # noqa: E501
        :rtype: str
        """

        result = None

        value = self.bond_currency_denomination
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'bond_currency_denomination': value }

        
        return result
        

    @bond_currency_denomination.setter
    def bond_currency_denomination(self, bond_currency_denomination):
        """Sets the bond_currency_denomination of this ETF.

        For all bond ETFs, this field provides additional detail on the currency denomination of the underlying securities  # noqa: E501

        :param bond_currency_denomination: The bond_currency_denomination of this ETF.  # noqa: E501
        :type: str
        """

        self._bond_currency_denomination = bond_currency_denomination

    @property
    def laddered(self):
        """Gets the laddered of this ETF.  # noqa: E501

        For bond ETFs, this field identifies those ETFs that specifically hold bonds in a laddered structure, where the bonds are scheduled to mature in an annual, sequential structure  # noqa: E501

        :return: The laddered of this ETF.  # noqa: E501
        :rtype: bool
        """
        return self._laddered
        
    @property
    def laddered_dict(self):
        """Gets the laddered of this ETF.  # noqa: E501

        For bond ETFs, this field identifies those ETFs that specifically hold bonds in a laddered structure, where the bonds are scheduled to mature in an annual, sequential structure as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The laddered of this ETF.  # noqa: E501
        :rtype: bool
        """

        result = None

        value = self.laddered
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'laddered': value }

        
        return result
        

    @laddered.setter
    def laddered(self, laddered):
        """Sets the laddered of this ETF.

        For bond ETFs, this field identifies those ETFs that specifically hold bonds in a laddered structure, where the bonds are scheduled to mature in an annual, sequential structure  # noqa: E501

        :param laddered: The laddered of this ETF.  # noqa: E501
        :type: bool
        """

        self._laddered = laddered

    @property
    def zero_coupon(self):
        """Gets the zero_coupon of this ETF.  # noqa: E501

        For bond ETFs, this field identifies those ETFs that specifically hold zero coupon Treasury Bills  # noqa: E501

        :return: The zero_coupon of this ETF.  # noqa: E501
        :rtype: bool
        """
        return self._zero_coupon
        
    @property
    def zero_coupon_dict(self):
        """Gets the zero_coupon of this ETF.  # noqa: E501

        For bond ETFs, this field identifies those ETFs that specifically hold zero coupon Treasury Bills as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The zero_coupon of this ETF.  # noqa: E501
        :rtype: bool
        """

        result = None

        value = self.zero_coupon
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'zero_coupon': value }

        
        return result
        

    @zero_coupon.setter
    def zero_coupon(self, zero_coupon):
        """Sets the zero_coupon of this ETF.

        For bond ETFs, this field identifies those ETFs that specifically hold zero coupon Treasury Bills  # noqa: E501

        :param zero_coupon: The zero_coupon of this ETF.  # noqa: E501
        :type: bool
        """

        self._zero_coupon = zero_coupon

    @property
    def floating_rate(self):
        """Gets the floating_rate of this ETF.  # noqa: E501

        For bond ETFs, this field identifies those ETFs that specifically hold floating rate bonds  # noqa: E501

        :return: The floating_rate of this ETF.  # noqa: E501
        :rtype: bool
        """
        return self._floating_rate
        
    @property
    def floating_rate_dict(self):
        """Gets the floating_rate of this ETF.  # noqa: E501

        For bond ETFs, this field identifies those ETFs that specifically hold floating rate bonds as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The floating_rate of this ETF.  # noqa: E501
        :rtype: bool
        """

        result = None

        value = self.floating_rate
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'floating_rate': value }

        
        return result
        

    @floating_rate.setter
    def floating_rate(self, floating_rate):
        """Sets the floating_rate of this ETF.

        For bond ETFs, this field identifies those ETFs that specifically hold floating rate bonds  # noqa: E501

        :param floating_rate: The floating_rate of this ETF.  # noqa: E501
        :type: bool
        """

        self._floating_rate = floating_rate

    @property
    def build_america_bonds(self):
        """Gets the build_america_bonds of this ETF.  # noqa: E501

        For municipal bond ETFs, this field identifies those ETFs that specifically hold Build America Bonds  # noqa: E501

        :return: The build_america_bonds of this ETF.  # noqa: E501
        :rtype: bool
        """
        return self._build_america_bonds
        
    @property
    def build_america_bonds_dict(self):
        """Gets the build_america_bonds of this ETF.  # noqa: E501

        For municipal bond ETFs, this field identifies those ETFs that specifically hold Build America Bonds as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The build_america_bonds of this ETF.  # noqa: E501
        :rtype: bool
        """

        result = None

        value = self.build_america_bonds
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'build_america_bonds': value }

        
        return result
        

    @build_america_bonds.setter
    def build_america_bonds(self, build_america_bonds):
        """Sets the build_america_bonds of this ETF.

        For municipal bond ETFs, this field identifies those ETFs that specifically hold Build America Bonds  # noqa: E501

        :param build_america_bonds: The build_america_bonds of this ETF.  # noqa: E501
        :type: bool
        """

        self._build_america_bonds = build_america_bonds

    @property
    def commodity_types(self):
        """Gets the commodity_types of this ETF.  # noqa: E501

        For ETFs where 'asset_class_type' is 'Commodities', this field provides detail on the type of commodities held in the ETF  # noqa: E501

        :return: The commodity_types of this ETF.  # noqa: E501
        :rtype: str
        """
        return self._commodity_types
        
    @property
    def commodity_types_dict(self):
        """Gets the commodity_types of this ETF.  # noqa: E501

        For ETFs where 'asset_class_type' is 'Commodities', this field provides detail on the type of commodities held in the ETF as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The commodity_types of this ETF.  # noqa: E501
        :rtype: str
        """

        result = None

        value = self.commodity_types
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'commodity_types': value }

        
        return result
        

    @commodity_types.setter
    def commodity_types(self, commodity_types):
        """Sets the commodity_types of this ETF.

        For ETFs where 'asset_class_type' is 'Commodities', this field provides detail on the type of commodities held in the ETF  # noqa: E501

        :param commodity_types: The commodity_types of this ETF.  # noqa: E501
        :type: str
        """

        self._commodity_types = commodity_types

    @property
    def energy_type(self):
        """Gets the energy_type of this ETF.  # noqa: E501

        For ETFs where 'commodity_type' is 'Energy', this field provides detail on the type of energy exposure provided by the ETF  # noqa: E501

        :return: The energy_type of this ETF.  # noqa: E501
        :rtype: str
        """
        return self._energy_type
        
    @property
    def energy_type_dict(self):
        """Gets the energy_type of this ETF.  # noqa: E501

        For ETFs where 'commodity_type' is 'Energy', this field provides detail on the type of energy exposure provided by the ETF as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The energy_type of this ETF.  # noqa: E501
        :rtype: str
        """

        result = None

        value = self.energy_type
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'energy_type': value }

        
        return result
        

    @energy_type.setter
    def energy_type(self, energy_type):
        """Sets the energy_type of this ETF.

        For ETFs where 'commodity_type' is 'Energy', this field provides detail on the type of energy exposure provided by the ETF  # noqa: E501

        :param energy_type: The energy_type of this ETF.  # noqa: E501
        :type: str
        """

        self._energy_type = energy_type

    @property
    def agricultural_type(self):
        """Gets the agricultural_type of this ETF.  # noqa: E501

        For ETFs where 'commodity_type' is 'Agricultural', this field provides detail on the type of agricultural exposure provided by the ETF  # noqa: E501

        :return: The agricultural_type of this ETF.  # noqa: E501
        :rtype: str
        """
        return self._agricultural_type
        
    @property
    def agricultural_type_dict(self):
        """Gets the agricultural_type of this ETF.  # noqa: E501

        For ETFs where 'commodity_type' is 'Agricultural', this field provides detail on the type of agricultural exposure provided by the ETF as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The agricultural_type of this ETF.  # noqa: E501
        :rtype: str
        """

        result = None

        value = self.agricultural_type
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'agricultural_type': value }

        
        return result
        

    @agricultural_type.setter
    def agricultural_type(self, agricultural_type):
        """Sets the agricultural_type of this ETF.

        For ETFs where 'commodity_type' is 'Agricultural', this field provides detail on the type of agricultural exposure provided by the ETF  # noqa: E501

        :param agricultural_type: The agricultural_type of this ETF.  # noqa: E501
        :type: str
        """

        self._agricultural_type = agricultural_type

    @property
    def metal_type(self):
        """Gets the metal_type of this ETF.  # noqa: E501

        For ETFs where 'commodity_type' is 'Gold & Metals', this field provides detail on the type of exposure provided by the ETF  # noqa: E501

        :return: The metal_type of this ETF.  # noqa: E501
        :rtype: str
        """
        return self._metal_type
        
    @property
    def metal_type_dict(self):
        """Gets the metal_type of this ETF.  # noqa: E501

        For ETFs where 'commodity_type' is 'Gold & Metals', this field provides detail on the type of exposure provided by the ETF as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The metal_type of this ETF.  # noqa: E501
        :rtype: str
        """

        result = None

        value = self.metal_type
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'metal_type': value }

        
        return result
        

    @metal_type.setter
    def metal_type(self, metal_type):
        """Sets the metal_type of this ETF.

        For ETFs where 'commodity_type' is 'Gold & Metals', this field provides detail on the type of exposure provided by the ETF  # noqa: E501

        :param metal_type: The metal_type of this ETF.  # noqa: E501
        :type: str
        """

        self._metal_type = metal_type

    @property
    def inverse_leveraged(self):
        """Gets the inverse_leveraged of this ETF.  # noqa: E501

        This field is populated if the ETF provides inverse or leveraged exposure  # noqa: E501

        :return: The inverse_leveraged of this ETF.  # noqa: E501
        :rtype: str
        """
        return self._inverse_leveraged
        
    @property
    def inverse_leveraged_dict(self):
        """Gets the inverse_leveraged of this ETF.  # noqa: E501

        This field is populated if the ETF provides inverse or leveraged exposure as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The inverse_leveraged of this ETF.  # noqa: E501
        :rtype: str
        """

        result = None

        value = self.inverse_leveraged
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'inverse_leveraged': value }

        
        return result
        

    @inverse_leveraged.setter
    def inverse_leveraged(self, inverse_leveraged):
        """Sets the inverse_leveraged of this ETF.

        This field is populated if the ETF provides inverse or leveraged exposure  # noqa: E501

        :param inverse_leveraged: The inverse_leveraged of this ETF.  # noqa: E501
        :type: str
        """

        self._inverse_leveraged = inverse_leveraged

    @property
    def target_date_multi_asset_type(self):
        """Gets the target_date_multi_asset_type of this ETF.  # noqa: E501

        For ETFs where 'asset_class_type' is 'Target Date / MultiAsset', this field provides detail on the type of commodities held in the ETF  # noqa: E501

        :return: The target_date_multi_asset_type of this ETF.  # noqa: E501
        :rtype: str
        """
        return self._target_date_multi_asset_type
        
    @property
    def target_date_multi_asset_type_dict(self):
        """Gets the target_date_multi_asset_type of this ETF.  # noqa: E501

        For ETFs where 'asset_class_type' is 'Target Date / MultiAsset', this field provides detail on the type of commodities held in the ETF as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The target_date_multi_asset_type of this ETF.  # noqa: E501
        :rtype: str
        """

        result = None

        value = self.target_date_multi_asset_type
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'target_date_multi_asset_type': value }

        
        return result
        

    @target_date_multi_asset_type.setter
    def target_date_multi_asset_type(self, target_date_multi_asset_type):
        """Sets the target_date_multi_asset_type of this ETF.

        For ETFs where 'asset_class_type' is 'Target Date / MultiAsset', this field provides detail on the type of commodities held in the ETF  # noqa: E501

        :param target_date_multi_asset_type: The target_date_multi_asset_type of this ETF.  # noqa: E501
        :type: str
        """

        self._target_date_multi_asset_type = target_date_multi_asset_type

    @property
    def currency_hedged(self):
        """Gets the currency_hedged of this ETF.  # noqa: E501

        This field is populated if the ETF’s strategy involves hedging currency exposure  # noqa: E501

        :return: The currency_hedged of this ETF.  # noqa: E501
        :rtype: bool
        """
        return self._currency_hedged
        
    @property
    def currency_hedged_dict(self):
        """Gets the currency_hedged of this ETF.  # noqa: E501

        This field is populated if the ETF’s strategy involves hedging currency exposure as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The currency_hedged of this ETF.  # noqa: E501
        :rtype: bool
        """

        result = None

        value = self.currency_hedged
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'currency_hedged': value }

        
        return result
        

    @currency_hedged.setter
    def currency_hedged(self, currency_hedged):
        """Sets the currency_hedged of this ETF.

        This field is populated if the ETF’s strategy involves hedging currency exposure  # noqa: E501

        :param currency_hedged: The currency_hedged of this ETF.  # noqa: E501
        :type: bool
        """

        self._currency_hedged = currency_hedged

    @property
    def currency_pair(self):
        """Gets the currency_pair of this ETF.  # noqa: E501

        This field is populated if the ETF’s strategy involves providing exposure to the movements of a currency or involves hedging currency exposure  # noqa: E501

        :return: The currency_pair of this ETF.  # noqa: E501
        :rtype: str
        """
        return self._currency_pair
        
    @property
    def currency_pair_dict(self):
        """Gets the currency_pair of this ETF.  # noqa: E501

        This field is populated if the ETF’s strategy involves providing exposure to the movements of a currency or involves hedging currency exposure as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The currency_pair of this ETF.  # noqa: E501
        :rtype: str
        """

        result = None

        value = self.currency_pair
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'currency_pair': value }

        
        return result
        

    @currency_pair.setter
    def currency_pair(self, currency_pair):
        """Sets the currency_pair of this ETF.

        This field is populated if the ETF’s strategy involves providing exposure to the movements of a currency or involves hedging currency exposure  # noqa: E501

        :param currency_pair: The currency_pair of this ETF.  # noqa: E501
        :type: str
        """

        self._currency_pair = currency_pair

    @property
    def social_environmental_type(self):
        """Gets the social_environmental_type of this ETF.  # noqa: E501

        This field is populated if the ETF’s strategy involves providing exposure to a specific social or environmental theme  # noqa: E501

        :return: The social_environmental_type of this ETF.  # noqa: E501
        :rtype: str
        """
        return self._social_environmental_type
        
    @property
    def social_environmental_type_dict(self):
        """Gets the social_environmental_type of this ETF.  # noqa: E501

        This field is populated if the ETF’s strategy involves providing exposure to a specific social or environmental theme as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The social_environmental_type of this ETF.  # noqa: E501
        :rtype: str
        """

        result = None

        value = self.social_environmental_type
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'social_environmental_type': value }

        
        return result
        

    @social_environmental_type.setter
    def social_environmental_type(self, social_environmental_type):
        """Sets the social_environmental_type of this ETF.

        This field is populated if the ETF’s strategy involves providing exposure to a specific social or environmental theme  # noqa: E501

        :param social_environmental_type: The social_environmental_type of this ETF.  # noqa: E501
        :type: str
        """

        self._social_environmental_type = social_environmental_type

    @property
    def clean_energy_type(self):
        """Gets the clean_energy_type of this ETF.  # noqa: E501

        This field is populated if the ETF has a value of 'Clean Energy' in the 'social_environmental_type' field.  # noqa: E501

        :return: The clean_energy_type of this ETF.  # noqa: E501
        :rtype: str
        """
        return self._clean_energy_type
        
    @property
    def clean_energy_type_dict(self):
        """Gets the clean_energy_type of this ETF.  # noqa: E501

        This field is populated if the ETF has a value of 'Clean Energy' in the 'social_environmental_type' field. as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The clean_energy_type of this ETF.  # noqa: E501
        :rtype: str
        """

        result = None

        value = self.clean_energy_type
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'clean_energy_type': value }

        
        return result
        

    @clean_energy_type.setter
    def clean_energy_type(self, clean_energy_type):
        """Sets the clean_energy_type of this ETF.

        This field is populated if the ETF has a value of 'Clean Energy' in the 'social_environmental_type' field.  # noqa: E501

        :param clean_energy_type: The clean_energy_type of this ETF.  # noqa: E501
        :type: str
        """

        self._clean_energy_type = clean_energy_type

    @property
    def dividend_type(self):
        """Gets the dividend_type of this ETF.  # noqa: E501

        This field is populated if the ETF has an intended investment objective of holding dividend-oriented stocks as stated in the prospectus  # noqa: E501

        :return: The dividend_type of this ETF.  # noqa: E501
        :rtype: str
        """
        return self._dividend_type
        
    @property
    def dividend_type_dict(self):
        """Gets the dividend_type of this ETF.  # noqa: E501

        This field is populated if the ETF has an intended investment objective of holding dividend-oriented stocks as stated in the prospectus as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The dividend_type of this ETF.  # noqa: E501
        :rtype: str
        """

        result = None

        value = self.dividend_type
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'dividend_type': value }

        
        return result
        

    @dividend_type.setter
    def dividend_type(self, dividend_type):
        """Sets the dividend_type of this ETF.

        This field is populated if the ETF has an intended investment objective of holding dividend-oriented stocks as stated in the prospectus  # noqa: E501

        :param dividend_type: The dividend_type of this ETF.  # noqa: E501
        :type: str
        """

        self._dividend_type = dividend_type

    @property
    def regular_dividend_payor_type(self):
        """Gets the regular_dividend_payor_type of this ETF.  # noqa: E501

        This field is populated if the ETF has a value of 'Dividend – Regular Payors' in the 'dividend_type' field  # noqa: E501

        :return: The regular_dividend_payor_type of this ETF.  # noqa: E501
        :rtype: str
        """
        return self._regular_dividend_payor_type
        
    @property
    def regular_dividend_payor_type_dict(self):
        """Gets the regular_dividend_payor_type of this ETF.  # noqa: E501

        This field is populated if the ETF has a value of 'Dividend – Regular Payors' in the 'dividend_type' field as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The regular_dividend_payor_type of this ETF.  # noqa: E501
        :rtype: str
        """

        result = None

        value = self.regular_dividend_payor_type
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'regular_dividend_payor_type': value }

        
        return result
        

    @regular_dividend_payor_type.setter
    def regular_dividend_payor_type(self, regular_dividend_payor_type):
        """Sets the regular_dividend_payor_type of this ETF.

        This field is populated if the ETF has a value of 'Dividend – Regular Payors' in the 'dividend_type' field  # noqa: E501

        :param regular_dividend_payor_type: The regular_dividend_payor_type of this ETF.  # noqa: E501
        :type: str
        """

        self._regular_dividend_payor_type = regular_dividend_payor_type

    @property
    def holds_ml_ps(self):
        """Gets the holds_ml_ps of this ETF.  # noqa: E501

        If true, the ETF’s investment objective explicitly specifies that it holds MLPs as an intended part of its investment strategy  # noqa: E501

        :return: The holds_ml_ps of this ETF.  # noqa: E501
        :rtype: bool
        """
        return self._holds_ml_ps
        
    @property
    def holds_ml_ps_dict(self):
        """Gets the holds_ml_ps of this ETF.  # noqa: E501

        If true, the ETF’s investment objective explicitly specifies that it holds MLPs as an intended part of its investment strategy as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The holds_ml_ps of this ETF.  # noqa: E501
        :rtype: bool
        """

        result = None

        value = self.holds_ml_ps
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'holds_ml_ps': value }

        
        return result
        

    @holds_ml_ps.setter
    def holds_ml_ps(self, holds_ml_ps):
        """Sets the holds_ml_ps of this ETF.

        If true, the ETF’s investment objective explicitly specifies that it holds MLPs as an intended part of its investment strategy  # noqa: E501

        :param holds_ml_ps: The holds_ml_ps of this ETF.  # noqa: E501
        :type: bool
        """

        self._holds_ml_ps = holds_ml_ps

    @property
    def holds_preferred_stock(self):
        """Gets the holds_preferred_stock of this ETF.  # noqa: E501

        If true, the ETF’s investment objective explicitly specifies that it holds preferred stock as an intended part of its investment strategy  # noqa: E501

        :return: The holds_preferred_stock of this ETF.  # noqa: E501
        :rtype: bool
        """
        return self._holds_preferred_stock
        
    @property
    def holds_preferred_stock_dict(self):
        """Gets the holds_preferred_stock of this ETF.  # noqa: E501

        If true, the ETF’s investment objective explicitly specifies that it holds preferred stock as an intended part of its investment strategy as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The holds_preferred_stock of this ETF.  # noqa: E501
        :rtype: bool
        """

        result = None

        value = self.holds_preferred_stock
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'holds_preferred_stock': value }

        
        return result
        

    @holds_preferred_stock.setter
    def holds_preferred_stock(self, holds_preferred_stock):
        """Sets the holds_preferred_stock of this ETF.

        If true, the ETF’s investment objective explicitly specifies that it holds preferred stock as an intended part of its investment strategy  # noqa: E501

        :param holds_preferred_stock: The holds_preferred_stock of this ETF.  # noqa: E501
        :type: bool
        """

        self._holds_preferred_stock = holds_preferred_stock

    @property
    def holds_closed_end_funds(self):
        """Gets the holds_closed_end_funds of this ETF.  # noqa: E501

        IF true, if the ETF’s investment objective explicitly specifies that it holds closed end funds as an intended part of its investment strategy  # noqa: E501

        :return: The holds_closed_end_funds of this ETF.  # noqa: E501
        :rtype: bool
        """
        return self._holds_closed_end_funds
        
    @property
    def holds_closed_end_funds_dict(self):
        """Gets the holds_closed_end_funds of this ETF.  # noqa: E501

        IF true, if the ETF’s investment objective explicitly specifies that it holds closed end funds as an intended part of its investment strategy as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The holds_closed_end_funds of this ETF.  # noqa: E501
        :rtype: bool
        """

        result = None

        value = self.holds_closed_end_funds
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'holds_closed_end_funds': value }

        
        return result
        

    @holds_closed_end_funds.setter
    def holds_closed_end_funds(self, holds_closed_end_funds):
        """Sets the holds_closed_end_funds of this ETF.

        IF true, if the ETF’s investment objective explicitly specifies that it holds closed end funds as an intended part of its investment strategy  # noqa: E501

        :param holds_closed_end_funds: The holds_closed_end_funds of this ETF.  # noqa: E501
        :type: bool
        """

        self._holds_closed_end_funds = holds_closed_end_funds

    @property
    def quant_strategies_type(self):
        """Gets the quant_strategies_type of this ETF.  # noqa: E501

        This field is populated if the ETF has either an index-linked or active strategy that is based on a proprietary quantitative strategy  # noqa: E501

        :return: The quant_strategies_type of this ETF.  # noqa: E501
        :rtype: str
        """
        return self._quant_strategies_type
        
    @property
    def quant_strategies_type_dict(self):
        """Gets the quant_strategies_type of this ETF.  # noqa: E501

        This field is populated if the ETF has either an index-linked or active strategy that is based on a proprietary quantitative strategy as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The quant_strategies_type of this ETF.  # noqa: E501
        :rtype: str
        """

        result = None

        value = self.quant_strategies_type
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'quant_strategies_type': value }

        
        return result
        

    @quant_strategies_type.setter
    def quant_strategies_type(self, quant_strategies_type):
        """Sets the quant_strategies_type of this ETF.

        This field is populated if the ETF has either an index-linked or active strategy that is based on a proprietary quantitative strategy  # noqa: E501

        :param quant_strategies_type: The quant_strategies_type of this ETF.  # noqa: E501
        :type: str
        """

        self._quant_strategies_type = quant_strategies_type

    @property
    def other_quant_models(self):
        """Gets the other_quant_models of this ETF.  # noqa: E501

        For ETFs where 'quant_strategies_type' is 'Other Quant Model', this field provides the name of the specific proprietary quant model used as the underlying strategy for the ETF  # noqa: E501

        :return: The other_quant_models of this ETF.  # noqa: E501
        :rtype: str
        """
        return self._other_quant_models
        
    @property
    def other_quant_models_dict(self):
        """Gets the other_quant_models of this ETF.  # noqa: E501

        For ETFs where 'quant_strategies_type' is 'Other Quant Model', this field provides the name of the specific proprietary quant model used as the underlying strategy for the ETF as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The other_quant_models of this ETF.  # noqa: E501
        :rtype: str
        """

        result = None

        value = self.other_quant_models
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'other_quant_models': value }

        
        return result
        

    @other_quant_models.setter
    def other_quant_models(self, other_quant_models):
        """Sets the other_quant_models of this ETF.

        For ETFs where 'quant_strategies_type' is 'Other Quant Model', this field provides the name of the specific proprietary quant model used as the underlying strategy for the ETF  # noqa: E501

        :param other_quant_models: The other_quant_models of this ETF.  # noqa: E501
        :type: str
        """

        self._other_quant_models = other_quant_models

    @property
    def hedge_fund_type(self):
        """Gets the hedge_fund_type of this ETF.  # noqa: E501

        For ETFs where 'other_asset_types' is 'Hedge Fund Replication', this field provides detail on the type of hedge fund replication strategy  # noqa: E501

        :return: The hedge_fund_type of this ETF.  # noqa: E501
        :rtype: str
        """
        return self._hedge_fund_type
        
    @property
    def hedge_fund_type_dict(self):
        """Gets the hedge_fund_type of this ETF.  # noqa: E501

        For ETFs where 'other_asset_types' is 'Hedge Fund Replication', this field provides detail on the type of hedge fund replication strategy as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The hedge_fund_type of this ETF.  # noqa: E501
        :rtype: str
        """

        result = None

        value = self.hedge_fund_type
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'hedge_fund_type': value }

        
        return result
        

    @hedge_fund_type.setter
    def hedge_fund_type(self, hedge_fund_type):
        """Sets the hedge_fund_type of this ETF.

        For ETFs where 'other_asset_types' is 'Hedge Fund Replication', this field provides detail on the type of hedge fund replication strategy  # noqa: E501

        :param hedge_fund_type: The hedge_fund_type of this ETF.  # noqa: E501
        :type: str
        """

        self._hedge_fund_type = hedge_fund_type

    @property
    def derivatives_based(self):
        """Gets the derivatives_based of this ETF.  # noqa: E501

        This field is populated if the ETF holds either listed or over-the-counter derivatives in its portfolio  # noqa: E501

        :return: The derivatives_based of this ETF.  # noqa: E501
        :rtype: str
        """
        return self._derivatives_based
        
    @property
    def derivatives_based_dict(self):
        """Gets the derivatives_based of this ETF.  # noqa: E501

        This field is populated if the ETF holds either listed or over-the-counter derivatives in its portfolio as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The derivatives_based of this ETF.  # noqa: E501
        :rtype: str
        """

        result = None

        value = self.derivatives_based
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'derivatives_based': value }

        
        return result
        

    @derivatives_based.setter
    def derivatives_based(self, derivatives_based):
        """Sets the derivatives_based of this ETF.

        This field is populated if the ETF holds either listed or over-the-counter derivatives in its portfolio  # noqa: E501

        :param derivatives_based: The derivatives_based of this ETF.  # noqa: E501
        :type: str
        """

        self._derivatives_based = derivatives_based

    @property
    def holds_ad_rs(self):
        """Gets the holds_ad_rs of this ETF.  # noqa: E501

        If true, he ETF’s investment objective explicitly specifies that it holds American Depositary Receipts (ADRs) as an intended part of its investment strategy  # noqa: E501

        :return: The holds_ad_rs of this ETF.  # noqa: E501
        :rtype: bool
        """
        return self._holds_ad_rs
        
    @property
    def holds_ad_rs_dict(self):
        """Gets the holds_ad_rs of this ETF.  # noqa: E501

        If true, he ETF’s investment objective explicitly specifies that it holds American Depositary Receipts (ADRs) as an intended part of its investment strategy as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The holds_ad_rs of this ETF.  # noqa: E501
        :rtype: bool
        """

        result = None

        value = self.holds_ad_rs
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'holds_ad_rs': value }

        
        return result
        

    @holds_ad_rs.setter
    def holds_ad_rs(self, holds_ad_rs):
        """Sets the holds_ad_rs of this ETF.

        If true, he ETF’s investment objective explicitly specifies that it holds American Depositary Receipts (ADRs) as an intended part of its investment strategy  # noqa: E501

        :param holds_ad_rs: The holds_ad_rs of this ETF.  # noqa: E501
        :type: bool
        """

        self._holds_ad_rs = holds_ad_rs

    @property
    def index_linked(self):
        """Gets the index_linked of this ETF.  # noqa: E501

        This field identifies whether an ETF is index linked or active  # noqa: E501

        :return: The index_linked of this ETF.  # noqa: E501
        :rtype: str
        """
        return self._index_linked
        
    @property
    def index_linked_dict(self):
        """Gets the index_linked of this ETF.  # noqa: E501

        This field identifies whether an ETF is index linked or active as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The index_linked of this ETF.  # noqa: E501
        :rtype: str
        """

        result = None

        value = self.index_linked
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'index_linked': value }

        
        return result
        

    @index_linked.setter
    def index_linked(self, index_linked):
        """Sets the index_linked of this ETF.

        This field identifies whether an ETF is index linked or active  # noqa: E501

        :param index_linked: The index_linked of this ETF.  # noqa: E501
        :type: str
        """

        self._index_linked = index_linked

    @property
    def includes_short_exposure(self):
        """Gets the includes_short_exposure of this ETF.  # noqa: E501

        This field is populated if the ETF has short exposure in any of its holdings e.g. in a long/short or inverse ETF  # noqa: E501

        :return: The includes_short_exposure of this ETF.  # noqa: E501
        :rtype: bool
        """
        return self._includes_short_exposure
        
    @property
    def includes_short_exposure_dict(self):
        """Gets the includes_short_exposure of this ETF.  # noqa: E501

        This field is populated if the ETF has short exposure in any of its holdings e.g. in a long/short or inverse ETF as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The includes_short_exposure of this ETF.  # noqa: E501
        :rtype: bool
        """

        result = None

        value = self.includes_short_exposure
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'includes_short_exposure': value }

        
        return result
        

    @includes_short_exposure.setter
    def includes_short_exposure(self, includes_short_exposure):
        """Sets the includes_short_exposure of this ETF.

        This field is populated if the ETF has short exposure in any of its holdings e.g. in a long/short or inverse ETF  # noqa: E501

        :param includes_short_exposure: The includes_short_exposure of this ETF.  # noqa: E501
        :type: bool
        """

        self._includes_short_exposure = includes_short_exposure

    @property
    def index_name(self):
        """Gets the index_name of this ETF.  # noqa: E501

        This field identifies the name of the underlying index tracked by the ETF, if applicable  # noqa: E501

        :return: The index_name of this ETF.  # noqa: E501
        :rtype: str
        """
        return self._index_name
        
    @property
    def index_name_dict(self):
        """Gets the index_name of this ETF.  # noqa: E501

        This field identifies the name of the underlying index tracked by the ETF, if applicable as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The index_name of this ETF.  # noqa: E501
        :rtype: str
        """

        result = None

        value = self.index_name
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'index_name': value }

        
        return result
        

    @index_name.setter
    def index_name(self, index_name):
        """Sets the index_name of this ETF.

        This field identifies the name of the underlying index tracked by the ETF, if applicable  # noqa: E501

        :param index_name: The index_name of this ETF.  # noqa: E501
        :type: str
        """

        self._index_name = index_name

    @property
    def parent_index(self):
        """Gets the parent_index of this ETF.  # noqa: E501

        This field identifies the name of the parent index, which represents the broader universe from which the index underlying the ETF is created, if applicable  # noqa: E501

        :return: The parent_index of this ETF.  # noqa: E501
        :rtype: str
        """
        return self._parent_index
        
    @property
    def parent_index_dict(self):
        """Gets the parent_index of this ETF.  # noqa: E501

        This field identifies the name of the parent index, which represents the broader universe from which the index underlying the ETF is created, if applicable as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The parent_index of this ETF.  # noqa: E501
        :rtype: str
        """

        result = None

        value = self.parent_index
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'parent_index': value }

        
        return result
        

    @parent_index.setter
    def parent_index(self, parent_index):
        """Sets the parent_index of this ETF.

        This field identifies the name of the parent index, which represents the broader universe from which the index underlying the ETF is created, if applicable  # noqa: E501

        :param parent_index: The parent_index of this ETF.  # noqa: E501
        :type: str
        """

        self._parent_index = parent_index

    @property
    def index_family(self):
        """Gets the index_family of this ETF.  # noqa: E501

        This field identifies the index family to which the index underlying the ETF belongs. The index family is represented as categorized by the index provider  # noqa: E501

        :return: The index_family of this ETF.  # noqa: E501
        :rtype: str
        """
        return self._index_family
        
    @property
    def index_family_dict(self):
        """Gets the index_family of this ETF.  # noqa: E501

        This field identifies the index family to which the index underlying the ETF belongs. The index family is represented as categorized by the index provider as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The index_family of this ETF.  # noqa: E501
        :rtype: str
        """

        result = None

        value = self.index_family
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'index_family': value }

        
        return result
        

    @index_family.setter
    def index_family(self, index_family):
        """Sets the index_family of this ETF.

        This field identifies the index family to which the index underlying the ETF belongs. The index family is represented as categorized by the index provider  # noqa: E501

        :param index_family: The index_family of this ETF.  # noqa: E501
        :type: str
        """

        self._index_family = index_family

    @property
    def broader_index_family(self):
        """Gets the broader_index_family of this ETF.  # noqa: E501

        This field identifies the broader index family to which the index underlying the ETF belongs. The broader index family is represented as categorized by the index provider  # noqa: E501

        :return: The broader_index_family of this ETF.  # noqa: E501
        :rtype: str
        """
        return self._broader_index_family
        
    @property
    def broader_index_family_dict(self):
        """Gets the broader_index_family of this ETF.  # noqa: E501

        This field identifies the broader index family to which the index underlying the ETF belongs. The broader index family is represented as categorized by the index provider as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The broader_index_family of this ETF.  # noqa: E501
        :rtype: str
        """

        result = None

        value = self.broader_index_family
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'broader_index_family': value }

        
        return result
        

    @broader_index_family.setter
    def broader_index_family(self, broader_index_family):
        """Sets the broader_index_family of this ETF.

        This field identifies the broader index family to which the index underlying the ETF belongs. The broader index family is represented as categorized by the index provider  # noqa: E501

        :param broader_index_family: The broader_index_family of this ETF.  # noqa: E501
        :type: str
        """

        self._broader_index_family = broader_index_family

    @property
    def index_provider(self):
        """Gets the index_provider of this ETF.  # noqa: E501

        This field identifies the Index provider for the index underlying the ETF, if applicable  # noqa: E501

        :return: The index_provider of this ETF.  # noqa: E501
        :rtype: str
        """
        return self._index_provider
        
    @property
    def index_provider_dict(self):
        """Gets the index_provider of this ETF.  # noqa: E501

        This field identifies the Index provider for the index underlying the ETF, if applicable as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The index_provider of this ETF.  # noqa: E501
        :rtype: str
        """

        result = None

        value = self.index_provider
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'index_provider': value }

        
        return result
        

    @index_provider.setter
    def index_provider(self, index_provider):
        """Sets the index_provider of this ETF.

        This field identifies the Index provider for the index underlying the ETF, if applicable  # noqa: E501

        :param index_provider: The index_provider of this ETF.  # noqa: E501
        :type: str
        """

        self._index_provider = index_provider

    @property
    def fund_family(self):
        """Gets the fund_family of this ETF.  # noqa: E501

        This field identifies the fund family to which the ETF belongs, as categorized by the ETF Sponsor  # noqa: E501

        :return: The fund_family of this ETF.  # noqa: E501
        :rtype: str
        """
        return self._fund_family
        
    @property
    def fund_family_dict(self):
        """Gets the fund_family of this ETF.  # noqa: E501

        This field identifies the fund family to which the ETF belongs, as categorized by the ETF Sponsor as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The fund_family of this ETF.  # noqa: E501
        :rtype: str
        """

        result = None

        value = self.fund_family
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'fund_family': value }

        
        return result
        

    @fund_family.setter
    def fund_family(self, fund_family):
        """Sets the fund_family of this ETF.

        This field identifies the fund family to which the ETF belongs, as categorized by the ETF Sponsor  # noqa: E501

        :param fund_family: The fund_family of this ETF.  # noqa: E501
        :type: str
        """

        self._fund_family = fund_family

    @property
    def index_ticker(self):
        """Gets the index_ticker of this ETF.  # noqa: E501

        This field identifies the OpenFIGI ticker for the Index underlying the ETF  # noqa: E501

        :return: The index_ticker of this ETF.  # noqa: E501
        :rtype: str
        """
        return self._index_ticker
        
    @property
    def index_ticker_dict(self):
        """Gets the index_ticker of this ETF.  # noqa: E501

        This field identifies the OpenFIGI ticker for the Index underlying the ETF as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The index_ticker of this ETF.  # noqa: E501
        :rtype: str
        """

        result = None

        value = self.index_ticker
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'index_ticker': value }

        
        return result
        

    @index_ticker.setter
    def index_ticker(self, index_ticker):
        """Sets the index_ticker of this ETF.

        This field identifies the OpenFIGI ticker for the Index underlying the ETF  # noqa: E501

        :param index_ticker: The index_ticker of this ETF.  # noqa: E501
        :type: str
        """

        self._index_ticker = index_ticker

    @property
    def etn_issuing_bank(self):
        """Gets the etn_issuing_bank of this ETF.  # noqa: E501

        If the product is an Exchange Traded Note (ETN), this field identifies the issuing bank  # noqa: E501

        :return: The etn_issuing_bank of this ETF.  # noqa: E501
        :rtype: str
        """
        return self._etn_issuing_bank
        
    @property
    def etn_issuing_bank_dict(self):
        """Gets the etn_issuing_bank of this ETF.  # noqa: E501

        If the product is an Exchange Traded Note (ETN), this field identifies the issuing bank as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The etn_issuing_bank of this ETF.  # noqa: E501
        :rtype: str
        """

        result = None

        value = self.etn_issuing_bank
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'etn_issuing_bank': value }

        
        return result
        

    @etn_issuing_bank.setter
    def etn_issuing_bank(self, etn_issuing_bank):
        """Sets the etn_issuing_bank of this ETF.

        If the product is an Exchange Traded Note (ETN), this field identifies the issuing bank  # noqa: E501

        :param etn_issuing_bank: The etn_issuing_bank of this ETF.  # noqa: E501
        :type: str
        """

        self._etn_issuing_bank = etn_issuing_bank

    @property
    def etn_maturity_date(self):
        """Gets the etn_maturity_date of this ETF.  # noqa: E501

        If the product is an ETN, this field identifies the maturity date for the ETN  # noqa: E501

        :return: The etn_maturity_date of this ETF.  # noqa: E501
        :rtype: date
        """
        return self._etn_maturity_date
        
    @property
    def etn_maturity_date_dict(self):
        """Gets the etn_maturity_date of this ETF.  # noqa: E501

        If the product is an ETN, this field identifies the maturity date for the ETN as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The etn_maturity_date of this ETF.  # noqa: E501
        :rtype: date
        """

        result = None

        value = self.etn_maturity_date
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'etn_maturity_date': value }

        
        return result
        

    @etn_maturity_date.setter
    def etn_maturity_date(self, etn_maturity_date):
        """Sets the etn_maturity_date of this ETF.

        If the product is an ETN, this field identifies the maturity date for the ETN  # noqa: E501

        :param etn_maturity_date: The etn_maturity_date of this ETF.  # noqa: E501
        :type: date
        """

        self._etn_maturity_date = etn_maturity_date

    @property
    def livestock(self):
        """Gets the livestock of this ETF.  # noqa: E501

        For ETFs where 'commodity_type' is 'Livestock', this field provides detail on the type of livestock exposure provided by the ETF  # noqa: E501

        :return: The livestock of this ETF.  # noqa: E501
        :rtype: str
        """
        return self._livestock
        
    @property
    def livestock_dict(self):
        """Gets the livestock of this ETF.  # noqa: E501

        For ETFs where 'commodity_type' is 'Livestock', this field provides detail on the type of livestock exposure provided by the ETF as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The livestock of this ETF.  # noqa: E501
        :rtype: str
        """

        result = None

        value = self.livestock
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'livestock': value }

        
        return result
        

    @livestock.setter
    def livestock(self, livestock):
        """Sets the livestock of this ETF.

        For ETFs where 'commodity_type' is 'Livestock', this field provides detail on the type of livestock exposure provided by the ETF  # noqa: E501

        :param livestock: The livestock of this ETF.  # noqa: E501
        :type: str
        """

        self._livestock = livestock

    @property
    def dynamic_futures_roll(self):
        """Gets the dynamic_futures_roll of this ETF.  # noqa: E501

        If the product holds futures contracts, this field identifies those products where the roll strategy is dynamic (rather than entirely rules based), so as to minimize roll costs  # noqa: E501

        :return: The dynamic_futures_roll of this ETF.  # noqa: E501
        :rtype: bool
        """
        return self._dynamic_futures_roll
        
    @property
    def dynamic_futures_roll_dict(self):
        """Gets the dynamic_futures_roll of this ETF.  # noqa: E501

        If the product holds futures contracts, this field identifies those products where the roll strategy is dynamic (rather than entirely rules based), so as to minimize roll costs as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The dynamic_futures_roll of this ETF.  # noqa: E501
        :rtype: bool
        """

        result = None

        value = self.dynamic_futures_roll
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'dynamic_futures_roll': value }

        
        return result
        

    @dynamic_futures_roll.setter
    def dynamic_futures_roll(self, dynamic_futures_roll):
        """Sets the dynamic_futures_roll of this ETF.

        If the product holds futures contracts, this field identifies those products where the roll strategy is dynamic (rather than entirely rules based), so as to minimize roll costs  # noqa: E501

        :param dynamic_futures_roll: The dynamic_futures_roll of this ETF.  # noqa: E501
        :type: bool
        """

        self._dynamic_futures_roll = dynamic_futures_roll

    @property
    def index_provider_code(self):
        """Gets the index_provider_code of this ETF.  # noqa: E501

        This field provides the First Bridge code for each Index provider, corresponding to the index underlying the ETF if applicable  # noqa: E501

        :return: The index_provider_code of this ETF.  # noqa: E501
        :rtype: str
        """
        return self._index_provider_code
        
    @property
    def index_provider_code_dict(self):
        """Gets the index_provider_code of this ETF.  # noqa: E501

        This field provides the First Bridge code for each Index provider, corresponding to the index underlying the ETF if applicable as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The index_provider_code of this ETF.  # noqa: E501
        :rtype: str
        """

        result = None

        value = self.index_provider_code
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'index_provider_code': value }

        
        return result
        

    @index_provider_code.setter
    def index_provider_code(self, index_provider_code):
        """Sets the index_provider_code of this ETF.

        This field provides the First Bridge code for each Index provider, corresponding to the index underlying the ETF if applicable  # noqa: E501

        :param index_provider_code: The index_provider_code of this ETF.  # noqa: E501
        :type: str
        """

        self._index_provider_code = index_provider_code

    @property
    def single_category_designation(self):
        """Gets the single_category_designation of this ETF.  # noqa: E501

        This categorization is created for those users who want every ETF to be ‘forced’ into a single bucket, so that the assets for all categories will always sum to the total market  # noqa: E501

        :return: The single_category_designation of this ETF.  # noqa: E501
        :rtype: str
        """
        return self._single_category_designation
        
    @property
    def single_category_designation_dict(self):
        """Gets the single_category_designation of this ETF.  # noqa: E501

        This categorization is created for those users who want every ETF to be ‘forced’ into a single bucket, so that the assets for all categories will always sum to the total market as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The single_category_designation of this ETF.  # noqa: E501
        :rtype: str
        """

        result = None

        value = self.single_category_designation
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'single_category_designation': value }

        
        return result
        

    @single_category_designation.setter
    def single_category_designation(self, single_category_designation):
        """Sets the single_category_designation of this ETF.

        This categorization is created for those users who want every ETF to be ‘forced’ into a single bucket, so that the assets for all categories will always sum to the total market  # noqa: E501

        :param single_category_designation: The single_category_designation of this ETF.  # noqa: E501
        :type: str
        """

        self._single_category_designation = single_category_designation

    @property
    def registered_countries(self):
        """Gets the registered_countries of this ETF.  # noqa: E501

        The list of countries where the ETF is legally registered for sale. This may differ from where the ETF is domiciled or traded, particularly in Europe  # noqa: E501

        :return: The registered_countries of this ETF.  # noqa: E501
        :rtype: str
        """
        return self._registered_countries
        
    @property
    def registered_countries_dict(self):
        """Gets the registered_countries of this ETF.  # noqa: E501

        The list of countries where the ETF is legally registered for sale. This may differ from where the ETF is domiciled or traded, particularly in Europe as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The registered_countries of this ETF.  # noqa: E501
        :rtype: str
        """

        result = None

        value = self.registered_countries
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'registered_countries': value }

        
        return result
        

    @registered_countries.setter
    def registered_countries(self, registered_countries):
        """Sets the registered_countries of this ETF.

        The list of countries where the ETF is legally registered for sale. This may differ from where the ETF is domiciled or traded, particularly in Europe  # noqa: E501

        :param registered_countries: The registered_countries of this ETF.  # noqa: E501
        :type: str
        """

        self._registered_countries = registered_countries

    @property
    def issuing_entity_country_code(self):
        """Gets the issuing_entity_country_code of this ETF.  # noqa: E501

        The name of the legal entity that issued the Exchange Traded Product (ETP)  # noqa: E501

        :return: The issuing_entity_country_code of this ETF.  # noqa: E501
        :rtype: str
        """
        return self._issuing_entity_country_code
        
    @property
    def issuing_entity_country_code_dict(self):
        """Gets the issuing_entity_country_code of this ETF.  # noqa: E501

        The name of the legal entity that issued the Exchange Traded Product (ETP) as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The issuing_entity_country_code of this ETF.  # noqa: E501
        :rtype: str
        """

        result = None

        value = self.issuing_entity_country_code
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'issuing_entity_country_code': value }

        
        return result
        

    @issuing_entity_country_code.setter
    def issuing_entity_country_code(self, issuing_entity_country_code):
        """Sets the issuing_entity_country_code of this ETF.

        The name of the legal entity that issued the Exchange Traded Product (ETP)  # noqa: E501

        :param issuing_entity_country_code: The issuing_entity_country_code of this ETF.  # noqa: E501
        :type: str
        """

        self._issuing_entity_country_code = issuing_entity_country_code

    @property
    def ucits(self):
        """Gets the ucits of this ETF.  # noqa: E501

        If true, the Exchange Traded Product (ETP) is Undertakings for the Collective Investment in Transferable Securities (UCITS) compliant  # noqa: E501

        :return: The ucits of this ETF.  # noqa: E501
        :rtype: bool
        """
        return self._ucits
        
    @property
    def ucits_dict(self):
        """Gets the ucits of this ETF.  # noqa: E501

        If true, the Exchange Traded Product (ETP) is Undertakings for the Collective Investment in Transferable Securities (UCITS) compliant as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The ucits of this ETF.  # noqa: E501
        :rtype: bool
        """

        result = None

        value = self.ucits
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'ucits': value }

        
        return result
        

    @ucits.setter
    def ucits(self, ucits):
        """Sets the ucits of this ETF.

        If true, the Exchange Traded Product (ETP) is Undertakings for the Collective Investment in Transferable Securities (UCITS) compliant  # noqa: E501

        :param ucits: The ucits of this ETF.  # noqa: E501
        :type: bool
        """

        self._ucits = ucits

    @property
    def replication_structure(self):
        """Gets the replication_structure of this ETF.  # noqa: E501

        The replication structure of the Exchange Traded Product (ETP)  # noqa: E501

        :return: The replication_structure of this ETF.  # noqa: E501
        :rtype: str
        """
        return self._replication_structure
        
    @property
    def replication_structure_dict(self):
        """Gets the replication_structure of this ETF.  # noqa: E501

        The replication structure of the Exchange Traded Product (ETP) as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The replication_structure of this ETF.  # noqa: E501
        :rtype: str
        """

        result = None

        value = self.replication_structure
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'replication_structure': value }

        
        return result
        

    @replication_structure.setter
    def replication_structure(self, replication_structure):
        """Sets the replication_structure of this ETF.

        The replication structure of the Exchange Traded Product (ETP)  # noqa: E501

        :param replication_structure: The replication_structure of this ETF.  # noqa: E501
        :type: str
        """

        self._replication_structure = replication_structure

    @property
    def domicile(self):
        """Gets the domicile of this ETF.  # noqa: E501

        2 letter ISO country code for the country where the ETP is domiciled  # noqa: E501

        :return: The domicile of this ETF.  # noqa: E501
        :rtype: str
        """
        return self._domicile
        
    @property
    def domicile_dict(self):
        """Gets the domicile of this ETF.  # noqa: E501

        2 letter ISO country code for the country where the ETP is domiciled as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The domicile of this ETF.  # noqa: E501
        :rtype: str
        """

        result = None

        value = self.domicile
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'domicile': value }

        
        return result
        

    @domicile.setter
    def domicile(self, domicile):
        """Sets the domicile of this ETF.

        2 letter ISO country code for the country where the ETP is domiciled  # noqa: E501

        :param domicile: The domicile of this ETF.  # noqa: E501
        :type: str
        """

        self._domicile = domicile

    @property
    def base_currency(self):
        """Gets the base_currency of this ETF.  # noqa: E501

        Base currency of the Exchange Traded Product (ETP) in which the net asset value (NAV) is calculated. Reported using the 3-digit ISO currency code  # noqa: E501

        :return: The base_currency of this ETF.  # noqa: E501
        :rtype: str
        """
        return self._base_currency
        
    @property
    def base_currency_dict(self):
        """Gets the base_currency of this ETF.  # noqa: E501

        Base currency of the Exchange Traded Product (ETP) in which the net asset value (NAV) is calculated. Reported using the 3-digit ISO currency code as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The base_currency of this ETF.  # noqa: E501
        :rtype: str
        """

        result = None

        value = self.base_currency
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'base_currency': value }

        
        return result
        

    @base_currency.setter
    def base_currency(self, base_currency):
        """Sets the base_currency of this ETF.

        Base currency of the Exchange Traded Product (ETP) in which the net asset value (NAV) is calculated. Reported using the 3-digit ISO currency code  # noqa: E501

        :param base_currency: The base_currency of this ETF.  # noqa: E501
        :type: str
        """

        self._base_currency = base_currency

    @property
    def listing_currency(self):
        """Gets the listing_currency of this ETF.  # noqa: E501

        Listing currency of the Exchange Traded Product (ETP) in which it is traded. Reported using the 3-digit ISO currency code  # noqa: E501

        :return: The listing_currency of this ETF.  # noqa: E501
        :rtype: str
        """
        return self._listing_currency
        
    @property
    def listing_currency_dict(self):
        """Gets the listing_currency of this ETF.  # noqa: E501

        Listing currency of the Exchange Traded Product (ETP) in which it is traded. Reported using the 3-digit ISO currency code as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The listing_currency of this ETF.  # noqa: E501
        :rtype: str
        """

        result = None

        value = self.listing_currency
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'listing_currency': value }

        
        return result
        

    @listing_currency.setter
    def listing_currency(self, listing_currency):
        """Sets the listing_currency of this ETF.

        Listing currency of the Exchange Traded Product (ETP) in which it is traded. Reported using the 3-digit ISO currency code  # noqa: E501

        :param listing_currency: The listing_currency of this ETF.  # noqa: E501
        :type: str
        """

        self._listing_currency = listing_currency

    @property
    def fund_listing_date(self):
        """Gets the fund_listing_date of this ETF.  # noqa: E501

        The date on which the Exchange Traded Product (ETP) or share class of the ETP is listed on a specific exchange  # noqa: E501

        :return: The fund_listing_date of this ETF.  # noqa: E501
        :rtype: date
        """
        return self._fund_listing_date
        
    @property
    def fund_listing_date_dict(self):
        """Gets the fund_listing_date of this ETF.  # noqa: E501

        The date on which the Exchange Traded Product (ETP) or share class of the ETP is listed on a specific exchange as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The fund_listing_date of this ETF.  # noqa: E501
        :rtype: date
        """

        result = None

        value = self.fund_listing_date
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'fund_listing_date': value }

        
        return result
        

    @fund_listing_date.setter
    def fund_listing_date(self, fund_listing_date):
        """Sets the fund_listing_date of this ETF.

        The date on which the Exchange Traded Product (ETP) or share class of the ETP is listed on a specific exchange  # noqa: E501

        :param fund_listing_date: The fund_listing_date of this ETF.  # noqa: E501
        :type: date
        """

        self._fund_listing_date = fund_listing_date

    @property
    def listing_country_code(self):
        """Gets the listing_country_code of this ETF.  # noqa: E501

        2 letter ISO country code for the country where the Exchange Traded Product (ETP) is listed  # noqa: E501

        :return: The listing_country_code of this ETF.  # noqa: E501
        :rtype: str
        """
        return self._listing_country_code
        
    @property
    def listing_country_code_dict(self):
        """Gets the listing_country_code of this ETF.  # noqa: E501

        2 letter ISO country code for the country where the Exchange Traded Product (ETP) is listed as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The listing_country_code of this ETF.  # noqa: E501
        :rtype: str
        """

        result = None

        value = self.listing_country_code
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'listing_country_code': value }

        
        return result
        

    @listing_country_code.setter
    def listing_country_code(self, listing_country_code):
        """Sets the listing_country_code of this ETF.

        2 letter ISO country code for the country where the Exchange Traded Product (ETP) is listed  # noqa: E501

        :param listing_country_code: The listing_country_code of this ETF.  # noqa: E501
        :type: str
        """

        self._listing_country_code = listing_country_code

    @property
    def listing_region(self):
        """Gets the listing_region of this ETF.  # noqa: E501

        The region in which this specific ETF is listed  # noqa: E501

        :return: The listing_region of this ETF.  # noqa: E501
        :rtype: str
        """
        return self._listing_region
        
    @property
    def listing_region_dict(self):
        """Gets the listing_region of this ETF.  # noqa: E501

        The region in which this specific ETF is listed as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The listing_region of this ETF.  # noqa: E501
        :rtype: str
        """

        result = None

        value = self.listing_region
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'listing_region': value }

        
        return result
        

    @listing_region.setter
    def listing_region(self, listing_region):
        """Sets the listing_region of this ETF.

        The region in which this specific ETF is listed  # noqa: E501

        :param listing_region: The listing_region of this ETF.  # noqa: E501
        :type: str
        """

        self._listing_region = listing_region

    @property
    def smartvs_traditional_beta(self):
        """Gets the smartvs_traditional_beta of this ETF.  # noqa: E501

        This field identifies whether an ETF provides 'Traditional' beta exposure or 'Smart' beta exposure. ETFs that are active (i.e. non-indexed), leveraged / inverse or have a proprietary quant model (i.e. that don’t provide indexed exposure to a targeted factor) are classified separately  # noqa: E501

        :return: The smartvs_traditional_beta of this ETF.  # noqa: E501
        :rtype: str
        """
        return self._smartvs_traditional_beta
        
    @property
    def smartvs_traditional_beta_dict(self):
        """Gets the smartvs_traditional_beta of this ETF.  # noqa: E501

        This field identifies whether an ETF provides 'Traditional' beta exposure or 'Smart' beta exposure. ETFs that are active (i.e. non-indexed), leveraged / inverse or have a proprietary quant model (i.e. that don’t provide indexed exposure to a targeted factor) are classified separately as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The smartvs_traditional_beta of this ETF.  # noqa: E501
        :rtype: str
        """

        result = None

        value = self.smartvs_traditional_beta
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'smartvs_traditional_beta': value }

        
        return result
        

    @smartvs_traditional_beta.setter
    def smartvs_traditional_beta(self, smartvs_traditional_beta):
        """Sets the smartvs_traditional_beta of this ETF.

        This field identifies whether an ETF provides 'Traditional' beta exposure or 'Smart' beta exposure. ETFs that are active (i.e. non-indexed), leveraged / inverse or have a proprietary quant model (i.e. that don’t provide indexed exposure to a targeted factor) are classified separately  # noqa: E501

        :param smartvs_traditional_beta: The smartvs_traditional_beta of this ETF.  # noqa: E501
        :type: str
        """

        self._smartvs_traditional_beta = smartvs_traditional_beta

    @property
    def smartvs_traditional_beta_level2(self):
        """Gets the smartvs_traditional_beta_level2 of this ETF.  # noqa: E501

        This field provides further detail within the traditional and smart beta categories  # noqa: E501

        :return: The smartvs_traditional_beta_level2 of this ETF.  # noqa: E501
        :rtype: str
        """
        return self._smartvs_traditional_beta_level2
        
    @property
    def smartvs_traditional_beta_level2_dict(self):
        """Gets the smartvs_traditional_beta_level2 of this ETF.  # noqa: E501

        This field provides further detail within the traditional and smart beta categories as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The smartvs_traditional_beta_level2 of this ETF.  # noqa: E501
        :rtype: str
        """

        result = None

        value = self.smartvs_traditional_beta_level2
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'smartvs_traditional_beta_level2': value }

        
        return result
        

    @smartvs_traditional_beta_level2.setter
    def smartvs_traditional_beta_level2(self, smartvs_traditional_beta_level2):
        """Sets the smartvs_traditional_beta_level2 of this ETF.

        This field provides further detail within the traditional and smart beta categories  # noqa: E501

        :param smartvs_traditional_beta_level2: The smartvs_traditional_beta_level2 of this ETF.  # noqa: E501
        :type: str
        """

        self._smartvs_traditional_beta_level2 = smartvs_traditional_beta_level2

    @property
    def income_category(self):
        """Gets the income_category of this ETF.  # noqa: E501

        Identifies if an Exchange Traded Fund (ETF) falls into a category that is specifically designed to provide a high yield or income  # noqa: E501

        :return: The income_category of this ETF.  # noqa: E501
        :rtype: str
        """
        return self._income_category
        
    @property
    def income_category_dict(self):
        """Gets the income_category of this ETF.  # noqa: E501

        Identifies if an Exchange Traded Fund (ETF) falls into a category that is specifically designed to provide a high yield or income as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The income_category of this ETF.  # noqa: E501
        :rtype: str
        """

        result = None

        value = self.income_category
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'income_category': value }

        
        return result
        

    @income_category.setter
    def income_category(self, income_category):
        """Sets the income_category of this ETF.

        Identifies if an Exchange Traded Fund (ETF) falls into a category that is specifically designed to provide a high yield or income  # noqa: E501

        :param income_category: The income_category of this ETF.  # noqa: E501
        :type: str
        """

        self._income_category = income_category

    @property
    def etp_structure_type(self):
        """Gets the etp_structure_type of this ETF.  # noqa: E501

        Classifies Exchange Traded Products (ETPs) into very broad categories based on its legal structure  # noqa: E501

        :return: The etp_structure_type of this ETF.  # noqa: E501
        :rtype: str
        """
        return self._etp_structure_type
        
    @property
    def etp_structure_type_dict(self):
        """Gets the etp_structure_type of this ETF.  # noqa: E501

        Classifies Exchange Traded Products (ETPs) into very broad categories based on its legal structure as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The etp_structure_type of this ETF.  # noqa: E501
        :rtype: str
        """

        result = None

        value = self.etp_structure_type
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'etp_structure_type': value }

        
        return result
        

    @etp_structure_type.setter
    def etp_structure_type(self, etp_structure_type):
        """Sets the etp_structure_type of this ETF.

        Classifies Exchange Traded Products (ETPs) into very broad categories based on its legal structure  # noqa: E501

        :param etp_structure_type: The etp_structure_type of this ETF.  # noqa: E501
        :type: str
        """

        self._etp_structure_type = etp_structure_type

    @property
    def month_end_assets(self):
        """Gets the month_end_assets of this ETF.  # noqa: E501

        Net assets in millions of dollars as of the most recent month end  # noqa: E501

        :return: The month_end_assets of this ETF.  # noqa: E501
        :rtype: float
        """
        return self._month_end_assets
        
    @property
    def month_end_assets_dict(self):
        """Gets the month_end_assets of this ETF.  # noqa: E501

        Net assets in millions of dollars as of the most recent month end as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The month_end_assets of this ETF.  # noqa: E501
        :rtype: float
        """

        result = None

        value = self.month_end_assets
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'month_end_assets': value }

        
        return result
        

    @month_end_assets.setter
    def month_end_assets(self, month_end_assets):
        """Sets the month_end_assets of this ETF.

        Net assets in millions of dollars as of the most recent month end  # noqa: E501

        :param month_end_assets: The month_end_assets of this ETF.  # noqa: E501
        :type: float
        """

        self._month_end_assets = month_end_assets

    @property
    def etf_portfolio_turnover(self):
        """Gets the etf_portfolio_turnover of this ETF.  # noqa: E501

        The percentage of positions turned over in the last 12 months  # noqa: E501

        :return: The etf_portfolio_turnover of this ETF.  # noqa: E501
        :rtype: float
        """
        return self._etf_portfolio_turnover
        
    @property
    def etf_portfolio_turnover_dict(self):
        """Gets the etf_portfolio_turnover of this ETF.  # noqa: E501

        The percentage of positions turned over in the last 12 months as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The etf_portfolio_turnover of this ETF.  # noqa: E501
        :rtype: float
        """

        result = None

        value = self.etf_portfolio_turnover
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'etf_portfolio_turnover': value }

        
        return result
        

    @etf_portfolio_turnover.setter
    def etf_portfolio_turnover(self, etf_portfolio_turnover):
        """Sets the etf_portfolio_turnover of this ETF.

        The percentage of positions turned over in the last 12 months  # noqa: E501

        :param etf_portfolio_turnover: The etf_portfolio_turnover of this ETF.  # noqa: E501
        :type: float
        """

        self._etf_portfolio_turnover = etf_portfolio_turnover

    @property
    def firstbridge_id(self):
        """Gets the firstbridge_id of this ETF.  # noqa: E501

        The FirstBridge unique identifier for the Exchange Traded Fund (ETF)  # noqa: E501

        :return: The firstbridge_id of this ETF.  # noqa: E501
        :rtype: str
        """
        return self._firstbridge_id
        
    @property
    def firstbridge_id_dict(self):
        """Gets the firstbridge_id of this ETF.  # noqa: E501

        The FirstBridge unique identifier for the Exchange Traded Fund (ETF) as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The firstbridge_id of this ETF.  # noqa: E501
        :rtype: str
        """

        result = None

        value = self.firstbridge_id
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'firstbridge_id': value }

        
        return result
        

    @firstbridge_id.setter
    def firstbridge_id(self, firstbridge_id):
        """Sets the firstbridge_id of this ETF.

        The FirstBridge unique identifier for the Exchange Traded Fund (ETF)  # noqa: E501

        :param firstbridge_id: The firstbridge_id of this ETF.  # noqa: E501
        :type: str
        """

        self._firstbridge_id = firstbridge_id

    @property
    def firstbridge_parent_id(self):
        """Gets the firstbridge_parent_id of this ETF.  # noqa: E501

        The FirstBridge unique identifier of the parent Exchange Traded Fund (ETF), if applicable  # noqa: E501

        :return: The firstbridge_parent_id of this ETF.  # noqa: E501
        :rtype: str
        """
        return self._firstbridge_parent_id
        
    @property
    def firstbridge_parent_id_dict(self):
        """Gets the firstbridge_parent_id of this ETF.  # noqa: E501

        The FirstBridge unique identifier of the parent Exchange Traded Fund (ETF), if applicable as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The firstbridge_parent_id of this ETF.  # noqa: E501
        :rtype: str
        """

        result = None

        value = self.firstbridge_parent_id
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'firstbridge_parent_id': value }

        
        return result
        

    @firstbridge_parent_id.setter
    def firstbridge_parent_id(self, firstbridge_parent_id):
        """Sets the firstbridge_parent_id of this ETF.

        The FirstBridge unique identifier of the parent Exchange Traded Fund (ETF), if applicable  # noqa: E501

        :param firstbridge_parent_id: The firstbridge_parent_id of this ETF.  # noqa: E501
        :type: str
        """

        self._firstbridge_parent_id = firstbridge_parent_id

    @property
    def number_of_holdings(self):
        """Gets the number_of_holdings of this ETF.  # noqa: E501

        The number of holdings for this Exchange Traded Fund (ETF)  # noqa: E501

        :return: The number_of_holdings of this ETF.  # noqa: E501
        :rtype: int
        """
        return self._number_of_holdings
        
    @property
    def number_of_holdings_dict(self):
        """Gets the number_of_holdings of this ETF.  # noqa: E501

        The number of holdings for this Exchange Traded Fund (ETF) as a dictionary. Useful for Panda Dataframes.  # noqa: E501

        :return: The number_of_holdings of this ETF.  # noqa: E501
        :rtype: int
        """

        result = None

        value = self.number_of_holdings
        if isinstance(value, list):
            result = list(map(
                lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                value
            ))
        elif hasattr(value, "to_dict"):
            result = value.to_dict()
        elif isinstance(value, dict):
            result = dict(map(
                lambda item: (item[0], item[1].to_dict())
                if hasattr(item[1], "to_dict") else item,
                value.items()
            ))
        else:
            result = { 'number_of_holdings': value }

        
        return result
        

    @number_of_holdings.setter
    def number_of_holdings(self, number_of_holdings):
        """Sets the number_of_holdings of this ETF.

        The number of holdings for this Exchange Traded Fund (ETF)  # noqa: E501

        :param number_of_holdings: The number_of_holdings of this ETF.  # noqa: E501
        :type: int
        """

        self._number_of_holdings = number_of_holdings

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ETF):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
