def parameters():
    """
    Dictionary of parameters defining geophysical acquisition systems
    """
    return {
        "AeroTEM (2007)": {
            "type": "time",
            "flag": "Zoff",
            "channel_start_index": 1,
            "channels": {
                "[1]": 58.1e-6,
                "[2]": 85.9e-6,
                "[3]": 113.7e-6,
                "[4]": 141.4e-6,
                "[5]": 169.2e-6,
                "[6]": 197.0e-6,
                "[7]": 238.7e-6,
                "[8]": 294.2e-6,
                "[9]": 349.8e-6,
                "[10]": 405.3e-6,
                "[11]": 474.8e-6,
                "[12]": 558.1e-6,
                "[13]": 655.3e-6,
                "[14]": 794.2e-6,
                "[15]": 988.7e-6,
                "[16]": 1280.3e-6,
                "[17]": 1738.7e-6,
            },
            "uncertainty": [
                [0.05, 5e-0],
                [0.05, 5e-0],
                [0.05, 5e-0],
                [0.05, 5e-0],
                [0.05, 5e-0],
                [0.05, 5e-0],
                [0.05, 5e-0],
                [0.05, 5e-0],
                [0.05, 5e-0],
                [0.05, 5e-0],
                [0.05, 5e-0],
                [0.05, 5e-0],
                [0.05, 5e-0],
                [0.05, 5e-0],
                [0.05, 5e-0],
                [0.05, 5e-0],
                [0.05, 5e-0],
            ],
            "waveform": [
                [-1.10e-03, 1e-8],
                [-8.2500e-04, 5.0e-01],
                [-5.50e-04, 1.0e00],
                [-2.7500e-04, 5.0e-01],
                [0.0e00, 0.0e00],
                [2.50e-05, 0.0e00],
                [5.0e-05, 0.0e00],
                [7.50e-05, 0.0e00],
                [1.0e-04, 0.0e00],
                [1.2500e-04, 0.0e00],
                [1.50e-04, 0.0e00],
                [1.7500e-04, 0.0e00],
                [2.0e-04, 0.0e00],
                [2.2500e-04, 0.0e00],
                [2.50e-04, 0.0e00],
                [3.0550e-04, 0.0e00],
                [3.6100e-04, 0.0e00],
                [4.1650e-04, 0.0e00],
                [4.7200e-04, 0.0e00],
                [5.2750e-04, 0.0e00],
                [6.0750e-04, 0.0e00],
                [6.8750e-04, 0.0e00],
                [7.6750e-04, 0.0e00],
                [8.4750e-04, 0.0e00],
                [9.2750e-04, 0.0e00],
                [1.1275e-03, 0.0e00],
                [1.3275e-03, 0.0e00],
                [1.5275e-03, 0.0e00],
                [1.7275e-03, 0.0e00],
                [1.9275e-03, 0.0e00],
                [2.1275e-03, 0.0e00],
            ],
            "tx_offsets": [[0, 0, 0]],
            "bird_offset": [0, 0, -40],
            "comment": "normalization accounts for 2.5m radius loop * 8 turns * 69 A current, nanoTesla",
            "normalization": [2.9e-4, 1e-9],
            "tx_specs": {"type": "CircularLoop", "a": 1.0, "I": 1.0},
            "data_type": "dBzdt",
        },
        "AeroTEM (2010)": {
            "type": "time",
            "flag": "Zoff",
            "channel_start_index": 1,
            "channels": {
                "[1]": 67.8e-6,
                "[2]": 95.6e-6,
                "[3]": 123.4e-6,
                "[4]": 151.2e-6,
                "[5]": 178.9e-6,
                "[6]": 206.7e-6,
                "[7]": 262.3e-6,
                "[8]": 345.6e-6,
                "[9]": 428.9e-6,
                "[10]": 512.3e-6,
                "[11]": 623.4e-6,
                "[12]": 762.3e-6,
                "[13]": 928.9e-6,
                "[14]": 1165.0e-6,
                "[15]": 1526.2e-6,
                "[16]": 2081.7e-6,
                "[17]": 2942.8e-6,
            },
            "uncertainty": [
                [0.05, 5e-0],
                [0.05, 5e-0],
                [0.05, 5e-0],
                [0.05, 5e-0],
                [0.05, 5e-0],
                [0.05, 5e-0],
                [0.05, 5e-0],
                [0.05, 5e-0],
                [0.05, 5e-0],
                [0.05, 5e-0],
                [0.05, 5e-0],
                [0.05, 5e-0],
                [0.05, 5e-0],
                [0.05, 5e-0],
                [0.05, 5e-0],
                [0.05, 5e-0],
                [0.05, 5e-0],
            ],
            "waveform": [
                [-1.10e-03, 1e-8],
                [-8.2500e-04, 5.0e-01],
                [-5.50e-04, 1.0e00],
                [-2.7500e-04, 5.0e-01],
                [0.0e00, 0.0e00],
                [2.50e-05, 0.0e00],
                [5.0e-05, 0.0e00],
                [7.50e-05, 0.0e00],
                [1.0e-04, 0.0e00],
                [1.2500e-04, 0.0e00],
                [1.50e-04, 0.0e00],
                [1.7500e-04, 0.0e00],
                [2.0e-04, 0.0e00],
                [2.2500e-04, 0.0e00],
                [2.50e-04, 0.0e00],
                [3.0550e-04, 0.0e00],
                [3.6100e-04, 0.0e00],
                [4.1650e-04, 0.0e00],
                [4.7200e-04, 0.0e00],
                [5.2750e-04, 0.0e00],
                [6.0750e-04, 0.0e00],
                [6.8750e-04, 0.0e00],
                [7.6750e-04, 0.0e00],
                [8.4750e-04, 0.0e00],
                [9.2750e-04, 0.0e00],
                [1.1275e-03, 0.0e00],
                [1.3275e-03, 0.0e00],
                [1.5275e-03, 0.0e00],
                [1.7275e-03, 0.0e00],
                [1.9275e-03, 0.0e00],
                [2.1275e-03, 0.0e00],
                [2.3275e-03, 0.0e00],
                [2.5275e-03, 0.0e00],
                [2.7275e-03, 0.0e00],
                [2.9275e-03, 0.0e00],
                [3.1275e-03, 0.0e00],
            ],
            "tx_offsets": [[0, 0, 0]],
            "bird_offset": [0, 0, -40],
            "comment": "normalization accounts for 2.5m radius loop, 8 turns * 69 A current, nanoTesla",
            "normalization": [2.9e-4, 1e-9],
            "tx_specs": {"type": "CircularLoop", "a": 1.0, "I": 1.0},
            "data_type": "dBzdt",
        },
        "DIGHEM": {
            "type": "frequency",
            "flag": "CPI900",
            "channel_start_index": 0,
            "channels": {
                "CPI900": 900,
                "CPI7200": 7200,
                "CPI56K": 56000,
                "CPQ900": 900,
                "CPQ7200": 7200,
                "CPQ56K": 56000,
            },
            "components": {
                "CPI900": "real",
                "CPQ900": "imag",
                "CPI7200": "real",
                "CPQ7200": "imag",
                "CPI56K": "real",
                "CPQ56K": "imag",
            },
            "tx_offsets": [
                [8, 0, 0],
                [8, 0, 0],
                [6.3, 0, 0],
                [8, 0, 0],
                [8, 0, 0],
                [6.3, 0, 0],
            ],
            "bird_offset": [0, 0, 0],
            "uncertainty": [
                [0.0, 2],
                [0.0, 5],
                [0.0, 10],
                [0.0, 2],
                [0.0, 5],
                [0.0, 10],
            ],
            "tx_specs": {"type": "VMD", "a": 1.0, "I": 1.0},
            "normalization": "ppm",
        },
        "GENESIS (2014)": {
            "type": "time",
            "flag": "emz_step_final",
            "channel_start_index": 1,
            "channels": {
                "0": 9e-6,
                "1": 26e-6,
                "2": 52.0e-6,
                "3": 95e-6,
                "4": 156e-6,
                "5": 243e-6,
                "6": 365e-6,
                "7": 547e-6,
                "8": 833e-6,
                "9": 1259e-6,
                "10": 1858e-6,
            },
            "uncertainty": [
                [0.05, 100],
                [0.05, 100],
                [0.05, 100],
                [0.05, 100],
                [0.05, 100],
                [0.05, 100],
                [0.05, 2000],
                [0.05, 100],
                [0.05, 100],
                [0.05, 100],
                [0.05, 100],
            ],
            "waveform": "stepoff",
            "tx_offsets": [[-90, 0, -43]],
            "bird_offset": [-90, 0, -43],
            "comment": "normalization accounts for unit dipole moment at the tx_offset, in part-per-million",
            "normalization": "ppm",
            "tx_specs": {"type": "VMD", "a": 1.0, "I": 1.0},
            "data_type": "Bz",
        },
        "GEOTEM (1992)": {
            "type": "time",
            "flag": "EM_chan",
            "channel_start_index": 1,
            "channels": {
                "1": 393e-6,
                "2": 550e-6,
                "3": 706e-6,
                "4": 862e-6,
                "5": 1019e-6,
                "6": 1175e-6,
                "7": 1331e-6,
                "8": 1487e-6,
                "9": 1644e-6,
                "10": 1800e-6,
                "11": 1956e-6,
                "12": 2112,
            },
            "uncertainty": [
                [0.05, 40.0],
                [0.05, 40.0],
                [0.05, 40.0],
                [0.05, 40.0],
                [0.05, 40.0],
                [0.05, 40.0],
                [0.05, 40.0],
                [0.05, 40.0],
                [0.05, 40.0],
                [0.05, 40.0],
                [0.05, 40.0],
                [0.05, 40.0],
            ],
            "waveform": "stepoff",
            "tx_offsets": [[-123, 0, -56]],
            "bird_offset": [-123, 0, -56],
            "comment": "normalization accounts for unit dipole moment at the tx_offset, in part-per-million",
            "normalization": "ppm",
            "tx_specs": {"type": "VMD", "a": 1.0, "I": 1.0},
            "data_type": "Bz",
        },
        "HELITEM (35C)": {
            "type": "time",
            "flag": "emz_db",
            "channel_start_index": 5,
            "channels": {
                "[1]": -0.007772,
                "[2]": -0.003654,
                "[3]": -0.002678,
                "[4]": -0.000122,
                "[5]": 0.000228,
                "[6]": 0.000269,
                "[7]": 0.000326,
                "[8]": 0.000399,
                "[9]": 0.000488,
                "[10]": 0.000594,
                "[11]": 0.000716,
                "[12]": 0.000854,
                "[13]": 0.001009,
                "[14]": 0.001196,
                "[15]": 0.001424,
                "[16]": 0.001693,
                "[17]": 0.002018,
                "[18]": 0.002417,
                "[19]": 0.002905,
                "[20]": 0.003499,
                "[21]": 0.004215,
                "[22]": 0.005078,
                "[23]": 0.006128,
                "[24]": 0.007406,
                "[25]": 0.008952,
                "[26]": 0.010824,
                "[27]": 0.013094,
                "[28]": 0.015845,
                "[29]": 0.019173,
                "[30]": 0.02321,
            },
            "uncertainty": [
                [0.05, 2e-1],
                [0.05, 2e-1],
                [0.05, 2e-1],
                [0.05, 2e-1],
                [0.05, 2e-1],
                [0.05, 2e-1],
                [0.05, 2e-1],
                [0.05, 2e-1],
                [0.05, 2e-1],
                [0.05, 2e-1],
                [0.05, 2e-1],
                [0.05, 2e-1],
                [0.05, 2e-1],
                [0.05, 2e-1],
                [0.05, 2e-1],
                [0.05, 2e-1],
                [0.05, 2e-1],
                [0.05, 2e-1],
                [0.05, 2e-1],
                [0.05, 2e-1],
                [0.05, 2e-1],
                [0.05, 2e-1],
                [0.05, 2e-1],
                [0.05, 2e-1],
                [0.05, 2e-1],
                [0.05, 2e-1],
                [0.05, 2e-1],
                [0.05, 2e-1],
                [0.05, 2e-1],
                [0.05, 2e-1],
            ],
            "waveform": [
                [-8.000e-03, 1.000e-03],
                [-7.750e-03, 9.802e-02],
                [-7.500e-03, 1.950e-01],
                [-7.250e-03, 2.902e-01],
                [-7.000e-03, 3.826e-01],
                [-6.750e-03, 4.713e-01],
                [-6.500e-03, 5.555e-01],
                [-6.250e-03, 6.344e-01],
                [-6.000e-03, 7.071e-01],
                [-5.750e-03, 7.730e-01],
                [-5.500e-03, 8.315e-01],
                [-5.250e-03, 8.820e-01],
                [-5.000e-03, 9.239e-01],
                [-4.750e-03, 9.569e-01],
                [-4.500e-03, 9.808e-01],
                [-4.250e-03, 9.951e-01],
                [-4.000e-03, 1.000e00],
                [-3.750e-03, 9.951e-01],
                [-3.500e-03, 9.808e-01],
                [-3.250e-03, 9.569e-01],
                [-3.000e-03, 9.239e-01],
                [-2.750e-03, 8.820e-01],
                [-2.500e-03, 8.315e-01],
                [-2.250e-03, 7.730e-01],
                [-2.000e-03, 7.071e-01],
                [-1.750e-03, 6.344e-01],
                [-1.500e-03, 5.555e-01],
                [-1.250e-03, 4.713e-01],
                [-1.000e-03, 3.826e-01],
                [-7.500e-04, 2.902e-01],
                [-5.000e-04, 1.950e-01],
                [-2.500e-04, 9.802e-02],
                [0.000e00, 0.000e00],
                [5.000e-05, 0.000e00],
                [1.000e-04, 0.000e00],
                [1.500e-04, 0.000e00],
                [2.000e-04, 0.000e00],
                [2.500e-04, 0.000e00],
                [3.000e-04, 0.000e00],
                [3.500e-04, 0.000e00],
                [4.000e-04, 0.000e00],
                [4.500e-04, 0.000e00],
                [5.000e-04, 0.000e00],
                [5.500e-04, 0.000e00],
                [6.000e-04, 0.000e00],
                [6.500e-04, 0.000e00],
                [7.000e-04, 0.000e00],
                [7.500e-04, 0.000e00],
                [8.000e-04, 0.000e00],
                [8.500e-04, 0.000e00],
                [9.000e-04, 0.000e00],
                [9.500e-04, 0.000e00],
                [1.000e-03, 0.000e00],
                [1.050e-03, 0.000e00],
                [1.100e-03, 0.000e00],
                [1.150e-03, 0.000e00],
                [1.200e-03, 0.000e00],
                [1.225e-03, 0.000e00],
                [1.475e-03, 0.000e00],
                [1.725e-03, 0.000e00],
                [1.975e-03, 0.000e00],
                [2.225e-03, 0.000e00],
                [2.475e-03, 0.000e00],
                [2.725e-03, 0.000e00],
                [2.975e-03, 0.000e00],
                [3.225e-03, 0.000e00],
                [3.475e-03, 0.000e00],
                [3.725e-03, 0.000e00],
                [3.975e-03, 0.000e00],
                [4.225e-03, 0.000e00],
                [4.475e-03, 0.000e00],
                [4.725e-03, 0.000e00],
                [4.975e-03, 0.000e00],
                [5.225e-03, 0.000e00],
                [5.475e-03, 0.000e00],
                [5.725e-03, 0.000e00],
                [5.975e-03, 0.000e00],
                [6.225e-03, 0.000e00],
                [6.475e-03, 0.000e00],
                [6.725e-03, 0.000e00],
                [6.975e-03, 0.000e00],
                [7.225e-03, 0.000e00],
                [7.475e-03, 0.000e00],
                [7.725e-03, 0.000e00],
                [7.975e-03, 0.000e00],
                [8.225e-03, 0.000e00],
                [8.475e-03, 0.000e00],
                [8.500e-03, 0.000e00],
                [9.250e-03, 0.000e00],
                [1.000e-02, 0.000e00],
                [1.075e-02, 0.000e00],
                [1.150e-02, 0.000e00],
                [1.225e-02, 0.000e00],
                [1.300e-02, 0.000e00],
                [1.375e-02, 0.000e00],
                [1.450e-02, 0.000e00],
                [1.525e-02, 0.000e00],
                [1.600e-02, 0.000e00],
                [1.675e-02, 0.000e00],
                [1.750e-02, 0.000e00],
                [1.825e-02, 0.000e00],
                [1.900e-02, 0.000e00],
                [1.975e-02, 0.000e00],
                [2.050e-02, 0.000e00],
                [2.125e-02, 0.000e00],
                [2.200e-02, 0.000e00],
                [2.275e-02, 0.000e00],
                [2.350e-02, 0.000e00],
                [2.425e-02, 0.000e00],
            ],
            "tx_offsets": [[12.5, 0, 26.8]],
            "bird_offset": [12.5, 0, 26.8],
            "comment": "normalization accounts for a loop 961 m**2 area * 4 turns * 363 A current, nanoTesla",
            "normalization": [7.167e-7, 1e-9],
            "tx_specs": {"type": "VMD", "a": 1.0, "I": 1.0},
            "data_type": "dBzdt",
        },
        "Resolve": {
            "type": "frequency",
            "flag": "CPI400",
            "channel_start_index": 0,
            "channels": {
                "CPI400": 385,
                "CPI1800": 1790,
                "CPI8200": 8208,
                "CPI40K": 39840,
                "CPI140K": 132660,
                "CPQ400": 385,
                "CPQ1800": 1790,
                "CPQ8200": 8208,
                "CPQ40K": 39840,
                "CPQ140K": 132660,
            },
            "components": {
                "CPI400": "real",
                "CPQ400": "imag",
                "CPI1800": "real",
                "CPQ1800": "imag",
                "CPI8200": "real",
                "CPQ8200": "imag",
                "CPI40K": "real",
                "CPQ40K": "imag",
                "CPI140K": "real",
                "CPQ140K": "imag",
            },
            "tx_offsets": [
                [7.86, 0, 0],
                [7.86, 0, 0],
                [7.86, 0, 0],
                [7.86, 0, 0],
                [7.86, 0, 0],
                [7.86, 0, 0],
                [7.86, 0, 0],
                [7.86, 0, 0],
                [7.86, 0, 0],
                [7.86, 0, 0],
            ],
            "bird_offset": [0, 0, 0],
            "uncertainty": [
                [0.0, 7.5],
                [0.0, 25],
                [0.0, 125],
                [0.0, 350],
                [0.0, 800],
                [0.0, 15],
                [0.0, 50],
                [0.0, 200],
                [0.0, 475],
                [0.0, 350],
            ],
            "tx_specs": {"type": "VMD", "a": 1.0, "I": 1.0},
            "normalization": "ppm",
        },
        "SandersGFEM": {
            "type": "frequency",
            "flag": "P9",
            "channel_start_index": 1,
            "channels": {
                "P912": 912,
                "P3005": 3005,
                "P11962": 11962,
                "P24510": 24510,
                "Q912": 912,
                "Q3005": 3005,
                "Q11962": 11962,
                "Q24510": 24510,
            },
            "components": {
                "P912": "real",
                "P3005": "real",
                "P11962": "real",
                "P24510": "real",
                "Q912": "imag",
                "Q3005": "imag",
                "Q11962": "imag",
                "Q24510": "imag",
            },
            "tx_offsets": [
                [21.35, 0, 0],
                [21.35, 0, 0],
                [21.38, 0, 0],
                [21.38, 0, 0],
                [21.35, 0, 0],
                [21.35, 0, 0],
                [21.38, 0, 0],
                [21.38, 0, 0],
            ],
            "bird_offset": [0, 0, 0],
            "uncertainty": [
                [0.0, 75],
                [0.0, 150],
                [0.0, 500],
                [0.0, 800],
                [0.0, 125],
                [0.0, 300],
                [0.0, 500],
                [0.0, 500],
            ],
            "tx_specs": {"type": "VMD", "a": 1.0, "I": 1.0},
            "normalization": "ppm",
        },
        "Skytem 304M (HM)": {
            "type": "time",
            "flag": "HM",
            "channel_start_index": 8,
            "channels": {
                "[1]": 0.43e-6,
                "[2]": 1.43e-6,
                "[3]": 3.43e-6,
                "[4]": 5.43e-6,
                "[5]": 7.43e-6,
                "[6]": 9.43e-6,
                "[7]": 11.43e-6,
                "[8]": 13.43e-6,
                "[9]": 16.43e-6,
                "[10]": 20.43e-6,
                "[11]": 25.43e-6,
                "[12]": 31.43e-6,
                "[13]": 39.43e-6,
                "[14]": 49.43e-6,
                "[15]": 62.43e-6,
                "[16]": 78.43e-6,
                "[17]": 98.43e-6,
                "[18]": 123.43e-6,
                "[19]": 154.43e-6,
                "[20]": 194.43e-6,
                "[21]": 245.43e-6,
                "[22]": 308.43e-6,
                "[23]": 389.43e-6,
                "[24]": 490.43e-6,
                "[25]": 617.43e-6,
                "[26]": 778.43e-6,
                "[27]": 980.43e-6,
                "[28]": 1235.43e-6,
                "[29]": 1557.43e-6,
                "[30]": 1963.43e-6,
                "[31]": 2474.43e-6,
                "[32]": 3120.43e-6,
                "[33]": 3912.43e-6,
                "[34]": 4880.43e-6,
                "[35]": 6065.43e-6,
                "[36]": 7517.43e-6,
                "[37]": 9293.43e-6,
                "[38]": 11473.43e-6,
            },
            "uncertainty": [
                [0.05, 1e-2],
                [0.05, 1e-2],
                [0.05, 1e-2],
                [0.05, 1e-2],
                [0.05, 1e-2],
                [0.05, 1e-2],
                [0.05, 1e-2],
                [0.05, 1e-2],
                [0.05, 1e-2],
                [0.05, 1e-2],
                [0.05, 1e-2],
                [0.05, 1e-2],
                [0.05, 1e-2],
                [0.05, 1e-2],
                [0.05, 1e-2],
                [0.05, 1e-2],
                [0.05, 1e-2],
                [0.05, 1e-2],
                [0.05, 1e-2],
                [0.05, 1e-2],
                [0.05, 1e-2],
                [0.05, 1e-2],
                [0.05, 1e-2],
                [0.05, 1e-2],
                [0.05, 1e-2],
                [0.05, 1e-2],
                [0.05, 1e-2],
                [0.05, 1e-2],
                [0.05, 1e-2],
                [0.05, 1e-2],
                [0.05, 1e-2],
                [0.05, 1e-2],
                [0.05, 1e-2],
                [0.05, 1e-2],
                [0.05, 1e-2],
                [0.05, 1e-2],
                [0.05, 1e-2],
                [0.05, 1e-2],
                [0.05, 1e-2],
            ],
            "waveform": [
                [-4.895e-03, 1.000e-05],
                [-4.640e-03, 9.24906690e-01],
                [-4.385e-03, 9.32202966e-01],
                [-4.130e-03, 9.39232247e-01],
                [-3.875e-03, 9.46198635e-01],
                [-3.620e-03, 9.53165023e-01],
                [-3.365e-03, 9.60131411e-01],
                [-3.110e-03, 9.67097799e-01],
                [-2.855e-03, 9.72342365e-01],
                [-2.600e-03, 9.76662739e-01],
                [-2.345e-03, 9.80880874e-01],
                [-2.090e-03, 9.84342079e-01],
                [-1.835e-03, 9.87803283e-01],
                [-1.580e-03, 9.91264488e-01],
                [-1.325e-03, 9.94371859e-01],
                [-1.070e-03, 9.97464146e-01],
                [-8.150e-04, 1.000e00],
                [-5.600e-04, 1.000e00],
                [-3.050e-04, 1.000e00],
                [-5.000e-05, 1.000e00],
                [-4.500e-05, 1.000e00],
                [-4.000e-05, 9.57188199e-01],
                [-3.500e-05, 8.40405552e-01],
                [-3.000e-05, 7.19785772e-01],
                [-2.500e-05, 5.99026151e-01],
                [-2.000e-05, 4.77564967e-01],
                [-1.500e-05, 3.56103783e-01],
                [-1.000e-05, 2.34673120e-01],
                [-5.000e-06, 1.13453783e-01],
                [0.0, 0.0],
                [5.000e-06, 0.0],
                [1.000e-05, 0.0],
                [1.500e-05, 0.0],
                [2.000e-05, 0.0],
                [2.500e-05, 0.0],
                [3.000e-05, 0.0],
                [3.500e-05, 0.0],
                [4.000e-05, 0.0],
                [4.500e-05, 0.0],
                [5.000e-05, 0.0],
                [5.500e-05, 0.0],
                [6.000e-05, 0.0],
                [6.500e-05, 0.0],
                [7.000e-05, 0.0],
                [7.500e-05, 0.0],
                [8.000e-05, 0.0],
                [8.500e-05, 0.0],
                [9.000e-05, 0.0],
                [9.500e-05, 0.0],
                [1.000e-04, 0.0],
                [1.050e-04, 0.0],
                [1.100e-04, 0.0],
                [1.150e-04, 0.0],
                [1.200e-04, 0.0],
                [1.250e-04, 0.0],
                [1.750e-04, 0.0],
                [2.250e-04, 0.0],
                [2.750e-04, 0.0],
                [3.250e-04, 0.0],
                [3.750e-04, 0.0],
                [4.250e-04, 0.0],
                [4.750e-04, 0.0],
                [5.250e-04, 0.0],
                [5.750e-04, 0.0],
                [6.250e-04, 0.0],
                [6.750e-04, 0.0],
                [7.250e-04, 0.0],
                [7.750e-04, 0.0],
                [8.250e-04, 0.0],
                [8.750e-04, 0.0],
                [9.250e-04, 0.0],
                [9.750e-04, 0.0],
                [1.025e-03, 0.0],
                [1.075e-03, 0.0],
                [1.125e-03, 0.0],
                [1.175e-03, 0.0],
                [1.225e-03, 0.0],
                [1.275e-03, 0.0],
                [1.325e-03, 0.0],
                [1.375e-03, 0.0],
                [1.425e-03, 0.0],
                [1.475e-03, 0.0],
                [1.775e-03, 0.0],
                [2.075e-03, 0.0],
                [2.375e-03, 0.0],
                [2.675e-03, 0.0],
                [2.975e-03, 0.0],
                [3.275e-03, 0.0],
                [3.575e-03, 0.0],
                [3.875e-03, 0.0],
                [4.175e-03, 0.0],
                [4.475e-03, 0.0],
                [4.775e-03, 0.0],
                [5.075e-03, 0.0],
                [5.375e-03, 0.0],
                [5.675e-03, 0.0],
                [5.975e-03, 0.0],
                [6.275e-03, 0.0],
                [6.575e-03, 0.0],
                [6.875e-03, 0.0],
                [7.175e-03, 0.0],
                [7.475e-03, 0.0],
                [7.775e-03, 0.0],
                [8.075e-03, 0.0],
                [8.375e-03, 0.0],
                [8.675e-03, 0.0],
                [8.975e-03, 0.0],
                [9.275e-03, 0.0],
                [9.575e-03, 0.0],
                [9.875e-03, 0.0],
                [1.0175e-02, 0.0],
                [1.0475e-02, 0.0],
                [1.0775e-02, 0.0],
                [1.1075e-02, 0.0],
                [1.1375e-02, 0.0],
                [1.1675e-02, 0.0],
                [1.1975e-02, 0.0],
            ],
            "tx_specs": {"type": "VMD", "a": 1.0, "I": 1.0},
            "tx_offsets": [[-13.25, 0, 0]],
            "bird_offset": [-26.5, 0, 0],
            "normalization": [1e-12],
            "data_type": "dBzdt",
        },
        "Skytem 312HP (HM)": {
            "type": "time",
            "flag": "HM",
            "channel_start_index": 10,
            "channels": {
                "[1]": -1.7850e-06,
                "[2]": 2.850e-07,
                "[3]": 1.7150e-06,
                "[4]": 3.7150e-06,
                "[5]": 5.7150e-06,
                "[6]": 7.7150e-06,
                "[7]": 9.7150e-06,
                "[8]": 1.2215e-05,
                "[9]": 1.5715e-05,
                "[10]": 2.0215e-05,
                "[11]": 2.5715e-05,
                "[12]": 3.2715e-05,
                "[13]": 4.1715e-05,
                "[14]": 5.3215e-05,
                "[15]": 6.7715e-05,
                "[16]": 8.5715e-05,
                "[17]": 1.082150e-04,
                "[18]": 1.362150e-04,
                "[19]": 1.717150e-04,
                "[20]": 2.172150e-04,
                "[21]": 2.742150e-04,
                "[22]": 3.462150e-04,
                "[23]": 4.372150e-04,
                "[24]": 5.512150e-04,
                "[25]": 6.952150e-04,
                "[26]": 8.767150e-04,
                "[27]": 1.1052150e-03,
                "[28]": 1.3937150e-03,
                "[29]": 1.7577150e-03,
                "[30]": 2.2162150e-03,
                "[31]": 2.7947150e-03,
                "[32]": 3.5137150e-03,
                "[33]": 4.3937150e-03,
                "[34]": 5.4702150e-03,
                "[35]": 6.7887150e-03,
                "[36]": 8.4027150e-03,
                "[37]": 1.0380715e-02,
            },
            "uncertainty": [
                [0.05, 1e-2],
                [0.05, 1e-2],
                [0.05, 1e-2],
                [0.05, 1e-2],
                [0.05, 1e-2],
                [0.05, 1e-2],
                [0.05, 1e-2],
                [0.05, 1e-2],
                [0.05, 1e-2],
                [0.05, 1e-2],
                [0.05, 1e-2],
                [0.05, 1e-2],
                [0.05, 1e-2],
                [0.05, 1e-2],
                [0.05, 1e-2],
                [0.05, 1e-2],
                [0.05, 1e-2],
                [0.05, 1e-2],
                [0.05, 1e-2],
                [0.05, 1e-2],
                [0.05, 1e-2],
                [0.05, 1e-2],
                [0.05, 1e-2],
                [0.05, 1e-2],
                [0.05, 1e-2],
                [0.05, 1e-2],
                [0.05, 1e-2],
                [0.05, 1e-2],
                [0.05, 1e-2],
                [0.05, 1e-2],
                [0.05, 1e-2],
                [0.05, 1e-2],
                [0.05, 1e-2],
                [0.05, 1e-2],
                [0.05, 1e-2],
                [0.05, 1e-2],
                [0.05, 1e-2],
                [0.05, 1e-2],
                [0.05, 1e-2],
            ],
            "waveform": [
                [-4.0e-03, 1.0e-08],
                [-3.90e-03, 1.11e-01],
                [-3.80e-03, 2.22e-01],
                [-3.70e-03, 3.33e-01],
                [-3.60e-03, 4.44e-01],
                [-3.50e-03, 5.55e-01],
                [-3.40e-03, 6.66e-01],
                [-3.30e-03, 7.77e-01],
                [-3.20e-03, 8.88e-01],
                [-3.10e-03, 1.0e00],
                [-3.0e-03, 1.0e00],
                [-2.90e-03, 1.0e00],
                [-2.80e-03, 1.0e00],
                [-2.70e-03, 1.0e00],
                [-2.60e-03, 1.0e00],
                [-2.50e-03, 1.0e00],
                [-2.40e-03, 1.0e00],
                [-2.30e-03, 1.0e00],
                [-2.20e-03, 1.0e00],
                [-2.10e-03, 1.0e00],
                [-2.0e-03, 1.0e00],
                [-1.90e-03, 1.0e00],
                [-1.80e-03, 1.0e00],
                [-1.70e-03, 1.0e00],
                [-1.60e-03, 1.0e00],
                [-1.50e-03, 1.0e00],
                [-1.40e-03, 1.0e00],
                [-1.30e-03, 1.0e00],
                [-1.20e-03, 1.0e00],
                [-1.10e-03, 1.0e00],
                [-1.0e-03, 1.0e00],
                [-9.0e-04, 9.0e-01],
                [-8.0e-04, 8.0e-01],
                [-7.0e-04, 7.0e-01],
                [-6.0e-04, 6.0e-01],
                [-5.0e-04, 5.0e-01],
                [-4.0e-04, 4.0e-01],
                [-3.0e-04, 3.0e-01],
                [-2.0e-04, 2.0e-01],
                [-1.0e-04, 1.0e-01],
                [0.0e-00, 0.0e00],
                [2.0e-05, 0.0e00],
                [4.0e-05, 0.0e00],
                [6.0e-05, 0.0e00],
                [8.0e-05, 0.0e00],
                [1.0e-04, 0.0e00],
                [1.20e-04, 0.0e00],
                [1.40e-04, 0.0e00],
                [1.60e-04, 0.0e00],
                [1.80e-04, 0.0e00],
                [2.0e-04, 0.0e00],
                [2.60e-04, 0.0e00],
                [3.20e-04, 0.0e00],
                [3.80e-04, 0.0e00],
                [4.40e-04, 0.0e00],
                [5.0e-04, 0.0e00],
                [5.60e-04, 0.0e00],
                [6.20e-04, 0.0e00],
                [6.80e-04, 0.0e00],
                [7.40e-04, 0.0e00],
                [8.0e-04, 0.0e00],
                [8.60e-04, 0.0e00],
                [9.20e-04, 0.0e00],
                [9.80e-04, 0.0e00],
                [1.04e-03, 0.0e00],
                [1.10e-03, 0.0e00],
                [1.16e-03, 0.0e00],
                [1.20e-03, 0.0e00],
                [1.70e-03, 0.0e00],
                [2.20e-03, 0.0e00],
                [2.70e-03, 0.0e00],
                [3.20e-03, 0.0e00],
                [3.70e-03, 0.0e00],
                [4.20e-03, 0.0e00],
                [4.70e-03, 0.0e00],
                [5.20e-03, 0.0e00],
                [5.70e-03, 0.0e00],
                [6.20e-03, 0.0e00],
                [6.70e-03, 0.0e00],
                [7.20e-03, 0.0e00],
                [7.70e-03, 0.0e00],
                [8.20e-03, 0.0e00],
                [8.70e-03, 0.0e00],
                [9.20e-03, 0.0e00],
                [9.70e-03, 0.0e00],
                [1.02e-02, 0.0e00],
                [1.07e-02, 0.0e00],
            ],
            "tx_specs": {"type": "VMD", "a": 1.0, "I": 1.0},
            "tx_offsets": [[-13.25, 0, 0]],
            "bird_offset": [-26.5, 0, 0],
            "normalization": [1e-12],
            "data_type": "dBzdt",
        },
        "Skytem 516M (HM)": {
            "type": "time",
            "flag": "HM",
            "channel_start_index": 20,
            "channels": {
                "[1]": 7.115e-06,
                "[2]": 8.615e-06,
                "[3]": 1.0615e-05,
                "[4]": 1.2615e-05,
                "[5]": 1.4615e-05,
                "[6]": 1.6615e-05,
                "[7]": 1.8615e-05,
                "[8]": 2.1115e-05,
                "[9]": 2.4615e-05,
                "[10]": 2.9115e-05,
                "[11]": 3.4615e-05,
                "[12]": 4.1615e-05,
                "[13]": 5.0615e-05,
                "[14]": 6.2115e-05,
                "[15]": 7.6615e-05,
                "[16]": 9.4615e-05,
                "[17]": 11.7115e-05,
                "[18]": 14.5115e-05,
                "[19]": 18.0615e-05,
                "[20]": 22.6114e-05,
                "[21]": 28.3115e-05,
                "[22]": 35.5115e-05,
                "[23]": 44.6114e-05,
                "[24]": 56.0115e-05,
                "[25]": 70.4115e-05,
                "[26]": 88.5615e-05,
                "[27]": 110.8614e-5,
                "[28]": 137.7614e-5,
                "[29]": 169.9114e-5,
                "[30]": 207.8615e-5,
                "[31]": 252.2614e-5,
                "[32]": 303.7114e-5,
                "[33]": 362.6614e-5,
                "[34]": 431.4114e-5,
                "[35]": 513.2115e-5,
                "[36]": 610.5614e-5,
                "[37]": 726.4614e-5,
                "[38]": 864.3614e-5,
                "[39]": 1028.3615e-5,
            },
            "uncertainty": [
                [0.05, 1e-2],
                [0.05, 1e-2],
                [0.05, 1e-2],
                [0.05, 1e-2],
                [0.05, 1e-2],
                [0.05, 1e-2],
                [0.05, 1e-2],
                [0.05, 1e-2],
                [0.05, 1e-2],
                [0.05, 1e-2],
                [0.05, 1e-2],
                [0.05, 1e-2],
                [0.05, 1e-2],
                [0.05, 1e-2],
                [0.05, 1e-2],
                [0.05, 1e-2],
                [0.05, 1e-2],
                [0.05, 1e-2],
                [0.05, 1e-2],
                [0.05, 1e-2],
                [0.05, 1e-2],
                [0.05, 1e-2],
                [0.05, 1e-2],
                [0.05, 1e-2],
                [0.05, 1e-2],
                [0.05, 1e-2],
                [0.05, 1e-2],
                [0.05, 1e-2],
                [0.05, 1e-2],
                [0.05, 1e-2],
                [0.05, 1e-2],
                [0.05, 1e-2],
                [0.05, 1e-2],
                [0.05, 1e-2],
                [0.05, 1e-2],
                [0.05, 1e-2],
                [0.05, 1e-2],
                [0.05, 1e-2],
                [0.05, 1e-2],
            ],
            "waveform": [
                [-3.650e-03, 1e-8],
                [-3.400e-03, 1.000e00],
                [-3.150e-03, 1.000e00],
                [-2.900e-03, 1.000e00],
                [-2.650e-03, 1.000e00],
                [-2.400e-03, 1.000e00],
                [-2.150e-03, 1.000e00],
                [-1.900e-03, 1.000e00],
                [-1.650e-03, 1.000e00],
                [-1.400e-03, 1.000e00],
                [-1.150e-03, 1.000e00],
                [-9.000e-04, 1.000e00],
                [-8.500e-04, 1.000e00],
                [-8.000e-04, 9.375e-01],
                [-7.500e-04, 8.750e-01],
                [-7.000e-04, 8.125e-01],
                [-6.500e-04, 7.500e-01],
                [-6.000e-04, 6.875e-01],
                [-5.500e-04, 6.250e-01],
                [-5.000e-04, 5.625e-01],
                [-4.500e-04, 5.000e-01],
                [-4.000e-04, 4.375e-01],
                [-3.500e-04, 3.750e-01],
                [-3.000e-04, 3.125e-01],
                [-2.500e-04, 2.500e-01],
                [-2.000e-04, 1.875e-01],
                [-1.500e-04, 1.250e-01],
                [-1.000e-04, 6.250e-02],
                [-5.000e-05, 0.000e00],
                [0.000e00, 0.000e00],
                [2.000e-06, 0.000e00],
                [4.000e-06, 0.000e00],
                [6.000e-06, 0.000e00],
                [8.000e-06, 0.000e00],
                [1.000e-05, 0.000e00],
                [1.200e-05, 0.000e00],
                [1.400e-05, 0.000e00],
                [1.600e-05, 0.000e00],
                [1.800e-05, 0.000e00],
                [2.000e-05, 0.000e00],
                [2.200e-05, 0.000e00],
                [2.400e-05, 0.000e00],
                [2.600e-05, 0.000e00],
                [3.100e-05, 0.000e00],
                [3.600e-05, 0.000e00],
                [4.100e-05, 0.000e00],
                [4.600e-05, 0.000e00],
                [5.100e-05, 0.000e00],
                [5.600e-05, 0.000e00],
                [6.100e-05, 0.000e00],
                [6.600e-05, 0.000e00],
                [7.100e-05, 0.000e00],
                [7.600e-05, 0.000e00],
                [8.100e-05, 0.000e00],
                [8.600e-05, 0.000e00],
                [9.100e-05, 0.000e00],
                [9.600e-05, 0.000e00],
                [1.010e-04, 0.000e00],
                [1.060e-04, 0.000e00],
                [1.110e-04, 0.000e00],
                [1.160e-04, 0.000e00],
                [1.210e-04, 0.000e00],
                [1.260e-04, 0.000e00],
                [1.310e-04, 0.000e00],
                [1.360e-04, 0.000e00],
                [1.410e-04, 0.000e00],
                [1.460e-04, 0.000e00],
                [1.510e-04, 0.000e00],
                [2.010e-04, 0.000e00],
                [2.510e-04, 0.000e00],
                [3.010e-04, 0.000e00],
                [3.510e-04, 0.000e00],
                [4.010e-04, 0.000e00],
                [4.510e-04, 0.000e00],
                [5.010e-04, 0.000e00],
                [5.510e-04, 0.000e00],
                [6.010e-04, 0.000e00],
                [6.510e-04, 0.000e00],
                [7.010e-04, 0.000e00],
                [7.510e-04, 0.000e00],
                [8.010e-04, 0.000e00],
                [8.510e-04, 0.000e00],
                [9.010e-04, 0.000e00],
                [9.510e-04, 0.000e00],
                [1.001e-03, 0.000e00],
                [1.051e-03, 0.000e00],
                [1.101e-03, 0.000e00],
                [1.151e-03, 0.000e00],
                [1.201e-03, 0.000e00],
                [1.251e-03, 0.000e00],
                [1.301e-03, 0.000e00],
                [1.351e-03, 0.000e00],
                [1.401e-03, 0.000e00],
                [1.451e-03, 0.000e00],
                [1.501e-03, 0.000e00],
                [1.551e-03, 0.000e00],
                [1.601e-03, 0.000e00],
                [1.651e-03, 0.000e00],
                [1.701e-03, 0.000e00],
                [1.751e-03, 0.000e00],
            ],
            "tx_specs": {"type": "VMD", "a": 1.0, "I": 1.0},
            "tx_offsets": [[-16.1, 0, 0]],
            "bird_offset": [-31.1, 0, 0],
            "normalization": [1e-12],
            "data_type": "dBzdt",
        },
        "Spectrem (2000)": {
            "type": "time",
            "flag": "EM_Z",
            "channel_start_index": 1,
            "channels": {
                "[1]": 10.85e-6,
                "[2]": 54.25e-6,
                "[3]": 119.35e-6,
                "[4]": 249.55e-6,
                "[5]": 509.96e-6,
                "[6]": 1030.82e-6,
                "[7]": 2072.49e-6,
                "[8]": 4155.82e-6,
            },
            "uncertainty": [
                [0.1, 32.0],
                [0.1, 16.0],
                [0.1, 8.0],
                [0.1, 4.0],
                [0.1, 2.0],
                [0.1, 1.0],
                [0.1, 0.25],
                [0.1, 0.1],
            ],
            "waveform": "stepoff",
            "tx_offsets": [[-136, 0, -39]],
            "bird_offset": [-136, 0, -39],
            "comment": "normalization accounts for unit dipole moment at the tx_offset, in part-per-2000",
            "normalization": "pp2t",
            "tx_specs": {"type": "VMD", "a": 1.0, "I": 1.0},
            "data_type": "Bz",
        },
        "Spectrem Plus": {
            "type": "time",
            "flag": "em_z",
            "channel_start_index": 1,
            "channels": {
                "[1]": 6.5e-6,
                "[2]": 26e-6,
                "[3]": 52.1e-6,
                "[4]": 104.2e-6,
                "[5]": 208.3e-6,
                "[6]": 416.7e-6,
                "[7]": 833.3e-6,
                "[8]": 1666.7e-6,
                "[9]": 3333.3e-6,
                "[10]": 6666.7e-6,
                "[11]": 13333.3e-6,
            },
            "uncertainty": [
                [0.05, 2000.0],
                [0.05, 2000.0],
                [0.05, 2000.0],
                [0.05, 2000.0],
                [0.05, 2000.0],
                [0.05, 2000.0],
                [0.05, 2000],
                [0.05, 2000.0],
                [0.05, 2000.0],
                [0.05, 2000.0],
                [0.05, 2000],
            ],
            "waveform": "stepoff",
            "tx_offsets": [[-131, 0, -36]],
            "bird_offset": [-131, 0, -36],
            "comment": "normalization accounts for unit dipole moment at the tx_offset, in part-per-million",
            "normalization": "ppm",
            "tx_specs": {"type": "VMD", "a": 1.0, "I": 1.0},
            "data_type": "Bz",
        },
        "VTEM (2007)": {
            "type": "time",
            "flag": "Sf",
            "channel_start_index": 9,
            "channels": {
                "[1]": 0e1,
                "[2]": 0e1,
                "[3]": 0e1,
                "[4]": 0e1,
                "[5]": 0e1,
                "[6]": 0e1,
                "[7]": 0e1,
                "[8]": 0e1,
                "[9]": 99e-6,
                "[10]": 120e-6,
                "[11]": 141e-6,
                "[12]": 167e-6,
                "[13]": 198e-6,
                "[14]": 234e-6,
                "[15]": 281e-6,
                "[16]": 339e-6,
                "[17]": 406e-6,
                "[18]": 484e-6,
                "[19]": 573e-6,
                "[20]": 682e-6,
                "[21]": 818e-6,
                "[22]": 974e-6,
                "[23]": 1151e-6,
                "[24]": 1370e-6,
                "[25]": 1641e-6,
                "[26]": 1953e-6,
                "[27]": 2307e-6,
                "[28]": 2745e-6,
                "[29]": 3286e-6,
                "[30]": 3911e-6,
                "[31]": 4620e-6,
                "[32]": 5495e-6,
                "[33]": 6578e-6,
                "[34]": 7828e-6,
                "[35]": 9245e-6,
            },
            "uncertainty": [
                [0.1, 5e-4],
                [0.1, 5e-4],
                [0.1, 5e-4],
                [0.1, 5e-4],
                [0.1, 5e-4],
                [0.1, 5e-4],
                [0.1, 5e-4],
                [0.1, 5e-4],
                [0.1, 5e-4],
                [0.1, 5e-4],
                [0.1, 5e-4],
                [0.1, 5e-4],
                [0.1, 5e-4],
                [0.1, 5e-4],
                [0.1, 5e-4],
                [0.1, 5e-4],
                [0.1, 5e-4],
                [0.1, 5e-4],
                [0.1, 5e-4],
                [0.1, 5e-4],
                [0.1, 5e-4],
                [0.1, 5e-4],
                [0.1, 5e-4],
                [0.1, 5e-4],
                [0.1, 5e-4],
                [0.1, 5e-4],
                [0.1, 5e-4],
                [0.1, 5e-4],
                [0.1, 5e-4],
                [0.1, 5e-4],
                [0.1, 5e-4],
                [0.1, 5e-4],
                [0.1, 5e-4],
                [0.1, 5e-4],
                [0.1, 5e-4],
            ],
            "waveform": [
                [-4.30e-03, 1.0e-08],
                [-4.20e-03, 3.34253e-02],
                [-4.10e-03, 1.16092e-01],
                [-4.0e-03, 1.97080e-01],
                [-3.90e-03, 2.75748e-01],
                [-3.80e-03, 3.51544e-01],
                [-3.70e-03, 4.23928e-01],
                [-3.60e-03, 4.92386e-01],
                [-3.50e-03, 5.56438e-01],
                [-3.40e-03, 6.15645e-01],
                [-3.30e-03, 6.69603e-01],
                [-3.20e-03, 7.17955e-01],
                [-3.10e-03, 7.60389e-01],
                [-3.0e-03, 7.96642e-01],
                [-2.90e-03, 8.26499e-01],
                [-2.80e-03, 8.49796e-01],
                [-2.70e-03, 8.66421e-01],
                [-2.60e-03, 8.78934e-01],
                [-2.50e-03, 8.91465e-01],
                [-2.40e-03, 9.03901e-01],
                [-2.30e-03, 9.16161e-01],
                [-2.20e-03, 9.28239e-01],
                [-2.10e-03, 9.40151e-01],
                [-2.0e-03, 9.51908e-01],
                [-1.90e-03, 9.63509e-01],
                [-1.80e-03, 9.74953e-01],
                [-1.70e-03, 9.86240e-01],
                [-1.60e-03, 9.97372e-01],
                [-1.50e-03, 1.0e00],
                [-1.40e-03, 9.65225e-01],
                [-1.30e-03, 9.23590e-01],
                [-1.20e-03, 8.75348e-01],
                [-1.10e-03, 8.20965e-01],
                [-1.0e-03, 7.60913e-01],
                [-9.0e-04, 6.95697e-01],
                [-8.0e-04, 6.25858e-01],
                [-7.0e-04, 5.51972e-01],
                [-6.0e-04, 4.74644e-01],
                [-5.0e-04, 3.94497e-01],
                [-4.0e-04, 3.12171e-01],
                [-3.0e-04, 2.28318e-01],
                [-2.0e-04, 1.43599e-01],
                [-1.0e-04, 5.86805e-02],
                [0.0e00, 0.0e00],
                [2.0e-05, 0.0e00],
                [4.0e-05, 0.0e00],
                [6.0e-05, 0.0e00],
                [8.0e-05, 0.0e00],
                [1.0e-04, 0.0e00],
                [1.20e-04, 0.0e00],
                [1.40e-04, 0.0e00],
                [1.60e-04, 0.0e00],
                [1.80e-04, 0.0e00],
                [2.0e-04, 0.0e00],
                [2.20e-04, 0.0e00],
                [2.40e-04, 0.0e00],
                [2.60e-04, 0.0e00],
                [2.80e-04, 0.0e00],
                [3.0e-04, 0.0e00],
                [3.90e-04, 0.0e00],
                [4.70e-04, 0.0e00],
                [5.50e-04, 0.0e00],
                [6.30e-04, 0.0e00],
                [7.10e-04, 0.0e00],
                [7.90e-04, 0.0e00],
                [8.70e-04, 0.0e00],
                [9.50e-04, 0.0e00],
                [1.03e-03, 0.0e00],
                [1.11e-03, 0.0e00],
                [1.19e-03, 0.0e00],
                [1.27e-03, 0.0e00],
                [1.35e-03, 0.0e00],
                [1.43e-03, 0.0e00],
                [1.51e-03, 0.0e00],
                [1.59e-03, 0.0e00],
                [1.67e-03, 0.0e00],
                [1.75e-03, 0.0e00],
                [1.83e-03, 0.0e00],
                [1.91e-03, 0.0e00],
                [1.99e-03, 0.0e00],
                [2.07e-03, 0.0e00],
                [2.15e-03, 0.0e00],
                [2.23e-03, 0.0e00],
                [2.31e-03, 0.0e00],
                [2.35e-03, 0.0e00],
                [2.65e-03, 0.0e00],
                [2.95e-03, 0.0e00],
                [3.25e-03, 0.0e00],
                [3.55e-03, 0.0e00],
                [3.85e-03, 0.0e00],
                [4.15e-03, 0.0e00],
                [4.45e-03, 0.0e00],
                [4.75e-03, 0.0e00],
                [5.05e-03, 0.0e00],
                [5.35e-03, 0.0e00],
                [5.65e-03, 0.0e00],
                [5.95e-03, 0.0e00],
                [6.25e-03, 0.0e00],
                [6.55e-03, 0.0e00],
                [6.85e-03, 0.0e00],
                [7.15e-03, 0.0e00],
                [7.45e-03, 0.0e00],
                [7.75e-03, 0.0e00],
                [8.05e-03, 0.0e00],
                [8.35e-03, 0.0e00],
                [8.65e-03, 0.0e00],
                [8.95e-03, 0.0e00],
                [9.25e-03, 0.0e00],
                [9.55e-03, 0.0e00],
                [9.85e-03, 0.0e00],
                [1.0150e-02, 0.0e00],
                [1.0450e-02, 0.0e00],
                [1.0750e-02, 0.0e00],
            ],
            "tx_offsets": [[0, 0, 0]],
            "bird_offset": [0, 0, 0],
            "normalization": [531, 1e-12],
            "tx_specs": {"type": "CircularLoop", "a": 13.0, "I": 1.0},
            "data_type": "dBzdt",
        },
        "VTEM Plus": {
            "type": "time",
            "flag": "SFz",
            "channel_start_index": 14,
            "channels": {
                "[1]": 0e1,
                "[2]": 0e1,
                "[3]": 0e1,
                "[4]": 21e-6,
                "[5]": 26e-6,
                "[6]": 31e-6,
                "[7]": 36e-6,
                "[8]": 42e-6,
                "[9]": 48e-6,
                "[10]": 55e-6,
                "[11]": 63e-6,
                "[12]": 73e-6,
                "[13]": 83e-6,
                "[14]": 96e-6,
                "[15]": 110e-6,
                "[16]": 126e-6,
                "[17]": 145e-6,
                "[18]": 167e-6,
                "[19]": 192e-6,
                "[20]": 220e-6,
                "[21]": 253e-6,
                "[22]": 290e-6,
                "[23]": 333e-6,
                "[24]": 383e-6,
                "[25]": 440e-6,
                "[26]": 505e-6,
                "[27]": 580e-6,
                "[28]": 667e-6,
                "[29]": 766e-6,
                "[30]": 880e-6,
                "[31]": 1010e-6,
                "[32]": 1161e-6,
                "[33]": 1333e-6,
                "[34]": 1531e-6,
                "[35]": 1760e-6,
                "[36]": 2021e-6,
                "[37]": 2323e-6,
                "[38]": 2667e-6,
                "[39]": 3063e-6,
                "[40]": 3521e-6,
                "[41]": 4042e-6,
                "[42]": 4641e-6,
                "[43]": 5333e-6,
                "[44]": 6125e-6,
                "[45]": 7036e-6,
                "[46]": 8083e-6,
            },
            "uncertainty": [
                [0.05, 1e-3],
                [0.05, 1e-3],
                [0.05, 1e-3],
                [0.05, 1e-3],
                [0.05, 1e-3],
                [0.05, 1e-3],
                [0.05, 1e-3],
                [0.05, 1e-3],
                [0.05, 1e-3],
                [0.05, 1e-3],
                [0.05, 1e-3],
                [0.05, 1e-3],
                [0.05, 1e-3],
                [0.05, 1e-3],
                [0.05, 1e-3],
                [0.05, 1e-3],
                [0.05, 1e-3],
                [0.05, 1e-3],
                [0.05, 1e-3],
                [0.05, 1e-3],
                [0.05, 1e-3],
                [0.05, 1e-3],
                [0.05, 1e-3],
                [0.05, 1e-3],
                [0.05, 1e-3],
                [0.05, 1e-3],
                [0.05, 1e-3],
                [0.05, 1e-3],
                [0.05, 1e-3],
                [0.05, 1e-3],
                [0.05, 1e-3],
                [0.05, 1e-3],
                [0.05, 1e-3],
                [0.05, 1e-3],
                [0.05, 1e-3],
                [0.05, 1e-3],
                [0.05, 1e-3],
                [0.05, 1e-3],
                [0.05, 1e-3],
                [0.05, 1e-3],
                [0.05, 1e-3],
                [0.05, 1e-3],
                [0.05, 1e-3],
                [0.05, 1e-3],
                [0.05, 1e-3],
                [0.05, 1e-3],
            ],
            "waveform": [
                [-6.90000000e-03, 1.65109034e-01],
                [-6.80000000e-03, 2.38693737e-01],
                [-6.70000000e-03, 3.10076270e-01],
                [-6.60000000e-03, 3.81995918e-01],
                [-6.50000000e-03, 3.96712859e-01],
                [-6.40000000e-03, 3.93651305e-01],
                [-6.30000000e-03, 3.91771404e-01],
                [-6.20000000e-03, 4.42206467e-01],
                [-6.10000000e-03, 5.04189494e-01],
                [-6.00000000e-03, 5.65259426e-01],
                [-5.90000000e-03, 6.19078311e-01],
                [-5.80000000e-03, 6.68385433e-01],
                [-5.70000000e-03, 6.94328070e-01],
                [-5.60000000e-03, 6.89547749e-01],
                [-5.50000000e-03, 6.84230315e-01],
                [-5.40000000e-03, 7.04586959e-01],
                [-5.30000000e-03, 7.41540445e-01],
                [-5.20000000e-03, 7.75539800e-01],
                [-5.10000000e-03, 8.04221721e-01],
                [-5.00000000e-03, 8.28499302e-01],
                [-4.90000000e-03, 8.43699646e-01],
                [-4.80000000e-03, 8.38489634e-01],
                [-4.70000000e-03, 8.32420238e-01],
                [-4.60000000e-03, 8.29788377e-01],
                [-4.50000000e-03, 8.41658610e-01],
                [-4.40000000e-03, 8.54119669e-01],
                [-4.30000000e-03, 8.65775056e-01],
                [-4.20000000e-03, 8.77376732e-01],
                [-4.10000000e-03, 8.88172736e-01],
                [-4.00000000e-03, 8.86829950e-01],
                [-3.90000000e-03, 8.80491997e-01],
                [-3.80000000e-03, 8.74315179e-01],
                [-3.70000000e-03, 8.81888495e-01],
                [-3.60000000e-03, 8.93221613e-01],
                [-3.50000000e-03, 9.05038135e-01],
                [-3.40000000e-03, 9.16156408e-01],
                [-3.30000000e-03, 9.27704372e-01],
                [-3.20000000e-03, 9.31249329e-01],
                [-3.10000000e-03, 9.24642819e-01],
                [-3.00000000e-03, 9.17660329e-01],
                [-2.90000000e-03, 9.20023633e-01],
                [-2.80000000e-03, 9.30336234e-01],
                [-2.70000000e-03, 9.41669352e-01],
                [-2.60000000e-03, 9.51767107e-01],
                [-2.50000000e-03, 9.62885380e-01],
                [-2.40000000e-03, 9.71479214e-01],
                [-2.30000000e-03, 9.65248684e-01],
                [-2.20000000e-03, 9.58373617e-01],
                [-2.10000000e-03, 9.54291546e-01],
                [-2.00000000e-03, 9.64443012e-01],
                [-1.90000000e-03, 9.74809324e-01],
                [-1.80000000e-03, 9.85068214e-01],
                [-1.70000000e-03, 9.95219680e-01],
                [-1.60000000e-03, 1.00000000e00],
                [-1.50000000e-03, 9.70136427e-01],
                [-1.40000000e-03, 9.32753250e-01],
                [-1.30000000e-03, 8.93651305e-01],
                [-1.20000000e-03, 8.44505317e-01],
                [-1.10000000e-03, 7.92512622e-01],
                [-1.00000000e-03, 7.35900741e-01],
                [-9.00000000e-04, 6.74938232e-01],
                [-8.00000000e-04, 6.10108497e-01],
                [-7.00000000e-04, 5.41894940e-01],
                [-6.00000000e-04, 4.70727253e-01],
                [-5.00000000e-04, 3.89300677e-01],
                [-4.00000000e-04, 3.17595875e-01],
                [-3.00000000e-04, 2.36491567e-01],
                [-2.00000000e-04, 1.62638307e-01],
                [-1.00000000e-04, 8.43807068e-02],
                [-0.00000000e00, 0.00000000e00],
                [5.00000000e-06, 0.00000000e00],
                [1.00000000e-05, 0.00000000e00],
                [1.50000000e-05, 0.00000000e00],
                [2.00000000e-05, 0.00000000e00],
                [2.50000000e-05, 0.00000000e00],
                [3.00000000e-05, 0.00000000e00],
                [3.50000000e-05, 0.00000000e00],
                [4.00000000e-05, 0.00000000e00],
                [4.50000000e-05, 0.00000000e00],
                [5.00000000e-05, 0.00000000e00],
                [5.50000000e-05, 0.00000000e00],
                [6.00000000e-05, 0.00000000e00],
                [6.50000000e-05, 0.00000000e00],
                [7.00000000e-05, 0.00000000e00],
                [7.50000000e-05, 0.00000000e00],
                [8.00000000e-05, 0.00000000e00],
                [8.50000000e-05, 0.00000000e00],
                [9.00000000e-05, 0.00000000e00],
                [9.50000000e-05, 0.00000000e00],
                [1.00000000e-04, 0.00000000e00],
                [1.05000000e-04, 0.00000000e00],
                [1.10000000e-04, 0.00000000e00],
                [1.20000000e-04, 0.00000000e00],
                [1.30000000e-04, 0.00000000e00],
                [1.40000000e-04, 0.00000000e00],
                [1.50000000e-04, 0.00000000e00],
                [1.60000000e-04, 0.00000000e00],
                [1.70000000e-04, 0.00000000e00],
                [1.80000000e-04, 0.00000000e00],
                [1.90000000e-04, 0.00000000e00],
                [2.00000000e-04, 0.00000000e00],
                [2.10000000e-04, 0.00000000e00],
                [2.20000000e-04, 0.00000000e00],
                [2.30000000e-04, 0.00000000e00],
                [2.40000000e-04, 0.00000000e00],
                [2.50000000e-04, 0.00000000e00],
                [2.60000000e-04, 0.00000000e00],
                [2.70000000e-04, 0.00000000e00],
                [2.80000000e-04, 0.00000000e00],
                [2.90000000e-04, 0.00000000e00],
                [3.00000000e-04, 0.00000000e00],
                [3.50000000e-04, 0.00000000e00],
                [4.00000000e-04, 0.00000000e00],
                [4.50000000e-04, 0.00000000e00],
                [5.00000000e-04, 0.00000000e00],
                [5.50000000e-04, 0.00000000e00],
                [6.00000000e-04, 0.00000000e00],
                [6.50000000e-04, 0.00000000e00],
                [7.00000000e-04, 0.00000000e00],
                [7.50000000e-04, 0.00000000e00],
                [8.00000000e-04, 0.00000000e00],
                [8.50000000e-04, 0.00000000e00],
                [9.00000000e-04, 0.00000000e00],
                [9.50000000e-04, 0.00000000e00],
                [1.00000000e-03, 0.00000000e00],
                [1.05000000e-03, 0.00000000e00],
                [1.10000000e-03, 0.00000000e00],
                [1.15000000e-03, 0.00000000e00],
                [1.20000000e-03, 0.00000000e00],
                [1.25000000e-03, 0.00000000e00],
                [1.30000000e-03, 0.00000000e00],
                [1.35000000e-03, 0.00000000e00],
                [1.40000000e-03, 0.00000000e00],
                [1.65000000e-03, 0.00000000e00],
                [1.90000000e-03, 0.00000000e00],
                [2.15000000e-03, 0.00000000e00],
                [2.40000000e-03, 0.00000000e00],
                [2.65000000e-03, 0.00000000e00],
                [2.90000000e-03, 0.00000000e00],
                [3.15000000e-03, 0.00000000e00],
                [3.40000000e-03, 0.00000000e00],
                [3.65000000e-03, 0.00000000e00],
                [3.90000000e-03, 0.00000000e00],
                [4.15000000e-03, 0.00000000e00],
                [4.40000000e-03, 0.00000000e00],
                [4.65000000e-03, 0.00000000e00],
                [4.90000000e-03, 0.00000000e00],
                [5.15000000e-03, 0.00000000e00],
                [5.40000000e-03, 0.00000000e00],
                [5.65000000e-03, 0.00000000e00],
                [5.90000000e-03, 0.00000000e00],
                [6.15000000e-03, 0.00000000e00],
                [6.40000000e-03, 0.00000000e00],
                [6.65000000e-03, 0.00000000e00],
                [6.90000000e-03, 0.00000000e00],
                [7.15000000e-03, 0.00000000e00],
                [7.40000000e-03, 0.00000000e00],
                [7.65000000e-03, 0.00000000e00],
                [7.90000000e-03, 0.00000000e00],
                [8.15000000e-03, 0.00000000e00],
                [8.40000000e-03, 0.00000000e00],
            ],
            "tx_offsets": [[0, 0, 0]],
            "bird_offset": [-25, 0, -34],
            "normalization": [3.1416, 1e-12],
            "tx_specs": {"type": "CircularLoop", "a": 1.0, "I": 1.0},
            "data_type": "dBzdt",
        },
        "VTEM Max": {
            "type": "time",
            "flag": "SFz",
            "channel_start_index": 14,
            "channels": {
                "[1]": 0e1,
                "[2]": 0e1,
                "[3]": 0e1,
                "[4]": 21e-6,
                "[5]": 26e-6,
                "[6]": 31e-6,
                "[7]": 36e-6,
                "[8]": 42e-6,
                "[9]": 48e-6,
                "[10]": 55e-6,
                "[11]": 63e-6,
                "[12]": 73e-6,
                "[13]": 83e-6,
                "[14]": 96e-6,
                "[15]": 110e-6,
                "[16]": 126e-6,
                "[17]": 145e-6,
                "[18]": 167e-6,
                "[19]": 192e-6,
                "[20]": 220e-6,
                "[21]": 253e-6,
                "[22]": 290e-6,
                "[23]": 333e-6,
                "[24]": 383e-6,
                "[25]": 440e-6,
                "[26]": 505e-6,
                "[27]": 580e-6,
                "[28]": 667e-6,
                "[29]": 766e-6,
                "[30]": 880e-6,
                "[31]": 1010e-6,
                "[32]": 1161e-6,
                "[33]": 1333e-6,
                "[34]": 1531e-6,
                "[35]": 1760e-6,
                "[36]": 2021e-6,
                "[37]": 2323e-6,
                "[38]": 2667e-6,
                "[39]": 3063e-6,
                "[40]": 3521e-6,
                "[41]": 4042e-6,
                "[42]": 4641e-6,
                "[43]": 5333e-6,
                "[44]": 6125e-6,
                "[45]": 7036e-6,
                "[46]": 8083e-6,
            },
            "uncertainty": [
                [0.05, 1e-3],
                [0.05, 1e-3],
                [0.05, 1e-3],
                [0.05, 1e-3],
                [0.05, 1e-3],
                [0.05, 1e-3],
                [0.05, 1e-3],
                [0.05, 1e-3],
                [0.05, 1e-3],
                [0.05, 1e-3],
                [0.05, 1e-3],
                [0.05, 1e-3],
                [0.05, 1e-3],
                [0.05, 1e-3],
                [0.05, 1e-3],
                [0.05, 1e-3],
                [0.05, 1e-3],
                [0.05, 1e-3],
                [0.05, 1e-3],
                [0.05, 1e-3],
                [0.05, 1e-3],
                [0.05, 1e-3],
                [0.05, 1e-3],
                [0.05, 1e-3],
                [0.05, 1e-3],
                [0.05, 1e-3],
                [0.05, 1e-3],
                [0.05, 1e-3],
                [0.05, 1e-3],
                [0.05, 1e-3],
                [0.05, 1e-3],
                [0.05, 1e-3],
                [0.05, 1e-3],
                [0.05, 1e-3],
                [0.05, 1e-3],
                [0.05, 1e-3],
                [0.05, 1e-3],
                [0.05, 1e-3],
                [0.05, 1e-3],
                [0.05, 1e-3],
                [0.05, 1e-3],
                [0.05, 1e-3],
                [0.05, 1e-3],
                [0.05, 1e-3],
                [0.05, 1e-3],
                [0.05, 1e-3],
            ],
            "waveform": [
                [-6.90000000e-03, 1.65109034e-01],
                [-6.80000000e-03, 2.38693737e-01],
                [-6.70000000e-03, 3.10076270e-01],
                [-6.60000000e-03, 3.81995918e-01],
                [-6.50000000e-03, 3.96712859e-01],
                [-6.40000000e-03, 3.93651305e-01],
                [-6.30000000e-03, 3.91771404e-01],
                [-6.20000000e-03, 4.42206467e-01],
                [-6.10000000e-03, 5.04189494e-01],
                [-6.00000000e-03, 5.65259426e-01],
                [-5.90000000e-03, 6.19078311e-01],
                [-5.80000000e-03, 6.68385433e-01],
                [-5.70000000e-03, 6.94328070e-01],
                [-5.60000000e-03, 6.89547749e-01],
                [-5.50000000e-03, 6.84230315e-01],
                [-5.40000000e-03, 7.04586959e-01],
                [-5.30000000e-03, 7.41540445e-01],
                [-5.20000000e-03, 7.75539800e-01],
                [-5.10000000e-03, 8.04221721e-01],
                [-5.00000000e-03, 8.28499302e-01],
                [-4.90000000e-03, 8.43699646e-01],
                [-4.80000000e-03, 8.38489634e-01],
                [-4.70000000e-03, 8.32420238e-01],
                [-4.60000000e-03, 8.29788377e-01],
                [-4.50000000e-03, 8.41658610e-01],
                [-4.40000000e-03, 8.54119669e-01],
                [-4.30000000e-03, 8.65775056e-01],
                [-4.20000000e-03, 8.77376732e-01],
                [-4.10000000e-03, 8.88172736e-01],
                [-4.00000000e-03, 8.86829950e-01],
                [-3.90000000e-03, 8.80491997e-01],
                [-3.80000000e-03, 8.74315179e-01],
                [-3.70000000e-03, 8.81888495e-01],
                [-3.60000000e-03, 8.93221613e-01],
                [-3.50000000e-03, 9.05038135e-01],
                [-3.40000000e-03, 9.16156408e-01],
                [-3.30000000e-03, 9.27704372e-01],
                [-3.20000000e-03, 9.31249329e-01],
                [-3.10000000e-03, 9.24642819e-01],
                [-3.00000000e-03, 9.17660329e-01],
                [-2.90000000e-03, 9.20023633e-01],
                [-2.80000000e-03, 9.30336234e-01],
                [-2.70000000e-03, 9.41669352e-01],
                [-2.60000000e-03, 9.51767107e-01],
                [-2.50000000e-03, 9.62885380e-01],
                [-2.40000000e-03, 9.71479214e-01],
                [-2.30000000e-03, 9.65248684e-01],
                [-2.20000000e-03, 9.58373617e-01],
                [-2.10000000e-03, 9.54291546e-01],
                [-2.00000000e-03, 9.64443012e-01],
                [-1.90000000e-03, 9.74809324e-01],
                [-1.80000000e-03, 9.85068214e-01],
                [-1.70000000e-03, 9.95219680e-01],
                [-1.60000000e-03, 1.00000000e00],
                [-1.50000000e-03, 9.70136427e-01],
                [-1.40000000e-03, 9.32753250e-01],
                [-1.30000000e-03, 8.93651305e-01],
                [-1.20000000e-03, 8.44505317e-01],
                [-1.10000000e-03, 7.92512622e-01],
                [-1.00000000e-03, 7.35900741e-01],
                [-9.00000000e-04, 6.74938232e-01],
                [-8.00000000e-04, 6.10108497e-01],
                [-7.00000000e-04, 5.41894940e-01],
                [-6.00000000e-04, 4.70727253e-01],
                [-5.00000000e-04, 3.89300677e-01],
                [-4.00000000e-04, 3.17595875e-01],
                [-3.00000000e-04, 2.36491567e-01],
                [-2.00000000e-04, 1.62638307e-01],
                [-1.00000000e-04, 8.43807068e-02],
                [-0.00000000e00, 0.00000000e00],
                [5.00000000e-06, 0.00000000e00],
                [1.00000000e-05, 0.00000000e00],
                [1.50000000e-05, 0.00000000e00],
                [2.00000000e-05, 0.00000000e00],
                [2.50000000e-05, 0.00000000e00],
                [3.00000000e-05, 0.00000000e00],
                [3.50000000e-05, 0.00000000e00],
                [4.00000000e-05, 0.00000000e00],
                [4.50000000e-05, 0.00000000e00],
                [5.00000000e-05, 0.00000000e00],
                [5.50000000e-05, 0.00000000e00],
                [6.00000000e-05, 0.00000000e00],
                [6.50000000e-05, 0.00000000e00],
                [7.00000000e-05, 0.00000000e00],
                [7.50000000e-05, 0.00000000e00],
                [8.00000000e-05, 0.00000000e00],
                [8.50000000e-05, 0.00000000e00],
                [9.00000000e-05, 0.00000000e00],
                [9.50000000e-05, 0.00000000e00],
                [1.00000000e-04, 0.00000000e00],
                [1.05000000e-04, 0.00000000e00],
                [1.10000000e-04, 0.00000000e00],
                [1.20000000e-04, 0.00000000e00],
                [1.30000000e-04, 0.00000000e00],
                [1.40000000e-04, 0.00000000e00],
                [1.50000000e-04, 0.00000000e00],
                [1.60000000e-04, 0.00000000e00],
                [1.70000000e-04, 0.00000000e00],
                [1.80000000e-04, 0.00000000e00],
                [1.90000000e-04, 0.00000000e00],
                [2.00000000e-04, 0.00000000e00],
                [2.10000000e-04, 0.00000000e00],
                [2.20000000e-04, 0.00000000e00],
                [2.30000000e-04, 0.00000000e00],
                [2.40000000e-04, 0.00000000e00],
                [2.50000000e-04, 0.00000000e00],
                [2.60000000e-04, 0.00000000e00],
                [2.70000000e-04, 0.00000000e00],
                [2.80000000e-04, 0.00000000e00],
                [2.90000000e-04, 0.00000000e00],
                [3.00000000e-04, 0.00000000e00],
                [3.50000000e-04, 0.00000000e00],
                [4.00000000e-04, 0.00000000e00],
                [4.50000000e-04, 0.00000000e00],
                [5.00000000e-04, 0.00000000e00],
                [5.50000000e-04, 0.00000000e00],
                [6.00000000e-04, 0.00000000e00],
                [6.50000000e-04, 0.00000000e00],
                [7.00000000e-04, 0.00000000e00],
                [7.50000000e-04, 0.00000000e00],
                [8.00000000e-04, 0.00000000e00],
                [8.50000000e-04, 0.00000000e00],
                [9.00000000e-04, 0.00000000e00],
                [9.50000000e-04, 0.00000000e00],
                [1.00000000e-03, 0.00000000e00],
                [1.05000000e-03, 0.00000000e00],
                [1.10000000e-03, 0.00000000e00],
                [1.15000000e-03, 0.00000000e00],
                [1.20000000e-03, 0.00000000e00],
                [1.25000000e-03, 0.00000000e00],
                [1.30000000e-03, 0.00000000e00],
                [1.35000000e-03, 0.00000000e00],
                [1.40000000e-03, 0.00000000e00],
                [1.65000000e-03, 0.00000000e00],
                [1.90000000e-03, 0.00000000e00],
                [2.15000000e-03, 0.00000000e00],
                [2.40000000e-03, 0.00000000e00],
                [2.65000000e-03, 0.00000000e00],
                [2.90000000e-03, 0.00000000e00],
                [3.15000000e-03, 0.00000000e00],
                [3.40000000e-03, 0.00000000e00],
                [3.65000000e-03, 0.00000000e00],
                [3.90000000e-03, 0.00000000e00],
                [4.15000000e-03, 0.00000000e00],
                [4.40000000e-03, 0.00000000e00],
                [4.65000000e-03, 0.00000000e00],
                [4.90000000e-03, 0.00000000e00],
                [5.15000000e-03, 0.00000000e00],
                [5.40000000e-03, 0.00000000e00],
                [5.65000000e-03, 0.00000000e00],
                [5.90000000e-03, 0.00000000e00],
                [6.15000000e-03, 0.00000000e00],
                [6.40000000e-03, 0.00000000e00],
                [6.65000000e-03, 0.00000000e00],
                [6.90000000e-03, 0.00000000e00],
                [7.15000000e-03, 0.00000000e00],
                [7.40000000e-03, 0.00000000e00],
                [7.65000000e-03, 0.00000000e00],
                [7.90000000e-03, 0.00000000e00],
                [8.15000000e-03, 0.00000000e00],
                [8.40000000e-03, 0.00000000e00],
            ],
            "tx_offsets": [[0, 0, 0]],
            "bird_offset": [-27, 0, -44],
            "normalization": [3.1416, 1e-12],
            "tx_specs": {"type": "CircularLoop", "a": 1.0, "I": 1.0},
            "data_type": "dBzdt",
        },
    }
