# coding: utf-8

"""
    EXACT - API

    API to interact with the EXACT Server  # noqa: E501

    OpenAPI spec version: 1.0.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import
from exact_sync.v1.api.pagination_base_api import PaginationBaseAPI
import re  # noqa: F401

from tqdm import tqdm
from pathlib import Path
# python 2 and python 3 compatibility library
import six

from exact_sync.v1.api_client import ApiClient


class ImagesApi(PaginationBaseAPI):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def create_image(self, **kwargs):  # noqa: E501
        """create_image  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_image(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str file_path:
        :param int image_type:
        :param int image_set:
        :return: Image
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_image_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.create_image_with_http_info(**kwargs)  # noqa: E501
            return data

    def create_image_with_http_info(self, **kwargs):  # noqa: E501
        """create_image  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_image_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str file_path:
        :param int image_type:
        :param int image_set:
        :return: Image
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['file_path', 'image_type', 'image_set']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_image" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'file_path' in params:
            local_var_files['file_path'] = params['file_path']  # noqa: E501
        if 'image_type' in params:
            form_params.append(('image_type', params['image_type']))  # noqa: E501
        if 'image_set' in params:
            form_params.append(('image_set', params['image_set']))  # noqa: E501



        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/images/images/', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Images',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def destroy_image(self, id, **kwargs):  # noqa: E501
        """destroy_image  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.destroy_image(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.destroy_image_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.destroy_image_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def destroy_image_with_http_info(self, id, **kwargs):  # noqa: E501
        """destroy_image  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.destroy_image_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method destroy_image" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `destroy_image`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []
        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/images/images/{id}/', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_images(self, pagination:bool=True, omit="annotations" ,**kwargs):  # noqa: E501
        """list_images  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_images(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int limit: Number of results to return per page.
        :param int offset: The initial index from which to return the results.
        :param str id: id
        :param str omit: fields to exclude
        :param str name: name
        :param str name__contains: name__contains
        :param str filename: filename
        :param str filename__contains: filename__contains
        :param str time: time
        :param str time__contains: time__contains
        :param str mpp: mpp
        :param str mpp__range: mpp__range
        :param str objective_power: objectivePower
        :param str objective_power__range: objectivePower__range
        :param str width: width
        :param str width__range: width__range
        :param str height: height
        :param str height__range: height__range
        :param str image_set: image_set
        :param str image_type: image_type
        :return: Images
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        kwargs['omit'] = omit
        if pagination:
            if kwargs.get('async_req'):
                return self.__list_images_with_http_info(**kwargs)  # noqa: E501
            else:
                (data) = self.__list_images_with_http_info(**kwargs)  # noqa: E501
                return data
        else:
            return self._get_all(self.__list_images_with_http_info, **kwargs)

    def __list_images_with_http_info(self, **kwargs):  # noqa: E501
        """list_images  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_images_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int limit: Number of results to return per page.
        :param int offset: The initial index from which to return the results.
        :param str id: id
        :param str name: name
        :param str name__contains: name__contains
        :param str filename: filename
        :param str filename__contains: filename__contains
        :param str time: time
        :param str time__contains: time__contains
        :param str mpp: mpp
        :param str mpp__range: mpp__range
        :param str objective_power: objectivePower
        :param str objective_power__range: objectivePower__range
        :param str width: width
        :param str width__range: width__range
        :param str height: height
        :param str height__range: height__range
        :param str image_set: image_set
        :param str image_type: image_type
        :return: Images
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['limit', 'offset', 'id', 'name', 'name__contains', 'filename', 'filename__contains', 'time', 'time__contains', 'mpp', 'mpp__range', 'objective_power', 'objective_power__range', 'width', 'width__range', 'height', 'height__range', 'image_set', 'image_type']  # noqa: E501
        all_params.append('omit')
        all_params.append('fields')
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_images" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501
        if 'offset' in params:
            query_params.append(('offset', params['offset']))  # noqa: E501
        if 'id' in params:
            query_params.append(('id', params['id']))  # noqa: E501
        if 'name' in params:
            query_params.append(('name', params['name']))  # noqa: E501
        if 'name__contains' in params:
            query_params.append(('name__contains', params['name__contains']))  # noqa: E501
        if 'filename' in params:
            query_params.append(('filename', params['filename']))  # noqa: E501
        if 'filename__contains' in params:
            query_params.append(('filename__contains', params['filename__contains']))  # noqa: E501
        if 'time' in params:
            query_params.append(('time', params['time']))  # noqa: E501
        if 'time__contains' in params:
            query_params.append(('time__contains', params['time__contains']))  # noqa: E501
        if 'mpp' in params:
            query_params.append(('mpp', params['mpp']))  # noqa: E501
        if 'mpp__range' in params:
            query_params.append(('mpp__range', params['mpp__range']))  # noqa: E501
        if 'objective_power' in params:
            query_params.append(('objective_power', params['objective_power']))  # noqa: E501
        if 'objective_power__range' in params:
            query_params.append(('objectivePower__range', params['objective_power__range']))  # noqa: E501
        if 'width' in params:
            query_params.append(('width', params['width']))  # noqa: E501
        if 'width__range' in params:
            query_params.append(('width__range', params['width__range']))  # noqa: E501
        if 'height' in params:
            query_params.append(('height', params['height']))  # noqa: E501
        if 'height__range' in params:
            query_params.append(('height__range', params['height__range']))  # noqa: E501
        if 'image_set' in params:
            query_params.append(('image_set', params['image_set']))  # noqa: E501
        if 'image_type' in params:
            query_params.append(('image_type', params['image_type']))  # noqa: E501
        if 'omit' in params:
            query_params.append(('omit', params['omit']))  # noqa: E501
        if 'fields' in params:
            query_params.append(('fields', params['fields']))  # noqa: E501
            
        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/images/images/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Images',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def partial_update_image(self, id, **kwargs):  # noqa: E501
        """partial_update_image  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.partial_update_image(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: (required)
        :param float mpp
        :param float objective_power
        :param int image_type
        :param int image_set
        :return: Image
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.partial_update_image_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.partial_update_image_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def partial_update_image_with_http_info(self, id, **kwargs):  # noqa: E501
        """partial_update_image  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.partial_update_image_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: (required)
        :param float mpp
        :param float objective_power
        :param int image_type
        :param int image_set
        :return: Image
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id', 'mpp', 'objective_power', 'image_set', 'image_type']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method partial_update_image" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `partial_update_image`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = {}
        if 'mpp' in params:
            body_params['mpp'] = params['mpp']
        if 'objective_power' in params:
            body_params['objectivePower'] = params['objective_power']
        if 'image_set' in params:
            body_params['image_set'] = params['image_set']
        if 'image_type' in params:
            body_params['image_type'] = params['image_type']


        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'application/x-www-form-urlencoded', 'multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/images/images/{id}/', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Image',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def retrieve_image(self, id, **kwargs):  # noqa: E501
        """retrieve_image  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.retrieve_image(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: (required)
        :param str id2: id
        :param str name: name
        :param str name__contains: name__contains
        :param str filename: filename
        :param str filename__contains: filename__contains
        :param str time: time
        :param str time__contains: time__contains
        :param str mpp: mpp
        :param str mpp__range: mpp__range
        :param str objective_power: objectivePower
        :param str objective_power__range: objectivePower__range
        :param str width: width
        :param str width__range: width__range
        :param str height: height
        :param str height__range: height__range
        :param str image_set: image_set
        :param str image_type: image_type
        :return: Image
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.retrieve_image_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.retrieve_image_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def retrieve_image_with_http_info(self, id, **kwargs):  # noqa: E501
        """retrieve_image  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.retrieve_image_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: (required)
        :param str id2: id
        :param str name: name
        :param str name__contains: name__contains
        :param str filename: filename
        :param str filename__contains: filename__contains
        :param str time: time
        :param str time__contains: time__contains
        :param str mpp: mpp
        :param str mpp__range: mpp__range
        :param str objective_power: objectivePower
        :param str objective_power__range: objectivePower__range
        :param str width: width
        :param str width__range: width__range
        :param str height: height
        :param str height__range: height__range
        :param str image_set: image_set
        :param str image_type: image_type
        :return: Image
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id', 'id2', 'name', 'name__contains', 'filename', 'filename__contains', 'time', 'time__contains', 'mpp', 'mpp__range', 'objective_power', 'objective_power__range', 'width', 'width__range', 'height', 'height__range', 'image_set', 'image_type']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method retrieve_image" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `retrieve_image`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []
        if 'id2' in params:
            query_params.append(('id', params['id2']))  # noqa: E501
        if 'name' in params:
            query_params.append(('name', params['name']))  # noqa: E501
        if 'name__contains' in params:
            query_params.append(('name__contains', params['name__contains']))  # noqa: E501
        if 'filename' in params:
            query_params.append(('filename', params['filename']))  # noqa: E501
        if 'filename__contains' in params:
            query_params.append(('filename__contains', params['filename__contains']))  # noqa: E501
        if 'time' in params:
            query_params.append(('time', params['time']))  # noqa: E501
        if 'time__contains' in params:
            query_params.append(('time__contains', params['time__contains']))  # noqa: E501
        if 'mpp' in params:
            query_params.append(('mpp', params['mpp']))  # noqa: E501
        if 'mpp__range' in params:
            query_params.append(('mpp__range', params['mpp__range']))  # noqa: E501
        if 'objective_power' in params:
            query_params.append(('objectivePower', params['objective_power']))  # noqa: E501
        if 'objective_power__range' in params:
            query_params.append(('objectivePower__range', params['objective_power__range']))  # noqa: E501
        if 'width' in params:
            query_params.append(('width', params['width']))  # noqa: E501
        if 'width__range' in params:
            query_params.append(('width__range', params['width__range']))  # noqa: E501
        if 'height' in params:
            query_params.append(('height', params['height']))  # noqa: E501
        if 'height__range' in params:
            query_params.append(('height__range', params['height__range']))  # noqa: E501
        if 'image_set' in params:
            query_params.append(('image_set', params['image_set']))  # noqa: E501
        if 'image_type' in params:
            query_params.append(('image_type', params['image_type']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/images/images/{id}/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Image',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_image(self, id, **kwargs):  # noqa: E501
        """update_image  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_image(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: (required)
        :param Image body:
        :return: Image
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_image_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_image_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def update_image_with_http_info(self, id, **kwargs):  # noqa: E501
        """update_image  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_image_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: (required)
        :param Image body:
        :return: Image
                 If the method is called asynchronously,
                 returns the request thread.
        """
        raise NotImplementedError('update_image_with_http_info')

        all_params = ['id', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_image" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `update_image`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []
        header_params = {}

        form_params = []
        local_var_files = {}
        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'application/x-www-form-urlencoded', 'multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/images/images/{id}/', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Image',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def download_image(self, id, target_path:Path, **kwargs):

        all_params = ['id', 'original_image']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method retrieve_image" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `retrieve_image`")  # noqa: E501

        collection_formats = {}
        path_params = {}
        header_params = {}

        query_params = []
        if 'original_image' in params:
            query_params.append(('original_image', params['original_image']))  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        response, status_code, header = self.api_client.call_api(
            '/images/api/image/download/{}/'.format(id), 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Image',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', False),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)


        with response as r:
            with open(str(target_path),'wb') as f:
                chunk_size=8192
                while True:
                    data = r.read(chunk_size)
                    if not data: break
                    f.write(data)

        return status_code, target_path

