"""Analysis GUI for scanning SQUID microscopy datasets generated by the
[scanning-squid](https://github.com/moler-group/scanning-squid) python package.
"""

from setuptools import setup, find_packages

DESCRIPTION = "Analysis GUI for scanning SQUID microscopy"
LONG_DESCRIPTION = __doc__

NAME = "ssm_analyze"
AUTHOR = "Logan Bishop-Van Horn"
AUTHOR_EMAIL = "logan.bvh@gmail.com"
URL = "https://github.com/loganbvh/ssm_analyze"
LICENSE = "MIT"
PYTHON_VERSION = ">=3.6"

INSTALL_REQUIRES = [
    "h5py",
    "ipykernel",
    "ipython",
    "jupyter",
    "jupyter_console",
    "matplotlib",
    "numpy",
    "pint",
    "PyQt5",
    "pyqtgraph",
    "qcodes",
    "qtpy",
    "scipy",
]

CLASSIFIERS = """\
Development Status :: 4 - Beta
Intended Audience :: Science/Research
License :: OSI Approved :: MIT License
Operating System :: MacOS
Operating System :: POSIX
Operating System :: Unix
Operating System :: Microsoft :: Windows
Programming Language :: Python
Programming Language :: Python :: 3.6
Programming Language :: Python :: 3.7
Programming Language :: Python :: 3.8
Programming Language :: Python :: 3.9
Topic :: Scientific/Engineering
Topic :: Scientific/Engineering :: Physics
"""

CLASSIFIERS = [line for line in CLASSIFIERS.splitlines() if line]
PLATFORMS = ["Linux", "Mac OSX", "Unix", "Windows"]
KEYWORDS = "scanning SQUID microscopy"


setup(
    name=NAME,
    version="0.1.3",
    author=AUTHOR,
    author_email=AUTHOR_EMAIL,
    url=URL,
    license=LICENSE,
    packages=find_packages(),
    include_package_data=True,
    entry_points = {
        "console_scripts": ["ssm_analyze=ssm_analyze.gui.window:main"],
    },
    description=DESCRIPTION,
    long_description=LONG_DESCRIPTION,
    long_description_content_type="text/markdown",
    keywords=KEYWORDS,
    classifiers=CLASSIFIERS,
    platforms=PLATFORMS,
    python_requires=PYTHON_VERSION,
    install_requires=INSTALL_REQUIRES,
)