#!/usr/bin/python
#
# Copyright 2018-2023 Polyaxon, Inc.
# This file and its contents are licensed under the AGPLv3 License.
# Please see the included NOTICE for copyright information and
# LICENSE-AGPL for a copy of the license.

from haupt.common.options.option import Option, OptionScope, OptionStores
from polyaxon import types

POLYAXON_ENVIRONMENT = "POLYAXON_ENVIRONMENT"
PLATFORM_VERSION = "PLATFORM_VERSION"
PLATFORM_DIST = "PLATFORM_DIST"
PLATFORM_HOST = "PLATFORM_HOST"
CHART_VERSION = "CHART_VERSION"
ORGANIZATION_KEY = "POLYAXON_ORGANIZATION_KEY"

OPTIONS = {
    POLYAXON_ENVIRONMENT,
    PLATFORM_VERSION,
    PLATFORM_DIST,
    PLATFORM_HOST,
    CHART_VERSION,
    ORGANIZATION_KEY,
}


class PlatformEnvironmentVersion(Option):
    key = POLYAXON_ENVIRONMENT
    scope = OptionScope.GLOBAL
    is_secret = False
    is_optional = True
    is_list = False
    typing = types.STR
    store = OptionStores.SETTINGS
    default = None
    options = None


class PlatformVersion(Option):
    key = PLATFORM_VERSION
    scope = OptionScope.GLOBAL
    is_secret = False
    is_optional = True
    is_list = False
    typing = types.STR
    store = OptionStores.SETTINGS
    default = None
    options = None


class PlatformDist(Option):
    key = PLATFORM_DIST
    scope = OptionScope.GLOBAL
    is_secret = False
    is_optional = True
    is_list = False
    typing = types.STR
    store = OptionStores.SETTINGS
    default = None
    options = None


class PlatformHost(Option):
    key = PLATFORM_HOST
    scope = OptionScope.GLOBAL
    is_secret = False
    is_optional = True
    is_list = False
    store = OptionStores.SETTINGS
    typing = types.STR
    default = None
    options = None


class ChartVersion(Option):
    key = CHART_VERSION
    scope = OptionScope.GLOBAL
    is_secret = False
    is_optional = True
    is_list = False
    typing = types.STR
    store = OptionStores.SETTINGS
    default = None
    options = None


class OrganizationKey(Option):
    key = ORGANIZATION_KEY
    scope = OptionScope.GLOBAL
    is_secret = False
    is_optional = True
    is_list = False
    typing = types.STR
    store = OptionStores.ENV
    default = None
    options = None
