import * as lambda from '@aws-cdk/aws-lambda';
import * as cdk from '@aws-cdk/core';
/**
 * An Alexa Skill, either managed by this CDK app, or imported.
 *
 * @stability stable
 */
export interface ISkill extends cdk.IResource {
    /**
     * The ID associated with this Skill.
     *
     * @stability stable
     * @attribute true
     */
    readonly skillId: string;
}
declare abstract class SkillBase extends cdk.Resource implements ISkill {
    abstract readonly skillId: string;
}
/**
 * Construction properties for an Alexa Skill object.
 *
 * @stability stable
 */
export interface SkillProps {
    /**
     * The Lambda Function to be configured as the endpoint for the Alexa Skill.
     *
     * @default - No endpoint Lambda Function
     * @stability stable
     */
    readonly endpointLambdaFunction?: lambda.IFunction;
    /**
     * The relative path to the skill package directory containing all configuration files for the Alexa Skill.
     *
     * @stability stable
     */
    readonly skillPackagePath: string;
    /**
     * Vendor ID associated with Alexa Developer account.
     *
     * @stability stable
     */
    readonly alexaVendorId: string;
    /**
     * Client ID of Login with Amazon (LWA) Security Profile.
     *
     * @stability stable
     */
    readonly lwaClientId: string;
    /**
     * Client secret associated with Login with Amazon (LWA) Client ID.
     *
     * @stability stable
     */
    readonly lwaClientSecret: cdk.SecretValue;
    /**
     * Refresh token associated with Login with Amazon (LWA) Security Profile.
     *
     * @stability stable
     */
    readonly lwaRefreshToken: cdk.SecretValue;
}
/**
 * Defines an Alexa Skill.
 *
 * @stability stable
 * @resource Alexa::ASK::Skill
 */
export declare class Skill extends SkillBase {
    /**
     * Reference an existing Skill, defined outside of the CDK code, by Skill ID.
     *
     * @stability stable
     */
    static fromSkillId(scope: cdk.Construct, id: string, skillId: string): ISkill;
    /**
     * The Skill ID of this Alexa Skill.
     *
     * @stability stable
     */
    readonly skillId: string;
    /**
     * @stability stable
     */
    constructor(scope: cdk.Construct, id: string, props: SkillProps);
}
export {};
