from unittest import TestCase

from glassbox_sdk.glassbox import GlassBox
from glassbox_sdk.glassbox_config import GlassBoxConfig, ModelRef
from glassbox_sdk.glassbox_model import GlassBoxModel, Purpose
from glassbox_sdk.spi.benchmark import MeanSquaredError, MeanAbsoluteError, R2Score, ExplainedVarianceScore, \
    MeanPinballLoss, D2PinballScore, D2AbsoluteErrorScore
from glassbox_sdk.spi.code import GitTag
from glassbox_sdk.spi.data import Dataset
from glassbox_sdk.spi.label import Label
from glassbox_sdk.spi.license import License
from glassbox_sdk.spi.property import Property
from glassbox_sdk.spi.validation import Logging


def to_base64(path: str):
    import base64
    with open(path, "rb") as img_file:
        my_string = base64.b64encode(img_file.read())
        return "data:image/png;base64," + my_string.decode('utf-8')

class AbcTest(TestCase):

    def test_abc(self):
        config = GlassBoxConfig(url="https://odq9ysmgu2.execute-api.eu-central-1.amazonaws.com/Beta/api/dispatch",
                                api_key="CYAYQSDVJ0EHL8M4WMW5",
                                api_secret="Z6NiFr9KtkGZM5FMRwU9NdCH5PzC4W4nzlHhcJhrvgQ")

        glassbox = GlassBox(config)

        model = GlassBoxModel(ModelRef("leftshiftone", "house-pricing", "1.0.12", "cpu-fp32"))
        model.checksum = "93649268ff4cc0cbd9cbf755399d5b0a"
        model.size = 128776000
        model.url = "https://github.com/leftshiftone/house-pricing-demo"
        model.license = License("leftshiftone", "http://leftshift.one/LICENSE")
        model.add_label(Label.TABULAR_CLASSIFICATION)
        model.add_label(Label.SCIKIT_LEARN)

        model.add_property(Property.SEED_VALUE, 123)
        model.add_property(Property.TRAIN_TEST_SPLIT, 0.2)

        model.add_hyper_parameters({
            "type": "RandomForrestRegressor",
            "bootstrap": True,
            "ccp_alpha": 0.0,
            "criterion": "squared_error",
            "max_depth": None,
            "max_features": 1.0,
            "max_leaf_nodes": None,
            "max_samples": None,
            "min_impurity_decrease": 0.0,
            "min_samples_leaf": 1,
            "min_samples_split": 2,
            "min_weight_fraction_leaf": 0.0,
            "n_estimators": 100,
            "n_jobs": None,
            "oob_score": False,
            "random_state": None,
            "verbose": 0,
            "warm_start": False,
            "estimator_0": {
                "ccp_alpha": 0.0,
                "criterion": "squared_error",
                "max_depth": None,
                "max_features": 1.0,
                "max_leaf_nodes": None,
                "min_impurity_decrease": 0.0,
                "min_samples_leaf": 1,
                "min_samples_split": 2,
                "min_weight_fraction_leaf": 0.0,
                "random_state": 1893742662,
                "splitter": "best"
            },
            "estimator_1": {
                "ccp_alpha": 0.0,
                "criterion": "squared_error",
                "max_depth": None,
                "max_features": 1.0,
                "max_leaf_nodes": None,
                "min_impurity_decrease": 0.0,
                "min_samples_leaf": 1,
                "min_samples_split": 2,
                "min_weight_fraction_leaf": 0.0,
                "random_state": 972764206,
                "splitter": "best"
            },
            "estimator_2": {
                "ccp_alpha": 0.0,
                "criterion": "squared_error",
                "max_depth": None,
                "max_features": 1.0,
                "max_leaf_nodes": None,
                "min_impurity_decrease": 0.0,
                "min_samples_leaf": 1,
                "min_samples_split": 2,
                "min_weight_fraction_leaf": 0.0,
                "random_state": 1944421437,
                "splitter": "best"
            },
            "estimator_3": {
                "ccp_alpha": 0.0,
                "criterion": "squared_error",
                "max_depth": None,
                "max_features": 1.0,
                "max_leaf_nodes": None,
                "min_impurity_decrease": 0.0,
                "min_samples_leaf": 1,
                "min_samples_split": 2,
                "min_weight_fraction_leaf": 0.0,
                "random_state": 2061619374,
                "splitter": "best"
            },
            "estimator_4": {
                "ccp_alpha": 0.0,
                "criterion": "squared_error",
                "max_depth": None,
                "max_features": 1.0,
                "max_leaf_nodes": None,
                "min_impurity_decrease": 0.0,
                "min_samples_leaf": 1,
                "min_samples_split": 2,
                "min_weight_fraction_leaf": 0.0,
                "random_state": 879659716,
                "splitter": "best"
            },
            "estimator_5": {
                "ccp_alpha": 0.0,
                "criterion": "squared_error",
                "max_depth": None,
                "max_features": 1.0,
                "max_leaf_nodes": None,
                "min_impurity_decrease": 0.0,
                "min_samples_leaf": 1,
                "min_samples_split": 2,
                "min_weight_fraction_leaf": 0.0,
                "random_state": 1801683172,
                "splitter": "best"
            },
            "estimator_6": {
                "ccp_alpha": 0.0,
                "criterion": "squared_error",
                "max_depth": None,
                "max_features": 1.0,
                "max_leaf_nodes": None,
                "min_impurity_decrease": 0.0,
                "min_samples_leaf": 1,
                "min_samples_split": 2,
                "min_weight_fraction_leaf": 0.0,
                "random_state": 357206447,
                "splitter": "best"
            },
            "estimator_7": {
                "ccp_alpha": 0.0,
                "criterion": "squared_error",
                "max_depth": None,
                "max_features": 1.0,
                "max_leaf_nodes": None,
                "min_impurity_decrease": 0.0,
                "min_samples_leaf": 1,
                "min_samples_split": 2,
                "min_weight_fraction_leaf": 0.0,
                "random_state": 1372827334,
                "splitter": "best"
            },
            "estimator_8": {
                "ccp_alpha": 0.0,
                "criterion": "squared_error",
                "max_depth": None,
                "max_features": 1.0,
                "max_leaf_nodes": None,
                "min_impurity_decrease": 0.0,
                "min_samples_leaf": 1,
                "min_samples_split": 2,
                "min_weight_fraction_leaf": 0.0,
                "random_state": 1858995904,
                "splitter": "best"
            },
            "estimator_9": {
                "ccp_alpha": 0.0,
                "criterion": "squared_error",
                "max_depth": None,
                "max_features": 1.0,
                "max_leaf_nodes": None,
                "min_impurity_decrease": 0.0,
                "min_samples_leaf": 1,
                "min_samples_split": 2,
                "min_weight_fraction_leaf": 0.0,
                "random_state": 704772313,
                "splitter": "best"
            },
            "estimator_10": {
                "ccp_alpha": 0.0,
                "criterion": "squared_error",
                "max_depth": None,
                "max_features": 1.0,
                "max_leaf_nodes": None,
                "min_impurity_decrease": 0.0,
                "min_samples_leaf": 1,
                "min_samples_split": 2,
                "min_weight_fraction_leaf": 0.0,
                "random_state": 928521916,
                "splitter": "best"
            },
            "estimator_11": {
                "ccp_alpha": 0.0,
                "criterion": "squared_error",
                "max_depth": None,
                "max_features": 1.0,
                "max_leaf_nodes": None,
                "min_impurity_decrease": 0.0,
                "min_samples_leaf": 1,
                "min_samples_split": 2,
                "min_weight_fraction_leaf": 0.0,
                "random_state": 248386668,
                "splitter": "best"
            },
            "estimator_12": {
                "ccp_alpha": 0.0,
                "criterion": "squared_error",
                "max_depth": None,
                "max_features": 1.0,
                "max_leaf_nodes": None,
                "min_impurity_decrease": 0.0,
                "min_samples_leaf": 1,
                "min_samples_split": 2,
                "min_weight_fraction_leaf": 0.0,
                "random_state": 231431994,
                "splitter": "best"
            },
            "estimator_13": {
                "ccp_alpha": 0.0,
                "criterion": "squared_error",
                "max_depth": None,
                "max_features": 1.0,
                "max_leaf_nodes": None,
                "min_impurity_decrease": 0.0,
                "min_samples_leaf": 1,
                "min_samples_split": 2,
                "min_weight_fraction_leaf": 0.0,
                "random_state": 571865862,
                "splitter": "best"
            },
            "estimator_14": {
                "ccp_alpha": 0.0,
                "criterion": "squared_error",
                "max_depth": None,
                "max_features": 1.0,
                "max_leaf_nodes": None,
                "min_impurity_decrease": 0.0,
                "min_samples_leaf": 1,
                "min_samples_split": 2,
                "min_weight_fraction_leaf": 0.0,
                "random_state": 2120152098,
                "splitter": "best"
            },
            "estimator_15": {
                "ccp_alpha": 0.0,
                "criterion": "squared_error",
                "max_depth": None,
                "max_features": 1.0,
                "max_leaf_nodes": None,
                "min_impurity_decrease": 0.0,
                "min_samples_leaf": 1,
                "min_samples_split": 2,
                "min_weight_fraction_leaf": 0.0,
                "random_state": 10434394,
                "splitter": "best"
            },
            "estimator_16": {
                "ccp_alpha": 0.0,
                "criterion": "squared_error",
                "max_depth": None,
                "max_features": 1.0,
                "max_leaf_nodes": None,
                "min_impurity_decrease": 0.0,
                "min_samples_leaf": 1,
                "min_samples_split": 2,
                "min_weight_fraction_leaf": 0.0,
                "random_state": 817613295,
                "splitter": "best"
            },
            "estimator_17": {
                "ccp_alpha": 0.0,
                "criterion": "squared_error",
                "max_depth": None,
                "max_features": 1.0,
                "max_leaf_nodes": None,
                "min_impurity_decrease": 0.0,
                "min_samples_leaf": 1,
                "min_samples_split": 2,
                "min_weight_fraction_leaf": 0.0,
                "random_state": 1110118470,
                "splitter": "best"
            },
            "estimator_18": {
                "ccp_alpha": 0.0,
                "criterion": "squared_error",
                "max_depth": None,
                "max_features": 1.0,
                "max_leaf_nodes": None,
                "min_impurity_decrease": 0.0,
                "min_samples_leaf": 1,
                "min_samples_split": 2,
                "min_weight_fraction_leaf": 0.0,
                "random_state": 633438204,
                "splitter": "best"
            },
            "estimator_19": {
                "ccp_alpha": 0.0,
                "criterion": "squared_error",
                "max_depth": None,
                "max_features": 1.0,
                "max_leaf_nodes": None,
                "min_impurity_decrease": 0.0,
                "min_samples_leaf": 1,
                "min_samples_split": 2,
                "min_weight_fraction_leaf": 0.0,
                "random_state": 853959262,
                "splitter": "best"
            },
            "estimator_20": {
                "ccp_alpha": 0.0,
                "criterion": "squared_error",
                "max_depth": None,
                "max_features": 1.0,
                "max_leaf_nodes": None,
                "min_impurity_decrease": 0.0,
                "min_samples_leaf": 1,
                "min_samples_split": 2,
                "min_weight_fraction_leaf": 0.0,
                "random_state": 1867829157,
                "splitter": "best"
            },
            "estimator_21": {
                "ccp_alpha": 0.0,
                "criterion": "squared_error",
                "max_depth": None,
                "max_features": 1.0,
                "max_leaf_nodes": None,
                "min_impurity_decrease": 0.0,
                "min_samples_leaf": 1,
                "min_samples_split": 2,
                "min_weight_fraction_leaf": 0.0,
                "random_state": 1972381126,
                "splitter": "best"
            },
            "estimator_22": {
                "ccp_alpha": 0.0,
                "criterion": "squared_error",
                "max_depth": None,
                "max_features": 1.0,
                "max_leaf_nodes": None,
                "min_impurity_decrease": 0.0,
                "min_samples_leaf": 1,
                "min_samples_split": 2,
                "min_weight_fraction_leaf": 0.0,
                "random_state": 310414367,
                "splitter": "best"
            },
            "estimator_23": {
                "ccp_alpha": 0.0,
                "criterion": "squared_error",
                "max_depth": None,
                "max_features": 1.0,
                "max_leaf_nodes": None,
                "min_impurity_decrease": 0.0,
                "min_samples_leaf": 1,
                "min_samples_split": 2,
                "min_weight_fraction_leaf": 0.0,
                "random_state": 338693251,
                "splitter": "best"
            },
            "estimator_24": {
                "ccp_alpha": 0.0,
                "criterion": "squared_error",
                "max_depth": None,
                "max_features": 1.0,
                "max_leaf_nodes": None,
                "min_impurity_decrease": 0.0,
                "min_samples_leaf": 1,
                "min_samples_split": 2,
                "min_weight_fraction_leaf": 0.0,
                "random_state": 101137620,
                "splitter": "best"
            },
            "estimator_25": {
                "ccp_alpha": 0.0,
                "criterion": "squared_error",
                "max_depth": None,
                "max_features": 1.0,
                "max_leaf_nodes": None,
                "min_impurity_decrease": 0.0,
                "min_samples_leaf": 1,
                "min_samples_split": 2,
                "min_weight_fraction_leaf": 0.0,
                "random_state": 1588705399,
                "splitter": "best"
            },
            "estimator_26": {
                "ccp_alpha": 0.0,
                "criterion": "squared_error",
                "max_depth": None,
                "max_features": 1.0,
                "max_leaf_nodes": None,
                "min_impurity_decrease": 0.0,
                "min_samples_leaf": 1,
                "min_samples_split": 2,
                "min_weight_fraction_leaf": 0.0,
                "random_state": 385868527,
                "splitter": "best"
            },
            "estimator_27": {
                "ccp_alpha": 0.0,
                "criterion": "squared_error",
                "max_depth": None,
                "max_features": 1.0,
                "max_leaf_nodes": None,
                "min_impurity_decrease": 0.0,
                "min_samples_leaf": 1,
                "min_samples_split": 2,
                "min_weight_fraction_leaf": 0.0,
                "random_state": 2026369355,
                "splitter": "best"
            },
            "estimator_28": {
                "ccp_alpha": 0.0,
                "criterion": "squared_error",
                "max_depth": None,
                "max_features": 1.0,
                "max_leaf_nodes": None,
                "min_impurity_decrease": 0.0,
                "min_samples_leaf": 1,
                "min_samples_split": 2,
                "min_weight_fraction_leaf": 0.0,
                "random_state": 1375497759,
                "splitter": "best"
            },
            "estimator_29": {
                "ccp_alpha": 0.0,
                "criterion": "squared_error",
                "max_depth": None,
                "max_features": 1.0,
                "max_leaf_nodes": None,
                "min_impurity_decrease": 0.0,
                "min_samples_leaf": 1,
                "min_samples_split": 2,
                "min_weight_fraction_leaf": 0.0,
                "random_state": 79350012,
                "splitter": "best"
            },
            "estimator_30": {
                "ccp_alpha": 0.0,
                "criterion": "squared_error",
                "max_depth": None,
                "max_features": 1.0,
                "max_leaf_nodes": None,
                "min_impurity_decrease": 0.0,
                "min_samples_leaf": 1,
                "min_samples_split": 2,
                "min_weight_fraction_leaf": 0.0,
                "random_state": 1545266943,
                "splitter": "best"
            },
            "estimator_31": {
                "ccp_alpha": 0.0,
                "criterion": "squared_error",
                "max_depth": None,
                "max_features": 1.0,
                "max_leaf_nodes": None,
                "min_impurity_decrease": 0.0,
                "min_samples_leaf": 1,
                "min_samples_split": 2,
                "min_weight_fraction_leaf": 0.0,
                "random_state": 1323772052,
                "splitter": "best"
            },
            "estimator_32": {
                "ccp_alpha": 0.0,
                "criterion": "squared_error",
                "max_depth": None,
                "max_features": 1.0,
                "max_leaf_nodes": None,
                "min_impurity_decrease": 0.0,
                "min_samples_leaf": 1,
                "min_samples_split": 2,
                "min_weight_fraction_leaf": 0.0,
                "random_state": 239175780,
                "splitter": "best"
            },
            "estimator_33": {
                "ccp_alpha": 0.0,
                "criterion": "squared_error",
                "max_depth": None,
                "max_features": 1.0,
                "max_leaf_nodes": None,
                "min_impurity_decrease": 0.0,
                "min_samples_leaf": 1,
                "min_samples_split": 2,
                "min_weight_fraction_leaf": 0.0,
                "random_state": 877217639,
                "splitter": "best"
            },
            "estimator_34": {
                "ccp_alpha": 0.0,
                "criterion": "squared_error",
                "max_depth": None,
                "max_features": 1.0,
                "max_leaf_nodes": None,
                "min_impurity_decrease": 0.0,
                "min_samples_leaf": 1,
                "min_samples_split": 2,
                "min_weight_fraction_leaf": 0.0,
                "random_state": 1441664002,
                "splitter": "best"
            },
            "estimator_35": {
                "ccp_alpha": 0.0,
                "criterion": "squared_error",
                "max_depth": None,
                "max_features": 1.0,
                "max_leaf_nodes": None,
                "min_impurity_decrease": 0.0,
                "min_samples_leaf": 1,
                "min_samples_split": 2,
                "min_weight_fraction_leaf": 0.0,
                "random_state": 1062074055,
                "splitter": "best"
            },
            "estimator_36": {
                "ccp_alpha": 0.0,
                "criterion": "squared_error",
                "max_depth": None,
                "max_features": 1.0,
                "max_leaf_nodes": None,
                "min_impurity_decrease": 0.0,
                "min_samples_leaf": 1,
                "min_samples_split": 2,
                "min_weight_fraction_leaf": 0.0,
                "random_state": 353236642,
                "splitter": "best"
            },
            "estimator_37": {
                "ccp_alpha": 0.0,
                "criterion": "squared_error",
                "max_depth": None,
                "max_features": 1.0,
                "max_leaf_nodes": None,
                "min_impurity_decrease": 0.0,
                "min_samples_leaf": 1,
                "min_samples_split": 2,
                "min_weight_fraction_leaf": 0.0,
                "random_state": 1971875976,
                "splitter": "best"
            },
            "estimator_38": {
                "ccp_alpha": 0.0,
                "criterion": "squared_error",
                "max_depth": None,
                "max_features": 1.0,
                "max_leaf_nodes": None,
                "min_impurity_decrease": 0.0,
                "min_samples_leaf": 1,
                "min_samples_split": 2,
                "min_weight_fraction_leaf": 0.0,
                "random_state": 499175196,
                "splitter": "best"
            },
            "estimator_39": {
                "ccp_alpha": 0.0,
                "criterion": "squared_error",
                "max_depth": None,
                "max_features": 1.0,
                "max_leaf_nodes": None,
                "min_impurity_decrease": 0.0,
                "min_samples_leaf": 1,
                "min_samples_split": 2,
                "min_weight_fraction_leaf": 0.0,
                "random_state": 1520155447,
                "splitter": "best"
            },
            "estimator_40": {
                "ccp_alpha": 0.0,
                "criterion": "squared_error",
                "max_depth": None,
                "max_features": 1.0,
                "max_leaf_nodes": None,
                "min_impurity_decrease": 0.0,
                "min_samples_leaf": 1,
                "min_samples_split": 2,
                "min_weight_fraction_leaf": 0.0,
                "random_state": 312049644,
                "splitter": "best"
            },
            "estimator_41": {
                "ccp_alpha": 0.0,
                "criterion": "squared_error",
                "max_depth": None,
                "max_features": 1.0,
                "max_leaf_nodes": None,
                "min_impurity_decrease": 0.0,
                "min_samples_leaf": 1,
                "min_samples_split": 2,
                "min_weight_fraction_leaf": 0.0,
                "random_state": 722690131,
                "splitter": "best"
            },
            "estimator_42": {
                "ccp_alpha": 0.0,
                "criterion": "squared_error",
                "max_depth": None,
                "max_features": 1.0,
                "max_leaf_nodes": None,
                "min_impurity_decrease": 0.0,
                "min_samples_leaf": 1,
                "min_samples_split": 2,
                "min_weight_fraction_leaf": 0.0,
                "random_state": 1059346804,
                "splitter": "best"
            },
            "estimator_43": {
                "ccp_alpha": 0.0,
                "criterion": "squared_error",
                "max_depth": None,
                "max_features": 1.0,
                "max_leaf_nodes": None,
                "min_impurity_decrease": 0.0,
                "min_samples_leaf": 1,
                "min_samples_split": 2,
                "min_weight_fraction_leaf": 0.0,
                "random_state": 605043361,
                "splitter": "best"
            },
            "estimator_44": {
                "ccp_alpha": 0.0,
                "criterion": "squared_error",
                "max_depth": None,
                "max_features": 1.0,
                "max_leaf_nodes": None,
                "min_impurity_decrease": 0.0,
                "min_samples_leaf": 1,
                "min_samples_split": 2,
                "min_weight_fraction_leaf": 0.0,
                "random_state": 819041553,
                "splitter": "best"
            },
            "estimator_45": {
                "ccp_alpha": 0.0,
                "criterion": "squared_error",
                "max_depth": None,
                "max_features": 1.0,
                "max_leaf_nodes": None,
                "min_impurity_decrease": 0.0,
                "min_samples_leaf": 1,
                "min_samples_split": 2,
                "min_weight_fraction_leaf": 0.0,
                "random_state": 74689721,
                "splitter": "best"
            },
            "estimator_46": {
                "ccp_alpha": 0.0,
                "criterion": "squared_error",
                "max_depth": None,
                "max_features": 1.0,
                "max_leaf_nodes": None,
                "min_impurity_decrease": 0.0,
                "min_samples_leaf": 1,
                "min_samples_split": 2,
                "min_weight_fraction_leaf": 0.0,
                "random_state": 31026280,
                "splitter": "best"
            },
            "estimator_47": {
                "ccp_alpha": 0.0,
                "criterion": "squared_error",
                "max_depth": None,
                "max_features": 1.0,
                "max_leaf_nodes": None,
                "min_impurity_decrease": 0.0,
                "min_samples_leaf": 1,
                "min_samples_split": 2,
                "min_weight_fraction_leaf": 0.0,
                "random_state": 1551773262,
                "splitter": "best"
            },
            "estimator_48": {
                "ccp_alpha": 0.0,
                "criterion": "squared_error",
                "max_depth": None,
                "max_features": 1.0,
                "max_leaf_nodes": None,
                "min_impurity_decrease": 0.0,
                "min_samples_leaf": 1,
                "min_samples_split": 2,
                "min_weight_fraction_leaf": 0.0,
                "random_state": 743635871,
                "splitter": "best"
            },
            "estimator_49": {
                "ccp_alpha": 0.0,
                "criterion": "squared_error",
                "max_depth": None,
                "max_features": 1.0,
                "max_leaf_nodes": None,
                "min_impurity_decrease": 0.0,
                "min_samples_leaf": 1,
                "min_samples_split": 2,
                "min_weight_fraction_leaf": 0.0,
                "random_state": 1094212308,
                "splitter": "best"
            },
            "estimator_50": {
                "ccp_alpha": 0.0,
                "criterion": "squared_error",
                "max_depth": None,
                "max_features": 1.0,
                "max_leaf_nodes": None,
                "min_impurity_decrease": 0.0,
                "min_samples_leaf": 1,
                "min_samples_split": 2,
                "min_weight_fraction_leaf": 0.0,
                "random_state": 32328633,
                "splitter": "best"
            },
            "estimator_51": {
                "ccp_alpha": 0.0,
                "criterion": "squared_error",
                "max_depth": None,
                "max_features": 1.0,
                "max_leaf_nodes": None,
                "min_impurity_decrease": 0.0,
                "min_samples_leaf": 1,
                "min_samples_split": 2,
                "min_weight_fraction_leaf": 0.0,
                "random_state": 1068306456,
                "splitter": "best"
            },
            "estimator_52": {
                "ccp_alpha": 0.0,
                "criterion": "squared_error",
                "max_depth": None,
                "max_features": 1.0,
                "max_leaf_nodes": None,
                "min_impurity_decrease": 0.0,
                "min_samples_leaf": 1,
                "min_samples_split": 2,
                "min_weight_fraction_leaf": 0.0,
                "random_state": 938254930,
                "splitter": "best"
            },
            "estimator_53": {
                "ccp_alpha": 0.0,
                "criterion": "squared_error",
                "max_depth": None,
                "max_features": 1.0,
                "max_leaf_nodes": None,
                "min_impurity_decrease": 0.0,
                "min_samples_leaf": 1,
                "min_samples_split": 2,
                "min_weight_fraction_leaf": 0.0,
                "random_state": 1439570503,
                "splitter": "best"
            },
            "estimator_54": {
                "ccp_alpha": 0.0,
                "criterion": "squared_error",
                "max_depth": None,
                "max_features": 1.0,
                "max_leaf_nodes": None,
                "min_impurity_decrease": 0.0,
                "min_samples_leaf": 1,
                "min_samples_split": 2,
                "min_weight_fraction_leaf": 0.0,
                "random_state": 2073201694,
                "splitter": "best"
            },
            "estimator_55": {
                "ccp_alpha": 0.0,
                "criterion": "squared_error",
                "max_depth": None,
                "max_features": 1.0,
                "max_leaf_nodes": None,
                "min_impurity_decrease": 0.0,
                "min_samples_leaf": 1,
                "min_samples_split": 2,
                "min_weight_fraction_leaf": 0.0,
                "random_state": 716953659,
                "splitter": "best"
            },
            "estimator_56": {
                "ccp_alpha": 0.0,
                "criterion": "squared_error",
                "max_depth": None,
                "max_features": 1.0,
                "max_leaf_nodes": None,
                "min_impurity_decrease": 0.0,
                "min_samples_leaf": 1,
                "min_samples_split": 2,
                "min_weight_fraction_leaf": 0.0,
                "random_state": 1931205235,
                "splitter": "best"
            },
            "estimator_57": {
                "ccp_alpha": 0.0,
                "criterion": "squared_error",
                "max_depth": None,
                "max_features": 1.0,
                "max_leaf_nodes": None,
                "min_impurity_decrease": 0.0,
                "min_samples_leaf": 1,
                "min_samples_split": 2,
                "min_weight_fraction_leaf": 0.0,
                "random_state": 2144676548,
                "splitter": "best"
            },
            "estimator_58": {
                "ccp_alpha": 0.0,
                "criterion": "squared_error",
                "max_depth": None,
                "max_features": 1.0,
                "max_leaf_nodes": None,
                "min_impurity_decrease": 0.0,
                "min_samples_leaf": 1,
                "min_samples_split": 2,
                "min_weight_fraction_leaf": 0.0,
                "random_state": 949082183,
                "splitter": "best"
            },
            "estimator_59": {
                "ccp_alpha": 0.0,
                "criterion": "squared_error",
                "max_depth": None,
                "max_features": 1.0,
                "max_leaf_nodes": None,
                "min_impurity_decrease": 0.0,
                "min_samples_leaf": 1,
                "min_samples_split": 2,
                "min_weight_fraction_leaf": 0.0,
                "random_state": 1757578956,
                "splitter": "best"
            },
            "estimator_60": {
                "ccp_alpha": 0.0,
                "criterion": "squared_error",
                "max_depth": None,
                "max_features": 1.0,
                "max_leaf_nodes": None,
                "min_impurity_decrease": 0.0,
                "min_samples_leaf": 1,
                "min_samples_split": 2,
                "min_weight_fraction_leaf": 0.0,
                "random_state": 1302562357,
                "splitter": "best"
            },
            "estimator_61": {
                "ccp_alpha": 0.0,
                "criterion": "squared_error",
                "max_depth": None,
                "max_features": 1.0,
                "max_leaf_nodes": None,
                "min_impurity_decrease": 0.0,
                "min_samples_leaf": 1,
                "min_samples_split": 2,
                "min_weight_fraction_leaf": 0.0,
                "random_state": 1590244562,
                "splitter": "best"
            },
            "estimator_62": {
                "ccp_alpha": 0.0,
                "criterion": "squared_error",
                "max_depth": None,
                "max_features": 1.0,
                "max_leaf_nodes": None,
                "min_impurity_decrease": 0.0,
                "min_samples_leaf": 1,
                "min_samples_split": 2,
                "min_weight_fraction_leaf": 0.0,
                "random_state": 548820696,
                "splitter": "best"
            },
            "estimator_63": {
                "ccp_alpha": 0.0,
                "criterion": "squared_error",
                "max_depth": None,
                "max_features": 1.0,
                "max_leaf_nodes": None,
                "min_impurity_decrease": 0.0,
                "min_samples_leaf": 1,
                "min_samples_split": 2,
                "min_weight_fraction_leaf": 0.0,
                "random_state": 329131046,
                "splitter": "best"
            },
            "estimator_64": {
                "ccp_alpha": 0.0,
                "criterion": "squared_error",
                "max_depth": None,
                "max_features": 1.0,
                "max_leaf_nodes": None,
                "min_impurity_decrease": 0.0,
                "min_samples_leaf": 1,
                "min_samples_split": 2,
                "min_weight_fraction_leaf": 0.0,
                "random_state": 220819013,
                "splitter": "best"
            },
            "estimator_65": {
                "ccp_alpha": 0.0,
                "criterion": "squared_error",
                "max_depth": None,
                "max_features": 1.0,
                "max_leaf_nodes": None,
                "min_impurity_decrease": 0.0,
                "min_samples_leaf": 1,
                "min_samples_split": 2,
                "min_weight_fraction_leaf": 0.0,
                "random_state": 16841877,
                "splitter": "best"
            },
            "estimator_66": {
                "ccp_alpha": 0.0,
                "criterion": "squared_error",
                "max_depth": None,
                "max_features": 1.0,
                "max_leaf_nodes": None,
                "min_impurity_decrease": 0.0,
                "min_samples_leaf": 1,
                "min_samples_split": 2,
                "min_weight_fraction_leaf": 0.0,
                "random_state": 552097147,
                "splitter": "best"
            },
            "estimator_67": {
                "ccp_alpha": 0.0,
                "criterion": "squared_error",
                "max_depth": None,
                "max_features": 1.0,
                "max_leaf_nodes": None,
                "min_impurity_decrease": 0.0,
                "min_samples_leaf": 1,
                "min_samples_split": 2,
                "min_weight_fraction_leaf": 0.0,
                "random_state": 1581651435,
                "splitter": "best"
            },
            "estimator_68": {
                "ccp_alpha": 0.0,
                "criterion": "squared_error",
                "max_depth": None,
                "max_features": 1.0,
                "max_leaf_nodes": None,
                "min_impurity_decrease": 0.0,
                "min_samples_leaf": 1,
                "min_samples_split": 2,
                "min_weight_fraction_leaf": 0.0,
                "random_state": 1763463479,
                "splitter": "best"
            },
            "estimator_69": {
                "ccp_alpha": 0.0,
                "criterion": "squared_error",
                "max_depth": None,
                "max_features": 1.0,
                "max_leaf_nodes": None,
                "min_impurity_decrease": 0.0,
                "min_samples_leaf": 1,
                "min_samples_split": 2,
                "min_weight_fraction_leaf": 0.0,
                "random_state": 1408593519,
                "splitter": "best"
            },
            "estimator_70": {
                "ccp_alpha": 0.0,
                "criterion": "squared_error",
                "max_depth": None,
                "max_features": 1.0,
                "max_leaf_nodes": None,
                "min_impurity_decrease": 0.0,
                "min_samples_leaf": 1,
                "min_samples_split": 2,
                "min_weight_fraction_leaf": 0.0,
                "random_state": 380016679,
                "splitter": "best"
            },
            "estimator_71": {
                "ccp_alpha": 0.0,
                "criterion": "squared_error",
                "max_depth": None,
                "max_features": 1.0,
                "max_leaf_nodes": None,
                "min_impurity_decrease": 0.0,
                "min_samples_leaf": 1,
                "min_samples_split": 2,
                "min_weight_fraction_leaf": 0.0,
                "random_state": 424503834,
                "splitter": "best"
            },
            "estimator_72": {
                "ccp_alpha": 0.0,
                "criterion": "squared_error",
                "max_depth": None,
                "max_features": 1.0,
                "max_leaf_nodes": None,
                "min_impurity_decrease": 0.0,
                "min_samples_leaf": 1,
                "min_samples_split": 2,
                "min_weight_fraction_leaf": 0.0,
                "random_state": 23080831,
                "splitter": "best"
            },
            "estimator_73": {
                "ccp_alpha": 0.0,
                "criterion": "squared_error",
                "max_depth": None,
                "max_features": 1.0,
                "max_leaf_nodes": None,
                "min_impurity_decrease": 0.0,
                "min_samples_leaf": 1,
                "min_samples_split": 2,
                "min_weight_fraction_leaf": 0.0,
                "random_state": 959806669,
                "splitter": "best"
            },
            "estimator_74": {
                "ccp_alpha": 0.0,
                "criterion": "squared_error",
                "max_depth": None,
                "max_features": 1.0,
                "max_leaf_nodes": None,
                "min_impurity_decrease": 0.0,
                "min_samples_leaf": 1,
                "min_samples_split": 2,
                "min_weight_fraction_leaf": 0.0,
                "random_state": 1396088672,
                "splitter": "best"
            },
            "estimator_75": {
                "ccp_alpha": 0.0,
                "criterion": "squared_error",
                "max_depth": None,
                "max_features": 1.0,
                "max_leaf_nodes": None,
                "min_impurity_decrease": 0.0,
                "min_samples_leaf": 1,
                "min_samples_split": 2,
                "min_weight_fraction_leaf": 0.0,
                "random_state": 1659885106,
                "splitter": "best"
            },
            "estimator_76": {
                "ccp_alpha": 0.0,
                "criterion": "squared_error",
                "max_depth": None,
                "max_features": 1.0,
                "max_leaf_nodes": None,
                "min_impurity_decrease": 0.0,
                "min_samples_leaf": 1,
                "min_samples_split": 2,
                "min_weight_fraction_leaf": 0.0,
                "random_state": 2052936325,
                "splitter": "best"
            },
            "estimator_77": {
                "ccp_alpha": 0.0,
                "criterion": "squared_error",
                "max_depth": None,
                "max_features": 1.0,
                "max_leaf_nodes": None,
                "min_impurity_decrease": 0.0,
                "min_samples_leaf": 1,
                "min_samples_split": 2,
                "min_weight_fraction_leaf": 0.0,
                "random_state": 802410347,
                "splitter": "best"
            },
            "estimator_78": {
                "ccp_alpha": 0.0,
                "criterion": "squared_error",
                "max_depth": None,
                "max_features": 1.0,
                "max_leaf_nodes": None,
                "min_impurity_decrease": 0.0,
                "min_samples_leaf": 1,
                "min_samples_split": 2,
                "min_weight_fraction_leaf": 0.0,
                "random_state": 568557426,
                "splitter": "best"
            },
            "estimator_79": {
                "ccp_alpha": 0.0,
                "criterion": "squared_error",
                "max_depth": None,
                "max_features": 1.0,
                "max_leaf_nodes": None,
                "min_impurity_decrease": 0.0,
                "min_samples_leaf": 1,
                "min_samples_split": 2,
                "min_weight_fraction_leaf": 0.0,
                "random_state": 634687942,
                "splitter": "best"
            },
            "estimator_80": {
                "ccp_alpha": 0.0,
                "criterion": "squared_error",
                "max_depth": None,
                "max_features": 1.0,
                "max_leaf_nodes": None,
                "min_impurity_decrease": 0.0,
                "min_samples_leaf": 1,
                "min_samples_split": 2,
                "min_weight_fraction_leaf": 0.0,
                "random_state": 675989982,
                "splitter": "best"
            },
            "estimator_81": {
                "ccp_alpha": 0.0,
                "criterion": "squared_error",
                "max_depth": None,
                "max_features": 1.0,
                "max_leaf_nodes": None,
                "min_impurity_decrease": 0.0,
                "min_samples_leaf": 1,
                "min_samples_split": 2,
                "min_weight_fraction_leaf": 0.0,
                "random_state": 1065713962,
                "splitter": "best"
            },
            "estimator_82": {
                "ccp_alpha": 0.0,
                "criterion": "squared_error",
                "max_depth": None,
                "max_features": 1.0,
                "max_leaf_nodes": None,
                "min_impurity_decrease": 0.0,
                "min_samples_leaf": 1,
                "min_samples_split": 2,
                "min_weight_fraction_leaf": 0.0,
                "random_state": 45961222,
                "splitter": "best"
            },
            "estimator_83": {
                "ccp_alpha": 0.0,
                "criterion": "squared_error",
                "max_depth": None,
                "max_features": 1.0,
                "max_leaf_nodes": None,
                "min_impurity_decrease": 0.0,
                "min_samples_leaf": 1,
                "min_samples_split": 2,
                "min_weight_fraction_leaf": 0.0,
                "random_state": 1043840685,
                "splitter": "best"
            },
            "estimator_84": {
                "ccp_alpha": 0.0,
                "criterion": "squared_error",
                "max_depth": None,
                "max_features": 1.0,
                "max_leaf_nodes": None,
                "min_impurity_decrease": 0.0,
                "min_samples_leaf": 1,
                "min_samples_split": 2,
                "min_weight_fraction_leaf": 0.0,
                "random_state": 1801399560,
                "splitter": "best"
            },
            "estimator_85": {
                "ccp_alpha": 0.0,
                "criterion": "squared_error",
                "max_depth": None,
                "max_features": 1.0,
                "max_leaf_nodes": None,
                "min_impurity_decrease": 0.0,
                "min_samples_leaf": 1,
                "min_samples_split": 2,
                "min_weight_fraction_leaf": 0.0,
                "random_state": 653072273,
                "splitter": "best"
            },
            "estimator_86": {
                "ccp_alpha": 0.0,
                "criterion": "squared_error",
                "max_depth": None,
                "max_features": 1.0,
                "max_leaf_nodes": None,
                "min_impurity_decrease": 0.0,
                "min_samples_leaf": 1,
                "min_samples_split": 2,
                "min_weight_fraction_leaf": 0.0,
                "random_state": 1199951186,
                "splitter": "best"
            },
            "estimator_87": {
                "ccp_alpha": 0.0,
                "criterion": "squared_error",
                "max_depth": None,
                "max_features": 1.0,
                "max_leaf_nodes": None,
                "min_impurity_decrease": 0.0,
                "min_samples_leaf": 1,
                "min_samples_split": 2,
                "min_weight_fraction_leaf": 0.0,
                "random_state": 1058911881,
                "splitter": "best"
            },
            "estimator_88": {
                "ccp_alpha": 0.0,
                "criterion": "squared_error",
                "max_depth": None,
                "max_features": 1.0,
                "max_leaf_nodes": None,
                "min_impurity_decrease": 0.0,
                "min_samples_leaf": 1,
                "min_samples_split": 2,
                "min_weight_fraction_leaf": 0.0,
                "random_state": 1428625170,
                "splitter": "best"
            },
            "estimator_89": {
                "ccp_alpha": 0.0,
                "criterion": "squared_error",
                "max_depth": None,
                "max_features": 1.0,
                "max_leaf_nodes": None,
                "min_impurity_decrease": 0.0,
                "min_samples_leaf": 1,
                "min_samples_split": 2,
                "min_weight_fraction_leaf": 0.0,
                "random_state": 723449209,
                "splitter": "best"
            },
            "estimator_90": {
                "ccp_alpha": 0.0,
                "criterion": "squared_error",
                "max_depth": None,
                "max_features": 1.0,
                "max_leaf_nodes": None,
                "min_impurity_decrease": 0.0,
                "min_samples_leaf": 1,
                "min_samples_split": 2,
                "min_weight_fraction_leaf": 0.0,
                "random_state": 1125958473,
                "splitter": "best"
            },
            "estimator_91": {
                "ccp_alpha": 0.0,
                "criterion": "squared_error",
                "max_depth": None,
                "max_features": 1.0,
                "max_leaf_nodes": None,
                "min_impurity_decrease": 0.0,
                "min_samples_leaf": 1,
                "min_samples_split": 2,
                "min_weight_fraction_leaf": 0.0,
                "random_state": 777198766,
                "splitter": "best"
            },
            "estimator_92": {
                "ccp_alpha": 0.0,
                "criterion": "squared_error",
                "max_depth": None,
                "max_features": 1.0,
                "max_leaf_nodes": None,
                "min_impurity_decrease": 0.0,
                "min_samples_leaf": 1,
                "min_samples_split": 2,
                "min_weight_fraction_leaf": 0.0,
                "random_state": 1298484387,
                "splitter": "best"
            },
            "estimator_93": {
                "ccp_alpha": 0.0,
                "criterion": "squared_error",
                "max_depth": None,
                "max_features": 1.0,
                "max_leaf_nodes": None,
                "min_impurity_decrease": 0.0,
                "min_samples_leaf": 1,
                "min_samples_split": 2,
                "min_weight_fraction_leaf": 0.0,
                "random_state": 1303090236,
                "splitter": "best"
            },
            "estimator_94": {
                "ccp_alpha": 0.0,
                "criterion": "squared_error",
                "max_depth": None,
                "max_features": 1.0,
                "max_leaf_nodes": None,
                "min_impurity_decrease": 0.0,
                "min_samples_leaf": 1,
                "min_samples_split": 2,
                "min_weight_fraction_leaf": 0.0,
                "random_state": 1259632477,
                "splitter": "best"
            },
            "estimator_95": {
                "ccp_alpha": 0.0,
                "criterion": "squared_error",
                "max_depth": None,
                "max_features": 1.0,
                "max_leaf_nodes": None,
                "min_impurity_decrease": 0.0,
                "min_samples_leaf": 1,
                "min_samples_split": 2,
                "min_weight_fraction_leaf": 0.0,
                "random_state": 1477938621,
                "splitter": "best"
            },
            "estimator_96": {
                "ccp_alpha": 0.0,
                "criterion": "squared_error",
                "max_depth": None,
                "max_features": 1.0,
                "max_leaf_nodes": None,
                "min_impurity_decrease": 0.0,
                "min_samples_leaf": 1,
                "min_samples_split": 2,
                "min_weight_fraction_leaf": 0.0,
                "random_state": 987454758,
                "splitter": "best"
            },
            "estimator_97": {
                "ccp_alpha": 0.0,
                "criterion": "squared_error",
                "max_depth": None,
                "max_features": 1.0,
                "max_leaf_nodes": None,
                "min_impurity_decrease": 0.0,
                "min_samples_leaf": 1,
                "min_samples_split": 2,
                "min_weight_fraction_leaf": 0.0,
                "random_state": 1698192072,
                "splitter": "best"
            },
            "estimator_98": {
                "ccp_alpha": 0.0,
                "criterion": "squared_error",
                "max_depth": None,
                "max_features": 1.0,
                "max_leaf_nodes": None,
                "min_impurity_decrease": 0.0,
                "min_samples_leaf": 1,
                "min_samples_split": 2,
                "min_weight_fraction_leaf": 0.0,
                "random_state": 2119845913,
                "splitter": "best"
            },
            "estimator_99": {
                "ccp_alpha": 0.0,
                "criterion": "squared_error",
                "max_depth": None,
                "max_features": 1.0,
                "max_leaf_nodes": None,
                "min_impurity_decrease": 0.0,
                "min_samples_leaf": 1,
                "min_samples_split": 2,
                "min_weight_fraction_leaf": 0.0,
                "random_state": 2071111449,
                "splitter": "best"
            }
        })

        code_logging = Logging(spec={'system': 'Linux', 'version': '#44~20.04.2-Ubuntu SMP Tue Oct 26 18:07:44 UTC 2021', 'machine': 'x86_64', 'processor': 'x86_64', 'cpu_physical_count': 8, 'cpu_total_count': 16, 'cpu_max_frequency': '2900.00Mhz', 'cpu_min_frequency': '1400.00Mhz', 'ram_total': '62.24GB', 'gpu': {0: {'name': 'NVIDIA GeForce RTX 2060', 'memory': '5934.0MB'}}}, logs=['SUCCESS: GlassBoxTestRunnerTest#test_abc'])
        data_logging = Logging(spec={'system': 'Linux', 'version': '#44~20.04.2-Ubuntu SMP Tue Oct 26 18:07:44 UTC 2021', 'machine': 'x86_64', 'processor': 'x86_64', 'cpu_physical_count': 8, 'cpu_total_count': 16, 'cpu_max_frequency': '2900.00Mhz', 'cpu_min_frequency': '1400.00Mhz', 'ram_total': '62.24GB', 'gpu': {0: {'name': 'NVIDIA GeForce RTX 2060', 'memory': '5934.0MB'}}}, logs=['SUCCESS: GlassBoxTestRunnerTest#test_abc'])

        code = GitTag("https://github.com/leftshiftone/house-pricing-demo", "1.0.0")
        model.add_code(code, purposes=[Purpose.TRAIN, Purpose.TEST, Purpose.EVALUATE], logs=code_logging)

        data1 = Dataset(url="https://ndownloader.figshare.com/files/5976036/cal_housing.tgz",
                        checksum="aaa5c9a6afe2225cc2aed2723682ae403280c4a3695a2ddda4ffb5d8215ea681")
        model.add_data(data1, purposes=[Purpose.TRAIN, Purpose.TEST, Purpose.EVALUATE], logs=data_logging)

        model.add_benchmarks([
            MeanSquaredError("https://ndownloader.figshare.com/files/5976036/cal_housing.tgz", "0.2422420691746969"),
            MeanAbsoluteError("https://ndownloader.figshare.com/files/5976036/cal_housing.tgz", "0.3203047060319769"),
            R2Score("https://ndownloader.figshare.com/files/5976036/cal_housing.tgz", "0.8156920034920443"),
            ExplainedVarianceScore("https://ndownloader.figshare.com/files/5976036/cal_housing.tgz",
                                   "0.8159051864428294"),
            MeanPinballLoss("https://ndownloader.figshare.com/files/5976036/cal_housing.tgz", "0.16015235301598846"),
            D2PinballScore("https://ndownloader.figshare.com/files/5976036/cal_housing.tgz", "0.6341997652856814"),
            D2AbsoluteErrorScore("https://ndownloader.figshare.com/files/5976036/cal_housing.tgz", "0.6341997652856814")
        ])

        model.description = f"""Regression model for the California housing dataset.

 * Samples total: 20640
 * Dimensionality: 8
 * Features: real
 * Target: real 0.15 - 5.
 
 # SHAP Values: #
 ![XAI 1]({to_base64("/home/christian/IdeaProjects/c7nw3r/onnx-explainer/onnx_explainer/house_pricing1.png")})
 ![XAI 2]({to_base64("/home/christian/IdeaProjects/c7nw3r/onnx-explainer/onnx_explainer/house_pricing2.png")})
 ![XAI 3]({to_base64("/home/christian/IdeaProjects/c7nw3r/onnx-explainer/onnx_explainer/house_pricing3.png")})
        """

        model.save("model.json")
        print(glassbox.create_model(model))
