"""Mapping templates for GBD sequelae.

This code is automatically generated by gbd_mapping_generator/sequela_builder.py

Any manual changes will be lost.
"""
from .id import s_id, me_id, hs_id
from .base_template import ModelableEntity, GbdRecord


class Healthstate(ModelableEntity):
    """Container for healthstate GBD ids and metadata."""
    __slots__ = ('name', 'kind', 'gbd_id', )

    def __init__(self,
                 name: str,
                 kind: str,
                 gbd_id: hs_id, ):
        super().__init__(name=name,
                         kind=kind,
                         gbd_id=gbd_id)
        self.name = name
        self.kind = kind
        self.gbd_id = gbd_id


class Sequela(ModelableEntity):
    """Container for sequela GBD ids and metadata."""
    __slots__ = ('name', 'kind', 'gbd_id', 'me_id', 'healthstate', )

    def __init__(self,
                 name: str,
                 kind: str,
                 gbd_id: s_id,
                 me_id: me_id,
                 healthstate: Healthstate, ):
        super().__init__(name=name,
                         kind=kind,
                         gbd_id=gbd_id)
        self.name = name
        self.kind = kind
        self.gbd_id = gbd_id
        self.me_id = me_id
        self.healthstate = healthstate


class Sequelae(GbdRecord):
    """Container for GBD sequelae."""
    __slots__ = ('acute_typhoid_infection', 'severe_typhoid_fever', 'intestinal_perforation_due_to_typhoid',
                 'acute_paratyphoid_infection', 'moderate_paratyphoid_fever', 'severe_paratyphoid_fever',
                 'intestinal_perforation_due_to_paratyphoid', 'other_intestinal_infectious_diseases',
                 'mild_upper_respiratory_infections', 'moderate_upper_respiratory_infections',
                 'guillain_barre_syndrome_due_to_upper_respiratory_infections', 'acute_otitis_media',
                 'acute_viral_meningitis', 'acute_encephalitis', 'moderate_diphtheria', 'severe_diphtheria',
                 'whooping_cough', 'severe_tetanus', 'moderate_measles', 'severe_measles', 'chickenpox',
                 'herpes_zoster', 'mild_malaria', 'moderate_malaria', 'severe_malaria', 'acute_chagas_disease',
                 'atrial_fibrillation_and_flutter_due_to_chagas_disease',
                 'mild_chronic_digestive_disease_due_to_chagas_disease',
                 'moderate_chronic_digestive_disease_due_to_chagas_disease',
                 'mild_heart_failure_due_to_chagas_disease', 'moderate_heart_failure_due_to_chagas_disease',
                 'severe_heart_failure_due_to_chagas_disease', 'moderate_visceral_leishmaniasis',
                 'severe_visceral_leishmaniasis', 'cutaneous_and_mucocutaneous_leishmaniasis',
                 'mild_schistosomiasis', 'mild_diarrhea_due_to_schistosomiasis',
                 'hematemesis_due_to_schistosomiasis', 'hepatomegaly_due_to_schistosomiasis',
                 'ascites_due_to_schistosomiasis', 'dysuria_due_to_schistosomiasis',
                 'bladder_pathology_due_to_schistosomiasis', 'hydronephrosis_due_to_schistosomiasis',
                 'mild_anemia_due_to_schistosomiasis', 'moderate_anemia_due_to_schistosomiasis',
                 'severe_anemia_due_to_schistosomiasis', 'abdominal_problems_due_to_cystic_echinococcosis',
                 'chronic_respiratory_disease_due_to_cystic_echinococcosis',
                 'prevalence_of_detectable_microfiliaria_due_to_lymphatic_filariasis',
                 'lymphedema_due_to_lymphatic_filariasis', 'hydrocele_due_to_lymphatic_filariasis',
                 'mild_skin_disease_due_to_onchocerciasis', 'moderate_skin_disease_due_to_onchocerciasis',
                 'moderate_vision_impairment_due_to_trachoma', 'severe_vision_impairment_due_to_trachoma',
                 'blindness_due_to_trachoma', 'moderate_dengue', 'severe_dengue',
                 'post_dengue_chronic_fatigue_syndrome', 'moderate_yellow_fever', 'severe_yellow_fever', 'rabies',
                 'heavy_infestation_of_ascariasis', 'mild_abdominopelvic_problems_due_to_ascariasis',
                 'severe_wasting_due_to_ascariasis', 'heavy_infestation_of_trichuriasis',
                 'mild_abdominopelvic_problems_due_to_trichuriasis', 'severe_wasting_due_to_trichuriasis',
                 'heavy_infestation_of_hookworm', 'mild_abdominopelvic_problems_due_to_hookworm_disease',
                 'severe_wasting_due_to_hookworm_disease', 'mild_anemia_due_to_hookworm_disease',
                 'moderate_anemia_due_to_hookworm_disease', 'severe_anemia_due_to_hookworm_disease',
                 'cerebral_paragonimiasis', 'acute_infection_due_to_other_neglected_tropical_diseases',
                 'mild_anemia_due_to_other_neglected_tropical_diseases',
                 'moderate_anemia_due_to_other_neglected_tropical_diseases',
                 'severe_anemia_due_to_other_neglected_tropical_diseases',
                 'maternal_hemorrhage_less_than__1l_blood_lost', 'maternal_hemorrhage_greater_than__1l_blood_lost',
                 'mild_anemia_due_to_maternal_hemorrhage', 'moderate_anemia_due_to_maternal_hemorrhage',
                 'severe_anemia_due_to_maternal_hemorrhage', 'severe_pre_eclampsia', 'eclampsia',
                 'long_term_sequelae_of_severe_pre_eclampsia', 'obstructed_labor_acute_event',
                 'rectovaginal_fistula', 'vesicovaginal_fistula', 'maternal_abortive_outcome',
                 'other_maternal_disorders', 'mild_vision_impairment_due_to_retinopathy_of_prematurity',
                 'mild_motor_plus_cognitive_impairments_due_to_neonatal_encephalopathy_due_to_birth_asphyxia_and_trauma',
                 'mild_motor_impairment_due_to_neonatal_encephalopathy_due_to_birth_asphyxia_and_trauma',
                 'other_neonatal_disorders', 'moderate_wasting_with_edema', 'severe_wasting_without_edema',
                 'visible_goiter_without_symptoms',
                 'visible_goiter_with_severe_intellectual_disability_due_to_iodine_deficiency',
                 'visible_goiter_with_profound_intellectual_disability_due_to_iodine_deficiency',
                 'moderate_vision_impairment_loss_due_to_vitamin_a_deficiency',
                 'severe_vision_impairment_loss_due_to_vitamin_a_deficiency',
                 'blindness_due_to_vitamin_a_deficiency', 'mild_iron_deficiency_anemia',
                 'moderate_iron_deficiency_anemia', 'severe_iron_deficiency_anemia',
                 'other_nutritional_deficiencies', 'epididymo_orchitis_due_to_chlamydial_infection',
                 'moderate_pelvic_inflammatory_diseases_due_to_chlamydial_infection',
                 'severe_pelvic_inflammatory_diseases_due_to_chlamydial_infection',
                 'primary_infertility_due_to_chlamydial_infection',
                 'secondary_infertility_due_to_chlamydial_infection',
                 'epididymo_orchitis_due_to_gonococcal_infection',
                 'moderate_pelvic_inflammatory_diseases_due_to_gonococcal_infection',
                 'severe_pelvic_inflammatory_diseases_due_to_gonococcal_infection',
                 'primary_infertility_due_to_gonococcal_infection',
                 'secondary_infertility_due_to_gonococcal_infection',
                 'moderate_pelvic_inflammatory_diseases_due_to_other_sexually_transmitted_diseases',
                 'severe_pelvic_inflammatory_diseases_due_to_other_sexually_transmitted_diseases',
                 'primary_infertility_due_to_other_sexually_transmitted_diseases',
                 'secondary_infertility_due_to_other_sexually_transmitted_diseases', 'moderate_acute_hepatitis_a',
                 'severe_acute_hepatitis_a', 'moderate_acute_hepatitis_b', 'severe_acute_hepatitis_b',
                 'moderate_acute_hepatitis_c', 'severe_acute_hepatitis_c', 'moderate_acute_hepatitis_e',
                 'severe_acute_hepatitis_e', 'disfigurement_level_1_due_to_leprosy',
                 'disfigurement_level_2_due_to_leprosy', 'mild_anemia_due_to_other_infectious_diseases',
                 'moderate_anemia_due_to_other_infectious_diseases',
                 'severe_anemia_due_to_other_infectious_diseases',
                 'guillain_barre_syndrome_due_to_other_infectious_diseases',
                 'diagnosis_and_primary_therapy_phase_of_esophageal_cancer', 'controlled_phase_of_esophageal_cancer',
                 'metastatic_phase_of_esophageal_cancer', 'terminal_phase_of_esophageal_cancer',
                 'diagnosis_and_primary_therapy_phase_of_stomach_cancer', 'controlled_phase_of_stomach_cancer',
                 'metastatic_phase_of_stomach_cancer', 'terminal_phase_of_stomach_cancer',
                 'diagnosis_and_primary_therapy_phase_of_liver_cancer_due_to_hepatitis_b',
                 'controlled_phase_of_liver_cancer_due_to_hepatitis_b',
                 'metastatic_phase_of_liver_cancer_due_to_hepatitis_b',
                 'terminal_phase_of_liver_cancer_due_to_hepatitis_b',
                 'diagnosis_and_primary_therapy_phase_of_liver_cancer_due_to_hepatitis_c',
                 'controlled_phase_of_liver_cancer_due_to_hepatitis_c',
                 'metastatic_phase_of_liver_cancer_due_to_hepatitis_c',
                 'terminal_phase_of_liver_cancer_due_to_hepatitis_c',
                 'diagnosis_and_primary_therapy_phase_of_liver_cancer_due_to_alcohol_use',
                 'controlled_phase_of_liver_cancer_due_to_alcohol_use',
                 'metastatic_phase_of_liver_cancer_due_to_alcohol_use',
                 'terminal_phase_of_liver_cancer_due_to_alcohol_use',
                 'diagnosis_and_primary_therapy_phase_of_liver_cancer_due_to_other_causes',
                 'controlled_phase_of_liver_cancer_due_to_other_causes',
                 'metastatic_phase_of_liver_cancer_due_to_other_causes',
                 'terminal_phase_of_liver_cancer_due_to_other_causes',
                 'diagnosis_and_primary_therapy_phase_of_larynx_cancer', 'metastatic_phase_of_larynx_cancer',
                 'terminal_phase_of_larynx_cancer',
                 'diagnosis_and_primary_therapy_phase_of_lung_bronchus_and_trachea_cancer',
                 'controlled_phase_of_lung_bronchus_and_trachea_cancer',
                 'metastatic_phase_of_lung_bronchus_and_trachea_cancer',
                 'terminal_phase_of_lung_bronchus_and_trachea_cancer',
                 'diagnosis_and_primary_therapy_phase_of_breast_cancer', 'metastatic_phase_of_breast_cancer',
                 'terminal_phase_of_breast_cancer', 'diagnosis_and_primary_therapy_phase_of_cervical_cancer',
                 'controlled_phase_of_cervical_cancer', 'metastatic_phase_of_cervical_cancer',
                 'terminal_phase_of_cervical_cancer', 'diagnosis_and_primary_therapy_phase_of_uterine_cancer',
                 'controlled_phase_of_uterine_cancer', 'metastatic_phase_of_uterine_cancer',
                 'terminal_phase_of_uterine_cancer', 'diagnosis_and_primary_therapy_phase_of_prostate_cancer',
                 'metastatic_phase_of_prostate_cancer', 'terminal_phase_of_prostate_cancer',
                 'diagnosis_and_primary_therapy_phase_of_colon_and_rectum_cancers',
                 'metastatic_phase_of_colon_and_rectum_cancers', 'terminal_phase_of_colon_and_rectum_cancers',
                 'diagnosis_and_primary_therapy_phase_of_mouth_cancer', 'controlled_phase_of_mouth_cancer',
                 'metastatic_phase_of_mouth_cancer', 'terminal_phase_of_mouth_cancer',
                 'diagnosis_and_primary_therapy_phase_of_nasopharynx_cancer',
                 'controlled_phase_of_nasopharynx_cancer', 'metastatic_phase_of_nasopharynx_cancer',
                 'terminal_phase_of_nasopharynx_cancer',
                 'diagnosis_and_primary_therapy_phase_of_other_pharynx_cancer',
                 'controlled_phase_of_other_pharynx_cancer', 'metastatic_phase_of_other_pharynx_cancer',
                 'terminal_phase_of_other_pharynx_cancer',
                 'diagnosis_and_primary_therapy_phase_of_gallbladder_and_biliary_tract_cancer',
                 'controlled_phase_of_gallbladder_and_biliary_tract_cancer',
                 'metastatic_phase_of_gallbladder_and_biliary_tract_cancer',
                 'terminal_phase_of_gallbladder_and_biliary_tract_cancer',
                 'diagnosis_and_primary_therapy_phase_of_pancreatic_cancer', 'controlled_phase_of_pancreatic_cancer',
                 'metastatic_phase_of_pancreatic_cancer', 'terminal_phase_of_pancreatic_cancer',
                 'diagnosis_and_primary_therapy_phase_of_malignant_skin_melanoma',
                 'controlled_phase_of_malignant_skin_melanoma', 'metastatic_phase_of_malignant_skin_melanoma',
                 'terminal_phase_of_malignant_skin_melanoma',
                 'diagnosis_and_primary_therapy_phase_of_ovarian_cancer', 'controlled_phase_of_ovarian_cancer',
                 'metastatic_phase_of_ovarian_cancer', 'terminal_phase_of_ovarian_cancer',
                 'diagnosis_and_primary_therapy_phase_of_testicular_cancer', 'controlled_phase_of_testicular_cancer',
                 'metastatic_phase_of_testicular_cancer', 'terminal_phase_of_testicular_cancer',
                 'diagnosis_and_primary_therapy_phase_of_kidney_cancer', 'controlled_phase_of_kidney_cancer',
                 'metastatic_phase_of_kidney_cancer', 'terminal_phase_of_kidney_cancer',
                 'diagnosis_and_primary_therapy_phase_of_bladder_cancer', 'metastatic_phase_of_bladder_cancer',
                 'terminal_phase_of_bladder_cancer',
                 'diagnosis_and_primary_therapy_phase_of_brain_and_central_nervous_system_cancers',
                 'controlled_phase_of_brain_and_central_nervous_system_cancers',
                 'metastatic_phase_of_brain_and_central_nervous_system_cancers',
                 'terminal_phase_of_brain_and_central_nervous_system_cancers',
                 'diagnosis_and_primary_therapy_phase_of_thyroid_cancer', 'controlled_phase_of_thyroid_cancer',
                 'metastatic_phase_of_thyroid_cancer', 'terminal_phase_of_thyroid_cancer',
                 'diagnosis_and_primary_therapy_phase_of_mesothelioma', 'controlled_phase_of_mesothelioma',
                 'metastatic_phase_of_mesothelioma', 'terminal_phase_of_mesothelioma',
                 'diagnosis_and_primary_therapy_phase_of_hodgkin_disease', 'controlled_phase_of_hodgkin_disease',
                 'metastatic_phase_of_hodgkin_disease', 'terminal_phase_of_hodgkin_disease',
                 'diagnosis_and_primary_therapy_phase_of_multiple_myeloma', 'controlled_phase_of_multiple_myeloma',
                 'metastatic_phase_of_multiple_myeloma', 'terminal_phase_of_multiple_myeloma',
                 'acute_myocardial_infarction_first_2_days', 'acute_myocardial_infarction_3_to_28_days',
                 'mild_angina_due_to_ischemic_heart_disease', 'moderate_angina_due_to_ischemic_heart_disease',
                 'severe_angina_due_to_ischemic_heart_disease', 'mild_heart_failure_due_to_ischemic_heart_disease',
                 'moderate_heart_failure_due_to_ischemic_heart_disease',
                 'severe_heart_failure_due_to_ischemic_heart_disease', 'acute_ischemic_stroke_severity_level_1',
                 'acute_ischemic_stroke_severity_level_2', 'acute_ischemic_stroke_severity_level_4',
                 'acute_ischemic_stroke_severity_level_3', 'acute_ischemic_stroke_severity_level_5',
                 'chronic_ischemic_stroke_severity_level_1', 'chronic_ischemic_stroke_severity_level_2',
                 'chronic_ischemic_stroke_severity_level_4', 'chronic_ischemic_stroke_severity_level_3',
                 'chronic_ischemic_stroke_severity_level_5', 'acute_intracerebral_hemorrhage_severity_level_1',
                 'acute_intracerebral_hemorrhage_severity_level_2',
                 'acute_intracerebral_hemorrhage_severity_level_4',
                 'acute_intracerebral_hemorrhage_severity_level_3',
                 'acute_intracerebral_hemorrhage_severity_level_5',
                 'chronic_intracerebral_hemorrhage_severity_level_1',
                 'chronic_intracerebral_hemorrhage_severity_level_2',
                 'chronic_intracerebral_hemorrhage_severity_level_4',
                 'chronic_intracerebral_hemorrhage_severity_level_3',
                 'chronic_intracerebral_hemorrhage_severity_level_5',
                 'mild_heart_failure_due_to_hypertensive_heart_disease',
                 'moderate_heart_failure_due_to_hypertensive_heart_disease',
                 'severe_heart_failure_due_to_hypertensive_heart_disease', 'acute_myocarditis',
                 'moderate_endocarditis', 'severe_endocarditis', 'mild_heart_failure_due_to_endocarditis',
                 'moderate_heart_failure_due_to_endocarditis', 'severe_heart_failure_due_to_endocarditis',
                 'mild_heart_failure_due_to_other_cardiovascular_diseases',
                 'moderate_heart_failure_due_to_other_cardiovascular_diseases',
                 'severe_heart_failure_due_to_other_cardiovascular_diseases',
                 'mild_chronic_obstructive_pulmonary_disease', 'moderate_chronic_obstructive_pulmonary_disease',
                 'mild_silicosis', 'moderate_silicosis', 'mild_asbestosis', 'moderate_asbestosis',
                 'mild_coal_workers_pneumoconiosis', 'moderate_coal_workers_pneumoconiosis',
                 'mild_other_pneumoconiosis', 'moderate_other_pneumoconiosis', 'controlled_asthma',
                 'partially_controlled_asthma', 'uncontrolled_asthma',
                 'mild_interstitial_lung_disease_and_pulmonary_sarcoidosis',
                 'moderate_interstitial_lung_disease_and_pulmonary_sarcoidosis',
                 'other_chronic_respiratory_diseases', 'appendicitis', 'paralytic_ileus_and_intestinal_obstruction',
                 'vascular_intestinal_disorders', 'other_digestive_diseases',
                 'mild_alzheimers_disease_and_other_dementias', 'moderate_alzheimers_disease_and_other_dementias',
                 'severe_alzheimers_disease_and_other_dementias', 'mild_parkinsons_disease',
                 'moderate_parkinsons_disease', 'severe_parkinsons_disease',
                 'idiopathic_seizure_free_treated_epilepsy', 'idiopathic_less_severe_epilepsy',
                 'idiopathic_severe_epilepsy', 'mild_multiple_sclerosis', 'moderate_multiple_sclerosis',
                 'severe_multiple_sclerosis', 'other_neurological_disorders',
                 'guillain_barre_syndrome_due_to_other_neurological_disorders', 'schizophrenia_acute_state',
                 'schizophrenia_residual_state', 'mild_alcohol_dependence', 'moderate_alcohol_dependence',
                 'severe_alcohol_dependence', 'mild_fetal_alcohol_syndrome', 'moderate_fetal_alcohol_syndrome',
                 'severe_fetal_alcohol_syndrome', 'other_drug_use_disorders', 'mild_major_depressive_disorder',
                 'moderate_major_depressive_disorder', 'severe_major_depressive_disorder',
                 'bipolar_disorder_manic_state', 'bipolar_disorder_residual_state', 'mild_anxiety_disorders',
                 'moderate_anxiety_disorders', 'severe_anxiety_disorders', 'anorexia_nervosa', 'bulimia_nervosa',
                 'borderline_idiopathic_developmental_intellectual_disability',
                 'mild_idiopathic_developmental_intellectual_disability',
                 'moderate_idiopathic_developmental_intellectual_disability',
                 'severe_idiopathic_developmental_intellectual_disability',
                 'profound_idiopathic_developmental_intellectual_disability', 'mild_other_mental_disorders',
                 'acute_glomerulonephritis', 'end_stage_renal_disease_after_transplant_due_to_hypertension',
                 'end_stage_renal_disease_after_transplant_due_to_glomerulonephritis',
                 'end_stage_renal_disease_after_transplant_due_to_other_and_unspecified_causes',
                 'mild_urinary_tract_infections', 'moderate_urinary_tract_infections',
                 'idiopathic_primary_male_infertility', 'idiopathic_secondary_male_infertility',
                 'other_urinary_diseases', 'primary_infertility_due_to_polycystic_ovarian_syndrome',
                 'idiopathic_primary_female_infertility', 'idiopathic_secondary_female_infertility',
                 'mild_abdominal_pain_due_to_endometriosis', 'moderate_abdominal_pain_due_to_endometriosis',
                 'primary_infertility_due_to_endometriosis', 'secondary_infertility_due_to_endometriosis',
                 'abdominal_pain_due_to_premenstrual_syndrome', 'mild_anemia_due_to_menstrual_disorders',
                 'moderate_anemia_due_to_menstrual_disorders', 'severe_anemia_due_to_menstrual_disorders',
                 'mild_heart_failure_due_to_thalassemias', 'moderate_heart_failure_due_to_thalassemias',
                 'severe_heart_failure_due_to_thalassemias',
                 'mild_anemia_due_to_other_hemoglobinopathies_and_hemolytic_anemias',
                 'moderate_anemia_due_to_other_hemoglobinopathies_and_hemolytic_anemias',
                 'severe_anemia_due_to_other_hemoglobinopathies_and_hemolytic_anemias',
                 'mild_heart_failure_due_to_other_hemoglobinopathies_and_hemolytic_anemias',
                 'moderate_heart_failure_due_to_other_hemoglobinopathies_and_hemolytic_anemias',
                 'severe_heart_failure_due_to_other_hemoglobinopathies_and_hemolytic_anemias',
                 'mild_anemia_due_to_endocrine_metabolic_blood_and_immune_disorders',
                 'moderate_anemia_due_to_endocrine_metabolic_blood_and_immune_disorders',
                 'severe_anemia_due_to_endocrine_metabolic_blood_and_immune_disorders',
                 'mild_heart_failure_due_to_endocrine_metabolic_blood_and_immune_disorders',
                 'moderate_heart_failure_due_to_endocrine_metabolic_blood_and_immune_disorders',
                 'severe_heart_failure_due_to_endocrine_metabolic_blood_and_immune_disorders',
                 'mild_rheumatoid_arthritis', 'moderate_rheumatoid_arthritis', 'severe_rheumatoid_arthritis',
                 'mild_osteoarthritis_of_the_hip', 'moderate_osteoarthritis_of_the_hip',
                 'severe_osteoarthritis_of_the_hip', 'mild_osteoarthritis_of_the_knee',
                 'moderate_osteoarthritis_of_the_knee', 'severe_osteoarthritis_of_the_knee',
                 'severe_low_back_pain_with_leg_pain', 'severe_low_back_pain_without_leg_pain',
                 'most_severe_low_back_pain_with_leg_pain', 'most_severe_low_back_pain_without_leg_pain',
                 'mild_neck_pain', 'severe_neck_pain', 'moderate_neck_pain', 'most_severe_neck_pain',
                 'polyarticular_gout', 'other_musculoskeletal_disorders_severity_level_2',
                 'other_musculoskeletal_disorders_severity_level_3',
                 'other_musculoskeletal_disorders_severity_level_5',
                 'other_musculoskeletal_disorders_severity_level_6',
                 'other_musculoskeletal_disorders_severity_level_1',
                 'other_musculoskeletal_disorders_severity_level_4',
                 'congenital_heart_disease_due_to_turner_syndrome', 'primary_infertility_due_to_turner_syndrome',
                 'borderline_intellectual_disability_due_to_klinefelter_syndrome',
                 'mild_intellectual_disability_due_to_klinefelter_syndrome',
                 'mild_intellectual_disability_with_infertility_due_to_klinefelter_syndrome',
                 'mild_hearing_loss_due_to_other_congenital_anomalies',
                 'mild_hearing_loss_with_ringing_due_to_other_congenital_anomalies',
                 'moderate_hearing_loss_due_to_other_congenital_anomalies',
                 'moderate_hearing_loss_with_ringing_due_to_other_congenital_anomalies',
                 'severe_hearing_loss_with_ringing_due_to_other_congenital_anomalies',
                 'severe_hearing_loss_due_to_other_congenital_anomalies',
                 'complete_hearing_loss_due_to_other_congenital_anomalies',
                 'complete_hearing_loss_with_ringing_due_to_other_congenital_anomalies',
                 'moderately_severe_hearing_loss_due_to_other_congenital_anomalies',
                 'moderately_severe_hearing_loss_with_ringing_due_to_other_congenital_anomalies',
                 'profound_hearing_loss_due_to_other_congenital_anomalies',
                 'profound_hearing_loss_with_ringing_due_to_other_congenital_anomalies', 'mild_atopic_dermatitis',
                 'moderate_atopic_dermatitis', 'severe_atopic_dermatitis', 'mild_psoriasis', 'moderate_psoriasis',
                 'severe_psoriasis', 'impetigo', 'abscess_and_other_bacterial_skin_diseases', 'scabies',
                 'tinea_capitis', 'mild_viral_warts', 'severe_viral_warts', 'mild_alopecia_areata',
                 'severe_alopecia_areata', 'pruritus', 'mild_urticaria', 'severe_urticaria', 'mild_decubitus_ulcer',
                 'moderate_decubitus_ulcer', 'severe_decubitus_ulcer', 'moderate_vision_impairment_due_to_glaucoma',
                 'severe_vision_impairment_due_to_glaucoma', 'blindness_due_to_glaucoma',
                 'moderate_vision_impairment_due_to_cataract', 'severe_vision_impairment_due_to_cataract',
                 'blindness_due_to_cataract', 'moderate_vision_impairment_due_to_macular_degeneration',
                 'severe_vision_impairment_due_to_macular_degeneration', 'blindness_due_to_macular_degeneration',
                 'moderate_vision_impairment_due_to_uncorrected_refractive_error',
                 'severe_vision_impairment_due_to_uncorrected_refractive_error',
                 'blindness_due_to_uncorrected_refractive_error',
                 'mild_hearing_loss_due_to_age_related_and_other_hearing_loss',
                 'mild_hearing_loss_with_ringing_due_to_age_related_and_other_hearing_loss',
                 'moderate_hearing_loss_due_to_age_related_and_other_hearing_loss',
                 'moderate_hearing_loss_with_ringing_due_to_age_related_and_other_hearing_loss',
                 'moderately_severe_hearing_loss_due_to_age_related_and_other_hearing_loss',
                 'moderately_severe_hearing_loss_with_ringing_due_to_age_related_and_other_hearing_loss',
                 'severe_hearing_loss_with_ringing_due_to_age_related_and_other_hearing_loss',
                 'severe_hearing_loss_due_to_age_related_and_other_hearing_loss',
                 'profound_hearing_loss_due_to_age_related_and_other_hearing_loss',
                 'profound_hearing_loss_with_ringing_due_to_age_related_and_other_hearing_loss',
                 'complete_hearing_loss_due_to_age_related_and_other_hearing_loss',
                 'complete_hearing_loss_with_ringing_due_to_age_related_and_other_hearing_loss',
                 'moderate_vision_impairment_due_to_other_vision_loss',
                 'severe_vision_impairment_due_to_other_vision_loss', 'blindness_due_to_other_vision_loss',
                 'bipolar_disorder_depressive_state', 'mild_anemia_due_to_b_thalassemia_trait',
                 'moderate_anemia_due_to_b_thalassemia_trait', 'severe_anemia_due_to_b_thalassemia_trait',
                 'mild_anemia_due_to_hemoglobin_e_trait', 'moderate_anemia_due_to_hemoglobin_e_trait',
                 'severe_anemia_due_to_hemoglobin_e_trait', 'mild_anemia_due_to_sickle_cell_trait',
                 'moderate_anemia_due_to_sickle_cell_trait', 'severe_anemia_due_to_sickle_cell_trait',
                 'mild_anemia_due_to_hemizygous_g6pd_trait', 'moderate_anemia_due_to_hemizygous_g6pd_trait',
                 'severe_anemia_due_to_hemizygous_g6pd_trait', 'disfigurement_due_to_basal_cell_carcinoma',
                 'severe_skin_disease_due_to_onchocerciasis', 'mild_contact_dermatitis',
                 'moderate_contact_dermatitis', 'symptomatic_seborrhoeic_dermatitis',
                 'pain_due_to_caries_of_deciduous_teeth', 'pain_due_to_caries_of_permanent_teeth',
                 'difficulty_eating_due_to_edentulism_and_severe_tooth_loss', 'mild_diarrheal_diseases',
                 'moderate_diarrheal_diseases', 'severe_diarrheal_diseases',
                 'guillain_barre_syndrome_due_to_diarrheal_diseases', 'moderate_lower_respiratory_infections',
                 'severe_lower_respiratory_infections',
                 'guillain_barre_syndrome_due_to_lower_respiratory_infections', 'other_fungal_skin_diseases',
                 'mild_skin_disease_without_itch_due_to_onchocerciasis',
                 'severe_skin_disease_without_itch_due_to_onchocerciasis', 'infertility_due_to_puerperal_sepsis',
                 'other_hypertensive_disorders_of_pregnancy', 'long_term_sequelae_of_eclampsia',
                 'very_mild_alcohol_dependence', 'mild_amphetamine_dependence', 'moderate_other_mental_disorders',
                 'severe_other_mental_disorders', 'mild_low_back_pain_with_leg_pain',
                 'mild_low_back_pain_without_leg_pain', 'moderate_low_back_pain_with_leg_pain',
                 'moderate_low_back_pain_without_leg_pain', 'mild_cannabis_dependence', 'mild_cocaine_dependence',
                 'congenital_heart_disease_with_infertility_due_to_turner_syndrome',
                 'neurocysticercosis_with_epilepsy', 'mild_opioid_dependence',
                 'borderline_intellectual_disability_with_infertility_due_to_klinefelter_syndrome',
                 'depression_due_to_premenstrual_syndrome',
                 'moderate_motor_plus_cognitive_impairment_with_blindness_due_to_hemolytic_disease_and_other_neonatal_jaundice',
                 'moderate_motor_plus_cognitive_impairment_with_blindness_due_to_neonatal_preterm_birth_complications_28_32wks',
                 'moderate_motor_plus_cognitive_impairment_with_blindness_due_to_neonatal_preterm_birth_complications_less_than_28wks',
                 'moderate_motor_plus_cognitive_impairment_with_blindness_due_to_neonatal_preterm_birth_complications_32_36wks',
                 'moderate_motor_plus_cognitive_impairment_with_blindness_due_to_neonatal_encephalopathy_due_to_birth_asphyxia_and_trauma',
                 'moderate_motor_plus_cognitive_impairment_with_blindness_due_to_neonatal_tetanus',
                 'moderate_motor_plus_cognitive_impairment_with_blindness_and_epilepsy_due_to_neonatal_preterm_birth_complications_32_36wks',
                 'moderate_motor_plus_cognitive_impairment_with_blindness_and_epilepsy_due_to_neonatal_preterm_birth_complications_less_than_28wks',
                 'moderate_motor_plus_cognitive_impairment_with_blindness_and_epilepsy_due_to_neonatal_preterm_birth_complications_28_32wks',
                 'moderate_motor_plus_cognitive_impairment_with_blindness_and_epilepsy_due_to_neonatal_tetanus',
                 'moderate_motor_plus_cognitive_impairment_with_blindness_and_epilepsy_due_to_hemolytic_disease_and_other_neonatal_jaundice',
                 'moderate_motor_plus_cognitive_impairment_with_blindness_and_epilepsy_due_to_neonatal_encephalopathy_due_to_birth_asphyxia_and_trauma',
                 'moderate_motor_plus_cognitive_impairment_with_epilepsy_due_to_neonatal_preterm_birth_complications_32_36wks',
                 'moderate_motor_plus_cognitive_impairment_with_epilepsy_due_to_neonatal_tetanus',
                 'moderate_motor_plus_cognitive_impairment_with_epilepsy_due_to_hemolytic_disease_and_other_neonatal_jaundice',
                 'moderate_motor_plus_cognitive_impairment_with_epilepsy_due_to_neonatal_encephalopathy_due_to_birth_asphyxia_and_trauma',
                 'moderate_motor_plus_cognitive_impairment_with_epilepsy_due_to_neonatal_preterm_birth_complications_less_than_28wks',
                 'moderate_motor_plus_cognitive_impairment_with_epilepsy_due_to_neonatal_preterm_birth_complications_28_32wks',
                 'severe_motor_plus_cognitive_impairment_with_blindness_due_to_neonatal_tetanus',
                 'severe_motor_plus_cognitive_impairment_with_blindness_due_to_neonatal_preterm_birth_complications_28_32wks',
                 'severe_motor_plus_cognitive_impairment_with_blindness_due_to_neonatal_preterm_birth_complications_32_36wks',
                 'severe_motor_plus_cognitive_impairment_with_blindness_due_to_hemolytic_disease_and_other_neonatal_jaundice',
                 'severe_motor_plus_cognitive_impairment_with_blindness_due_to_neonatal_encephalopathy_due_to_birth_asphyxia_and_trauma',
                 'severe_motor_plus_cognitive_impairment_with_blindness_due_to_neonatal_preterm_birth_complications_less_than_28wks',
                 'severe_motor_plus_cognitive_impairment_with_blindness_and_epilepsy_due_to_neonatal_preterm_birth_complications_28_32wks',
                 'severe_motor_plus_cognitive_impairment_with_blindness_and_epilepsy_due_to_neonatal_preterm_birth_complications_less_than_28wks',
                 'severe_motor_plus_cognitive_impairment_with_blindness_and_epilepsy_due_to_hemolytic_disease_and_other_neonatal_jaundice',
                 'severe_motor_plus_cognitive_impairment_with_blindness_and_epilepsy_due_to_neonatal_encephalopathy_due_to_birth_asphyxia_and_trauma',
                 'severe_motor_plus_cognitive_impairment_with_blindness_and_epilepsy_due_to_neonatal_preterm_birth_complications_32_36wks',
                 'severe_motor_plus_cognitive_impairment_with_blindness_and_epilepsy_due_to_neonatal_tetanus',
                 'severe_motor_plus_cognitive_impairment_with_epilepsy_due_to_neonatal_preterm_birth_complications_less_than_28wks',
                 'severe_motor_plus_cognitive_impairment_with_epilepsy_due_to_neonatal_encephalopathy_due_to_birth_asphyxia_and_trauma',
                 'severe_motor_plus_cognitive_impairment_with_epilepsy_due_to_hemolytic_disease_and_other_neonatal_jaundice',
                 'severe_motor_plus_cognitive_impairment_with_epilepsy_due_to_neonatal_preterm_birth_complications_32_36wks',
                 'severe_motor_plus_cognitive_impairment_with_epilepsy_due_to_neonatal_preterm_birth_complications_28_32wks',
                 'severe_motor_plus_cognitive_impairment_with_epilepsy_due_to_neonatal_tetanus',
                 'moderate_motor_impairment_due_to_neonatal_tetanus',
                 'moderate_motor_impairment_due_to_hemolytic_disease_and_other_neonatal_jaundice',
                 'moderate_motor_impairment_due_to_neonatal_preterm_birth_complications_28_32wks',
                 'moderate_motor_impairment_due_to_neonatal_encephalopathy_due_to_birth_asphyxia_and_trauma',
                 'moderate_motor_impairment_due_to_neonatal_preterm_birth_complications_less_than_28wks',
                 'moderate_motor_impairment_due_to_neonatal_preterm_birth_complications_32_36wks',
                 'moderate_motor_impairment_with_blindness_due_to_neonatal_preterm_birth_complications_less_than_28wks',
                 'moderate_motor_impairment_with_blindness_due_to_neonatal_preterm_birth_complications_28_32wks',
                 'moderate_motor_impairment_with_blindness_due_to_neonatal_preterm_birth_complications_32_36wks',
                 'moderate_motor_impairment_with_blindness_due_to_neonatal_tetanus',
                 'moderate_motor_impairment_with_blindness_due_to_neonatal_encephalopathy_due_to_birth_asphyxia_and_trauma',
                 'moderate_motor_impairment_with_blindness_due_to_hemolytic_disease_and_other_neonatal_jaundice',
                 'moderate_motor_impairment_with_blindness_and_epilepsy_due_to_hemolytic_disease_and_other_neonatal_jaundice',
                 'moderate_motor_impairment_with_blindness_and_epilepsy_due_to_neonatal_encephalopathy_due_to_birth_asphyxia_and_trauma',
                 'moderate_motor_impairment_with_blindness_and_epilepsy_due_to_neonatal_preterm_birth_complications_32_36wks',
                 'moderate_motor_impairment_with_blindness_and_epilepsy_due_to_neonatal_preterm_birth_complications_28_32wks',
                 'moderate_motor_impairment_with_blindness_and_epilepsy_due_to_neonatal_preterm_birth_complications_less_than_28wks',
                 'moderate_motor_impairment_with_blindness_and_epilepsy_due_to_neonatal_tetanus',
                 'moderate_motor_impairment_with_epilepsy_due_to_neonatal_preterm_birth_complications_32_36wks',
                 'moderate_motor_impairment_with_epilepsy_due_to_neonatal_tetanus',
                 'moderate_motor_impairment_with_epilepsy_due_to_neonatal_preterm_birth_complications_28_32wks',
                 'moderate_motor_impairment_with_epilepsy_due_to_neonatal_encephalopathy_due_to_birth_asphyxia_and_trauma',
                 'moderate_motor_impairment_with_epilepsy_due_to_neonatal_preterm_birth_complications_less_than_28wks',
                 'moderate_motor_impairment_with_epilepsy_due_to_hemolytic_disease_and_other_neonatal_jaundice',
                 'severe_motor_impairment_due_to_neonatal_encephalopathy_due_to_birth_asphyxia_and_trauma',
                 'severe_motor_impairment_severe_due_to_hemolytic_disease_and_other_neonatal_jaundice',
                 'severe_motor_impairment_due_to_neonatal_preterm_birth_complications_less_than_28wks',
                 'severe_motor_impairment_due_to_neonatal_preterm_birth_complications_32_36wks',
                 'severe_motor_impairment_due_to_neonatal_preterm_birth_complications_28_32wks',
                 'severe_motor_impairment_due_to_neonatal_tetanus',
                 'severe_motor_impairment_with_blindness_due_to_neonatal_preterm_birth_complications_28_32wks',
                 'severe_motor_impairment_with_blindness_due_to_neonatal_tetanus',
                 'severe_motor_impairment_with_blindness_due_to_hemolytic_disease_and_other_neonatal_jaundice',
                 'severe_motor_impairment_with_blindness_due_to_neonatal_preterm_birth_complications_less_than_28wks',
                 'severe_motor_impairment_with_blindness_due_to_neonatal_preterm_birth_complications_32_36wks',
                 'severe_motor_impairment_with_blindness_due_to_neonatal_encephalopathy_due_to_birth_asphyxia_and_trauma',
                 'severe_motor_impairment_with_blindness_and_epilepsy_due_to_neonatal_tetanus',
                 'severe_motor_impairment_with_blindness_and_epilepsy_due_to_neonatal_preterm_birth_complications_less_than_28wks',
                 'severe_motor_impairment_with_blindness_and_epilepsy_due_to_neonatal_preterm_birth_complications_28_32wks',
                 'severe_motor_impairment_with_blindness_and_epilepsy_due_to_hemolytic_disease_and_other_neonatal_jaundice',
                 'severe_motor_impairment_with_blindness_and_epilepsy_due_to_neonatal_preterm_birth_complications_32_36wks',
                 'severe_motor_impairment_with_blindness_and_epilepsy_due_to_neonatal_encephalopathy_due_to_birth_asphyxia_and_trauma',
                 'severe_motor_impairment_with_epilepsy_due_to_neonatal_encephalopathy_due_to_birth_asphyxia_and_trauma',
                 'severe_motor_impairment_with_epilepsy_due_to_neonatal_preterm_birth_complications_32_36wks',
                 'severe_motor_impairment_with_epilepsy_due_to_neonatal_tetanus',
                 'severe_motor_impairment_with_epilepsy_due_to_neonatal_preterm_birth_complications_less_than_28wks',
                 'severe_motor_impairment_with_epilepsy_due_to_neonatal_preterm_birth_complications_28_32wks',
                 'severe_motor_impairment_with_epilepsy_due_to_hemolytic_disease_and_other_neonatal_jaundice',
                 'mild_motor_impairment_due_to_neonatal_tetanus',
                 'mild_motor_plus_cognitive_impairments_due_to_neonatal_tetanus', 'epilepsy_due_to_echinococcosis',
                 'symptomatic_genital_herpes', 'other_hemoglobinopathies_and_hemolytic_anemias_residual',
                 'mild_behavioral_problems_due_to_encephalitis',
                 'mild_motor_impairment_due_to_long_term_due_to_encephalitis',
                 'mild_motor_plus_cognitive_impairments_due_to_encephalitis',
                 'borderline_intellectual_disability_due_to_encephalitis',
                 'monocular_distance_vision_loss_due_to_encephalitis',
                 'mild_intellectual_disability_due_to_encephalitis', 'moderate_motor_impairment_due_to_encephalitis',
                 'severe_motor_impairment_due_to_encephalitis',
                 'moderate_motor_plus_cognitive_impairments_due_to_encephalitis',
                 'severe_motor_plus_cognitive_impairments_due_to_encephalitis', 'epilepsy_due_to_encephalitis',
                 'severe_opioid_dependence', 'severe_cocaine_dependence', 'severe_amphetamine_dependence',
                 'severe_cannabis_dependence', 'other_sexually_transmitted_diseases_residual',
                 'asymptomatic_atrial_fibrillation_and_flutter',
                 'symptomatic_attention_deficit_hyperactivity_disorder',
                 'attention_deficit_hyperactivity_disorder_currently_without_symptoms',
                 'asymptomatic_alcohol_dependence', 'asymptomatic_fetal_alcohol_syndrome',
                 'anxiety_disorders_currently_without_symptoms', 'symptomatic_conduct_disorder',
                 'conduct_disorder_currently_without_symptoms', 'asymptomatic_cannabis_dependence',
                 'asymptomatic_opioid_dependence', 'asymptomatic_cocaine_dependence', 'symptomatic_dysthymia',
                 'dysthymia_currently_without_symptoms', 'major_depressive_disorder_currently_without_symptoms',
                 'symptomatic_episodes_of_gout', 'asymptomatic_gout',
                 'severe_infectious_complications_due_to_chronic_otitis_media', 'asymptomatic_asthma',
                 'asymptomatic_genital_herpes', 'asymptomatic_endometriosis', 'asymptomatic_amphetamine_dependence',
                 'isolated_congenital_heart_disease_due_to_down_syndrome',
                 'asymptomatic_other_cardiovascular_diseases', 'mild_other_cardiovascular_diseases',
                 'moderate_other_cardiovascular_diseases', 'severe_other_cardiovascular_diseases',
                 'asymptomatic_other_gynecological_disorders', 'mild_other_gynecological_disorders',
                 'moderate_other_gynecological_disorders', 'severe_other_gynecological_disorders',
                 'other_mental_disorders_currently_without_symptoms', 'asymptomatic_premenstrual_syndrome',
                 'abdominal_pain_and_depression_due_to_premenstrual_syndrome',
                 'asymptomatic_polycystic_ovarian_syndrome', 'hirsutism_due_to_polycystic_ovarian_syndrome',
                 'hirsutism_and_primary_infertility_due_to_polycystic_ovarian_syndrome',
                 'asymptomatic_genital_prolapse', 'abdominal_pain_due_to_genital_prolapse',
                 'stress_incontinence_due_to_genital_prolapse',
                 'abdominal_pain_and_stress_incontinence_due_to_genital_prolapse', 'asymptomatic_acute_hepatitis_a',
                 'asymptomatic_acute_hepatitis_b', 'asymptomatic_acute_hepatitis_c',
                 'asymptomatic_acute_hepatitis_e', 'asymptomatic_retinopathy_of_prematurity',
                 'blindness_due_to_retinopathy_of_prematurity',
                 'mild_motor_impairment_due_to_neonatal_preterm_birth_complications_less_than_28wks',
                 'mild_motor_impairment_due_to_neonatal_preterm_birth_complications_28_32wks',
                 'mild_motor_impairment_due_to_neonatal_preterm_birth_complications_32_36wks',
                 'mild_motor_plus_cognitive_impairments_due_to_neonatal_preterm_birth_complications_less_than_28wks',
                 'mild_motor_plus_cognitive_impairments_due_to_neonatal_preterm_birth_complications_28_32wks',
                 'mild_motor_plus_cognitive_impairments_due_to_neonatal_preterm_birth_complications_32_36wks',
                 'blindness_due_to_encephalitis', 'blindness_due_to_onchocerciasis',
                 'moderate_vision_impairment_due_to_onchocerciasis',
                 'severe_vision_impairment_due_to_onchocerciasis',
                 'mild_abdominal_pain_and_primary_infertility_due_to_endometriosis',
                 'moderate_abdominal_pain_and_primary_infertility_due_to_endometriosis',
                 'severe_abdominal_pain_and_primary_infertility_due_to_endometriosis',
                 'mild_abdominal_pain_and_secondary_infertility_due_to_endometriosis',
                 'moderate_abdominal_pain_and_secondary_infertility_due_to_endometriosis',
                 'severe_abdominal_pain_and_secondary_infertility_due_to_endometriosis',
                 'moderate_motor_impairment_due_to_malaria',
                 'moderate_motor_impairment_with_blindness_due_to_malaria',
                 'moderate_motor_impairment_with_epilepsy_due_to_malaria',
                 'moderate_motor_impairment_with_blindness_and_epilepsy_due_to_malaria',
                 'moderate_motor_plus_cognitive_impairment_with_blindness_due_to_malaria',
                 'moderate_motor_plus_cognitive_impairment_with_epilepsy_due_to_malaria',
                 'moderate_motor_plus_cognitive_impairment_with_blindness_and_epilepsy_due_to_malaria',
                 'severe_motor_impairment_due_to_malaria', 'severe_motor_impairment_with_blindness_due_to_malaria',
                 'severe_motor_impairment_with_epilepsy_due_to_malaria',
                 'severe_motor_impairment_with_blindness_and_epilepsy_due_to_malaria',
                 'severe_motor_plus_cognitive_impairment_with_blindness_due_to_malaria',
                 'severe_motor_plus_cognitive_impairment_with_epilepsy_due_to_malaria',
                 'severe_motor_plus_cognitive_impairment_with_blindness_and_epilepsy_due_to_malaria',
                 'asymptomatic_other_skin_and_subcutaneous_diseases',
                 'symptomatic_other_skin_and_subcutaneous_diseases', 'mild_molluscum_contagiosum',
                 'severe_molluscum_contagiosum', 'chronic_hepatitis_b_without_cirrhosis',
                 'chronic_hepatitis_c_without_cirrhosis',
                 'asymptomatic_endocrine_metabolic_blood_and_immune_disorders',
                 'mild_endocrine_metabolic_blood_and_immune_disorders',
                 'moderate_endocrine_metabolic_blood_and_immune_disorders',
                 'severe_endocrine_metabolic_blood_and_immune_disorders',
                 'heavy_clonorchiasis_due_to_food_borne_trematodiases',
                 'heavy_fascioliasis_due_to_food_borne_trematodiases',
                 'heavy_intestinal_fluke_infection_due_to_food_borne_trematodiases',
                 'heavy_opisthorchiasis_due_to_food_borne_trematodiases',
                 'symptomatic_atrial_fibrillation_and_flutter', 'asymptomatic_turner_syndrome',
                 'moderate_vision_impairment_due_to_retinopathy_of_prematurity',
                 'severe_vision_impairment_due_to_retinopathy_of_prematurity', 'mild_chlamydial_infection',
                 'asymptomatic_chlamydial_infection', 'mild_gonococcal_infection',
                 'asymptomatic_gonococcal_infection', 'acute_trichomoniasis_infection',
                 'asymptomatic_trichomoniasis_infection', 'disfigurement_level_1_due_to_orofacial_clefts',
                 'disfigurement_level_2_due_to_orofacial_clefts',
                 'disfigurement_level_2_and_speech_problems_due_to_orofacial_clefts',
                 'asymptomatic_chronic_obstructive_pulmonary_disease', 'asymptomatic_down_syndrome',
                 'asymptomatic_other_chromosomal_abnormalities', 'primary_infertility_due_to_klinefelter_syndrome',
                 'asymptomatic_klinefelter_syndrome',
                 'isolated_congenital_heart_disease_due_to_other_chromosomal_abnormalities',
                 'asymptomatic_chagas_disease', 'chronic_periodontal_diseases', 'puerperal_sepsis',
                 'other_maternal_infections',
                 'hirsutism_and_secondary_infertility_due_to_polycystic_ovarian_syndrome',
                 'secondary_infertility_due_to_polycystic_ovarian_syndrome',
                 'severe_abdominal_pain_due_to_endometriosis',
                 'moderate_infection_due_to_initial_genital_herpes_episode',
                 'asymptomatic_caries_of_deciduous_teeth', 'asymptomatic_caries_of_permanent_teeth',
                 'asymptomatic_edentulism_and_severe_tooth_loss', 'asymptomatic_chronic_ischemic_stroke',
                 'asymptomatic_chronic_intracerebral_hemorrhage', 'asymptomatic_silicosis',
                 'asymptomatic_asbestosis', 'asymptomatic_coal_workers_pneumoconiosis',
                 'asymptomatic_other_pneumoconiosis',
                 'asymptomatic_interstitial_lung_disease_and_pulmonary_sarcoidosis',
                 'asymptomatic_angina_due_to_ischemic_heart_disease', 'asymptomatic_onchocerciasis',
                 'asymptomatic_ascariasis', 'asymptomatic_trichuriasis', 'asymptomatic_clonorchiasis',
                 'asymptomatic_fascioliasis', 'asymptomatic_intestinal_fluke_infection',
                 'asymptomatic_opisthorchiasis', 'asymptomatic_paragonimiasis',
                 'asymptomatic_peripheral_arterial_disease', 'asymptomatic_benign_prostatic_hyperplasia',
                 'symptomatic_benign_prostatic_hyperplasia', 'asymptomatic_uterine_fibroids',
                 'asymptomatic_other_musculoskeletal_disorders', 'mild_cellulitis', 'severe_cellulitis',
                 'gastrointestinal_bleeding_due_to_typhoid',
                 'vertigo_with_mild_hearing_loss_due_to_chronic_otitis_media',
                 'vertigo_with_mild_hearing_loss_and_ringing_due_to_chronic_otitis_media',
                 'asymptomatic_hookworm_disease',
                 'mild_heart_failure_due_to_severe_chronic_obstructive_pulmonary_disease',
                 'moderate_heart_failure_due_to_severe_chronic_obstructive_pulmonary_disease',
                 'severe_heart_failure_due_to_severe_chronic_obstructive_pulmonary_disease',
                 'severe_chronic_obstructive_pulmonary_disease_without_heart_failure',
                 'mild_heart_failure_due_to_severe_silicosis', 'moderate_heart_failure_due_to_severe_silicosis',
                 'severe_heart_failure_due_to_severe_silicosis', 'severe_silicosis_without_heart_failure',
                 'mild_heart_failure_due_to_severe_asbestosis', 'moderate_heart_failure_due_to_severe_asbestosis',
                 'severe_heart_failure_due_to_severe_asbestosis', 'severe_asbestosis_without_heart_failure',
                 'mild_heart_failure_due_to_severe_coal_workers_pneumoconiosis',
                 'moderate_heart_failure_due_to_severe_coal_workers_pneumoconiosis',
                 'severe_heart_failure_due_to_severe_coal_workers_pneumoconiosis',
                 'severe_coal_workers_pneumoconiosis_without_heart_failure',
                 'mild_heart_failure_due_to_severe_other_pneumoconiosis',
                 'moderate_heart_failure_due_to_severe_other_pneumoconiosis',
                 'severe_heart_failure_due_to_severe_other_pneumoconiosis',
                 'severe_other_pneumoconiosis_without_heart_failure',
                 'mild_heart_failure_due_to_severe_interstitial_lung_disease_and_pulmonary_sarcoidosis',
                 'moderate_heart_failure_due_to_severe_interstitial_lung_disease_and_pulmonary_sarcoidosis',
                 'severe_heart_failure_due_to_severe_interstitial_lung_disease_and_pulmonary_sarcoidosis',
                 'severe_interstitial_lung_disease_and_pulmonary_sarcoidosis_without_heart_failure',
                 'stage_3_chronic_kidney_disease_and_mild_anemia_due_to_hypertension',
                 'stage_3_chronic_kidney_disease_and_moderate_anemia_due_to_hypertension',
                 'stage_3_chronic_kidney_disease_and_severe_anemia_due_to_hypertension',
                 'stage_3_chronic_kidney_disease_without_anemia_due_to_hypertension',
                 'stage_3_chronic_kidney_disease_and_mild_anemia_due_to_glomerulonephritis',
                 'stage_3_chronic_kidney_disease_and_moderate_anemia_due_to_glomerulonephritis',
                 'stage_3_chronic_kidney_disease_and_severe_anemia_due_to_glomerulonephritis',
                 'stage_3_chronic_kidney_disease_without_anemia_due_to_glomerulonephritis',
                 'stage_3_chronic_kidney_disease_and_mild_anemia_due_to_other_causes',
                 'stage_3_chronic_kidney_disease_and_moderate_anemia_due_to_other_causes',
                 'stage_3_chronic_kidney_disease_and_severe_anemia_due_to_other_causes',
                 'stage_3_chronic_kidney_disease_without_anemia_due_to_other_causes',
                 'asymptomatic_ischemic_heart_disease_following_myocardial_infarction',
                 'symptomatic_claudication_due_to_peripheral_arterial_disease',
                 'asymptomatic_seborrhoeic_dermatitis', 'asymptomatic_contact_dermatitis',
                 'mild_other_oral_disorders', 'severe_other_oral_disorders', 'asymptomatic_b_thalassemia_trait',
                 'asymptomatic_hemoglobin_e_trait', 'asymptomatic_sickle_cell_trait',
                 'asymptomatic_hemizygous_g6pd_trait', 'mild_hearing_loss_due_to_chronic_otitis_media',
                 'mild_hearing_loss_with_ringing_due_to_chronic_otitis_media',
                 'asymptomatic_malaria_parasitemia_pfpr', 'mild_anemia_due_to_malaria_parasitemia_pfpr',
                 'moderate_anemia_due_to_malaria_parasitemia_pfpr', 'severe_anemia_due_to_malaria_parasitemia_pfpr',
                 'beta_thalassemia_major_severe_infection_with_severe_anemia',
                 'beta_thalassemia_major_with_mild_anemia', 'beta_thalassemia_major_with_moderate_anemia',
                 'beta_thalassemia_major_with_severe_anemia',
                 'hemoglobin_e_beta_thalassemia_severe_infection_with_severe_anemia',
                 'hemoglobin_e_beta_thalassemia_with_mild_anemia',
                 'hemoglobin_e_beta_thalassemia_with_moderate_anemia',
                 'hemoglobin_e_beta_thalassemia_with_severe_anemia',
                 'hemoglobin_h_disease_severe_infection_with_severe_anemia', 'hemoglobin_h_disease_with_mild_anemia',
                 'hemoglobin_h_disease_with_moderate_anemia', 'hemoglobin_h_disease_with_severe_anemia',
                 'homozygous_sickle_cell_and_severe_sickle_cell_beta_thalassemia_without_anemia',
                 'homozygous_sickle_cell_and_severe_sickle_cell_beta_thalassemia_with_vaso_occlusive_crisis_without_anemia',
                 'homozygous_sickle_cell_and_severe_sickle_cell_beta_thalassemia_with_vaso_occlusive_crisis_and_severe_anemia',
                 'homozygous_sickle_cell_and_severe_sickle_cell_beta_thalassemia_with_stroke_and_severe_anemia',
                 'homozygous_sickle_cell_and_severe_sickle_cell_beta_thalassemia_with_stroke_without_anemia',
                 'homozygous_sickle_cell_and_severe_sickle_cell_beta_thalassemia_with_vaso_occlusive_crisis_stroke_and_severe_anemia',
                 'homozygous_sickle_cell_and_severe_sickle_cell_beta_thalassemia_with_vaso_occlusive_crisis_and_stroke_without_anemia',
                 'homozygous_sickle_cell_and_severe_sickle_cell_beta_thalassemia_with_mild_anemia',
                 'homozygous_sickle_cell_and_severe_sickle_cell_beta_thalassemia_with_moderate_anemia',
                 'homozygous_sickle_cell_and_severe_sickle_cell_beta_thalassemia_with_severe_anemia',
                 'hemoglobin_sc_disease_without_anemia',
                 'hemoglobin_sc_disease_with_vaso_occlusive_crisis_and_severe_anemia',
                 'hemoglobin_sc_disease_with_vaso_occlusive_crisis_without_anemia',
                 'hemoglobin_sc_disease_with_stroke_and_severe_anemia',
                 'hemoglobin_sc_disease_with_stroke_without_anemia',
                 'hemoglobin_sc_disease_with_vaso_occlusive_crisis_stroke_and_severe_anemia',
                 'hemoglobin_sc_disease_with_vaso_occlusive_crisis_and_stroke_without_anemia',
                 'hemoglobin_sc_disease_with_mild_anemia', 'hemoglobin_sc_disease_with_moderate_anemia',
                 'hemoglobin_sc_disease_with_severe_anemia', 'mild_sickle_cell_beta_thalassemia_without_anemia',
                 'mild_sickle_cell_beta_thalassemia_with_vaso_occlusive_crisis_and_severe_anemia',
                 'mild_sickle_cell_beta_thalassemia_with_vaso_occlusive_crisis_without_anemia',
                 'mild_sickle_cell_beta_thalassemia_with_stroke_and_severe_anemia',
                 'mild_sickle_cell_beta_thalassemia_with_stroke_without_anemia',
                 'mild_sickle_cell_beta_thalassemia_with_vaso_occlusive_crisis_stroke_and_severe_anemia',
                 'mild_sickle_cell_beta_thalassemia_with_vaso_occlusive_crisis_and_stroke_without_anemia',
                 'mild_sickle_cell_beta_thalassemia_with_mild_anemia',
                 'mild_sickle_cell_beta_thalassemia_with_moderate_anemia',
                 'mild_sickle_cell_beta_thalassemia_with_severe_anemia',
                 'vertigo_with_moderate_hearing_loss_due_to_chronic_otitis_media',
                 'vertigo_with_moderate_hearing_loss_and_ringing_due_to_chronic_otitis_media',
                 'moderate_hearing_loss_due_to_chronic_otitis_media',
                 'moderate_hearing_loss_with_ringing_due_to_chronic_otitis_media',
                 'mild_abdominal_pain_due_to_uterine_fibroids_with_mild_anemia',
                 'mild_abdominal_pain_due_to_uterine_fibroids_with_moderate_anemia',
                 'mild_abdominal_pain_due_to_uterine_fibroids_with_severe_anemia',
                 'mild_abdominal_pain_due_to_uterine_fibroids_without_anemia', 'asymptomatic_yellow_fever',
                 'hemoglobin_h_disease_without_anemia', 'beta_thalassemia_major_without_anemia',
                 'hemoglobin_e_beta_thalassemia_without_anemia', 'rheumatic_heart_disease_without_heart_failure',
                 'mild_heart_failure_due_to_rheumatic_heart_disease',
                 'moderate_heart_failure_due_to_rheumatic_heart_disease',
                 'severe_heart_failure_due_to_rheumatic_heart_disease', 'mild_anemia_due_to_g6pd_deficiency',
                 'moderate_anemia_due_to_g6pd_deficiency', 'severe_anemia_due_to_g6pd_deficiency',
                 'mild_heart_failure_due_to_g6pd_deficiency', 'moderate_heart_failure_due_to_g6pd_deficiency',
                 'severe_heart_failure_due_to_g6pd_deficiency', 'asymptomatic_g6pd_deficiency',
                 'asymptomatic_gallbladder_and_biliary_diseases', 'moderate_vision_impairment_due_to_encephalitis',
                 'severe_vision_impairment_due_to_encephalitis',
                 'mild_motor_impairment_mild_respiratory_problems_and_speech_problems_due_to_motor_neuron_disease',
                 'mild_motor_impairment_moderate_respiratory_problems_and_speech_problems_due_to_motor_neuron_disease',
                 'mild_motor_impairment_severe_respiratory_problems_and_speech_problems_due_to_motor_neuron_disease',
                 'mild_motor_impairment_and_speech_problems_due_to_motor_neuron_disease',
                 'moderate_motor_impairment_mild_respiratory_problems_and_speech_problems_due_to_motor_neuron_disease',
                 'moderate_motor_impairment_moderate_respiratory_problems_and_speech_problems_due_to_motor_neuron_disease',
                 'moderate_motor_impairment_severe_respiratory_problems_and_speech_problems_due_to_motor_neuron_disease',
                 'severe_motor_impairment_mild_respiratory_problems_and_speech_problems_due_to_motor_neuron_disease',
                 'severe_motor_impairment_moderate_respiratory_problems_and_speech_problems_due_to_motor_neuron_disease',
                 'severe_motor_impairment_severe_respiratory_problems_and_speech_problems_due_to_motor_neuron_disease',
                 'mild_motor_impairment_and_mild_respiratory_problems_due_to_motor_neuron_disease',
                 'mild_motor_impairment_and_severe_respiratory_problems_due_to_motor_neuron_disease',
                 'moderate_motor_impairment_and_mild_respiratory_problems_due_to_motor_neuron_disease',
                 'moderate_motor_impairment_and_moderate_respiratory_problems_due_to_motor_neuron_disease',
                 'moderate_motor_impairment_and_severe_respiratory_problems_due_to_motor_neuron_disease',
                 'severe_motor_impairment_and_mild_respiratory_problems_due_to_motor_neuron_disease',
                 'severe_motor_impairment_and_moderate_respiratory_problems_due_to_motor_neuron_disease',
                 'severe_motor_impairment_and_severe_respiratory_problems_due_to_motor_neuron_disease',
                 'moderate_motor_impairment_and_speech_problems_due_to_motor_neuron_disease',
                 'severe_motor_impairment_and_speech_problems_due_to_motor_neuron_disease',
                 'mild_motor_impairment_due_to_motor_neuron_disease',
                 'moderate_motor_impairment_due_to_motor_neuron_disease',
                 'severe_motor_impairment_due_to_motor_neuron_disease',
                 'mild_respiratory_problems_and_speech_problems_due_to_motor_neuron_disease',
                 'moderate_respiratory_problems_and_speech_problems_due_to_motor_neuron_disease',
                 'severe_respiratory_problems_and_speech_problems_due_to_motor_neuron_disease',
                 'mild_respiratory_problems_due_to_motor_neuron_disease',
                 'moderate_respiratory_problems_due_to_motor_neuron_disease',
                 'severe_respiratory_problems_due_to_motor_neuron_disease',
                 'speech_problems_due_to_motor_neuron_disease', 'diagnosis_of_motor_neuron_disease', 'ebola_cases',
                 'post_ebola_chronic_fatigue_syndrome',
                 'diagnosis_and_primary_therapy_phase_of_acute_lymphoid_leukemia',
                 'diagnosis_and_primary_therapy_phase_of_acute_myeloid_leukemia',
                 'diagnosis_and_primary_therapy_phase_of_chronic_lymphoid_leukemia',
                 'diagnosis_and_primary_therapy_phase_of_chronic_myeloid_leukemia',
                 'controlled_phase_of_acute_lymphoid_leukemia', 'controlled_phase_of_acute_myeloid_leukemia',
                 'controlled_phase_of_chronic_lymphoid_leukemia', 'controlled_phase_of_chronic_myeloid_leukemia',
                 'metastatic_phase_of_acute_lymphoid_leukemia', 'metastatic_phase_of_acute_myeloid_leukemia',
                 'metastatic_phase_of_chronic_lymphoid_leukemia', 'metastatic_phase_of_chronic_myeloid_leukemia',
                 'terminal_phase_of_acute_lymphoid_leukemia', 'terminal_phase_of_acute_myeloid_leukemia',
                 'terminal_phase_of_chronic_lymphoid_leukemia', 'terminal_phase_of_chronic_myeloid_leukemia',
                 'asymptomatic_early_syphilis_infection', 'mild_early_syphilis_infection',
                 'borderline_intellectual_disability_due_to_down_syndrome',
                 'mild_intellectual_disability_due_to_down_syndrome',
                 'moderate_intellectual_disability_due_to_down_syndrome',
                 'severe_intellectual_disability_due_to_down_syndrome',
                 'profound_intellectual_disability_due_to_down_syndrome',
                 'borderline_intellectual_disability_with_congenital_heart_disease_due_to_down_syndrome',
                 'mild_intellectual_disability_with_congenital_heart_disease_due_to_down_syndrome',
                 'moderate_intellectual_disability_with_congenital_heart_disease_due_to_down_syndrome',
                 'severe_intellectual_disability_with_congenital_heart_disease_due_to_down_syndrome',
                 'profound_intellectual_disability_with_congenital_heart_disease_due_to_down_syndrome',
                 'borderline_intellectual_disability_due_to_other_chromosomal_abnormalities',
                 'mild_intellectual_disability_due_to_other_chromosomal_abnormalities',
                 'moderate_intellectual_disability_due_to_other_chromosomal_abnormalities',
                 'severe_intellectual_disability_due_to_other_chromosomal_abnormalities',
                 'profound_intellectual_disability_due_to_other_chromosomal_abnormalities',
                 'borderline_intellectual_disability_with_congenital_heart_disease_due_to_other_chromosomal_abnormalities',
                 'mild_intellectual_disability_with_congenital_heart_disease_due_to_other_chromosomal_abnormalities',
                 'moderate_intellectual_disability_with_congenital_heart_disease_due_to_other_chromosomal_abnormalities',
                 'severe_intellectual_disability_with_congenital_heart_disease_due_to_other_chromosomal_abnormalities',
                 'profound_intellectual_disability_with_congenital_heart_disease_due_to_other_chromosomal_abnormalities',
                 'mild_dementia_due_to_down_syndrome', 'moderate_dementia_due_to_down_syndrome',
                 'severe_dementia_due_to_down_syndrome',
                 'congenital_heart_disease_and_mild_dementia_due_to_down_syndrome',
                 'congenital_heart_disease_and_moderate_dementia_due_to_down_syndrome',
                 'congenital_heart_disease_and_severe_dementia_due_to_down_syndrome',
                 'mild_dementia_due_to_other_chromosomal_abnormalities',
                 'moderate_dementia_due_to_other_chromosomal_abnormalities',
                 'severe_dementia_due_to_other_chromosomal_abnormalities',
                 'congenital_heart_disease_and_mild_dementia_due_to_other_chromosomal_abnormalities',
                 'congenital_heart_disease_and_moderate_dementia_due_to_other_chromosomal_abnormalities',
                 'congenital_heart_disease_and_severe_dementia_due_to_other_chromosomal_abnormalities',
                 'asymptomatic_neonatal_preterm_birth_less_than_28_weeks',
                 'asymptomatic_neonatal_preterm_birth_28_less_than_32_wks',
                 'asymptomatic_neonatal_preterm_birth_32_less_than_37wks',
                 'asymptomatic_neonatal_encephalopathy_due_to_birth_asphyxia_and_trauma',
                 'asymptomatic_neonatal_sepsis_and_other_neonatal_infections',
                 'mild_motor_plus_cognitive_impairments_due_to_neonatal_sepsis_and_other_neonatal_infections',
                 'mild_motor_impairment_due_to_neonatal_sepsis_and_other_neonatal_infections',
                 'moderate_motor_impairment_due_to_neonatal_sepsis_and_other_neonatal_infections',
                 'moderate_motor_impairment_with_blindness_due_to_neonatal_sepsis_and_other_neonatal_infections',
                 'moderate_motor_impairment_with_epilepsy_due_to_neonatal_sepsis_and_other_neonatal_infections',
                 'moderate_motor_impairment_with_blindness_and_epilepsy_due_to_neonatal_sepsis_and_other_neonatal_infections',
                 'moderate_motor_plus_cognitive_impairment_with_blindness_due_to_neonatal_sepsis_and_other_neonatal_infections',
                 'moderate_motor_plus_cognitive_impairment_with_epilepsy_due_to_neonatal_sepsis_and_other_neonatal_infections',
                 'moderate_motor_plus_cognitive_impairment_with_blindness_and_epilepsy_due_to_neonatal_sepsis_and_other_neonatal_infections',
                 'severe_motor_impairment_due_to_neonatal_sepsis_and_other_neonatal_infections',
                 'severe_motor_impairment_with_blindness_due_to_neonatal_sepsis_and_other_neonatal_infections',
                 'severe_motor_impairment_with_epilepsy_due_to_neonatal_sepsis_and_other_neonatal_infections',
                 'severe_motor_impairment_with_blindness_and_epilepsy_due_to_neonatal_sepsis_and_other_neonatal_infections',
                 'severe_motor_plus_cognitive_impairment_with_blindness_due_to_neonatal_sepsis_and_other_neonatal_infections',
                 'severe_motor_plus_cognitive_impairment_with_epilepsy_due_to_neonatal_sepsis_and_other_neonatal_infections',
                 'severe_motor_plus_cognitive_impairment_with_blindness_and_epilepsy_due_to_neonatal_sepsis_and_other_neonatal_infections',
                 'borderline_intellectual_disability_mild_dementia_and_congenital_heart_disease_due_to_down_syndrome',
                 'mild_intellectual_disability_mild_dementia_and_congenital_heart_disease_due_to_down_syndrome',
                 'moderate_intellectual_disability_mild_dementia_and_congenital_heart_disease_due_to_down_syndrome',
                 'severe_intellectual_disability_mild_dementia_and_congenital_heart_disease_due_to_down_syndrome',
                 'profound_intellectual_disability_mild_dementia_and_congenital_heart_disease_due_to_down_syndrome',
                 'borderline_intellectual_disability_moderate_dementia_and_congenital_heart_disease_due_to_down_syndrome',
                 'mild_intellectual_disability_moderate_dementia_and_congenital_heart_disease_due_to_down_syndrome',
                 'moderate_intellectual_disability_moderate_dementia_and_congenital_heart_disease_due_to_down_syndrome',
                 'severe_intellectual_disability_moderate_dementia_and_congenital_heart_disease_due_to_down_syndrome',
                 'profound_intellectual_disability_moderate_dementia_and_congenital_heart_disease_due_to_down_syndrome',
                 'borderline_intellectual_disability_severe_dementia_and_congenital_heart_disease_due_to_down_syndrome',
                 'mild_intellectual_disability_severe_dementia_and_congenital_heart_disease_due_to_down_syndrome',
                 'moderate_intellectual_disability_severe_dementia_and_congenital_heart_disease_due_to_down_syndrome',
                 'severe_intellectual_disability_severe_dementia_and_congenital_heart_disease_due_to_down_syndrome',
                 'profound_intellectual_disability_severe_dementia_and_congenital_heart_disease_due_to_down_syndrome',
                 'borderline_intellectual_disability_mild_dementia_and_congenital_heart_disease_due_to_other_chromosomal_abnormalities',
                 'mild_intellectual_disability_mild_dementia_and_congenital_heart_disease_due_to_other_chromosomal_abnormalities',
                 'moderate_intellectual_disability_mild_dementia_and_congenital_heart_disease_due_to_other_chromosomal_abnormalities',
                 'severe_intellectual_disability_mild_dementia_and_congenital_heart_disease_due_to_other_chromosomal_abnormalities',
                 'profound_intellectual_disability_mild_dementia_and_congenital_heart_disease_due_to_other_chromosomal_abnormalities',
                 'borderline_intellectual_disability_moderate_dementia_and_congenital_heart_disease_due_to_other_chromosomal_abnormalities',
                 'mild_intellectual_disability_moderate_dementia_and_congenital_heart_disease_due_to_other_chromosomal_abnormalities',
                 'moderate_intellectual_disability_moderate_dementia_and_congenital_heart_disease_due_to_other_chromosomal_abnormalities',
                 'severe_intellectual_disability_moderate_dementia_and_congenital_heart_disease_due_to_other_chromosomal_abnormalities',
                 'profound_intellectual_disability_moderate_dementia_and_congenital_heart_disease_due_to_other_chromosomal_abnormalities',
                 'borderline_intellectual_disability_severe_dementia_and_congenital_heart_disease_due_to_other_chromosomal_abnormalities',
                 'mild_intellectual_disability_severe_dementia_and_congenital_heart_disease_due_to_other_chromosomal_abnormalities',
                 'moderate_intellectual_disability_severe_dementia_and_congenital_heart_disease_due_to_other_chromosomal_abnormalities',
                 'severe_intellectual_disability_severe_dementia_and_congenital_heart_disease_due_to_other_chromosomal_abnormalities',
                 'profound_intellectual_disability_severe_dementia_and_congenital_heart_disease_due_to_other_chromosomal_abnormalities',
                 'profound_intellectual_disability_and_mild_dementia_due_to_down_syndrome',
                 'severe_intellectual_disability_and_mild_dementia_due_to_down_syndrome',
                 'moderate_intellectual_disability_and_mild_dementia_due_to_down_syndrome',
                 'mild_intellectual_disability_and_mild_dementia_due_to_down_syndrome',
                 'borderline_intellectual_disability_and_mild_dementia_due_to_down_syndrome',
                 'profound_intellectual_disability_and_moderate_dementia_due_to_down_syndrome',
                 'severe_intellectual_disability_and_moderate_dementia_due_to_down_syndrome',
                 'moderate_intellectual_disability_and_moderate_dementia_due_to_down_syndrome',
                 'mild_intellectual_disability_and_moderate_dementia_due_to_down_syndrome',
                 'borderline_intellectual_disability_and_moderate_dementia_due_to_down_syndrome',
                 'profound_intellectual_disability_and_severe_dementia_due_to_down_syndrome',
                 'severe_intellectual_disability_and_severe_dementia_due_to_down_syndrome',
                 'moderate_intellectual_disability_and_severe_dementia_due_to_down_syndrome',
                 'mild_intellectual_disability_and_severe_dementia_due_to_down_syndrome',
                 'borderline_intellectual_disability_and_severe_dementia_due_to_down_syndrome',
                 'profound_intellectual_disability_and_mild_dementia_due_to_other_chromosomal_abnormalities',
                 'severe_intellectual_disability_and_mild_dementia_due_to_other_chromosomal_abnormalities',
                 'moderate_intellectual_disability_and_mild_dementia_due_to_other_chromosomal_abnormalities',
                 'mild_intellectual_disability_and_mild_dementia_due_to_other_chromosomal_abnormalities',
                 'borderline_intellectual_disability_and_mild_dementia_due_to_other_chromosomal_abnormalities',
                 'profound_intellectual_disability_and_moderate_dementia_due_to_other_chromosomal_abnormalities',
                 'severe_intellectual_disability_and_moderate_dementia_due_to_other_chromosomal_abnormalities',
                 'moderate_intellectual_disability_and_moderate_dementia_due_to_other_chromosomal_abnormalities',
                 'mild_intellectual_disability_and_moderate_dementia_due_to_other_chromosomal_abnormalities',
                 'borderline_intellectual_disability_and_moderate_dementia_due_to_other_chromosomal_abnormalities',
                 'profound_intellectual_disability_and_severe_dementia_due_to_other_chromosomal_abnormalities',
                 'severe_intellectual_disability_and_severe_dementia_due_to_other_chromosomal_abnormalities',
                 'moderate_intellectual_disability_and_severe_dementia_due_to_other_chromosomal_abnormalities',
                 'mild_intellectual_disability_and_severe_dementia_due_to_other_chromosomal_abnormalities',
                 'borderline_intellectual_disability_and_severe_dementia_due_to_other_chromosomal_abnormalities',
                 'autism_spectrum_disorders_without_intellectual_disability',
                 'autism_spectrum_disorders_with_borderline_intellectual_disability',
                 'autism_spectrum_disorders_with_mild_intellectual_disability',
                 'autism_spectrum_disorders_with_moderate_intellectual_disability',
                 'autism_spectrum_disorders_with_severe_intellectual_disability',
                 'autism_spectrum_disorders_with_profound_intellectual_disability',
                 'asymptomatic_acute_other_sense_organ_diseases', 'mild_acute_other_sense_organ_diseases',
                 'moderate_acute_other_sense_organ_diseases', 'asymptomatic_chronic_other_sense_organ_diseases',
                 'mild_chronic_other_sense_organ_diseases', 'moderate_chronic_other_sense_organ_diseases',
                 'mild_paragonimiasis_due_to_food_borne_trematodiases',
                 'moderate_paragonimiasis_due_to_food_borne_trematodiases',
                 'severe_paragonimiasis_due_to_food_borne_trematodiases',
                 'asymptomatic_medication_overuse_headache_due_to_migraine',
                 'symptomatic_medication_overuse_headache_due_to_migraine',
                 'asymptomatic_medication_overuse_headache_due_to_tension_type_headache',
                 'symptomatic_medication_overuse_headache_due_to_tension_type_headache',
                 'stage_5_chronic_kidney_disease_untreated_without_anemia_due_to_hypertension',
                 'stage_5_chronic_kidney_disease_untreated_and_mild_anemia_due_to_hypertension',
                 'stage_5_chronic_kidney_disease_untreated_and_moderate_anemia_due_to_hypertension',
                 'stage_5_chronic_kidney_disease_untreated_and_severe_anemia_due_to_hypertension',
                 'stage_5_chronic_kidney_disease_untreated_without_anemia_due_to_glomerulonephritis',
                 'stage_5_chronic_kidney_disease_untreated_and_mild_anemia_due_to_glomerulonephritis',
                 'stage_5_chronic_kidney_disease_untreated_and_moderate_anemia_due_to_glomerulonephritis',
                 'stage_5_chronic_kidney_disease_untreated_and_severe_anemia_due_to_glomerulonephritis',
                 'stage_5_chronic_kidney_disease_untreated_without_anemia_due_to_other_causes',
                 'stage_5_chronic_kidney_disease_untreated_and_mild_anemia_due_to_other_causes',
                 'stage_5_chronic_kidney_disease_untreated_and_moderate_anemia_due_to_other_causes',
                 'stage_5_chronic_kidney_disease_untreated_and_severe_anemia_due_to_other_causes',
                 'stage_4_chronic_kidney_disease_untreated_without_anemia_due_to_hypertension',
                 'stage_4_chronic_kidney_disease_untreated_and_mild_anemia_due_to_hypertension',
                 'stage_4_chronic_kidney_disease_untreated_and_moderate_anemia_due_to_hypertension',
                 'stage_4_chronic_kidney_disease_untreated_and_severe_anemia_due_to_hypertension',
                 'stage_4_chronic_kidney_disease_untreated_without_anemia_due_to_glomerulonephritis',
                 'stage_4_chronic_kidney_disease_untreated_and_mild_anemia_due_to_glomerulonephritis',
                 'stage_4_chronic_kidney_disease_untreated_and_moderate_anemia_due_to_glomerulonephritis',
                 'stage_4_chronic_kidney_disease_untreated_and_severe_anemia_due_to_glomerulonephritis',
                 'stage_4_chronic_kidney_disease_untreated_without_anemia_due_to_other_causes',
                 'stage_4_chronic_kidney_disease_untreated_and_mild_anemia_due_to_other_causes',
                 'stage_4_chronic_kidney_disease_untreated_and_moderate_anemia_due_to_other_causes',
                 'stage_4_chronic_kidney_disease_untreated_and_severe_anemia_due_to_other_causes',
                 'skin_disfigurement_due_to_trypanosoma_brucei_gambiense',
                 'sleeping_sickness_due_to_trypanosoma_brucei_gambiense',
                 'sleeping_sickness_due_to_trypanosoma_brucei_rhodesiense',
                 'skin_disfigurement_due_to_trypanosoma_brucei_rhodesiense', 'metastatic_phase_of_other_leukemia',
                 'diagnosis_and_primary_therapy_phase_of_other_leukemia', 'terminal_phase_of_other_leukemia',
                 'controlled_phase_of_other_leukemia', 'drug_susceptible_tuberculosis',
                 'multidrug_resistant_tuberculosis_without_extensive_drug_resistance',
                 'extensively_drug_resistant_tuberculosis', 'acute_zika_infection',
                 'guillain_barre_syndrome_due_to_zika_infection', 'congenital_zika_syndrome',
                 'asymptomatic_zika_infection', 'mild_heart_failure_due_to_myocarditis',
                 'moderate_heart_failure_due_to_myocarditis', 'severe_heart_failure_due_to_myocarditis',
                 'mild_heart_failure_due_to_alcoholic_cardiomyopathy',
                 'moderate_heart_failure_due_to_alcoholic_cardiomyopathy',
                 'severe_heart_failure_due_to_alcoholic_cardiomyopathy',
                 'mild_heart_failure_due_to_other_cardiomyopathy',
                 'moderate_heart_failure_due_to_other_cardiomyopathy',
                 'severe_heart_failure_due_to_other_cardiomyopathy',
                 'disfigurement_level_1_due_to_polydactyly_and_syndactyly',
                 'disfigurement_level_2_due_to_congenital_limb_deficiency',
                 'disfigurement_level_2_with_pain_due_to_congenital_limb_deficiency',
                 'disfigurement_level_2_and_mild_motor_impairment_due_to_congenital_limb_deficiency',
                 'disfigurement_level_2_and_moderate_motor_impairment_due_to_congenital_limb_deficiency',
                 'disfigurement_level_2_with_pain_and_mild_motor_impairment_due_to_congenital_limb_deficiency',
                 'disfigurement_level_2_with_pain_and_moderate_motor_impairment_due_to_congenital_limb_deficiency',
                 'disfigurement_level_2_due_to_other_congenital_musculoskeletal_anomalies',
                 'disfigurement_level_2_with_pain_due_to_other_congenital_musculoskeletal_anomalies',
                 'disfigurement_level_2_and_mild_motor_impairment_due_to_other_congenital_musculoskeletal_anomalies',
                 'disfigurement_level_2_and_moderate_motor_impairment_due_to_other_congenital_musculoskeletal_anomalies',
                 'disfigurement_level_2_with_pain_and_mild_motor_impairment_due_to_other_congenital_musculoskeletal_anomalies',
                 'disfigurement_level_2_with_pain_and_moderate_motor_impairment_due_to_other_congenital_musculoskeletal_anomalies',
                 'asymptomatic_congenital_diaphragmatic_hernia',
                 'chronic_abdominal_pain_due_to_congenital_diaphragmatic_hernia',
                 'disfigurement_due_to_congenital_diaphragmatic_hernia',
                 'mild_chronic_respiratory_problems_and_breathlessness_due_to_congenital_diaphragmatic_hernia',
                 'developmental_delay_or_mild_intellectual_disability_due_to_congenital_diaphragmatic_hernia',
                 'chronic_abdominal_pain_and_disfigurement_due_to_congenital_diaphragmatic_hernia',
                 'chronic_abdominal_pain_and_mild_chronic_respiratory_problems_due_to_congenital_diaphragmatic_hernia',
                 'chronic_abdominal_pain_and_developmental_delay_due_to_congenital_diaphragmatic_hernia',
                 'disfigurement_and_mild_chronic_respiratory_problems_due_to_congenital_diaphragmatic_hernia',
                 'disfigurement_and_developmental_delay_due_to_congenital_diaphragmatic_hernia',
                 '_mild_chronic_respiratory_problems_and_developmental_delay_due_to_congenital_diaphragmatic_hernia',
                 'chronic_abdominal_pain_disfigurement_and_chronic_respiratory_problems_due_to_congenital_diaphragmatic_hernia',
                 'chronic_abdominal_pain_disfigurement_and_developmental_delay_due_to_congenital_diaphragmatic_hernia',
                 'chronic_abdominal_pain_chronic_respiratory_problems_and_developmental_delay_due_to_congenital_diaphragmatic_hernia',
                 'disfigurement_chronic_respiratory_problems_and_developmental_delay_due_to_congenital_diaphragmatic_hernia',
                 'chronic_abdominal_pain_disfigurement_developmental_delay_and_chronic_respiratory_problems_due_to_congenital_diaphragmatic_hernia',
                 'asymptomatic_congenital_atresia_and_or_stenosis_of_the_digestive_tract',
                 'dysphagia_or_acid_reflux_due_to_congenital_atresia_and_or_stenosis_of_the_digestive_tract',
                 'chronic_abdominal_pain_due_to_congenital_atresia_and_or_stenosis_of_the_digestive_tract',
                 'chronic_respiratory_problems_including_difficulty_breaking_and_recurrent_upper_respiratory_infections_due_to_atresia_and_or_stenosis_of_the_digestive_tract',
                 'chronic_respiratory_problems_and_dysphagia_or_acid_reflux_due_to_congenital_atresia_and_or_stenosis_of_the_digestive_tract',
                 'chronic_respiratory_problems_and_abdominal_pain_due_to_congenital_atresia_and_or_stenosis_of_the_digestive_tract',
                 'dysphagia_or_acid_reflux_and_chronic_abdominal_pain_due_to_congenital_atresia_and_or_stenosis_of_the_digestive_tract',
                 'dysphagia_or_acid_reflux_chronic_abdominal_pain_and_chronic_respiratory_problems_due_to_congenital_atresia_and_or_stenosis_of_the_digestive_tract',
                 'asymptomatic_congenital_malformations_of_the_abdominal_wall_after_treatment',
                 'disfigurement_from_scars_following_treatment_for_congenital_malformations_of_the_abdominal_wall',
                 'constipation_due_to_congenital_malformations_of_the_abdominal_wall',
                 'chronic_abdominal_pain_due_to_congenital_malformations_of_the_abdominal_wall',
                 'constipation_and_concern_about_scars_due_to_congenital_malformations_of_the_abdominal_wall',
                 'chronic_abdominal_pain_and_concern_about_scars_due_to_congenital_malformations_of_the_abdominal_wall',
                 'constipation_and_chronic_abdominal_pain_due_to_congenital_malformations_of_the_abdominal_wall',
                 'constipation_chronic_abdominal_pain_and_concern_about_scars_due_to_congenital_malformations_of_the_abdominal_wall',
                 'asymptomatic_other_congenital_malformations_of_the_digestive_tract',
                 'acid_reflux_dyspahgia_and_or_constipation_due_to_other_congenital_malformations_of_the_digestive_tract',
                 'chronic_abdominal_pain_and_or_nausea_due_to_other_congenital_malformations_of_the_digestive_tract',
                 'chronic_abdominal_pain_and_or_nausea_with_acid_reflux_dyspahgia_and_or_constipation_due_to_other_congenital_malformations_of_the_digestive_tract',
                 'asymptomatic_congenital_genital_anomalies',
                 'atypical_genitalia_due_to_congenital_genital_anomalies',
                 'primary_infertility_due_to_congenital_genital_anomalies',
                 'impotence_due_to_congenital_genital_anomalies',
                 'recurrent_urinary_tract_infections_or_other_abdominal_issues_due_to_congenital_genital_anomalies',
                 'atypical_genital_and_recurrent_urinary_tract_infections_and_other_abdominal_issues_due_to_congenital_genital_anomalies',
                 'atypical_genitalia_and_primary_infertility_due_to_congenital_genital_anomalies',
                 'atypical_genitalia_and_impotence_due_to_congenital_genital_anomalies',
                 'primary_infertility_and_recurrent_urinary_tract_infections_or_other_abdominal_issues_due_to_congenital_genital_anomalies',
                 'impotence_and_recurrent_urinary_tract_infections_or_other_abdominal_issues_due_to_congenital_genital_anomalies',
                 'infertility_and_impotence_due_to_congenital_genital_anomalies',
                 'atypical_genitalia_recurrent_urinary_tract_infections_or_other_abdominal_issues_and_infertility_due_to_congenital_genital_anomalies',
                 'atypical_genitalia_recurrent_urinary_tract_infections_or_other_abdominal_issues_and_impotence_due_to_congenital_genital_anomalies',
                 'atypical_genitalia_infertility_and_impotence_due_to_congenital_genital_anomalies',
                 'infertility_impotence_and_recurrent_urinary_tract_infections_or_other_abdominal_issues_and_impotence_due_to_congenital_genital_anomalies',
                 'atypical_genitalia_infertility_impotence_and_recurrent_urinary_tract_infections_or_other_abdominal_issues_and_impotence_due_to_congenital_genital_anomalies',
                 'asymptomatic_ventricular_septal_defect_and_atrial_septal_defect',
                 'asymptomatic_congenital_anomalies_of_the_urinary_tract',
                 'atypical_genitalia_due_to_congenital_anomalies_of_the_urinary_tract',
                 'incontinence_due_to_congenital_anomalies_of_the_urinary_tract',
                 'impotence_due_to_congenital_anomalies_of_the_urinary_tract',
                 'recurrent_urinary_tract_infections_or_other_abdominal_issues_due_to_congenital_anomalies_of_the_urinary_tract',
                 'atypical_genital_and_recurrent_urinary_tract_infections_and_other_abdominal_issues_due_to_congenital_anomalies_of_the_urinary_tract',
                 'atypical_genitalia_and_incontinence_due_to_congenital_anomalies_of_the_urinary_tract',
                 'atypical_genitalia_and_impotence_due_to_congenital_anomalies_of_the_urinary_tract',
                 'incontinence_and_recurrent_urinary_tract_infections_or_other_abdominal_issues_due_to_congenital_anomalies_of_the_urinary_tract',
                 'impotence_and_recurrent_urinary_tract_infections_or_other_abdominal_issues_due_to_congenital_anomalies_of_the_urinary_tract',
                 'incontinence_and_impotence_due_to_congenital_anomalies_of_the_urinary_tract',
                 'atypical_genitalia_recurrent_urinary_tract_infections_or_other_abdominal_issues_and_incontinence_due_to_congenital_anomalies_of_the_urinary_tract',
                 'atypical_genitalia_recurrent_urinary_tract_infections_or_other_abdominal_issues_and_impotence_due_to_congenital_anomalies_of_the_urinary_tract',
                 'atypical_genitalia_incontinence_and_impotence_due_to_congenital_anomalies_of_the_urinary_tract',
                 'incontinence_impotence_and_recurrent_urinary_tract_infections_or_other_abdominal_issues_and_impotence_due_to_congenital_anomalies_of_the_urinary_tract',
                 'atypical_genitalia_incontinence_impotence_and_recurrent_urinary_tract_infections_or_other_abdominal_issues_and_impotence_due_to_congenital_anomalies_of_the_urinary_tract',
                 'severe_motor_and_cognitive_impairment_due_to_edward_syndrome_or_patau_syndrome',
                 'severe_motor_and_cognitive_impairment_with_congenital_heart_disease_due_to_edward_syndrome_or_patau_syndrome',
                 'severe_motor_and_cognitive_impairment_due_to_anencephaly',
                 'asymptomatic_encephalocele_following_treatment',
                 'borderline_intellectual_disability_due_to_encephalocele',
                 'mild_intellectual_disability_due_to_encephalocele',
                 'moderate_intellectual_disability_due_to_encephalocele',
                 'severe_intellectual_disability_due_to_encephalocele',
                 'profound_intellectual_disability_due_to_encephalocele', 'incontinence_due_to_encephalocele',
                 'borderline_intellectual_disability_and_incontinence_due_to_encephalocele',
                 'mild_intellectual_disability_and_incontinence_due_to_encephalocele',
                 'moderate_intellectual_disability_and_incontinence_due_to_encephalocele',
                 'severe_intellectual_disability_and_incontinence_due_to_encephalocele',
                 'profound_intellectual_disability_and_incontinence_due_to_encephalocele',
                 'mild_motor_impairment_due_to_spina_bifida', 'moderate_motor_impairment_due_to_spina_bifida',
                 'severe_motor_impairment_due_to_spina_bifida',
                 'mild_motor_impairment_and_borderline_intellectual_disability_due_to_spina_bifida',
                 'moderate_motor_impairment_and_borderline_intellectual_disability_due_to_spina_bifida',
                 'severe_motor_impairment_and_borderline_intellectual_disability_due_to_spina_bifida',
                 'mild_motor_impairment_and_mild_intellectual_disability_due_to_spina_bifida',
                 'moderate_motor_impairment_and_mild_intellectual_disability_due_to_spina_bifida',
                 'severe_motor_impairment_and_mild_intellectual_disability_due_to_spina_bifida',
                 'mild_motor_impairment_and_moderate_intellectual_disability_due_to_spina_bifida',
                 'moderate_motor_impairment_and_moderate_intellectual_disability_due_to_spina_bifida',
                 'severe_motor_impairment_and_moderate_intellectual_disability_due_to_spina_bifida',
                 'mild_motor_impairment_and_severe_intellectual_disability_due_to_spina_bifida',
                 'moderate_motor_impairment_and_severe_intellectual_disability_due_to_spina_bifida',
                 'severe_motor_impairment_and_severe_intellectual_disability_due_to_spina_bifida',
                 'mild_motor_impairment_borderline_intellectual_disability_and_incontinence_due_to_spina_bifida',
                 'moderate_motor_impairment_borderline_intellectual_disability_and_incontinence_due_to_spina_bifida',
                 'severe_motor_impairment_borderline_intellectual_disability_and_incontinence_due_to_spina_bifida',
                 'mild_motor_impairment_mild_intellectual_disability_and_incontinence_due_to_spina_bifida',
                 'moderate_motor_impairment_mild_intellectual_disability_and_incontinence_due_to_spina_bifida',
                 'severe_motor_impairment_mild_intellectual_disability_and_incontinence_due_to_spina_bifida',
                 'mild_motor_impairment_moderate_intellectual_disability_and_incontinence_due_to_spina_bifida',
                 'moderate_motor_impairment_moderate_intellectual_disability_and_incontinence_due_to_spina_bifida',
                 'severe_motor_impairment_moderate_intellectual_disability_and_incontinence_due_to_spina_bifida',
                 'mild_motor_impairment_severe_intellectual_disability_and_incontinence_due_to_spina_bifida',
                 'moderate_motor_impairment_severe_intellectual_disability_and_incontinence_due_to_spina_bifida',
                 'severe_motor_impairment_severe_intellectual_disability_and_incontinence_due_to_spina_bifida',
                 'mild_motor_impairment_and_incontinence_due_to_spina_bifida',
                 'moderate_motor_impairment_and_incontinence_due_to_spina_bifida',
                 'severe_motor_impairment_and_incontinence_due_to_spina_bifida', 'moderate_wasting_without_edema',
                 'severe_wasting_with_edema', 'mild_disfigurement_due_to_squamous_cell_carcinoma',
                 'moderate_disfigurement_due_to_squamous_cell_carcinoma',
                 'severe_disfigurement_due_to_squamous_cell_carcinoma',
                 'neurological_problems_and_cardiovascular_complications_due_to_adult_tertiary_syphilis',
                 'severe_disfigurement_and_cardiovascular_complications_due_to_adult_tertiary_syphilis',
                 'severe_disfigurement_and_neurological_problems_due_to_adult_tertiary_syphilis',
                 'severe_disfigurement_neurological_problems_and_cardiovascular_complications_due_to_adult_tertiary_syphilis',
                 'mild_motor_impairment_and_profound_intellectual_disability_due_to_spina_bifida',
                 'moderate_motor_impairment_and_profound_intellectual_disability_due_to_spina_bifida',
                 'severe_motor_impairment_and_profound_intellectual_disability_due_to_spina_bifida',
                 'mild_motor_impairment_profound_intellectual_disability_and_incontinence_due_to_spina_bifida',
                 'moderate_motor_impairment_profound_intellectual_disability_and_incontinence_due_to_spina_bifida',
                 'severe_motor_impairment_profound_intellectual_disability_and_incontinence_due_to_spina_bifida',
                 'mild_motor_impairment_due_to_encephalocele', 'moderate_motor_impairment_due_to_encephalocele',
                 'severe_motor_impairment_due_to_encephalocele',
                 'mild_motor_impairment_and_incontinence_due_to_encephalocele',
                 'moderate_motor_impairment_and_incontinence_due_to_encephalocele',
                 'severe_motor_impairment_and_incontinence_due_to_encephalocele',
                 'mild_motor_impairment_and_borderline_intellectual_disability_due_to_encephalocele',
                 'moderate_motor_impairment_and_borderline_intellectual_disability_due_to_encephalocele',
                 'severe_motor_impairment_and_borderline_intellectual_disability_due_to_encephalocele',
                 'mild_motor_impairment_and_mild_intellectual_disability_due_to_encephalocele',
                 'moderate_motor_impairment_and_mild_intellectual_disability_due_to_encephalocele',
                 'severe_motor_impairment_and_mild_intellectual_disability_due_to_encephalocele',
                 'mild_motor_impairment_and_moderate_intellectual_disability_due_to_encephalocele',
                 'moderate_motor_impairment_and_moderate_intellectual_disability_due_to_encephalocele',
                 'severe_motor_impairment_and_moderate_intellectual_disability_due_to_encephalocele',
                 'mild_motor_impairment_and_severe_intellectual_disability_due_to_encephalocele',
                 'moderate_motor_impairment_and_severe_intellectual_disability_due_to_encephalocele',
                 'severe_motor_impairment_and_severe_intellectual_disability_due_to_encephalocele',
                 'mild_motor_impairment_and_profound_intellectual_disability_due_to_encephalocele',
                 'moderate_motor_impairment_and_profound_intellectual_disability_due_to_encephalocele',
                 'severe_motor_impairment_and_profound_intellectual_disability_due_to_encephalocele',
                 'mild_motor_impairment_borderline_intellectual_disability_and_incontinence_due_to_encephalocele',
                 'moderate_motor_impairment_borderline_intellectual_disability_and_incontinence_due_to_encephalocele',
                 'severe_motor_impairment_borderline_intellectual_disability_and_incontinence_due_to_encephalocele',
                 'mild_motor_impairment_mild_intellectual_disability_and_incontinence_due_to_encephalocele',
                 'moderate_motor_impairment_mild_intellectual_disability_and_incontinence_due_to_encephalocele',
                 'severe_motor_impairment_mild_intellectual_disability_and_incontinence_due_to_encephalocele',
                 'mild_motor_impairment_moderate_intellectual_disability_and_incontinence_due_to_encephalocele',
                 'moderate_motor_impairment_moderate_intellectual_disability_and_incontinence_due_to_encephalocele',
                 'severe_motor_impairment_moderate_intellectual_disability_and_incontinence_due_to_encephalocele',
                 'mild_motor_impairment_severe_intellectual_disability_and_incontinence_due_to_encephalocele',
                 'moderate_motor_impairment_severe_intellectual_disability_and_incontinence_due_to_encephalocele',
                 'severe_motor_impairment_severe_intellectual_disability_and_incontinence_due_to_encephalocele',
                 'mild_motor_impairment_profound_intellectual_disability_and_incontinence_due_to_encephalocele',
                 'moderate_motor_impairment_profound_intellectual_disability_and_incontinence_due_to_encephalocele',
                 'severe_motor_impairment_profound_intellectual_disability_and_incontinence_due_to_encephalocele',
                 'asymptomatic_vitamin_a_deficiency', 'latent_tuberculosis_infection',
                 'mild_pain_due_to_guinea_worm_emergence',
                 'mild_symptomatic_episodes_gallbladder_and_biliary_diseases',
                 'moderate_symptomatic_episodes_gallbladder_and_biliary_diseases',
                 'severe_symptomatic_episodes_gallbladder_and_biliary_diseases',
                 'mild_symptomatic_inguinal_femoral_and_abdominal_hernia',
                 'moderate_symptomatic_inguinal_femoral_and_abdominal_hernia',
                 'severe_symptomatic_inguinal_femoral_and_abdominal_hernia', 'asymptomatic_ulcerative_colitis',
                 'asymptomatic_crohns_disease', 'mild_chronic_pancreatitis', 'moderate_chronic_pancreatitis',
                 'severe_chronic_pancreatitis', 'mild_acne_vulgaris', 'moderate_acne_vulgaris',
                 'severe_acne_vulgaris', 'moderate_cellulitis', 'mild_urolithiasis_episodes',
                 'moderate_urolithiasis_episodes', 'severe_urolithiasis_episodes',
                 'congenital_heart_disease_without_intellectual_disability_or_heart_failure_due_to_other_congenital_cardiovascular_anomalies',
                 'congenital_heart_disease_and_borderline_intellectual_disability_without_heart_failure_due_to_other_congenital_cardiovascular_anomalies',
                 'congenital_heart_disease_and_mild_intellectual_disability_without_heart_failure_due_to_other_congenital_cardiovascular_anomalies',
                 'congenital_heart_disease_and_moderate_intellectual_disability_without_heart_failure_due_to_other_congenital_cardiovascular_anomalies',
                 'congenital_heart_disease_and_severe_intellectual_disability_without_heart_failure_due_to_other_congenital_cardiovascular_anomalies',
                 'congenital_heart_disease_and_profound_intellectual_disability_without_heart_failure_due_to_other_congenital_cardiovascular_anomalies',
                 'congenital_heart_disease_without_intellectual_disability_or_heart_failure_due_to_single_ventricle_and_single_ventricle_pathway_heart_defects',
                 'congenital_heart_disease_and_borderline_intellectual_disability_without_heart_failure_due_to_single_ventricle_and_single_ventricle_pathway_heart_defects',
                 'congenital_heart_disease_and_mild_intellectual_disability_without_heart_failure_due_to_single_ventricle_and_single_ventricle_pathway_heart_defects',
                 'congenital_heart_disease_and_moderate_intellectual_disability_without_heart_failure_due_to_single_ventricle_and_single_ventricle_pathway_heart_defects',
                 'congenital_heart_disease_and_severe_intellectual_disability_without_heart_failure_due_to_single_ventricle_and_single_ventricle_pathway_heart_defects',
                 'congenital_heart_disease_and_profound_intellectual_disability_without_heart_failure_due_to_single_ventricle_and_single_ventricle_pathway_heart_defects',
                 'congenital_heart_disease_and_mild_heart_failure_without_intellectual_disability_due_to_single_ventricle_and_single_ventricle_pathway_heart_defects',
                 'congenital_heart_disease_borderline_intellectual_disability_and_mild_heart_failure_due_to_single_ventricle_and_single_ventricle_pathway_heart_defects',
                 'congenital_heart_disease_mild_intellectual_disability_and_mild_heart_failure_due_to_single_ventricle_and_single_ventricle_pathway_heart_defects',
                 'congenital_heart_disease_moderate_intellectual_disability_and_mild_heart_failure_due_to_single_ventricle_and_single_ventricle_pathway_heart_defects',
                 'congenital_heart_disease_severe_intellectual_disability_and_mild_heart_failure_due_to_single_ventricle_and_single_ventricle_pathway_heart_defects',
                 'congenital_heart_disease_profound_intellectual_disability_and_mild_heart_failure_due_to_single_ventricle_and_single_ventricle_pathway_heart_defects',
                 'congenital_heart_disease_and_moderate_heart_failure_without_intellectual_disability_due_to_single_ventricle_and_single_ventricle_pathway_heart_defects',
                 'congenital_heart_disease_borderline_intellectual_disability_and_moderate_heart_failure_due_to_single_ventricle_and_single_ventricle_pathway_heart_defects',
                 'congenital_heart_disease_mild_intellectual_disability_and_moderate_heart_failure_due_to_single_ventricle_and_single_ventricle_pathway_heart_defects',
                 'congenital_heart_disease_moderate_intellectual_disability_and_moderate_heart_failure_due_to_single_ventricle_and_single_ventricle_pathway_heart_defects',
                 'congenital_heart_disease_severe_intellectual_disability_and_moderate_heart_failure_due_to_single_ventricle_and_single_ventricle_pathway_heart_defects',
                 'congenital_heart_disease_profound_intellectual_disability_and_moderate_heart_failure_due_to_single_ventricle_and_single_ventricle_pathway_heart_defects',
                 'congenital_heart_disease_and_severe_heart_failure_without_intellectual_disability_due_to_single_ventricle_and_single_ventricle_pathway_heart_defects',
                 'congenital_heart_disease_borderline_intellectual_disability_and_severe_heart_failure_due_to_single_ventricle_and_single_ventricle_pathway_heart_defects',
                 'congenital_heart_disease_mild_intellectual_disability_and_severe_heart_failure_due_to_single_ventricle_and_single_ventricle_pathway_heart_defects',
                 'congenital_heart_disease_moderate_intellectual_disability_and_severe_heart_failure_due_to_single_ventricle_and_single_ventricle_pathway_heart_defects',
                 'congenital_heart_disease_severe_intellectual_disability_and_severe_heart_failure_due_to_single_ventricle_and_single_ventricle_pathway_heart_defects',
                 'congenital_heart_disease_profound_intellectual_disability_and_severe_heart_failure_due_to_single_ventricle_and_single_ventricle_pathway_heart_defects',
                 'congenital_heart_disease_without_intellectual_disability_or_heart_failure_due_to_severe_congenital_heart_anomalies_excluding_single_ventricle_heart_defects',
                 'congenital_heart_disease_and_borderline_intellectual_disability_without_heart_failure_due_to_severe_congenital_heart_anomalies_excluding_single_ventricle_heart_defects',
                 'congenital_heart_disease_and_mild_intellectual_disability_without_heart_failure_due_to_severe_congenital_heart_anomalies_excluding_single_ventricle_heart_defects',
                 'congenital_heart_disease_and_moderate_intellectual_disability_without_heart_failure_due_to_severe_congenital_heart_anomalies_excluding_single_ventricle_heart_defects',
                 'congenital_heart_disease_and_severe_intellectual_disability_without_heart_failure_due_to_severe_congenital_heart_anomalies_excluding_single_ventricle_heart_defects',
                 'congenital_heart_disease_and_profound_intellectual_disability_without_heart_failure_due_to_severe_congenital_heart_anomalies_excluding_single_ventricle_heart_defects',
                 'congenital_heart_disease_and_mild_heart_failure_without_intellectual_disability_due_to_severe_congenital_heart_anomalies_excluding_single_ventricle_heart_defects',
                 'congenital_heart_disease_borderline_intellectual_disability_and_mild_heart_failure_due_to_severe_congenital_heart_anomalies_excluding_single_ventricle_heart_defects',
                 'congenital_heart_disease_mild_intellectual_disability_and_mild_heart_failure_due_to_severe_congenital_heart_anomalies_excluding_single_ventricle_heart_defects',
                 'congenital_heart_disease_moderate_intellectual_disability_and_mild_heart_failure_due_to_severe_congenital_heart_anomalies_excluding_single_ventricle_heart_defects',
                 'congenital_heart_disease_severe_intellectual_disability_and_mild_heart_failure_due_to_severe_congenital_heart_anomalies_excluding_single_ventricle_heart_defects',
                 'congenital_heart_disease_profound_intellectual_disability_and_mild_heart_failure_due_to_severe_congenital_heart_anomalies_excluding_single_ventricle_heart_defects',
                 'congenital_heart_disease_and_moderate_heart_failure_without_intellectual_disability_due_to_severe_congenital_heart_anomalies_excluding_single_ventricle_heart_defects',
                 'congenital_heart_disease_borderline_intellectual_disability_and_moderate_heart_failure_due_to_severe_congenital_heart_anomalies_excluding_single_ventricle_heart_defects',
                 'congenital_heart_disease_mild_intellectual_disability_and_moderate_heart_failure_due_to_severe_congenital_heart_anomalies_excluding_single_ventricle_heart_defects',
                 'congenital_heart_disease_moderate_intellectual_disability_and_moderate_heart_failure_due_to_severe_congenital_heart_anomalies_excluding_single_ventricle_heart_defects',
                 'congenital_heart_disease_severe_intellectual_disability_and_moderate_heart_failure_due_to_severe_congenital_heart_anomalies_excluding_single_ventricle_heart_defects',
                 'congenital_heart_disease_profound_intellectual_disability_and_moderate_heart_failure_due_to_severe_congenital_heart_anomalies_excluding_single_ventricle_heart_defects',
                 'congenital_heart_disease_and_severe_heart_failure_without_intellectual_disability_due_to_severe_congenital_heart_anomalies_excluding_single_ventricle_heart_defects',
                 'congenital_heart_disease_borderline_intellectual_disability_and_severe_heart_failure_due_to_severe_congenital_heart_anomalies_excluding_single_ventricle_heart_defects',
                 'congenital_heart_disease_mild_intellectual_disability_and_severe_heart_failure_due_to_severe_congenital_heart_anomalies_excluding_single_ventricle_heart_defects',
                 'congenital_heart_disease_moderate_intellectual_disability_and_severe_heart_failure_due_to_severe_congenital_heart_anomalies_excluding_single_ventricle_heart_defects',
                 'congenital_heart_disease_severe_intellectual_disability_and_severe_heart_failure_due_to_severe_congenital_heart_anomalies_excluding_single_ventricle_heart_defects',
                 'congenital_heart_disease_profound_intellectual_disability_and_severe_heart_failure_due_to_severe_congenital_heart_anomalies_excluding_single_ventricle_heart_defects',
                 'congenital_heart_disease_without_heart_failure_or_intellectual_disability_due_to_critical_malformations_of_great_vessels_congenital_valvular_heart_disease_and_patent_ductus_arteriosus',
                 'congenital_heart_disease_and_borderline_intellectual_disability_without_heart_failure_due_to_critical_malformations_of_great_vessels_congenital_valvular_heart_disease_and_patent_ductus_arteriosus',
                 'congenital_heart_disease_and_mild_intellectual_disability_without_heart_failure_due_to_critical_malformations_of_great_vessels_congenital_valvular_heart_disease_and_patent_ductus_arteriosus',
                 'congenital_heart_disease_and_moderate_intellectual_disability_without_heart_failure_due_to_critical_malformations_of_great_vessels_congenital_valvular_heart_disease_and_patent_ductus_arteriosus',
                 'congenital_heart_disease_and_severe_intellectual_disability_without_heart_failure_due_to_critical_malformations_of_great_vessels_congenital_valvular_heart_disease_and_patent_ductus_arteriosus',
                 'congenital_heart_disease_and_profound_intellectual_disability_without_heart_failure_due_to_critical_malformations_of_great_vessels_congenital_valvular_heart_disease_and_patent_ductus_arteriosus',
                 'congenital_heart_disease_and_mild_heart_failure_without_intellectual_disability_due_to_critical_malformations_of_great_vessels_congenital_valvular_heart_disease_and_patent_ductus_arteriosus',
                 'congenital_heart_disease_borderline_intellectual_disability_and_mild_heart_failure_due_to_critical_malformations_of_great_vessels_congenital_valvular_heart_disease_and_patent_ductus_arteriosus',
                 'congenital_heart_disease_mild_intellectual_disability_and_mild_heart_failure_due_to_critical_malformations_of_great_vessels_congenital_valvular_heart_disease_and_patent_ductus_arteriosus',
                 'congenital_heart_disease_moderate_intellectual_disability_and_mild_heart_failure_due_to_critical_malformations_of_great_vessels_congenital_valvular_heart_disease_and_patent_ductus_arteriosus',
                 'congenital_heart_disease_severe_intellectual_disability_and_mild_heart_failure_due_to_critical_malformations_of_great_vessels_congenital_valvular_heart_disease_and_patent_ductus_arteriosus',
                 'congenital_heart_disease_profound_intellectual_disability_and_mild_heart_failure_due_to_critical_malformations_of_great_vessels_congenital_valvular_heart_disease_and_patent_ductus_arteriosus',
                 'congenital_heart_disease_and_moderate_heart_failure_without_intellectual_disability_due_to_critical_malformations_of_great_vessels_congenital_valvular_heart_disease_and_patent_ductus_arteriosus',
                 'congenital_heart_disease_borderline_intellectual_disability_and_moderate_heart_failure_due_to_critical_malformations_of_great_vessels_congenital_valvular_heart_disease_and_patent_ductus_arteriosus',
                 'congenital_heart_disease_mild_intellectual_disability_and_moderate_heart_failure_due_to_critical_malformations_of_great_vessels_congenital_valvular_heart_disease_and_patent_ductus_arteriosus',
                 'congenital_heart_disease_moderate_intellectual_disability_and_moderate_heart_failure_due_to_critical_malformations_of_great_vessels_congenital_valvular_heart_disease_and_patent_ductus_arteriosus',
                 'congenital_heart_disease_severe_intellectual_disability_and_moderate_heart_failure_due_to_critical_malformations_of_great_vessels_congenital_valvular_heart_disease_and_patent_ductus_arteriosus',
                 'congenital_heart_disease_profound_intellectual_disability_and_moderate_heart_failure_due_to_critical_malformations_of_great_vessels_congenital_valvular_heart_disease_and_patent_ductus_arteriosus',
                 'congenital_heart_disease_and_severe_heart_failure_without_intellectual_disability_due_to_critical_malformations_of_great_vessels_congenital_valvular_heart_disease_and_patent_ductus_arteriosus',
                 'congenital_heart_disease_borderline_intellectual_disability_and_severe_heart_failure_due_to_critical_malformations_of_great_vessels_congenital_valvular_heart_disease_and_patent_ductus_arteriosus',
                 'congenital_heart_disease_mild_intellectual_disability_and_severe_heart_failure_due_to_critical_malformations_of_great_vessels_congenital_valvular_heart_disease_and_patent_ductus_arteriosus',
                 'congenital_heart_disease_moderate_intellectual_disability_and_severe_heart_failure_due_to_critical_malformations_of_great_vessels_congenital_valvular_heart_disease_and_patent_ductus_arteriosus',
                 'congenital_heart_disease_severe_intellectual_disability_and_severe_heart_failure_due_to_critical_malformations_of_great_vessels_congenital_valvular_heart_disease_and_patent_ductus_arteriosus',
                 'congenital_heart_disease_profound_intellectual_disability_and_severe_heart_failure_due_to_critical_malformations_of_great_vessels_congenital_valvular_heart_disease_and_patent_ductus_arteriosus',
                 'congenital_heart_disease_without_heart_failure_or_intellectual_disability_due_to_ventricular_septal_defect_and_atrial_septal_defect',
                 'congenital_heart_disease_and_borderline_intellectual_disability_without_heart_failure_due_to_ventricular_septal_defect_and_atrial_septal_defect',
                 'congenital_heart_disease_and_mild_intellectual_disability_without_heart_failure_due_to_ventricular_septal_defect_and_atrial_septal_defect',
                 'congenital_heart_disease_and_moderate_intellectual_disability_without_heart_failure_due_to_ventricular_septal_defect_and_atrial_septal_defect',
                 'congenital_heart_disease_and_severe_intellectual_disability_without_heart_failure_due_to_ventricular_septal_defect_and_atrial_septal_defect',
                 'congenital_heart_disease_and_profound_intellectual_disability_without_heart_failure_due_to_ventricular_septal_defect_and_atrial_septal_defect',
                 'congenital_heart_disease_and_mild_heart_failure_without_intellectual_disability_due_to_ventricular_septal_defect_and_atrial_septal_defect',
                 'congenital_heart_disease_borderline_intellectual_disability_and_mild_heart_failure_due_to_ventricular_septal_defect_and_atrial_septal_defect',
                 'congenital_heart_disease_mild_intellectual_disability_and_mild_heart_failure_due_to_ventricular_septal_defect_and_atrial_septal_defect',
                 'congenital_heart_disease_moderate_intellectual_disability_and_mild_heart_failure_due_to_ventricular_septal_defect_and_atrial_septal_defect',
                 'congenital_heart_disease_severe_intellectual_disability_and_mild_heart_failure_due_to_ventricular_septal_defect_and_atrial_septal_defect',
                 'congenital_heart_disease_profound_intellectual_disability_and_mild_heart_failure_due_to_ventricular_septal_defect_and_atrial_septal_defect',
                 'congenital_heart_disease_and_moderate_heart_failure_without_intellectual_disability_due_to_ventricular_septal_defect_and_atrial_septal_defect',
                 'congenital_heart_disease_borderline_intellectual_disability_and_moderate_heart_failure_due_to_ventricular_septal_defect_and_atrial_septal_defect',
                 'congenital_heart_disease_mild_intellectual_disability_and_moderate_heart_failure_due_to_ventricular_septal_defect_and_atrial_septal_defect',
                 'congenital_heart_disease_moderate_intellectual_disability_and_moderate_heart_failure_due_to_ventricular_septal_defect_and_atrial_septal_defect',
                 'congenital_heart_disease_severe_intellectual_disability_and_moderate_heart_failure_due_to_ventricular_septal_defect_and_atrial_septal_defect',
                 'congenital_heart_disease_profound_intellectual_disability_and_moderate_heart_failure_due_to_ventricular_septal_defect_and_atrial_septal_defect',
                 'congenital_heart_disease_and_severe_heart_without_intellectual_disability_due_to_ventricular_septal_defect_and_atrial_septal_defect',
                 'congenital_heart_disease_borderline_intellectual_disability_and_severe_heart_failure_due_to_ventricular_septal_defect_and_atrial_septal_defect',
                 'congenital_heart_disease_mild_intellectual_disability_and_severe_heart_failure_due_to_ventricular_septal_defect_and_atrial_septal_defect',
                 'congenital_heart_disease_moderate_intellectual_disability_and_severe_heart_failure_due_to_ventricular_septal_defect_and_atrial_septal_defect',
                 'congenital_heart_disease_severe_intellectual_disability_and_severe_heart_failure_due_to_ventricular_septal_defect_and_atrial_septal_defect',
                 'congenital_heart_disease_profound_intellectual_disability_and_severe_heart_failure_due_to_ventricular_septal_defect_and_atrial_septal_defect',
                 'acute_adenolymphangitis_due_to_lymphatic_filariasis', 'asymptomatic_multiple_sclerosis',
                 'mildly_symptomatic_pud_with_mild_anemia', 'moderately_symptomatic_pud_with_mild_anemia',
                 'mildly_symptomatic_pud_with_moderate_anemia', 'moderately_symptomatic_pud_with_moderate_anemia',
                 'mildly_symptomatic_pud_with_severe_anemia', 'moderately_symptomatic_pud_with_severe_anemia',
                 'mildly_symptomatic_pud_with_no_anemia', 'moderately_symptomatic_pud_with_no_anemia',
                 'asymptomatic_pud_with_mild_anemia', 'asymptomatic_pud_with_moderate_anemia',
                 'asymptomatic_pud_with_severe_anemia', 'mildy_symptomatic_gastritis_duodenitis_with_mild_anemia',
                 'moderately_symptomatic_gastritis_duodenitis_with_mild_anemia',
                 'mildly_symptomatic_gastritis_duodenitis_with_moderate_anemia',
                 'moderately_symptomatic_gastritis_duodenitis_with_moderate_anemia',
                 'mildy_symptomatic_gastritis_duodenitis_with_severe_anemia',
                 'moderately_symptomatic_gastritis_duodenitis_with_severe_anemia',
                 'mildly_symptomatic_gastritis_duodenitis_with_no_anemia',
                 'moderately_symptomatic_gastritis_duodenitis_with_no_anemia',
                 'asymptomatic_gastritis_duodenitis_with_mild_anemia',
                 'asymptomatic_gastritis_duodenitis_with_moderate_anemia',
                 'asymptomatic_gastritis_duodenitis_with_severe_anemia', 'severe_malaria_with_mild_anemia',
                 'severe_malaria_with_moderate_anemia', 'severe_malaria_with_severe_anemia',
                 'mild_malaria_with_mild_anemia', 'mild_malaria_with_moderate_anemia',
                 'mild_malaria_with_severe_anemia', 'moderate_malaria_with_mild_anemia',
                 'moderate_malaria_with_moderate_anemia', 'moderate_malaria_with_severe_anemia',
                 'asymptomatic_pud_with_no_anemia', 'asymptomatic_gastritis_duodenitis_with_no_anemia',
                 'early_hiv_with_mild_anemia', 'early_hiv_with_moderate_anemia', 'early_hiv_with_severe_anemia',
                 'early_hiv_without_anemia', 'symptomatic_hiv_with_mild_anemia',
                 'symptomatic_hiv_with_moderate_anemia', 'symptomatic_hiv_with_severe_anemia',
                 'symptomatic_hiv_without_anemia', 'hiv_aids_with_antiretroviral_treatment_with_mild_anemia',
                 'hiv_aids_with_antiretroviral_treatment_with_moderate_anemia',
                 'hiv_aids_with_antiretroviral_treatment_with_severe_anemia',
                 'hiv_aids_with_antiretroviral_treatment_without_anemia', 'aids_with_mild_anemia',
                 'aids_with_moderate_anemia', 'aids_with_severe_anemia', 'aids_without_anemia',
                 'hiv_aids_drug_susceptible_tuberculosis_with_mild_anemia',
                 'hiv_aids_drug_susceptible_tuberculosis_with_moderate_anemia',
                 'hiv_aids_drug_susceptible_tuberculosis_with_severe_anemia',
                 'hiv_aids_drug_susceptible_tuberculosis_without_anemia',
                 'hiv_aids_multidrug_resistant_tuberculosis_without_extensive_drug_resistance_with_mild_anemia',
                 'hiv_aids_multidrug_resistant_tuberculosis_without_extensive_drug_resistance_with_moderate_anemia',
                 'hiv_aids_multidrug_resistant_tuberculosis_without_extensive_drug_resistance_with_severe_anemia',
                 'hiv_aids_multidrug_resistant_tuberculosis_without_extensive_drug_resistance_without_anemia',
                 'hiv_aids_extensively_drug_resistant_tuberculosis_with_mild_anemia',
                 'hiv_aids_extensively_drug_resistant_tuberculosis_with_moderate_anemia',
                 'hiv_aids_extensively_drug_resistant_tuberculosis_with_severe_anemia',
                 'hiv_aids_extensively_drug_resistant_tuberculosis_without_anemia',
                 'cirrhosis_and_other_chronic_liver_diseases_due_to_hepatitis_b_compensated',
                 'cirrhosis_and_other_chronic_liver_diseases_due_to_hepatitis_c_compensated',
                 'cirrhosis_and_other_chronic_liver_diseases_due_to_alcohol_compensated',
                 'cirrhosis_and_other_chronic_liver_diseases_due_to_other_cause_compensated',
                 'severe_disfigurement_due_to_adult_tertiary_syphilis',
                 'neurological_problems_due_to_adult_tertiary_syphilis',
                 'cardiovascular_complications_due_to_adult_tertiary_syphilis',
                 'asymptomatic_adult_tertiary_syphilis', 'other_infectious_diseases',
                 'other_congenital_birth_defects', 'ectopic_pregnancy',
                 'acute_subarachnoid_hemorrhage_severity_level_1', 'acute_subarachnoid_hemorrhage_severity_level_2',
                 'acute_subarachnoid_hemorrhage_severity_level_3', 'acute_subarachnoid_hemorrhage_severity_level_4',
                 'acute_subarachnoid_hemorrhage_severity_level_5', 'asymptomatic_chronic_subarachnoid_hemorrhage',
                 'chronic_subarachnoid_hemorrhage_severity_level_1',
                 'chronic_subarachnoid_hemorrhage_severity_level_2',
                 'chronic_subarachnoid_hemorrhage_severity_level_3',
                 'chronic_subarachnoid_hemorrhage_severity_level_4',
                 'chronic_subarachnoid_hemorrhage_severity_level_5',
                 'end_stage_renal_disease_after_transplant_due_to_type_1_diabetes_mellitus',
                 'end_stage_renal_disease_after_transplant_due_to_type_2_diabetes_mellitus',
                 'stage_3_chronic_kidney_disease_and_severe_anemia_due_to_type_1_diabetes_mellitus',
                 'stage_3_chronic_kidney_disease_and_severe_anemia_due_to_type_2_diabetes_mellitus',
                 'stage_3_chronic_kidney_disease_and_moderate_anemia_due_to_type_1_diabetes_mellitus',
                 'stage_3_chronic_kidney_disease_and_moderate_anemia_due_to_type_2_diabetes_mellitus',
                 'stage_3_chronic_kidney_disease_and_mild_anemia_due_to_type_1_diabetes_mellitus',
                 'stage_3_chronic_kidney_disease_and_mild_anemia_due_to_type_2_diabetes_mellitus',
                 'stage_3_chronic_kidney_disease_without_anemia_due_to_type_1_diabetes_mellitus',
                 'stage_3_chronic_kidney_disease_without_anemia_due_to_type_2_diabetes_mellitus',
                 'stage_4_chronic_kidney_disease_untreated_and_severe_anemia_due_to_type_1_diabetes_mellitus',
                 'stage_4_chronic_kidney_disease_untreated_and_severe_anemia_due_to_type_2_diabetes_mellitus',
                 'stage_4_chronic_kidney_disease_untreated_and_moderate_anemia_due_to_type_1_diabetes_mellitus',
                 'stage_4_chronic_kidney_disease_untreated_and_moderate_anemia_due_to_type_2_diabetes_mellitus',
                 'stage_4_chronic_kidney_disease_untreated_and_mild_anemia_due_to_type_1_diabetes_mellitus',
                 'stage_4_chronic_kidney_disease_untreated_and_mild_anemia_due_to_type_2_diabetes_mellitus',
                 'stage_4_chronic_kidney_disease_untreated_without_anemia_due_to_type_1_diabetes_mellitus',
                 'stage_4_chronic_kidney_disease_untreated_without_anemia_due_to_type_2_diabetes_mellitus',
                 'stage_5_chronic_kidney_disease_untreated_and_severe_anemia_due_to_type_1_diabetes_mellitus',
                 'stage_5_chronic_kidney_disease_untreated_and_severe_anemia_due_to_type_2_diabetes_mellitus',
                 'stage_5_chronic_kidney_disease_untreated_and_moderate_anemia_due_to_type_1_diabetes_mellitus',
                 'stage_5_chronic_kidney_disease_untreated_and_moderate_anemia_due_to_type_2_diabetes_mellitus',
                 'stage_5_chronic_kidney_disease_untreated_and_mild_anemia_due_to_type_1_diabetes_mellitus',
                 'stage_5_chronic_kidney_disease_untreated_and_mild_anemia_due_to_type_2_diabetes_mellitus',
                 'stage_5_chronic_kidney_disease_untreated_without_anemia_due_to_type_1_diabetes_mellitus',
                 'stage_5_chronic_kidney_disease_untreated_without_anemia_due_to_type_2_diabetes_mellitus',
                 'calcific_aortic_valve_disease_after_valve_intervention',
                 'asymptomatic_calcific_aortic_valve_disease',
                 'mild_heart_failure_due_to_calcific_aortic_valve_disease',
                 'moderate_heart_failure_due_to_calcific_aortic_valve_disease',
                 'severe_heart_failure_due_to_calcific_aortic_valve_disease',
                 'degenerative_mitral_valve_disease_after_valve_intervention',
                 'asymptomatic_degenerative_mitral_valve_disease',
                 'mild_heart_failure_due_to_degenerative_mitral_valve_disease',
                 'moderate_heart_failure_due_to_degenerative_mitral_valve_disease',
                 'severe_heart_failure_due_to_degenerative_mitral_valve_disease',
                 'mild_heart_failure_due_to_other_non_rheumatic_valve_disease',
                 'moderate_heart_failure_due_to_other_non_rheumatic_valve_disease',
                 'severe_heart_failure_due_to_other_non_rheumatic_valve_disease',
                 'cirrhosis_and_other_chronic_liver_diseases_due_to_nash_compensated',
                 'vitamin_a_deficiency_with_mild_anemia', 'vitamin_a_deficiency_with_moderate_anemia',
                 'vitamin_a_deficiency_with_severe_anemia',
                 'myelodysplastic_myeloproliferative_and_other_hematopoietic_neoplasms',
                 'benign_and_in_situ_intestinal_neoplasms', 'benign_and_in_situ_cervical_and_uterine_neoplasms',
                 'other_benign_and_in_situ_neoplasms',
                 'diagnosis_and_primary_therapy_phase_of_liver_cancer_due_to_nash',
                 'controlled_phase_of_liver_cancer_due_to_nash', 'metastatic_phase_of_liver_cancer_due_to_nash',
                 'terminal_phase_of_liver_cancer_due_to_nash',
                 'diabetic_foot_due_to_neuropathy_due_to_diabetes_mellitus_type_1',
                 'diabetic_neuropathy_due_to_diabetes_mellitus_type_1_without_diabetic_foot_or_amputation',
                 'diabetic_neuropathy_and_amputation_with_treatment_due_to_diabetes_mellitus_type_1',
                 'diabetic_neuropathy_and_amputation_without_treatment_due_to_diabetes_mellitus_type_1',
                 'uncomplicated_diabetes_mellitus_type_1',
                 'moderate_vision_impairment_due_to_diabetes_mellitus_type_1_retinopathy',
                 'severe_vision_impairment_due_to_diabetes_mellitus_type_1_retinopathy',
                 'blindness_due_to_diabetes_mellitus_type_1_retinopathy',
                 'diabetic_foot_due_to_neuropathy_due_to_diabetes_mellitus_type_2',
                 'diabetic_neuropathy_due_to_diabetes_mellitus_type_2_without_diabetic_foot_or_amputation',
                 'diabetic_neuropathy_and_amputation_with_treatment_due_to_diabetes_mellitus_type_2',
                 'diabetic_neuropathy_and_amputation_without_treatment_due_to_diabetes_mellitus_type_2',
                 'uncomplicated_diabetes_mellitus_type_2',
                 'moderate_vision_impairment_due_to_diabetes_mellitus_type_2_retinopathy',
                 'severe_vision_impairment_due_to_diabetes_mellitus_type_2_retinopathy',
                 'blindness_due_to_diabetes_mellitus_type_2_retinopathy',
                 'non_alcoholic_fatty_liver_disease_nafld_non_alcoholic_steatohepatitis_nash', 'near_vision_loss',
                 'controlled_phase_of_breast_cancer_with_mastectomy',
                 'controlled_phase_of_breast_cancer_without_mastectomy',
                 'mastectomy_from_breast_cancer_beyond_ten_years',
                 'controlled_phase_of_prostate_cancer_with_impotence',
                 'controlled_phase_of_prostate_cancer_with_incontinence',
                 'controlled_phase_of_prostate_cancer_without_impotence_or_incontinence',
                 'impotence_from_prostate_cancer_beyond_ten_years',
                 'incontinence_from_prostate_cancer_beyond_ten_years',
                 'controlled_phase_of_larynx_cancer_with_laryngectomy',
                 'controlled_phase_of_larynx_cancer_without_laryngectomy',
                 'laryngectomy_from_larynx_cancer_beyond_ten_years',
                 'controlled_phase_of_colon_and_rectum_cancers_with_stoma',
                 'controlled_phase_of_colon_and_rectum_cancers_without_stoma',
                 'stoma_from_colon_and_rectum_cancers_beyond_ten_years',
                 'controlled_phase_of_bladder_cancer_with_incontinence',
                 'controlled_phase_of_bladder_cancer_without_incontinence',
                 'incontinence_from_bladder_cancer_beyond_ten_years',
                 'moderate_pain_and_limited_mobility_due_to_guinea_worm',
                 'stage_1_2_chronic_kidney_disease_with_preserved_gfr_due_to_type_1_diabetes_mellitus',
                 'stage_1_2_chronic_kidney_disease_with_preserved_gfr_due_to_type_2_diabetes_mellitus',
                 'stage_1_2_chronic_kidney_disease_with_preserved_gfr_due_to_hypertension',
                 'stage_1_2_chronic_kidney_disease_with_preserved_gfr_due_to_glomerulonephritis',
                 'stage_1_2_chronic_kidney_disease_with_preserved_gfr_due_to_other_causes', 'severe_acute_ints',
                 'menstrual_disorders_without_anemia', 'ulcerative_colitis_with_mild_anemia',
                 'ulcerative_colitis_with_moderate_anemia', 'ulcerative_colitis_with_severe_anemia',
                 'ulcerative_colitis_without_anemia', 'crohns_disease_with_mild_anemia',
                 'crohns_disease_with_moderate_anemia', 'crohns_disease_with_severe_anemia',
                 'crohns_disease_without_anemia', 'mild_anemia_due_to_malaria_vivax_pvpr',
                 'moderate_anemia_due_to_malaria_vivax_pvpr', 'severe_anemia_due_to_malaria_vivax_pvpr',
                 'asymptomatic_malaria_vivax_pvpr', 'non_disabling_symptomatic_acne', 'acute_pancreatitis',
                 'complicated_pud_with_no_anemia', 'complicated_pud_with_mild_anemia',
                 'complicated_pud_with_moderate_anemia', 'complicated_pud_with_severe_anemia',
                 'complicated_gastritis_duodenitis_with_no_anemia',
                 'complicated_gastritis_duodenitis_with_mild_anemia',
                 'complicated_gastritis_duodenitis_with_moderate_anemia',
                 'complicated_gastritis_duodenitis_with_severe_anemia',
                 'controlled_medically_managed_heart_failure_due_ischemic_heart_disease',
                 'controlled_medically_managed_heart_failure_due_to_alcoholic_cardiomyopathy',
                 'controlled_medically_managed_heart_failure_due_to_calcific_aortic_valve_disease',
                 'controlled_medically_managed_heart_failure_due_to_chagas_disease',
                 'controlled_medically_managed_heart_failure_due_to_degenerative_mitral_valve_disease',
                 'controlled_medically_managed_heart_failure_due_to_endocarditis',
                 'controlled_medically_managed_heart_failure_due_to_endocrine_metabolic_blood_and_immune_disorders',
                 'controlled_medically_managed_heart_failure_due_to_g6pd_deficiency',
                 'controlled_medically_managed_heart_failure_due_to_hypertensive_heart_disease',
                 'controlled_medically_managed_heart_failure_due_to_myocarditis',
                 'controlled_medically_managed_heart_failure_due_to_other_cardiomyopathy',
                 'controlled_medically_managed_heart_failure_due_to_other_cardiovascular_disease',
                 'controlled_medically_managed_heart_failure_due_to_other_hemoglobinopathies_and_hemolytic_anemias',
                 'controlled_medically_managed_heart_failure_due_to_other_non_rheumatic_valve_disease',
                 'controlled_medically_managed_heart_failure_due_to_rheumatic_heart_disease',
                 'controlled_medically_managed_heart_failure_due_to_severe_asbestosis',
                 'controlled_medically_managed_heart_failure_due_to_severe_chronic_obstructive_pulmonary_disease',
                 'controlled_medically_managed_heart_failure_due_to_severe_coal_workers_pneumoconiosis',
                 'controlled_medically_managed_heart_failure_due_to_severe_interstitial_lung_disease_and_pulmonary_sarcoidosis',
                 'controlled_medically_managed_heart_failure_due_to_severe_other_pneumoconiosis',
                 'controlled_medically_managed_heart_failure_due_to_severe_silicosis',
                 'controlled_medically_managed_heart_failure_due_to_thalassemias',
                 'congenital_heart_disease_and_controlled_medically_managed_heart_failure_without_intellectual_disability_due_to_critical_malformations_of_great_vessels_congenital_valvular_heart_disease_and_patent_ductus_arteriosus',
                 'congenital_heart_disease_and_controlled_medically_managed_heart_failure_without_intellectual_disability_due_to_severe_congenital_heart_anomalies_excluding_single_ventricle_heart_defects',
                 'congenital_heart_disease_and_controlled_medically_managed_heart_failure_without_intellectual_disability_due_to_single_ventricle_and_single_ventricle_pathway_heart_defects',
                 'congenital_heart_disease_and_controlled_medically_managed_heart_failure_without_intellectual_disability_due_to_ventricular_septal_defect_and_atrial_septal_defect',
                 'congenital_heart_disease_borderline_intellectual_disability_and_controlled_medically_managed_heart_failure_due_to_critical_malformations_of_great_vessels_congenital_valvular_heart_disease_and_patent_ductus_arteriosus',
                 'congenital_heart_disease_borderline_intellectual_disability_and_controlled_medically_managed_heart_failure_due_to_severe_congenital_heart_anomalies_excluding_single_ventricle_heart_defects',
                 'congenital_heart_disease_borderline_intellectual_disability_and_controlled_medically_managed_heart_failure_due_to_single_ventricle_and_single_ventricle_pathway_heart_defects',
                 'congenital_heart_disease_borderline_intellectual_disability_and_controlled_medically_managed_heart_failure_due_to_ventricular_septal_defect_and_atrial_septal_defect',
                 'congenital_heart_disease_mild_intellectual_disability_and_controlled_medically_managed_heart_failure_due_to_critical_malformations_of_great_vessels_congenital_valvular_heart_disease_and_patent_ductus_arteriosus',
                 'congenital_heart_disease_mild_intellectual_disability_and_controlled_medically_managed_heart_failure_due_to_severe_congenital_heart_anomalies_excluding_single_ventricle_heart_defects',
                 'congenital_heart_disease_mild_intellectual_disability_and_controlled_medically_managed_heart_failure_due_to_single_ventricle_and_single_ventricle_pathway_heart_defects',
                 'congenital_heart_disease_mild_intellectual_disability_and_controlled_medically_managed_heart_failure_due_to_ventricular_septal_defect_and_atrial_septal_defect',
                 'congenital_heart_disease_moderate_intellectual_disability_and_controlled_medically_managed_heart_failure_due_to_critical_malformations_of_great_vessels_congenital_valvular_heart_disease_and_patent_ductus_arteriosus',
                 'congenital_heart_disease_moderate_intellectual_disability_and_controlled_medically_managed_heart_failure_due_to_severe_congenital_heart_anomalies_excluding_single_ventricle_heart_defects',
                 'congenital_heart_disease_moderate_intellectual_disability_and_controlled_medically_managed_heart_failure_due_to_single_ventricle_and_single_ventricle_pathway_heart_defects',
                 'congenital_heart_disease_moderate_intellectual_disability_and_controlled_medically_managed_heart_failure_due_to_ventricular_septal_defect_and_atrial_septal_defect',
                 'congenital_heart_disease_profound_intellectual_disability_and_controlled_medically_managed_heart_failure_due_to_severe_congenital_heart_anomalies_excluding_single_ventricle_heart_defects',
                 'congenital_heart_disease_profound_intellectual_disability_and_controlled_medically_managed_heart_failure_due_to_single_ventricle_and_single_ventricle_pathway_heart_defects',
                 'congenital_heart_disease_profound_intellectual_disability_and_controlled_medically_managed_heart_failure_due_to_ventricular_septal_defect_and_atrial_septal_defect',
                 'congenital_heart_disease_profound_intellectual_disability_and_controlled_medically_managed_heart_failure_due_to_critical_malformations_of_great_vessels_congenital_valvular_heart_disease_and_patent_ductus_arteriosus',
                 'congenital_heart_disease_severe_intellectual_disability_and_controlled_medically_managed_heart_failure_due_to_critical_malformations_of_great_vessels_congenital_valvular_heart_disease_and_patent_ductus_arteriosus',
                 'congenital_heart_disease_severe_intellectual_disability_and_controlled_medically_managed_heart_failure_due_to_severe_congenital_heart_anomalies_excluding_single_ventricle_heart_defects',
                 'congenital_heart_disease_severe_intellectual_disability_and_controlled_medically_managed_heart_failure_due_to_single_ventricle_and_single_ventricle_pathway_heart_defects',
                 'congenital_heart_disease_severe_intellectual_disability_and_controlled_medically_managed_heart_failure_due_to_ventricular_septal_defect_and_atrial_septal_defect',
                 'diagnosis_and_primary_therapy_phase_of_other_malignant_neoplasms',
                 'controlled_phase_of_other_malignant_neoplasms', 'metastatic_phase_of_other_malignant_neoplasms',
                 'terminal_phase_of_other_malignant_neoplasms', 'asymptomatic_rheumatoid_arthritis',
                 'symptomatic_probable_migraine', 'asymptomatic_probable_migraine', 'symptomatic_definite_migraine',
                 'asymptomatic_definite_migraine', 'asymptomatic_osteoarthritis_of_the_knee',
                 'asymptomatic_osteoarthritis_of_the_hip', 'mild_to_moderate_gerd_symptomatic_days',
                 'mild_to_moderate_gerd_asymptomatic_days', 'severe_gerd_symptomatic_days',
                 'severe_gerd_asymptomatic_days', 'asymptomatic_chronic_pancreatitis',
                 'severe_acute_uncomplicated_pud_with_no_anemia', 'severe_acute_uncomplicated_pud_with_mild_anemia',
                 'severe_acute_uncomplicated_pud_with_moderate_anemia',
                 'severe_acute_uncomplicated_pud_with_severe_anemia',
                 'severe_acute_uncomplicated_gastritis_duodenitis_with_no_anemia',
                 'severe_acute_uncomplicated_gastritis_duodenitis_with_mild_anemia',
                 'severe_acute_uncomplicated_gastritis_duodenitis_with_moderate_anemia',
                 'severe_acute_uncomplicated_gastritis_duodenitis_with_severe_anemia',
                 'extreme_hyperbilirubinemia_due_to_hemolytic_disease_and_other_neonatal_jaundice_without_kernicterus',
                 'basal_cell_carcinoma_without_disfigurement',
                 'mild_motor_impairment_and_moderate_respiratory_problems_due_to_motor_neuron_disease',
                 'mild_motor_plus_cognitive_impairments_due_to_meningitis',
                 'moderately_severe_hearing_loss_due_to_meningitis',
                 'profound_hearing_loss_with_ringing_due_to_meningitis',
                 'moderate_motor_impairment_due_to_meningitis', 'blindness_due_to_meningitis',
                 'moderate_hearing_loss_with_ringing_due_to_meningitis', 'profound_hearing_loss_due_to_meningitis',
                 'mild_intellectual_disability_due_to_meningitis', 'epilepsy_due_to_meningitis',
                 'moderate_hearing_loss_due_to_meningitis', 'severe_hearing_loss_with_ringing_due_to_meningitis',
                 'borderline_intellectual_disability_due_to_meningitis',
                 'monocular_distance_vision_loss_due_to_meningitis',
                 'severe_motor_plus_cognitive_impairments_due_to_meningitis',
                 'mild_hearing_loss_with_ringing_due_to_meningitis',
                 'mild_motor_impairment_due_to_long_term_due_to_meningitis',
                 'mild_behavioral_problems_due_to_meningitis', 'severe_hearing_loss_due_to_meningitis',
                 'complete_hearing_loss_with_ringing_due_to_meningitis',
                 'moderate_motor_plus_cognitive_impairments_due_to_meningitis',
                 'mild_hearing_loss_due_to_meningitis', 'acute_meningitis',
                 'moderately_severe_hearing_loss_with_ringing_due_to_meningitis',
                 'complete_hearing_loss_due_to_meningitis', 'severe_motor_impairment_due_to_meningitis',
                 'moderate_vision_impairment_due_to_meningitis', 'severe_vision_impairment_due_to_meningitis',
                 'mild_osteoarthritis_of_the_hand_and_foot', 'moderate_osteoarthritis_of_the_hand_and_foot',
                 'severe_osteoarthritis_of_the_hand_and_foot', 'mild_osteoarthritis_other',
                 'moderate_osteoarthritis_other', 'severe_osteoarthritis_other',
                 'diagnosis_and_primary_therapy_phase_of_burkitt_lymphoma', 'controlled_phase_of_burkitt_lymphoma',
                 'metastatic_phase_of_burkitt_lymphoma', 'terminal_phase_of_burkitt_lymphoma',
                 'diagnosis_and_primary_therapy_phase_of_other_non_hodgkin_lymphoma',
                 'controlled_phase_of_other_non_hodgkin_lymphoma', 'metastatic_phase_of_other_non_hodgkin_lymphoma',
                 'terminal_phase_of_other_non_hodgkin_lymphoma',
                 'diagnosis_and_primary_therapy_phase_of_hepatoblastoma', 'controlled_phase_of_hepatoblastoma',
                 'metastatic_phase_of_hepatoblastoma', 'terminal_phase_of_hepatoblastoma',
                 'diagnosis_and_primary_therapy_phase_of_retinoblastoma', 'controlled_phase_of_retinoblastoma',
                 'metastatic_phase_of_retinoblastoma', 'terminal_phase_of_retinoblastoma',
                 'diagnosis_and_primary_therapy_phase_of_other_eye_cancers', 'controlled_phase_of_other_eye_cancers',
                 'metastatic_phase_of_other_eye_cancers', 'terminal_phase_of_other_eye_cancers',
                 'diagnosis_and_primary_therapy_phase_of_soft_tissue_and_other_extraosseous_sarcomas',
                 'controlled_phase_of_soft_tissue_and_other_extraosseous_sarcomas',
                 'metastatic_phase_of_soft_tissue_and_other_extraosseous_sarcomas',
                 'terminal_phase_of_soft_tissue_and_other_extraosseous_sarcomas',
                 'diagnosis_and_primary_therapy_phase_of_malignant_bone_tumors',
                 'controlled_phase_of_malignant_bone_tumors', 'metastatic_phase_of_malignant_bone_tumors',
                 'terminal_phase_of_malignant_bone_tumors',
                 'diagnosis_and_primary_therapy_phase_of_neuroblastoma_and_other_peripheral_nervous_cell_tumors',
                 'controlled_phase_of_neuroblastoma_and_other_peripheral_nervous_cell_tumors',
                 'metastatic_phase_of_neuroblastoma_and_other_peripheral_nervous_cell_tumors',
                 'terminal_phase_of_neuroblastoma_and_other_peripheral_nervous_cell_tumors',
                 'controlled_medically_managed_heart_failure_due_to_pulmonary_arterial_hypertension',
                 'mild_heart_failure_due_to_pulmonary_arterial_hypertension',
                 'moderate_heart_failure_due_to_pulmonary_arterial_hypertension',
                 'severe_heart_failure_due_to_pulmonary_arterial_hypertension',
                 'end_stage_renal_disease_on_dialysis_and_mild_anemia_due_to_type_1_diabetes_mellitus',
                 'end_stage_renal_disease_on_dialysis_and_mild_anemia_due_to_type_2_diabetes_mellitus',
                 'end_stage_renal_disease_on_dialysis_and_mild_anemia_due_to_hypertension',
                 'end_stage_renal_disease_on_dialysis_and_mild_anemia_due_to_glomerulonephritis',
                 'end_stage_renal_disease_on_dialysis_and_mild_anemia_due_to_other_and_unspecified_causes',
                 'end_stage_renal_disease_on_dialysis_and_moderate_anemia_due_to_type_1_diabetes_mellitus',
                 'end_stage_renal_disease_on_dialysis_and_moderate_anemia_due_to_type_2_diabetes_mellitus',
                 'end_stage_renal_disease_on_dialysis_and_moderate_anemia_due_to_hypertension',
                 'end_stage_renal_disease_on_dialysis_and_moderate_anemia_due_to_glomerulonephritis',
                 'end_stage_renal_disease_on_dialysis_and_moderate_anemia_due_to_other_and_unspecified_causes',
                 'end_stage_renal_disease_on_dialysis_and_severe_anemia_due_to_type_1_diabetes_mellitus',
                 'end_stage_renal_disease_on_dialysis_and_severe_anemia_due_to_type_2_diabetes_mellitus',
                 'end_stage_renal_disease_on_dialysis_and_severe_anemia_due_to_hypertension',
                 'end_stage_renal_disease_on_dialysis_and_severe_anemia_due_to_glomerulonephritis',
                 'end_stage_renal_disease_on_dialysis_and_severe_anemia_due_to_other_and_unspecified_causes',
                 'end_stage_renal_disease_on_dialysis_without_anemia_due_to_type_1_diabetes_mellitus',
                 'end_stage_renal_disease_on_dialysis_without_anemia_due_to_type_2_diabetes_mellitus',
                 'end_stage_renal_disease_on_dialysis_without_anemia_due_to_hypertension',
                 'end_stage_renal_disease_on_dialysis_without_anemia_due_to_glomerulonephritis',
                 'end_stage_renal_disease_on_dialysis_without_anemia_due_to_other_and_unspecified_causes',
                 'cirrhosis_and_other_chronic_liver_diseases_due_to_hepatitis_b_decompensated_without_anemia',
                 'cirrhosis_and_other_chronic_liver_diseases_due_to_hepatitis_b_decompensated_with_mild_anemia',
                 'cirrhosis_and_other_chronic_liver_diseases_due_to_hepatitis_b_decompensated_with_moderate_anemia',
                 'cirrhosis_and_other_chronic_liver_diseases_due_to_hepatitis_b_decompensated_with_severe_anemia',
                 'cirrhosis_and_other_chronic_liver_diseases_due_to_hepatitis_c_decompensated_with_no_anemia',
                 'cirrhosis_and_other_chronic_liver_diseases_due_to_hepatitis_c_decompensated_with_mild_anemia',
                 'cirrhosis_and_other_chronic_liver_diseases_due_to_hepatitis_c_decompensated_with_moderate_anemia',
                 'cirrhosis_and_other_chronic_liver_diseases_due_to_hepatitis_c_decompensated_with_severe_anemia',
                 'cirrhosis_and_other_chronic_liver_diseases_due_to_alcohol_decompensated_without_anemia',
                 'cirrhosis_and_other_chronic_liver_diseases_due_to_alcohol_decompensated_with_mild_anemia',
                 'cirrhosis_and_other_chronic_liver_diseases_due_to_alcohol_decompensated_with_moderate_anemia',
                 'cirrhosis_and_other_chronic_liver_diseases_due_to_alcohol_decompensated_with_severe_anemia',
                 'cirrhosis_and_other_chronic_liver_diseases_due_to_other_decompensated_with_no_anemia',
                 'cirrhosis_and_other_chronic_liver_diseases_due_to_other_decompensated_with_mild_anemia',
                 'cirrhosis_and_other_chronic_liver_diseases_due_to_other_decompensated_with_moderate_anemia',
                 'cirrhosis_and_other_chronic_liver_diseases_due_to_other_decompensated_with_severe_anemia',
                 'cirrhosis_and_other_chronic_liver_diseases_due_to_nash_decompensated_with_no_anemia',
                 'cirrhosis_and_other_chronic_liver_diseases_due_to_nash_decompensated_with_mild_anemia',
                 'cirrhosis_and_other_chronic_liver_diseases_due_to_nash_decompensated_with_moderate_anemia',
                 'cirrhosis_and_other_chronic_liver_diseases_due_to_nash_decompensated_with_severe_anemia',
                 'asymptomatic_symptomatic_inguinal_femoral_and_abdominal_hernia',
                 'asymptomatic_osteoarthritis_of_the_hand_and_foot', 'asymptomatic_osteoarthritis_other',
                 'symptomatic_probable_tension_type_headache', 'asymptomatic_probable_tension_type_headache',
                 'symptomatic_definite_tension_type_headache', 'asymptomatic_definite_tension_type_headache',
                 'other_combined_sequelae_of_homozygous_sickle_cell_and_severe_sickle_cell_beta_thalassemia',
                 'other_combined_sequelae_of_hemoglobin_sc_disease',
                 'other_combined_sequelae_of_mild_sickle_cell_beta_thalassemia_exclusivity_adjustment', )

    def __init__(self, **kwargs):
        super().__init__()
        self.acute_typhoid_infection = kwargs.get('acute_typhoid_infection')
        self.severe_typhoid_fever = kwargs.get('severe_typhoid_fever')
        self.intestinal_perforation_due_to_typhoid = kwargs.get('intestinal_perforation_due_to_typhoid')
        self.acute_paratyphoid_infection = kwargs.get('acute_paratyphoid_infection')
        self.moderate_paratyphoid_fever = kwargs.get('moderate_paratyphoid_fever')
        self.severe_paratyphoid_fever = kwargs.get('severe_paratyphoid_fever')
        self.intestinal_perforation_due_to_paratyphoid = kwargs.get('intestinal_perforation_due_to_paratyphoid')
        self.other_intestinal_infectious_diseases = kwargs.get('other_intestinal_infectious_diseases')
        self.mild_upper_respiratory_infections = kwargs.get('mild_upper_respiratory_infections')
        self.moderate_upper_respiratory_infections = kwargs.get('moderate_upper_respiratory_infections')
        self.guillain_barre_syndrome_due_to_upper_respiratory_infections = kwargs.get('guillain_barre_syndrome_due_to_upper_respiratory_infections')
        self.acute_otitis_media = kwargs.get('acute_otitis_media')
        self.acute_viral_meningitis = kwargs.get('acute_viral_meningitis')
        self.acute_encephalitis = kwargs.get('acute_encephalitis')
        self.moderate_diphtheria = kwargs.get('moderate_diphtheria')
        self.severe_diphtheria = kwargs.get('severe_diphtheria')
        self.whooping_cough = kwargs.get('whooping_cough')
        self.severe_tetanus = kwargs.get('severe_tetanus')
        self.moderate_measles = kwargs.get('moderate_measles')
        self.severe_measles = kwargs.get('severe_measles')
        self.chickenpox = kwargs.get('chickenpox')
        self.herpes_zoster = kwargs.get('herpes_zoster')
        self.mild_malaria = kwargs.get('mild_malaria')
        self.moderate_malaria = kwargs.get('moderate_malaria')
        self.severe_malaria = kwargs.get('severe_malaria')
        self.acute_chagas_disease = kwargs.get('acute_chagas_disease')
        self.atrial_fibrillation_and_flutter_due_to_chagas_disease = kwargs.get('atrial_fibrillation_and_flutter_due_to_chagas_disease')
        self.mild_chronic_digestive_disease_due_to_chagas_disease = kwargs.get('mild_chronic_digestive_disease_due_to_chagas_disease')
        self.moderate_chronic_digestive_disease_due_to_chagas_disease = kwargs.get('moderate_chronic_digestive_disease_due_to_chagas_disease')
        self.mild_heart_failure_due_to_chagas_disease = kwargs.get('mild_heart_failure_due_to_chagas_disease')
        self.moderate_heart_failure_due_to_chagas_disease = kwargs.get('moderate_heart_failure_due_to_chagas_disease')
        self.severe_heart_failure_due_to_chagas_disease = kwargs.get('severe_heart_failure_due_to_chagas_disease')
        self.moderate_visceral_leishmaniasis = kwargs.get('moderate_visceral_leishmaniasis')
        self.severe_visceral_leishmaniasis = kwargs.get('severe_visceral_leishmaniasis')
        self.cutaneous_and_mucocutaneous_leishmaniasis = kwargs.get('cutaneous_and_mucocutaneous_leishmaniasis')
        self.mild_schistosomiasis = kwargs.get('mild_schistosomiasis')
        self.mild_diarrhea_due_to_schistosomiasis = kwargs.get('mild_diarrhea_due_to_schistosomiasis')
        self.hematemesis_due_to_schistosomiasis = kwargs.get('hematemesis_due_to_schistosomiasis')
        self.hepatomegaly_due_to_schistosomiasis = kwargs.get('hepatomegaly_due_to_schistosomiasis')
        self.ascites_due_to_schistosomiasis = kwargs.get('ascites_due_to_schistosomiasis')
        self.dysuria_due_to_schistosomiasis = kwargs.get('dysuria_due_to_schistosomiasis')
        self.bladder_pathology_due_to_schistosomiasis = kwargs.get('bladder_pathology_due_to_schistosomiasis')
        self.hydronephrosis_due_to_schistosomiasis = kwargs.get('hydronephrosis_due_to_schistosomiasis')
        self.mild_anemia_due_to_schistosomiasis = kwargs.get('mild_anemia_due_to_schistosomiasis')
        self.moderate_anemia_due_to_schistosomiasis = kwargs.get('moderate_anemia_due_to_schistosomiasis')
        self.severe_anemia_due_to_schistosomiasis = kwargs.get('severe_anemia_due_to_schistosomiasis')
        self.abdominal_problems_due_to_cystic_echinococcosis = kwargs.get('abdominal_problems_due_to_cystic_echinococcosis')
        self.chronic_respiratory_disease_due_to_cystic_echinococcosis = kwargs.get('chronic_respiratory_disease_due_to_cystic_echinococcosis')
        self.prevalence_of_detectable_microfiliaria_due_to_lymphatic_filariasis = kwargs.get('prevalence_of_detectable_microfiliaria_due_to_lymphatic_filariasis')
        self.lymphedema_due_to_lymphatic_filariasis = kwargs.get('lymphedema_due_to_lymphatic_filariasis')
        self.hydrocele_due_to_lymphatic_filariasis = kwargs.get('hydrocele_due_to_lymphatic_filariasis')
        self.mild_skin_disease_due_to_onchocerciasis = kwargs.get('mild_skin_disease_due_to_onchocerciasis')
        self.moderate_skin_disease_due_to_onchocerciasis = kwargs.get('moderate_skin_disease_due_to_onchocerciasis')
        self.moderate_vision_impairment_due_to_trachoma = kwargs.get('moderate_vision_impairment_due_to_trachoma')
        self.severe_vision_impairment_due_to_trachoma = kwargs.get('severe_vision_impairment_due_to_trachoma')
        self.blindness_due_to_trachoma = kwargs.get('blindness_due_to_trachoma')
        self.moderate_dengue = kwargs.get('moderate_dengue')
        self.severe_dengue = kwargs.get('severe_dengue')
        self.post_dengue_chronic_fatigue_syndrome = kwargs.get('post_dengue_chronic_fatigue_syndrome')
        self.moderate_yellow_fever = kwargs.get('moderate_yellow_fever')
        self.severe_yellow_fever = kwargs.get('severe_yellow_fever')
        self.rabies = kwargs.get('rabies')
        self.heavy_infestation_of_ascariasis = kwargs.get('heavy_infestation_of_ascariasis')
        self.mild_abdominopelvic_problems_due_to_ascariasis = kwargs.get('mild_abdominopelvic_problems_due_to_ascariasis')
        self.severe_wasting_due_to_ascariasis = kwargs.get('severe_wasting_due_to_ascariasis')
        self.heavy_infestation_of_trichuriasis = kwargs.get('heavy_infestation_of_trichuriasis')
        self.mild_abdominopelvic_problems_due_to_trichuriasis = kwargs.get('mild_abdominopelvic_problems_due_to_trichuriasis')
        self.severe_wasting_due_to_trichuriasis = kwargs.get('severe_wasting_due_to_trichuriasis')
        self.heavy_infestation_of_hookworm = kwargs.get('heavy_infestation_of_hookworm')
        self.mild_abdominopelvic_problems_due_to_hookworm_disease = kwargs.get('mild_abdominopelvic_problems_due_to_hookworm_disease')
        self.severe_wasting_due_to_hookworm_disease = kwargs.get('severe_wasting_due_to_hookworm_disease')
        self.mild_anemia_due_to_hookworm_disease = kwargs.get('mild_anemia_due_to_hookworm_disease')
        self.moderate_anemia_due_to_hookworm_disease = kwargs.get('moderate_anemia_due_to_hookworm_disease')
        self.severe_anemia_due_to_hookworm_disease = kwargs.get('severe_anemia_due_to_hookworm_disease')
        self.cerebral_paragonimiasis = kwargs.get('cerebral_paragonimiasis')
        self.acute_infection_due_to_other_neglected_tropical_diseases = kwargs.get('acute_infection_due_to_other_neglected_tropical_diseases')
        self.mild_anemia_due_to_other_neglected_tropical_diseases = kwargs.get('mild_anemia_due_to_other_neglected_tropical_diseases')
        self.moderate_anemia_due_to_other_neglected_tropical_diseases = kwargs.get('moderate_anemia_due_to_other_neglected_tropical_diseases')
        self.severe_anemia_due_to_other_neglected_tropical_diseases = kwargs.get('severe_anemia_due_to_other_neglected_tropical_diseases')
        self.maternal_hemorrhage_less_than__1l_blood_lost = kwargs.get('maternal_hemorrhage_less_than__1l_blood_lost')
        self.maternal_hemorrhage_greater_than__1l_blood_lost = kwargs.get('maternal_hemorrhage_greater_than__1l_blood_lost')
        self.mild_anemia_due_to_maternal_hemorrhage = kwargs.get('mild_anemia_due_to_maternal_hemorrhage')
        self.moderate_anemia_due_to_maternal_hemorrhage = kwargs.get('moderate_anemia_due_to_maternal_hemorrhage')
        self.severe_anemia_due_to_maternal_hemorrhage = kwargs.get('severe_anemia_due_to_maternal_hemorrhage')
        self.severe_pre_eclampsia = kwargs.get('severe_pre_eclampsia')
        self.eclampsia = kwargs.get('eclampsia')
        self.long_term_sequelae_of_severe_pre_eclampsia = kwargs.get('long_term_sequelae_of_severe_pre_eclampsia')
        self.obstructed_labor_acute_event = kwargs.get('obstructed_labor_acute_event')
        self.rectovaginal_fistula = kwargs.get('rectovaginal_fistula')
        self.vesicovaginal_fistula = kwargs.get('vesicovaginal_fistula')
        self.maternal_abortive_outcome = kwargs.get('maternal_abortive_outcome')
        self.other_maternal_disorders = kwargs.get('other_maternal_disorders')
        self.mild_vision_impairment_due_to_retinopathy_of_prematurity = kwargs.get('mild_vision_impairment_due_to_retinopathy_of_prematurity')
        self.mild_motor_plus_cognitive_impairments_due_to_neonatal_encephalopathy_due_to_birth_asphyxia_and_trauma = kwargs.get('mild_motor_plus_cognitive_impairments_due_to_neonatal_encephalopathy_due_to_birth_asphyxia_and_trauma')
        self.mild_motor_impairment_due_to_neonatal_encephalopathy_due_to_birth_asphyxia_and_trauma = kwargs.get('mild_motor_impairment_due_to_neonatal_encephalopathy_due_to_birth_asphyxia_and_trauma')
        self.other_neonatal_disorders = kwargs.get('other_neonatal_disorders')
        self.moderate_wasting_with_edema = kwargs.get('moderate_wasting_with_edema')
        self.severe_wasting_without_edema = kwargs.get('severe_wasting_without_edema')
        self.visible_goiter_without_symptoms = kwargs.get('visible_goiter_without_symptoms')
        self.visible_goiter_with_severe_intellectual_disability_due_to_iodine_deficiency = kwargs.get('visible_goiter_with_severe_intellectual_disability_due_to_iodine_deficiency')
        self.visible_goiter_with_profound_intellectual_disability_due_to_iodine_deficiency = kwargs.get('visible_goiter_with_profound_intellectual_disability_due_to_iodine_deficiency')
        self.moderate_vision_impairment_loss_due_to_vitamin_a_deficiency = kwargs.get('moderate_vision_impairment_loss_due_to_vitamin_a_deficiency')
        self.severe_vision_impairment_loss_due_to_vitamin_a_deficiency = kwargs.get('severe_vision_impairment_loss_due_to_vitamin_a_deficiency')
        self.blindness_due_to_vitamin_a_deficiency = kwargs.get('blindness_due_to_vitamin_a_deficiency')
        self.mild_iron_deficiency_anemia = kwargs.get('mild_iron_deficiency_anemia')
        self.moderate_iron_deficiency_anemia = kwargs.get('moderate_iron_deficiency_anemia')
        self.severe_iron_deficiency_anemia = kwargs.get('severe_iron_deficiency_anemia')
        self.other_nutritional_deficiencies = kwargs.get('other_nutritional_deficiencies')
        self.epididymo_orchitis_due_to_chlamydial_infection = kwargs.get('epididymo_orchitis_due_to_chlamydial_infection')
        self.moderate_pelvic_inflammatory_diseases_due_to_chlamydial_infection = kwargs.get('moderate_pelvic_inflammatory_diseases_due_to_chlamydial_infection')
        self.severe_pelvic_inflammatory_diseases_due_to_chlamydial_infection = kwargs.get('severe_pelvic_inflammatory_diseases_due_to_chlamydial_infection')
        self.primary_infertility_due_to_chlamydial_infection = kwargs.get('primary_infertility_due_to_chlamydial_infection')
        self.secondary_infertility_due_to_chlamydial_infection = kwargs.get('secondary_infertility_due_to_chlamydial_infection')
        self.epididymo_orchitis_due_to_gonococcal_infection = kwargs.get('epididymo_orchitis_due_to_gonococcal_infection')
        self.moderate_pelvic_inflammatory_diseases_due_to_gonococcal_infection = kwargs.get('moderate_pelvic_inflammatory_diseases_due_to_gonococcal_infection')
        self.severe_pelvic_inflammatory_diseases_due_to_gonococcal_infection = kwargs.get('severe_pelvic_inflammatory_diseases_due_to_gonococcal_infection')
        self.primary_infertility_due_to_gonococcal_infection = kwargs.get('primary_infertility_due_to_gonococcal_infection')
        self.secondary_infertility_due_to_gonococcal_infection = kwargs.get('secondary_infertility_due_to_gonococcal_infection')
        self.moderate_pelvic_inflammatory_diseases_due_to_other_sexually_transmitted_diseases = kwargs.get('moderate_pelvic_inflammatory_diseases_due_to_other_sexually_transmitted_diseases')
        self.severe_pelvic_inflammatory_diseases_due_to_other_sexually_transmitted_diseases = kwargs.get('severe_pelvic_inflammatory_diseases_due_to_other_sexually_transmitted_diseases')
        self.primary_infertility_due_to_other_sexually_transmitted_diseases = kwargs.get('primary_infertility_due_to_other_sexually_transmitted_diseases')
        self.secondary_infertility_due_to_other_sexually_transmitted_diseases = kwargs.get('secondary_infertility_due_to_other_sexually_transmitted_diseases')
        self.moderate_acute_hepatitis_a = kwargs.get('moderate_acute_hepatitis_a')
        self.severe_acute_hepatitis_a = kwargs.get('severe_acute_hepatitis_a')
        self.moderate_acute_hepatitis_b = kwargs.get('moderate_acute_hepatitis_b')
        self.severe_acute_hepatitis_b = kwargs.get('severe_acute_hepatitis_b')
        self.moderate_acute_hepatitis_c = kwargs.get('moderate_acute_hepatitis_c')
        self.severe_acute_hepatitis_c = kwargs.get('severe_acute_hepatitis_c')
        self.moderate_acute_hepatitis_e = kwargs.get('moderate_acute_hepatitis_e')
        self.severe_acute_hepatitis_e = kwargs.get('severe_acute_hepatitis_e')
        self.disfigurement_level_1_due_to_leprosy = kwargs.get('disfigurement_level_1_due_to_leprosy')
        self.disfigurement_level_2_due_to_leprosy = kwargs.get('disfigurement_level_2_due_to_leprosy')
        self.mild_anemia_due_to_other_infectious_diseases = kwargs.get('mild_anemia_due_to_other_infectious_diseases')
        self.moderate_anemia_due_to_other_infectious_diseases = kwargs.get('moderate_anemia_due_to_other_infectious_diseases')
        self.severe_anemia_due_to_other_infectious_diseases = kwargs.get('severe_anemia_due_to_other_infectious_diseases')
        self.guillain_barre_syndrome_due_to_other_infectious_diseases = kwargs.get('guillain_barre_syndrome_due_to_other_infectious_diseases')
        self.diagnosis_and_primary_therapy_phase_of_esophageal_cancer = kwargs.get('diagnosis_and_primary_therapy_phase_of_esophageal_cancer')
        self.controlled_phase_of_esophageal_cancer = kwargs.get('controlled_phase_of_esophageal_cancer')
        self.metastatic_phase_of_esophageal_cancer = kwargs.get('metastatic_phase_of_esophageal_cancer')
        self.terminal_phase_of_esophageal_cancer = kwargs.get('terminal_phase_of_esophageal_cancer')
        self.diagnosis_and_primary_therapy_phase_of_stomach_cancer = kwargs.get('diagnosis_and_primary_therapy_phase_of_stomach_cancer')
        self.controlled_phase_of_stomach_cancer = kwargs.get('controlled_phase_of_stomach_cancer')
        self.metastatic_phase_of_stomach_cancer = kwargs.get('metastatic_phase_of_stomach_cancer')
        self.terminal_phase_of_stomach_cancer = kwargs.get('terminal_phase_of_stomach_cancer')
        self.diagnosis_and_primary_therapy_phase_of_liver_cancer_due_to_hepatitis_b = kwargs.get('diagnosis_and_primary_therapy_phase_of_liver_cancer_due_to_hepatitis_b')
        self.controlled_phase_of_liver_cancer_due_to_hepatitis_b = kwargs.get('controlled_phase_of_liver_cancer_due_to_hepatitis_b')
        self.metastatic_phase_of_liver_cancer_due_to_hepatitis_b = kwargs.get('metastatic_phase_of_liver_cancer_due_to_hepatitis_b')
        self.terminal_phase_of_liver_cancer_due_to_hepatitis_b = kwargs.get('terminal_phase_of_liver_cancer_due_to_hepatitis_b')
        self.diagnosis_and_primary_therapy_phase_of_liver_cancer_due_to_hepatitis_c = kwargs.get('diagnosis_and_primary_therapy_phase_of_liver_cancer_due_to_hepatitis_c')
        self.controlled_phase_of_liver_cancer_due_to_hepatitis_c = kwargs.get('controlled_phase_of_liver_cancer_due_to_hepatitis_c')
        self.metastatic_phase_of_liver_cancer_due_to_hepatitis_c = kwargs.get('metastatic_phase_of_liver_cancer_due_to_hepatitis_c')
        self.terminal_phase_of_liver_cancer_due_to_hepatitis_c = kwargs.get('terminal_phase_of_liver_cancer_due_to_hepatitis_c')
        self.diagnosis_and_primary_therapy_phase_of_liver_cancer_due_to_alcohol_use = kwargs.get('diagnosis_and_primary_therapy_phase_of_liver_cancer_due_to_alcohol_use')
        self.controlled_phase_of_liver_cancer_due_to_alcohol_use = kwargs.get('controlled_phase_of_liver_cancer_due_to_alcohol_use')
        self.metastatic_phase_of_liver_cancer_due_to_alcohol_use = kwargs.get('metastatic_phase_of_liver_cancer_due_to_alcohol_use')
        self.terminal_phase_of_liver_cancer_due_to_alcohol_use = kwargs.get('terminal_phase_of_liver_cancer_due_to_alcohol_use')
        self.diagnosis_and_primary_therapy_phase_of_liver_cancer_due_to_other_causes = kwargs.get('diagnosis_and_primary_therapy_phase_of_liver_cancer_due_to_other_causes')
        self.controlled_phase_of_liver_cancer_due_to_other_causes = kwargs.get('controlled_phase_of_liver_cancer_due_to_other_causes')
        self.metastatic_phase_of_liver_cancer_due_to_other_causes = kwargs.get('metastatic_phase_of_liver_cancer_due_to_other_causes')
        self.terminal_phase_of_liver_cancer_due_to_other_causes = kwargs.get('terminal_phase_of_liver_cancer_due_to_other_causes')
        self.diagnosis_and_primary_therapy_phase_of_larynx_cancer = kwargs.get('diagnosis_and_primary_therapy_phase_of_larynx_cancer')
        self.metastatic_phase_of_larynx_cancer = kwargs.get('metastatic_phase_of_larynx_cancer')
        self.terminal_phase_of_larynx_cancer = kwargs.get('terminal_phase_of_larynx_cancer')
        self.diagnosis_and_primary_therapy_phase_of_lung_bronchus_and_trachea_cancer = kwargs.get('diagnosis_and_primary_therapy_phase_of_lung_bronchus_and_trachea_cancer')
        self.controlled_phase_of_lung_bronchus_and_trachea_cancer = kwargs.get('controlled_phase_of_lung_bronchus_and_trachea_cancer')
        self.metastatic_phase_of_lung_bronchus_and_trachea_cancer = kwargs.get('metastatic_phase_of_lung_bronchus_and_trachea_cancer')
        self.terminal_phase_of_lung_bronchus_and_trachea_cancer = kwargs.get('terminal_phase_of_lung_bronchus_and_trachea_cancer')
        self.diagnosis_and_primary_therapy_phase_of_breast_cancer = kwargs.get('diagnosis_and_primary_therapy_phase_of_breast_cancer')
        self.metastatic_phase_of_breast_cancer = kwargs.get('metastatic_phase_of_breast_cancer')
        self.terminal_phase_of_breast_cancer = kwargs.get('terminal_phase_of_breast_cancer')
        self.diagnosis_and_primary_therapy_phase_of_cervical_cancer = kwargs.get('diagnosis_and_primary_therapy_phase_of_cervical_cancer')
        self.controlled_phase_of_cervical_cancer = kwargs.get('controlled_phase_of_cervical_cancer')
        self.metastatic_phase_of_cervical_cancer = kwargs.get('metastatic_phase_of_cervical_cancer')
        self.terminal_phase_of_cervical_cancer = kwargs.get('terminal_phase_of_cervical_cancer')
        self.diagnosis_and_primary_therapy_phase_of_uterine_cancer = kwargs.get('diagnosis_and_primary_therapy_phase_of_uterine_cancer')
        self.controlled_phase_of_uterine_cancer = kwargs.get('controlled_phase_of_uterine_cancer')
        self.metastatic_phase_of_uterine_cancer = kwargs.get('metastatic_phase_of_uterine_cancer')
        self.terminal_phase_of_uterine_cancer = kwargs.get('terminal_phase_of_uterine_cancer')
        self.diagnosis_and_primary_therapy_phase_of_prostate_cancer = kwargs.get('diagnosis_and_primary_therapy_phase_of_prostate_cancer')
        self.metastatic_phase_of_prostate_cancer = kwargs.get('metastatic_phase_of_prostate_cancer')
        self.terminal_phase_of_prostate_cancer = kwargs.get('terminal_phase_of_prostate_cancer')
        self.diagnosis_and_primary_therapy_phase_of_colon_and_rectum_cancers = kwargs.get('diagnosis_and_primary_therapy_phase_of_colon_and_rectum_cancers')
        self.metastatic_phase_of_colon_and_rectum_cancers = kwargs.get('metastatic_phase_of_colon_and_rectum_cancers')
        self.terminal_phase_of_colon_and_rectum_cancers = kwargs.get('terminal_phase_of_colon_and_rectum_cancers')
        self.diagnosis_and_primary_therapy_phase_of_mouth_cancer = kwargs.get('diagnosis_and_primary_therapy_phase_of_mouth_cancer')
        self.controlled_phase_of_mouth_cancer = kwargs.get('controlled_phase_of_mouth_cancer')
        self.metastatic_phase_of_mouth_cancer = kwargs.get('metastatic_phase_of_mouth_cancer')
        self.terminal_phase_of_mouth_cancer = kwargs.get('terminal_phase_of_mouth_cancer')
        self.diagnosis_and_primary_therapy_phase_of_nasopharynx_cancer = kwargs.get('diagnosis_and_primary_therapy_phase_of_nasopharynx_cancer')
        self.controlled_phase_of_nasopharynx_cancer = kwargs.get('controlled_phase_of_nasopharynx_cancer')
        self.metastatic_phase_of_nasopharynx_cancer = kwargs.get('metastatic_phase_of_nasopharynx_cancer')
        self.terminal_phase_of_nasopharynx_cancer = kwargs.get('terminal_phase_of_nasopharynx_cancer')
        self.diagnosis_and_primary_therapy_phase_of_other_pharynx_cancer = kwargs.get('diagnosis_and_primary_therapy_phase_of_other_pharynx_cancer')
        self.controlled_phase_of_other_pharynx_cancer = kwargs.get('controlled_phase_of_other_pharynx_cancer')
        self.metastatic_phase_of_other_pharynx_cancer = kwargs.get('metastatic_phase_of_other_pharynx_cancer')
        self.terminal_phase_of_other_pharynx_cancer = kwargs.get('terminal_phase_of_other_pharynx_cancer')
        self.diagnosis_and_primary_therapy_phase_of_gallbladder_and_biliary_tract_cancer = kwargs.get('diagnosis_and_primary_therapy_phase_of_gallbladder_and_biliary_tract_cancer')
        self.controlled_phase_of_gallbladder_and_biliary_tract_cancer = kwargs.get('controlled_phase_of_gallbladder_and_biliary_tract_cancer')
        self.metastatic_phase_of_gallbladder_and_biliary_tract_cancer = kwargs.get('metastatic_phase_of_gallbladder_and_biliary_tract_cancer')
        self.terminal_phase_of_gallbladder_and_biliary_tract_cancer = kwargs.get('terminal_phase_of_gallbladder_and_biliary_tract_cancer')
        self.diagnosis_and_primary_therapy_phase_of_pancreatic_cancer = kwargs.get('diagnosis_and_primary_therapy_phase_of_pancreatic_cancer')
        self.controlled_phase_of_pancreatic_cancer = kwargs.get('controlled_phase_of_pancreatic_cancer')
        self.metastatic_phase_of_pancreatic_cancer = kwargs.get('metastatic_phase_of_pancreatic_cancer')
        self.terminal_phase_of_pancreatic_cancer = kwargs.get('terminal_phase_of_pancreatic_cancer')
        self.diagnosis_and_primary_therapy_phase_of_malignant_skin_melanoma = kwargs.get('diagnosis_and_primary_therapy_phase_of_malignant_skin_melanoma')
        self.controlled_phase_of_malignant_skin_melanoma = kwargs.get('controlled_phase_of_malignant_skin_melanoma')
        self.metastatic_phase_of_malignant_skin_melanoma = kwargs.get('metastatic_phase_of_malignant_skin_melanoma')
        self.terminal_phase_of_malignant_skin_melanoma = kwargs.get('terminal_phase_of_malignant_skin_melanoma')
        self.diagnosis_and_primary_therapy_phase_of_ovarian_cancer = kwargs.get('diagnosis_and_primary_therapy_phase_of_ovarian_cancer')
        self.controlled_phase_of_ovarian_cancer = kwargs.get('controlled_phase_of_ovarian_cancer')
        self.metastatic_phase_of_ovarian_cancer = kwargs.get('metastatic_phase_of_ovarian_cancer')
        self.terminal_phase_of_ovarian_cancer = kwargs.get('terminal_phase_of_ovarian_cancer')
        self.diagnosis_and_primary_therapy_phase_of_testicular_cancer = kwargs.get('diagnosis_and_primary_therapy_phase_of_testicular_cancer')
        self.controlled_phase_of_testicular_cancer = kwargs.get('controlled_phase_of_testicular_cancer')
        self.metastatic_phase_of_testicular_cancer = kwargs.get('metastatic_phase_of_testicular_cancer')
        self.terminal_phase_of_testicular_cancer = kwargs.get('terminal_phase_of_testicular_cancer')
        self.diagnosis_and_primary_therapy_phase_of_kidney_cancer = kwargs.get('diagnosis_and_primary_therapy_phase_of_kidney_cancer')
        self.controlled_phase_of_kidney_cancer = kwargs.get('controlled_phase_of_kidney_cancer')
        self.metastatic_phase_of_kidney_cancer = kwargs.get('metastatic_phase_of_kidney_cancer')
        self.terminal_phase_of_kidney_cancer = kwargs.get('terminal_phase_of_kidney_cancer')
        self.diagnosis_and_primary_therapy_phase_of_bladder_cancer = kwargs.get('diagnosis_and_primary_therapy_phase_of_bladder_cancer')
        self.metastatic_phase_of_bladder_cancer = kwargs.get('metastatic_phase_of_bladder_cancer')
        self.terminal_phase_of_bladder_cancer = kwargs.get('terminal_phase_of_bladder_cancer')
        self.diagnosis_and_primary_therapy_phase_of_brain_and_central_nervous_system_cancers = kwargs.get('diagnosis_and_primary_therapy_phase_of_brain_and_central_nervous_system_cancers')
        self.controlled_phase_of_brain_and_central_nervous_system_cancers = kwargs.get('controlled_phase_of_brain_and_central_nervous_system_cancers')
        self.metastatic_phase_of_brain_and_central_nervous_system_cancers = kwargs.get('metastatic_phase_of_brain_and_central_nervous_system_cancers')
        self.terminal_phase_of_brain_and_central_nervous_system_cancers = kwargs.get('terminal_phase_of_brain_and_central_nervous_system_cancers')
        self.diagnosis_and_primary_therapy_phase_of_thyroid_cancer = kwargs.get('diagnosis_and_primary_therapy_phase_of_thyroid_cancer')
        self.controlled_phase_of_thyroid_cancer = kwargs.get('controlled_phase_of_thyroid_cancer')
        self.metastatic_phase_of_thyroid_cancer = kwargs.get('metastatic_phase_of_thyroid_cancer')
        self.terminal_phase_of_thyroid_cancer = kwargs.get('terminal_phase_of_thyroid_cancer')
        self.diagnosis_and_primary_therapy_phase_of_mesothelioma = kwargs.get('diagnosis_and_primary_therapy_phase_of_mesothelioma')
        self.controlled_phase_of_mesothelioma = kwargs.get('controlled_phase_of_mesothelioma')
        self.metastatic_phase_of_mesothelioma = kwargs.get('metastatic_phase_of_mesothelioma')
        self.terminal_phase_of_mesothelioma = kwargs.get('terminal_phase_of_mesothelioma')
        self.diagnosis_and_primary_therapy_phase_of_hodgkin_disease = kwargs.get('diagnosis_and_primary_therapy_phase_of_hodgkin_disease')
        self.controlled_phase_of_hodgkin_disease = kwargs.get('controlled_phase_of_hodgkin_disease')
        self.metastatic_phase_of_hodgkin_disease = kwargs.get('metastatic_phase_of_hodgkin_disease')
        self.terminal_phase_of_hodgkin_disease = kwargs.get('terminal_phase_of_hodgkin_disease')
        self.diagnosis_and_primary_therapy_phase_of_multiple_myeloma = kwargs.get('diagnosis_and_primary_therapy_phase_of_multiple_myeloma')
        self.controlled_phase_of_multiple_myeloma = kwargs.get('controlled_phase_of_multiple_myeloma')
        self.metastatic_phase_of_multiple_myeloma = kwargs.get('metastatic_phase_of_multiple_myeloma')
        self.terminal_phase_of_multiple_myeloma = kwargs.get('terminal_phase_of_multiple_myeloma')
        self.acute_myocardial_infarction_first_2_days = kwargs.get('acute_myocardial_infarction_first_2_days')
        self.acute_myocardial_infarction_3_to_28_days = kwargs.get('acute_myocardial_infarction_3_to_28_days')
        self.mild_angina_due_to_ischemic_heart_disease = kwargs.get('mild_angina_due_to_ischemic_heart_disease')
        self.moderate_angina_due_to_ischemic_heart_disease = kwargs.get('moderate_angina_due_to_ischemic_heart_disease')
        self.severe_angina_due_to_ischemic_heart_disease = kwargs.get('severe_angina_due_to_ischemic_heart_disease')
        self.mild_heart_failure_due_to_ischemic_heart_disease = kwargs.get('mild_heart_failure_due_to_ischemic_heart_disease')
        self.moderate_heart_failure_due_to_ischemic_heart_disease = kwargs.get('moderate_heart_failure_due_to_ischemic_heart_disease')
        self.severe_heart_failure_due_to_ischemic_heart_disease = kwargs.get('severe_heart_failure_due_to_ischemic_heart_disease')
        self.acute_ischemic_stroke_severity_level_1 = kwargs.get('acute_ischemic_stroke_severity_level_1')
        self.acute_ischemic_stroke_severity_level_2 = kwargs.get('acute_ischemic_stroke_severity_level_2')
        self.acute_ischemic_stroke_severity_level_4 = kwargs.get('acute_ischemic_stroke_severity_level_4')
        self.acute_ischemic_stroke_severity_level_3 = kwargs.get('acute_ischemic_stroke_severity_level_3')
        self.acute_ischemic_stroke_severity_level_5 = kwargs.get('acute_ischemic_stroke_severity_level_5')
        self.chronic_ischemic_stroke_severity_level_1 = kwargs.get('chronic_ischemic_stroke_severity_level_1')
        self.chronic_ischemic_stroke_severity_level_2 = kwargs.get('chronic_ischemic_stroke_severity_level_2')
        self.chronic_ischemic_stroke_severity_level_4 = kwargs.get('chronic_ischemic_stroke_severity_level_4')
        self.chronic_ischemic_stroke_severity_level_3 = kwargs.get('chronic_ischemic_stroke_severity_level_3')
        self.chronic_ischemic_stroke_severity_level_5 = kwargs.get('chronic_ischemic_stroke_severity_level_5')
        self.acute_intracerebral_hemorrhage_severity_level_1 = kwargs.get('acute_intracerebral_hemorrhage_severity_level_1')
        self.acute_intracerebral_hemorrhage_severity_level_2 = kwargs.get('acute_intracerebral_hemorrhage_severity_level_2')
        self.acute_intracerebral_hemorrhage_severity_level_4 = kwargs.get('acute_intracerebral_hemorrhage_severity_level_4')
        self.acute_intracerebral_hemorrhage_severity_level_3 = kwargs.get('acute_intracerebral_hemorrhage_severity_level_3')
        self.acute_intracerebral_hemorrhage_severity_level_5 = kwargs.get('acute_intracerebral_hemorrhage_severity_level_5')
        self.chronic_intracerebral_hemorrhage_severity_level_1 = kwargs.get('chronic_intracerebral_hemorrhage_severity_level_1')
        self.chronic_intracerebral_hemorrhage_severity_level_2 = kwargs.get('chronic_intracerebral_hemorrhage_severity_level_2')
        self.chronic_intracerebral_hemorrhage_severity_level_4 = kwargs.get('chronic_intracerebral_hemorrhage_severity_level_4')
        self.chronic_intracerebral_hemorrhage_severity_level_3 = kwargs.get('chronic_intracerebral_hemorrhage_severity_level_3')
        self.chronic_intracerebral_hemorrhage_severity_level_5 = kwargs.get('chronic_intracerebral_hemorrhage_severity_level_5')
        self.mild_heart_failure_due_to_hypertensive_heart_disease = kwargs.get('mild_heart_failure_due_to_hypertensive_heart_disease')
        self.moderate_heart_failure_due_to_hypertensive_heart_disease = kwargs.get('moderate_heart_failure_due_to_hypertensive_heart_disease')
        self.severe_heart_failure_due_to_hypertensive_heart_disease = kwargs.get('severe_heart_failure_due_to_hypertensive_heart_disease')
        self.acute_myocarditis = kwargs.get('acute_myocarditis')
        self.moderate_endocarditis = kwargs.get('moderate_endocarditis')
        self.severe_endocarditis = kwargs.get('severe_endocarditis')
        self.mild_heart_failure_due_to_endocarditis = kwargs.get('mild_heart_failure_due_to_endocarditis')
        self.moderate_heart_failure_due_to_endocarditis = kwargs.get('moderate_heart_failure_due_to_endocarditis')
        self.severe_heart_failure_due_to_endocarditis = kwargs.get('severe_heart_failure_due_to_endocarditis')
        self.mild_heart_failure_due_to_other_cardiovascular_diseases = kwargs.get('mild_heart_failure_due_to_other_cardiovascular_diseases')
        self.moderate_heart_failure_due_to_other_cardiovascular_diseases = kwargs.get('moderate_heart_failure_due_to_other_cardiovascular_diseases')
        self.severe_heart_failure_due_to_other_cardiovascular_diseases = kwargs.get('severe_heart_failure_due_to_other_cardiovascular_diseases')
        self.mild_chronic_obstructive_pulmonary_disease = kwargs.get('mild_chronic_obstructive_pulmonary_disease')
        self.moderate_chronic_obstructive_pulmonary_disease = kwargs.get('moderate_chronic_obstructive_pulmonary_disease')
        self.mild_silicosis = kwargs.get('mild_silicosis')
        self.moderate_silicosis = kwargs.get('moderate_silicosis')
        self.mild_asbestosis = kwargs.get('mild_asbestosis')
        self.moderate_asbestosis = kwargs.get('moderate_asbestosis')
        self.mild_coal_workers_pneumoconiosis = kwargs.get('mild_coal_workers_pneumoconiosis')
        self.moderate_coal_workers_pneumoconiosis = kwargs.get('moderate_coal_workers_pneumoconiosis')
        self.mild_other_pneumoconiosis = kwargs.get('mild_other_pneumoconiosis')
        self.moderate_other_pneumoconiosis = kwargs.get('moderate_other_pneumoconiosis')
        self.controlled_asthma = kwargs.get('controlled_asthma')
        self.partially_controlled_asthma = kwargs.get('partially_controlled_asthma')
        self.uncontrolled_asthma = kwargs.get('uncontrolled_asthma')
        self.mild_interstitial_lung_disease_and_pulmonary_sarcoidosis = kwargs.get('mild_interstitial_lung_disease_and_pulmonary_sarcoidosis')
        self.moderate_interstitial_lung_disease_and_pulmonary_sarcoidosis = kwargs.get('moderate_interstitial_lung_disease_and_pulmonary_sarcoidosis')
        self.other_chronic_respiratory_diseases = kwargs.get('other_chronic_respiratory_diseases')
        self.appendicitis = kwargs.get('appendicitis')
        self.paralytic_ileus_and_intestinal_obstruction = kwargs.get('paralytic_ileus_and_intestinal_obstruction')
        self.vascular_intestinal_disorders = kwargs.get('vascular_intestinal_disorders')
        self.other_digestive_diseases = kwargs.get('other_digestive_diseases')
        self.mild_alzheimers_disease_and_other_dementias = kwargs.get('mild_alzheimers_disease_and_other_dementias')
        self.moderate_alzheimers_disease_and_other_dementias = kwargs.get('moderate_alzheimers_disease_and_other_dementias')
        self.severe_alzheimers_disease_and_other_dementias = kwargs.get('severe_alzheimers_disease_and_other_dementias')
        self.mild_parkinsons_disease = kwargs.get('mild_parkinsons_disease')
        self.moderate_parkinsons_disease = kwargs.get('moderate_parkinsons_disease')
        self.severe_parkinsons_disease = kwargs.get('severe_parkinsons_disease')
        self.idiopathic_seizure_free_treated_epilepsy = kwargs.get('idiopathic_seizure_free_treated_epilepsy')
        self.idiopathic_less_severe_epilepsy = kwargs.get('idiopathic_less_severe_epilepsy')
        self.idiopathic_severe_epilepsy = kwargs.get('idiopathic_severe_epilepsy')
        self.mild_multiple_sclerosis = kwargs.get('mild_multiple_sclerosis')
        self.moderate_multiple_sclerosis = kwargs.get('moderate_multiple_sclerosis')
        self.severe_multiple_sclerosis = kwargs.get('severe_multiple_sclerosis')
        self.other_neurological_disorders = kwargs.get('other_neurological_disorders')
        self.guillain_barre_syndrome_due_to_other_neurological_disorders = kwargs.get('guillain_barre_syndrome_due_to_other_neurological_disorders')
        self.schizophrenia_acute_state = kwargs.get('schizophrenia_acute_state')
        self.schizophrenia_residual_state = kwargs.get('schizophrenia_residual_state')
        self.mild_alcohol_dependence = kwargs.get('mild_alcohol_dependence')
        self.moderate_alcohol_dependence = kwargs.get('moderate_alcohol_dependence')
        self.severe_alcohol_dependence = kwargs.get('severe_alcohol_dependence')
        self.mild_fetal_alcohol_syndrome = kwargs.get('mild_fetal_alcohol_syndrome')
        self.moderate_fetal_alcohol_syndrome = kwargs.get('moderate_fetal_alcohol_syndrome')
        self.severe_fetal_alcohol_syndrome = kwargs.get('severe_fetal_alcohol_syndrome')
        self.other_drug_use_disorders = kwargs.get('other_drug_use_disorders')
        self.mild_major_depressive_disorder = kwargs.get('mild_major_depressive_disorder')
        self.moderate_major_depressive_disorder = kwargs.get('moderate_major_depressive_disorder')
        self.severe_major_depressive_disorder = kwargs.get('severe_major_depressive_disorder')
        self.bipolar_disorder_manic_state = kwargs.get('bipolar_disorder_manic_state')
        self.bipolar_disorder_residual_state = kwargs.get('bipolar_disorder_residual_state')
        self.mild_anxiety_disorders = kwargs.get('mild_anxiety_disorders')
        self.moderate_anxiety_disorders = kwargs.get('moderate_anxiety_disorders')
        self.severe_anxiety_disorders = kwargs.get('severe_anxiety_disorders')
        self.anorexia_nervosa = kwargs.get('anorexia_nervosa')
        self.bulimia_nervosa = kwargs.get('bulimia_nervosa')
        self.borderline_idiopathic_developmental_intellectual_disability = kwargs.get('borderline_idiopathic_developmental_intellectual_disability')
        self.mild_idiopathic_developmental_intellectual_disability = kwargs.get('mild_idiopathic_developmental_intellectual_disability')
        self.moderate_idiopathic_developmental_intellectual_disability = kwargs.get('moderate_idiopathic_developmental_intellectual_disability')
        self.severe_idiopathic_developmental_intellectual_disability = kwargs.get('severe_idiopathic_developmental_intellectual_disability')
        self.profound_idiopathic_developmental_intellectual_disability = kwargs.get('profound_idiopathic_developmental_intellectual_disability')
        self.mild_other_mental_disorders = kwargs.get('mild_other_mental_disorders')
        self.acute_glomerulonephritis = kwargs.get('acute_glomerulonephritis')
        self.end_stage_renal_disease_after_transplant_due_to_hypertension = kwargs.get('end_stage_renal_disease_after_transplant_due_to_hypertension')
        self.end_stage_renal_disease_after_transplant_due_to_glomerulonephritis = kwargs.get('end_stage_renal_disease_after_transplant_due_to_glomerulonephritis')
        self.end_stage_renal_disease_after_transplant_due_to_other_and_unspecified_causes = kwargs.get('end_stage_renal_disease_after_transplant_due_to_other_and_unspecified_causes')
        self.mild_urinary_tract_infections = kwargs.get('mild_urinary_tract_infections')
        self.moderate_urinary_tract_infections = kwargs.get('moderate_urinary_tract_infections')
        self.idiopathic_primary_male_infertility = kwargs.get('idiopathic_primary_male_infertility')
        self.idiopathic_secondary_male_infertility = kwargs.get('idiopathic_secondary_male_infertility')
        self.other_urinary_diseases = kwargs.get('other_urinary_diseases')
        self.primary_infertility_due_to_polycystic_ovarian_syndrome = kwargs.get('primary_infertility_due_to_polycystic_ovarian_syndrome')
        self.idiopathic_primary_female_infertility = kwargs.get('idiopathic_primary_female_infertility')
        self.idiopathic_secondary_female_infertility = kwargs.get('idiopathic_secondary_female_infertility')
        self.mild_abdominal_pain_due_to_endometriosis = kwargs.get('mild_abdominal_pain_due_to_endometriosis')
        self.moderate_abdominal_pain_due_to_endometriosis = kwargs.get('moderate_abdominal_pain_due_to_endometriosis')
        self.primary_infertility_due_to_endometriosis = kwargs.get('primary_infertility_due_to_endometriosis')
        self.secondary_infertility_due_to_endometriosis = kwargs.get('secondary_infertility_due_to_endometriosis')
        self.abdominal_pain_due_to_premenstrual_syndrome = kwargs.get('abdominal_pain_due_to_premenstrual_syndrome')
        self.mild_anemia_due_to_menstrual_disorders = kwargs.get('mild_anemia_due_to_menstrual_disorders')
        self.moderate_anemia_due_to_menstrual_disorders = kwargs.get('moderate_anemia_due_to_menstrual_disorders')
        self.severe_anemia_due_to_menstrual_disorders = kwargs.get('severe_anemia_due_to_menstrual_disorders')
        self.mild_heart_failure_due_to_thalassemias = kwargs.get('mild_heart_failure_due_to_thalassemias')
        self.moderate_heart_failure_due_to_thalassemias = kwargs.get('moderate_heart_failure_due_to_thalassemias')
        self.severe_heart_failure_due_to_thalassemias = kwargs.get('severe_heart_failure_due_to_thalassemias')
        self.mild_anemia_due_to_other_hemoglobinopathies_and_hemolytic_anemias = kwargs.get('mild_anemia_due_to_other_hemoglobinopathies_and_hemolytic_anemias')
        self.moderate_anemia_due_to_other_hemoglobinopathies_and_hemolytic_anemias = kwargs.get('moderate_anemia_due_to_other_hemoglobinopathies_and_hemolytic_anemias')
        self.severe_anemia_due_to_other_hemoglobinopathies_and_hemolytic_anemias = kwargs.get('severe_anemia_due_to_other_hemoglobinopathies_and_hemolytic_anemias')
        self.mild_heart_failure_due_to_other_hemoglobinopathies_and_hemolytic_anemias = kwargs.get('mild_heart_failure_due_to_other_hemoglobinopathies_and_hemolytic_anemias')
        self.moderate_heart_failure_due_to_other_hemoglobinopathies_and_hemolytic_anemias = kwargs.get('moderate_heart_failure_due_to_other_hemoglobinopathies_and_hemolytic_anemias')
        self.severe_heart_failure_due_to_other_hemoglobinopathies_and_hemolytic_anemias = kwargs.get('severe_heart_failure_due_to_other_hemoglobinopathies_and_hemolytic_anemias')
        self.mild_anemia_due_to_endocrine_metabolic_blood_and_immune_disorders = kwargs.get('mild_anemia_due_to_endocrine_metabolic_blood_and_immune_disorders')
        self.moderate_anemia_due_to_endocrine_metabolic_blood_and_immune_disorders = kwargs.get('moderate_anemia_due_to_endocrine_metabolic_blood_and_immune_disorders')
        self.severe_anemia_due_to_endocrine_metabolic_blood_and_immune_disorders = kwargs.get('severe_anemia_due_to_endocrine_metabolic_blood_and_immune_disorders')
        self.mild_heart_failure_due_to_endocrine_metabolic_blood_and_immune_disorders = kwargs.get('mild_heart_failure_due_to_endocrine_metabolic_blood_and_immune_disorders')
        self.moderate_heart_failure_due_to_endocrine_metabolic_blood_and_immune_disorders = kwargs.get('moderate_heart_failure_due_to_endocrine_metabolic_blood_and_immune_disorders')
        self.severe_heart_failure_due_to_endocrine_metabolic_blood_and_immune_disorders = kwargs.get('severe_heart_failure_due_to_endocrine_metabolic_blood_and_immune_disorders')
        self.mild_rheumatoid_arthritis = kwargs.get('mild_rheumatoid_arthritis')
        self.moderate_rheumatoid_arthritis = kwargs.get('moderate_rheumatoid_arthritis')
        self.severe_rheumatoid_arthritis = kwargs.get('severe_rheumatoid_arthritis')
        self.mild_osteoarthritis_of_the_hip = kwargs.get('mild_osteoarthritis_of_the_hip')
        self.moderate_osteoarthritis_of_the_hip = kwargs.get('moderate_osteoarthritis_of_the_hip')
        self.severe_osteoarthritis_of_the_hip = kwargs.get('severe_osteoarthritis_of_the_hip')
        self.mild_osteoarthritis_of_the_knee = kwargs.get('mild_osteoarthritis_of_the_knee')
        self.moderate_osteoarthritis_of_the_knee = kwargs.get('moderate_osteoarthritis_of_the_knee')
        self.severe_osteoarthritis_of_the_knee = kwargs.get('severe_osteoarthritis_of_the_knee')
        self.severe_low_back_pain_with_leg_pain = kwargs.get('severe_low_back_pain_with_leg_pain')
        self.severe_low_back_pain_without_leg_pain = kwargs.get('severe_low_back_pain_without_leg_pain')
        self.most_severe_low_back_pain_with_leg_pain = kwargs.get('most_severe_low_back_pain_with_leg_pain')
        self.most_severe_low_back_pain_without_leg_pain = kwargs.get('most_severe_low_back_pain_without_leg_pain')
        self.mild_neck_pain = kwargs.get('mild_neck_pain')
        self.severe_neck_pain = kwargs.get('severe_neck_pain')
        self.moderate_neck_pain = kwargs.get('moderate_neck_pain')
        self.most_severe_neck_pain = kwargs.get('most_severe_neck_pain')
        self.polyarticular_gout = kwargs.get('polyarticular_gout')
        self.other_musculoskeletal_disorders_severity_level_2 = kwargs.get('other_musculoskeletal_disorders_severity_level_2')
        self.other_musculoskeletal_disorders_severity_level_3 = kwargs.get('other_musculoskeletal_disorders_severity_level_3')
        self.other_musculoskeletal_disorders_severity_level_5 = kwargs.get('other_musculoskeletal_disorders_severity_level_5')
        self.other_musculoskeletal_disorders_severity_level_6 = kwargs.get('other_musculoskeletal_disorders_severity_level_6')
        self.other_musculoskeletal_disorders_severity_level_1 = kwargs.get('other_musculoskeletal_disorders_severity_level_1')
        self.other_musculoskeletal_disorders_severity_level_4 = kwargs.get('other_musculoskeletal_disorders_severity_level_4')
        self.congenital_heart_disease_due_to_turner_syndrome = kwargs.get('congenital_heart_disease_due_to_turner_syndrome')
        self.primary_infertility_due_to_turner_syndrome = kwargs.get('primary_infertility_due_to_turner_syndrome')
        self.borderline_intellectual_disability_due_to_klinefelter_syndrome = kwargs.get('borderline_intellectual_disability_due_to_klinefelter_syndrome')
        self.mild_intellectual_disability_due_to_klinefelter_syndrome = kwargs.get('mild_intellectual_disability_due_to_klinefelter_syndrome')
        self.mild_intellectual_disability_with_infertility_due_to_klinefelter_syndrome = kwargs.get('mild_intellectual_disability_with_infertility_due_to_klinefelter_syndrome')
        self.mild_hearing_loss_due_to_other_congenital_anomalies = kwargs.get('mild_hearing_loss_due_to_other_congenital_anomalies')
        self.mild_hearing_loss_with_ringing_due_to_other_congenital_anomalies = kwargs.get('mild_hearing_loss_with_ringing_due_to_other_congenital_anomalies')
        self.moderate_hearing_loss_due_to_other_congenital_anomalies = kwargs.get('moderate_hearing_loss_due_to_other_congenital_anomalies')
        self.moderate_hearing_loss_with_ringing_due_to_other_congenital_anomalies = kwargs.get('moderate_hearing_loss_with_ringing_due_to_other_congenital_anomalies')
        self.severe_hearing_loss_with_ringing_due_to_other_congenital_anomalies = kwargs.get('severe_hearing_loss_with_ringing_due_to_other_congenital_anomalies')
        self.severe_hearing_loss_due_to_other_congenital_anomalies = kwargs.get('severe_hearing_loss_due_to_other_congenital_anomalies')
        self.complete_hearing_loss_due_to_other_congenital_anomalies = kwargs.get('complete_hearing_loss_due_to_other_congenital_anomalies')
        self.complete_hearing_loss_with_ringing_due_to_other_congenital_anomalies = kwargs.get('complete_hearing_loss_with_ringing_due_to_other_congenital_anomalies')
        self.moderately_severe_hearing_loss_due_to_other_congenital_anomalies = kwargs.get('moderately_severe_hearing_loss_due_to_other_congenital_anomalies')
        self.moderately_severe_hearing_loss_with_ringing_due_to_other_congenital_anomalies = kwargs.get('moderately_severe_hearing_loss_with_ringing_due_to_other_congenital_anomalies')
        self.profound_hearing_loss_due_to_other_congenital_anomalies = kwargs.get('profound_hearing_loss_due_to_other_congenital_anomalies')
        self.profound_hearing_loss_with_ringing_due_to_other_congenital_anomalies = kwargs.get('profound_hearing_loss_with_ringing_due_to_other_congenital_anomalies')
        self.mild_atopic_dermatitis = kwargs.get('mild_atopic_dermatitis')
        self.moderate_atopic_dermatitis = kwargs.get('moderate_atopic_dermatitis')
        self.severe_atopic_dermatitis = kwargs.get('severe_atopic_dermatitis')
        self.mild_psoriasis = kwargs.get('mild_psoriasis')
        self.moderate_psoriasis = kwargs.get('moderate_psoriasis')
        self.severe_psoriasis = kwargs.get('severe_psoriasis')
        self.impetigo = kwargs.get('impetigo')
        self.abscess_and_other_bacterial_skin_diseases = kwargs.get('abscess_and_other_bacterial_skin_diseases')
        self.scabies = kwargs.get('scabies')
        self.tinea_capitis = kwargs.get('tinea_capitis')
        self.mild_viral_warts = kwargs.get('mild_viral_warts')
        self.severe_viral_warts = kwargs.get('severe_viral_warts')
        self.mild_alopecia_areata = kwargs.get('mild_alopecia_areata')
        self.severe_alopecia_areata = kwargs.get('severe_alopecia_areata')
        self.pruritus = kwargs.get('pruritus')
        self.mild_urticaria = kwargs.get('mild_urticaria')
        self.severe_urticaria = kwargs.get('severe_urticaria')
        self.mild_decubitus_ulcer = kwargs.get('mild_decubitus_ulcer')
        self.moderate_decubitus_ulcer = kwargs.get('moderate_decubitus_ulcer')
        self.severe_decubitus_ulcer = kwargs.get('severe_decubitus_ulcer')
        self.moderate_vision_impairment_due_to_glaucoma = kwargs.get('moderate_vision_impairment_due_to_glaucoma')
        self.severe_vision_impairment_due_to_glaucoma = kwargs.get('severe_vision_impairment_due_to_glaucoma')
        self.blindness_due_to_glaucoma = kwargs.get('blindness_due_to_glaucoma')
        self.moderate_vision_impairment_due_to_cataract = kwargs.get('moderate_vision_impairment_due_to_cataract')
        self.severe_vision_impairment_due_to_cataract = kwargs.get('severe_vision_impairment_due_to_cataract')
        self.blindness_due_to_cataract = kwargs.get('blindness_due_to_cataract')
        self.moderate_vision_impairment_due_to_macular_degeneration = kwargs.get('moderate_vision_impairment_due_to_macular_degeneration')
        self.severe_vision_impairment_due_to_macular_degeneration = kwargs.get('severe_vision_impairment_due_to_macular_degeneration')
        self.blindness_due_to_macular_degeneration = kwargs.get('blindness_due_to_macular_degeneration')
        self.moderate_vision_impairment_due_to_uncorrected_refractive_error = kwargs.get('moderate_vision_impairment_due_to_uncorrected_refractive_error')
        self.severe_vision_impairment_due_to_uncorrected_refractive_error = kwargs.get('severe_vision_impairment_due_to_uncorrected_refractive_error')
        self.blindness_due_to_uncorrected_refractive_error = kwargs.get('blindness_due_to_uncorrected_refractive_error')
        self.mild_hearing_loss_due_to_age_related_and_other_hearing_loss = kwargs.get('mild_hearing_loss_due_to_age_related_and_other_hearing_loss')
        self.mild_hearing_loss_with_ringing_due_to_age_related_and_other_hearing_loss = kwargs.get('mild_hearing_loss_with_ringing_due_to_age_related_and_other_hearing_loss')
        self.moderate_hearing_loss_due_to_age_related_and_other_hearing_loss = kwargs.get('moderate_hearing_loss_due_to_age_related_and_other_hearing_loss')
        self.moderate_hearing_loss_with_ringing_due_to_age_related_and_other_hearing_loss = kwargs.get('moderate_hearing_loss_with_ringing_due_to_age_related_and_other_hearing_loss')
        self.moderately_severe_hearing_loss_due_to_age_related_and_other_hearing_loss = kwargs.get('moderately_severe_hearing_loss_due_to_age_related_and_other_hearing_loss')
        self.moderately_severe_hearing_loss_with_ringing_due_to_age_related_and_other_hearing_loss = kwargs.get('moderately_severe_hearing_loss_with_ringing_due_to_age_related_and_other_hearing_loss')
        self.severe_hearing_loss_with_ringing_due_to_age_related_and_other_hearing_loss = kwargs.get('severe_hearing_loss_with_ringing_due_to_age_related_and_other_hearing_loss')
        self.severe_hearing_loss_due_to_age_related_and_other_hearing_loss = kwargs.get('severe_hearing_loss_due_to_age_related_and_other_hearing_loss')
        self.profound_hearing_loss_due_to_age_related_and_other_hearing_loss = kwargs.get('profound_hearing_loss_due_to_age_related_and_other_hearing_loss')
        self.profound_hearing_loss_with_ringing_due_to_age_related_and_other_hearing_loss = kwargs.get('profound_hearing_loss_with_ringing_due_to_age_related_and_other_hearing_loss')
        self.complete_hearing_loss_due_to_age_related_and_other_hearing_loss = kwargs.get('complete_hearing_loss_due_to_age_related_and_other_hearing_loss')
        self.complete_hearing_loss_with_ringing_due_to_age_related_and_other_hearing_loss = kwargs.get('complete_hearing_loss_with_ringing_due_to_age_related_and_other_hearing_loss')
        self.moderate_vision_impairment_due_to_other_vision_loss = kwargs.get('moderate_vision_impairment_due_to_other_vision_loss')
        self.severe_vision_impairment_due_to_other_vision_loss = kwargs.get('severe_vision_impairment_due_to_other_vision_loss')
        self.blindness_due_to_other_vision_loss = kwargs.get('blindness_due_to_other_vision_loss')
        self.bipolar_disorder_depressive_state = kwargs.get('bipolar_disorder_depressive_state')
        self.mild_anemia_due_to_b_thalassemia_trait = kwargs.get('mild_anemia_due_to_b_thalassemia_trait')
        self.moderate_anemia_due_to_b_thalassemia_trait = kwargs.get('moderate_anemia_due_to_b_thalassemia_trait')
        self.severe_anemia_due_to_b_thalassemia_trait = kwargs.get('severe_anemia_due_to_b_thalassemia_trait')
        self.mild_anemia_due_to_hemoglobin_e_trait = kwargs.get('mild_anemia_due_to_hemoglobin_e_trait')
        self.moderate_anemia_due_to_hemoglobin_e_trait = kwargs.get('moderate_anemia_due_to_hemoglobin_e_trait')
        self.severe_anemia_due_to_hemoglobin_e_trait = kwargs.get('severe_anemia_due_to_hemoglobin_e_trait')
        self.mild_anemia_due_to_sickle_cell_trait = kwargs.get('mild_anemia_due_to_sickle_cell_trait')
        self.moderate_anemia_due_to_sickle_cell_trait = kwargs.get('moderate_anemia_due_to_sickle_cell_trait')
        self.severe_anemia_due_to_sickle_cell_trait = kwargs.get('severe_anemia_due_to_sickle_cell_trait')
        self.mild_anemia_due_to_hemizygous_g6pd_trait = kwargs.get('mild_anemia_due_to_hemizygous_g6pd_trait')
        self.moderate_anemia_due_to_hemizygous_g6pd_trait = kwargs.get('moderate_anemia_due_to_hemizygous_g6pd_trait')
        self.severe_anemia_due_to_hemizygous_g6pd_trait = kwargs.get('severe_anemia_due_to_hemizygous_g6pd_trait')
        self.disfigurement_due_to_basal_cell_carcinoma = kwargs.get('disfigurement_due_to_basal_cell_carcinoma')
        self.severe_skin_disease_due_to_onchocerciasis = kwargs.get('severe_skin_disease_due_to_onchocerciasis')
        self.mild_contact_dermatitis = kwargs.get('mild_contact_dermatitis')
        self.moderate_contact_dermatitis = kwargs.get('moderate_contact_dermatitis')
        self.symptomatic_seborrhoeic_dermatitis = kwargs.get('symptomatic_seborrhoeic_dermatitis')
        self.pain_due_to_caries_of_deciduous_teeth = kwargs.get('pain_due_to_caries_of_deciduous_teeth')
        self.pain_due_to_caries_of_permanent_teeth = kwargs.get('pain_due_to_caries_of_permanent_teeth')
        self.difficulty_eating_due_to_edentulism_and_severe_tooth_loss = kwargs.get('difficulty_eating_due_to_edentulism_and_severe_tooth_loss')
        self.mild_diarrheal_diseases = kwargs.get('mild_diarrheal_diseases')
        self.moderate_diarrheal_diseases = kwargs.get('moderate_diarrheal_diseases')
        self.severe_diarrheal_diseases = kwargs.get('severe_diarrheal_diseases')
        self.guillain_barre_syndrome_due_to_diarrheal_diseases = kwargs.get('guillain_barre_syndrome_due_to_diarrheal_diseases')
        self.moderate_lower_respiratory_infections = kwargs.get('moderate_lower_respiratory_infections')
        self.severe_lower_respiratory_infections = kwargs.get('severe_lower_respiratory_infections')
        self.guillain_barre_syndrome_due_to_lower_respiratory_infections = kwargs.get('guillain_barre_syndrome_due_to_lower_respiratory_infections')
        self.other_fungal_skin_diseases = kwargs.get('other_fungal_skin_diseases')
        self.mild_skin_disease_without_itch_due_to_onchocerciasis = kwargs.get('mild_skin_disease_without_itch_due_to_onchocerciasis')
        self.severe_skin_disease_without_itch_due_to_onchocerciasis = kwargs.get('severe_skin_disease_without_itch_due_to_onchocerciasis')
        self.infertility_due_to_puerperal_sepsis = kwargs.get('infertility_due_to_puerperal_sepsis')
        self.other_hypertensive_disorders_of_pregnancy = kwargs.get('other_hypertensive_disorders_of_pregnancy')
        self.long_term_sequelae_of_eclampsia = kwargs.get('long_term_sequelae_of_eclampsia')
        self.very_mild_alcohol_dependence = kwargs.get('very_mild_alcohol_dependence')
        self.mild_amphetamine_dependence = kwargs.get('mild_amphetamine_dependence')
        self.moderate_other_mental_disorders = kwargs.get('moderate_other_mental_disorders')
        self.severe_other_mental_disorders = kwargs.get('severe_other_mental_disorders')
        self.mild_low_back_pain_with_leg_pain = kwargs.get('mild_low_back_pain_with_leg_pain')
        self.mild_low_back_pain_without_leg_pain = kwargs.get('mild_low_back_pain_without_leg_pain')
        self.moderate_low_back_pain_with_leg_pain = kwargs.get('moderate_low_back_pain_with_leg_pain')
        self.moderate_low_back_pain_without_leg_pain = kwargs.get('moderate_low_back_pain_without_leg_pain')
        self.mild_cannabis_dependence = kwargs.get('mild_cannabis_dependence')
        self.mild_cocaine_dependence = kwargs.get('mild_cocaine_dependence')
        self.congenital_heart_disease_with_infertility_due_to_turner_syndrome = kwargs.get('congenital_heart_disease_with_infertility_due_to_turner_syndrome')
        self.neurocysticercosis_with_epilepsy = kwargs.get('neurocysticercosis_with_epilepsy')
        self.mild_opioid_dependence = kwargs.get('mild_opioid_dependence')
        self.borderline_intellectual_disability_with_infertility_due_to_klinefelter_syndrome = kwargs.get('borderline_intellectual_disability_with_infertility_due_to_klinefelter_syndrome')
        self.depression_due_to_premenstrual_syndrome = kwargs.get('depression_due_to_premenstrual_syndrome')
        self.moderate_motor_plus_cognitive_impairment_with_blindness_due_to_hemolytic_disease_and_other_neonatal_jaundice = kwargs.get('moderate_motor_plus_cognitive_impairment_with_blindness_due_to_hemolytic_disease_and_other_neonatal_jaundice')
        self.moderate_motor_plus_cognitive_impairment_with_blindness_due_to_neonatal_preterm_birth_complications_28_32wks = kwargs.get('moderate_motor_plus_cognitive_impairment_with_blindness_due_to_neonatal_preterm_birth_complications_28_32wks')
        self.moderate_motor_plus_cognitive_impairment_with_blindness_due_to_neonatal_preterm_birth_complications_less_than_28wks = kwargs.get('moderate_motor_plus_cognitive_impairment_with_blindness_due_to_neonatal_preterm_birth_complications_less_than_28wks')
        self.moderate_motor_plus_cognitive_impairment_with_blindness_due_to_neonatal_preterm_birth_complications_32_36wks = kwargs.get('moderate_motor_plus_cognitive_impairment_with_blindness_due_to_neonatal_preterm_birth_complications_32_36wks')
        self.moderate_motor_plus_cognitive_impairment_with_blindness_due_to_neonatal_encephalopathy_due_to_birth_asphyxia_and_trauma = kwargs.get('moderate_motor_plus_cognitive_impairment_with_blindness_due_to_neonatal_encephalopathy_due_to_birth_asphyxia_and_trauma')
        self.moderate_motor_plus_cognitive_impairment_with_blindness_due_to_neonatal_tetanus = kwargs.get('moderate_motor_plus_cognitive_impairment_with_blindness_due_to_neonatal_tetanus')
        self.moderate_motor_plus_cognitive_impairment_with_blindness_and_epilepsy_due_to_neonatal_preterm_birth_complications_32_36wks = kwargs.get('moderate_motor_plus_cognitive_impairment_with_blindness_and_epilepsy_due_to_neonatal_preterm_birth_complications_32_36wks')
        self.moderate_motor_plus_cognitive_impairment_with_blindness_and_epilepsy_due_to_neonatal_preterm_birth_complications_less_than_28wks = kwargs.get('moderate_motor_plus_cognitive_impairment_with_blindness_and_epilepsy_due_to_neonatal_preterm_birth_complications_less_than_28wks')
        self.moderate_motor_plus_cognitive_impairment_with_blindness_and_epilepsy_due_to_neonatal_preterm_birth_complications_28_32wks = kwargs.get('moderate_motor_plus_cognitive_impairment_with_blindness_and_epilepsy_due_to_neonatal_preterm_birth_complications_28_32wks')
        self.moderate_motor_plus_cognitive_impairment_with_blindness_and_epilepsy_due_to_neonatal_tetanus = kwargs.get('moderate_motor_plus_cognitive_impairment_with_blindness_and_epilepsy_due_to_neonatal_tetanus')
        self.moderate_motor_plus_cognitive_impairment_with_blindness_and_epilepsy_due_to_hemolytic_disease_and_other_neonatal_jaundice = kwargs.get('moderate_motor_plus_cognitive_impairment_with_blindness_and_epilepsy_due_to_hemolytic_disease_and_other_neonatal_jaundice')
        self.moderate_motor_plus_cognitive_impairment_with_blindness_and_epilepsy_due_to_neonatal_encephalopathy_due_to_birth_asphyxia_and_trauma = kwargs.get('moderate_motor_plus_cognitive_impairment_with_blindness_and_epilepsy_due_to_neonatal_encephalopathy_due_to_birth_asphyxia_and_trauma')
        self.moderate_motor_plus_cognitive_impairment_with_epilepsy_due_to_neonatal_preterm_birth_complications_32_36wks = kwargs.get('moderate_motor_plus_cognitive_impairment_with_epilepsy_due_to_neonatal_preterm_birth_complications_32_36wks')
        self.moderate_motor_plus_cognitive_impairment_with_epilepsy_due_to_neonatal_tetanus = kwargs.get('moderate_motor_plus_cognitive_impairment_with_epilepsy_due_to_neonatal_tetanus')
        self.moderate_motor_plus_cognitive_impairment_with_epilepsy_due_to_hemolytic_disease_and_other_neonatal_jaundice = kwargs.get('moderate_motor_plus_cognitive_impairment_with_epilepsy_due_to_hemolytic_disease_and_other_neonatal_jaundice')
        self.moderate_motor_plus_cognitive_impairment_with_epilepsy_due_to_neonatal_encephalopathy_due_to_birth_asphyxia_and_trauma = kwargs.get('moderate_motor_plus_cognitive_impairment_with_epilepsy_due_to_neonatal_encephalopathy_due_to_birth_asphyxia_and_trauma')
        self.moderate_motor_plus_cognitive_impairment_with_epilepsy_due_to_neonatal_preterm_birth_complications_less_than_28wks = kwargs.get('moderate_motor_plus_cognitive_impairment_with_epilepsy_due_to_neonatal_preterm_birth_complications_less_than_28wks')
        self.moderate_motor_plus_cognitive_impairment_with_epilepsy_due_to_neonatal_preterm_birth_complications_28_32wks = kwargs.get('moderate_motor_plus_cognitive_impairment_with_epilepsy_due_to_neonatal_preterm_birth_complications_28_32wks')
        self.severe_motor_plus_cognitive_impairment_with_blindness_due_to_neonatal_tetanus = kwargs.get('severe_motor_plus_cognitive_impairment_with_blindness_due_to_neonatal_tetanus')
        self.severe_motor_plus_cognitive_impairment_with_blindness_due_to_neonatal_preterm_birth_complications_28_32wks = kwargs.get('severe_motor_plus_cognitive_impairment_with_blindness_due_to_neonatal_preterm_birth_complications_28_32wks')
        self.severe_motor_plus_cognitive_impairment_with_blindness_due_to_neonatal_preterm_birth_complications_32_36wks = kwargs.get('severe_motor_plus_cognitive_impairment_with_blindness_due_to_neonatal_preterm_birth_complications_32_36wks')
        self.severe_motor_plus_cognitive_impairment_with_blindness_due_to_hemolytic_disease_and_other_neonatal_jaundice = kwargs.get('severe_motor_plus_cognitive_impairment_with_blindness_due_to_hemolytic_disease_and_other_neonatal_jaundice')
        self.severe_motor_plus_cognitive_impairment_with_blindness_due_to_neonatal_encephalopathy_due_to_birth_asphyxia_and_trauma = kwargs.get('severe_motor_plus_cognitive_impairment_with_blindness_due_to_neonatal_encephalopathy_due_to_birth_asphyxia_and_trauma')
        self.severe_motor_plus_cognitive_impairment_with_blindness_due_to_neonatal_preterm_birth_complications_less_than_28wks = kwargs.get('severe_motor_plus_cognitive_impairment_with_blindness_due_to_neonatal_preterm_birth_complications_less_than_28wks')
        self.severe_motor_plus_cognitive_impairment_with_blindness_and_epilepsy_due_to_neonatal_preterm_birth_complications_28_32wks = kwargs.get('severe_motor_plus_cognitive_impairment_with_blindness_and_epilepsy_due_to_neonatal_preterm_birth_complications_28_32wks')
        self.severe_motor_plus_cognitive_impairment_with_blindness_and_epilepsy_due_to_neonatal_preterm_birth_complications_less_than_28wks = kwargs.get('severe_motor_plus_cognitive_impairment_with_blindness_and_epilepsy_due_to_neonatal_preterm_birth_complications_less_than_28wks')
        self.severe_motor_plus_cognitive_impairment_with_blindness_and_epilepsy_due_to_hemolytic_disease_and_other_neonatal_jaundice = kwargs.get('severe_motor_plus_cognitive_impairment_with_blindness_and_epilepsy_due_to_hemolytic_disease_and_other_neonatal_jaundice')
        self.severe_motor_plus_cognitive_impairment_with_blindness_and_epilepsy_due_to_neonatal_encephalopathy_due_to_birth_asphyxia_and_trauma = kwargs.get('severe_motor_plus_cognitive_impairment_with_blindness_and_epilepsy_due_to_neonatal_encephalopathy_due_to_birth_asphyxia_and_trauma')
        self.severe_motor_plus_cognitive_impairment_with_blindness_and_epilepsy_due_to_neonatal_preterm_birth_complications_32_36wks = kwargs.get('severe_motor_plus_cognitive_impairment_with_blindness_and_epilepsy_due_to_neonatal_preterm_birth_complications_32_36wks')
        self.severe_motor_plus_cognitive_impairment_with_blindness_and_epilepsy_due_to_neonatal_tetanus = kwargs.get('severe_motor_plus_cognitive_impairment_with_blindness_and_epilepsy_due_to_neonatal_tetanus')
        self.severe_motor_plus_cognitive_impairment_with_epilepsy_due_to_neonatal_preterm_birth_complications_less_than_28wks = kwargs.get('severe_motor_plus_cognitive_impairment_with_epilepsy_due_to_neonatal_preterm_birth_complications_less_than_28wks')
        self.severe_motor_plus_cognitive_impairment_with_epilepsy_due_to_neonatal_encephalopathy_due_to_birth_asphyxia_and_trauma = kwargs.get('severe_motor_plus_cognitive_impairment_with_epilepsy_due_to_neonatal_encephalopathy_due_to_birth_asphyxia_and_trauma')
        self.severe_motor_plus_cognitive_impairment_with_epilepsy_due_to_hemolytic_disease_and_other_neonatal_jaundice = kwargs.get('severe_motor_plus_cognitive_impairment_with_epilepsy_due_to_hemolytic_disease_and_other_neonatal_jaundice')
        self.severe_motor_plus_cognitive_impairment_with_epilepsy_due_to_neonatal_preterm_birth_complications_32_36wks = kwargs.get('severe_motor_plus_cognitive_impairment_with_epilepsy_due_to_neonatal_preterm_birth_complications_32_36wks')
        self.severe_motor_plus_cognitive_impairment_with_epilepsy_due_to_neonatal_preterm_birth_complications_28_32wks = kwargs.get('severe_motor_plus_cognitive_impairment_with_epilepsy_due_to_neonatal_preterm_birth_complications_28_32wks')
        self.severe_motor_plus_cognitive_impairment_with_epilepsy_due_to_neonatal_tetanus = kwargs.get('severe_motor_plus_cognitive_impairment_with_epilepsy_due_to_neonatal_tetanus')
        self.moderate_motor_impairment_due_to_neonatal_tetanus = kwargs.get('moderate_motor_impairment_due_to_neonatal_tetanus')
        self.moderate_motor_impairment_due_to_hemolytic_disease_and_other_neonatal_jaundice = kwargs.get('moderate_motor_impairment_due_to_hemolytic_disease_and_other_neonatal_jaundice')
        self.moderate_motor_impairment_due_to_neonatal_preterm_birth_complications_28_32wks = kwargs.get('moderate_motor_impairment_due_to_neonatal_preterm_birth_complications_28_32wks')
        self.moderate_motor_impairment_due_to_neonatal_encephalopathy_due_to_birth_asphyxia_and_trauma = kwargs.get('moderate_motor_impairment_due_to_neonatal_encephalopathy_due_to_birth_asphyxia_and_trauma')
        self.moderate_motor_impairment_due_to_neonatal_preterm_birth_complications_less_than_28wks = kwargs.get('moderate_motor_impairment_due_to_neonatal_preterm_birth_complications_less_than_28wks')
        self.moderate_motor_impairment_due_to_neonatal_preterm_birth_complications_32_36wks = kwargs.get('moderate_motor_impairment_due_to_neonatal_preterm_birth_complications_32_36wks')
        self.moderate_motor_impairment_with_blindness_due_to_neonatal_preterm_birth_complications_less_than_28wks = kwargs.get('moderate_motor_impairment_with_blindness_due_to_neonatal_preterm_birth_complications_less_than_28wks')
        self.moderate_motor_impairment_with_blindness_due_to_neonatal_preterm_birth_complications_28_32wks = kwargs.get('moderate_motor_impairment_with_blindness_due_to_neonatal_preterm_birth_complications_28_32wks')
        self.moderate_motor_impairment_with_blindness_due_to_neonatal_preterm_birth_complications_32_36wks = kwargs.get('moderate_motor_impairment_with_blindness_due_to_neonatal_preterm_birth_complications_32_36wks')
        self.moderate_motor_impairment_with_blindness_due_to_neonatal_tetanus = kwargs.get('moderate_motor_impairment_with_blindness_due_to_neonatal_tetanus')
        self.moderate_motor_impairment_with_blindness_due_to_neonatal_encephalopathy_due_to_birth_asphyxia_and_trauma = kwargs.get('moderate_motor_impairment_with_blindness_due_to_neonatal_encephalopathy_due_to_birth_asphyxia_and_trauma')
        self.moderate_motor_impairment_with_blindness_due_to_hemolytic_disease_and_other_neonatal_jaundice = kwargs.get('moderate_motor_impairment_with_blindness_due_to_hemolytic_disease_and_other_neonatal_jaundice')
        self.moderate_motor_impairment_with_blindness_and_epilepsy_due_to_hemolytic_disease_and_other_neonatal_jaundice = kwargs.get('moderate_motor_impairment_with_blindness_and_epilepsy_due_to_hemolytic_disease_and_other_neonatal_jaundice')
        self.moderate_motor_impairment_with_blindness_and_epilepsy_due_to_neonatal_encephalopathy_due_to_birth_asphyxia_and_trauma = kwargs.get('moderate_motor_impairment_with_blindness_and_epilepsy_due_to_neonatal_encephalopathy_due_to_birth_asphyxia_and_trauma')
        self.moderate_motor_impairment_with_blindness_and_epilepsy_due_to_neonatal_preterm_birth_complications_32_36wks = kwargs.get('moderate_motor_impairment_with_blindness_and_epilepsy_due_to_neonatal_preterm_birth_complications_32_36wks')
        self.moderate_motor_impairment_with_blindness_and_epilepsy_due_to_neonatal_preterm_birth_complications_28_32wks = kwargs.get('moderate_motor_impairment_with_blindness_and_epilepsy_due_to_neonatal_preterm_birth_complications_28_32wks')
        self.moderate_motor_impairment_with_blindness_and_epilepsy_due_to_neonatal_preterm_birth_complications_less_than_28wks = kwargs.get('moderate_motor_impairment_with_blindness_and_epilepsy_due_to_neonatal_preterm_birth_complications_less_than_28wks')
        self.moderate_motor_impairment_with_blindness_and_epilepsy_due_to_neonatal_tetanus = kwargs.get('moderate_motor_impairment_with_blindness_and_epilepsy_due_to_neonatal_tetanus')
        self.moderate_motor_impairment_with_epilepsy_due_to_neonatal_preterm_birth_complications_32_36wks = kwargs.get('moderate_motor_impairment_with_epilepsy_due_to_neonatal_preterm_birth_complications_32_36wks')
        self.moderate_motor_impairment_with_epilepsy_due_to_neonatal_tetanus = kwargs.get('moderate_motor_impairment_with_epilepsy_due_to_neonatal_tetanus')
        self.moderate_motor_impairment_with_epilepsy_due_to_neonatal_preterm_birth_complications_28_32wks = kwargs.get('moderate_motor_impairment_with_epilepsy_due_to_neonatal_preterm_birth_complications_28_32wks')
        self.moderate_motor_impairment_with_epilepsy_due_to_neonatal_encephalopathy_due_to_birth_asphyxia_and_trauma = kwargs.get('moderate_motor_impairment_with_epilepsy_due_to_neonatal_encephalopathy_due_to_birth_asphyxia_and_trauma')
        self.moderate_motor_impairment_with_epilepsy_due_to_neonatal_preterm_birth_complications_less_than_28wks = kwargs.get('moderate_motor_impairment_with_epilepsy_due_to_neonatal_preterm_birth_complications_less_than_28wks')
        self.moderate_motor_impairment_with_epilepsy_due_to_hemolytic_disease_and_other_neonatal_jaundice = kwargs.get('moderate_motor_impairment_with_epilepsy_due_to_hemolytic_disease_and_other_neonatal_jaundice')
        self.severe_motor_impairment_due_to_neonatal_encephalopathy_due_to_birth_asphyxia_and_trauma = kwargs.get('severe_motor_impairment_due_to_neonatal_encephalopathy_due_to_birth_asphyxia_and_trauma')
        self.severe_motor_impairment_severe_due_to_hemolytic_disease_and_other_neonatal_jaundice = kwargs.get('severe_motor_impairment_severe_due_to_hemolytic_disease_and_other_neonatal_jaundice')
        self.severe_motor_impairment_due_to_neonatal_preterm_birth_complications_less_than_28wks = kwargs.get('severe_motor_impairment_due_to_neonatal_preterm_birth_complications_less_than_28wks')
        self.severe_motor_impairment_due_to_neonatal_preterm_birth_complications_32_36wks = kwargs.get('severe_motor_impairment_due_to_neonatal_preterm_birth_complications_32_36wks')
        self.severe_motor_impairment_due_to_neonatal_preterm_birth_complications_28_32wks = kwargs.get('severe_motor_impairment_due_to_neonatal_preterm_birth_complications_28_32wks')
        self.severe_motor_impairment_due_to_neonatal_tetanus = kwargs.get('severe_motor_impairment_due_to_neonatal_tetanus')
        self.severe_motor_impairment_with_blindness_due_to_neonatal_preterm_birth_complications_28_32wks = kwargs.get('severe_motor_impairment_with_blindness_due_to_neonatal_preterm_birth_complications_28_32wks')
        self.severe_motor_impairment_with_blindness_due_to_neonatal_tetanus = kwargs.get('severe_motor_impairment_with_blindness_due_to_neonatal_tetanus')
        self.severe_motor_impairment_with_blindness_due_to_hemolytic_disease_and_other_neonatal_jaundice = kwargs.get('severe_motor_impairment_with_blindness_due_to_hemolytic_disease_and_other_neonatal_jaundice')
        self.severe_motor_impairment_with_blindness_due_to_neonatal_preterm_birth_complications_less_than_28wks = kwargs.get('severe_motor_impairment_with_blindness_due_to_neonatal_preterm_birth_complications_less_than_28wks')
        self.severe_motor_impairment_with_blindness_due_to_neonatal_preterm_birth_complications_32_36wks = kwargs.get('severe_motor_impairment_with_blindness_due_to_neonatal_preterm_birth_complications_32_36wks')
        self.severe_motor_impairment_with_blindness_due_to_neonatal_encephalopathy_due_to_birth_asphyxia_and_trauma = kwargs.get('severe_motor_impairment_with_blindness_due_to_neonatal_encephalopathy_due_to_birth_asphyxia_and_trauma')
        self.severe_motor_impairment_with_blindness_and_epilepsy_due_to_neonatal_tetanus = kwargs.get('severe_motor_impairment_with_blindness_and_epilepsy_due_to_neonatal_tetanus')
        self.severe_motor_impairment_with_blindness_and_epilepsy_due_to_neonatal_preterm_birth_complications_less_than_28wks = kwargs.get('severe_motor_impairment_with_blindness_and_epilepsy_due_to_neonatal_preterm_birth_complications_less_than_28wks')
        self.severe_motor_impairment_with_blindness_and_epilepsy_due_to_neonatal_preterm_birth_complications_28_32wks = kwargs.get('severe_motor_impairment_with_blindness_and_epilepsy_due_to_neonatal_preterm_birth_complications_28_32wks')
        self.severe_motor_impairment_with_blindness_and_epilepsy_due_to_hemolytic_disease_and_other_neonatal_jaundice = kwargs.get('severe_motor_impairment_with_blindness_and_epilepsy_due_to_hemolytic_disease_and_other_neonatal_jaundice')
        self.severe_motor_impairment_with_blindness_and_epilepsy_due_to_neonatal_preterm_birth_complications_32_36wks = kwargs.get('severe_motor_impairment_with_blindness_and_epilepsy_due_to_neonatal_preterm_birth_complications_32_36wks')
        self.severe_motor_impairment_with_blindness_and_epilepsy_due_to_neonatal_encephalopathy_due_to_birth_asphyxia_and_trauma = kwargs.get('severe_motor_impairment_with_blindness_and_epilepsy_due_to_neonatal_encephalopathy_due_to_birth_asphyxia_and_trauma')
        self.severe_motor_impairment_with_epilepsy_due_to_neonatal_encephalopathy_due_to_birth_asphyxia_and_trauma = kwargs.get('severe_motor_impairment_with_epilepsy_due_to_neonatal_encephalopathy_due_to_birth_asphyxia_and_trauma')
        self.severe_motor_impairment_with_epilepsy_due_to_neonatal_preterm_birth_complications_32_36wks = kwargs.get('severe_motor_impairment_with_epilepsy_due_to_neonatal_preterm_birth_complications_32_36wks')
        self.severe_motor_impairment_with_epilepsy_due_to_neonatal_tetanus = kwargs.get('severe_motor_impairment_with_epilepsy_due_to_neonatal_tetanus')
        self.severe_motor_impairment_with_epilepsy_due_to_neonatal_preterm_birth_complications_less_than_28wks = kwargs.get('severe_motor_impairment_with_epilepsy_due_to_neonatal_preterm_birth_complications_less_than_28wks')
        self.severe_motor_impairment_with_epilepsy_due_to_neonatal_preterm_birth_complications_28_32wks = kwargs.get('severe_motor_impairment_with_epilepsy_due_to_neonatal_preterm_birth_complications_28_32wks')
        self.severe_motor_impairment_with_epilepsy_due_to_hemolytic_disease_and_other_neonatal_jaundice = kwargs.get('severe_motor_impairment_with_epilepsy_due_to_hemolytic_disease_and_other_neonatal_jaundice')
        self.mild_motor_impairment_due_to_neonatal_tetanus = kwargs.get('mild_motor_impairment_due_to_neonatal_tetanus')
        self.mild_motor_plus_cognitive_impairments_due_to_neonatal_tetanus = kwargs.get('mild_motor_plus_cognitive_impairments_due_to_neonatal_tetanus')
        self.epilepsy_due_to_echinococcosis = kwargs.get('epilepsy_due_to_echinococcosis')
        self.symptomatic_genital_herpes = kwargs.get('symptomatic_genital_herpes')
        self.other_hemoglobinopathies_and_hemolytic_anemias_residual = kwargs.get('other_hemoglobinopathies_and_hemolytic_anemias_residual')
        self.mild_behavioral_problems_due_to_encephalitis = kwargs.get('mild_behavioral_problems_due_to_encephalitis')
        self.mild_motor_impairment_due_to_long_term_due_to_encephalitis = kwargs.get('mild_motor_impairment_due_to_long_term_due_to_encephalitis')
        self.mild_motor_plus_cognitive_impairments_due_to_encephalitis = kwargs.get('mild_motor_plus_cognitive_impairments_due_to_encephalitis')
        self.borderline_intellectual_disability_due_to_encephalitis = kwargs.get('borderline_intellectual_disability_due_to_encephalitis')
        self.monocular_distance_vision_loss_due_to_encephalitis = kwargs.get('monocular_distance_vision_loss_due_to_encephalitis')
        self.mild_intellectual_disability_due_to_encephalitis = kwargs.get('mild_intellectual_disability_due_to_encephalitis')
        self.moderate_motor_impairment_due_to_encephalitis = kwargs.get('moderate_motor_impairment_due_to_encephalitis')
        self.severe_motor_impairment_due_to_encephalitis = kwargs.get('severe_motor_impairment_due_to_encephalitis')
        self.moderate_motor_plus_cognitive_impairments_due_to_encephalitis = kwargs.get('moderate_motor_plus_cognitive_impairments_due_to_encephalitis')
        self.severe_motor_plus_cognitive_impairments_due_to_encephalitis = kwargs.get('severe_motor_plus_cognitive_impairments_due_to_encephalitis')
        self.epilepsy_due_to_encephalitis = kwargs.get('epilepsy_due_to_encephalitis')
        self.severe_opioid_dependence = kwargs.get('severe_opioid_dependence')
        self.severe_cocaine_dependence = kwargs.get('severe_cocaine_dependence')
        self.severe_amphetamine_dependence = kwargs.get('severe_amphetamine_dependence')
        self.severe_cannabis_dependence = kwargs.get('severe_cannabis_dependence')
        self.other_sexually_transmitted_diseases_residual = kwargs.get('other_sexually_transmitted_diseases_residual')
        self.asymptomatic_atrial_fibrillation_and_flutter = kwargs.get('asymptomatic_atrial_fibrillation_and_flutter')
        self.symptomatic_attention_deficit_hyperactivity_disorder = kwargs.get('symptomatic_attention_deficit_hyperactivity_disorder')
        self.attention_deficit_hyperactivity_disorder_currently_without_symptoms = kwargs.get('attention_deficit_hyperactivity_disorder_currently_without_symptoms')
        self.asymptomatic_alcohol_dependence = kwargs.get('asymptomatic_alcohol_dependence')
        self.asymptomatic_fetal_alcohol_syndrome = kwargs.get('asymptomatic_fetal_alcohol_syndrome')
        self.anxiety_disorders_currently_without_symptoms = kwargs.get('anxiety_disorders_currently_without_symptoms')
        self.symptomatic_conduct_disorder = kwargs.get('symptomatic_conduct_disorder')
        self.conduct_disorder_currently_without_symptoms = kwargs.get('conduct_disorder_currently_without_symptoms')
        self.asymptomatic_cannabis_dependence = kwargs.get('asymptomatic_cannabis_dependence')
        self.asymptomatic_opioid_dependence = kwargs.get('asymptomatic_opioid_dependence')
        self.asymptomatic_cocaine_dependence = kwargs.get('asymptomatic_cocaine_dependence')
        self.symptomatic_dysthymia = kwargs.get('symptomatic_dysthymia')
        self.dysthymia_currently_without_symptoms = kwargs.get('dysthymia_currently_without_symptoms')
        self.major_depressive_disorder_currently_without_symptoms = kwargs.get('major_depressive_disorder_currently_without_symptoms')
        self.symptomatic_episodes_of_gout = kwargs.get('symptomatic_episodes_of_gout')
        self.asymptomatic_gout = kwargs.get('asymptomatic_gout')
        self.severe_infectious_complications_due_to_chronic_otitis_media = kwargs.get('severe_infectious_complications_due_to_chronic_otitis_media')
        self.asymptomatic_asthma = kwargs.get('asymptomatic_asthma')
        self.asymptomatic_genital_herpes = kwargs.get('asymptomatic_genital_herpes')
        self.asymptomatic_endometriosis = kwargs.get('asymptomatic_endometriosis')
        self.asymptomatic_amphetamine_dependence = kwargs.get('asymptomatic_amphetamine_dependence')
        self.isolated_congenital_heart_disease_due_to_down_syndrome = kwargs.get('isolated_congenital_heart_disease_due_to_down_syndrome')
        self.asymptomatic_other_cardiovascular_diseases = kwargs.get('asymptomatic_other_cardiovascular_diseases')
        self.mild_other_cardiovascular_diseases = kwargs.get('mild_other_cardiovascular_diseases')
        self.moderate_other_cardiovascular_diseases = kwargs.get('moderate_other_cardiovascular_diseases')
        self.severe_other_cardiovascular_diseases = kwargs.get('severe_other_cardiovascular_diseases')
        self.asymptomatic_other_gynecological_disorders = kwargs.get('asymptomatic_other_gynecological_disorders')
        self.mild_other_gynecological_disorders = kwargs.get('mild_other_gynecological_disorders')
        self.moderate_other_gynecological_disorders = kwargs.get('moderate_other_gynecological_disorders')
        self.severe_other_gynecological_disorders = kwargs.get('severe_other_gynecological_disorders')
        self.other_mental_disorders_currently_without_symptoms = kwargs.get('other_mental_disorders_currently_without_symptoms')
        self.asymptomatic_premenstrual_syndrome = kwargs.get('asymptomatic_premenstrual_syndrome')
        self.abdominal_pain_and_depression_due_to_premenstrual_syndrome = kwargs.get('abdominal_pain_and_depression_due_to_premenstrual_syndrome')
        self.asymptomatic_polycystic_ovarian_syndrome = kwargs.get('asymptomatic_polycystic_ovarian_syndrome')
        self.hirsutism_due_to_polycystic_ovarian_syndrome = kwargs.get('hirsutism_due_to_polycystic_ovarian_syndrome')
        self.hirsutism_and_primary_infertility_due_to_polycystic_ovarian_syndrome = kwargs.get('hirsutism_and_primary_infertility_due_to_polycystic_ovarian_syndrome')
        self.asymptomatic_genital_prolapse = kwargs.get('asymptomatic_genital_prolapse')
        self.abdominal_pain_due_to_genital_prolapse = kwargs.get('abdominal_pain_due_to_genital_prolapse')
        self.stress_incontinence_due_to_genital_prolapse = kwargs.get('stress_incontinence_due_to_genital_prolapse')
        self.abdominal_pain_and_stress_incontinence_due_to_genital_prolapse = kwargs.get('abdominal_pain_and_stress_incontinence_due_to_genital_prolapse')
        self.asymptomatic_acute_hepatitis_a = kwargs.get('asymptomatic_acute_hepatitis_a')
        self.asymptomatic_acute_hepatitis_b = kwargs.get('asymptomatic_acute_hepatitis_b')
        self.asymptomatic_acute_hepatitis_c = kwargs.get('asymptomatic_acute_hepatitis_c')
        self.asymptomatic_acute_hepatitis_e = kwargs.get('asymptomatic_acute_hepatitis_e')
        self.asymptomatic_retinopathy_of_prematurity = kwargs.get('asymptomatic_retinopathy_of_prematurity')
        self.blindness_due_to_retinopathy_of_prematurity = kwargs.get('blindness_due_to_retinopathy_of_prematurity')
        self.mild_motor_impairment_due_to_neonatal_preterm_birth_complications_less_than_28wks = kwargs.get('mild_motor_impairment_due_to_neonatal_preterm_birth_complications_less_than_28wks')
        self.mild_motor_impairment_due_to_neonatal_preterm_birth_complications_28_32wks = kwargs.get('mild_motor_impairment_due_to_neonatal_preterm_birth_complications_28_32wks')
        self.mild_motor_impairment_due_to_neonatal_preterm_birth_complications_32_36wks = kwargs.get('mild_motor_impairment_due_to_neonatal_preterm_birth_complications_32_36wks')
        self.mild_motor_plus_cognitive_impairments_due_to_neonatal_preterm_birth_complications_less_than_28wks = kwargs.get('mild_motor_plus_cognitive_impairments_due_to_neonatal_preterm_birth_complications_less_than_28wks')
        self.mild_motor_plus_cognitive_impairments_due_to_neonatal_preterm_birth_complications_28_32wks = kwargs.get('mild_motor_plus_cognitive_impairments_due_to_neonatal_preterm_birth_complications_28_32wks')
        self.mild_motor_plus_cognitive_impairments_due_to_neonatal_preterm_birth_complications_32_36wks = kwargs.get('mild_motor_plus_cognitive_impairments_due_to_neonatal_preterm_birth_complications_32_36wks')
        self.blindness_due_to_encephalitis = kwargs.get('blindness_due_to_encephalitis')
        self.blindness_due_to_onchocerciasis = kwargs.get('blindness_due_to_onchocerciasis')
        self.moderate_vision_impairment_due_to_onchocerciasis = kwargs.get('moderate_vision_impairment_due_to_onchocerciasis')
        self.severe_vision_impairment_due_to_onchocerciasis = kwargs.get('severe_vision_impairment_due_to_onchocerciasis')
        self.mild_abdominal_pain_and_primary_infertility_due_to_endometriosis = kwargs.get('mild_abdominal_pain_and_primary_infertility_due_to_endometriosis')
        self.moderate_abdominal_pain_and_primary_infertility_due_to_endometriosis = kwargs.get('moderate_abdominal_pain_and_primary_infertility_due_to_endometriosis')
        self.severe_abdominal_pain_and_primary_infertility_due_to_endometriosis = kwargs.get('severe_abdominal_pain_and_primary_infertility_due_to_endometriosis')
        self.mild_abdominal_pain_and_secondary_infertility_due_to_endometriosis = kwargs.get('mild_abdominal_pain_and_secondary_infertility_due_to_endometriosis')
        self.moderate_abdominal_pain_and_secondary_infertility_due_to_endometriosis = kwargs.get('moderate_abdominal_pain_and_secondary_infertility_due_to_endometriosis')
        self.severe_abdominal_pain_and_secondary_infertility_due_to_endometriosis = kwargs.get('severe_abdominal_pain_and_secondary_infertility_due_to_endometriosis')
        self.moderate_motor_impairment_due_to_malaria = kwargs.get('moderate_motor_impairment_due_to_malaria')
        self.moderate_motor_impairment_with_blindness_due_to_malaria = kwargs.get('moderate_motor_impairment_with_blindness_due_to_malaria')
        self.moderate_motor_impairment_with_epilepsy_due_to_malaria = kwargs.get('moderate_motor_impairment_with_epilepsy_due_to_malaria')
        self.moderate_motor_impairment_with_blindness_and_epilepsy_due_to_malaria = kwargs.get('moderate_motor_impairment_with_blindness_and_epilepsy_due_to_malaria')
        self.moderate_motor_plus_cognitive_impairment_with_blindness_due_to_malaria = kwargs.get('moderate_motor_plus_cognitive_impairment_with_blindness_due_to_malaria')
        self.moderate_motor_plus_cognitive_impairment_with_epilepsy_due_to_malaria = kwargs.get('moderate_motor_plus_cognitive_impairment_with_epilepsy_due_to_malaria')
        self.moderate_motor_plus_cognitive_impairment_with_blindness_and_epilepsy_due_to_malaria = kwargs.get('moderate_motor_plus_cognitive_impairment_with_blindness_and_epilepsy_due_to_malaria')
        self.severe_motor_impairment_due_to_malaria = kwargs.get('severe_motor_impairment_due_to_malaria')
        self.severe_motor_impairment_with_blindness_due_to_malaria = kwargs.get('severe_motor_impairment_with_blindness_due_to_malaria')
        self.severe_motor_impairment_with_epilepsy_due_to_malaria = kwargs.get('severe_motor_impairment_with_epilepsy_due_to_malaria')
        self.severe_motor_impairment_with_blindness_and_epilepsy_due_to_malaria = kwargs.get('severe_motor_impairment_with_blindness_and_epilepsy_due_to_malaria')
        self.severe_motor_plus_cognitive_impairment_with_blindness_due_to_malaria = kwargs.get('severe_motor_plus_cognitive_impairment_with_blindness_due_to_malaria')
        self.severe_motor_plus_cognitive_impairment_with_epilepsy_due_to_malaria = kwargs.get('severe_motor_plus_cognitive_impairment_with_epilepsy_due_to_malaria')
        self.severe_motor_plus_cognitive_impairment_with_blindness_and_epilepsy_due_to_malaria = kwargs.get('severe_motor_plus_cognitive_impairment_with_blindness_and_epilepsy_due_to_malaria')
        self.asymptomatic_other_skin_and_subcutaneous_diseases = kwargs.get('asymptomatic_other_skin_and_subcutaneous_diseases')
        self.symptomatic_other_skin_and_subcutaneous_diseases = kwargs.get('symptomatic_other_skin_and_subcutaneous_diseases')
        self.mild_molluscum_contagiosum = kwargs.get('mild_molluscum_contagiosum')
        self.severe_molluscum_contagiosum = kwargs.get('severe_molluscum_contagiosum')
        self.chronic_hepatitis_b_without_cirrhosis = kwargs.get('chronic_hepatitis_b_without_cirrhosis')
        self.chronic_hepatitis_c_without_cirrhosis = kwargs.get('chronic_hepatitis_c_without_cirrhosis')
        self.asymptomatic_endocrine_metabolic_blood_and_immune_disorders = kwargs.get('asymptomatic_endocrine_metabolic_blood_and_immune_disorders')
        self.mild_endocrine_metabolic_blood_and_immune_disorders = kwargs.get('mild_endocrine_metabolic_blood_and_immune_disorders')
        self.moderate_endocrine_metabolic_blood_and_immune_disorders = kwargs.get('moderate_endocrine_metabolic_blood_and_immune_disorders')
        self.severe_endocrine_metabolic_blood_and_immune_disorders = kwargs.get('severe_endocrine_metabolic_blood_and_immune_disorders')
        self.heavy_clonorchiasis_due_to_food_borne_trematodiases = kwargs.get('heavy_clonorchiasis_due_to_food_borne_trematodiases')
        self.heavy_fascioliasis_due_to_food_borne_trematodiases = kwargs.get('heavy_fascioliasis_due_to_food_borne_trematodiases')
        self.heavy_intestinal_fluke_infection_due_to_food_borne_trematodiases = kwargs.get('heavy_intestinal_fluke_infection_due_to_food_borne_trematodiases')
        self.heavy_opisthorchiasis_due_to_food_borne_trematodiases = kwargs.get('heavy_opisthorchiasis_due_to_food_borne_trematodiases')
        self.symptomatic_atrial_fibrillation_and_flutter = kwargs.get('symptomatic_atrial_fibrillation_and_flutter')
        self.asymptomatic_turner_syndrome = kwargs.get('asymptomatic_turner_syndrome')
        self.moderate_vision_impairment_due_to_retinopathy_of_prematurity = kwargs.get('moderate_vision_impairment_due_to_retinopathy_of_prematurity')
        self.severe_vision_impairment_due_to_retinopathy_of_prematurity = kwargs.get('severe_vision_impairment_due_to_retinopathy_of_prematurity')
        self.mild_chlamydial_infection = kwargs.get('mild_chlamydial_infection')
        self.asymptomatic_chlamydial_infection = kwargs.get('asymptomatic_chlamydial_infection')
        self.mild_gonococcal_infection = kwargs.get('mild_gonococcal_infection')
        self.asymptomatic_gonococcal_infection = kwargs.get('asymptomatic_gonococcal_infection')
        self.acute_trichomoniasis_infection = kwargs.get('acute_trichomoniasis_infection')
        self.asymptomatic_trichomoniasis_infection = kwargs.get('asymptomatic_trichomoniasis_infection')
        self.disfigurement_level_1_due_to_orofacial_clefts = kwargs.get('disfigurement_level_1_due_to_orofacial_clefts')
        self.disfigurement_level_2_due_to_orofacial_clefts = kwargs.get('disfigurement_level_2_due_to_orofacial_clefts')
        self.disfigurement_level_2_and_speech_problems_due_to_orofacial_clefts = kwargs.get('disfigurement_level_2_and_speech_problems_due_to_orofacial_clefts')
        self.asymptomatic_chronic_obstructive_pulmonary_disease = kwargs.get('asymptomatic_chronic_obstructive_pulmonary_disease')
        self.asymptomatic_down_syndrome = kwargs.get('asymptomatic_down_syndrome')
        self.asymptomatic_other_chromosomal_abnormalities = kwargs.get('asymptomatic_other_chromosomal_abnormalities')
        self.primary_infertility_due_to_klinefelter_syndrome = kwargs.get('primary_infertility_due_to_klinefelter_syndrome')
        self.asymptomatic_klinefelter_syndrome = kwargs.get('asymptomatic_klinefelter_syndrome')
        self.isolated_congenital_heart_disease_due_to_other_chromosomal_abnormalities = kwargs.get('isolated_congenital_heart_disease_due_to_other_chromosomal_abnormalities')
        self.asymptomatic_chagas_disease = kwargs.get('asymptomatic_chagas_disease')
        self.chronic_periodontal_diseases = kwargs.get('chronic_periodontal_diseases')
        self.puerperal_sepsis = kwargs.get('puerperal_sepsis')
        self.other_maternal_infections = kwargs.get('other_maternal_infections')
        self.hirsutism_and_secondary_infertility_due_to_polycystic_ovarian_syndrome = kwargs.get('hirsutism_and_secondary_infertility_due_to_polycystic_ovarian_syndrome')
        self.secondary_infertility_due_to_polycystic_ovarian_syndrome = kwargs.get('secondary_infertility_due_to_polycystic_ovarian_syndrome')
        self.severe_abdominal_pain_due_to_endometriosis = kwargs.get('severe_abdominal_pain_due_to_endometriosis')
        self.moderate_infection_due_to_initial_genital_herpes_episode = kwargs.get('moderate_infection_due_to_initial_genital_herpes_episode')
        self.asymptomatic_caries_of_deciduous_teeth = kwargs.get('asymptomatic_caries_of_deciduous_teeth')
        self.asymptomatic_caries_of_permanent_teeth = kwargs.get('asymptomatic_caries_of_permanent_teeth')
        self.asymptomatic_edentulism_and_severe_tooth_loss = kwargs.get('asymptomatic_edentulism_and_severe_tooth_loss')
        self.asymptomatic_chronic_ischemic_stroke = kwargs.get('asymptomatic_chronic_ischemic_stroke')
        self.asymptomatic_chronic_intracerebral_hemorrhage = kwargs.get('asymptomatic_chronic_intracerebral_hemorrhage')
        self.asymptomatic_silicosis = kwargs.get('asymptomatic_silicosis')
        self.asymptomatic_asbestosis = kwargs.get('asymptomatic_asbestosis')
        self.asymptomatic_coal_workers_pneumoconiosis = kwargs.get('asymptomatic_coal_workers_pneumoconiosis')
        self.asymptomatic_other_pneumoconiosis = kwargs.get('asymptomatic_other_pneumoconiosis')
        self.asymptomatic_interstitial_lung_disease_and_pulmonary_sarcoidosis = kwargs.get('asymptomatic_interstitial_lung_disease_and_pulmonary_sarcoidosis')
        self.asymptomatic_angina_due_to_ischemic_heart_disease = kwargs.get('asymptomatic_angina_due_to_ischemic_heart_disease')
        self.asymptomatic_onchocerciasis = kwargs.get('asymptomatic_onchocerciasis')
        self.asymptomatic_ascariasis = kwargs.get('asymptomatic_ascariasis')
        self.asymptomatic_trichuriasis = kwargs.get('asymptomatic_trichuriasis')
        self.asymptomatic_clonorchiasis = kwargs.get('asymptomatic_clonorchiasis')
        self.asymptomatic_fascioliasis = kwargs.get('asymptomatic_fascioliasis')
        self.asymptomatic_intestinal_fluke_infection = kwargs.get('asymptomatic_intestinal_fluke_infection')
        self.asymptomatic_opisthorchiasis = kwargs.get('asymptomatic_opisthorchiasis')
        self.asymptomatic_paragonimiasis = kwargs.get('asymptomatic_paragonimiasis')
        self.asymptomatic_peripheral_arterial_disease = kwargs.get('asymptomatic_peripheral_arterial_disease')
        self.asymptomatic_benign_prostatic_hyperplasia = kwargs.get('asymptomatic_benign_prostatic_hyperplasia')
        self.symptomatic_benign_prostatic_hyperplasia = kwargs.get('symptomatic_benign_prostatic_hyperplasia')
        self.asymptomatic_uterine_fibroids = kwargs.get('asymptomatic_uterine_fibroids')
        self.asymptomatic_other_musculoskeletal_disorders = kwargs.get('asymptomatic_other_musculoskeletal_disorders')
        self.mild_cellulitis = kwargs.get('mild_cellulitis')
        self.severe_cellulitis = kwargs.get('severe_cellulitis')
        self.gastrointestinal_bleeding_due_to_typhoid = kwargs.get('gastrointestinal_bleeding_due_to_typhoid')
        self.vertigo_with_mild_hearing_loss_due_to_chronic_otitis_media = kwargs.get('vertigo_with_mild_hearing_loss_due_to_chronic_otitis_media')
        self.vertigo_with_mild_hearing_loss_and_ringing_due_to_chronic_otitis_media = kwargs.get('vertigo_with_mild_hearing_loss_and_ringing_due_to_chronic_otitis_media')
        self.asymptomatic_hookworm_disease = kwargs.get('asymptomatic_hookworm_disease')
        self.mild_heart_failure_due_to_severe_chronic_obstructive_pulmonary_disease = kwargs.get('mild_heart_failure_due_to_severe_chronic_obstructive_pulmonary_disease')
        self.moderate_heart_failure_due_to_severe_chronic_obstructive_pulmonary_disease = kwargs.get('moderate_heart_failure_due_to_severe_chronic_obstructive_pulmonary_disease')
        self.severe_heart_failure_due_to_severe_chronic_obstructive_pulmonary_disease = kwargs.get('severe_heart_failure_due_to_severe_chronic_obstructive_pulmonary_disease')
        self.severe_chronic_obstructive_pulmonary_disease_without_heart_failure = kwargs.get('severe_chronic_obstructive_pulmonary_disease_without_heart_failure')
        self.mild_heart_failure_due_to_severe_silicosis = kwargs.get('mild_heart_failure_due_to_severe_silicosis')
        self.moderate_heart_failure_due_to_severe_silicosis = kwargs.get('moderate_heart_failure_due_to_severe_silicosis')
        self.severe_heart_failure_due_to_severe_silicosis = kwargs.get('severe_heart_failure_due_to_severe_silicosis')
        self.severe_silicosis_without_heart_failure = kwargs.get('severe_silicosis_without_heart_failure')
        self.mild_heart_failure_due_to_severe_asbestosis = kwargs.get('mild_heart_failure_due_to_severe_asbestosis')
        self.moderate_heart_failure_due_to_severe_asbestosis = kwargs.get('moderate_heart_failure_due_to_severe_asbestosis')
        self.severe_heart_failure_due_to_severe_asbestosis = kwargs.get('severe_heart_failure_due_to_severe_asbestosis')
        self.severe_asbestosis_without_heart_failure = kwargs.get('severe_asbestosis_without_heart_failure')
        self.mild_heart_failure_due_to_severe_coal_workers_pneumoconiosis = kwargs.get('mild_heart_failure_due_to_severe_coal_workers_pneumoconiosis')
        self.moderate_heart_failure_due_to_severe_coal_workers_pneumoconiosis = kwargs.get('moderate_heart_failure_due_to_severe_coal_workers_pneumoconiosis')
        self.severe_heart_failure_due_to_severe_coal_workers_pneumoconiosis = kwargs.get('severe_heart_failure_due_to_severe_coal_workers_pneumoconiosis')
        self.severe_coal_workers_pneumoconiosis_without_heart_failure = kwargs.get('severe_coal_workers_pneumoconiosis_without_heart_failure')
        self.mild_heart_failure_due_to_severe_other_pneumoconiosis = kwargs.get('mild_heart_failure_due_to_severe_other_pneumoconiosis')
        self.moderate_heart_failure_due_to_severe_other_pneumoconiosis = kwargs.get('moderate_heart_failure_due_to_severe_other_pneumoconiosis')
        self.severe_heart_failure_due_to_severe_other_pneumoconiosis = kwargs.get('severe_heart_failure_due_to_severe_other_pneumoconiosis')
        self.severe_other_pneumoconiosis_without_heart_failure = kwargs.get('severe_other_pneumoconiosis_without_heart_failure')
        self.mild_heart_failure_due_to_severe_interstitial_lung_disease_and_pulmonary_sarcoidosis = kwargs.get('mild_heart_failure_due_to_severe_interstitial_lung_disease_and_pulmonary_sarcoidosis')
        self.moderate_heart_failure_due_to_severe_interstitial_lung_disease_and_pulmonary_sarcoidosis = kwargs.get('moderate_heart_failure_due_to_severe_interstitial_lung_disease_and_pulmonary_sarcoidosis')
        self.severe_heart_failure_due_to_severe_interstitial_lung_disease_and_pulmonary_sarcoidosis = kwargs.get('severe_heart_failure_due_to_severe_interstitial_lung_disease_and_pulmonary_sarcoidosis')
        self.severe_interstitial_lung_disease_and_pulmonary_sarcoidosis_without_heart_failure = kwargs.get('severe_interstitial_lung_disease_and_pulmonary_sarcoidosis_without_heart_failure')
        self.stage_3_chronic_kidney_disease_and_mild_anemia_due_to_hypertension = kwargs.get('stage_3_chronic_kidney_disease_and_mild_anemia_due_to_hypertension')
        self.stage_3_chronic_kidney_disease_and_moderate_anemia_due_to_hypertension = kwargs.get('stage_3_chronic_kidney_disease_and_moderate_anemia_due_to_hypertension')
        self.stage_3_chronic_kidney_disease_and_severe_anemia_due_to_hypertension = kwargs.get('stage_3_chronic_kidney_disease_and_severe_anemia_due_to_hypertension')
        self.stage_3_chronic_kidney_disease_without_anemia_due_to_hypertension = kwargs.get('stage_3_chronic_kidney_disease_without_anemia_due_to_hypertension')
        self.stage_3_chronic_kidney_disease_and_mild_anemia_due_to_glomerulonephritis = kwargs.get('stage_3_chronic_kidney_disease_and_mild_anemia_due_to_glomerulonephritis')
        self.stage_3_chronic_kidney_disease_and_moderate_anemia_due_to_glomerulonephritis = kwargs.get('stage_3_chronic_kidney_disease_and_moderate_anemia_due_to_glomerulonephritis')
        self.stage_3_chronic_kidney_disease_and_severe_anemia_due_to_glomerulonephritis = kwargs.get('stage_3_chronic_kidney_disease_and_severe_anemia_due_to_glomerulonephritis')
        self.stage_3_chronic_kidney_disease_without_anemia_due_to_glomerulonephritis = kwargs.get('stage_3_chronic_kidney_disease_without_anemia_due_to_glomerulonephritis')
        self.stage_3_chronic_kidney_disease_and_mild_anemia_due_to_other_causes = kwargs.get('stage_3_chronic_kidney_disease_and_mild_anemia_due_to_other_causes')
        self.stage_3_chronic_kidney_disease_and_moderate_anemia_due_to_other_causes = kwargs.get('stage_3_chronic_kidney_disease_and_moderate_anemia_due_to_other_causes')
        self.stage_3_chronic_kidney_disease_and_severe_anemia_due_to_other_causes = kwargs.get('stage_3_chronic_kidney_disease_and_severe_anemia_due_to_other_causes')
        self.stage_3_chronic_kidney_disease_without_anemia_due_to_other_causes = kwargs.get('stage_3_chronic_kidney_disease_without_anemia_due_to_other_causes')
        self.asymptomatic_ischemic_heart_disease_following_myocardial_infarction = kwargs.get('asymptomatic_ischemic_heart_disease_following_myocardial_infarction')
        self.symptomatic_claudication_due_to_peripheral_arterial_disease = kwargs.get('symptomatic_claudication_due_to_peripheral_arterial_disease')
        self.asymptomatic_seborrhoeic_dermatitis = kwargs.get('asymptomatic_seborrhoeic_dermatitis')
        self.asymptomatic_contact_dermatitis = kwargs.get('asymptomatic_contact_dermatitis')
        self.mild_other_oral_disorders = kwargs.get('mild_other_oral_disorders')
        self.severe_other_oral_disorders = kwargs.get('severe_other_oral_disorders')
        self.asymptomatic_b_thalassemia_trait = kwargs.get('asymptomatic_b_thalassemia_trait')
        self.asymptomatic_hemoglobin_e_trait = kwargs.get('asymptomatic_hemoglobin_e_trait')
        self.asymptomatic_sickle_cell_trait = kwargs.get('asymptomatic_sickle_cell_trait')
        self.asymptomatic_hemizygous_g6pd_trait = kwargs.get('asymptomatic_hemizygous_g6pd_trait')
        self.mild_hearing_loss_due_to_chronic_otitis_media = kwargs.get('mild_hearing_loss_due_to_chronic_otitis_media')
        self.mild_hearing_loss_with_ringing_due_to_chronic_otitis_media = kwargs.get('mild_hearing_loss_with_ringing_due_to_chronic_otitis_media')
        self.asymptomatic_malaria_parasitemia_pfpr = kwargs.get('asymptomatic_malaria_parasitemia_pfpr')
        self.mild_anemia_due_to_malaria_parasitemia_pfpr = kwargs.get('mild_anemia_due_to_malaria_parasitemia_pfpr')
        self.moderate_anemia_due_to_malaria_parasitemia_pfpr = kwargs.get('moderate_anemia_due_to_malaria_parasitemia_pfpr')
        self.severe_anemia_due_to_malaria_parasitemia_pfpr = kwargs.get('severe_anemia_due_to_malaria_parasitemia_pfpr')
        self.beta_thalassemia_major_severe_infection_with_severe_anemia = kwargs.get('beta_thalassemia_major_severe_infection_with_severe_anemia')
        self.beta_thalassemia_major_with_mild_anemia = kwargs.get('beta_thalassemia_major_with_mild_anemia')
        self.beta_thalassemia_major_with_moderate_anemia = kwargs.get('beta_thalassemia_major_with_moderate_anemia')
        self.beta_thalassemia_major_with_severe_anemia = kwargs.get('beta_thalassemia_major_with_severe_anemia')
        self.hemoglobin_e_beta_thalassemia_severe_infection_with_severe_anemia = kwargs.get('hemoglobin_e_beta_thalassemia_severe_infection_with_severe_anemia')
        self.hemoglobin_e_beta_thalassemia_with_mild_anemia = kwargs.get('hemoglobin_e_beta_thalassemia_with_mild_anemia')
        self.hemoglobin_e_beta_thalassemia_with_moderate_anemia = kwargs.get('hemoglobin_e_beta_thalassemia_with_moderate_anemia')
        self.hemoglobin_e_beta_thalassemia_with_severe_anemia = kwargs.get('hemoglobin_e_beta_thalassemia_with_severe_anemia')
        self.hemoglobin_h_disease_severe_infection_with_severe_anemia = kwargs.get('hemoglobin_h_disease_severe_infection_with_severe_anemia')
        self.hemoglobin_h_disease_with_mild_anemia = kwargs.get('hemoglobin_h_disease_with_mild_anemia')
        self.hemoglobin_h_disease_with_moderate_anemia = kwargs.get('hemoglobin_h_disease_with_moderate_anemia')
        self.hemoglobin_h_disease_with_severe_anemia = kwargs.get('hemoglobin_h_disease_with_severe_anemia')
        self.homozygous_sickle_cell_and_severe_sickle_cell_beta_thalassemia_without_anemia = kwargs.get('homozygous_sickle_cell_and_severe_sickle_cell_beta_thalassemia_without_anemia')
        self.homozygous_sickle_cell_and_severe_sickle_cell_beta_thalassemia_with_vaso_occlusive_crisis_without_anemia = kwargs.get('homozygous_sickle_cell_and_severe_sickle_cell_beta_thalassemia_with_vaso_occlusive_crisis_without_anemia')
        self.homozygous_sickle_cell_and_severe_sickle_cell_beta_thalassemia_with_vaso_occlusive_crisis_and_severe_anemia = kwargs.get('homozygous_sickle_cell_and_severe_sickle_cell_beta_thalassemia_with_vaso_occlusive_crisis_and_severe_anemia')
        self.homozygous_sickle_cell_and_severe_sickle_cell_beta_thalassemia_with_stroke_and_severe_anemia = kwargs.get('homozygous_sickle_cell_and_severe_sickle_cell_beta_thalassemia_with_stroke_and_severe_anemia')
        self.homozygous_sickle_cell_and_severe_sickle_cell_beta_thalassemia_with_stroke_without_anemia = kwargs.get('homozygous_sickle_cell_and_severe_sickle_cell_beta_thalassemia_with_stroke_without_anemia')
        self.homozygous_sickle_cell_and_severe_sickle_cell_beta_thalassemia_with_vaso_occlusive_crisis_stroke_and_severe_anemia = kwargs.get('homozygous_sickle_cell_and_severe_sickle_cell_beta_thalassemia_with_vaso_occlusive_crisis_stroke_and_severe_anemia')
        self.homozygous_sickle_cell_and_severe_sickle_cell_beta_thalassemia_with_vaso_occlusive_crisis_and_stroke_without_anemia = kwargs.get('homozygous_sickle_cell_and_severe_sickle_cell_beta_thalassemia_with_vaso_occlusive_crisis_and_stroke_without_anemia')
        self.homozygous_sickle_cell_and_severe_sickle_cell_beta_thalassemia_with_mild_anemia = kwargs.get('homozygous_sickle_cell_and_severe_sickle_cell_beta_thalassemia_with_mild_anemia')
        self.homozygous_sickle_cell_and_severe_sickle_cell_beta_thalassemia_with_moderate_anemia = kwargs.get('homozygous_sickle_cell_and_severe_sickle_cell_beta_thalassemia_with_moderate_anemia')
        self.homozygous_sickle_cell_and_severe_sickle_cell_beta_thalassemia_with_severe_anemia = kwargs.get('homozygous_sickle_cell_and_severe_sickle_cell_beta_thalassemia_with_severe_anemia')
        self.hemoglobin_sc_disease_without_anemia = kwargs.get('hemoglobin_sc_disease_without_anemia')
        self.hemoglobin_sc_disease_with_vaso_occlusive_crisis_and_severe_anemia = kwargs.get('hemoglobin_sc_disease_with_vaso_occlusive_crisis_and_severe_anemia')
        self.hemoglobin_sc_disease_with_vaso_occlusive_crisis_without_anemia = kwargs.get('hemoglobin_sc_disease_with_vaso_occlusive_crisis_without_anemia')
        self.hemoglobin_sc_disease_with_stroke_and_severe_anemia = kwargs.get('hemoglobin_sc_disease_with_stroke_and_severe_anemia')
        self.hemoglobin_sc_disease_with_stroke_without_anemia = kwargs.get('hemoglobin_sc_disease_with_stroke_without_anemia')
        self.hemoglobin_sc_disease_with_vaso_occlusive_crisis_stroke_and_severe_anemia = kwargs.get('hemoglobin_sc_disease_with_vaso_occlusive_crisis_stroke_and_severe_anemia')
        self.hemoglobin_sc_disease_with_vaso_occlusive_crisis_and_stroke_without_anemia = kwargs.get('hemoglobin_sc_disease_with_vaso_occlusive_crisis_and_stroke_without_anemia')
        self.hemoglobin_sc_disease_with_mild_anemia = kwargs.get('hemoglobin_sc_disease_with_mild_anemia')
        self.hemoglobin_sc_disease_with_moderate_anemia = kwargs.get('hemoglobin_sc_disease_with_moderate_anemia')
        self.hemoglobin_sc_disease_with_severe_anemia = kwargs.get('hemoglobin_sc_disease_with_severe_anemia')
        self.mild_sickle_cell_beta_thalassemia_without_anemia = kwargs.get('mild_sickle_cell_beta_thalassemia_without_anemia')
        self.mild_sickle_cell_beta_thalassemia_with_vaso_occlusive_crisis_and_severe_anemia = kwargs.get('mild_sickle_cell_beta_thalassemia_with_vaso_occlusive_crisis_and_severe_anemia')
        self.mild_sickle_cell_beta_thalassemia_with_vaso_occlusive_crisis_without_anemia = kwargs.get('mild_sickle_cell_beta_thalassemia_with_vaso_occlusive_crisis_without_anemia')
        self.mild_sickle_cell_beta_thalassemia_with_stroke_and_severe_anemia = kwargs.get('mild_sickle_cell_beta_thalassemia_with_stroke_and_severe_anemia')
        self.mild_sickle_cell_beta_thalassemia_with_stroke_without_anemia = kwargs.get('mild_sickle_cell_beta_thalassemia_with_stroke_without_anemia')
        self.mild_sickle_cell_beta_thalassemia_with_vaso_occlusive_crisis_stroke_and_severe_anemia = kwargs.get('mild_sickle_cell_beta_thalassemia_with_vaso_occlusive_crisis_stroke_and_severe_anemia')
        self.mild_sickle_cell_beta_thalassemia_with_vaso_occlusive_crisis_and_stroke_without_anemia = kwargs.get('mild_sickle_cell_beta_thalassemia_with_vaso_occlusive_crisis_and_stroke_without_anemia')
        self.mild_sickle_cell_beta_thalassemia_with_mild_anemia = kwargs.get('mild_sickle_cell_beta_thalassemia_with_mild_anemia')
        self.mild_sickle_cell_beta_thalassemia_with_moderate_anemia = kwargs.get('mild_sickle_cell_beta_thalassemia_with_moderate_anemia')
        self.mild_sickle_cell_beta_thalassemia_with_severe_anemia = kwargs.get('mild_sickle_cell_beta_thalassemia_with_severe_anemia')
        self.vertigo_with_moderate_hearing_loss_due_to_chronic_otitis_media = kwargs.get('vertigo_with_moderate_hearing_loss_due_to_chronic_otitis_media')
        self.vertigo_with_moderate_hearing_loss_and_ringing_due_to_chronic_otitis_media = kwargs.get('vertigo_with_moderate_hearing_loss_and_ringing_due_to_chronic_otitis_media')
        self.moderate_hearing_loss_due_to_chronic_otitis_media = kwargs.get('moderate_hearing_loss_due_to_chronic_otitis_media')
        self.moderate_hearing_loss_with_ringing_due_to_chronic_otitis_media = kwargs.get('moderate_hearing_loss_with_ringing_due_to_chronic_otitis_media')
        self.mild_abdominal_pain_due_to_uterine_fibroids_with_mild_anemia = kwargs.get('mild_abdominal_pain_due_to_uterine_fibroids_with_mild_anemia')
        self.mild_abdominal_pain_due_to_uterine_fibroids_with_moderate_anemia = kwargs.get('mild_abdominal_pain_due_to_uterine_fibroids_with_moderate_anemia')
        self.mild_abdominal_pain_due_to_uterine_fibroids_with_severe_anemia = kwargs.get('mild_abdominal_pain_due_to_uterine_fibroids_with_severe_anemia')
        self.mild_abdominal_pain_due_to_uterine_fibroids_without_anemia = kwargs.get('mild_abdominal_pain_due_to_uterine_fibroids_without_anemia')
        self.asymptomatic_yellow_fever = kwargs.get('asymptomatic_yellow_fever')
        self.hemoglobin_h_disease_without_anemia = kwargs.get('hemoglobin_h_disease_without_anemia')
        self.beta_thalassemia_major_without_anemia = kwargs.get('beta_thalassemia_major_without_anemia')
        self.hemoglobin_e_beta_thalassemia_without_anemia = kwargs.get('hemoglobin_e_beta_thalassemia_without_anemia')
        self.rheumatic_heart_disease_without_heart_failure = kwargs.get('rheumatic_heart_disease_without_heart_failure')
        self.mild_heart_failure_due_to_rheumatic_heart_disease = kwargs.get('mild_heart_failure_due_to_rheumatic_heart_disease')
        self.moderate_heart_failure_due_to_rheumatic_heart_disease = kwargs.get('moderate_heart_failure_due_to_rheumatic_heart_disease')
        self.severe_heart_failure_due_to_rheumatic_heart_disease = kwargs.get('severe_heart_failure_due_to_rheumatic_heart_disease')
        self.mild_anemia_due_to_g6pd_deficiency = kwargs.get('mild_anemia_due_to_g6pd_deficiency')
        self.moderate_anemia_due_to_g6pd_deficiency = kwargs.get('moderate_anemia_due_to_g6pd_deficiency')
        self.severe_anemia_due_to_g6pd_deficiency = kwargs.get('severe_anemia_due_to_g6pd_deficiency')
        self.mild_heart_failure_due_to_g6pd_deficiency = kwargs.get('mild_heart_failure_due_to_g6pd_deficiency')
        self.moderate_heart_failure_due_to_g6pd_deficiency = kwargs.get('moderate_heart_failure_due_to_g6pd_deficiency')
        self.severe_heart_failure_due_to_g6pd_deficiency = kwargs.get('severe_heart_failure_due_to_g6pd_deficiency')
        self.asymptomatic_g6pd_deficiency = kwargs.get('asymptomatic_g6pd_deficiency')
        self.asymptomatic_gallbladder_and_biliary_diseases = kwargs.get('asymptomatic_gallbladder_and_biliary_diseases')
        self.moderate_vision_impairment_due_to_encephalitis = kwargs.get('moderate_vision_impairment_due_to_encephalitis')
        self.severe_vision_impairment_due_to_encephalitis = kwargs.get('severe_vision_impairment_due_to_encephalitis')
        self.mild_motor_impairment_mild_respiratory_problems_and_speech_problems_due_to_motor_neuron_disease = kwargs.get('mild_motor_impairment_mild_respiratory_problems_and_speech_problems_due_to_motor_neuron_disease')
        self.mild_motor_impairment_moderate_respiratory_problems_and_speech_problems_due_to_motor_neuron_disease = kwargs.get('mild_motor_impairment_moderate_respiratory_problems_and_speech_problems_due_to_motor_neuron_disease')
        self.mild_motor_impairment_severe_respiratory_problems_and_speech_problems_due_to_motor_neuron_disease = kwargs.get('mild_motor_impairment_severe_respiratory_problems_and_speech_problems_due_to_motor_neuron_disease')
        self.mild_motor_impairment_and_speech_problems_due_to_motor_neuron_disease = kwargs.get('mild_motor_impairment_and_speech_problems_due_to_motor_neuron_disease')
        self.moderate_motor_impairment_mild_respiratory_problems_and_speech_problems_due_to_motor_neuron_disease = kwargs.get('moderate_motor_impairment_mild_respiratory_problems_and_speech_problems_due_to_motor_neuron_disease')
        self.moderate_motor_impairment_moderate_respiratory_problems_and_speech_problems_due_to_motor_neuron_disease = kwargs.get('moderate_motor_impairment_moderate_respiratory_problems_and_speech_problems_due_to_motor_neuron_disease')
        self.moderate_motor_impairment_severe_respiratory_problems_and_speech_problems_due_to_motor_neuron_disease = kwargs.get('moderate_motor_impairment_severe_respiratory_problems_and_speech_problems_due_to_motor_neuron_disease')
        self.severe_motor_impairment_mild_respiratory_problems_and_speech_problems_due_to_motor_neuron_disease = kwargs.get('severe_motor_impairment_mild_respiratory_problems_and_speech_problems_due_to_motor_neuron_disease')
        self.severe_motor_impairment_moderate_respiratory_problems_and_speech_problems_due_to_motor_neuron_disease = kwargs.get('severe_motor_impairment_moderate_respiratory_problems_and_speech_problems_due_to_motor_neuron_disease')
        self.severe_motor_impairment_severe_respiratory_problems_and_speech_problems_due_to_motor_neuron_disease = kwargs.get('severe_motor_impairment_severe_respiratory_problems_and_speech_problems_due_to_motor_neuron_disease')
        self.mild_motor_impairment_and_mild_respiratory_problems_due_to_motor_neuron_disease = kwargs.get('mild_motor_impairment_and_mild_respiratory_problems_due_to_motor_neuron_disease')
        self.mild_motor_impairment_and_severe_respiratory_problems_due_to_motor_neuron_disease = kwargs.get('mild_motor_impairment_and_severe_respiratory_problems_due_to_motor_neuron_disease')
        self.moderate_motor_impairment_and_mild_respiratory_problems_due_to_motor_neuron_disease = kwargs.get('moderate_motor_impairment_and_mild_respiratory_problems_due_to_motor_neuron_disease')
        self.moderate_motor_impairment_and_moderate_respiratory_problems_due_to_motor_neuron_disease = kwargs.get('moderate_motor_impairment_and_moderate_respiratory_problems_due_to_motor_neuron_disease')
        self.moderate_motor_impairment_and_severe_respiratory_problems_due_to_motor_neuron_disease = kwargs.get('moderate_motor_impairment_and_severe_respiratory_problems_due_to_motor_neuron_disease')
        self.severe_motor_impairment_and_mild_respiratory_problems_due_to_motor_neuron_disease = kwargs.get('severe_motor_impairment_and_mild_respiratory_problems_due_to_motor_neuron_disease')
        self.severe_motor_impairment_and_moderate_respiratory_problems_due_to_motor_neuron_disease = kwargs.get('severe_motor_impairment_and_moderate_respiratory_problems_due_to_motor_neuron_disease')
        self.severe_motor_impairment_and_severe_respiratory_problems_due_to_motor_neuron_disease = kwargs.get('severe_motor_impairment_and_severe_respiratory_problems_due_to_motor_neuron_disease')
        self.moderate_motor_impairment_and_speech_problems_due_to_motor_neuron_disease = kwargs.get('moderate_motor_impairment_and_speech_problems_due_to_motor_neuron_disease')
        self.severe_motor_impairment_and_speech_problems_due_to_motor_neuron_disease = kwargs.get('severe_motor_impairment_and_speech_problems_due_to_motor_neuron_disease')
        self.mild_motor_impairment_due_to_motor_neuron_disease = kwargs.get('mild_motor_impairment_due_to_motor_neuron_disease')
        self.moderate_motor_impairment_due_to_motor_neuron_disease = kwargs.get('moderate_motor_impairment_due_to_motor_neuron_disease')
        self.severe_motor_impairment_due_to_motor_neuron_disease = kwargs.get('severe_motor_impairment_due_to_motor_neuron_disease')
        self.mild_respiratory_problems_and_speech_problems_due_to_motor_neuron_disease = kwargs.get('mild_respiratory_problems_and_speech_problems_due_to_motor_neuron_disease')
        self.moderate_respiratory_problems_and_speech_problems_due_to_motor_neuron_disease = kwargs.get('moderate_respiratory_problems_and_speech_problems_due_to_motor_neuron_disease')
        self.severe_respiratory_problems_and_speech_problems_due_to_motor_neuron_disease = kwargs.get('severe_respiratory_problems_and_speech_problems_due_to_motor_neuron_disease')
        self.mild_respiratory_problems_due_to_motor_neuron_disease = kwargs.get('mild_respiratory_problems_due_to_motor_neuron_disease')
        self.moderate_respiratory_problems_due_to_motor_neuron_disease = kwargs.get('moderate_respiratory_problems_due_to_motor_neuron_disease')
        self.severe_respiratory_problems_due_to_motor_neuron_disease = kwargs.get('severe_respiratory_problems_due_to_motor_neuron_disease')
        self.speech_problems_due_to_motor_neuron_disease = kwargs.get('speech_problems_due_to_motor_neuron_disease')
        self.diagnosis_of_motor_neuron_disease = kwargs.get('diagnosis_of_motor_neuron_disease')
        self.ebola_cases = kwargs.get('ebola_cases')
        self.post_ebola_chronic_fatigue_syndrome = kwargs.get('post_ebola_chronic_fatigue_syndrome')
        self.diagnosis_and_primary_therapy_phase_of_acute_lymphoid_leukemia = kwargs.get('diagnosis_and_primary_therapy_phase_of_acute_lymphoid_leukemia')
        self.diagnosis_and_primary_therapy_phase_of_acute_myeloid_leukemia = kwargs.get('diagnosis_and_primary_therapy_phase_of_acute_myeloid_leukemia')
        self.diagnosis_and_primary_therapy_phase_of_chronic_lymphoid_leukemia = kwargs.get('diagnosis_and_primary_therapy_phase_of_chronic_lymphoid_leukemia')
        self.diagnosis_and_primary_therapy_phase_of_chronic_myeloid_leukemia = kwargs.get('diagnosis_and_primary_therapy_phase_of_chronic_myeloid_leukemia')
        self.controlled_phase_of_acute_lymphoid_leukemia = kwargs.get('controlled_phase_of_acute_lymphoid_leukemia')
        self.controlled_phase_of_acute_myeloid_leukemia = kwargs.get('controlled_phase_of_acute_myeloid_leukemia')
        self.controlled_phase_of_chronic_lymphoid_leukemia = kwargs.get('controlled_phase_of_chronic_lymphoid_leukemia')
        self.controlled_phase_of_chronic_myeloid_leukemia = kwargs.get('controlled_phase_of_chronic_myeloid_leukemia')
        self.metastatic_phase_of_acute_lymphoid_leukemia = kwargs.get('metastatic_phase_of_acute_lymphoid_leukemia')
        self.metastatic_phase_of_acute_myeloid_leukemia = kwargs.get('metastatic_phase_of_acute_myeloid_leukemia')
        self.metastatic_phase_of_chronic_lymphoid_leukemia = kwargs.get('metastatic_phase_of_chronic_lymphoid_leukemia')
        self.metastatic_phase_of_chronic_myeloid_leukemia = kwargs.get('metastatic_phase_of_chronic_myeloid_leukemia')
        self.terminal_phase_of_acute_lymphoid_leukemia = kwargs.get('terminal_phase_of_acute_lymphoid_leukemia')
        self.terminal_phase_of_acute_myeloid_leukemia = kwargs.get('terminal_phase_of_acute_myeloid_leukemia')
        self.terminal_phase_of_chronic_lymphoid_leukemia = kwargs.get('terminal_phase_of_chronic_lymphoid_leukemia')
        self.terminal_phase_of_chronic_myeloid_leukemia = kwargs.get('terminal_phase_of_chronic_myeloid_leukemia')
        self.asymptomatic_early_syphilis_infection = kwargs.get('asymptomatic_early_syphilis_infection')
        self.mild_early_syphilis_infection = kwargs.get('mild_early_syphilis_infection')
        self.borderline_intellectual_disability_due_to_down_syndrome = kwargs.get('borderline_intellectual_disability_due_to_down_syndrome')
        self.mild_intellectual_disability_due_to_down_syndrome = kwargs.get('mild_intellectual_disability_due_to_down_syndrome')
        self.moderate_intellectual_disability_due_to_down_syndrome = kwargs.get('moderate_intellectual_disability_due_to_down_syndrome')
        self.severe_intellectual_disability_due_to_down_syndrome = kwargs.get('severe_intellectual_disability_due_to_down_syndrome')
        self.profound_intellectual_disability_due_to_down_syndrome = kwargs.get('profound_intellectual_disability_due_to_down_syndrome')
        self.borderline_intellectual_disability_with_congenital_heart_disease_due_to_down_syndrome = kwargs.get('borderline_intellectual_disability_with_congenital_heart_disease_due_to_down_syndrome')
        self.mild_intellectual_disability_with_congenital_heart_disease_due_to_down_syndrome = kwargs.get('mild_intellectual_disability_with_congenital_heart_disease_due_to_down_syndrome')
        self.moderate_intellectual_disability_with_congenital_heart_disease_due_to_down_syndrome = kwargs.get('moderate_intellectual_disability_with_congenital_heart_disease_due_to_down_syndrome')
        self.severe_intellectual_disability_with_congenital_heart_disease_due_to_down_syndrome = kwargs.get('severe_intellectual_disability_with_congenital_heart_disease_due_to_down_syndrome')
        self.profound_intellectual_disability_with_congenital_heart_disease_due_to_down_syndrome = kwargs.get('profound_intellectual_disability_with_congenital_heart_disease_due_to_down_syndrome')
        self.borderline_intellectual_disability_due_to_other_chromosomal_abnormalities = kwargs.get('borderline_intellectual_disability_due_to_other_chromosomal_abnormalities')
        self.mild_intellectual_disability_due_to_other_chromosomal_abnormalities = kwargs.get('mild_intellectual_disability_due_to_other_chromosomal_abnormalities')
        self.moderate_intellectual_disability_due_to_other_chromosomal_abnormalities = kwargs.get('moderate_intellectual_disability_due_to_other_chromosomal_abnormalities')
        self.severe_intellectual_disability_due_to_other_chromosomal_abnormalities = kwargs.get('severe_intellectual_disability_due_to_other_chromosomal_abnormalities')
        self.profound_intellectual_disability_due_to_other_chromosomal_abnormalities = kwargs.get('profound_intellectual_disability_due_to_other_chromosomal_abnormalities')
        self.borderline_intellectual_disability_with_congenital_heart_disease_due_to_other_chromosomal_abnormalities = kwargs.get('borderline_intellectual_disability_with_congenital_heart_disease_due_to_other_chromosomal_abnormalities')
        self.mild_intellectual_disability_with_congenital_heart_disease_due_to_other_chromosomal_abnormalities = kwargs.get('mild_intellectual_disability_with_congenital_heart_disease_due_to_other_chromosomal_abnormalities')
        self.moderate_intellectual_disability_with_congenital_heart_disease_due_to_other_chromosomal_abnormalities = kwargs.get('moderate_intellectual_disability_with_congenital_heart_disease_due_to_other_chromosomal_abnormalities')
        self.severe_intellectual_disability_with_congenital_heart_disease_due_to_other_chromosomal_abnormalities = kwargs.get('severe_intellectual_disability_with_congenital_heart_disease_due_to_other_chromosomal_abnormalities')
        self.profound_intellectual_disability_with_congenital_heart_disease_due_to_other_chromosomal_abnormalities = kwargs.get('profound_intellectual_disability_with_congenital_heart_disease_due_to_other_chromosomal_abnormalities')
        self.mild_dementia_due_to_down_syndrome = kwargs.get('mild_dementia_due_to_down_syndrome')
        self.moderate_dementia_due_to_down_syndrome = kwargs.get('moderate_dementia_due_to_down_syndrome')
        self.severe_dementia_due_to_down_syndrome = kwargs.get('severe_dementia_due_to_down_syndrome')
        self.congenital_heart_disease_and_mild_dementia_due_to_down_syndrome = kwargs.get('congenital_heart_disease_and_mild_dementia_due_to_down_syndrome')
        self.congenital_heart_disease_and_moderate_dementia_due_to_down_syndrome = kwargs.get('congenital_heart_disease_and_moderate_dementia_due_to_down_syndrome')
        self.congenital_heart_disease_and_severe_dementia_due_to_down_syndrome = kwargs.get('congenital_heart_disease_and_severe_dementia_due_to_down_syndrome')
        self.mild_dementia_due_to_other_chromosomal_abnormalities = kwargs.get('mild_dementia_due_to_other_chromosomal_abnormalities')
        self.moderate_dementia_due_to_other_chromosomal_abnormalities = kwargs.get('moderate_dementia_due_to_other_chromosomal_abnormalities')
        self.severe_dementia_due_to_other_chromosomal_abnormalities = kwargs.get('severe_dementia_due_to_other_chromosomal_abnormalities')
        self.congenital_heart_disease_and_mild_dementia_due_to_other_chromosomal_abnormalities = kwargs.get('congenital_heart_disease_and_mild_dementia_due_to_other_chromosomal_abnormalities')
        self.congenital_heart_disease_and_moderate_dementia_due_to_other_chromosomal_abnormalities = kwargs.get('congenital_heart_disease_and_moderate_dementia_due_to_other_chromosomal_abnormalities')
        self.congenital_heart_disease_and_severe_dementia_due_to_other_chromosomal_abnormalities = kwargs.get('congenital_heart_disease_and_severe_dementia_due_to_other_chromosomal_abnormalities')
        self.asymptomatic_neonatal_preterm_birth_less_than_28_weeks = kwargs.get('asymptomatic_neonatal_preterm_birth_less_than_28_weeks')
        self.asymptomatic_neonatal_preterm_birth_28_less_than_32_wks = kwargs.get('asymptomatic_neonatal_preterm_birth_28_less_than_32_wks')
        self.asymptomatic_neonatal_preterm_birth_32_less_than_37wks = kwargs.get('asymptomatic_neonatal_preterm_birth_32_less_than_37wks')
        self.asymptomatic_neonatal_encephalopathy_due_to_birth_asphyxia_and_trauma = kwargs.get('asymptomatic_neonatal_encephalopathy_due_to_birth_asphyxia_and_trauma')
        self.asymptomatic_neonatal_sepsis_and_other_neonatal_infections = kwargs.get('asymptomatic_neonatal_sepsis_and_other_neonatal_infections')
        self.mild_motor_plus_cognitive_impairments_due_to_neonatal_sepsis_and_other_neonatal_infections = kwargs.get('mild_motor_plus_cognitive_impairments_due_to_neonatal_sepsis_and_other_neonatal_infections')
        self.mild_motor_impairment_due_to_neonatal_sepsis_and_other_neonatal_infections = kwargs.get('mild_motor_impairment_due_to_neonatal_sepsis_and_other_neonatal_infections')
        self.moderate_motor_impairment_due_to_neonatal_sepsis_and_other_neonatal_infections = kwargs.get('moderate_motor_impairment_due_to_neonatal_sepsis_and_other_neonatal_infections')
        self.moderate_motor_impairment_with_blindness_due_to_neonatal_sepsis_and_other_neonatal_infections = kwargs.get('moderate_motor_impairment_with_blindness_due_to_neonatal_sepsis_and_other_neonatal_infections')
        self.moderate_motor_impairment_with_epilepsy_due_to_neonatal_sepsis_and_other_neonatal_infections = kwargs.get('moderate_motor_impairment_with_epilepsy_due_to_neonatal_sepsis_and_other_neonatal_infections')
        self.moderate_motor_impairment_with_blindness_and_epilepsy_due_to_neonatal_sepsis_and_other_neonatal_infections = kwargs.get('moderate_motor_impairment_with_blindness_and_epilepsy_due_to_neonatal_sepsis_and_other_neonatal_infections')
        self.moderate_motor_plus_cognitive_impairment_with_blindness_due_to_neonatal_sepsis_and_other_neonatal_infections = kwargs.get('moderate_motor_plus_cognitive_impairment_with_blindness_due_to_neonatal_sepsis_and_other_neonatal_infections')
        self.moderate_motor_plus_cognitive_impairment_with_epilepsy_due_to_neonatal_sepsis_and_other_neonatal_infections = kwargs.get('moderate_motor_plus_cognitive_impairment_with_epilepsy_due_to_neonatal_sepsis_and_other_neonatal_infections')
        self.moderate_motor_plus_cognitive_impairment_with_blindness_and_epilepsy_due_to_neonatal_sepsis_and_other_neonatal_infections = kwargs.get('moderate_motor_plus_cognitive_impairment_with_blindness_and_epilepsy_due_to_neonatal_sepsis_and_other_neonatal_infections')
        self.severe_motor_impairment_due_to_neonatal_sepsis_and_other_neonatal_infections = kwargs.get('severe_motor_impairment_due_to_neonatal_sepsis_and_other_neonatal_infections')
        self.severe_motor_impairment_with_blindness_due_to_neonatal_sepsis_and_other_neonatal_infections = kwargs.get('severe_motor_impairment_with_blindness_due_to_neonatal_sepsis_and_other_neonatal_infections')
        self.severe_motor_impairment_with_epilepsy_due_to_neonatal_sepsis_and_other_neonatal_infections = kwargs.get('severe_motor_impairment_with_epilepsy_due_to_neonatal_sepsis_and_other_neonatal_infections')
        self.severe_motor_impairment_with_blindness_and_epilepsy_due_to_neonatal_sepsis_and_other_neonatal_infections = kwargs.get('severe_motor_impairment_with_blindness_and_epilepsy_due_to_neonatal_sepsis_and_other_neonatal_infections')
        self.severe_motor_plus_cognitive_impairment_with_blindness_due_to_neonatal_sepsis_and_other_neonatal_infections = kwargs.get('severe_motor_plus_cognitive_impairment_with_blindness_due_to_neonatal_sepsis_and_other_neonatal_infections')
        self.severe_motor_plus_cognitive_impairment_with_epilepsy_due_to_neonatal_sepsis_and_other_neonatal_infections = kwargs.get('severe_motor_plus_cognitive_impairment_with_epilepsy_due_to_neonatal_sepsis_and_other_neonatal_infections')
        self.severe_motor_plus_cognitive_impairment_with_blindness_and_epilepsy_due_to_neonatal_sepsis_and_other_neonatal_infections = kwargs.get('severe_motor_plus_cognitive_impairment_with_blindness_and_epilepsy_due_to_neonatal_sepsis_and_other_neonatal_infections')
        self.borderline_intellectual_disability_mild_dementia_and_congenital_heart_disease_due_to_down_syndrome = kwargs.get('borderline_intellectual_disability_mild_dementia_and_congenital_heart_disease_due_to_down_syndrome')
        self.mild_intellectual_disability_mild_dementia_and_congenital_heart_disease_due_to_down_syndrome = kwargs.get('mild_intellectual_disability_mild_dementia_and_congenital_heart_disease_due_to_down_syndrome')
        self.moderate_intellectual_disability_mild_dementia_and_congenital_heart_disease_due_to_down_syndrome = kwargs.get('moderate_intellectual_disability_mild_dementia_and_congenital_heart_disease_due_to_down_syndrome')
        self.severe_intellectual_disability_mild_dementia_and_congenital_heart_disease_due_to_down_syndrome = kwargs.get('severe_intellectual_disability_mild_dementia_and_congenital_heart_disease_due_to_down_syndrome')
        self.profound_intellectual_disability_mild_dementia_and_congenital_heart_disease_due_to_down_syndrome = kwargs.get('profound_intellectual_disability_mild_dementia_and_congenital_heart_disease_due_to_down_syndrome')
        self.borderline_intellectual_disability_moderate_dementia_and_congenital_heart_disease_due_to_down_syndrome = kwargs.get('borderline_intellectual_disability_moderate_dementia_and_congenital_heart_disease_due_to_down_syndrome')
        self.mild_intellectual_disability_moderate_dementia_and_congenital_heart_disease_due_to_down_syndrome = kwargs.get('mild_intellectual_disability_moderate_dementia_and_congenital_heart_disease_due_to_down_syndrome')
        self.moderate_intellectual_disability_moderate_dementia_and_congenital_heart_disease_due_to_down_syndrome = kwargs.get('moderate_intellectual_disability_moderate_dementia_and_congenital_heart_disease_due_to_down_syndrome')
        self.severe_intellectual_disability_moderate_dementia_and_congenital_heart_disease_due_to_down_syndrome = kwargs.get('severe_intellectual_disability_moderate_dementia_and_congenital_heart_disease_due_to_down_syndrome')
        self.profound_intellectual_disability_moderate_dementia_and_congenital_heart_disease_due_to_down_syndrome = kwargs.get('profound_intellectual_disability_moderate_dementia_and_congenital_heart_disease_due_to_down_syndrome')
        self.borderline_intellectual_disability_severe_dementia_and_congenital_heart_disease_due_to_down_syndrome = kwargs.get('borderline_intellectual_disability_severe_dementia_and_congenital_heart_disease_due_to_down_syndrome')
        self.mild_intellectual_disability_severe_dementia_and_congenital_heart_disease_due_to_down_syndrome = kwargs.get('mild_intellectual_disability_severe_dementia_and_congenital_heart_disease_due_to_down_syndrome')
        self.moderate_intellectual_disability_severe_dementia_and_congenital_heart_disease_due_to_down_syndrome = kwargs.get('moderate_intellectual_disability_severe_dementia_and_congenital_heart_disease_due_to_down_syndrome')
        self.severe_intellectual_disability_severe_dementia_and_congenital_heart_disease_due_to_down_syndrome = kwargs.get('severe_intellectual_disability_severe_dementia_and_congenital_heart_disease_due_to_down_syndrome')
        self.profound_intellectual_disability_severe_dementia_and_congenital_heart_disease_due_to_down_syndrome = kwargs.get('profound_intellectual_disability_severe_dementia_and_congenital_heart_disease_due_to_down_syndrome')
        self.borderline_intellectual_disability_mild_dementia_and_congenital_heart_disease_due_to_other_chromosomal_abnormalities = kwargs.get('borderline_intellectual_disability_mild_dementia_and_congenital_heart_disease_due_to_other_chromosomal_abnormalities')
        self.mild_intellectual_disability_mild_dementia_and_congenital_heart_disease_due_to_other_chromosomal_abnormalities = kwargs.get('mild_intellectual_disability_mild_dementia_and_congenital_heart_disease_due_to_other_chromosomal_abnormalities')
        self.moderate_intellectual_disability_mild_dementia_and_congenital_heart_disease_due_to_other_chromosomal_abnormalities = kwargs.get('moderate_intellectual_disability_mild_dementia_and_congenital_heart_disease_due_to_other_chromosomal_abnormalities')
        self.severe_intellectual_disability_mild_dementia_and_congenital_heart_disease_due_to_other_chromosomal_abnormalities = kwargs.get('severe_intellectual_disability_mild_dementia_and_congenital_heart_disease_due_to_other_chromosomal_abnormalities')
        self.profound_intellectual_disability_mild_dementia_and_congenital_heart_disease_due_to_other_chromosomal_abnormalities = kwargs.get('profound_intellectual_disability_mild_dementia_and_congenital_heart_disease_due_to_other_chromosomal_abnormalities')
        self.borderline_intellectual_disability_moderate_dementia_and_congenital_heart_disease_due_to_other_chromosomal_abnormalities = kwargs.get('borderline_intellectual_disability_moderate_dementia_and_congenital_heart_disease_due_to_other_chromosomal_abnormalities')
        self.mild_intellectual_disability_moderate_dementia_and_congenital_heart_disease_due_to_other_chromosomal_abnormalities = kwargs.get('mild_intellectual_disability_moderate_dementia_and_congenital_heart_disease_due_to_other_chromosomal_abnormalities')
        self.moderate_intellectual_disability_moderate_dementia_and_congenital_heart_disease_due_to_other_chromosomal_abnormalities = kwargs.get('moderate_intellectual_disability_moderate_dementia_and_congenital_heart_disease_due_to_other_chromosomal_abnormalities')
        self.severe_intellectual_disability_moderate_dementia_and_congenital_heart_disease_due_to_other_chromosomal_abnormalities = kwargs.get('severe_intellectual_disability_moderate_dementia_and_congenital_heart_disease_due_to_other_chromosomal_abnormalities')
        self.profound_intellectual_disability_moderate_dementia_and_congenital_heart_disease_due_to_other_chromosomal_abnormalities = kwargs.get('profound_intellectual_disability_moderate_dementia_and_congenital_heart_disease_due_to_other_chromosomal_abnormalities')
        self.borderline_intellectual_disability_severe_dementia_and_congenital_heart_disease_due_to_other_chromosomal_abnormalities = kwargs.get('borderline_intellectual_disability_severe_dementia_and_congenital_heart_disease_due_to_other_chromosomal_abnormalities')
        self.mild_intellectual_disability_severe_dementia_and_congenital_heart_disease_due_to_other_chromosomal_abnormalities = kwargs.get('mild_intellectual_disability_severe_dementia_and_congenital_heart_disease_due_to_other_chromosomal_abnormalities')
        self.moderate_intellectual_disability_severe_dementia_and_congenital_heart_disease_due_to_other_chromosomal_abnormalities = kwargs.get('moderate_intellectual_disability_severe_dementia_and_congenital_heart_disease_due_to_other_chromosomal_abnormalities')
        self.severe_intellectual_disability_severe_dementia_and_congenital_heart_disease_due_to_other_chromosomal_abnormalities = kwargs.get('severe_intellectual_disability_severe_dementia_and_congenital_heart_disease_due_to_other_chromosomal_abnormalities')
        self.profound_intellectual_disability_severe_dementia_and_congenital_heart_disease_due_to_other_chromosomal_abnormalities = kwargs.get('profound_intellectual_disability_severe_dementia_and_congenital_heart_disease_due_to_other_chromosomal_abnormalities')
        self.profound_intellectual_disability_and_mild_dementia_due_to_down_syndrome = kwargs.get('profound_intellectual_disability_and_mild_dementia_due_to_down_syndrome')
        self.severe_intellectual_disability_and_mild_dementia_due_to_down_syndrome = kwargs.get('severe_intellectual_disability_and_mild_dementia_due_to_down_syndrome')
        self.moderate_intellectual_disability_and_mild_dementia_due_to_down_syndrome = kwargs.get('moderate_intellectual_disability_and_mild_dementia_due_to_down_syndrome')
        self.mild_intellectual_disability_and_mild_dementia_due_to_down_syndrome = kwargs.get('mild_intellectual_disability_and_mild_dementia_due_to_down_syndrome')
        self.borderline_intellectual_disability_and_mild_dementia_due_to_down_syndrome = kwargs.get('borderline_intellectual_disability_and_mild_dementia_due_to_down_syndrome')
        self.profound_intellectual_disability_and_moderate_dementia_due_to_down_syndrome = kwargs.get('profound_intellectual_disability_and_moderate_dementia_due_to_down_syndrome')
        self.severe_intellectual_disability_and_moderate_dementia_due_to_down_syndrome = kwargs.get('severe_intellectual_disability_and_moderate_dementia_due_to_down_syndrome')
        self.moderate_intellectual_disability_and_moderate_dementia_due_to_down_syndrome = kwargs.get('moderate_intellectual_disability_and_moderate_dementia_due_to_down_syndrome')
        self.mild_intellectual_disability_and_moderate_dementia_due_to_down_syndrome = kwargs.get('mild_intellectual_disability_and_moderate_dementia_due_to_down_syndrome')
        self.borderline_intellectual_disability_and_moderate_dementia_due_to_down_syndrome = kwargs.get('borderline_intellectual_disability_and_moderate_dementia_due_to_down_syndrome')
        self.profound_intellectual_disability_and_severe_dementia_due_to_down_syndrome = kwargs.get('profound_intellectual_disability_and_severe_dementia_due_to_down_syndrome')
        self.severe_intellectual_disability_and_severe_dementia_due_to_down_syndrome = kwargs.get('severe_intellectual_disability_and_severe_dementia_due_to_down_syndrome')
        self.moderate_intellectual_disability_and_severe_dementia_due_to_down_syndrome = kwargs.get('moderate_intellectual_disability_and_severe_dementia_due_to_down_syndrome')
        self.mild_intellectual_disability_and_severe_dementia_due_to_down_syndrome = kwargs.get('mild_intellectual_disability_and_severe_dementia_due_to_down_syndrome')
        self.borderline_intellectual_disability_and_severe_dementia_due_to_down_syndrome = kwargs.get('borderline_intellectual_disability_and_severe_dementia_due_to_down_syndrome')
        self.profound_intellectual_disability_and_mild_dementia_due_to_other_chromosomal_abnormalities = kwargs.get('profound_intellectual_disability_and_mild_dementia_due_to_other_chromosomal_abnormalities')
        self.severe_intellectual_disability_and_mild_dementia_due_to_other_chromosomal_abnormalities = kwargs.get('severe_intellectual_disability_and_mild_dementia_due_to_other_chromosomal_abnormalities')
        self.moderate_intellectual_disability_and_mild_dementia_due_to_other_chromosomal_abnormalities = kwargs.get('moderate_intellectual_disability_and_mild_dementia_due_to_other_chromosomal_abnormalities')
        self.mild_intellectual_disability_and_mild_dementia_due_to_other_chromosomal_abnormalities = kwargs.get('mild_intellectual_disability_and_mild_dementia_due_to_other_chromosomal_abnormalities')
        self.borderline_intellectual_disability_and_mild_dementia_due_to_other_chromosomal_abnormalities = kwargs.get('borderline_intellectual_disability_and_mild_dementia_due_to_other_chromosomal_abnormalities')
        self.profound_intellectual_disability_and_moderate_dementia_due_to_other_chromosomal_abnormalities = kwargs.get('profound_intellectual_disability_and_moderate_dementia_due_to_other_chromosomal_abnormalities')
        self.severe_intellectual_disability_and_moderate_dementia_due_to_other_chromosomal_abnormalities = kwargs.get('severe_intellectual_disability_and_moderate_dementia_due_to_other_chromosomal_abnormalities')
        self.moderate_intellectual_disability_and_moderate_dementia_due_to_other_chromosomal_abnormalities = kwargs.get('moderate_intellectual_disability_and_moderate_dementia_due_to_other_chromosomal_abnormalities')
        self.mild_intellectual_disability_and_moderate_dementia_due_to_other_chromosomal_abnormalities = kwargs.get('mild_intellectual_disability_and_moderate_dementia_due_to_other_chromosomal_abnormalities')
        self.borderline_intellectual_disability_and_moderate_dementia_due_to_other_chromosomal_abnormalities = kwargs.get('borderline_intellectual_disability_and_moderate_dementia_due_to_other_chromosomal_abnormalities')
        self.profound_intellectual_disability_and_severe_dementia_due_to_other_chromosomal_abnormalities = kwargs.get('profound_intellectual_disability_and_severe_dementia_due_to_other_chromosomal_abnormalities')
        self.severe_intellectual_disability_and_severe_dementia_due_to_other_chromosomal_abnormalities = kwargs.get('severe_intellectual_disability_and_severe_dementia_due_to_other_chromosomal_abnormalities')
        self.moderate_intellectual_disability_and_severe_dementia_due_to_other_chromosomal_abnormalities = kwargs.get('moderate_intellectual_disability_and_severe_dementia_due_to_other_chromosomal_abnormalities')
        self.mild_intellectual_disability_and_severe_dementia_due_to_other_chromosomal_abnormalities = kwargs.get('mild_intellectual_disability_and_severe_dementia_due_to_other_chromosomal_abnormalities')
        self.borderline_intellectual_disability_and_severe_dementia_due_to_other_chromosomal_abnormalities = kwargs.get('borderline_intellectual_disability_and_severe_dementia_due_to_other_chromosomal_abnormalities')
        self.autism_spectrum_disorders_without_intellectual_disability = kwargs.get('autism_spectrum_disorders_without_intellectual_disability')
        self.autism_spectrum_disorders_with_borderline_intellectual_disability = kwargs.get('autism_spectrum_disorders_with_borderline_intellectual_disability')
        self.autism_spectrum_disorders_with_mild_intellectual_disability = kwargs.get('autism_spectrum_disorders_with_mild_intellectual_disability')
        self.autism_spectrum_disorders_with_moderate_intellectual_disability = kwargs.get('autism_spectrum_disorders_with_moderate_intellectual_disability')
        self.autism_spectrum_disorders_with_severe_intellectual_disability = kwargs.get('autism_spectrum_disorders_with_severe_intellectual_disability')
        self.autism_spectrum_disorders_with_profound_intellectual_disability = kwargs.get('autism_spectrum_disorders_with_profound_intellectual_disability')
        self.asymptomatic_acute_other_sense_organ_diseases = kwargs.get('asymptomatic_acute_other_sense_organ_diseases')
        self.mild_acute_other_sense_organ_diseases = kwargs.get('mild_acute_other_sense_organ_diseases')
        self.moderate_acute_other_sense_organ_diseases = kwargs.get('moderate_acute_other_sense_organ_diseases')
        self.asymptomatic_chronic_other_sense_organ_diseases = kwargs.get('asymptomatic_chronic_other_sense_organ_diseases')
        self.mild_chronic_other_sense_organ_diseases = kwargs.get('mild_chronic_other_sense_organ_diseases')
        self.moderate_chronic_other_sense_organ_diseases = kwargs.get('moderate_chronic_other_sense_organ_diseases')
        self.mild_paragonimiasis_due_to_food_borne_trematodiases = kwargs.get('mild_paragonimiasis_due_to_food_borne_trematodiases')
        self.moderate_paragonimiasis_due_to_food_borne_trematodiases = kwargs.get('moderate_paragonimiasis_due_to_food_borne_trematodiases')
        self.severe_paragonimiasis_due_to_food_borne_trematodiases = kwargs.get('severe_paragonimiasis_due_to_food_borne_trematodiases')
        self.asymptomatic_medication_overuse_headache_due_to_migraine = kwargs.get('asymptomatic_medication_overuse_headache_due_to_migraine')
        self.symptomatic_medication_overuse_headache_due_to_migraine = kwargs.get('symptomatic_medication_overuse_headache_due_to_migraine')
        self.asymptomatic_medication_overuse_headache_due_to_tension_type_headache = kwargs.get('asymptomatic_medication_overuse_headache_due_to_tension_type_headache')
        self.symptomatic_medication_overuse_headache_due_to_tension_type_headache = kwargs.get('symptomatic_medication_overuse_headache_due_to_tension_type_headache')
        self.stage_5_chronic_kidney_disease_untreated_without_anemia_due_to_hypertension = kwargs.get('stage_5_chronic_kidney_disease_untreated_without_anemia_due_to_hypertension')
        self.stage_5_chronic_kidney_disease_untreated_and_mild_anemia_due_to_hypertension = kwargs.get('stage_5_chronic_kidney_disease_untreated_and_mild_anemia_due_to_hypertension')
        self.stage_5_chronic_kidney_disease_untreated_and_moderate_anemia_due_to_hypertension = kwargs.get('stage_5_chronic_kidney_disease_untreated_and_moderate_anemia_due_to_hypertension')
        self.stage_5_chronic_kidney_disease_untreated_and_severe_anemia_due_to_hypertension = kwargs.get('stage_5_chronic_kidney_disease_untreated_and_severe_anemia_due_to_hypertension')
        self.stage_5_chronic_kidney_disease_untreated_without_anemia_due_to_glomerulonephritis = kwargs.get('stage_5_chronic_kidney_disease_untreated_without_anemia_due_to_glomerulonephritis')
        self.stage_5_chronic_kidney_disease_untreated_and_mild_anemia_due_to_glomerulonephritis = kwargs.get('stage_5_chronic_kidney_disease_untreated_and_mild_anemia_due_to_glomerulonephritis')
        self.stage_5_chronic_kidney_disease_untreated_and_moderate_anemia_due_to_glomerulonephritis = kwargs.get('stage_5_chronic_kidney_disease_untreated_and_moderate_anemia_due_to_glomerulonephritis')
        self.stage_5_chronic_kidney_disease_untreated_and_severe_anemia_due_to_glomerulonephritis = kwargs.get('stage_5_chronic_kidney_disease_untreated_and_severe_anemia_due_to_glomerulonephritis')
        self.stage_5_chronic_kidney_disease_untreated_without_anemia_due_to_other_causes = kwargs.get('stage_5_chronic_kidney_disease_untreated_without_anemia_due_to_other_causes')
        self.stage_5_chronic_kidney_disease_untreated_and_mild_anemia_due_to_other_causes = kwargs.get('stage_5_chronic_kidney_disease_untreated_and_mild_anemia_due_to_other_causes')
        self.stage_5_chronic_kidney_disease_untreated_and_moderate_anemia_due_to_other_causes = kwargs.get('stage_5_chronic_kidney_disease_untreated_and_moderate_anemia_due_to_other_causes')
        self.stage_5_chronic_kidney_disease_untreated_and_severe_anemia_due_to_other_causes = kwargs.get('stage_5_chronic_kidney_disease_untreated_and_severe_anemia_due_to_other_causes')
        self.stage_4_chronic_kidney_disease_untreated_without_anemia_due_to_hypertension = kwargs.get('stage_4_chronic_kidney_disease_untreated_without_anemia_due_to_hypertension')
        self.stage_4_chronic_kidney_disease_untreated_and_mild_anemia_due_to_hypertension = kwargs.get('stage_4_chronic_kidney_disease_untreated_and_mild_anemia_due_to_hypertension')
        self.stage_4_chronic_kidney_disease_untreated_and_moderate_anemia_due_to_hypertension = kwargs.get('stage_4_chronic_kidney_disease_untreated_and_moderate_anemia_due_to_hypertension')
        self.stage_4_chronic_kidney_disease_untreated_and_severe_anemia_due_to_hypertension = kwargs.get('stage_4_chronic_kidney_disease_untreated_and_severe_anemia_due_to_hypertension')
        self.stage_4_chronic_kidney_disease_untreated_without_anemia_due_to_glomerulonephritis = kwargs.get('stage_4_chronic_kidney_disease_untreated_without_anemia_due_to_glomerulonephritis')
        self.stage_4_chronic_kidney_disease_untreated_and_mild_anemia_due_to_glomerulonephritis = kwargs.get('stage_4_chronic_kidney_disease_untreated_and_mild_anemia_due_to_glomerulonephritis')
        self.stage_4_chronic_kidney_disease_untreated_and_moderate_anemia_due_to_glomerulonephritis = kwargs.get('stage_4_chronic_kidney_disease_untreated_and_moderate_anemia_due_to_glomerulonephritis')
        self.stage_4_chronic_kidney_disease_untreated_and_severe_anemia_due_to_glomerulonephritis = kwargs.get('stage_4_chronic_kidney_disease_untreated_and_severe_anemia_due_to_glomerulonephritis')
        self.stage_4_chronic_kidney_disease_untreated_without_anemia_due_to_other_causes = kwargs.get('stage_4_chronic_kidney_disease_untreated_without_anemia_due_to_other_causes')
        self.stage_4_chronic_kidney_disease_untreated_and_mild_anemia_due_to_other_causes = kwargs.get('stage_4_chronic_kidney_disease_untreated_and_mild_anemia_due_to_other_causes')
        self.stage_4_chronic_kidney_disease_untreated_and_moderate_anemia_due_to_other_causes = kwargs.get('stage_4_chronic_kidney_disease_untreated_and_moderate_anemia_due_to_other_causes')
        self.stage_4_chronic_kidney_disease_untreated_and_severe_anemia_due_to_other_causes = kwargs.get('stage_4_chronic_kidney_disease_untreated_and_severe_anemia_due_to_other_causes')
        self.skin_disfigurement_due_to_trypanosoma_brucei_gambiense = kwargs.get('skin_disfigurement_due_to_trypanosoma_brucei_gambiense')
        self.sleeping_sickness_due_to_trypanosoma_brucei_gambiense = kwargs.get('sleeping_sickness_due_to_trypanosoma_brucei_gambiense')
        self.sleeping_sickness_due_to_trypanosoma_brucei_rhodesiense = kwargs.get('sleeping_sickness_due_to_trypanosoma_brucei_rhodesiense')
        self.skin_disfigurement_due_to_trypanosoma_brucei_rhodesiense = kwargs.get('skin_disfigurement_due_to_trypanosoma_brucei_rhodesiense')
        self.metastatic_phase_of_other_leukemia = kwargs.get('metastatic_phase_of_other_leukemia')
        self.diagnosis_and_primary_therapy_phase_of_other_leukemia = kwargs.get('diagnosis_and_primary_therapy_phase_of_other_leukemia')
        self.terminal_phase_of_other_leukemia = kwargs.get('terminal_phase_of_other_leukemia')
        self.controlled_phase_of_other_leukemia = kwargs.get('controlled_phase_of_other_leukemia')
        self.drug_susceptible_tuberculosis = kwargs.get('drug_susceptible_tuberculosis')
        self.multidrug_resistant_tuberculosis_without_extensive_drug_resistance = kwargs.get('multidrug_resistant_tuberculosis_without_extensive_drug_resistance')
        self.extensively_drug_resistant_tuberculosis = kwargs.get('extensively_drug_resistant_tuberculosis')
        self.acute_zika_infection = kwargs.get('acute_zika_infection')
        self.guillain_barre_syndrome_due_to_zika_infection = kwargs.get('guillain_barre_syndrome_due_to_zika_infection')
        self.congenital_zika_syndrome = kwargs.get('congenital_zika_syndrome')
        self.asymptomatic_zika_infection = kwargs.get('asymptomatic_zika_infection')
        self.mild_heart_failure_due_to_myocarditis = kwargs.get('mild_heart_failure_due_to_myocarditis')
        self.moderate_heart_failure_due_to_myocarditis = kwargs.get('moderate_heart_failure_due_to_myocarditis')
        self.severe_heart_failure_due_to_myocarditis = kwargs.get('severe_heart_failure_due_to_myocarditis')
        self.mild_heart_failure_due_to_alcoholic_cardiomyopathy = kwargs.get('mild_heart_failure_due_to_alcoholic_cardiomyopathy')
        self.moderate_heart_failure_due_to_alcoholic_cardiomyopathy = kwargs.get('moderate_heart_failure_due_to_alcoholic_cardiomyopathy')
        self.severe_heart_failure_due_to_alcoholic_cardiomyopathy = kwargs.get('severe_heart_failure_due_to_alcoholic_cardiomyopathy')
        self.mild_heart_failure_due_to_other_cardiomyopathy = kwargs.get('mild_heart_failure_due_to_other_cardiomyopathy')
        self.moderate_heart_failure_due_to_other_cardiomyopathy = kwargs.get('moderate_heart_failure_due_to_other_cardiomyopathy')
        self.severe_heart_failure_due_to_other_cardiomyopathy = kwargs.get('severe_heart_failure_due_to_other_cardiomyopathy')
        self.disfigurement_level_1_due_to_polydactyly_and_syndactyly = kwargs.get('disfigurement_level_1_due_to_polydactyly_and_syndactyly')
        self.disfigurement_level_2_due_to_congenital_limb_deficiency = kwargs.get('disfigurement_level_2_due_to_congenital_limb_deficiency')
        self.disfigurement_level_2_with_pain_due_to_congenital_limb_deficiency = kwargs.get('disfigurement_level_2_with_pain_due_to_congenital_limb_deficiency')
        self.disfigurement_level_2_and_mild_motor_impairment_due_to_congenital_limb_deficiency = kwargs.get('disfigurement_level_2_and_mild_motor_impairment_due_to_congenital_limb_deficiency')
        self.disfigurement_level_2_and_moderate_motor_impairment_due_to_congenital_limb_deficiency = kwargs.get('disfigurement_level_2_and_moderate_motor_impairment_due_to_congenital_limb_deficiency')
        self.disfigurement_level_2_with_pain_and_mild_motor_impairment_due_to_congenital_limb_deficiency = kwargs.get('disfigurement_level_2_with_pain_and_mild_motor_impairment_due_to_congenital_limb_deficiency')
        self.disfigurement_level_2_with_pain_and_moderate_motor_impairment_due_to_congenital_limb_deficiency = kwargs.get('disfigurement_level_2_with_pain_and_moderate_motor_impairment_due_to_congenital_limb_deficiency')
        self.disfigurement_level_2_due_to_other_congenital_musculoskeletal_anomalies = kwargs.get('disfigurement_level_2_due_to_other_congenital_musculoskeletal_anomalies')
        self.disfigurement_level_2_with_pain_due_to_other_congenital_musculoskeletal_anomalies = kwargs.get('disfigurement_level_2_with_pain_due_to_other_congenital_musculoskeletal_anomalies')
        self.disfigurement_level_2_and_mild_motor_impairment_due_to_other_congenital_musculoskeletal_anomalies = kwargs.get('disfigurement_level_2_and_mild_motor_impairment_due_to_other_congenital_musculoskeletal_anomalies')
        self.disfigurement_level_2_and_moderate_motor_impairment_due_to_other_congenital_musculoskeletal_anomalies = kwargs.get('disfigurement_level_2_and_moderate_motor_impairment_due_to_other_congenital_musculoskeletal_anomalies')
        self.disfigurement_level_2_with_pain_and_mild_motor_impairment_due_to_other_congenital_musculoskeletal_anomalies = kwargs.get('disfigurement_level_2_with_pain_and_mild_motor_impairment_due_to_other_congenital_musculoskeletal_anomalies')
        self.disfigurement_level_2_with_pain_and_moderate_motor_impairment_due_to_other_congenital_musculoskeletal_anomalies = kwargs.get('disfigurement_level_2_with_pain_and_moderate_motor_impairment_due_to_other_congenital_musculoskeletal_anomalies')
        self.asymptomatic_congenital_diaphragmatic_hernia = kwargs.get('asymptomatic_congenital_diaphragmatic_hernia')
        self.chronic_abdominal_pain_due_to_congenital_diaphragmatic_hernia = kwargs.get('chronic_abdominal_pain_due_to_congenital_diaphragmatic_hernia')
        self.disfigurement_due_to_congenital_diaphragmatic_hernia = kwargs.get('disfigurement_due_to_congenital_diaphragmatic_hernia')
        self.mild_chronic_respiratory_problems_and_breathlessness_due_to_congenital_diaphragmatic_hernia = kwargs.get('mild_chronic_respiratory_problems_and_breathlessness_due_to_congenital_diaphragmatic_hernia')
        self.developmental_delay_or_mild_intellectual_disability_due_to_congenital_diaphragmatic_hernia = kwargs.get('developmental_delay_or_mild_intellectual_disability_due_to_congenital_diaphragmatic_hernia')
        self.chronic_abdominal_pain_and_disfigurement_due_to_congenital_diaphragmatic_hernia = kwargs.get('chronic_abdominal_pain_and_disfigurement_due_to_congenital_diaphragmatic_hernia')
        self.chronic_abdominal_pain_and_mild_chronic_respiratory_problems_due_to_congenital_diaphragmatic_hernia = kwargs.get('chronic_abdominal_pain_and_mild_chronic_respiratory_problems_due_to_congenital_diaphragmatic_hernia')
        self.chronic_abdominal_pain_and_developmental_delay_due_to_congenital_diaphragmatic_hernia = kwargs.get('chronic_abdominal_pain_and_developmental_delay_due_to_congenital_diaphragmatic_hernia')
        self.disfigurement_and_mild_chronic_respiratory_problems_due_to_congenital_diaphragmatic_hernia = kwargs.get('disfigurement_and_mild_chronic_respiratory_problems_due_to_congenital_diaphragmatic_hernia')
        self.disfigurement_and_developmental_delay_due_to_congenital_diaphragmatic_hernia = kwargs.get('disfigurement_and_developmental_delay_due_to_congenital_diaphragmatic_hernia')
        self._mild_chronic_respiratory_problems_and_developmental_delay_due_to_congenital_diaphragmatic_hernia = kwargs.get('_mild_chronic_respiratory_problems_and_developmental_delay_due_to_congenital_diaphragmatic_hernia')
        self.chronic_abdominal_pain_disfigurement_and_chronic_respiratory_problems_due_to_congenital_diaphragmatic_hernia = kwargs.get('chronic_abdominal_pain_disfigurement_and_chronic_respiratory_problems_due_to_congenital_diaphragmatic_hernia')
        self.chronic_abdominal_pain_disfigurement_and_developmental_delay_due_to_congenital_diaphragmatic_hernia = kwargs.get('chronic_abdominal_pain_disfigurement_and_developmental_delay_due_to_congenital_diaphragmatic_hernia')
        self.chronic_abdominal_pain_chronic_respiratory_problems_and_developmental_delay_due_to_congenital_diaphragmatic_hernia = kwargs.get('chronic_abdominal_pain_chronic_respiratory_problems_and_developmental_delay_due_to_congenital_diaphragmatic_hernia')
        self.disfigurement_chronic_respiratory_problems_and_developmental_delay_due_to_congenital_diaphragmatic_hernia = kwargs.get('disfigurement_chronic_respiratory_problems_and_developmental_delay_due_to_congenital_diaphragmatic_hernia')
        self.chronic_abdominal_pain_disfigurement_developmental_delay_and_chronic_respiratory_problems_due_to_congenital_diaphragmatic_hernia = kwargs.get('chronic_abdominal_pain_disfigurement_developmental_delay_and_chronic_respiratory_problems_due_to_congenital_diaphragmatic_hernia')
        self.asymptomatic_congenital_atresia_and_or_stenosis_of_the_digestive_tract = kwargs.get('asymptomatic_congenital_atresia_and_or_stenosis_of_the_digestive_tract')
        self.dysphagia_or_acid_reflux_due_to_congenital_atresia_and_or_stenosis_of_the_digestive_tract = kwargs.get('dysphagia_or_acid_reflux_due_to_congenital_atresia_and_or_stenosis_of_the_digestive_tract')
        self.chronic_abdominal_pain_due_to_congenital_atresia_and_or_stenosis_of_the_digestive_tract = kwargs.get('chronic_abdominal_pain_due_to_congenital_atresia_and_or_stenosis_of_the_digestive_tract')
        self.chronic_respiratory_problems_including_difficulty_breaking_and_recurrent_upper_respiratory_infections_due_to_atresia_and_or_stenosis_of_the_digestive_tract = kwargs.get('chronic_respiratory_problems_including_difficulty_breaking_and_recurrent_upper_respiratory_infections_due_to_atresia_and_or_stenosis_of_the_digestive_tract')
        self.chronic_respiratory_problems_and_dysphagia_or_acid_reflux_due_to_congenital_atresia_and_or_stenosis_of_the_digestive_tract = kwargs.get('chronic_respiratory_problems_and_dysphagia_or_acid_reflux_due_to_congenital_atresia_and_or_stenosis_of_the_digestive_tract')
        self.chronic_respiratory_problems_and_abdominal_pain_due_to_congenital_atresia_and_or_stenosis_of_the_digestive_tract = kwargs.get('chronic_respiratory_problems_and_abdominal_pain_due_to_congenital_atresia_and_or_stenosis_of_the_digestive_tract')
        self.dysphagia_or_acid_reflux_and_chronic_abdominal_pain_due_to_congenital_atresia_and_or_stenosis_of_the_digestive_tract = kwargs.get('dysphagia_or_acid_reflux_and_chronic_abdominal_pain_due_to_congenital_atresia_and_or_stenosis_of_the_digestive_tract')
        self.dysphagia_or_acid_reflux_chronic_abdominal_pain_and_chronic_respiratory_problems_due_to_congenital_atresia_and_or_stenosis_of_the_digestive_tract = kwargs.get('dysphagia_or_acid_reflux_chronic_abdominal_pain_and_chronic_respiratory_problems_due_to_congenital_atresia_and_or_stenosis_of_the_digestive_tract')
        self.asymptomatic_congenital_malformations_of_the_abdominal_wall_after_treatment = kwargs.get('asymptomatic_congenital_malformations_of_the_abdominal_wall_after_treatment')
        self.disfigurement_from_scars_following_treatment_for_congenital_malformations_of_the_abdominal_wall = kwargs.get('disfigurement_from_scars_following_treatment_for_congenital_malformations_of_the_abdominal_wall')
        self.constipation_due_to_congenital_malformations_of_the_abdominal_wall = kwargs.get('constipation_due_to_congenital_malformations_of_the_abdominal_wall')
        self.chronic_abdominal_pain_due_to_congenital_malformations_of_the_abdominal_wall = kwargs.get('chronic_abdominal_pain_due_to_congenital_malformations_of_the_abdominal_wall')
        self.constipation_and_concern_about_scars_due_to_congenital_malformations_of_the_abdominal_wall = kwargs.get('constipation_and_concern_about_scars_due_to_congenital_malformations_of_the_abdominal_wall')
        self.chronic_abdominal_pain_and_concern_about_scars_due_to_congenital_malformations_of_the_abdominal_wall = kwargs.get('chronic_abdominal_pain_and_concern_about_scars_due_to_congenital_malformations_of_the_abdominal_wall')
        self.constipation_and_chronic_abdominal_pain_due_to_congenital_malformations_of_the_abdominal_wall = kwargs.get('constipation_and_chronic_abdominal_pain_due_to_congenital_malformations_of_the_abdominal_wall')
        self.constipation_chronic_abdominal_pain_and_concern_about_scars_due_to_congenital_malformations_of_the_abdominal_wall = kwargs.get('constipation_chronic_abdominal_pain_and_concern_about_scars_due_to_congenital_malformations_of_the_abdominal_wall')
        self.asymptomatic_other_congenital_malformations_of_the_digestive_tract = kwargs.get('asymptomatic_other_congenital_malformations_of_the_digestive_tract')
        self.acid_reflux_dyspahgia_and_or_constipation_due_to_other_congenital_malformations_of_the_digestive_tract = kwargs.get('acid_reflux_dyspahgia_and_or_constipation_due_to_other_congenital_malformations_of_the_digestive_tract')
        self.chronic_abdominal_pain_and_or_nausea_due_to_other_congenital_malformations_of_the_digestive_tract = kwargs.get('chronic_abdominal_pain_and_or_nausea_due_to_other_congenital_malformations_of_the_digestive_tract')
        self.chronic_abdominal_pain_and_or_nausea_with_acid_reflux_dyspahgia_and_or_constipation_due_to_other_congenital_malformations_of_the_digestive_tract = kwargs.get('chronic_abdominal_pain_and_or_nausea_with_acid_reflux_dyspahgia_and_or_constipation_due_to_other_congenital_malformations_of_the_digestive_tract')
        self.asymptomatic_congenital_genital_anomalies = kwargs.get('asymptomatic_congenital_genital_anomalies')
        self.atypical_genitalia_due_to_congenital_genital_anomalies = kwargs.get('atypical_genitalia_due_to_congenital_genital_anomalies')
        self.primary_infertility_due_to_congenital_genital_anomalies = kwargs.get('primary_infertility_due_to_congenital_genital_anomalies')
        self.impotence_due_to_congenital_genital_anomalies = kwargs.get('impotence_due_to_congenital_genital_anomalies')
        self.recurrent_urinary_tract_infections_or_other_abdominal_issues_due_to_congenital_genital_anomalies = kwargs.get('recurrent_urinary_tract_infections_or_other_abdominal_issues_due_to_congenital_genital_anomalies')
        self.atypical_genital_and_recurrent_urinary_tract_infections_and_other_abdominal_issues_due_to_congenital_genital_anomalies = kwargs.get('atypical_genital_and_recurrent_urinary_tract_infections_and_other_abdominal_issues_due_to_congenital_genital_anomalies')
        self.atypical_genitalia_and_primary_infertility_due_to_congenital_genital_anomalies = kwargs.get('atypical_genitalia_and_primary_infertility_due_to_congenital_genital_anomalies')
        self.atypical_genitalia_and_impotence_due_to_congenital_genital_anomalies = kwargs.get('atypical_genitalia_and_impotence_due_to_congenital_genital_anomalies')
        self.primary_infertility_and_recurrent_urinary_tract_infections_or_other_abdominal_issues_due_to_congenital_genital_anomalies = kwargs.get('primary_infertility_and_recurrent_urinary_tract_infections_or_other_abdominal_issues_due_to_congenital_genital_anomalies')
        self.impotence_and_recurrent_urinary_tract_infections_or_other_abdominal_issues_due_to_congenital_genital_anomalies = kwargs.get('impotence_and_recurrent_urinary_tract_infections_or_other_abdominal_issues_due_to_congenital_genital_anomalies')
        self.infertility_and_impotence_due_to_congenital_genital_anomalies = kwargs.get('infertility_and_impotence_due_to_congenital_genital_anomalies')
        self.atypical_genitalia_recurrent_urinary_tract_infections_or_other_abdominal_issues_and_infertility_due_to_congenital_genital_anomalies = kwargs.get('atypical_genitalia_recurrent_urinary_tract_infections_or_other_abdominal_issues_and_infertility_due_to_congenital_genital_anomalies')
        self.atypical_genitalia_recurrent_urinary_tract_infections_or_other_abdominal_issues_and_impotence_due_to_congenital_genital_anomalies = kwargs.get('atypical_genitalia_recurrent_urinary_tract_infections_or_other_abdominal_issues_and_impotence_due_to_congenital_genital_anomalies')
        self.atypical_genitalia_infertility_and_impotence_due_to_congenital_genital_anomalies = kwargs.get('atypical_genitalia_infertility_and_impotence_due_to_congenital_genital_anomalies')
        self.infertility_impotence_and_recurrent_urinary_tract_infections_or_other_abdominal_issues_and_impotence_due_to_congenital_genital_anomalies = kwargs.get('infertility_impotence_and_recurrent_urinary_tract_infections_or_other_abdominal_issues_and_impotence_due_to_congenital_genital_anomalies')
        self.atypical_genitalia_infertility_impotence_and_recurrent_urinary_tract_infections_or_other_abdominal_issues_and_impotence_due_to_congenital_genital_anomalies = kwargs.get('atypical_genitalia_infertility_impotence_and_recurrent_urinary_tract_infections_or_other_abdominal_issues_and_impotence_due_to_congenital_genital_anomalies')
        self.asymptomatic_ventricular_septal_defect_and_atrial_septal_defect = kwargs.get('asymptomatic_ventricular_septal_defect_and_atrial_septal_defect')
        self.asymptomatic_congenital_anomalies_of_the_urinary_tract = kwargs.get('asymptomatic_congenital_anomalies_of_the_urinary_tract')
        self.atypical_genitalia_due_to_congenital_anomalies_of_the_urinary_tract = kwargs.get('atypical_genitalia_due_to_congenital_anomalies_of_the_urinary_tract')
        self.incontinence_due_to_congenital_anomalies_of_the_urinary_tract = kwargs.get('incontinence_due_to_congenital_anomalies_of_the_urinary_tract')
        self.impotence_due_to_congenital_anomalies_of_the_urinary_tract = kwargs.get('impotence_due_to_congenital_anomalies_of_the_urinary_tract')
        self.recurrent_urinary_tract_infections_or_other_abdominal_issues_due_to_congenital_anomalies_of_the_urinary_tract = kwargs.get('recurrent_urinary_tract_infections_or_other_abdominal_issues_due_to_congenital_anomalies_of_the_urinary_tract')
        self.atypical_genital_and_recurrent_urinary_tract_infections_and_other_abdominal_issues_due_to_congenital_anomalies_of_the_urinary_tract = kwargs.get('atypical_genital_and_recurrent_urinary_tract_infections_and_other_abdominal_issues_due_to_congenital_anomalies_of_the_urinary_tract')
        self.atypical_genitalia_and_incontinence_due_to_congenital_anomalies_of_the_urinary_tract = kwargs.get('atypical_genitalia_and_incontinence_due_to_congenital_anomalies_of_the_urinary_tract')
        self.atypical_genitalia_and_impotence_due_to_congenital_anomalies_of_the_urinary_tract = kwargs.get('atypical_genitalia_and_impotence_due_to_congenital_anomalies_of_the_urinary_tract')
        self.incontinence_and_recurrent_urinary_tract_infections_or_other_abdominal_issues_due_to_congenital_anomalies_of_the_urinary_tract = kwargs.get('incontinence_and_recurrent_urinary_tract_infections_or_other_abdominal_issues_due_to_congenital_anomalies_of_the_urinary_tract')
        self.impotence_and_recurrent_urinary_tract_infections_or_other_abdominal_issues_due_to_congenital_anomalies_of_the_urinary_tract = kwargs.get('impotence_and_recurrent_urinary_tract_infections_or_other_abdominal_issues_due_to_congenital_anomalies_of_the_urinary_tract')
        self.incontinence_and_impotence_due_to_congenital_anomalies_of_the_urinary_tract = kwargs.get('incontinence_and_impotence_due_to_congenital_anomalies_of_the_urinary_tract')
        self.atypical_genitalia_recurrent_urinary_tract_infections_or_other_abdominal_issues_and_incontinence_due_to_congenital_anomalies_of_the_urinary_tract = kwargs.get('atypical_genitalia_recurrent_urinary_tract_infections_or_other_abdominal_issues_and_incontinence_due_to_congenital_anomalies_of_the_urinary_tract')
        self.atypical_genitalia_recurrent_urinary_tract_infections_or_other_abdominal_issues_and_impotence_due_to_congenital_anomalies_of_the_urinary_tract = kwargs.get('atypical_genitalia_recurrent_urinary_tract_infections_or_other_abdominal_issues_and_impotence_due_to_congenital_anomalies_of_the_urinary_tract')
        self.atypical_genitalia_incontinence_and_impotence_due_to_congenital_anomalies_of_the_urinary_tract = kwargs.get('atypical_genitalia_incontinence_and_impotence_due_to_congenital_anomalies_of_the_urinary_tract')
        self.incontinence_impotence_and_recurrent_urinary_tract_infections_or_other_abdominal_issues_and_impotence_due_to_congenital_anomalies_of_the_urinary_tract = kwargs.get('incontinence_impotence_and_recurrent_urinary_tract_infections_or_other_abdominal_issues_and_impotence_due_to_congenital_anomalies_of_the_urinary_tract')
        self.atypical_genitalia_incontinence_impotence_and_recurrent_urinary_tract_infections_or_other_abdominal_issues_and_impotence_due_to_congenital_anomalies_of_the_urinary_tract = kwargs.get('atypical_genitalia_incontinence_impotence_and_recurrent_urinary_tract_infections_or_other_abdominal_issues_and_impotence_due_to_congenital_anomalies_of_the_urinary_tract')
        self.severe_motor_and_cognitive_impairment_due_to_edward_syndrome_or_patau_syndrome = kwargs.get('severe_motor_and_cognitive_impairment_due_to_edward_syndrome_or_patau_syndrome')
        self.severe_motor_and_cognitive_impairment_with_congenital_heart_disease_due_to_edward_syndrome_or_patau_syndrome = kwargs.get('severe_motor_and_cognitive_impairment_with_congenital_heart_disease_due_to_edward_syndrome_or_patau_syndrome')
        self.severe_motor_and_cognitive_impairment_due_to_anencephaly = kwargs.get('severe_motor_and_cognitive_impairment_due_to_anencephaly')
        self.asymptomatic_encephalocele_following_treatment = kwargs.get('asymptomatic_encephalocele_following_treatment')
        self.borderline_intellectual_disability_due_to_encephalocele = kwargs.get('borderline_intellectual_disability_due_to_encephalocele')
        self.mild_intellectual_disability_due_to_encephalocele = kwargs.get('mild_intellectual_disability_due_to_encephalocele')
        self.moderate_intellectual_disability_due_to_encephalocele = kwargs.get('moderate_intellectual_disability_due_to_encephalocele')
        self.severe_intellectual_disability_due_to_encephalocele = kwargs.get('severe_intellectual_disability_due_to_encephalocele')
        self.profound_intellectual_disability_due_to_encephalocele = kwargs.get('profound_intellectual_disability_due_to_encephalocele')
        self.incontinence_due_to_encephalocele = kwargs.get('incontinence_due_to_encephalocele')
        self.borderline_intellectual_disability_and_incontinence_due_to_encephalocele = kwargs.get('borderline_intellectual_disability_and_incontinence_due_to_encephalocele')
        self.mild_intellectual_disability_and_incontinence_due_to_encephalocele = kwargs.get('mild_intellectual_disability_and_incontinence_due_to_encephalocele')
        self.moderate_intellectual_disability_and_incontinence_due_to_encephalocele = kwargs.get('moderate_intellectual_disability_and_incontinence_due_to_encephalocele')
        self.severe_intellectual_disability_and_incontinence_due_to_encephalocele = kwargs.get('severe_intellectual_disability_and_incontinence_due_to_encephalocele')
        self.profound_intellectual_disability_and_incontinence_due_to_encephalocele = kwargs.get('profound_intellectual_disability_and_incontinence_due_to_encephalocele')
        self.mild_motor_impairment_due_to_spina_bifida = kwargs.get('mild_motor_impairment_due_to_spina_bifida')
        self.moderate_motor_impairment_due_to_spina_bifida = kwargs.get('moderate_motor_impairment_due_to_spina_bifida')
        self.severe_motor_impairment_due_to_spina_bifida = kwargs.get('severe_motor_impairment_due_to_spina_bifida')
        self.mild_motor_impairment_and_borderline_intellectual_disability_due_to_spina_bifida = kwargs.get('mild_motor_impairment_and_borderline_intellectual_disability_due_to_spina_bifida')
        self.moderate_motor_impairment_and_borderline_intellectual_disability_due_to_spina_bifida = kwargs.get('moderate_motor_impairment_and_borderline_intellectual_disability_due_to_spina_bifida')
        self.severe_motor_impairment_and_borderline_intellectual_disability_due_to_spina_bifida = kwargs.get('severe_motor_impairment_and_borderline_intellectual_disability_due_to_spina_bifida')
        self.mild_motor_impairment_and_mild_intellectual_disability_due_to_spina_bifida = kwargs.get('mild_motor_impairment_and_mild_intellectual_disability_due_to_spina_bifida')
        self.moderate_motor_impairment_and_mild_intellectual_disability_due_to_spina_bifida = kwargs.get('moderate_motor_impairment_and_mild_intellectual_disability_due_to_spina_bifida')
        self.severe_motor_impairment_and_mild_intellectual_disability_due_to_spina_bifida = kwargs.get('severe_motor_impairment_and_mild_intellectual_disability_due_to_spina_bifida')
        self.mild_motor_impairment_and_moderate_intellectual_disability_due_to_spina_bifida = kwargs.get('mild_motor_impairment_and_moderate_intellectual_disability_due_to_spina_bifida')
        self.moderate_motor_impairment_and_moderate_intellectual_disability_due_to_spina_bifida = kwargs.get('moderate_motor_impairment_and_moderate_intellectual_disability_due_to_spina_bifida')
        self.severe_motor_impairment_and_moderate_intellectual_disability_due_to_spina_bifida = kwargs.get('severe_motor_impairment_and_moderate_intellectual_disability_due_to_spina_bifida')
        self.mild_motor_impairment_and_severe_intellectual_disability_due_to_spina_bifida = kwargs.get('mild_motor_impairment_and_severe_intellectual_disability_due_to_spina_bifida')
        self.moderate_motor_impairment_and_severe_intellectual_disability_due_to_spina_bifida = kwargs.get('moderate_motor_impairment_and_severe_intellectual_disability_due_to_spina_bifida')
        self.severe_motor_impairment_and_severe_intellectual_disability_due_to_spina_bifida = kwargs.get('severe_motor_impairment_and_severe_intellectual_disability_due_to_spina_bifida')
        self.mild_motor_impairment_borderline_intellectual_disability_and_incontinence_due_to_spina_bifida = kwargs.get('mild_motor_impairment_borderline_intellectual_disability_and_incontinence_due_to_spina_bifida')
        self.moderate_motor_impairment_borderline_intellectual_disability_and_incontinence_due_to_spina_bifida = kwargs.get('moderate_motor_impairment_borderline_intellectual_disability_and_incontinence_due_to_spina_bifida')
        self.severe_motor_impairment_borderline_intellectual_disability_and_incontinence_due_to_spina_bifida = kwargs.get('severe_motor_impairment_borderline_intellectual_disability_and_incontinence_due_to_spina_bifida')
        self.mild_motor_impairment_mild_intellectual_disability_and_incontinence_due_to_spina_bifida = kwargs.get('mild_motor_impairment_mild_intellectual_disability_and_incontinence_due_to_spina_bifida')
        self.moderate_motor_impairment_mild_intellectual_disability_and_incontinence_due_to_spina_bifida = kwargs.get('moderate_motor_impairment_mild_intellectual_disability_and_incontinence_due_to_spina_bifida')
        self.severe_motor_impairment_mild_intellectual_disability_and_incontinence_due_to_spina_bifida = kwargs.get('severe_motor_impairment_mild_intellectual_disability_and_incontinence_due_to_spina_bifida')
        self.mild_motor_impairment_moderate_intellectual_disability_and_incontinence_due_to_spina_bifida = kwargs.get('mild_motor_impairment_moderate_intellectual_disability_and_incontinence_due_to_spina_bifida')
        self.moderate_motor_impairment_moderate_intellectual_disability_and_incontinence_due_to_spina_bifida = kwargs.get('moderate_motor_impairment_moderate_intellectual_disability_and_incontinence_due_to_spina_bifida')
        self.severe_motor_impairment_moderate_intellectual_disability_and_incontinence_due_to_spina_bifida = kwargs.get('severe_motor_impairment_moderate_intellectual_disability_and_incontinence_due_to_spina_bifida')
        self.mild_motor_impairment_severe_intellectual_disability_and_incontinence_due_to_spina_bifida = kwargs.get('mild_motor_impairment_severe_intellectual_disability_and_incontinence_due_to_spina_bifida')
        self.moderate_motor_impairment_severe_intellectual_disability_and_incontinence_due_to_spina_bifida = kwargs.get('moderate_motor_impairment_severe_intellectual_disability_and_incontinence_due_to_spina_bifida')
        self.severe_motor_impairment_severe_intellectual_disability_and_incontinence_due_to_spina_bifida = kwargs.get('severe_motor_impairment_severe_intellectual_disability_and_incontinence_due_to_spina_bifida')
        self.mild_motor_impairment_and_incontinence_due_to_spina_bifida = kwargs.get('mild_motor_impairment_and_incontinence_due_to_spina_bifida')
        self.moderate_motor_impairment_and_incontinence_due_to_spina_bifida = kwargs.get('moderate_motor_impairment_and_incontinence_due_to_spina_bifida')
        self.severe_motor_impairment_and_incontinence_due_to_spina_bifida = kwargs.get('severe_motor_impairment_and_incontinence_due_to_spina_bifida')
        self.moderate_wasting_without_edema = kwargs.get('moderate_wasting_without_edema')
        self.severe_wasting_with_edema = kwargs.get('severe_wasting_with_edema')
        self.mild_disfigurement_due_to_squamous_cell_carcinoma = kwargs.get('mild_disfigurement_due_to_squamous_cell_carcinoma')
        self.moderate_disfigurement_due_to_squamous_cell_carcinoma = kwargs.get('moderate_disfigurement_due_to_squamous_cell_carcinoma')
        self.severe_disfigurement_due_to_squamous_cell_carcinoma = kwargs.get('severe_disfigurement_due_to_squamous_cell_carcinoma')
        self.neurological_problems_and_cardiovascular_complications_due_to_adult_tertiary_syphilis = kwargs.get('neurological_problems_and_cardiovascular_complications_due_to_adult_tertiary_syphilis')
        self.severe_disfigurement_and_cardiovascular_complications_due_to_adult_tertiary_syphilis = kwargs.get('severe_disfigurement_and_cardiovascular_complications_due_to_adult_tertiary_syphilis')
        self.severe_disfigurement_and_neurological_problems_due_to_adult_tertiary_syphilis = kwargs.get('severe_disfigurement_and_neurological_problems_due_to_adult_tertiary_syphilis')
        self.severe_disfigurement_neurological_problems_and_cardiovascular_complications_due_to_adult_tertiary_syphilis = kwargs.get('severe_disfigurement_neurological_problems_and_cardiovascular_complications_due_to_adult_tertiary_syphilis')
        self.mild_motor_impairment_and_profound_intellectual_disability_due_to_spina_bifida = kwargs.get('mild_motor_impairment_and_profound_intellectual_disability_due_to_spina_bifida')
        self.moderate_motor_impairment_and_profound_intellectual_disability_due_to_spina_bifida = kwargs.get('moderate_motor_impairment_and_profound_intellectual_disability_due_to_spina_bifida')
        self.severe_motor_impairment_and_profound_intellectual_disability_due_to_spina_bifida = kwargs.get('severe_motor_impairment_and_profound_intellectual_disability_due_to_spina_bifida')
        self.mild_motor_impairment_profound_intellectual_disability_and_incontinence_due_to_spina_bifida = kwargs.get('mild_motor_impairment_profound_intellectual_disability_and_incontinence_due_to_spina_bifida')
        self.moderate_motor_impairment_profound_intellectual_disability_and_incontinence_due_to_spina_bifida = kwargs.get('moderate_motor_impairment_profound_intellectual_disability_and_incontinence_due_to_spina_bifida')
        self.severe_motor_impairment_profound_intellectual_disability_and_incontinence_due_to_spina_bifida = kwargs.get('severe_motor_impairment_profound_intellectual_disability_and_incontinence_due_to_spina_bifida')
        self.mild_motor_impairment_due_to_encephalocele = kwargs.get('mild_motor_impairment_due_to_encephalocele')
        self.moderate_motor_impairment_due_to_encephalocele = kwargs.get('moderate_motor_impairment_due_to_encephalocele')
        self.severe_motor_impairment_due_to_encephalocele = kwargs.get('severe_motor_impairment_due_to_encephalocele')
        self.mild_motor_impairment_and_incontinence_due_to_encephalocele = kwargs.get('mild_motor_impairment_and_incontinence_due_to_encephalocele')
        self.moderate_motor_impairment_and_incontinence_due_to_encephalocele = kwargs.get('moderate_motor_impairment_and_incontinence_due_to_encephalocele')
        self.severe_motor_impairment_and_incontinence_due_to_encephalocele = kwargs.get('severe_motor_impairment_and_incontinence_due_to_encephalocele')
        self.mild_motor_impairment_and_borderline_intellectual_disability_due_to_encephalocele = kwargs.get('mild_motor_impairment_and_borderline_intellectual_disability_due_to_encephalocele')
        self.moderate_motor_impairment_and_borderline_intellectual_disability_due_to_encephalocele = kwargs.get('moderate_motor_impairment_and_borderline_intellectual_disability_due_to_encephalocele')
        self.severe_motor_impairment_and_borderline_intellectual_disability_due_to_encephalocele = kwargs.get('severe_motor_impairment_and_borderline_intellectual_disability_due_to_encephalocele')
        self.mild_motor_impairment_and_mild_intellectual_disability_due_to_encephalocele = kwargs.get('mild_motor_impairment_and_mild_intellectual_disability_due_to_encephalocele')
        self.moderate_motor_impairment_and_mild_intellectual_disability_due_to_encephalocele = kwargs.get('moderate_motor_impairment_and_mild_intellectual_disability_due_to_encephalocele')
        self.severe_motor_impairment_and_mild_intellectual_disability_due_to_encephalocele = kwargs.get('severe_motor_impairment_and_mild_intellectual_disability_due_to_encephalocele')
        self.mild_motor_impairment_and_moderate_intellectual_disability_due_to_encephalocele = kwargs.get('mild_motor_impairment_and_moderate_intellectual_disability_due_to_encephalocele')
        self.moderate_motor_impairment_and_moderate_intellectual_disability_due_to_encephalocele = kwargs.get('moderate_motor_impairment_and_moderate_intellectual_disability_due_to_encephalocele')
        self.severe_motor_impairment_and_moderate_intellectual_disability_due_to_encephalocele = kwargs.get('severe_motor_impairment_and_moderate_intellectual_disability_due_to_encephalocele')
        self.mild_motor_impairment_and_severe_intellectual_disability_due_to_encephalocele = kwargs.get('mild_motor_impairment_and_severe_intellectual_disability_due_to_encephalocele')
        self.moderate_motor_impairment_and_severe_intellectual_disability_due_to_encephalocele = kwargs.get('moderate_motor_impairment_and_severe_intellectual_disability_due_to_encephalocele')
        self.severe_motor_impairment_and_severe_intellectual_disability_due_to_encephalocele = kwargs.get('severe_motor_impairment_and_severe_intellectual_disability_due_to_encephalocele')
        self.mild_motor_impairment_and_profound_intellectual_disability_due_to_encephalocele = kwargs.get('mild_motor_impairment_and_profound_intellectual_disability_due_to_encephalocele')
        self.moderate_motor_impairment_and_profound_intellectual_disability_due_to_encephalocele = kwargs.get('moderate_motor_impairment_and_profound_intellectual_disability_due_to_encephalocele')
        self.severe_motor_impairment_and_profound_intellectual_disability_due_to_encephalocele = kwargs.get('severe_motor_impairment_and_profound_intellectual_disability_due_to_encephalocele')
        self.mild_motor_impairment_borderline_intellectual_disability_and_incontinence_due_to_encephalocele = kwargs.get('mild_motor_impairment_borderline_intellectual_disability_and_incontinence_due_to_encephalocele')
        self.moderate_motor_impairment_borderline_intellectual_disability_and_incontinence_due_to_encephalocele = kwargs.get('moderate_motor_impairment_borderline_intellectual_disability_and_incontinence_due_to_encephalocele')
        self.severe_motor_impairment_borderline_intellectual_disability_and_incontinence_due_to_encephalocele = kwargs.get('severe_motor_impairment_borderline_intellectual_disability_and_incontinence_due_to_encephalocele')
        self.mild_motor_impairment_mild_intellectual_disability_and_incontinence_due_to_encephalocele = kwargs.get('mild_motor_impairment_mild_intellectual_disability_and_incontinence_due_to_encephalocele')
        self.moderate_motor_impairment_mild_intellectual_disability_and_incontinence_due_to_encephalocele = kwargs.get('moderate_motor_impairment_mild_intellectual_disability_and_incontinence_due_to_encephalocele')
        self.severe_motor_impairment_mild_intellectual_disability_and_incontinence_due_to_encephalocele = kwargs.get('severe_motor_impairment_mild_intellectual_disability_and_incontinence_due_to_encephalocele')
        self.mild_motor_impairment_moderate_intellectual_disability_and_incontinence_due_to_encephalocele = kwargs.get('mild_motor_impairment_moderate_intellectual_disability_and_incontinence_due_to_encephalocele')
        self.moderate_motor_impairment_moderate_intellectual_disability_and_incontinence_due_to_encephalocele = kwargs.get('moderate_motor_impairment_moderate_intellectual_disability_and_incontinence_due_to_encephalocele')
        self.severe_motor_impairment_moderate_intellectual_disability_and_incontinence_due_to_encephalocele = kwargs.get('severe_motor_impairment_moderate_intellectual_disability_and_incontinence_due_to_encephalocele')
        self.mild_motor_impairment_severe_intellectual_disability_and_incontinence_due_to_encephalocele = kwargs.get('mild_motor_impairment_severe_intellectual_disability_and_incontinence_due_to_encephalocele')
        self.moderate_motor_impairment_severe_intellectual_disability_and_incontinence_due_to_encephalocele = kwargs.get('moderate_motor_impairment_severe_intellectual_disability_and_incontinence_due_to_encephalocele')
        self.severe_motor_impairment_severe_intellectual_disability_and_incontinence_due_to_encephalocele = kwargs.get('severe_motor_impairment_severe_intellectual_disability_and_incontinence_due_to_encephalocele')
        self.mild_motor_impairment_profound_intellectual_disability_and_incontinence_due_to_encephalocele = kwargs.get('mild_motor_impairment_profound_intellectual_disability_and_incontinence_due_to_encephalocele')
        self.moderate_motor_impairment_profound_intellectual_disability_and_incontinence_due_to_encephalocele = kwargs.get('moderate_motor_impairment_profound_intellectual_disability_and_incontinence_due_to_encephalocele')
        self.severe_motor_impairment_profound_intellectual_disability_and_incontinence_due_to_encephalocele = kwargs.get('severe_motor_impairment_profound_intellectual_disability_and_incontinence_due_to_encephalocele')
        self.asymptomatic_vitamin_a_deficiency = kwargs.get('asymptomatic_vitamin_a_deficiency')
        self.latent_tuberculosis_infection = kwargs.get('latent_tuberculosis_infection')
        self.mild_pain_due_to_guinea_worm_emergence = kwargs.get('mild_pain_due_to_guinea_worm_emergence')
        self.mild_symptomatic_episodes_gallbladder_and_biliary_diseases = kwargs.get('mild_symptomatic_episodes_gallbladder_and_biliary_diseases')
        self.moderate_symptomatic_episodes_gallbladder_and_biliary_diseases = kwargs.get('moderate_symptomatic_episodes_gallbladder_and_biliary_diseases')
        self.severe_symptomatic_episodes_gallbladder_and_biliary_diseases = kwargs.get('severe_symptomatic_episodes_gallbladder_and_biliary_diseases')
        self.mild_symptomatic_inguinal_femoral_and_abdominal_hernia = kwargs.get('mild_symptomatic_inguinal_femoral_and_abdominal_hernia')
        self.moderate_symptomatic_inguinal_femoral_and_abdominal_hernia = kwargs.get('moderate_symptomatic_inguinal_femoral_and_abdominal_hernia')
        self.severe_symptomatic_inguinal_femoral_and_abdominal_hernia = kwargs.get('severe_symptomatic_inguinal_femoral_and_abdominal_hernia')
        self.asymptomatic_ulcerative_colitis = kwargs.get('asymptomatic_ulcerative_colitis')
        self.asymptomatic_crohns_disease = kwargs.get('asymptomatic_crohns_disease')
        self.mild_chronic_pancreatitis = kwargs.get('mild_chronic_pancreatitis')
        self.moderate_chronic_pancreatitis = kwargs.get('moderate_chronic_pancreatitis')
        self.severe_chronic_pancreatitis = kwargs.get('severe_chronic_pancreatitis')
        self.mild_acne_vulgaris = kwargs.get('mild_acne_vulgaris')
        self.moderate_acne_vulgaris = kwargs.get('moderate_acne_vulgaris')
        self.severe_acne_vulgaris = kwargs.get('severe_acne_vulgaris')
        self.moderate_cellulitis = kwargs.get('moderate_cellulitis')
        self.mild_urolithiasis_episodes = kwargs.get('mild_urolithiasis_episodes')
        self.moderate_urolithiasis_episodes = kwargs.get('moderate_urolithiasis_episodes')
        self.severe_urolithiasis_episodes = kwargs.get('severe_urolithiasis_episodes')
        self.congenital_heart_disease_without_intellectual_disability_or_heart_failure_due_to_other_congenital_cardiovascular_anomalies = kwargs.get('congenital_heart_disease_without_intellectual_disability_or_heart_failure_due_to_other_congenital_cardiovascular_anomalies')
        self.congenital_heart_disease_and_borderline_intellectual_disability_without_heart_failure_due_to_other_congenital_cardiovascular_anomalies = kwargs.get('congenital_heart_disease_and_borderline_intellectual_disability_without_heart_failure_due_to_other_congenital_cardiovascular_anomalies')
        self.congenital_heart_disease_and_mild_intellectual_disability_without_heart_failure_due_to_other_congenital_cardiovascular_anomalies = kwargs.get('congenital_heart_disease_and_mild_intellectual_disability_without_heart_failure_due_to_other_congenital_cardiovascular_anomalies')
        self.congenital_heart_disease_and_moderate_intellectual_disability_without_heart_failure_due_to_other_congenital_cardiovascular_anomalies = kwargs.get('congenital_heart_disease_and_moderate_intellectual_disability_without_heart_failure_due_to_other_congenital_cardiovascular_anomalies')
        self.congenital_heart_disease_and_severe_intellectual_disability_without_heart_failure_due_to_other_congenital_cardiovascular_anomalies = kwargs.get('congenital_heart_disease_and_severe_intellectual_disability_without_heart_failure_due_to_other_congenital_cardiovascular_anomalies')
        self.congenital_heart_disease_and_profound_intellectual_disability_without_heart_failure_due_to_other_congenital_cardiovascular_anomalies = kwargs.get('congenital_heart_disease_and_profound_intellectual_disability_without_heart_failure_due_to_other_congenital_cardiovascular_anomalies')
        self.congenital_heart_disease_without_intellectual_disability_or_heart_failure_due_to_single_ventricle_and_single_ventricle_pathway_heart_defects = kwargs.get('congenital_heart_disease_without_intellectual_disability_or_heart_failure_due_to_single_ventricle_and_single_ventricle_pathway_heart_defects')
        self.congenital_heart_disease_and_borderline_intellectual_disability_without_heart_failure_due_to_single_ventricle_and_single_ventricle_pathway_heart_defects = kwargs.get('congenital_heart_disease_and_borderline_intellectual_disability_without_heart_failure_due_to_single_ventricle_and_single_ventricle_pathway_heart_defects')
        self.congenital_heart_disease_and_mild_intellectual_disability_without_heart_failure_due_to_single_ventricle_and_single_ventricle_pathway_heart_defects = kwargs.get('congenital_heart_disease_and_mild_intellectual_disability_without_heart_failure_due_to_single_ventricle_and_single_ventricle_pathway_heart_defects')
        self.congenital_heart_disease_and_moderate_intellectual_disability_without_heart_failure_due_to_single_ventricle_and_single_ventricle_pathway_heart_defects = kwargs.get('congenital_heart_disease_and_moderate_intellectual_disability_without_heart_failure_due_to_single_ventricle_and_single_ventricle_pathway_heart_defects')
        self.congenital_heart_disease_and_severe_intellectual_disability_without_heart_failure_due_to_single_ventricle_and_single_ventricle_pathway_heart_defects = kwargs.get('congenital_heart_disease_and_severe_intellectual_disability_without_heart_failure_due_to_single_ventricle_and_single_ventricle_pathway_heart_defects')
        self.congenital_heart_disease_and_profound_intellectual_disability_without_heart_failure_due_to_single_ventricle_and_single_ventricle_pathway_heart_defects = kwargs.get('congenital_heart_disease_and_profound_intellectual_disability_without_heart_failure_due_to_single_ventricle_and_single_ventricle_pathway_heart_defects')
        self.congenital_heart_disease_and_mild_heart_failure_without_intellectual_disability_due_to_single_ventricle_and_single_ventricle_pathway_heart_defects = kwargs.get('congenital_heart_disease_and_mild_heart_failure_without_intellectual_disability_due_to_single_ventricle_and_single_ventricle_pathway_heart_defects')
        self.congenital_heart_disease_borderline_intellectual_disability_and_mild_heart_failure_due_to_single_ventricle_and_single_ventricle_pathway_heart_defects = kwargs.get('congenital_heart_disease_borderline_intellectual_disability_and_mild_heart_failure_due_to_single_ventricle_and_single_ventricle_pathway_heart_defects')
        self.congenital_heart_disease_mild_intellectual_disability_and_mild_heart_failure_due_to_single_ventricle_and_single_ventricle_pathway_heart_defects = kwargs.get('congenital_heart_disease_mild_intellectual_disability_and_mild_heart_failure_due_to_single_ventricle_and_single_ventricle_pathway_heart_defects')
        self.congenital_heart_disease_moderate_intellectual_disability_and_mild_heart_failure_due_to_single_ventricle_and_single_ventricle_pathway_heart_defects = kwargs.get('congenital_heart_disease_moderate_intellectual_disability_and_mild_heart_failure_due_to_single_ventricle_and_single_ventricle_pathway_heart_defects')
        self.congenital_heart_disease_severe_intellectual_disability_and_mild_heart_failure_due_to_single_ventricle_and_single_ventricle_pathway_heart_defects = kwargs.get('congenital_heart_disease_severe_intellectual_disability_and_mild_heart_failure_due_to_single_ventricle_and_single_ventricle_pathway_heart_defects')
        self.congenital_heart_disease_profound_intellectual_disability_and_mild_heart_failure_due_to_single_ventricle_and_single_ventricle_pathway_heart_defects = kwargs.get('congenital_heart_disease_profound_intellectual_disability_and_mild_heart_failure_due_to_single_ventricle_and_single_ventricle_pathway_heart_defects')
        self.congenital_heart_disease_and_moderate_heart_failure_without_intellectual_disability_due_to_single_ventricle_and_single_ventricle_pathway_heart_defects = kwargs.get('congenital_heart_disease_and_moderate_heart_failure_without_intellectual_disability_due_to_single_ventricle_and_single_ventricle_pathway_heart_defects')
        self.congenital_heart_disease_borderline_intellectual_disability_and_moderate_heart_failure_due_to_single_ventricle_and_single_ventricle_pathway_heart_defects = kwargs.get('congenital_heart_disease_borderline_intellectual_disability_and_moderate_heart_failure_due_to_single_ventricle_and_single_ventricle_pathway_heart_defects')
        self.congenital_heart_disease_mild_intellectual_disability_and_moderate_heart_failure_due_to_single_ventricle_and_single_ventricle_pathway_heart_defects = kwargs.get('congenital_heart_disease_mild_intellectual_disability_and_moderate_heart_failure_due_to_single_ventricle_and_single_ventricle_pathway_heart_defects')
        self.congenital_heart_disease_moderate_intellectual_disability_and_moderate_heart_failure_due_to_single_ventricle_and_single_ventricle_pathway_heart_defects = kwargs.get('congenital_heart_disease_moderate_intellectual_disability_and_moderate_heart_failure_due_to_single_ventricle_and_single_ventricle_pathway_heart_defects')
        self.congenital_heart_disease_severe_intellectual_disability_and_moderate_heart_failure_due_to_single_ventricle_and_single_ventricle_pathway_heart_defects = kwargs.get('congenital_heart_disease_severe_intellectual_disability_and_moderate_heart_failure_due_to_single_ventricle_and_single_ventricle_pathway_heart_defects')
        self.congenital_heart_disease_profound_intellectual_disability_and_moderate_heart_failure_due_to_single_ventricle_and_single_ventricle_pathway_heart_defects = kwargs.get('congenital_heart_disease_profound_intellectual_disability_and_moderate_heart_failure_due_to_single_ventricle_and_single_ventricle_pathway_heart_defects')
        self.congenital_heart_disease_and_severe_heart_failure_without_intellectual_disability_due_to_single_ventricle_and_single_ventricle_pathway_heart_defects = kwargs.get('congenital_heart_disease_and_severe_heart_failure_without_intellectual_disability_due_to_single_ventricle_and_single_ventricle_pathway_heart_defects')
        self.congenital_heart_disease_borderline_intellectual_disability_and_severe_heart_failure_due_to_single_ventricle_and_single_ventricle_pathway_heart_defects = kwargs.get('congenital_heart_disease_borderline_intellectual_disability_and_severe_heart_failure_due_to_single_ventricle_and_single_ventricle_pathway_heart_defects')
        self.congenital_heart_disease_mild_intellectual_disability_and_severe_heart_failure_due_to_single_ventricle_and_single_ventricle_pathway_heart_defects = kwargs.get('congenital_heart_disease_mild_intellectual_disability_and_severe_heart_failure_due_to_single_ventricle_and_single_ventricle_pathway_heart_defects')
        self.congenital_heart_disease_moderate_intellectual_disability_and_severe_heart_failure_due_to_single_ventricle_and_single_ventricle_pathway_heart_defects = kwargs.get('congenital_heart_disease_moderate_intellectual_disability_and_severe_heart_failure_due_to_single_ventricle_and_single_ventricle_pathway_heart_defects')
        self.congenital_heart_disease_severe_intellectual_disability_and_severe_heart_failure_due_to_single_ventricle_and_single_ventricle_pathway_heart_defects = kwargs.get('congenital_heart_disease_severe_intellectual_disability_and_severe_heart_failure_due_to_single_ventricle_and_single_ventricle_pathway_heart_defects')
        self.congenital_heart_disease_profound_intellectual_disability_and_severe_heart_failure_due_to_single_ventricle_and_single_ventricle_pathway_heart_defects = kwargs.get('congenital_heart_disease_profound_intellectual_disability_and_severe_heart_failure_due_to_single_ventricle_and_single_ventricle_pathway_heart_defects')
        self.congenital_heart_disease_without_intellectual_disability_or_heart_failure_due_to_severe_congenital_heart_anomalies_excluding_single_ventricle_heart_defects = kwargs.get('congenital_heart_disease_without_intellectual_disability_or_heart_failure_due_to_severe_congenital_heart_anomalies_excluding_single_ventricle_heart_defects')
        self.congenital_heart_disease_and_borderline_intellectual_disability_without_heart_failure_due_to_severe_congenital_heart_anomalies_excluding_single_ventricle_heart_defects = kwargs.get('congenital_heart_disease_and_borderline_intellectual_disability_without_heart_failure_due_to_severe_congenital_heart_anomalies_excluding_single_ventricle_heart_defects')
        self.congenital_heart_disease_and_mild_intellectual_disability_without_heart_failure_due_to_severe_congenital_heart_anomalies_excluding_single_ventricle_heart_defects = kwargs.get('congenital_heart_disease_and_mild_intellectual_disability_without_heart_failure_due_to_severe_congenital_heart_anomalies_excluding_single_ventricle_heart_defects')
        self.congenital_heart_disease_and_moderate_intellectual_disability_without_heart_failure_due_to_severe_congenital_heart_anomalies_excluding_single_ventricle_heart_defects = kwargs.get('congenital_heart_disease_and_moderate_intellectual_disability_without_heart_failure_due_to_severe_congenital_heart_anomalies_excluding_single_ventricle_heart_defects')
        self.congenital_heart_disease_and_severe_intellectual_disability_without_heart_failure_due_to_severe_congenital_heart_anomalies_excluding_single_ventricle_heart_defects = kwargs.get('congenital_heart_disease_and_severe_intellectual_disability_without_heart_failure_due_to_severe_congenital_heart_anomalies_excluding_single_ventricle_heart_defects')
        self.congenital_heart_disease_and_profound_intellectual_disability_without_heart_failure_due_to_severe_congenital_heart_anomalies_excluding_single_ventricle_heart_defects = kwargs.get('congenital_heart_disease_and_profound_intellectual_disability_without_heart_failure_due_to_severe_congenital_heart_anomalies_excluding_single_ventricle_heart_defects')
        self.congenital_heart_disease_and_mild_heart_failure_without_intellectual_disability_due_to_severe_congenital_heart_anomalies_excluding_single_ventricle_heart_defects = kwargs.get('congenital_heart_disease_and_mild_heart_failure_without_intellectual_disability_due_to_severe_congenital_heart_anomalies_excluding_single_ventricle_heart_defects')
        self.congenital_heart_disease_borderline_intellectual_disability_and_mild_heart_failure_due_to_severe_congenital_heart_anomalies_excluding_single_ventricle_heart_defects = kwargs.get('congenital_heart_disease_borderline_intellectual_disability_and_mild_heart_failure_due_to_severe_congenital_heart_anomalies_excluding_single_ventricle_heart_defects')
        self.congenital_heart_disease_mild_intellectual_disability_and_mild_heart_failure_due_to_severe_congenital_heart_anomalies_excluding_single_ventricle_heart_defects = kwargs.get('congenital_heart_disease_mild_intellectual_disability_and_mild_heart_failure_due_to_severe_congenital_heart_anomalies_excluding_single_ventricle_heart_defects')
        self.congenital_heart_disease_moderate_intellectual_disability_and_mild_heart_failure_due_to_severe_congenital_heart_anomalies_excluding_single_ventricle_heart_defects = kwargs.get('congenital_heart_disease_moderate_intellectual_disability_and_mild_heart_failure_due_to_severe_congenital_heart_anomalies_excluding_single_ventricle_heart_defects')
        self.congenital_heart_disease_severe_intellectual_disability_and_mild_heart_failure_due_to_severe_congenital_heart_anomalies_excluding_single_ventricle_heart_defects = kwargs.get('congenital_heart_disease_severe_intellectual_disability_and_mild_heart_failure_due_to_severe_congenital_heart_anomalies_excluding_single_ventricle_heart_defects')
        self.congenital_heart_disease_profound_intellectual_disability_and_mild_heart_failure_due_to_severe_congenital_heart_anomalies_excluding_single_ventricle_heart_defects = kwargs.get('congenital_heart_disease_profound_intellectual_disability_and_mild_heart_failure_due_to_severe_congenital_heart_anomalies_excluding_single_ventricle_heart_defects')
        self.congenital_heart_disease_and_moderate_heart_failure_without_intellectual_disability_due_to_severe_congenital_heart_anomalies_excluding_single_ventricle_heart_defects = kwargs.get('congenital_heart_disease_and_moderate_heart_failure_without_intellectual_disability_due_to_severe_congenital_heart_anomalies_excluding_single_ventricle_heart_defects')
        self.congenital_heart_disease_borderline_intellectual_disability_and_moderate_heart_failure_due_to_severe_congenital_heart_anomalies_excluding_single_ventricle_heart_defects = kwargs.get('congenital_heart_disease_borderline_intellectual_disability_and_moderate_heart_failure_due_to_severe_congenital_heart_anomalies_excluding_single_ventricle_heart_defects')
        self.congenital_heart_disease_mild_intellectual_disability_and_moderate_heart_failure_due_to_severe_congenital_heart_anomalies_excluding_single_ventricle_heart_defects = kwargs.get('congenital_heart_disease_mild_intellectual_disability_and_moderate_heart_failure_due_to_severe_congenital_heart_anomalies_excluding_single_ventricle_heart_defects')
        self.congenital_heart_disease_moderate_intellectual_disability_and_moderate_heart_failure_due_to_severe_congenital_heart_anomalies_excluding_single_ventricle_heart_defects = kwargs.get('congenital_heart_disease_moderate_intellectual_disability_and_moderate_heart_failure_due_to_severe_congenital_heart_anomalies_excluding_single_ventricle_heart_defects')
        self.congenital_heart_disease_severe_intellectual_disability_and_moderate_heart_failure_due_to_severe_congenital_heart_anomalies_excluding_single_ventricle_heart_defects = kwargs.get('congenital_heart_disease_severe_intellectual_disability_and_moderate_heart_failure_due_to_severe_congenital_heart_anomalies_excluding_single_ventricle_heart_defects')
        self.congenital_heart_disease_profound_intellectual_disability_and_moderate_heart_failure_due_to_severe_congenital_heart_anomalies_excluding_single_ventricle_heart_defects = kwargs.get('congenital_heart_disease_profound_intellectual_disability_and_moderate_heart_failure_due_to_severe_congenital_heart_anomalies_excluding_single_ventricle_heart_defects')
        self.congenital_heart_disease_and_severe_heart_failure_without_intellectual_disability_due_to_severe_congenital_heart_anomalies_excluding_single_ventricle_heart_defects = kwargs.get('congenital_heart_disease_and_severe_heart_failure_without_intellectual_disability_due_to_severe_congenital_heart_anomalies_excluding_single_ventricle_heart_defects')
        self.congenital_heart_disease_borderline_intellectual_disability_and_severe_heart_failure_due_to_severe_congenital_heart_anomalies_excluding_single_ventricle_heart_defects = kwargs.get('congenital_heart_disease_borderline_intellectual_disability_and_severe_heart_failure_due_to_severe_congenital_heart_anomalies_excluding_single_ventricle_heart_defects')
        self.congenital_heart_disease_mild_intellectual_disability_and_severe_heart_failure_due_to_severe_congenital_heart_anomalies_excluding_single_ventricle_heart_defects = kwargs.get('congenital_heart_disease_mild_intellectual_disability_and_severe_heart_failure_due_to_severe_congenital_heart_anomalies_excluding_single_ventricle_heart_defects')
        self.congenital_heart_disease_moderate_intellectual_disability_and_severe_heart_failure_due_to_severe_congenital_heart_anomalies_excluding_single_ventricle_heart_defects = kwargs.get('congenital_heart_disease_moderate_intellectual_disability_and_severe_heart_failure_due_to_severe_congenital_heart_anomalies_excluding_single_ventricle_heart_defects')
        self.congenital_heart_disease_severe_intellectual_disability_and_severe_heart_failure_due_to_severe_congenital_heart_anomalies_excluding_single_ventricle_heart_defects = kwargs.get('congenital_heart_disease_severe_intellectual_disability_and_severe_heart_failure_due_to_severe_congenital_heart_anomalies_excluding_single_ventricle_heart_defects')
        self.congenital_heart_disease_profound_intellectual_disability_and_severe_heart_failure_due_to_severe_congenital_heart_anomalies_excluding_single_ventricle_heart_defects = kwargs.get('congenital_heart_disease_profound_intellectual_disability_and_severe_heart_failure_due_to_severe_congenital_heart_anomalies_excluding_single_ventricle_heart_defects')
        self.congenital_heart_disease_without_heart_failure_or_intellectual_disability_due_to_critical_malformations_of_great_vessels_congenital_valvular_heart_disease_and_patent_ductus_arteriosus = kwargs.get('congenital_heart_disease_without_heart_failure_or_intellectual_disability_due_to_critical_malformations_of_great_vessels_congenital_valvular_heart_disease_and_patent_ductus_arteriosus')
        self.congenital_heart_disease_and_borderline_intellectual_disability_without_heart_failure_due_to_critical_malformations_of_great_vessels_congenital_valvular_heart_disease_and_patent_ductus_arteriosus = kwargs.get('congenital_heart_disease_and_borderline_intellectual_disability_without_heart_failure_due_to_critical_malformations_of_great_vessels_congenital_valvular_heart_disease_and_patent_ductus_arteriosus')
        self.congenital_heart_disease_and_mild_intellectual_disability_without_heart_failure_due_to_critical_malformations_of_great_vessels_congenital_valvular_heart_disease_and_patent_ductus_arteriosus = kwargs.get('congenital_heart_disease_and_mild_intellectual_disability_without_heart_failure_due_to_critical_malformations_of_great_vessels_congenital_valvular_heart_disease_and_patent_ductus_arteriosus')
        self.congenital_heart_disease_and_moderate_intellectual_disability_without_heart_failure_due_to_critical_malformations_of_great_vessels_congenital_valvular_heart_disease_and_patent_ductus_arteriosus = kwargs.get('congenital_heart_disease_and_moderate_intellectual_disability_without_heart_failure_due_to_critical_malformations_of_great_vessels_congenital_valvular_heart_disease_and_patent_ductus_arteriosus')
        self.congenital_heart_disease_and_severe_intellectual_disability_without_heart_failure_due_to_critical_malformations_of_great_vessels_congenital_valvular_heart_disease_and_patent_ductus_arteriosus = kwargs.get('congenital_heart_disease_and_severe_intellectual_disability_without_heart_failure_due_to_critical_malformations_of_great_vessels_congenital_valvular_heart_disease_and_patent_ductus_arteriosus')
        self.congenital_heart_disease_and_profound_intellectual_disability_without_heart_failure_due_to_critical_malformations_of_great_vessels_congenital_valvular_heart_disease_and_patent_ductus_arteriosus = kwargs.get('congenital_heart_disease_and_profound_intellectual_disability_without_heart_failure_due_to_critical_malformations_of_great_vessels_congenital_valvular_heart_disease_and_patent_ductus_arteriosus')
        self.congenital_heart_disease_and_mild_heart_failure_without_intellectual_disability_due_to_critical_malformations_of_great_vessels_congenital_valvular_heart_disease_and_patent_ductus_arteriosus = kwargs.get('congenital_heart_disease_and_mild_heart_failure_without_intellectual_disability_due_to_critical_malformations_of_great_vessels_congenital_valvular_heart_disease_and_patent_ductus_arteriosus')
        self.congenital_heart_disease_borderline_intellectual_disability_and_mild_heart_failure_due_to_critical_malformations_of_great_vessels_congenital_valvular_heart_disease_and_patent_ductus_arteriosus = kwargs.get('congenital_heart_disease_borderline_intellectual_disability_and_mild_heart_failure_due_to_critical_malformations_of_great_vessels_congenital_valvular_heart_disease_and_patent_ductus_arteriosus')
        self.congenital_heart_disease_mild_intellectual_disability_and_mild_heart_failure_due_to_critical_malformations_of_great_vessels_congenital_valvular_heart_disease_and_patent_ductus_arteriosus = kwargs.get('congenital_heart_disease_mild_intellectual_disability_and_mild_heart_failure_due_to_critical_malformations_of_great_vessels_congenital_valvular_heart_disease_and_patent_ductus_arteriosus')
        self.congenital_heart_disease_moderate_intellectual_disability_and_mild_heart_failure_due_to_critical_malformations_of_great_vessels_congenital_valvular_heart_disease_and_patent_ductus_arteriosus = kwargs.get('congenital_heart_disease_moderate_intellectual_disability_and_mild_heart_failure_due_to_critical_malformations_of_great_vessels_congenital_valvular_heart_disease_and_patent_ductus_arteriosus')
        self.congenital_heart_disease_severe_intellectual_disability_and_mild_heart_failure_due_to_critical_malformations_of_great_vessels_congenital_valvular_heart_disease_and_patent_ductus_arteriosus = kwargs.get('congenital_heart_disease_severe_intellectual_disability_and_mild_heart_failure_due_to_critical_malformations_of_great_vessels_congenital_valvular_heart_disease_and_patent_ductus_arteriosus')
        self.congenital_heart_disease_profound_intellectual_disability_and_mild_heart_failure_due_to_critical_malformations_of_great_vessels_congenital_valvular_heart_disease_and_patent_ductus_arteriosus = kwargs.get('congenital_heart_disease_profound_intellectual_disability_and_mild_heart_failure_due_to_critical_malformations_of_great_vessels_congenital_valvular_heart_disease_and_patent_ductus_arteriosus')
        self.congenital_heart_disease_and_moderate_heart_failure_without_intellectual_disability_due_to_critical_malformations_of_great_vessels_congenital_valvular_heart_disease_and_patent_ductus_arteriosus = kwargs.get('congenital_heart_disease_and_moderate_heart_failure_without_intellectual_disability_due_to_critical_malformations_of_great_vessels_congenital_valvular_heart_disease_and_patent_ductus_arteriosus')
        self.congenital_heart_disease_borderline_intellectual_disability_and_moderate_heart_failure_due_to_critical_malformations_of_great_vessels_congenital_valvular_heart_disease_and_patent_ductus_arteriosus = kwargs.get('congenital_heart_disease_borderline_intellectual_disability_and_moderate_heart_failure_due_to_critical_malformations_of_great_vessels_congenital_valvular_heart_disease_and_patent_ductus_arteriosus')
        self.congenital_heart_disease_mild_intellectual_disability_and_moderate_heart_failure_due_to_critical_malformations_of_great_vessels_congenital_valvular_heart_disease_and_patent_ductus_arteriosus = kwargs.get('congenital_heart_disease_mild_intellectual_disability_and_moderate_heart_failure_due_to_critical_malformations_of_great_vessels_congenital_valvular_heart_disease_and_patent_ductus_arteriosus')
        self.congenital_heart_disease_moderate_intellectual_disability_and_moderate_heart_failure_due_to_critical_malformations_of_great_vessels_congenital_valvular_heart_disease_and_patent_ductus_arteriosus = kwargs.get('congenital_heart_disease_moderate_intellectual_disability_and_moderate_heart_failure_due_to_critical_malformations_of_great_vessels_congenital_valvular_heart_disease_and_patent_ductus_arteriosus')
        self.congenital_heart_disease_severe_intellectual_disability_and_moderate_heart_failure_due_to_critical_malformations_of_great_vessels_congenital_valvular_heart_disease_and_patent_ductus_arteriosus = kwargs.get('congenital_heart_disease_severe_intellectual_disability_and_moderate_heart_failure_due_to_critical_malformations_of_great_vessels_congenital_valvular_heart_disease_and_patent_ductus_arteriosus')
        self.congenital_heart_disease_profound_intellectual_disability_and_moderate_heart_failure_due_to_critical_malformations_of_great_vessels_congenital_valvular_heart_disease_and_patent_ductus_arteriosus = kwargs.get('congenital_heart_disease_profound_intellectual_disability_and_moderate_heart_failure_due_to_critical_malformations_of_great_vessels_congenital_valvular_heart_disease_and_patent_ductus_arteriosus')
        self.congenital_heart_disease_and_severe_heart_failure_without_intellectual_disability_due_to_critical_malformations_of_great_vessels_congenital_valvular_heart_disease_and_patent_ductus_arteriosus = kwargs.get('congenital_heart_disease_and_severe_heart_failure_without_intellectual_disability_due_to_critical_malformations_of_great_vessels_congenital_valvular_heart_disease_and_patent_ductus_arteriosus')
        self.congenital_heart_disease_borderline_intellectual_disability_and_severe_heart_failure_due_to_critical_malformations_of_great_vessels_congenital_valvular_heart_disease_and_patent_ductus_arteriosus = kwargs.get('congenital_heart_disease_borderline_intellectual_disability_and_severe_heart_failure_due_to_critical_malformations_of_great_vessels_congenital_valvular_heart_disease_and_patent_ductus_arteriosus')
        self.congenital_heart_disease_mild_intellectual_disability_and_severe_heart_failure_due_to_critical_malformations_of_great_vessels_congenital_valvular_heart_disease_and_patent_ductus_arteriosus = kwargs.get('congenital_heart_disease_mild_intellectual_disability_and_severe_heart_failure_due_to_critical_malformations_of_great_vessels_congenital_valvular_heart_disease_and_patent_ductus_arteriosus')
        self.congenital_heart_disease_moderate_intellectual_disability_and_severe_heart_failure_due_to_critical_malformations_of_great_vessels_congenital_valvular_heart_disease_and_patent_ductus_arteriosus = kwargs.get('congenital_heart_disease_moderate_intellectual_disability_and_severe_heart_failure_due_to_critical_malformations_of_great_vessels_congenital_valvular_heart_disease_and_patent_ductus_arteriosus')
        self.congenital_heart_disease_severe_intellectual_disability_and_severe_heart_failure_due_to_critical_malformations_of_great_vessels_congenital_valvular_heart_disease_and_patent_ductus_arteriosus = kwargs.get('congenital_heart_disease_severe_intellectual_disability_and_severe_heart_failure_due_to_critical_malformations_of_great_vessels_congenital_valvular_heart_disease_and_patent_ductus_arteriosus')
        self.congenital_heart_disease_profound_intellectual_disability_and_severe_heart_failure_due_to_critical_malformations_of_great_vessels_congenital_valvular_heart_disease_and_patent_ductus_arteriosus = kwargs.get('congenital_heart_disease_profound_intellectual_disability_and_severe_heart_failure_due_to_critical_malformations_of_great_vessels_congenital_valvular_heart_disease_and_patent_ductus_arteriosus')
        self.congenital_heart_disease_without_heart_failure_or_intellectual_disability_due_to_ventricular_septal_defect_and_atrial_septal_defect = kwargs.get('congenital_heart_disease_without_heart_failure_or_intellectual_disability_due_to_ventricular_septal_defect_and_atrial_septal_defect')
        self.congenital_heart_disease_and_borderline_intellectual_disability_without_heart_failure_due_to_ventricular_septal_defect_and_atrial_septal_defect = kwargs.get('congenital_heart_disease_and_borderline_intellectual_disability_without_heart_failure_due_to_ventricular_septal_defect_and_atrial_septal_defect')
        self.congenital_heart_disease_and_mild_intellectual_disability_without_heart_failure_due_to_ventricular_septal_defect_and_atrial_septal_defect = kwargs.get('congenital_heart_disease_and_mild_intellectual_disability_without_heart_failure_due_to_ventricular_septal_defect_and_atrial_septal_defect')
        self.congenital_heart_disease_and_moderate_intellectual_disability_without_heart_failure_due_to_ventricular_septal_defect_and_atrial_septal_defect = kwargs.get('congenital_heart_disease_and_moderate_intellectual_disability_without_heart_failure_due_to_ventricular_septal_defect_and_atrial_septal_defect')
        self.congenital_heart_disease_and_severe_intellectual_disability_without_heart_failure_due_to_ventricular_septal_defect_and_atrial_septal_defect = kwargs.get('congenital_heart_disease_and_severe_intellectual_disability_without_heart_failure_due_to_ventricular_septal_defect_and_atrial_septal_defect')
        self.congenital_heart_disease_and_profound_intellectual_disability_without_heart_failure_due_to_ventricular_septal_defect_and_atrial_septal_defect = kwargs.get('congenital_heart_disease_and_profound_intellectual_disability_without_heart_failure_due_to_ventricular_septal_defect_and_atrial_septal_defect')
        self.congenital_heart_disease_and_mild_heart_failure_without_intellectual_disability_due_to_ventricular_septal_defect_and_atrial_septal_defect = kwargs.get('congenital_heart_disease_and_mild_heart_failure_without_intellectual_disability_due_to_ventricular_septal_defect_and_atrial_septal_defect')
        self.congenital_heart_disease_borderline_intellectual_disability_and_mild_heart_failure_due_to_ventricular_septal_defect_and_atrial_septal_defect = kwargs.get('congenital_heart_disease_borderline_intellectual_disability_and_mild_heart_failure_due_to_ventricular_septal_defect_and_atrial_septal_defect')
        self.congenital_heart_disease_mild_intellectual_disability_and_mild_heart_failure_due_to_ventricular_septal_defect_and_atrial_septal_defect = kwargs.get('congenital_heart_disease_mild_intellectual_disability_and_mild_heart_failure_due_to_ventricular_septal_defect_and_atrial_septal_defect')
        self.congenital_heart_disease_moderate_intellectual_disability_and_mild_heart_failure_due_to_ventricular_septal_defect_and_atrial_septal_defect = kwargs.get('congenital_heart_disease_moderate_intellectual_disability_and_mild_heart_failure_due_to_ventricular_septal_defect_and_atrial_septal_defect')
        self.congenital_heart_disease_severe_intellectual_disability_and_mild_heart_failure_due_to_ventricular_septal_defect_and_atrial_septal_defect = kwargs.get('congenital_heart_disease_severe_intellectual_disability_and_mild_heart_failure_due_to_ventricular_septal_defect_and_atrial_septal_defect')
        self.congenital_heart_disease_profound_intellectual_disability_and_mild_heart_failure_due_to_ventricular_septal_defect_and_atrial_septal_defect = kwargs.get('congenital_heart_disease_profound_intellectual_disability_and_mild_heart_failure_due_to_ventricular_septal_defect_and_atrial_septal_defect')
        self.congenital_heart_disease_and_moderate_heart_failure_without_intellectual_disability_due_to_ventricular_septal_defect_and_atrial_septal_defect = kwargs.get('congenital_heart_disease_and_moderate_heart_failure_without_intellectual_disability_due_to_ventricular_septal_defect_and_atrial_septal_defect')
        self.congenital_heart_disease_borderline_intellectual_disability_and_moderate_heart_failure_due_to_ventricular_septal_defect_and_atrial_septal_defect = kwargs.get('congenital_heart_disease_borderline_intellectual_disability_and_moderate_heart_failure_due_to_ventricular_septal_defect_and_atrial_septal_defect')
        self.congenital_heart_disease_mild_intellectual_disability_and_moderate_heart_failure_due_to_ventricular_septal_defect_and_atrial_septal_defect = kwargs.get('congenital_heart_disease_mild_intellectual_disability_and_moderate_heart_failure_due_to_ventricular_septal_defect_and_atrial_septal_defect')
        self.congenital_heart_disease_moderate_intellectual_disability_and_moderate_heart_failure_due_to_ventricular_septal_defect_and_atrial_septal_defect = kwargs.get('congenital_heart_disease_moderate_intellectual_disability_and_moderate_heart_failure_due_to_ventricular_septal_defect_and_atrial_septal_defect')
        self.congenital_heart_disease_severe_intellectual_disability_and_moderate_heart_failure_due_to_ventricular_septal_defect_and_atrial_septal_defect = kwargs.get('congenital_heart_disease_severe_intellectual_disability_and_moderate_heart_failure_due_to_ventricular_septal_defect_and_atrial_septal_defect')
        self.congenital_heart_disease_profound_intellectual_disability_and_moderate_heart_failure_due_to_ventricular_septal_defect_and_atrial_septal_defect = kwargs.get('congenital_heart_disease_profound_intellectual_disability_and_moderate_heart_failure_due_to_ventricular_septal_defect_and_atrial_septal_defect')
        self.congenital_heart_disease_and_severe_heart_without_intellectual_disability_due_to_ventricular_septal_defect_and_atrial_septal_defect = kwargs.get('congenital_heart_disease_and_severe_heart_without_intellectual_disability_due_to_ventricular_septal_defect_and_atrial_septal_defect')
        self.congenital_heart_disease_borderline_intellectual_disability_and_severe_heart_failure_due_to_ventricular_septal_defect_and_atrial_septal_defect = kwargs.get('congenital_heart_disease_borderline_intellectual_disability_and_severe_heart_failure_due_to_ventricular_septal_defect_and_atrial_septal_defect')
        self.congenital_heart_disease_mild_intellectual_disability_and_severe_heart_failure_due_to_ventricular_septal_defect_and_atrial_septal_defect = kwargs.get('congenital_heart_disease_mild_intellectual_disability_and_severe_heart_failure_due_to_ventricular_septal_defect_and_atrial_septal_defect')
        self.congenital_heart_disease_moderate_intellectual_disability_and_severe_heart_failure_due_to_ventricular_septal_defect_and_atrial_septal_defect = kwargs.get('congenital_heart_disease_moderate_intellectual_disability_and_severe_heart_failure_due_to_ventricular_septal_defect_and_atrial_septal_defect')
        self.congenital_heart_disease_severe_intellectual_disability_and_severe_heart_failure_due_to_ventricular_septal_defect_and_atrial_septal_defect = kwargs.get('congenital_heart_disease_severe_intellectual_disability_and_severe_heart_failure_due_to_ventricular_septal_defect_and_atrial_septal_defect')
        self.congenital_heart_disease_profound_intellectual_disability_and_severe_heart_failure_due_to_ventricular_septal_defect_and_atrial_septal_defect = kwargs.get('congenital_heart_disease_profound_intellectual_disability_and_severe_heart_failure_due_to_ventricular_septal_defect_and_atrial_septal_defect')
        self.acute_adenolymphangitis_due_to_lymphatic_filariasis = kwargs.get('acute_adenolymphangitis_due_to_lymphatic_filariasis')
        self.asymptomatic_multiple_sclerosis = kwargs.get('asymptomatic_multiple_sclerosis')
        self.mildly_symptomatic_pud_with_mild_anemia = kwargs.get('mildly_symptomatic_pud_with_mild_anemia')
        self.moderately_symptomatic_pud_with_mild_anemia = kwargs.get('moderately_symptomatic_pud_with_mild_anemia')
        self.mildly_symptomatic_pud_with_moderate_anemia = kwargs.get('mildly_symptomatic_pud_with_moderate_anemia')
        self.moderately_symptomatic_pud_with_moderate_anemia = kwargs.get('moderately_symptomatic_pud_with_moderate_anemia')
        self.mildly_symptomatic_pud_with_severe_anemia = kwargs.get('mildly_symptomatic_pud_with_severe_anemia')
        self.moderately_symptomatic_pud_with_severe_anemia = kwargs.get('moderately_symptomatic_pud_with_severe_anemia')
        self.mildly_symptomatic_pud_with_no_anemia = kwargs.get('mildly_symptomatic_pud_with_no_anemia')
        self.moderately_symptomatic_pud_with_no_anemia = kwargs.get('moderately_symptomatic_pud_with_no_anemia')
        self.asymptomatic_pud_with_mild_anemia = kwargs.get('asymptomatic_pud_with_mild_anemia')
        self.asymptomatic_pud_with_moderate_anemia = kwargs.get('asymptomatic_pud_with_moderate_anemia')
        self.asymptomatic_pud_with_severe_anemia = kwargs.get('asymptomatic_pud_with_severe_anemia')
        self.mildy_symptomatic_gastritis_duodenitis_with_mild_anemia = kwargs.get('mildy_symptomatic_gastritis_duodenitis_with_mild_anemia')
        self.moderately_symptomatic_gastritis_duodenitis_with_mild_anemia = kwargs.get('moderately_symptomatic_gastritis_duodenitis_with_mild_anemia')
        self.mildly_symptomatic_gastritis_duodenitis_with_moderate_anemia = kwargs.get('mildly_symptomatic_gastritis_duodenitis_with_moderate_anemia')
        self.moderately_symptomatic_gastritis_duodenitis_with_moderate_anemia = kwargs.get('moderately_symptomatic_gastritis_duodenitis_with_moderate_anemia')
        self.mildy_symptomatic_gastritis_duodenitis_with_severe_anemia = kwargs.get('mildy_symptomatic_gastritis_duodenitis_with_severe_anemia')
        self.moderately_symptomatic_gastritis_duodenitis_with_severe_anemia = kwargs.get('moderately_symptomatic_gastritis_duodenitis_with_severe_anemia')
        self.mildly_symptomatic_gastritis_duodenitis_with_no_anemia = kwargs.get('mildly_symptomatic_gastritis_duodenitis_with_no_anemia')
        self.moderately_symptomatic_gastritis_duodenitis_with_no_anemia = kwargs.get('moderately_symptomatic_gastritis_duodenitis_with_no_anemia')
        self.asymptomatic_gastritis_duodenitis_with_mild_anemia = kwargs.get('asymptomatic_gastritis_duodenitis_with_mild_anemia')
        self.asymptomatic_gastritis_duodenitis_with_moderate_anemia = kwargs.get('asymptomatic_gastritis_duodenitis_with_moderate_anemia')
        self.asymptomatic_gastritis_duodenitis_with_severe_anemia = kwargs.get('asymptomatic_gastritis_duodenitis_with_severe_anemia')
        self.severe_malaria_with_mild_anemia = kwargs.get('severe_malaria_with_mild_anemia')
        self.severe_malaria_with_moderate_anemia = kwargs.get('severe_malaria_with_moderate_anemia')
        self.severe_malaria_with_severe_anemia = kwargs.get('severe_malaria_with_severe_anemia')
        self.mild_malaria_with_mild_anemia = kwargs.get('mild_malaria_with_mild_anemia')
        self.mild_malaria_with_moderate_anemia = kwargs.get('mild_malaria_with_moderate_anemia')
        self.mild_malaria_with_severe_anemia = kwargs.get('mild_malaria_with_severe_anemia')
        self.moderate_malaria_with_mild_anemia = kwargs.get('moderate_malaria_with_mild_anemia')
        self.moderate_malaria_with_moderate_anemia = kwargs.get('moderate_malaria_with_moderate_anemia')
        self.moderate_malaria_with_severe_anemia = kwargs.get('moderate_malaria_with_severe_anemia')
        self.asymptomatic_pud_with_no_anemia = kwargs.get('asymptomatic_pud_with_no_anemia')
        self.asymptomatic_gastritis_duodenitis_with_no_anemia = kwargs.get('asymptomatic_gastritis_duodenitis_with_no_anemia')
        self.early_hiv_with_mild_anemia = kwargs.get('early_hiv_with_mild_anemia')
        self.early_hiv_with_moderate_anemia = kwargs.get('early_hiv_with_moderate_anemia')
        self.early_hiv_with_severe_anemia = kwargs.get('early_hiv_with_severe_anemia')
        self.early_hiv_without_anemia = kwargs.get('early_hiv_without_anemia')
        self.symptomatic_hiv_with_mild_anemia = kwargs.get('symptomatic_hiv_with_mild_anemia')
        self.symptomatic_hiv_with_moderate_anemia = kwargs.get('symptomatic_hiv_with_moderate_anemia')
        self.symptomatic_hiv_with_severe_anemia = kwargs.get('symptomatic_hiv_with_severe_anemia')
        self.symptomatic_hiv_without_anemia = kwargs.get('symptomatic_hiv_without_anemia')
        self.hiv_aids_with_antiretroviral_treatment_with_mild_anemia = kwargs.get('hiv_aids_with_antiretroviral_treatment_with_mild_anemia')
        self.hiv_aids_with_antiretroviral_treatment_with_moderate_anemia = kwargs.get('hiv_aids_with_antiretroviral_treatment_with_moderate_anemia')
        self.hiv_aids_with_antiretroviral_treatment_with_severe_anemia = kwargs.get('hiv_aids_with_antiretroviral_treatment_with_severe_anemia')
        self.hiv_aids_with_antiretroviral_treatment_without_anemia = kwargs.get('hiv_aids_with_antiretroviral_treatment_without_anemia')
        self.aids_with_mild_anemia = kwargs.get('aids_with_mild_anemia')
        self.aids_with_moderate_anemia = kwargs.get('aids_with_moderate_anemia')
        self.aids_with_severe_anemia = kwargs.get('aids_with_severe_anemia')
        self.aids_without_anemia = kwargs.get('aids_without_anemia')
        self.hiv_aids_drug_susceptible_tuberculosis_with_mild_anemia = kwargs.get('hiv_aids_drug_susceptible_tuberculosis_with_mild_anemia')
        self.hiv_aids_drug_susceptible_tuberculosis_with_moderate_anemia = kwargs.get('hiv_aids_drug_susceptible_tuberculosis_with_moderate_anemia')
        self.hiv_aids_drug_susceptible_tuberculosis_with_severe_anemia = kwargs.get('hiv_aids_drug_susceptible_tuberculosis_with_severe_anemia')
        self.hiv_aids_drug_susceptible_tuberculosis_without_anemia = kwargs.get('hiv_aids_drug_susceptible_tuberculosis_without_anemia')
        self.hiv_aids_multidrug_resistant_tuberculosis_without_extensive_drug_resistance_with_mild_anemia = kwargs.get('hiv_aids_multidrug_resistant_tuberculosis_without_extensive_drug_resistance_with_mild_anemia')
        self.hiv_aids_multidrug_resistant_tuberculosis_without_extensive_drug_resistance_with_moderate_anemia = kwargs.get('hiv_aids_multidrug_resistant_tuberculosis_without_extensive_drug_resistance_with_moderate_anemia')
        self.hiv_aids_multidrug_resistant_tuberculosis_without_extensive_drug_resistance_with_severe_anemia = kwargs.get('hiv_aids_multidrug_resistant_tuberculosis_without_extensive_drug_resistance_with_severe_anemia')
        self.hiv_aids_multidrug_resistant_tuberculosis_without_extensive_drug_resistance_without_anemia = kwargs.get('hiv_aids_multidrug_resistant_tuberculosis_without_extensive_drug_resistance_without_anemia')
        self.hiv_aids_extensively_drug_resistant_tuberculosis_with_mild_anemia = kwargs.get('hiv_aids_extensively_drug_resistant_tuberculosis_with_mild_anemia')
        self.hiv_aids_extensively_drug_resistant_tuberculosis_with_moderate_anemia = kwargs.get('hiv_aids_extensively_drug_resistant_tuberculosis_with_moderate_anemia')
        self.hiv_aids_extensively_drug_resistant_tuberculosis_with_severe_anemia = kwargs.get('hiv_aids_extensively_drug_resistant_tuberculosis_with_severe_anemia')
        self.hiv_aids_extensively_drug_resistant_tuberculosis_without_anemia = kwargs.get('hiv_aids_extensively_drug_resistant_tuberculosis_without_anemia')
        self.cirrhosis_and_other_chronic_liver_diseases_due_to_hepatitis_b_compensated = kwargs.get('cirrhosis_and_other_chronic_liver_diseases_due_to_hepatitis_b_compensated')
        self.cirrhosis_and_other_chronic_liver_diseases_due_to_hepatitis_c_compensated = kwargs.get('cirrhosis_and_other_chronic_liver_diseases_due_to_hepatitis_c_compensated')
        self.cirrhosis_and_other_chronic_liver_diseases_due_to_alcohol_compensated = kwargs.get('cirrhosis_and_other_chronic_liver_diseases_due_to_alcohol_compensated')
        self.cirrhosis_and_other_chronic_liver_diseases_due_to_other_cause_compensated = kwargs.get('cirrhosis_and_other_chronic_liver_diseases_due_to_other_cause_compensated')
        self.severe_disfigurement_due_to_adult_tertiary_syphilis = kwargs.get('severe_disfigurement_due_to_adult_tertiary_syphilis')
        self.neurological_problems_due_to_adult_tertiary_syphilis = kwargs.get('neurological_problems_due_to_adult_tertiary_syphilis')
        self.cardiovascular_complications_due_to_adult_tertiary_syphilis = kwargs.get('cardiovascular_complications_due_to_adult_tertiary_syphilis')
        self.asymptomatic_adult_tertiary_syphilis = kwargs.get('asymptomatic_adult_tertiary_syphilis')
        self.other_infectious_diseases = kwargs.get('other_infectious_diseases')
        self.other_congenital_birth_defects = kwargs.get('other_congenital_birth_defects')
        self.ectopic_pregnancy = kwargs.get('ectopic_pregnancy')
        self.acute_subarachnoid_hemorrhage_severity_level_1 = kwargs.get('acute_subarachnoid_hemorrhage_severity_level_1')
        self.acute_subarachnoid_hemorrhage_severity_level_2 = kwargs.get('acute_subarachnoid_hemorrhage_severity_level_2')
        self.acute_subarachnoid_hemorrhage_severity_level_3 = kwargs.get('acute_subarachnoid_hemorrhage_severity_level_3')
        self.acute_subarachnoid_hemorrhage_severity_level_4 = kwargs.get('acute_subarachnoid_hemorrhage_severity_level_4')
        self.acute_subarachnoid_hemorrhage_severity_level_5 = kwargs.get('acute_subarachnoid_hemorrhage_severity_level_5')
        self.asymptomatic_chronic_subarachnoid_hemorrhage = kwargs.get('asymptomatic_chronic_subarachnoid_hemorrhage')
        self.chronic_subarachnoid_hemorrhage_severity_level_1 = kwargs.get('chronic_subarachnoid_hemorrhage_severity_level_1')
        self.chronic_subarachnoid_hemorrhage_severity_level_2 = kwargs.get('chronic_subarachnoid_hemorrhage_severity_level_2')
        self.chronic_subarachnoid_hemorrhage_severity_level_3 = kwargs.get('chronic_subarachnoid_hemorrhage_severity_level_3')
        self.chronic_subarachnoid_hemorrhage_severity_level_4 = kwargs.get('chronic_subarachnoid_hemorrhage_severity_level_4')
        self.chronic_subarachnoid_hemorrhage_severity_level_5 = kwargs.get('chronic_subarachnoid_hemorrhage_severity_level_5')
        self.end_stage_renal_disease_after_transplant_due_to_type_1_diabetes_mellitus = kwargs.get('end_stage_renal_disease_after_transplant_due_to_type_1_diabetes_mellitus')
        self.end_stage_renal_disease_after_transplant_due_to_type_2_diabetes_mellitus = kwargs.get('end_stage_renal_disease_after_transplant_due_to_type_2_diabetes_mellitus')
        self.stage_3_chronic_kidney_disease_and_severe_anemia_due_to_type_1_diabetes_mellitus = kwargs.get('stage_3_chronic_kidney_disease_and_severe_anemia_due_to_type_1_diabetes_mellitus')
        self.stage_3_chronic_kidney_disease_and_severe_anemia_due_to_type_2_diabetes_mellitus = kwargs.get('stage_3_chronic_kidney_disease_and_severe_anemia_due_to_type_2_diabetes_mellitus')
        self.stage_3_chronic_kidney_disease_and_moderate_anemia_due_to_type_1_diabetes_mellitus = kwargs.get('stage_3_chronic_kidney_disease_and_moderate_anemia_due_to_type_1_diabetes_mellitus')
        self.stage_3_chronic_kidney_disease_and_moderate_anemia_due_to_type_2_diabetes_mellitus = kwargs.get('stage_3_chronic_kidney_disease_and_moderate_anemia_due_to_type_2_diabetes_mellitus')
        self.stage_3_chronic_kidney_disease_and_mild_anemia_due_to_type_1_diabetes_mellitus = kwargs.get('stage_3_chronic_kidney_disease_and_mild_anemia_due_to_type_1_diabetes_mellitus')
        self.stage_3_chronic_kidney_disease_and_mild_anemia_due_to_type_2_diabetes_mellitus = kwargs.get('stage_3_chronic_kidney_disease_and_mild_anemia_due_to_type_2_diabetes_mellitus')
        self.stage_3_chronic_kidney_disease_without_anemia_due_to_type_1_diabetes_mellitus = kwargs.get('stage_3_chronic_kidney_disease_without_anemia_due_to_type_1_diabetes_mellitus')
        self.stage_3_chronic_kidney_disease_without_anemia_due_to_type_2_diabetes_mellitus = kwargs.get('stage_3_chronic_kidney_disease_without_anemia_due_to_type_2_diabetes_mellitus')
        self.stage_4_chronic_kidney_disease_untreated_and_severe_anemia_due_to_type_1_diabetes_mellitus = kwargs.get('stage_4_chronic_kidney_disease_untreated_and_severe_anemia_due_to_type_1_diabetes_mellitus')
        self.stage_4_chronic_kidney_disease_untreated_and_severe_anemia_due_to_type_2_diabetes_mellitus = kwargs.get('stage_4_chronic_kidney_disease_untreated_and_severe_anemia_due_to_type_2_diabetes_mellitus')
        self.stage_4_chronic_kidney_disease_untreated_and_moderate_anemia_due_to_type_1_diabetes_mellitus = kwargs.get('stage_4_chronic_kidney_disease_untreated_and_moderate_anemia_due_to_type_1_diabetes_mellitus')
        self.stage_4_chronic_kidney_disease_untreated_and_moderate_anemia_due_to_type_2_diabetes_mellitus = kwargs.get('stage_4_chronic_kidney_disease_untreated_and_moderate_anemia_due_to_type_2_diabetes_mellitus')
        self.stage_4_chronic_kidney_disease_untreated_and_mild_anemia_due_to_type_1_diabetes_mellitus = kwargs.get('stage_4_chronic_kidney_disease_untreated_and_mild_anemia_due_to_type_1_diabetes_mellitus')
        self.stage_4_chronic_kidney_disease_untreated_and_mild_anemia_due_to_type_2_diabetes_mellitus = kwargs.get('stage_4_chronic_kidney_disease_untreated_and_mild_anemia_due_to_type_2_diabetes_mellitus')
        self.stage_4_chronic_kidney_disease_untreated_without_anemia_due_to_type_1_diabetes_mellitus = kwargs.get('stage_4_chronic_kidney_disease_untreated_without_anemia_due_to_type_1_diabetes_mellitus')
        self.stage_4_chronic_kidney_disease_untreated_without_anemia_due_to_type_2_diabetes_mellitus = kwargs.get('stage_4_chronic_kidney_disease_untreated_without_anemia_due_to_type_2_diabetes_mellitus')
        self.stage_5_chronic_kidney_disease_untreated_and_severe_anemia_due_to_type_1_diabetes_mellitus = kwargs.get('stage_5_chronic_kidney_disease_untreated_and_severe_anemia_due_to_type_1_diabetes_mellitus')
        self.stage_5_chronic_kidney_disease_untreated_and_severe_anemia_due_to_type_2_diabetes_mellitus = kwargs.get('stage_5_chronic_kidney_disease_untreated_and_severe_anemia_due_to_type_2_diabetes_mellitus')
        self.stage_5_chronic_kidney_disease_untreated_and_moderate_anemia_due_to_type_1_diabetes_mellitus = kwargs.get('stage_5_chronic_kidney_disease_untreated_and_moderate_anemia_due_to_type_1_diabetes_mellitus')
        self.stage_5_chronic_kidney_disease_untreated_and_moderate_anemia_due_to_type_2_diabetes_mellitus = kwargs.get('stage_5_chronic_kidney_disease_untreated_and_moderate_anemia_due_to_type_2_diabetes_mellitus')
        self.stage_5_chronic_kidney_disease_untreated_and_mild_anemia_due_to_type_1_diabetes_mellitus = kwargs.get('stage_5_chronic_kidney_disease_untreated_and_mild_anemia_due_to_type_1_diabetes_mellitus')
        self.stage_5_chronic_kidney_disease_untreated_and_mild_anemia_due_to_type_2_diabetes_mellitus = kwargs.get('stage_5_chronic_kidney_disease_untreated_and_mild_anemia_due_to_type_2_diabetes_mellitus')
        self.stage_5_chronic_kidney_disease_untreated_without_anemia_due_to_type_1_diabetes_mellitus = kwargs.get('stage_5_chronic_kidney_disease_untreated_without_anemia_due_to_type_1_diabetes_mellitus')
        self.stage_5_chronic_kidney_disease_untreated_without_anemia_due_to_type_2_diabetes_mellitus = kwargs.get('stage_5_chronic_kidney_disease_untreated_without_anemia_due_to_type_2_diabetes_mellitus')
        self.calcific_aortic_valve_disease_after_valve_intervention = kwargs.get('calcific_aortic_valve_disease_after_valve_intervention')
        self.asymptomatic_calcific_aortic_valve_disease = kwargs.get('asymptomatic_calcific_aortic_valve_disease')
        self.mild_heart_failure_due_to_calcific_aortic_valve_disease = kwargs.get('mild_heart_failure_due_to_calcific_aortic_valve_disease')
        self.moderate_heart_failure_due_to_calcific_aortic_valve_disease = kwargs.get('moderate_heart_failure_due_to_calcific_aortic_valve_disease')
        self.severe_heart_failure_due_to_calcific_aortic_valve_disease = kwargs.get('severe_heart_failure_due_to_calcific_aortic_valve_disease')
        self.degenerative_mitral_valve_disease_after_valve_intervention = kwargs.get('degenerative_mitral_valve_disease_after_valve_intervention')
        self.asymptomatic_degenerative_mitral_valve_disease = kwargs.get('asymptomatic_degenerative_mitral_valve_disease')
        self.mild_heart_failure_due_to_degenerative_mitral_valve_disease = kwargs.get('mild_heart_failure_due_to_degenerative_mitral_valve_disease')
        self.moderate_heart_failure_due_to_degenerative_mitral_valve_disease = kwargs.get('moderate_heart_failure_due_to_degenerative_mitral_valve_disease')
        self.severe_heart_failure_due_to_degenerative_mitral_valve_disease = kwargs.get('severe_heart_failure_due_to_degenerative_mitral_valve_disease')
        self.mild_heart_failure_due_to_other_non_rheumatic_valve_disease = kwargs.get('mild_heart_failure_due_to_other_non_rheumatic_valve_disease')
        self.moderate_heart_failure_due_to_other_non_rheumatic_valve_disease = kwargs.get('moderate_heart_failure_due_to_other_non_rheumatic_valve_disease')
        self.severe_heart_failure_due_to_other_non_rheumatic_valve_disease = kwargs.get('severe_heart_failure_due_to_other_non_rheumatic_valve_disease')
        self.cirrhosis_and_other_chronic_liver_diseases_due_to_nash_compensated = kwargs.get('cirrhosis_and_other_chronic_liver_diseases_due_to_nash_compensated')
        self.vitamin_a_deficiency_with_mild_anemia = kwargs.get('vitamin_a_deficiency_with_mild_anemia')
        self.vitamin_a_deficiency_with_moderate_anemia = kwargs.get('vitamin_a_deficiency_with_moderate_anemia')
        self.vitamin_a_deficiency_with_severe_anemia = kwargs.get('vitamin_a_deficiency_with_severe_anemia')
        self.myelodysplastic_myeloproliferative_and_other_hematopoietic_neoplasms = kwargs.get('myelodysplastic_myeloproliferative_and_other_hematopoietic_neoplasms')
        self.benign_and_in_situ_intestinal_neoplasms = kwargs.get('benign_and_in_situ_intestinal_neoplasms')
        self.benign_and_in_situ_cervical_and_uterine_neoplasms = kwargs.get('benign_and_in_situ_cervical_and_uterine_neoplasms')
        self.other_benign_and_in_situ_neoplasms = kwargs.get('other_benign_and_in_situ_neoplasms')
        self.diagnosis_and_primary_therapy_phase_of_liver_cancer_due_to_nash = kwargs.get('diagnosis_and_primary_therapy_phase_of_liver_cancer_due_to_nash')
        self.controlled_phase_of_liver_cancer_due_to_nash = kwargs.get('controlled_phase_of_liver_cancer_due_to_nash')
        self.metastatic_phase_of_liver_cancer_due_to_nash = kwargs.get('metastatic_phase_of_liver_cancer_due_to_nash')
        self.terminal_phase_of_liver_cancer_due_to_nash = kwargs.get('terminal_phase_of_liver_cancer_due_to_nash')
        self.diabetic_foot_due_to_neuropathy_due_to_diabetes_mellitus_type_1 = kwargs.get('diabetic_foot_due_to_neuropathy_due_to_diabetes_mellitus_type_1')
        self.diabetic_neuropathy_due_to_diabetes_mellitus_type_1_without_diabetic_foot_or_amputation = kwargs.get('diabetic_neuropathy_due_to_diabetes_mellitus_type_1_without_diabetic_foot_or_amputation')
        self.diabetic_neuropathy_and_amputation_with_treatment_due_to_diabetes_mellitus_type_1 = kwargs.get('diabetic_neuropathy_and_amputation_with_treatment_due_to_diabetes_mellitus_type_1')
        self.diabetic_neuropathy_and_amputation_without_treatment_due_to_diabetes_mellitus_type_1 = kwargs.get('diabetic_neuropathy_and_amputation_without_treatment_due_to_diabetes_mellitus_type_1')
        self.uncomplicated_diabetes_mellitus_type_1 = kwargs.get('uncomplicated_diabetes_mellitus_type_1')
        self.moderate_vision_impairment_due_to_diabetes_mellitus_type_1_retinopathy = kwargs.get('moderate_vision_impairment_due_to_diabetes_mellitus_type_1_retinopathy')
        self.severe_vision_impairment_due_to_diabetes_mellitus_type_1_retinopathy = kwargs.get('severe_vision_impairment_due_to_diabetes_mellitus_type_1_retinopathy')
        self.blindness_due_to_diabetes_mellitus_type_1_retinopathy = kwargs.get('blindness_due_to_diabetes_mellitus_type_1_retinopathy')
        self.diabetic_foot_due_to_neuropathy_due_to_diabetes_mellitus_type_2 = kwargs.get('diabetic_foot_due_to_neuropathy_due_to_diabetes_mellitus_type_2')
        self.diabetic_neuropathy_due_to_diabetes_mellitus_type_2_without_diabetic_foot_or_amputation = kwargs.get('diabetic_neuropathy_due_to_diabetes_mellitus_type_2_without_diabetic_foot_or_amputation')
        self.diabetic_neuropathy_and_amputation_with_treatment_due_to_diabetes_mellitus_type_2 = kwargs.get('diabetic_neuropathy_and_amputation_with_treatment_due_to_diabetes_mellitus_type_2')
        self.diabetic_neuropathy_and_amputation_without_treatment_due_to_diabetes_mellitus_type_2 = kwargs.get('diabetic_neuropathy_and_amputation_without_treatment_due_to_diabetes_mellitus_type_2')
        self.uncomplicated_diabetes_mellitus_type_2 = kwargs.get('uncomplicated_diabetes_mellitus_type_2')
        self.moderate_vision_impairment_due_to_diabetes_mellitus_type_2_retinopathy = kwargs.get('moderate_vision_impairment_due_to_diabetes_mellitus_type_2_retinopathy')
        self.severe_vision_impairment_due_to_diabetes_mellitus_type_2_retinopathy = kwargs.get('severe_vision_impairment_due_to_diabetes_mellitus_type_2_retinopathy')
        self.blindness_due_to_diabetes_mellitus_type_2_retinopathy = kwargs.get('blindness_due_to_diabetes_mellitus_type_2_retinopathy')
        self.non_alcoholic_fatty_liver_disease_nafld_non_alcoholic_steatohepatitis_nash = kwargs.get('non_alcoholic_fatty_liver_disease_nafld_non_alcoholic_steatohepatitis_nash')
        self.near_vision_loss = kwargs.get('near_vision_loss')
        self.controlled_phase_of_breast_cancer_with_mastectomy = kwargs.get('controlled_phase_of_breast_cancer_with_mastectomy')
        self.controlled_phase_of_breast_cancer_without_mastectomy = kwargs.get('controlled_phase_of_breast_cancer_without_mastectomy')
        self.mastectomy_from_breast_cancer_beyond_ten_years = kwargs.get('mastectomy_from_breast_cancer_beyond_ten_years')
        self.controlled_phase_of_prostate_cancer_with_impotence = kwargs.get('controlled_phase_of_prostate_cancer_with_impotence')
        self.controlled_phase_of_prostate_cancer_with_incontinence = kwargs.get('controlled_phase_of_prostate_cancer_with_incontinence')
        self.controlled_phase_of_prostate_cancer_without_impotence_or_incontinence = kwargs.get('controlled_phase_of_prostate_cancer_without_impotence_or_incontinence')
        self.impotence_from_prostate_cancer_beyond_ten_years = kwargs.get('impotence_from_prostate_cancer_beyond_ten_years')
        self.incontinence_from_prostate_cancer_beyond_ten_years = kwargs.get('incontinence_from_prostate_cancer_beyond_ten_years')
        self.controlled_phase_of_larynx_cancer_with_laryngectomy = kwargs.get('controlled_phase_of_larynx_cancer_with_laryngectomy')
        self.controlled_phase_of_larynx_cancer_without_laryngectomy = kwargs.get('controlled_phase_of_larynx_cancer_without_laryngectomy')
        self.laryngectomy_from_larynx_cancer_beyond_ten_years = kwargs.get('laryngectomy_from_larynx_cancer_beyond_ten_years')
        self.controlled_phase_of_colon_and_rectum_cancers_with_stoma = kwargs.get('controlled_phase_of_colon_and_rectum_cancers_with_stoma')
        self.controlled_phase_of_colon_and_rectum_cancers_without_stoma = kwargs.get('controlled_phase_of_colon_and_rectum_cancers_without_stoma')
        self.stoma_from_colon_and_rectum_cancers_beyond_ten_years = kwargs.get('stoma_from_colon_and_rectum_cancers_beyond_ten_years')
        self.controlled_phase_of_bladder_cancer_with_incontinence = kwargs.get('controlled_phase_of_bladder_cancer_with_incontinence')
        self.controlled_phase_of_bladder_cancer_without_incontinence = kwargs.get('controlled_phase_of_bladder_cancer_without_incontinence')
        self.incontinence_from_bladder_cancer_beyond_ten_years = kwargs.get('incontinence_from_bladder_cancer_beyond_ten_years')
        self.moderate_pain_and_limited_mobility_due_to_guinea_worm = kwargs.get('moderate_pain_and_limited_mobility_due_to_guinea_worm')
        self.stage_1_2_chronic_kidney_disease_with_preserved_gfr_due_to_type_1_diabetes_mellitus = kwargs.get('stage_1_2_chronic_kidney_disease_with_preserved_gfr_due_to_type_1_diabetes_mellitus')
        self.stage_1_2_chronic_kidney_disease_with_preserved_gfr_due_to_type_2_diabetes_mellitus = kwargs.get('stage_1_2_chronic_kidney_disease_with_preserved_gfr_due_to_type_2_diabetes_mellitus')
        self.stage_1_2_chronic_kidney_disease_with_preserved_gfr_due_to_hypertension = kwargs.get('stage_1_2_chronic_kidney_disease_with_preserved_gfr_due_to_hypertension')
        self.stage_1_2_chronic_kidney_disease_with_preserved_gfr_due_to_glomerulonephritis = kwargs.get('stage_1_2_chronic_kidney_disease_with_preserved_gfr_due_to_glomerulonephritis')
        self.stage_1_2_chronic_kidney_disease_with_preserved_gfr_due_to_other_causes = kwargs.get('stage_1_2_chronic_kidney_disease_with_preserved_gfr_due_to_other_causes')
        self.severe_acute_ints = kwargs.get('severe_acute_ints')
        self.menstrual_disorders_without_anemia = kwargs.get('menstrual_disorders_without_anemia')
        self.ulcerative_colitis_with_mild_anemia = kwargs.get('ulcerative_colitis_with_mild_anemia')
        self.ulcerative_colitis_with_moderate_anemia = kwargs.get('ulcerative_colitis_with_moderate_anemia')
        self.ulcerative_colitis_with_severe_anemia = kwargs.get('ulcerative_colitis_with_severe_anemia')
        self.ulcerative_colitis_without_anemia = kwargs.get('ulcerative_colitis_without_anemia')
        self.crohns_disease_with_mild_anemia = kwargs.get('crohns_disease_with_mild_anemia')
        self.crohns_disease_with_moderate_anemia = kwargs.get('crohns_disease_with_moderate_anemia')
        self.crohns_disease_with_severe_anemia = kwargs.get('crohns_disease_with_severe_anemia')
        self.crohns_disease_without_anemia = kwargs.get('crohns_disease_without_anemia')
        self.mild_anemia_due_to_malaria_vivax_pvpr = kwargs.get('mild_anemia_due_to_malaria_vivax_pvpr')
        self.moderate_anemia_due_to_malaria_vivax_pvpr = kwargs.get('moderate_anemia_due_to_malaria_vivax_pvpr')
        self.severe_anemia_due_to_malaria_vivax_pvpr = kwargs.get('severe_anemia_due_to_malaria_vivax_pvpr')
        self.asymptomatic_malaria_vivax_pvpr = kwargs.get('asymptomatic_malaria_vivax_pvpr')
        self.non_disabling_symptomatic_acne = kwargs.get('non_disabling_symptomatic_acne')
        self.acute_pancreatitis = kwargs.get('acute_pancreatitis')
        self.complicated_pud_with_no_anemia = kwargs.get('complicated_pud_with_no_anemia')
        self.complicated_pud_with_mild_anemia = kwargs.get('complicated_pud_with_mild_anemia')
        self.complicated_pud_with_moderate_anemia = kwargs.get('complicated_pud_with_moderate_anemia')
        self.complicated_pud_with_severe_anemia = kwargs.get('complicated_pud_with_severe_anemia')
        self.complicated_gastritis_duodenitis_with_no_anemia = kwargs.get('complicated_gastritis_duodenitis_with_no_anemia')
        self.complicated_gastritis_duodenitis_with_mild_anemia = kwargs.get('complicated_gastritis_duodenitis_with_mild_anemia')
        self.complicated_gastritis_duodenitis_with_moderate_anemia = kwargs.get('complicated_gastritis_duodenitis_with_moderate_anemia')
        self.complicated_gastritis_duodenitis_with_severe_anemia = kwargs.get('complicated_gastritis_duodenitis_with_severe_anemia')
        self.controlled_medically_managed_heart_failure_due_ischemic_heart_disease = kwargs.get('controlled_medically_managed_heart_failure_due_ischemic_heart_disease')
        self.controlled_medically_managed_heart_failure_due_to_alcoholic_cardiomyopathy = kwargs.get('controlled_medically_managed_heart_failure_due_to_alcoholic_cardiomyopathy')
        self.controlled_medically_managed_heart_failure_due_to_calcific_aortic_valve_disease = kwargs.get('controlled_medically_managed_heart_failure_due_to_calcific_aortic_valve_disease')
        self.controlled_medically_managed_heart_failure_due_to_chagas_disease = kwargs.get('controlled_medically_managed_heart_failure_due_to_chagas_disease')
        self.controlled_medically_managed_heart_failure_due_to_degenerative_mitral_valve_disease = kwargs.get('controlled_medically_managed_heart_failure_due_to_degenerative_mitral_valve_disease')
        self.controlled_medically_managed_heart_failure_due_to_endocarditis = kwargs.get('controlled_medically_managed_heart_failure_due_to_endocarditis')
        self.controlled_medically_managed_heart_failure_due_to_endocrine_metabolic_blood_and_immune_disorders = kwargs.get('controlled_medically_managed_heart_failure_due_to_endocrine_metabolic_blood_and_immune_disorders')
        self.controlled_medically_managed_heart_failure_due_to_g6pd_deficiency = kwargs.get('controlled_medically_managed_heart_failure_due_to_g6pd_deficiency')
        self.controlled_medically_managed_heart_failure_due_to_hypertensive_heart_disease = kwargs.get('controlled_medically_managed_heart_failure_due_to_hypertensive_heart_disease')
        self.controlled_medically_managed_heart_failure_due_to_myocarditis = kwargs.get('controlled_medically_managed_heart_failure_due_to_myocarditis')
        self.controlled_medically_managed_heart_failure_due_to_other_cardiomyopathy = kwargs.get('controlled_medically_managed_heart_failure_due_to_other_cardiomyopathy')
        self.controlled_medically_managed_heart_failure_due_to_other_cardiovascular_disease = kwargs.get('controlled_medically_managed_heart_failure_due_to_other_cardiovascular_disease')
        self.controlled_medically_managed_heart_failure_due_to_other_hemoglobinopathies_and_hemolytic_anemias = kwargs.get('controlled_medically_managed_heart_failure_due_to_other_hemoglobinopathies_and_hemolytic_anemias')
        self.controlled_medically_managed_heart_failure_due_to_other_non_rheumatic_valve_disease = kwargs.get('controlled_medically_managed_heart_failure_due_to_other_non_rheumatic_valve_disease')
        self.controlled_medically_managed_heart_failure_due_to_rheumatic_heart_disease = kwargs.get('controlled_medically_managed_heart_failure_due_to_rheumatic_heart_disease')
        self.controlled_medically_managed_heart_failure_due_to_severe_asbestosis = kwargs.get('controlled_medically_managed_heart_failure_due_to_severe_asbestosis')
        self.controlled_medically_managed_heart_failure_due_to_severe_chronic_obstructive_pulmonary_disease = kwargs.get('controlled_medically_managed_heart_failure_due_to_severe_chronic_obstructive_pulmonary_disease')
        self.controlled_medically_managed_heart_failure_due_to_severe_coal_workers_pneumoconiosis = kwargs.get('controlled_medically_managed_heart_failure_due_to_severe_coal_workers_pneumoconiosis')
        self.controlled_medically_managed_heart_failure_due_to_severe_interstitial_lung_disease_and_pulmonary_sarcoidosis = kwargs.get('controlled_medically_managed_heart_failure_due_to_severe_interstitial_lung_disease_and_pulmonary_sarcoidosis')
        self.controlled_medically_managed_heart_failure_due_to_severe_other_pneumoconiosis = kwargs.get('controlled_medically_managed_heart_failure_due_to_severe_other_pneumoconiosis')
        self.controlled_medically_managed_heart_failure_due_to_severe_silicosis = kwargs.get('controlled_medically_managed_heart_failure_due_to_severe_silicosis')
        self.controlled_medically_managed_heart_failure_due_to_thalassemias = kwargs.get('controlled_medically_managed_heart_failure_due_to_thalassemias')
        self.congenital_heart_disease_and_controlled_medically_managed_heart_failure_without_intellectual_disability_due_to_critical_malformations_of_great_vessels_congenital_valvular_heart_disease_and_patent_ductus_arteriosus = kwargs.get('congenital_heart_disease_and_controlled_medically_managed_heart_failure_without_intellectual_disability_due_to_critical_malformations_of_great_vessels_congenital_valvular_heart_disease_and_patent_ductus_arteriosus')
        self.congenital_heart_disease_and_controlled_medically_managed_heart_failure_without_intellectual_disability_due_to_severe_congenital_heart_anomalies_excluding_single_ventricle_heart_defects = kwargs.get('congenital_heart_disease_and_controlled_medically_managed_heart_failure_without_intellectual_disability_due_to_severe_congenital_heart_anomalies_excluding_single_ventricle_heart_defects')
        self.congenital_heart_disease_and_controlled_medically_managed_heart_failure_without_intellectual_disability_due_to_single_ventricle_and_single_ventricle_pathway_heart_defects = kwargs.get('congenital_heart_disease_and_controlled_medically_managed_heart_failure_without_intellectual_disability_due_to_single_ventricle_and_single_ventricle_pathway_heart_defects')
        self.congenital_heart_disease_and_controlled_medically_managed_heart_failure_without_intellectual_disability_due_to_ventricular_septal_defect_and_atrial_septal_defect = kwargs.get('congenital_heart_disease_and_controlled_medically_managed_heart_failure_without_intellectual_disability_due_to_ventricular_septal_defect_and_atrial_septal_defect')
        self.congenital_heart_disease_borderline_intellectual_disability_and_controlled_medically_managed_heart_failure_due_to_critical_malformations_of_great_vessels_congenital_valvular_heart_disease_and_patent_ductus_arteriosus = kwargs.get('congenital_heart_disease_borderline_intellectual_disability_and_controlled_medically_managed_heart_failure_due_to_critical_malformations_of_great_vessels_congenital_valvular_heart_disease_and_patent_ductus_arteriosus')
        self.congenital_heart_disease_borderline_intellectual_disability_and_controlled_medically_managed_heart_failure_due_to_severe_congenital_heart_anomalies_excluding_single_ventricle_heart_defects = kwargs.get('congenital_heart_disease_borderline_intellectual_disability_and_controlled_medically_managed_heart_failure_due_to_severe_congenital_heart_anomalies_excluding_single_ventricle_heart_defects')
        self.congenital_heart_disease_borderline_intellectual_disability_and_controlled_medically_managed_heart_failure_due_to_single_ventricle_and_single_ventricle_pathway_heart_defects = kwargs.get('congenital_heart_disease_borderline_intellectual_disability_and_controlled_medically_managed_heart_failure_due_to_single_ventricle_and_single_ventricle_pathway_heart_defects')
        self.congenital_heart_disease_borderline_intellectual_disability_and_controlled_medically_managed_heart_failure_due_to_ventricular_septal_defect_and_atrial_septal_defect = kwargs.get('congenital_heart_disease_borderline_intellectual_disability_and_controlled_medically_managed_heart_failure_due_to_ventricular_septal_defect_and_atrial_septal_defect')
        self.congenital_heart_disease_mild_intellectual_disability_and_controlled_medically_managed_heart_failure_due_to_critical_malformations_of_great_vessels_congenital_valvular_heart_disease_and_patent_ductus_arteriosus = kwargs.get('congenital_heart_disease_mild_intellectual_disability_and_controlled_medically_managed_heart_failure_due_to_critical_malformations_of_great_vessels_congenital_valvular_heart_disease_and_patent_ductus_arteriosus')
        self.congenital_heart_disease_mild_intellectual_disability_and_controlled_medically_managed_heart_failure_due_to_severe_congenital_heart_anomalies_excluding_single_ventricle_heart_defects = kwargs.get('congenital_heart_disease_mild_intellectual_disability_and_controlled_medically_managed_heart_failure_due_to_severe_congenital_heart_anomalies_excluding_single_ventricle_heart_defects')
        self.congenital_heart_disease_mild_intellectual_disability_and_controlled_medically_managed_heart_failure_due_to_single_ventricle_and_single_ventricle_pathway_heart_defects = kwargs.get('congenital_heart_disease_mild_intellectual_disability_and_controlled_medically_managed_heart_failure_due_to_single_ventricle_and_single_ventricle_pathway_heart_defects')
        self.congenital_heart_disease_mild_intellectual_disability_and_controlled_medically_managed_heart_failure_due_to_ventricular_septal_defect_and_atrial_septal_defect = kwargs.get('congenital_heart_disease_mild_intellectual_disability_and_controlled_medically_managed_heart_failure_due_to_ventricular_septal_defect_and_atrial_septal_defect')
        self.congenital_heart_disease_moderate_intellectual_disability_and_controlled_medically_managed_heart_failure_due_to_critical_malformations_of_great_vessels_congenital_valvular_heart_disease_and_patent_ductus_arteriosus = kwargs.get('congenital_heart_disease_moderate_intellectual_disability_and_controlled_medically_managed_heart_failure_due_to_critical_malformations_of_great_vessels_congenital_valvular_heart_disease_and_patent_ductus_arteriosus')
        self.congenital_heart_disease_moderate_intellectual_disability_and_controlled_medically_managed_heart_failure_due_to_severe_congenital_heart_anomalies_excluding_single_ventricle_heart_defects = kwargs.get('congenital_heart_disease_moderate_intellectual_disability_and_controlled_medically_managed_heart_failure_due_to_severe_congenital_heart_anomalies_excluding_single_ventricle_heart_defects')
        self.congenital_heart_disease_moderate_intellectual_disability_and_controlled_medically_managed_heart_failure_due_to_single_ventricle_and_single_ventricle_pathway_heart_defects = kwargs.get('congenital_heart_disease_moderate_intellectual_disability_and_controlled_medically_managed_heart_failure_due_to_single_ventricle_and_single_ventricle_pathway_heart_defects')
        self.congenital_heart_disease_moderate_intellectual_disability_and_controlled_medically_managed_heart_failure_due_to_ventricular_septal_defect_and_atrial_septal_defect = kwargs.get('congenital_heart_disease_moderate_intellectual_disability_and_controlled_medically_managed_heart_failure_due_to_ventricular_septal_defect_and_atrial_septal_defect')
        self.congenital_heart_disease_profound_intellectual_disability_and_controlled_medically_managed_heart_failure_due_to_severe_congenital_heart_anomalies_excluding_single_ventricle_heart_defects = kwargs.get('congenital_heart_disease_profound_intellectual_disability_and_controlled_medically_managed_heart_failure_due_to_severe_congenital_heart_anomalies_excluding_single_ventricle_heart_defects')
        self.congenital_heart_disease_profound_intellectual_disability_and_controlled_medically_managed_heart_failure_due_to_single_ventricle_and_single_ventricle_pathway_heart_defects = kwargs.get('congenital_heart_disease_profound_intellectual_disability_and_controlled_medically_managed_heart_failure_due_to_single_ventricle_and_single_ventricle_pathway_heart_defects')
        self.congenital_heart_disease_profound_intellectual_disability_and_controlled_medically_managed_heart_failure_due_to_ventricular_septal_defect_and_atrial_septal_defect = kwargs.get('congenital_heart_disease_profound_intellectual_disability_and_controlled_medically_managed_heart_failure_due_to_ventricular_septal_defect_and_atrial_septal_defect')
        self.congenital_heart_disease_profound_intellectual_disability_and_controlled_medically_managed_heart_failure_due_to_critical_malformations_of_great_vessels_congenital_valvular_heart_disease_and_patent_ductus_arteriosus = kwargs.get('congenital_heart_disease_profound_intellectual_disability_and_controlled_medically_managed_heart_failure_due_to_critical_malformations_of_great_vessels_congenital_valvular_heart_disease_and_patent_ductus_arteriosus')
        self.congenital_heart_disease_severe_intellectual_disability_and_controlled_medically_managed_heart_failure_due_to_critical_malformations_of_great_vessels_congenital_valvular_heart_disease_and_patent_ductus_arteriosus = kwargs.get('congenital_heart_disease_severe_intellectual_disability_and_controlled_medically_managed_heart_failure_due_to_critical_malformations_of_great_vessels_congenital_valvular_heart_disease_and_patent_ductus_arteriosus')
        self.congenital_heart_disease_severe_intellectual_disability_and_controlled_medically_managed_heart_failure_due_to_severe_congenital_heart_anomalies_excluding_single_ventricle_heart_defects = kwargs.get('congenital_heart_disease_severe_intellectual_disability_and_controlled_medically_managed_heart_failure_due_to_severe_congenital_heart_anomalies_excluding_single_ventricle_heart_defects')
        self.congenital_heart_disease_severe_intellectual_disability_and_controlled_medically_managed_heart_failure_due_to_single_ventricle_and_single_ventricle_pathway_heart_defects = kwargs.get('congenital_heart_disease_severe_intellectual_disability_and_controlled_medically_managed_heart_failure_due_to_single_ventricle_and_single_ventricle_pathway_heart_defects')
        self.congenital_heart_disease_severe_intellectual_disability_and_controlled_medically_managed_heart_failure_due_to_ventricular_septal_defect_and_atrial_septal_defect = kwargs.get('congenital_heart_disease_severe_intellectual_disability_and_controlled_medically_managed_heart_failure_due_to_ventricular_septal_defect_and_atrial_septal_defect')
        self.diagnosis_and_primary_therapy_phase_of_other_malignant_neoplasms = kwargs.get('diagnosis_and_primary_therapy_phase_of_other_malignant_neoplasms')
        self.controlled_phase_of_other_malignant_neoplasms = kwargs.get('controlled_phase_of_other_malignant_neoplasms')
        self.metastatic_phase_of_other_malignant_neoplasms = kwargs.get('metastatic_phase_of_other_malignant_neoplasms')
        self.terminal_phase_of_other_malignant_neoplasms = kwargs.get('terminal_phase_of_other_malignant_neoplasms')
        self.asymptomatic_rheumatoid_arthritis = kwargs.get('asymptomatic_rheumatoid_arthritis')
        self.symptomatic_probable_migraine = kwargs.get('symptomatic_probable_migraine')
        self.asymptomatic_probable_migraine = kwargs.get('asymptomatic_probable_migraine')
        self.symptomatic_definite_migraine = kwargs.get('symptomatic_definite_migraine')
        self.asymptomatic_definite_migraine = kwargs.get('asymptomatic_definite_migraine')
        self.asymptomatic_osteoarthritis_of_the_knee = kwargs.get('asymptomatic_osteoarthritis_of_the_knee')
        self.asymptomatic_osteoarthritis_of_the_hip = kwargs.get('asymptomatic_osteoarthritis_of_the_hip')
        self.mild_to_moderate_gerd_symptomatic_days = kwargs.get('mild_to_moderate_gerd_symptomatic_days')
        self.mild_to_moderate_gerd_asymptomatic_days = kwargs.get('mild_to_moderate_gerd_asymptomatic_days')
        self.severe_gerd_symptomatic_days = kwargs.get('severe_gerd_symptomatic_days')
        self.severe_gerd_asymptomatic_days = kwargs.get('severe_gerd_asymptomatic_days')
        self.asymptomatic_chronic_pancreatitis = kwargs.get('asymptomatic_chronic_pancreatitis')
        self.severe_acute_uncomplicated_pud_with_no_anemia = kwargs.get('severe_acute_uncomplicated_pud_with_no_anemia')
        self.severe_acute_uncomplicated_pud_with_mild_anemia = kwargs.get('severe_acute_uncomplicated_pud_with_mild_anemia')
        self.severe_acute_uncomplicated_pud_with_moderate_anemia = kwargs.get('severe_acute_uncomplicated_pud_with_moderate_anemia')
        self.severe_acute_uncomplicated_pud_with_severe_anemia = kwargs.get('severe_acute_uncomplicated_pud_with_severe_anemia')
        self.severe_acute_uncomplicated_gastritis_duodenitis_with_no_anemia = kwargs.get('severe_acute_uncomplicated_gastritis_duodenitis_with_no_anemia')
        self.severe_acute_uncomplicated_gastritis_duodenitis_with_mild_anemia = kwargs.get('severe_acute_uncomplicated_gastritis_duodenitis_with_mild_anemia')
        self.severe_acute_uncomplicated_gastritis_duodenitis_with_moderate_anemia = kwargs.get('severe_acute_uncomplicated_gastritis_duodenitis_with_moderate_anemia')
        self.severe_acute_uncomplicated_gastritis_duodenitis_with_severe_anemia = kwargs.get('severe_acute_uncomplicated_gastritis_duodenitis_with_severe_anemia')
        self.extreme_hyperbilirubinemia_due_to_hemolytic_disease_and_other_neonatal_jaundice_without_kernicterus = kwargs.get('extreme_hyperbilirubinemia_due_to_hemolytic_disease_and_other_neonatal_jaundice_without_kernicterus')
        self.basal_cell_carcinoma_without_disfigurement = kwargs.get('basal_cell_carcinoma_without_disfigurement')
        self.mild_motor_impairment_and_moderate_respiratory_problems_due_to_motor_neuron_disease = kwargs.get('mild_motor_impairment_and_moderate_respiratory_problems_due_to_motor_neuron_disease')
        self.mild_motor_plus_cognitive_impairments_due_to_meningitis = kwargs.get('mild_motor_plus_cognitive_impairments_due_to_meningitis')
        self.moderately_severe_hearing_loss_due_to_meningitis = kwargs.get('moderately_severe_hearing_loss_due_to_meningitis')
        self.profound_hearing_loss_with_ringing_due_to_meningitis = kwargs.get('profound_hearing_loss_with_ringing_due_to_meningitis')
        self.moderate_motor_impairment_due_to_meningitis = kwargs.get('moderate_motor_impairment_due_to_meningitis')
        self.blindness_due_to_meningitis = kwargs.get('blindness_due_to_meningitis')
        self.moderate_hearing_loss_with_ringing_due_to_meningitis = kwargs.get('moderate_hearing_loss_with_ringing_due_to_meningitis')
        self.profound_hearing_loss_due_to_meningitis = kwargs.get('profound_hearing_loss_due_to_meningitis')
        self.mild_intellectual_disability_due_to_meningitis = kwargs.get('mild_intellectual_disability_due_to_meningitis')
        self.epilepsy_due_to_meningitis = kwargs.get('epilepsy_due_to_meningitis')
        self.moderate_hearing_loss_due_to_meningitis = kwargs.get('moderate_hearing_loss_due_to_meningitis')
        self.severe_hearing_loss_with_ringing_due_to_meningitis = kwargs.get('severe_hearing_loss_with_ringing_due_to_meningitis')
        self.borderline_intellectual_disability_due_to_meningitis = kwargs.get('borderline_intellectual_disability_due_to_meningitis')
        self.monocular_distance_vision_loss_due_to_meningitis = kwargs.get('monocular_distance_vision_loss_due_to_meningitis')
        self.severe_motor_plus_cognitive_impairments_due_to_meningitis = kwargs.get('severe_motor_plus_cognitive_impairments_due_to_meningitis')
        self.mild_hearing_loss_with_ringing_due_to_meningitis = kwargs.get('mild_hearing_loss_with_ringing_due_to_meningitis')
        self.mild_motor_impairment_due_to_long_term_due_to_meningitis = kwargs.get('mild_motor_impairment_due_to_long_term_due_to_meningitis')
        self.mild_behavioral_problems_due_to_meningitis = kwargs.get('mild_behavioral_problems_due_to_meningitis')
        self.severe_hearing_loss_due_to_meningitis = kwargs.get('severe_hearing_loss_due_to_meningitis')
        self.complete_hearing_loss_with_ringing_due_to_meningitis = kwargs.get('complete_hearing_loss_with_ringing_due_to_meningitis')
        self.moderate_motor_plus_cognitive_impairments_due_to_meningitis = kwargs.get('moderate_motor_plus_cognitive_impairments_due_to_meningitis')
        self.mild_hearing_loss_due_to_meningitis = kwargs.get('mild_hearing_loss_due_to_meningitis')
        self.acute_meningitis = kwargs.get('acute_meningitis')
        self.moderately_severe_hearing_loss_with_ringing_due_to_meningitis = kwargs.get('moderately_severe_hearing_loss_with_ringing_due_to_meningitis')
        self.complete_hearing_loss_due_to_meningitis = kwargs.get('complete_hearing_loss_due_to_meningitis')
        self.severe_motor_impairment_due_to_meningitis = kwargs.get('severe_motor_impairment_due_to_meningitis')
        self.moderate_vision_impairment_due_to_meningitis = kwargs.get('moderate_vision_impairment_due_to_meningitis')
        self.severe_vision_impairment_due_to_meningitis = kwargs.get('severe_vision_impairment_due_to_meningitis')
        self.mild_osteoarthritis_of_the_hand_and_foot = kwargs.get('mild_osteoarthritis_of_the_hand_and_foot')
        self.moderate_osteoarthritis_of_the_hand_and_foot = kwargs.get('moderate_osteoarthritis_of_the_hand_and_foot')
        self.severe_osteoarthritis_of_the_hand_and_foot = kwargs.get('severe_osteoarthritis_of_the_hand_and_foot')
        self.mild_osteoarthritis_other = kwargs.get('mild_osteoarthritis_other')
        self.moderate_osteoarthritis_other = kwargs.get('moderate_osteoarthritis_other')
        self.severe_osteoarthritis_other = kwargs.get('severe_osteoarthritis_other')
        self.diagnosis_and_primary_therapy_phase_of_burkitt_lymphoma = kwargs.get('diagnosis_and_primary_therapy_phase_of_burkitt_lymphoma')
        self.controlled_phase_of_burkitt_lymphoma = kwargs.get('controlled_phase_of_burkitt_lymphoma')
        self.metastatic_phase_of_burkitt_lymphoma = kwargs.get('metastatic_phase_of_burkitt_lymphoma')
        self.terminal_phase_of_burkitt_lymphoma = kwargs.get('terminal_phase_of_burkitt_lymphoma')
        self.diagnosis_and_primary_therapy_phase_of_other_non_hodgkin_lymphoma = kwargs.get('diagnosis_and_primary_therapy_phase_of_other_non_hodgkin_lymphoma')
        self.controlled_phase_of_other_non_hodgkin_lymphoma = kwargs.get('controlled_phase_of_other_non_hodgkin_lymphoma')
        self.metastatic_phase_of_other_non_hodgkin_lymphoma = kwargs.get('metastatic_phase_of_other_non_hodgkin_lymphoma')
        self.terminal_phase_of_other_non_hodgkin_lymphoma = kwargs.get('terminal_phase_of_other_non_hodgkin_lymphoma')
        self.diagnosis_and_primary_therapy_phase_of_hepatoblastoma = kwargs.get('diagnosis_and_primary_therapy_phase_of_hepatoblastoma')
        self.controlled_phase_of_hepatoblastoma = kwargs.get('controlled_phase_of_hepatoblastoma')
        self.metastatic_phase_of_hepatoblastoma = kwargs.get('metastatic_phase_of_hepatoblastoma')
        self.terminal_phase_of_hepatoblastoma = kwargs.get('terminal_phase_of_hepatoblastoma')
        self.diagnosis_and_primary_therapy_phase_of_retinoblastoma = kwargs.get('diagnosis_and_primary_therapy_phase_of_retinoblastoma')
        self.controlled_phase_of_retinoblastoma = kwargs.get('controlled_phase_of_retinoblastoma')
        self.metastatic_phase_of_retinoblastoma = kwargs.get('metastatic_phase_of_retinoblastoma')
        self.terminal_phase_of_retinoblastoma = kwargs.get('terminal_phase_of_retinoblastoma')
        self.diagnosis_and_primary_therapy_phase_of_other_eye_cancers = kwargs.get('diagnosis_and_primary_therapy_phase_of_other_eye_cancers')
        self.controlled_phase_of_other_eye_cancers = kwargs.get('controlled_phase_of_other_eye_cancers')
        self.metastatic_phase_of_other_eye_cancers = kwargs.get('metastatic_phase_of_other_eye_cancers')
        self.terminal_phase_of_other_eye_cancers = kwargs.get('terminal_phase_of_other_eye_cancers')
        self.diagnosis_and_primary_therapy_phase_of_soft_tissue_and_other_extraosseous_sarcomas = kwargs.get('diagnosis_and_primary_therapy_phase_of_soft_tissue_and_other_extraosseous_sarcomas')
        self.controlled_phase_of_soft_tissue_and_other_extraosseous_sarcomas = kwargs.get('controlled_phase_of_soft_tissue_and_other_extraosseous_sarcomas')
        self.metastatic_phase_of_soft_tissue_and_other_extraosseous_sarcomas = kwargs.get('metastatic_phase_of_soft_tissue_and_other_extraosseous_sarcomas')
        self.terminal_phase_of_soft_tissue_and_other_extraosseous_sarcomas = kwargs.get('terminal_phase_of_soft_tissue_and_other_extraosseous_sarcomas')
        self.diagnosis_and_primary_therapy_phase_of_malignant_bone_tumors = kwargs.get('diagnosis_and_primary_therapy_phase_of_malignant_bone_tumors')
        self.controlled_phase_of_malignant_bone_tumors = kwargs.get('controlled_phase_of_malignant_bone_tumors')
        self.metastatic_phase_of_malignant_bone_tumors = kwargs.get('metastatic_phase_of_malignant_bone_tumors')
        self.terminal_phase_of_malignant_bone_tumors = kwargs.get('terminal_phase_of_malignant_bone_tumors')
        self.diagnosis_and_primary_therapy_phase_of_neuroblastoma_and_other_peripheral_nervous_cell_tumors = kwargs.get('diagnosis_and_primary_therapy_phase_of_neuroblastoma_and_other_peripheral_nervous_cell_tumors')
        self.controlled_phase_of_neuroblastoma_and_other_peripheral_nervous_cell_tumors = kwargs.get('controlled_phase_of_neuroblastoma_and_other_peripheral_nervous_cell_tumors')
        self.metastatic_phase_of_neuroblastoma_and_other_peripheral_nervous_cell_tumors = kwargs.get('metastatic_phase_of_neuroblastoma_and_other_peripheral_nervous_cell_tumors')
        self.terminal_phase_of_neuroblastoma_and_other_peripheral_nervous_cell_tumors = kwargs.get('terminal_phase_of_neuroblastoma_and_other_peripheral_nervous_cell_tumors')
        self.controlled_medically_managed_heart_failure_due_to_pulmonary_arterial_hypertension = kwargs.get('controlled_medically_managed_heart_failure_due_to_pulmonary_arterial_hypertension')
        self.mild_heart_failure_due_to_pulmonary_arterial_hypertension = kwargs.get('mild_heart_failure_due_to_pulmonary_arterial_hypertension')
        self.moderate_heart_failure_due_to_pulmonary_arterial_hypertension = kwargs.get('moderate_heart_failure_due_to_pulmonary_arterial_hypertension')
        self.severe_heart_failure_due_to_pulmonary_arterial_hypertension = kwargs.get('severe_heart_failure_due_to_pulmonary_arterial_hypertension')
        self.end_stage_renal_disease_on_dialysis_and_mild_anemia_due_to_type_1_diabetes_mellitus = kwargs.get('end_stage_renal_disease_on_dialysis_and_mild_anemia_due_to_type_1_diabetes_mellitus')
        self.end_stage_renal_disease_on_dialysis_and_mild_anemia_due_to_type_2_diabetes_mellitus = kwargs.get('end_stage_renal_disease_on_dialysis_and_mild_anemia_due_to_type_2_diabetes_mellitus')
        self.end_stage_renal_disease_on_dialysis_and_mild_anemia_due_to_hypertension = kwargs.get('end_stage_renal_disease_on_dialysis_and_mild_anemia_due_to_hypertension')
        self.end_stage_renal_disease_on_dialysis_and_mild_anemia_due_to_glomerulonephritis = kwargs.get('end_stage_renal_disease_on_dialysis_and_mild_anemia_due_to_glomerulonephritis')
        self.end_stage_renal_disease_on_dialysis_and_mild_anemia_due_to_other_and_unspecified_causes = kwargs.get('end_stage_renal_disease_on_dialysis_and_mild_anemia_due_to_other_and_unspecified_causes')
        self.end_stage_renal_disease_on_dialysis_and_moderate_anemia_due_to_type_1_diabetes_mellitus = kwargs.get('end_stage_renal_disease_on_dialysis_and_moderate_anemia_due_to_type_1_diabetes_mellitus')
        self.end_stage_renal_disease_on_dialysis_and_moderate_anemia_due_to_type_2_diabetes_mellitus = kwargs.get('end_stage_renal_disease_on_dialysis_and_moderate_anemia_due_to_type_2_diabetes_mellitus')
        self.end_stage_renal_disease_on_dialysis_and_moderate_anemia_due_to_hypertension = kwargs.get('end_stage_renal_disease_on_dialysis_and_moderate_anemia_due_to_hypertension')
        self.end_stage_renal_disease_on_dialysis_and_moderate_anemia_due_to_glomerulonephritis = kwargs.get('end_stage_renal_disease_on_dialysis_and_moderate_anemia_due_to_glomerulonephritis')
        self.end_stage_renal_disease_on_dialysis_and_moderate_anemia_due_to_other_and_unspecified_causes = kwargs.get('end_stage_renal_disease_on_dialysis_and_moderate_anemia_due_to_other_and_unspecified_causes')
        self.end_stage_renal_disease_on_dialysis_and_severe_anemia_due_to_type_1_diabetes_mellitus = kwargs.get('end_stage_renal_disease_on_dialysis_and_severe_anemia_due_to_type_1_diabetes_mellitus')
        self.end_stage_renal_disease_on_dialysis_and_severe_anemia_due_to_type_2_diabetes_mellitus = kwargs.get('end_stage_renal_disease_on_dialysis_and_severe_anemia_due_to_type_2_diabetes_mellitus')
        self.end_stage_renal_disease_on_dialysis_and_severe_anemia_due_to_hypertension = kwargs.get('end_stage_renal_disease_on_dialysis_and_severe_anemia_due_to_hypertension')
        self.end_stage_renal_disease_on_dialysis_and_severe_anemia_due_to_glomerulonephritis = kwargs.get('end_stage_renal_disease_on_dialysis_and_severe_anemia_due_to_glomerulonephritis')
        self.end_stage_renal_disease_on_dialysis_and_severe_anemia_due_to_other_and_unspecified_causes = kwargs.get('end_stage_renal_disease_on_dialysis_and_severe_anemia_due_to_other_and_unspecified_causes')
        self.end_stage_renal_disease_on_dialysis_without_anemia_due_to_type_1_diabetes_mellitus = kwargs.get('end_stage_renal_disease_on_dialysis_without_anemia_due_to_type_1_diabetes_mellitus')
        self.end_stage_renal_disease_on_dialysis_without_anemia_due_to_type_2_diabetes_mellitus = kwargs.get('end_stage_renal_disease_on_dialysis_without_anemia_due_to_type_2_diabetes_mellitus')
        self.end_stage_renal_disease_on_dialysis_without_anemia_due_to_hypertension = kwargs.get('end_stage_renal_disease_on_dialysis_without_anemia_due_to_hypertension')
        self.end_stage_renal_disease_on_dialysis_without_anemia_due_to_glomerulonephritis = kwargs.get('end_stage_renal_disease_on_dialysis_without_anemia_due_to_glomerulonephritis')
        self.end_stage_renal_disease_on_dialysis_without_anemia_due_to_other_and_unspecified_causes = kwargs.get('end_stage_renal_disease_on_dialysis_without_anemia_due_to_other_and_unspecified_causes')
        self.cirrhosis_and_other_chronic_liver_diseases_due_to_hepatitis_b_decompensated_without_anemia = kwargs.get('cirrhosis_and_other_chronic_liver_diseases_due_to_hepatitis_b_decompensated_without_anemia')
        self.cirrhosis_and_other_chronic_liver_diseases_due_to_hepatitis_b_decompensated_with_mild_anemia = kwargs.get('cirrhosis_and_other_chronic_liver_diseases_due_to_hepatitis_b_decompensated_with_mild_anemia')
        self.cirrhosis_and_other_chronic_liver_diseases_due_to_hepatitis_b_decompensated_with_moderate_anemia = kwargs.get('cirrhosis_and_other_chronic_liver_diseases_due_to_hepatitis_b_decompensated_with_moderate_anemia')
        self.cirrhosis_and_other_chronic_liver_diseases_due_to_hepatitis_b_decompensated_with_severe_anemia = kwargs.get('cirrhosis_and_other_chronic_liver_diseases_due_to_hepatitis_b_decompensated_with_severe_anemia')
        self.cirrhosis_and_other_chronic_liver_diseases_due_to_hepatitis_c_decompensated_with_no_anemia = kwargs.get('cirrhosis_and_other_chronic_liver_diseases_due_to_hepatitis_c_decompensated_with_no_anemia')
        self.cirrhosis_and_other_chronic_liver_diseases_due_to_hepatitis_c_decompensated_with_mild_anemia = kwargs.get('cirrhosis_and_other_chronic_liver_diseases_due_to_hepatitis_c_decompensated_with_mild_anemia')
        self.cirrhosis_and_other_chronic_liver_diseases_due_to_hepatitis_c_decompensated_with_moderate_anemia = kwargs.get('cirrhosis_and_other_chronic_liver_diseases_due_to_hepatitis_c_decompensated_with_moderate_anemia')
        self.cirrhosis_and_other_chronic_liver_diseases_due_to_hepatitis_c_decompensated_with_severe_anemia = kwargs.get('cirrhosis_and_other_chronic_liver_diseases_due_to_hepatitis_c_decompensated_with_severe_anemia')
        self.cirrhosis_and_other_chronic_liver_diseases_due_to_alcohol_decompensated_without_anemia = kwargs.get('cirrhosis_and_other_chronic_liver_diseases_due_to_alcohol_decompensated_without_anemia')
        self.cirrhosis_and_other_chronic_liver_diseases_due_to_alcohol_decompensated_with_mild_anemia = kwargs.get('cirrhosis_and_other_chronic_liver_diseases_due_to_alcohol_decompensated_with_mild_anemia')
        self.cirrhosis_and_other_chronic_liver_diseases_due_to_alcohol_decompensated_with_moderate_anemia = kwargs.get('cirrhosis_and_other_chronic_liver_diseases_due_to_alcohol_decompensated_with_moderate_anemia')
        self.cirrhosis_and_other_chronic_liver_diseases_due_to_alcohol_decompensated_with_severe_anemia = kwargs.get('cirrhosis_and_other_chronic_liver_diseases_due_to_alcohol_decompensated_with_severe_anemia')
        self.cirrhosis_and_other_chronic_liver_diseases_due_to_other_decompensated_with_no_anemia = kwargs.get('cirrhosis_and_other_chronic_liver_diseases_due_to_other_decompensated_with_no_anemia')
        self.cirrhosis_and_other_chronic_liver_diseases_due_to_other_decompensated_with_mild_anemia = kwargs.get('cirrhosis_and_other_chronic_liver_diseases_due_to_other_decompensated_with_mild_anemia')
        self.cirrhosis_and_other_chronic_liver_diseases_due_to_other_decompensated_with_moderate_anemia = kwargs.get('cirrhosis_and_other_chronic_liver_diseases_due_to_other_decompensated_with_moderate_anemia')
        self.cirrhosis_and_other_chronic_liver_diseases_due_to_other_decompensated_with_severe_anemia = kwargs.get('cirrhosis_and_other_chronic_liver_diseases_due_to_other_decompensated_with_severe_anemia')
        self.cirrhosis_and_other_chronic_liver_diseases_due_to_nash_decompensated_with_no_anemia = kwargs.get('cirrhosis_and_other_chronic_liver_diseases_due_to_nash_decompensated_with_no_anemia')
        self.cirrhosis_and_other_chronic_liver_diseases_due_to_nash_decompensated_with_mild_anemia = kwargs.get('cirrhosis_and_other_chronic_liver_diseases_due_to_nash_decompensated_with_mild_anemia')
        self.cirrhosis_and_other_chronic_liver_diseases_due_to_nash_decompensated_with_moderate_anemia = kwargs.get('cirrhosis_and_other_chronic_liver_diseases_due_to_nash_decompensated_with_moderate_anemia')
        self.cirrhosis_and_other_chronic_liver_diseases_due_to_nash_decompensated_with_severe_anemia = kwargs.get('cirrhosis_and_other_chronic_liver_diseases_due_to_nash_decompensated_with_severe_anemia')
        self.asymptomatic_symptomatic_inguinal_femoral_and_abdominal_hernia = kwargs.get('asymptomatic_symptomatic_inguinal_femoral_and_abdominal_hernia')
        self.asymptomatic_osteoarthritis_of_the_hand_and_foot = kwargs.get('asymptomatic_osteoarthritis_of_the_hand_and_foot')
        self.asymptomatic_osteoarthritis_other = kwargs.get('asymptomatic_osteoarthritis_other')
        self.symptomatic_probable_tension_type_headache = kwargs.get('symptomatic_probable_tension_type_headache')
        self.asymptomatic_probable_tension_type_headache = kwargs.get('asymptomatic_probable_tension_type_headache')
        self.symptomatic_definite_tension_type_headache = kwargs.get('symptomatic_definite_tension_type_headache')
        self.asymptomatic_definite_tension_type_headache = kwargs.get('asymptomatic_definite_tension_type_headache')
        self.other_combined_sequelae_of_homozygous_sickle_cell_and_severe_sickle_cell_beta_thalassemia = kwargs.get('other_combined_sequelae_of_homozygous_sickle_cell_and_severe_sickle_cell_beta_thalassemia')
        self.other_combined_sequelae_of_hemoglobin_sc_disease = kwargs.get('other_combined_sequelae_of_hemoglobin_sc_disease')
        self.other_combined_sequelae_of_mild_sickle_cell_beta_thalassemia_exclusivity_adjustment = kwargs.get('other_combined_sequelae_of_mild_sickle_cell_beta_thalassemia_exclusivity_adjustment')
