import { App } from 'cdk8s';
import { Construct } from 'constructs';
/**
 * The handler for this custom resource provider.
 */
export interface ICustomResourceProviderHandler {
    apply(scope: Construct, id: string, spec: any): Construct;
}
export interface CustomResourceProvider {
    /**
     * Kind of this custom resource.
     */
    readonly kind: string;
    /**
     * API version of the custom resource.
     *
     * @default "v1"
     */
    readonly apiVersion: string;
    /**
     * The construct handler.
     */
    readonly handler: ICustomResourceProviderHandler;
}
export interface OperatorProps {
    /**
     * A Kubernetes JSON manifest with a single resource that is matched against
     * one of the providers within this operator.
     *
     * @default - first position command-line argument or "/dev/stdin"
     */
    readonly inputFile?: string;
    /**
     * Where to write the synthesized output.
     *
     * @default "/dev/stdout"
     */
    readonly outputFile?: string;
}
/**
 * A CDK8s app which allows implementing Kubernetes operators using CDK8s constructs.
 */
export declare class Operator extends App {
    private readonly inputFile;
    private readonly outputFile?;
    private readonly providers;
    constructor(props?: OperatorProps);
    /**
     * Adds a custom resource provider to this operator.
     * @param provider The provider to add
     */
    addProvider(provider: CustomResourceProvider): void;
    /**
     * Reads a Kubernetes manifest in JSON format from STDIN or the file specified
     * as the first positional command-line argument. This manifest is expected to
     * include a single Kubernetes resource. Then, we match `apiVersion` and
     * `kind` to one of the registered providers and if we do, we invoke
     * `apply()`, passing it the `spec` of the input manifest and a chart as a
     * scope. The chart is then synthesized and the output manifest is written to
     * STDOUT.
     */
    synth(): void;
    private findProvider;
}
