#!/usr/bin/python

from .caesar import Caesar
import secretpy.alphabets as al


class Rot5:
    """
    The Rot5 Cipher
    """
    __caesar = Caesar()

    def encrypt(self, text, key=None, alphabet=None):
        """
        Encryption method

        :param text: Text to encrypt
        :param key: Encryption key
        :param alphabet: Alphabet which will be used,
                         if there is no a value, English is used
        :type text: string
        :type key: integer
        :type alphabet: string
        :return: text
        :rtype: string
        """
        return self.__caesar.encrypt(text, 5, al.DECIMAL)

    def decrypt(self, text, key=None, alphabet=None):
        """
        Decryption method

        :param text: Text to decrypt
        :param key: Decryption key
        :param alphabet: Alphabet which will be used,
                         if there is no a value, English is used
        :type text: string
        :type key: integer
        :type alphabet: string
        :return: text
        :rtype: string
        """
        return self.__caesar.encrypt(text, 5, al.DECIMAL)

    def get_fixed_alphabet(self):
        return al.DECIMAL
