# This file is part of tad-dftd4.
#
# SPDX-Identifier: LGPL-3.0
# Copyright (C) 2022 Marvin Friede
#
# tad-dftd4 is free software: you can redistribute it and/or modify it under
# the terms of the GNU Lesser General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# tad-dftd4 is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public License
# along with tad-dftd4. If not, see <https://www.gnu.org/licenses/>.
"""
Data for testing D4 coordination number (taken from D4 testsuite).
"""
from __future__ import annotations

import torch

from tad_dftd4._typing import Molecule, Tensor, TypedDict

from ..molecules import merge_nested_dicts, mols


class Refs(TypedDict):
    """Format of reference values."""

    disp: Tensor
    """Atom-resolved full dispersion energy"""

    disp2: Tensor
    """Atom-resolved two-body dispersion energy"""

    disp3: Tensor
    """Atom-resolved ATM dispersion energy"""


class Record(Molecule, Refs):
    """Store for molecular information and reference values."""


refs: dict[str, Refs] = {
    "LiH": {
        "disp": torch.tensor(
            [
                -2.5509356117699210e-04,
                -2.5509356117699210e-04,
            ],
            dtype=torch.double,
        ),
        "disp2": torch.tensor(
            [
                -2.5509356117699210e-04,
                -2.5509356117699210e-04,
            ],
            dtype=torch.double,
        ),
        "disp3": torch.tensor(
            [
                +0.0000000000000000e00,
                +0.0000000000000000e00,
            ],
            dtype=torch.double,
        ),
    },
    "SiH4": {
        "disp": torch.tensor(
            [
                -7.3576779675529251e-04,
                -2.9018353739054548e-04,
                -2.9018353739054548e-04,
                -2.9018353739054548e-04,
                -2.9018353739054548e-04,
            ],
            dtype=torch.double,
        ),
        "disp2": torch.tensor(
            [
                -7.3576887054011008e-04,
                -2.9019661352652499e-04,
                -2.9019661352652499e-04,
                -2.9019661352652499e-04,
                -2.9019661352652499e-04,
            ],
            dtype=torch.double,
        ),
        "disp3": torch.tensor(
            [
                +1.0737848175727815e-09,
                +1.3076135979507488e-08,
                +1.3076135979507488e-08,
                +1.3076135979507488e-08,
                +1.3076135979507488e-08,
            ],
            dtype=torch.double,
        ),
    },
    "MB16_43_01": {
        "disp": torch.tensor(
            [
                -1.5948923458780405e-03,
                -4.3009226023566692e-04,
                -1.2204275297280716e-03,
                -5.9217495625634407e-04,
                -9.7864757361015940e-04,
                -4.0387576379090356e-04,
                -7.6357921697888106e-04,
                -1.5369807766040921e-03,
                -2.4230888962675709e-03,
                -2.7946009443035794e-04,
                -3.7943641770640303e-04,
                -2.7621678318318983e-03,
                -1.9767296147143059e-03,
                -1.8079430824138340e-03,
                -2.2044616756734638e-03,
                -3.3564696718858564e-03,
            ],
            dtype=torch.double,
        ),
        "disp2": torch.tensor(
            [
                -1.5978589147675343e-03,
                -4.3087736648956209e-04,
                -1.2245064465596241e-03,
                -5.9462439803399962e-04,
                -9.7987253141476019e-04,
                -4.0651634267966285e-04,
                -7.6550170877790055e-04,
                -1.5420673484584780e-03,
                -2.4237393242014290e-03,
                -2.8248239127451303e-04,
                -3.8157589397311607e-04,
                -2.7686217642163909e-03,
                -1.9799965057999240e-03,
                -1.8115981482957710e-03,
                -2.2079138476736051e-03,
                -3.3570468419725774e-03,
            ],
            dtype=torch.double,
        ),
        "disp3": torch.tensor(
            [
                +2.9665688894937522e-06,
                +7.8510625389516817e-07,
                +4.0789168315525422e-06,
                +2.4494417776555442e-06,
                +1.2249578046007962e-06,
                +2.6405788887592908e-06,
                +1.9224917990194905e-06,
                +5.0865718543859594e-06,
                +6.5042793385809705e-07,
                +3.0222968441550907e-06,
                +2.1394762667130396e-06,
                +6.4539323844925445e-06,
                +3.2668910856180865e-06,
                +3.6550658819370363e-06,
                +3.4521720001412688e-06,
                +5.7717008672105233e-07,
            ],
            dtype=torch.double,
        ),
    },
    "MB16_43_02": {
        "disp": torch.tensor(
            [
                -6.5351866032916923e-04,
                -4.2277359090176188e-03,
                -2.6506653907401984e-03,
                -1.9288040417832645e-03,
                -2.4606388775668922e-03,
                -4.6635764405510068e-04,
                -5.5025434227611741e-04,
                -5.4043047672928241e-04,
                -3.9231507025866783e-03,
                -5.0976580417290245e-04,
                -2.5657903795437888e-03,
                -7.3449130469025663e-04,
                -1.1508896960101620e-03,
                -5.6354545617317577e-04,
                -8.1864401009594111e-04,
                -3.6642920946537562e-03,
            ],
            dtype=torch.double,
        ),
        "disp2": torch.tensor(
            [
                -6.5662007951545077e-04,
                -4.2332279913520933e-03,
                -2.6545483454024320e-03,
                -1.9334100439492260e-03,
                -2.4635064851083895e-03,
                -4.6933771526446621e-04,
                -5.5338594488015501e-04,
                -5.4337570594438728e-04,
                -3.9267858764318476e-03,
                -5.1250599988761792e-04,
                -2.5690462058174648e-03,
                -7.3602401553507708e-04,
                -1.1560325931820779e-03,
                -5.6678007558992865e-04,
                -8.2037588198600846e-04,
                -3.6730444664360767e-03,
            ],
            dtype=torch.double,
        ),
        "disp3": torch.tensor(
            [
                +3.1014191862815347e-06,
                +5.4920823344744782e-06,
                +3.8829546622335710e-06,
                +4.6060021659615185e-06,
                +2.8676075414972926e-06,
                +2.9800712093655275e-06,
                +3.1316026040376001e-06,
                +2.9452292151048703e-06,
                +3.6351738451692595e-06,
                +2.7401957147154751e-06,
                +3.2558262736759672e-06,
                +1.5327108448204502e-06,
                +5.1428971719158327e-06,
                +3.2346194167528781e-06,
                +1.7318718900673474e-06,
                +8.7523717823205331e-06,
            ],
            dtype=torch.double,
        ),
    },
    "vancoh2": {
        "disp": torch.tensor(
            [
                -1.1541495746800860e-03,
                -4.2252061121602772e-03,
                -4.0749206772128822e-03,
                -4.0829860800412794e-03,
                -3.8632409645664107e-03,
                -3.5436742086934966e-03,
                -3.7580767452530485e-03,
                -3.4362939324759779e-03,
                -4.5997757319171575e-03,
                -5.4662231363589095e-03,
                -5.2091638009658693e-03,
                -5.2944816012540970e-03,
                -4.5291528686820272e-03,
                -4.5169797795923819e-03,
                -3.8673794239558012e-03,
                -3.9707504274663925e-03,
                -1.2063995661432047e-03,
                -4.1228431025676585e-03,
                -1.2822033584506632e-03,
                -3.8098926382820575e-03,
                -3.1909096669433330e-03,
                -2.9841872765367971e-03,
                -7.3870349987531839e-04,
                -7.3613323117175777e-04,
                -2.8528353057504395e-03,
                -2.5571751456230068e-03,
                -4.0343678006693598e-04,
                -4.0962933401119734e-04,
                -2.9473403079043432e-03,
                -9.8603952613651237e-04,
                -5.8708875283404439e-04,
                -7.6157206444836534e-04,
                -3.3786004545704128e-03,
                -3.0862457450028906e-03,
                -6.2722546920363571e-04,
                -1.0255015769422818e-03,
                -4.0350676222667275e-03,
                -4.4560778825859628e-03,
                -1.0454262470156555e-03,
                -1.2600053084747798e-03,
                -1.1975252614740178e-03,
                -1.4740456684620498e-03,
                -3.4771121291144319e-03,
                -7.6336001348272181e-04,
                -3.1062331759254326e-03,
                -7.4482993181464543e-04,
                -2.8197415185878777e-03,
                -6.7747767568229105e-04,
                -2.6485994347541877e-03,
                -2.1461126565206915e-03,
                -5.3179146257552692e-04,
                -6.5691220047449166e-04,
                -2.7494267927247436e-03,
                -2.2808927179640112e-03,
                -1.6172362192000936e-03,
                -4.2673767666409797e-04,
                -5.2493423281555797e-04,
                -7.7399287537984059e-04,
                -3.1519833364024564e-03,
                -6.3783460184422495e-04,
                -3.4503314862699085e-03,
                -3.4979942247705125e-03,
                -3.2352155208503412e-03,
                -3.3253232999214924e-03,
                -3.7287163180794295e-03,
                -3.7462938317040723e-03,
                -3.6217044347789718e-03,
                -8.2483275637655357e-04,
                -7.9843135643570967e-04,
                -2.8523552299580483e-03,
                -2.1420100411405131e-03,
                -4.6494111601174288e-04,
                -7.1496273216473084e-04,
                -3.4384481270274213e-03,
                -4.9409566866322422e-03,
                -3.6103663993794018e-03,
                -2.8450315175570641e-03,
                -3.5647068889961440e-03,
                -5.1003310462745212e-03,
                -6.0754426701536846e-03,
                -5.3584479400781270e-03,
                -4.0344616939171568e-03,
                -3.7523643355392854e-03,
                -4.2408645794858070e-03,
                -8.1915806731989104e-04,
                -6.7939530272354508e-04,
                -2.6737122311910212e-03,
                -5.8173431199592994e-04,
                -4.9589977779977788e-03,
                -4.5124798656031593e-03,
                -3.4138645793605586e-03,
                -2.5430230480116339e-03,
                -3.1806089438969425e-03,
                -3.9173187656722083e-03,
                -3.4037707313367255e-03,
                -7.1442645325482082e-04,
                -6.7044425889585221e-04,
                -1.4857673866386786e-03,
                -3.0104340831283577e-04,
                -7.0763620306893145e-04,
                -3.5002493675683611e-03,
                -4.8496231305152843e-03,
                -3.8604365372122908e-03,
                -3.3204680847128743e-03,
                -7.7333519336620770e-04,
                -3.1359847254217011e-03,
                -2.5590274986683715e-03,
                -2.6666715352539503e-03,
                -3.9057862639033884e-04,
                -8.3474449561480679e-04,
                -1.4900032542550041e-03,
                -4.2676913902594113e-03,
                -3.8147467232258958e-03,
                -3.2639238706708351e-03,
                -4.4757374591332996e-03,
                -5.6054724959550958e-03,
                -4.4115132987377799e-03,
                -4.4598205164362434e-03,
                -3.5390743918569155e-03,
                -5.0628445356817068e-03,
                -3.5696743473316865e-03,
                -2.4709317646832455e-03,
                -3.4964989152735447e-03,
                -5.2173038965010448e-03,
                -3.6761126881010688e-03,
                -2.9066236637152782e-03,
                -3.2048128833630000e-03,
                -3.3987257517959796e-03,
                -1.9590540621411208e-03,
                -4.9273955098393292e-04,
                -4.2073537610307191e-04,
                -6.1379609829155318e-04,
                -6.8889634695349354e-04,
                -3.9539221496771243e-03,
                -1.2314441877940270e-03,
                -1.2495105910242524e-03,
                -2.6414537384090758e-03,
                -2.2832646758910217e-03,
                -6.4088535548496135e-04,
                -4.8265489388371391e-04,
                -6.6331467399340040e-04,
                -2.6129150521731676e-03,
                -8.6810572074384762e-04,
                -5.1059420256306036e-04,
                -7.7633057490323243e-04,
                -6.9156347800107196e-04,
                -8.3344791934069880e-04,
                -9.5249329025498346e-04,
                -8.0559776795853478e-04,
                -3.0752830031804189e-03,
                -2.2809574715988261e-03,
                -4.8621213166574962e-04,
                -7.6696657222513588e-04,
                -1.1056117169966550e-03,
                -3.3775744008670834e-03,
                -3.0946879033118685e-03,
                -3.9077894639707664e-03,
                -2.2823152780972814e-03,
                -3.1805287171060993e-04,
                -3.3516871475942829e-04,
                -1.0312901065051994e-03,
                -7.6056253132250130e-04,
                -8.3439802984305053e-04,
                -9.2483048132079655e-04,
                -1.4532065983103375e-03,
                -5.6354283387465942e-04,
                -8.3763824433559671e-04,
                -1.0281411929963452e-03,
                -8.2285823183678890e-04,
                -6.7055876280141429e-04,
                -6.5581500941418376e-04,
                -1.3845569984251396e-03,
                -1.4282025602773492e-03,
                -6.9587107526766843e-04,
                -8.1446612684752968e-04,
                -8.7724972102449562e-04,
            ],
            dtype=torch.double,
        ),
        "disp2": torch.tensor(
            [
                -1.2052656580585840e-03,
                -4.3449264441342049e-03,
                -4.1682808470235085e-03,
                -4.1482033986213465e-03,
                -3.9282896683895925e-03,
                -3.6211524190806112e-03,
                -3.8630752002367249e-03,
                -3.5122759980921376e-03,
                -4.7149675022717637e-03,
                -5.6077241815018983e-03,
                -5.3671802475730177e-03,
                -5.4275348070603651e-03,
                -4.6339549108192057e-03,
                -4.6101131239979914e-03,
                -3.9130073286529057e-03,
                -4.0222002950205645e-03,
                -1.2423034245767819e-03,
                -4.1728253517219543e-03,
                -1.3121591785524372e-03,
                -3.8611429667992987e-03,
                -3.2481382024114763e-03,
                -3.0241921764317401e-03,
                -7.4972323537164925e-04,
                -7.5140304580669632e-04,
                -2.8938975867956328e-03,
                -2.5771408974924739e-03,
                -4.1588584183418174e-04,
                -4.1855323864944353e-04,
                -3.0053770382594772e-03,
                -1.0210776371417424e-03,
                -6.0084582760298703e-04,
                -7.8953410207122825e-04,
                -3.4425490946933504e-03,
                -3.1212237533610079e-03,
                -6.5176050467545619e-04,
                -1.0627797379646131e-03,
                -4.1247175069287810e-03,
                -4.5904243854626402e-03,
                -1.0966993059523854e-03,
                -1.3340012504515970e-03,
                -1.2612184349922622e-03,
                -1.5161530970921153e-03,
                -3.5436086989504029e-03,
                -7.8915342537132812e-04,
                -3.1436124831288105e-03,
                -7.6482523627524103e-04,
                -2.8580920778251530e-03,
                -6.9779172581269349e-04,
                -2.6688439340917121e-03,
                -2.1659453065919652e-03,
                -5.4612911203165621e-04,
                -6.5940698307470321e-04,
                -2.7715087511696488e-03,
                -2.2995912700857143e-03,
                -1.6345947239123487e-03,
                -4.3763511112566533e-04,
                -5.2444582496249449e-04,
                -7.8666256718918108e-04,
                -3.1811446374268456e-03,
                -6.4449558817968272e-04,
                -3.5097275482364517e-03,
                -3.5871114442385518e-03,
                -3.3067170418129665e-03,
                -3.3843476119952021e-03,
                -3.7938613411796730e-03,
                -3.8377718454288665e-03,
                -3.7283654722037162e-03,
                -8.7336674339256602e-04,
                -8.3704931404297595e-04,
                -2.8913000264608108e-03,
                -2.1589147310974873e-03,
                -4.8034321528576143e-04,
                -7.2562516593219098e-04,
                -3.4988663828093135e-03,
                -5.0175241126730963e-03,
                -3.6954875111263369e-03,
                -2.8908479847434931e-03,
                -3.6580779925366189e-03,
                -5.2151710261977742e-03,
                -6.1965647076918850e-03,
                -5.4616432708581974e-03,
                -4.1198671212478704e-03,
                -3.8369855058921925e-03,
                -4.3384988042262087e-03,
                -8.5206879853686759e-04,
                -7.0078294810413497e-04,
                -2.7224690845572960e-03,
                -6.0710640810233323e-04,
                -5.0533201672385017e-03,
                -4.5865399754534547e-03,
                -3.4703158421377713e-03,
                -2.5889530835592994e-03,
                -3.2397158454416275e-03,
                -4.0053984243950975e-03,
                -3.4744176112432206e-03,
                -7.5822278095152265e-04,
                -6.8704666200925760e-04,
                -1.4970119621738626e-03,
                -3.0353412116605028e-04,
                -7.2015310544028212e-04,
                -3.5605962345221804e-03,
                -4.9237153675289113e-03,
                -3.9479415825864166e-03,
                -3.3837986111128933e-03,
                -8.0470203478039820e-04,
                -3.1929722207564692e-03,
                -2.5941506297992335e-03,
                -2.7085073785585354e-03,
                -4.0792510852876454e-04,
                -8.5280792343547318e-04,
                -1.5480746569925725e-03,
                -4.3610074755360030e-03,
                -3.9427882235188822e-03,
                -3.3496013271943378e-03,
                -4.6192473356542509e-03,
                -5.7409785892446226e-03,
                -4.5469851542991203e-03,
                -4.5649021274032789e-03,
                -3.6288319231440542e-03,
                -5.1400011923017005e-03,
                -3.6310545561831697e-03,
                -2.5054422399119242e-03,
                -3.5536505782813150e-03,
                -5.2875745916442967e-03,
                -3.7474946131059511e-03,
                -2.9431975340368367e-03,
                -3.2691329108685621e-03,
                -3.4480357140052758e-03,
                -1.9843331869492001e-03,
                -4.9709317315962259e-04,
                -4.3060707389451600e-04,
                -6.3128002864550970e-04,
                -7.1922617231041691e-04,
                -4.0300698155360517e-03,
                -1.2725543551195902e-03,
                -1.2902653111403642e-03,
                -2.6983607022533825e-03,
                -2.3214691528321237e-03,
                -6.5441080254096621e-04,
                -4.8811518177733018e-04,
                -6.8566478326901670e-04,
                -2.6736403624623901e-03,
                -8.9845538836654383e-04,
                -5.2673263076682898e-04,
                -8.1014654897187781e-04,
                -7.0545183077257655e-04,
                -8.4943242573558948e-04,
                -9.9051330363105362e-04,
                -8.2233280984485096e-04,
                -3.1185370430237475e-03,
                -2.2985203399560673e-03,
                -5.0242247708491962e-04,
                -7.8441023603852968e-04,
                -1.1475986663111888e-03,
                -3.4395367261187506e-03,
                -3.1728848464280201e-03,
                -3.9917344542265568e-03,
                -2.3204488533982389e-03,
                -3.3616099820379713e-04,
                -3.4556782501106870e-04,
                -1.0519159825991024e-03,
                -7.7772800809377694e-04,
                -8.7256395441260941e-04,
                -9.7894098893856600e-04,
                -1.5140919677569316e-03,
                -5.9523573694480667e-04,
                -8.6876677439274013e-04,
                -1.0635382877847064e-03,
                -8.3942609144147722e-04,
                -6.8798555088330231e-04,
                -6.8073091731230885e-04,
                -1.4330945834754108e-03,
                -1.4832408890375209e-03,
                -7.2483632867772802e-04,
                -8.3197180562823365e-04,
                -9.1802975857506008e-04,
            ],
            dtype=torch.double,
        ),
        "disp3": torch.tensor(
            [
                +5.1116083378498038e-05,
                +1.1972033197392776e-04,
                +9.3360169810626295e-05,
                +6.5217318580067067e-05,
                +6.5048703823181869e-05,
                +7.7478210387114596e-05,
                +1.0499845498367641e-04,
                +7.5982065616159687e-05,
                +1.1519177035460623e-04,
                +1.4150104514298878e-04,
                +1.5801644660714837e-04,
                +1.3305320580626803e-04,
                +1.0480204213717849e-04,
                +9.3133344405609518e-05,
                +4.5627904697104465e-05,
                +5.1449867554172017e-05,
                +3.5903858433577150e-05,
                +4.9982249154295784e-05,
                +2.9955820101773946e-05,
                +5.1250328517241268e-05,
                +5.7228535468143230e-05,
                +4.0004899894943019e-05,
                +1.1019735496330856e-05,
                +1.5269814634938546e-05,
                +4.1062281045193324e-05,
                +1.9965751869467120e-05,
                +1.2449061767245766e-05,
                +8.9239046382461854e-06,
                +5.8036730355134035e-05,
                +3.5038111005230004e-05,
                +1.3757074768942648e-05,
                +2.7962037622862915e-05,
                +6.3948640122937599e-05,
                +3.4978008358117329e-05,
                +2.4535035471820476e-05,
                +3.7278161022331283e-05,
                +8.9649884662053488e-05,
                +1.3434650287667740e-04,
                +5.1273058936729963e-05,
                +7.3995941976817171e-05,
                +6.3693173518244344e-05,
                +4.2107428630065464e-05,
                +6.6496569835971034e-05,
                +2.5793411888606313e-05,
                +3.7379307203377898e-05,
                +1.9995304460595597e-05,
                +3.8350559237275341e-05,
                +2.0314050130402442e-05,
                +2.0244499337524445e-05,
                +1.9832650071273730e-05,
                +1.4337649456129292e-05,
                +2.4947826002115437e-06,
                +2.2081958444905223e-05,
                +1.8698552121703110e-05,
                +1.7358504712255149e-05,
                +1.0897434461567363e-05,
                -4.8840785306348243e-07,
                +1.2669691809340483e-05,
                +2.9161301024389213e-05,
                +6.6609863354577742e-06,
                +5.9396061966543196e-05,
                +8.9117219468039331e-05,
                +7.1501520962625326e-05,
                +5.9024312073709725e-05,
                +6.5145023100243466e-05,
                +9.1478013724794176e-05,
                +1.0666103742474438e-04,
                +4.8533987016012451e-05,
                +3.8617957607266283e-05,
                +3.8944796502762575e-05,
                +1.6904689956974243e-05,
                +1.5402099274018557e-05,
                +1.0662433767460143e-05,
                +6.0418255781892211e-05,
                +7.6567426040854113e-05,
                +8.5121111746935124e-05,
                +4.5816467186429038e-05,
                +9.3371103540474884e-05,
                +1.1483997992325305e-04,
                +1.2112203753820040e-04,
                +1.0319533078007037e-04,
                +8.5405427330713553e-05,
                +8.4621170352907130e-05,
                +9.7634224740401725e-05,
                +3.2910731216976544e-05,
                +2.1387645380589889e-05,
                +4.8756853366274840e-05,
                +2.5372096106403286e-05,
                +9.4322389240722969e-05,
                +7.4060109850295451e-05,
                +5.6451262777212647e-05,
                +4.5930035547665522e-05,
                +5.9106901544685002e-05,
                +8.8079658722889191e-05,
                +7.0646879906495052e-05,
                +4.3796327696701831e-05,
                +1.6602403113405396e-05,
                +1.1244575535184062e-05,
                +2.4907128532145116e-06,
                +1.2516902371350670e-05,
                +6.0346866953819248e-05,
                +7.4092237013627035e-05,
                +8.7505045374125772e-05,
                +6.3330526400018957e-05,
                +3.1366841414190503e-05,
                +5.6987495334768091e-05,
                +3.5123131130861997e-05,
                +4.1835843304585067e-05,
                +1.7346482138425707e-05,
                +1.8063427820666392e-05,
                +5.8071402737568372e-05,
                +9.3316085276591750e-05,
                +1.2804150029298647e-04,
                +8.5677456523502744e-05,
                +1.4350987652095130e-04,
                +1.3550609328952679e-04,
                +1.3547185556134038e-04,
                +1.0508161096703557e-04,
                +8.9757531287138620e-05,
                +7.7156656619993720e-05,
                +6.1380208851483185e-05,
                +3.4510475228678641e-05,
                +5.7151663007770290e-05,
                +7.0270695143251870e-05,
                +7.1381925004882288e-05,
                +3.6573870321558559e-05,
                +6.4320027505562153e-05,
                +4.9309962209296166e-05,
                +2.5279124808079249e-05,
                +4.3536221756896752e-06,
                +9.8716977914440934e-06,
                +1.7483930353956521e-05,
                +3.0329825356923377e-05,
                +7.6147665858927391e-05,
                +4.1110167325563145e-05,
                +4.0754720116111757e-05,
                +5.6906963844306682e-05,
                +3.8204476941102079e-05,
                +1.3525447056004863e-05,
                +5.4602878936162733e-06,
                +2.2350109275616308e-05,
                +6.0725310289222456e-05,
                +3.0349667622696212e-05,
                +1.6138428203768627e-05,
                +3.3815974068645378e-05,
                +1.3888352771504594e-05,
                +1.5984506394890676e-05,
                +3.8020013376070154e-05,
                +1.6735041886316174e-05,
                +4.3254039843328672e-05,
                +1.7562868357241194e-05,
                +1.6210345419170001e-05,
                +1.7443663813393809e-05,
                +4.1986949314533816e-05,
                +6.1962325251667220e-05,
                +7.8196943116151576e-05,
                +8.3944990255790421e-05,
                +3.8133575300957571e-05,
                +1.8108126493187205e-05,
                +1.0399110251640411e-05,
                +2.0625876093902963e-05,
                +1.7165476771275646e-05,
                +3.8165924569558878e-05,
                +5.4110507617769442e-05,
                +6.0885369446594083e-05,
                +3.1692903070147248e-05,
                +3.1128530057143418e-05,
                +3.5397094788361134e-05,
                +1.6567859604688312e-05,
                +1.7426788081888016e-05,
                +2.4915907898125089e-05,
                +4.8537585050271222e-05,
                +5.5038328760171739e-05,
                +2.8965253410059583e-05,
                +1.7505678780703970e-05,
                +4.0780037550564464e-05,
            ],
            dtype=torch.double,
        ),
    },
}


samples: dict[str, Record] = merge_nested_dicts(mols, refs)
