# This file is part of tad-dftd4.
#
# SPDX-Identifier: LGPL-3.0
# Copyright (C) 2022 Marvin Friede
#
# tad-dftd4 is free software: you can redistribute it and/or modify it under
# the terms of the GNU Lesser General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# tad-dftd4 is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public License
# along with tad-dftd4. If not, see <https://www.gnu.org/licenses/>.
"""
Parameters
==========

This module contains all parameters the computation of the C6 coefficients
(reference systems, reference polarizabilites, ...).
"""
import torch

refcn = torch.tensor(
    [
        [
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            0.89422436546040,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            0.80196797025252,
            4.55700000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            0.87483634146801,
            1.75692293756846,
            8.44900000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            0.93017535174568,
            1.86318070483743,
            2.79150308430417,
            4.41327468359181,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            0.91894761153698,
            1.90786062124811,
            2.83122393221341,
            3.74870030209262,
            2.91832701804388,
            0.85560990866661,
        ],
        [
            0.00000000000000,
            0.85827791612782,
            1.83985112339643,
            2.58039902538908,
            0.98085535554904,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            0.80416789582615,
            1.61123940672270,
            0.97984400975835,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            0.74076991274917,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            0.78077255822701,
            6.00100000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            0.82437946770105,
            1.66972660811953,
            13.95600000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            0.86567622356503,
            1.73262223552501,
            2.61541321571983,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            0.89153537011814,
            1.82343155163634,
            2.80029114356397,
            3.66675219599495,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            0.97498969761258,
            1.95559430261502,
            2.92666412421238,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            0.92198495968462,
            1.84453813661707,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            0.84439969796621,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            0.77389074718844,
            11.45000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            0.80173786145238,
            1.57758711825521,
            15.14000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            1.60644512750973,
            2.50274820582596,
            3.83500003814697,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            1.62278979228613,
            3.43281247525220,
            4.43849000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            1.72211010302514,
            2.62026342999598,
            3.38800000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            1.65041632145300,
            9.59333666980809,
            5.09941611449080,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            1.45861721080984,
            8.78012041793345,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            1.52985788829933,
            8.47495927159456,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            1.60281178943204,
            2.73732238386544,
            7.27710111777824,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            1.68368353980441,
            6.15501721386632,
            5.91752241519496,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            0.89816244646957,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            1.75336283145604,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            0.88820287155353,
            1.78721228422408,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            0.89941149965103,
            1.85525243419195,
            2.78448725734282,
            3.71823460680579,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            0.96810324138508,
            1.93762986034873,
            2.90829444959119,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            0.92195274896170,
            1.84493749809528,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            0.87141367228098,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            0.77155167960451,
            12.39000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            0.79294768050705,
            1.54805734413866,
            15.12100028991699,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            1.61670701598223,
            2.43996146811665,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            1.66263906536582,
            3.35991209283567,
            6.09300000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            1.75136276843804,
            2.61865286219105,
            4.02900000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            1.89510707051732,
            10.77850977361032,
            5.59646145748005,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            1.56460355314490,
            8.94426823783675,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            1.82293327778554,
            8.72336154530085,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            1.84241892648043,
            2.88090049147235,
            4.69798180984017,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            1.82751376419277,
            5.62156480548985,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            0.91215552676727,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            1.77531555102521,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            0.88719377220275,
            1.78495637384615,
            2.70420959057537,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            0.90042437628478,
            1.84687551160093,
            2.77047146659601,
            3.70466711294240,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            0.93580947053485,
            1.87397783659382,
            2.81393944504634,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            0.94900106848812,
            1.89954395376061,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            0.91239969640123,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            0.78131762864252,
            13.94000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            0.78501458609867,
            1.47819220471197,
            14.67700004577637,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            1.60493415835961,
            2.41715875994685,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            2.32446531201143,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            2.44976242184767,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            2.45621204848065,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            2.45653273553474,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            2.45472309204146,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            1.53272635693059,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            2.41754019361739,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            2.45190848719608,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            2.44535641509585,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            2.47312888776754,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            2.48043640078965,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            2.48120800603580,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            2.41884356027485,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            2.48673110207243,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            1.64596625526870,
            3.32095096313483,
            4.62300000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            1.71671961147963,
            2.55699041057149,
            3.96300000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            1.84852525804219,
            10.44998431099169,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            1.69673556648333,
            9.19053013143453,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            1.85014246784508,
            8.97974115543403,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            1.82924504495576,
            2.88910972828218,
            3.78801363268039,
            4.66121308138933,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            1.86072268763509,
            6.46855936294889,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            0.91830179564855,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            1.89515764632510,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            0.83218042800594,
            1.73451304607259,
            2.64455909521743,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            0.90267202371440,
            1.86326667138745,
            2.79951773292937,
            3.76444392234350,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            0.93840398774753,
            1.87829610127455,
            2.81907131341312,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            0.93512916979697,
            1.87110482058901,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            0.97711087656722,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
    ],
    dtype=torch.float64,
)
refq = torch.tensor(
    [
        [
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            0.37061732228445,
            0.50233549783800,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            0.17355187691088,
            0.31121011558254,
            0.34700000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            -0.10464538187607,
            -0.20153708141000,
            -0.28222637549158,
            -0.34038820700000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            -0.17123705791311,
            -0.14210003554128,
            -0.22250854670718,
            -0.25653918216622,
            -0.10441353918078,
            0.21030312690000,
        ],
        [
            0.00000000000000,
            -0.35298592555229,
            -0.30125788296606,
            -0.82429723124422,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            -0.35471470167212,
            -0.59881526060460,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            -0.24773915490000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            0.37895090683878,
            0.54307355286400,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            0.32933884303798,
            0.51074920852765,
            0.34300000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            0.03709152257935,
            0.05079767549293,
            0.05291396110000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            0.01649127941162,
            -0.00640083798505,
            -0.03084420203156,
            -0.06585975730000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            -0.17987135979307,
            -0.12671124139840,
            -0.17467927420000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            -0.16267234588041,
            -0.23775171448800,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            -0.15045057450000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            0.44376242787490,
            0.30400000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            0.31814452979636,
            0.50078886624431,
            0.24400000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            0.50144727255861,
            0.62485373296540,
            0.78700000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            0.32259167829296,
            0.53505953733387,
            0.90400000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            0.30538713298844,
            0.39745931358650,
            0.93500000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            0.17721817570715,
            0.16754955881404,
            0.61467776160000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            0.26888428905691,
            -0.01438794807200,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            0.16108330144470,
            0.05493242513400,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            0.21568151580380,
            0.20590049778110,
            -0.01577894810000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            0.09850839901243,
            0.02948298358915,
            0.02439689310000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            0.05450628880000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            0.25796918840000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            0.02870304944818,
            0.04511416923200,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            0.00938786608492,
            -0.00592798448224,
            -0.03161585463110,
            -0.06445558540000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            -0.09954248086481,
            -0.11896736577051,
            -0.10225384710000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            -0.12327157100582,
            -0.17535803722300,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            -0.14490782120000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            0.44852683448077,
            0.41600000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            0.42643340166796,
            0.64902814271780,
            0.51400000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            0.57618546114280,
            0.72312847632100,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            0.34661262612707,
            0.56547785565182,
            0.94300000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            0.42830519499403,
            0.56050948600940,
            1.24600000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            0.46738200215089,
            0.47338670395900,
            0.59427677780000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            0.24709379453256,
            0.18198173917100,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            0.32415456703039,
            0.36375674498500,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            0.14509956942986,
            0.18388211183689,
            0.24549798800000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            0.22956514930613,
            0.55444971429300,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            0.10670361770000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            0.21898540540000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            0.06391398485994,
            0.10806425732282,
            0.14171698990000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            0.03599066704066,
            0.04368851386536,
            0.03463534758499,
            0.01418221270000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            -0.01439446368141,
            -0.01543201581300,
            -0.00985357190000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            -0.09115200126999,
            -0.09678003345000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            -0.13740767680000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            0.46524059775602,
            0.49200000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            0.42198236936188,
            0.63397117832958,
            0.52800000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            0.65599616057853,
            0.83084860530300,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.78733393310000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            0.78255214120000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            0.78608430860000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            0.79124653410000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            0.78972506100000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            0.65326281410000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            0.78994446360000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            0.79462439280000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            0.79518107340000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            0.80930480240000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            0.81306730350000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            0.81408370480000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            0.78415843730000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            0.82263187270000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            0.44266476936835,
            0.68407375970491,
            0.94300000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            0.23523422154086,
            0.30980440015125,
            1.09300000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            0.31319918056428,
            0.23020705290800,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            0.10191716059118,
            -0.03451303623300,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            0.19864391765550,
            -0.06474020857100,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            -0.01399684403519,
            -0.04786532465344,
            -0.07756443085155,
            -0.12042733190000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            0.00248540621951,
            0.10111888298800,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            0.02560952120000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            0.11991146910000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            0.05732791283824,
            0.10187349213041,
            0.14012325640000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            0.11449566751294,
            0.16758459323190,
            0.18265663815354,
            0.17825662710000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            0.04276095694715,
            0.06545183973370,
            0.07662886460000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            -0.04479748091835,
            -0.02201995669700,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            -0.07596582020000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
    ],
    dtype=torch.float64,
)
refsq = torch.tensor(
    [
        [
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            -0.37061732228445,
            -0.50233549783851,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            -0.17355187691088,
            -0.15560505779127,
            -0.34700000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            0.10464538187607,
            0.10076854070500,
            0.09407545849719,
            0.11346273566869,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            0.17123705791311,
            0.14210003554128,
            0.11125427335359,
            0.08551306072207,
            0.10441353918078,
            -0.21030312699251,
        ],
        [
            0.00000000000000,
            0.35298592555229,
            0.30125788296606,
            0.27476574374807,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            0.35471470167212,
            0.29940763030230,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            0.24773915491465,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            -0.37895090683878,
            -0.54307355286424,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            -0.32933884303798,
            -0.25537460426383,
            -0.34300000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            -0.03709152257935,
            -0.02539883774646,
            -0.01763798704591,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            -0.01649127941162,
            0.00320041899253,
            0.01542210101578,
            0.02195325245915,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            0.17987135979307,
            0.12671124139840,
            0.05822642474110,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            0.16267234588041,
            0.11887585724439,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            0.15045057451823,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            -0.44376242787490,
            -0.30400000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            -0.31814452979636,
            -0.25039443312215,
            -0.24400000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            -0.25072363627930,
            -0.20828457765513,
            -0.26200000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            -0.16129583914648,
            -0.13376488433347,
            -0.22575000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            -0.15269356649422,
            -0.13248643786217,
            -0.18700000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            -0.08860908785357,
            -0.01396246323450,
            -0.19615593415441,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            -0.13444214452845,
            0.00130799527933,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            -0.08054165072235,
            -0.00549324251347,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            -0.10784075790190,
            -0.06863349926037,
            0.00175321646512,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            -0.04925419950621,
            -0.00368537294864,
            -0.00304961164871,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            -0.05450628884215,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            -0.12898459420177,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            -0.02870304944818,
            -0.02255708461617,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            -0.00938786608492,
            0.00296399224112,
            0.01053861821037,
            0.01611389637169,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            0.09954248086481,
            0.05948368288525,
            0.03408461572369,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            0.12327157100582,
            0.08767901861183,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            0.14490782122377,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            -0.44852683448077,
            -0.41600000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            -0.42643340166796,
            -0.32451407135890,
            -0.51400000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            -0.28809273057140,
            -0.24104282544034,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            -0.17330631306353,
            -0.14136946391296,
            -0.23575000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            -0.21415259749701,
            -0.18683649533647,
            -0.24920000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            -0.23369100107545,
            -0.03944889199658,
            -0.09904612964760,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            -0.12354689726628,
            -0.01654379447015,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            -0.16207728351520,
            -0.03637567449858,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            -0.07254978471493,
            -0.06129403727896,
            -0.04909959760867,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            -0.11478257465306,
            -0.06930621428674,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            -0.10670361771604,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            -0.10949270272585,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            -0.06391398485994,
            -0.05403212866141,
            -0.04723899664934,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            -0.03599066704066,
            -0.02184425693268,
            -0.01154511586166,
            -0.00354555319366,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            0.01439446368141,
            0.00771600790650,
            0.00328452399254,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            0.09115200126999,
            0.04839001672511,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            0.13740767685282,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            -0.46524059775602,
            -0.49200000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            -0.42198236936188,
            -0.31698558916479,
            -0.52800000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            -0.32799808028927,
            -0.27694953510110,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            -0.26244464437392,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            -0.26085071373976,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            -0.26202810288884,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            -0.26374884470785,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            -0.26324168703303,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            -0.32663140707424,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            -0.26331482122356,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            -0.26487479761653,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            -0.26506035780811,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            -0.26976826747468,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            -0.27102243451532,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            -0.27136123496666,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            -0.26138614578463,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            -0.27421062424350,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            -0.22133238468418,
            -0.17101843992623,
            -0.23575000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            -0.11761711077043,
            -0.10326813338375,
            -0.21860000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            -0.15659959028214,
            -0.01918392107569,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            -0.05095858029559,
            0.00313754874849,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            -0.09932195882775,
            0.00647402085719,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            0.00699842201760,
            0.01595510821781,
            0.01939110771289,
            0.02408546639218,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            -0.00124270310976,
            -0.01263986037358,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            -0.02560952126341,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            -0.05995573459960,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            -0.05732791283824,
            -0.05093674606521,
            -0.04670775213539,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            -0.11449566751294,
            -0.08379229661595,
            -0.06088554605118,
            -0.04456415679904,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            -0.04276095694715,
            -0.03272591986685,
            -0.02554295489333,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            0.04479748091835,
            0.01100997834863,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            0.07596582020292,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
    ],
    dtype=torch.float64,
)
refalpha = torch.tensor(
    [
        [
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
        ],
        [
            [
                5.05401600000000e00,
                4.96682100000000e00,
                4.72443900000000e00,
                3.97078600000000e00,
                3.16550300000000e00,
                2.48864600000000e00,
                1.96704600000000e00,
                1.57508400000000e00,
                1.28042900000000e00,
                1.05653300000000e00,
                8.83925000000000e-01,
                7.48808000000000e-01,
                5.55006000000000e-01,
                4.26292000000000e-01,
                3.36939000000000e-01,
                2.72605000000000e-01,
                2.24858000000000e-01,
                1.48387000000000e-01,
                1.04992000000000e-01,
                6.03100000000000e-02,
                3.90250000000000e-02,
                1.75590000000000e-02,
                9.92500000000000e-03,
            ],
            [
                5.44151600000000e00,
                5.39127200000000e00,
                5.24667800000000e00,
                4.74625700000000e00,
                4.11220500000000e00,
                3.48279900000000e00,
                2.92562600000000e00,
                2.45860200000000e00,
                2.07639000000000e00,
                1.76603500000000e00,
                1.51389800000000e00,
                1.30807400000000e00,
                9.98777000000000e-01,
                7.83360000000000e-01,
                6.28681000000000e-01,
                5.14505000000000e-01,
                4.28148000000000e-01,
                2.86767000000000e-01,
                2.04727000000000e-01,
                1.18756000000000e-01,
                7.72270000000000e-02,
                3.49350000000000e-02,
                1.97880000000000e-02,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
        ],
        [
            [
                1.45463600000000e00,
                1.45021300000000e00,
                1.43714000000000e00,
                1.38759000000000e00,
                1.31354500000000e00,
                1.22436000000000e00,
                1.12861300000000e00,
                1.03278000000000e00,
                9.41058000000000e-01,
                8.55772000000000e-01,
                7.77929000000000e-01,
                7.07704000000000e-01,
                5.88640000000000e-01,
                4.94012000000000e-01,
                4.18709000000000e-01,
                3.58353000000000e-01,
                3.09516000000000e-01,
                2.22300000000000e-01,
                1.66509000000000e-01,
                1.02624000000000e-01,
                6.91900000000000e-02,
                3.27930000000000e-02,
                1.89800000000000e-02,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
        ],
        [
            [
                1.49684693000000e02,
                1.01093775000000e02,
                5.16672830000000e01,
                1.80181080000000e01,
                8.90934600000000e00,
                5.33090300000000e00,
                3.56971900000000e00,
                2.57307300000000e00,
                1.95375400000000e00,
                1.54217400000000e00,
                1.25438700000000e00,
                1.04493700000000e00,
                7.65833000000000e-01,
                5.92286000000000e-01,
                4.76082000000000e-01,
                3.93814000000000e-01,
                3.33009000000000e-01,
                2.34547000000000e-01,
                1.76685000000000e-01,
                1.13304000000000e-01,
                8.02740000000000e-02,
                4.24220000000000e-02,
                2.64160000000000e-02,
            ],
            [
                2.77934790000000e01,
                2.59220070000000e01,
                2.18214140000000e01,
                1.41717810000000e01,
                9.48248800000000e00,
                6.71290900000000e00,
                4.98572500000000e00,
                3.84650200000000e00,
                3.05897600000000e00,
                2.49322500000000e00,
                2.07366100000000e00,
                1.75410100000000e00,
                1.30734300000000e00,
                1.01650200000000e00,
                8.16158000000000e-01,
                6.71910000000000e-01,
                5.64308000000000e-01,
                3.89327000000000e-01,
                2.87017000000000e-01,
                1.76855000000000e-01,
                1.21126000000000e-01,
                6.02840000000000e-02,
                3.62580000000000e-02,
            ],
            [
                8.46459010000000e01,
                8.36841238000000e01,
                8.09655079000000e01,
                7.20284169000000e01,
                6.14818132000000e01,
                5.15922762000000e01,
                4.31612588000000e01,
                3.62527416000000e01,
                3.06710866000000e01,
                2.61700904000000e01,
                2.25260442000000e01,
                1.95557200000000e01,
                1.50928030000000e01,
                1.19795535000000e01,
                9.73760060000000e00,
                8.07622620000000e00,
                6.81365840000000e00,
                4.72675790000000e00,
                3.49485200000000e00,
                2.16814440000000e00,
                1.49976110000000e00,
                7.71818100000000e-01,
                4.81595100000000e-01,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
        ],
        [
            [
                4.28790460000000e01,
                3.99295910000000e01,
                3.31319060000000e01,
                1.98584460000000e01,
                1.20562070000000e01,
                7.87312400000000e00,
                5.50037000000000e00,
                4.05221400000000e00,
                3.10971800000000e00,
                2.46339300000000e00,
                2.00116300000000e00,
                1.65918600000000e00,
                1.19657200000000e00,
                9.06171000000000e-01,
                7.11967000000000e-01,
                5.75682000000000e-01,
                4.76326000000000e-01,
                3.19938000000000e-01,
                2.32135000000000e-01,
                1.41147000000000e-01,
                9.65570000000000e-02,
                4.88560000000000e-02,
                3.02000000000000e-02,
            ],
            [
                3.39191750000000e01,
                3.06229690000000e01,
                2.51809150000000e01,
                1.71197860000000e01,
                1.20494810000000e01,
                8.78239600000000e00,
                6.62332900000000e00,
                5.14835000000000e00,
                4.10599300000000e00,
                3.34621600000000e00,
                2.77718200000000e00,
                2.34088400000000e00,
                1.72765100000000e00,
                1.32762500000000e00,
                1.05284600000000e00,
                8.56226000000000e-01,
                7.10789000000000e-01,
                4.78152000000000e-01,
                3.45631000000000e-01,
                2.07337000000000e-01,
                1.39663000000000e-01,
                6.81800000000000e-02,
                4.09330000000000e-02,
            ],
            [
                2.03763510000000e01,
                1.99881660000000e01,
                1.89207290000000e01,
                1.56997430000000e01,
                1.23941440000000e01,
                9.69945200000000e00,
                7.66133400000000e00,
                6.14486300000000e00,
                5.00988200000000e00,
                4.14853500000000e00,
                3.48417300000000e00,
                2.96338900000000e00,
                2.21432600000000e00,
                1.71467500000000e00,
                1.36629700000000e00,
                1.11438900000000e00,
                9.26645000000000e-01,
                6.23903000000000e-01,
                4.50246000000000e-01,
                2.68461000000000e-01,
                1.79590000000000e-01,
                8.62930000000000e-02,
                5.11440000000000e-02,
            ],
            [
                5.08062040000000e01,
                5.00592716000000e01,
                4.80905154000000e01,
                4.25028663000000e01,
                3.67056665000000e01,
                3.15232793000000e01,
                2.71066190000000e01,
                2.34118521000000e01,
                2.03403941000000e01,
                1.77870106000000e01,
                1.56568911000000e01,
                1.38703586000000e01,
                1.10817107000000e01,
                9.04350220000000e00,
                7.51564070000000e00,
                6.34381990000000e00,
                5.42668580000000e00,
                3.85050330000000e00,
                2.87816080000000e00,
                1.90581830000000e00,
                1.22486150000000e00,
                6.02905500000000e-01,
                3.60209600000000e-01,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
        ],
        [
            [
                2.21068880000000e01,
                2.13442260000000e01,
                1.94317910000000e01,
                1.46694210000000e01,
                1.06975470000000e01,
                7.90232000000000e00,
                5.99221000000000e00,
                4.66844900000000e00,
                3.72698800000000e00,
                3.03894400000000e00,
                2.52319900000000e00,
                2.12773900000000e00,
                1.57206200000000e00,
                1.20956800000000e00,
                9.60327000000000e-01,
                7.81657000000000e-01,
                6.49190000000000e-01,
                4.36456000000000e-01,
                3.14692000000000e-01,
                1.87373000000000e-01,
                1.25270000000000e-01,
                6.02010000000000e-02,
                3.56010000000000e-02,
            ],
            [
                2.05521070000000e01,
                1.99101690000000e01,
                1.83552210000000e01,
                1.45802680000000e01,
                1.13056180000000e01,
                8.81651400000000e00,
                6.97943900000000e00,
                5.62061800000000e00,
                4.60226900000000e00,
                3.82638500000000e00,
                3.22515300000000e00,
                2.75167200000000e00,
                2.06645100000000e00,
                1.60597100000000e00,
                1.28287100000000e00,
                1.04798100000000e00,
                8.72121000000000e-01,
                5.86930000000000e-01,
                4.22471000000000e-01,
                2.50075000000000e-01,
                1.66134000000000e-01,
                7.88140000000000e-02,
                4.62310000000000e-02,
            ],
            [
                2.02806350000000e01,
                1.91635070000000e01,
                1.78009360000000e01,
                1.48840980000000e01,
                1.20983160000000e01,
                9.78360600000000e00,
                7.95693100000000e00,
                6.53703100000000e00,
                5.43285300000000e00,
                4.56782600000000e00,
                3.88309100000000e00,
                3.33486300000000e00,
                2.52733500000000e00,
                1.97529500000000e00,
                1.58353800000000e00,
                1.29652300000000e00,
                1.08047400000000e00,
                7.28153000000000e-01,
                5.24025000000000e-01,
                3.09524000000000e-01,
                2.05045000000000e-01,
                9.66460000000000e-02,
                5.64440000000000e-02,
            ],
            [
                1.73839000000000e01,
                1.71992340000000e01,
                1.66725580000000e01,
                1.48986510000000e01,
                1.27407520000000e01,
                1.06754850000000e01,
                8.89690800000000e00,
                7.43491400000000e00,
                6.25469200000000e00,
                5.30567600000000e00,
                4.54018400000000e00,
                3.91866100000000e00,
                2.98992000000000e00,
                2.34645100000000e00,
                1.88587300000000e00,
                1.54649900000000e00,
                1.29003000000000e00,
                8.70119000000000e-01,
                6.26026000000000e-01,
                3.69113000000000e-01,
                2.43962000000000e-01,
                1.14385000000000e-01,
                6.65550000000000e-02,
            ],
            [
                3.33389310000000e01,
                3.30011270000000e01,
                3.20357710000000e01,
                2.87639060000000e01,
                2.47422160000000e01,
                2.08503600000000e01,
                1.74641170000000e01,
                1.46555110000000e01,
                1.23709610000000e01,
                1.05223950000000e01,
                9.02363000000000e00,
                7.80164000000000e00,
                5.96709900000000e00,
                4.69016900000000e00,
                3.77334600000000e00,
                3.09637800000000e00,
                2.58404900000000e00,
                1.74404700000000e00,
                1.25522200000000e00,
                7.40457000000000e-01,
                4.89644000000000e-01,
                2.29910000000000e-01,
                1.33970000000000e-01,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
        ],
        [
            [
                1.23555340000000e01,
                1.21386640000000e01,
                1.15492610000000e01,
                9.79994900000000e00,
                7.99168200000000e00,
                6.46911200000000e00,
                5.27155500000000e00,
                4.34637000000000e00,
                3.62985800000000e00,
                3.06915700000000e00,
                2.62468200000000e00,
                2.26767800000000e00,
                1.73843000000000e00,
                1.37298300000000e00,
                1.11102100000000e00,
                9.17259000000000e-01,
                7.70100000000000e-01,
                5.26911000000000e-01,
                3.83503000000000e-01,
                2.29873000000000e-01,
                1.53581000000000e-01,
                7.32580000000000e-02,
                4.31920000000000e-02,
            ],
            [
                1.45482810000000e01,
                1.42754640000000e01,
                1.33786710000000e01,
                1.13492310000000e01,
                9.41853100000000e00,
                7.77191200000000e00,
                6.43618500000000e00,
                5.37287500000000e00,
                4.52877200000000e00,
                3.85533400000000e00,
                3.31349600000000e00,
                2.87327900000000e00,
                2.21276700000000e00,
                1.75148800000000e00,
                1.41845900000000e00,
                1.17102100000000e00,
                9.82578000000000e-01,
                6.70555000000000e-01,
                4.86537000000000e-01,
                2.89904000000000e-01,
                1.92716000000000e-01,
                9.10580000000000e-02,
                5.33330000000000e-02,
            ],
            [
                2.30116230000000e01,
                2.27312670000000e01,
                2.19447640000000e01,
                1.94160980000000e01,
                1.65257670000000e01,
                1.38835800000000e01,
                1.16644030000000e01,
                9.85664000000000e00,
                8.39542200000000e00,
                7.21181600000000e00,
                6.24695700000000e00,
                5.45405800000000e00,
                4.24755600000000e00,
                3.39147300000000e00,
                2.76550500000000e00,
                2.29559300000000e00,
                1.93467000000000e00,
                1.33059200000000e00,
                9.70136000000000e-01,
                5.81185000000000e-01,
                3.87432000000000e-01,
                1.83694000000000e-01,
                1.07810000000000e-01,
            ],
            [
                2.74537640000000e01,
                2.70921900000000e01,
                2.60934140000000e01,
                2.30050050000000e01,
                1.96170750000000e01,
                1.65717410000000e01,
                1.40107840000000e01,
                1.19057630000000e01,
                1.01859920000000e01,
                8.77914900000000e00,
                7.62277000000000e00,
                6.66612000000000e00,
                5.20002300000000e00,
                4.15296300000000e00,
                3.38451500000000e00,
                2.80654800000000e00,
                2.36231300000000e00,
                1.61909900000000e00,
                1.17658300000000e00,
                7.00962000000000e-01,
                4.65256000000000e-01,
                2.18871000000000e-01,
                1.27754000000000e-01,
            ],
            [
                2.83352760000000e01,
                2.80932470000000e01,
                2.73990360000000e01,
                2.50151020000000e01,
                2.20076950000000e01,
                1.89989890000000e01,
                1.62867160000000e01,
                1.39588710000000e01,
                1.20051730000000e01,
                1.03795410000000e01,
                9.02863700000000e00,
                7.90308800000000e00,
                6.16769700000000e00,
                4.92312800000000e00,
                4.00831600000000e00,
                3.32008700000000e00,
                2.79130600000000e00,
                1.90779800000000e00,
                1.38300300000000e00,
                8.20737000000000e-01,
                5.43129000000000e-01,
                2.54120000000000e-01,
                1.47757000000000e-01,
            ],
            [
                6.85832590000000e01,
                6.75115260000000e01,
                6.46123080000000e01,
                5.61286650000000e01,
                4.74318310000000e01,
                3.99459190000000e01,
                3.37814890000000e01,
                2.87553020000000e01,
                2.46561470000000e01,
                2.12992860000000e01,
                1.85340330000000e01,
                1.62406480000000e01,
                1.27133690000000e01,
                1.01832050000000e01,
                8.31946400000000e00,
                6.91337900000000e00,
                5.82981000000000e00,
                4.01066000000000e00,
                2.92309200000000e00,
                1.74948000000000e00,
                1.16548300000000e00,
                5.52306000000000e-01,
                3.24202000000000e-01,
            ],
            [
                7.74025000000000e00,
                7.66430000000000e00,
                7.44867000000000e00,
                6.72865000000000e00,
                5.85336000000000e00,
                5.00455000000000e00,
                4.25857000000000e00,
                3.63162000000000e00,
                3.11429000000000e00,
                2.68943000000000e00,
                2.33976000000000e00,
                2.05036000000000e00,
                1.60669000000000e00,
                1.28944000000000e00,
                1.05611000000000e00,
                8.80101000000000e-01,
                7.44360000000000e-01,
                5.15828000000000e-01,
                3.78403000000000e-01,
                2.28799000000000e-01,
                1.53550000000000e-01,
                7.36385000000000e-02,
                4.35460000000000e-02,
            ],
        ],
        [
            [
                7.53850900000000e00,
                7.46578400000000e00,
                7.25922300000000e00,
                6.57084200000000e00,
                5.74120900000000e00,
                4.94450400000000e00,
                4.24741100000000e00,
                3.66058200000000e00,
                3.17347200000000e00,
                2.77003800000000e00,
                2.43471700000000e00,
                2.15426700000000e00,
                1.71746100000000e00,
                1.39843500000000e00,
                1.15917600000000e00,
                9.75581000000000e-01,
                8.31886000000000e-01,
                5.85259000000000e-01,
                4.33727000000000e-01,
                2.65465000000000e-01,
                1.79204000000000e-01,
                8.60960000000000e-02,
                5.07150000000000e-02,
            ],
            [
                9.83408900000000e00,
                9.69804400000000e00,
                9.35215000000000e00,
                8.38113100000000e00,
                7.31842300000000e00,
                6.31838500000000e00,
                5.44072400000000e00,
                4.69565500000000e00,
                4.07209800000000e00,
                3.55233100000000e00,
                3.11842300000000e00,
                2.75458800000000e00,
                2.18726700000000e00,
                1.77344900000000e00,
                1.46404900000000e00,
                1.22750700000000e00,
                1.04307100000000e00,
                7.28380000000000e-01,
                5.36540000000000e-01,
                3.25416000000000e-01,
                2.18261000000000e-01,
                1.03808000000000e-01,
                6.07780000000000e-02,
            ],
            [
                1.85281530000000e01,
                1.83270930000000e01,
                1.77675350000000e01,
                1.59940890000000e01,
                1.39674690000000e01,
                1.20720960000000e01,
                1.04237930000000e01,
                9.02983000000000e00,
                7.86230500000000e00,
                6.88573000000000e00,
                6.06662500000000e00,
                5.37632100000000e00,
                4.29235100000000e00,
                3.49503200000000e00,
                2.89484400000000e00,
                2.43347000000000e00,
                2.07212100000000e00,
                1.45209500000000e00,
                1.07184900000000e00,
                6.51379000000000e-01,
                4.37251000000000e-01,
                2.08148000000000e-01,
                1.21945000000000e-01,
            ],
            [
                1.38928580000000e01,
                1.37335660000000e01,
                1.32948950000000e01,
                1.19342710000000e01,
                1.04022050000000e01,
                8.97061900000000e00,
                7.72181400000000e00,
                6.66356800000000e00,
                5.77723400000000e00,
                5.03713400000000e00,
                4.41817300000000e00,
                3.89844100000000e00,
                3.08722400000000e00,
                2.49563300000000e00,
                2.05397900000000e00,
                1.71704600000000e00,
                1.45495700000000e00,
                1.00954500000000e00,
                7.39563000000000e-01,
                4.44560000000000e-01,
                2.96150000000000e-01,
                1.39252000000000e-01,
                8.09340000000000e-02,
            ],
            [
                1.16125430000000e01,
                1.15410500000000e01,
                1.13332410000000e01,
                1.05895270000000e01,
                9.58863000000000e00,
                8.52284100000000e00,
                7.51063500000000e00,
                6.60431400000000e00,
                5.81642800000000e00,
                5.14065500000000e00,
                4.56368500000000e00,
                4.07092400000000e00,
                3.28581300000000e00,
                2.69945300000000e00,
                2.25275600000000e00,
                1.90595100000000e00,
                1.63202700000000e00,
                1.15658300000000e00,
                8.60973000000000e-01,
                5.29497000000000e-01,
                3.58275000000000e-01,
                1.72584000000000e-01,
                1.01807000000000e-01,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
        ],
        [
            [
                5.19670900000000e00,
                5.16443000000000e00,
                5.07156900000000e00,
                4.74845000000000e00,
                4.32735300000000e00,
                3.88542600000000e00,
                3.46480100000000e00,
                3.08386400000000e00,
                2.74782900000000e00,
                2.45533100000000e00,
                2.20216000000000e00,
                1.98324100000000e00,
                1.62875900000000e00,
                1.35871700000000e00,
                1.14924700000000e00,
                9.83879000000000e-01,
                8.51237000000000e-01,
                6.15831000000000e-01,
                4.65426000000000e-01,
                2.92127000000000e-01,
                2.00182000000000e-01,
                9.78590000000000e-02,
                5.79230000000000e-02,
            ],
            [
                7.29415700000000e00,
                7.23567900000000e00,
                7.07282800000000e00,
                6.54068900000000e00,
                5.88728900000000e00,
                5.22884300000000e00,
                4.61981800000000e00,
                4.07947000000000e00,
                3.60987300000000e00,
                3.20564300000000e00,
                2.85879200000000e00,
                2.56101800000000e00,
                2.08316500000000e00,
                1.72312300000000e00,
                1.44666000000000e00,
                1.23044600000000e00,
                1.05850300000000e00,
                7.57055000000000e-01,
                5.67268000000000e-01,
                3.51781000000000e-01,
                2.39118000000000e-01,
                1.15527000000000e-01,
                6.79560000000000e-02,
            ],
            [
                9.37158400000000e00,
                9.29176700000000e00,
                9.06639600000000e00,
                8.32277700000000e00,
                7.42350500000000e00,
                6.53920700000000e00,
                5.73862000000000e00,
                5.03980200000000e00,
                4.43965400000000e00,
                3.92746400000000e00,
                3.49075300000000e00,
                3.11765800000000e00,
                2.52224700000000e00,
                2.07641900000000e00,
                1.73594500000000e00,
                1.47099300000000e00,
                1.26125200000000e00,
                8.95955000000000e-01,
                6.67832000000000e-01,
                4.10982000000000e-01,
                2.77866000000000e-01,
                1.33160000000000e-01,
                7.79780000000000e-02,
            ],
            [
                1.03975870000000e01,
                1.03144230000000e01,
                1.00802310000000e01,
                9.31504800000000e00,
                8.40270200000000e00,
                7.50951200000000e00,
                6.69391100000000e00,
                5.97006900000000e00,
                5.33618200000000e00,
                4.78453000000000e00,
                4.30545700000000e00,
                3.88919800000000e00,
                3.21005900000000e00,
                2.68788400000000e00,
                2.27986700000000e00,
                1.95595300000000e00,
                1.69502800000000e00,
                1.22959000000000e00,
                9.30673000000000e-01,
                5.84862000000000e-01,
                4.00895000000000e-01,
                1.95985000000000e-01,
                1.16024000000000e-01,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
        ],
        [
            [
                3.63383900000000e00,
                3.61969600000000e00,
                3.57839400000000e00,
                3.42793800000000e00,
                3.21737200000000e00,
                2.97992900000000e00,
                2.73834900000000e00,
                2.50579100000000e00,
                2.28899900000000e00,
                2.09081400000000e00,
                1.91179100000000e00,
                1.75120000000000e00,
                1.47952600000000e00,
                1.26277400000000e00,
                1.08868800000000e00,
                9.47406000000000e-01,
                8.31438000000000e-01,
                6.18974000000000e-01,
                4.77855000000000e-01,
                3.08641000000000e-01,
                2.15354000000000e-01,
                1.07913000000000e-01,
                6.45990000000000e-02,
            ],
            [
                5.41705200000000e00,
                5.38858200000000e00,
                5.30626300000000e00,
                5.01557200000000e00,
                4.62855800000000e00,
                4.21373600000000e00,
                3.81040200000000e00,
                3.43689900000000e00,
                3.09985600000000e00,
                2.79994400000000e00,
                2.53500700000000e00,
                2.30171500000000e00,
                1.91556600000000e00,
                1.61459600000000e00,
                1.37729100000000e00,
                1.18765500000000e00,
                1.03406200000000e00,
                7.57846000000000e-01,
                5.78398000000000e-01,
                3.67849000000000e-01,
                2.54123000000000e-01,
                1.25549000000000e-01,
                7.46120000000000e-02,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
        ],
        [
            [
                2.62279400000000e00,
                2.61608100000000e00,
                2.59630100000000e00,
                2.52211500000000e00,
                2.41300700000000e00,
                2.28318500000000e00,
                2.14422400000000e00,
                2.00408900000000e00,
                1.86774600000000e00,
                1.73807500000000e00,
                1.61658500000000e00,
                1.50390700000000e00,
                1.30491800000000e00,
                1.13831700000000e00,
                9.99363000000000e-01,
                8.83202000000000e-01,
                7.85556000000000e-01,
                6.01026000000000e-01,
                4.73935000000000e-01,
                3.15511000000000e-01,
                2.24572000000000e-01,
                1.15709000000000e-01,
                7.02160000000000e-02,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
        ],
        [
            [
                1.70928531000000e02,
                1.19194623000000e02,
                6.28166710000000e01,
                2.22250350000000e01,
                1.10609650000000e01,
                6.72256800000000e00,
                4.61676300000000e00,
                3.43602800000000e00,
                2.70380200000000e00,
                2.21454000000000e00,
                1.86826500000000e00,
                1.61177100000000e00,
                1.25865200000000e00,
                1.02726100000000e00,
                8.63693000000000e-01,
                7.41806000000000e-01,
                6.47480000000000e-01,
                4.84921000000000e-01,
                3.82313000000000e-01,
                2.62013000000000e-01,
                1.94713000000000e-01,
                1.10805000000000e-01,
                7.17200000000000e-02,
            ],
            [
                4.08166710000000e01,
                3.73885700000000e01,
                3.02959980000000e01,
                1.83845350000000e01,
                1.18437670000000e01,
                8.25289400000000e00,
                6.11997100000000e00,
                4.75721000000000e00,
                3.83331600000000e00,
                3.17626000000000e00,
                2.69038600000000e00,
                2.31935200000000e00,
                1.79486800000000e00,
                1.44543100000000e00,
                1.19798700000000e00,
                1.01469800000000e00,
                8.74212000000000e-01,
                6.36537000000000e-01,
                4.90509000000000e-01,
                3.24702000000000e-01,
                2.35369000000000e-01,
                1.29021000000000e-01,
                8.19540000000000e-02,
            ],
            [
                9.26411774000000e01,
                9.14243783000000e01,
                8.80445743000000e01,
                7.74364073000000e01,
                6.56163384000000e01,
                5.49685877000000e01,
                4.60979628000000e01,
                3.89126798000000e01,
                3.31338025000000e01,
                2.84756146000000e01,
                2.46963717000000e01,
                2.16046368000000e01,
                1.69269705000000e01,
                1.36278912000000e01,
                1.12244983000000e01,
                9.42307370000000e00,
                8.03912310000000e00,
                5.71416620000000e00,
                4.31216980000000e00,
                2.96529010000000e00,
                1.96165460000000e00,
                1.04968610000000e00,
                6.66155700000000e-01,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
        ],
        [
            [
                7.56666810000000e01,
                6.86955210000000e01,
                5.39153050000000e01,
                2.92692840000000e01,
                1.68382330000000e01,
                1.06997010000000e01,
                7.37931600000000e00,
                5.41684700000000e00,
                4.17021100000000e00,
                3.33149200000000e00,
                2.74054600000000e00,
                2.30815200000000e00,
                1.72854000000000e00,
                1.36536800000000e00,
                1.12012100000000e00,
                9.44726000000000e-01,
                8.13518000000000e-01,
                5.95916000000000e-01,
                4.62629000000000e-01,
                3.07942000000000e-01,
                2.21999000000000e-01,
                1.18858000000000e-01,
                7.45220000000000e-02,
            ],
            [
                6.50041490000000e01,
                5.73670330000000e01,
                4.46926220000000e01,
                2.68427890000000e01,
                1.72249920000000e01,
                1.18363720000000e01,
                8.61094200000000e00,
                6.55541300000000e00,
                5.17386500000000e00,
                4.20348700000000e00,
                3.49654400000000e00,
                2.96551100000000e00,
                2.23346800000000e00,
                1.76236100000000e00,
                1.43913600000000e00,
                1.20603600000000e00,
                1.03113600000000e00,
                7.41949000000000e-01,
                5.67097000000000e-01,
                3.68808000000000e-01,
                2.61744000000000e-01,
                1.36955000000000e-01,
                8.47940000000000e-02,
            ],
            [
                3.45442750000000e01,
                3.35344340000000e01,
                3.08656630000000e01,
                2.36561780000000e01,
                1.73397030000000e01,
                1.28432530000000e01,
                9.77232700000000e00,
                7.65213800000000e00,
                6.15048100000000e00,
                5.05676300000000e00,
                4.23881100000000e00,
                3.61230900000000e00,
                2.73143700000000e00,
                2.15429600000000e00,
                1.75423700000000e00,
                1.46419500000000e00,
                1.24614700000000e00,
                8.86233000000000e-01,
                6.70308000000000e-01,
                4.28938000000000e-01,
                3.01012000000000e-01,
                1.54843000000000e-01,
                9.49500000000000e-02,
            ],
            [
                7.46298821000000e01,
                7.26677188000000e01,
                6.79314704000000e01,
                5.65001225000000e01,
                4.64504007000000e01,
                3.84956042000000e01,
                3.23037179000000e01,
                2.74626661000000e01,
                2.36358080000000e01,
                2.05710128000000e01,
                1.80838250000000e01,
                1.60395958000000e01,
                1.29096858000000e01,
                1.06544671000000e01,
                8.97108140000000e00,
                7.67712880000000e00,
                6.65793700000000e00,
                4.87782300000000e00,
                3.85863120000000e00,
                2.83943940000000e00,
                1.71077820000000e00,
                8.78469300000000e-01,
                5.36523200000000e-01,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
        ],
        [
            [
                6.08923430000000e01,
                5.63100140000000e01,
                4.67886820000000e01,
                2.95825800000000e01,
                1.89999900000000e01,
                1.28554770000000e01,
                9.16537200000000e00,
                6.83511700000000e00,
                5.29019700000000e00,
                4.22118800000000e00,
                3.45397700000000e00,
                2.88602100000000e00,
                2.11861900000000e00,
                1.63766400000000e00,
                1.31578200000000e00,
                1.08900100000000e00,
                9.22495000000000e-01,
                6.55671000000000e-01,
                5.00295000000000e-01,
                3.29221000000000e-01,
                2.37792000000000e-01,
                1.28642000000000e-01,
                8.07650000000000e-02,
            ],
            [
                5.62109890000000e01,
                5.24017100000000e01,
                4.43132520000000e01,
                2.94084250000000e01,
                1.99025080000000e01,
                1.40717810000000e01,
                1.03773750000000e01,
                7.93723900000000e00,
                6.25995900000000e00,
                5.06530900000000e00,
                4.18770300000000e00,
                3.52557300000000e00,
                2.61171100000000e00,
                2.02625900000000e00,
                1.62846700000000e00,
                1.34530700000000e00,
                1.13600600000000e00,
                7.98910000000000e-01,
                6.02662000000000e-01,
                3.88684000000000e-01,
                2.76485000000000e-01,
                1.46142000000000e-01,
                9.06750000000000e-02,
            ],
            [
                4.30078740000000e01,
                4.03049500000000e01,
                3.57272810000000e01,
                2.68099970000000e01,
                1.98081180000000e01,
                1.48306090000000e01,
                1.13606550000000e01,
                8.91713500000000e00,
                7.16077800000000e00,
                5.86875100000000e00,
                4.89650000000000e00,
                4.14934900000000e00,
                3.09796800000000e00,
                2.41163900000000e00,
                1.93954100000000e00,
                1.60075800000000e00,
                1.34903600000000e00,
                9.41973000000000e-01,
                7.04899000000000e-01,
                4.48010000000000e-01,
                3.15048000000000e-01,
                1.63563000000000e-01,
                1.00542000000000e-01,
            ],
            [
                3.22831180000000e01,
                3.17115930000000e01,
                3.01255060000000e01,
                2.52170820000000e01,
                2.00120360000000e01,
                1.56749350000000e01,
                1.23626340000000e01,
                9.89456800000000e00,
                8.05306200000000e00,
                6.66269700000000e00,
                5.59650600000000e00,
                4.76548500000000e00,
                3.57878900000000e00,
                2.79320300000000e00,
                2.24790800000000e00,
                1.85425800000000e00,
                1.56063400000000e00,
                1.08433000000000e00,
                8.06759000000000e-01,
                5.07207000000000e-01,
                3.53560000000000e-01,
                1.80975000000000e-01,
                1.10404000000000e-01,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
        ],
        [
            [
                3.89490650000000e01,
                3.75127500000000e01,
                3.39244170000000e01,
                2.51761170000000e01,
                1.80845250000000e01,
                1.31765080000000e01,
                9.86167000000000e00,
                7.59170600000000e00,
                5.99824200000000e00,
                4.84934000000000e00,
                3.99953100000000e00,
                3.35611600000000e00,
                2.46688400000000e00,
                1.89821900000000e00,
                1.51346200000000e00,
                1.24110200000000e00,
                1.04106700000000e00,
                7.22600000000000e-01,
                5.40556000000000e-01,
                3.46553000000000e-01,
                2.47176000000000e-01,
                1.33261000000000e-01,
                8.45050000000000e-02,
            ],
            [
                3.80097750000000e01,
                3.66441270000000e01,
                3.33701090000000e01,
                2.55897470000000e01,
                1.90941400000000e01,
                1.43691430000000e01,
                1.10297080000000e01,
                8.65695700000000e00,
                6.94178300000000e00,
                5.67589700000000e00,
                4.72179500000000e00,
                3.98829800000000e00,
                2.95705800000000e00,
                2.28580300000000e00,
                1.82595300000000e00,
                1.49755000000000e00,
                1.25484400000000e00,
                8.66094000000000e-01,
                6.43081000000000e-01,
                4.06049000000000e-01,
                2.85861000000000e-01,
                1.50742000000000e-01,
                9.43940000000000e-02,
            ],
            [
                3.72763200000000e01,
                3.62054630000000e01,
                3.34711240000000e01,
                2.64376500000000e01,
                2.02438260000000e01,
                1.55716430000000e01,
                1.21648030000000e01,
                9.67987400000000e00,
                7.84486700000000e00,
                6.46705100000000e00,
                5.41408200000000e00,
                4.59540000000000e00,
                3.42976000000000e00,
                2.66105900000000e00,
                2.12957300000000e00,
                1.74748400000000e00,
                1.46374300000000e00,
                1.00704100000000e00,
                7.44164000000000e-01,
                4.65003000000000e-01,
                3.24318000000000e-01,
                1.68192000000000e-01,
                1.04281000000000e-01,
            ],
            [
                7.52662880000000e01,
                7.23612970000000e01,
                6.56345910000000e01,
                5.08100850000000e01,
                3.89033790000000e01,
                3.00787730000000e01,
                2.36268450000000e01,
                1.88896320000000e01,
                1.53681050000000e01,
                1.27085630000000e01,
                1.06661350000000e01,
                9.07173900000000e00,
                6.79128300000000e00,
                5.28032600000000e00,
                4.23215900000000e00,
                3.47678200000000e00,
                2.91479700000000e00,
                2.00828100000000e00,
                1.48532500000000e00,
                9.28970000000000e-01,
                6.48177000000000e-01,
                3.36241000000000e-01,
                2.08475000000000e-01,
            ],
            [
                6.17861480000000e01,
                6.08116450000000e01,
                5.80975290000000e01,
                4.95798710000000e01,
                4.02758690000000e01,
                3.22331470000000e01,
                2.58672360000000e01,
                2.09751250000000e01,
                1.72319240000000e01,
                1.43488200000000e01,
                1.21032080000000e01,
                1.03316220000000e01,
                7.76988200000000e00,
                6.05476200000000e00,
                4.85682200000000e00,
                3.98954100000000e00,
                3.34229500000000e00,
                2.29527400000000e00,
                1.69038600000000e00,
                1.04795900000000e00,
                7.25532000000000e-01,
                3.71177000000000e-01,
                2.28230000000000e-01,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
        ],
        [
            [
                2.59470070000000e01,
                2.54290340000000e01,
                2.40216260000000e01,
                1.98723550000000e01,
                1.56749860000000e01,
                1.22514680000000e01,
                9.65166500000000e00,
                7.71296900000000e00,
                6.26285300000000e00,
                5.16567000000000e00,
                4.32339800000000e00,
                3.66693300000000e00,
                2.73115700000000e00,
                2.11442600000000e00,
                1.68882900000000e00,
                1.38359000000000e00,
                1.15748000000000e00,
                7.94987000000000e-01,
                5.87534000000000e-01,
                3.68761000000000e-01,
                2.59274000000000e-01,
                1.37872000000000e-01,
                8.75080000000000e-02,
            ],
            [
                2.78753970000000e01,
                2.73122270000000e01,
                2.58232190000000e01,
                2.15634300000000e01,
                1.72591270000000e01,
                1.36872210000000e01,
                1.09190600000000e01,
                8.81620500000000e00,
                7.21834600000000e00,
                5.99339200000000e00,
                5.04266200000000e00,
                4.29480800000000e00,
                3.21727700000000e00,
                2.49896200000000e00,
                1.99912800000000e00,
                1.63846300000000e00,
                1.37011100000000e00,
                9.37927000000000e-01,
                6.89768000000000e-01,
                4.28165000000000e-01,
                2.97933000000000e-01,
                1.55370000000000e-01,
                9.74170000000000e-02,
            ],
            [
                5.57853670000000e01,
                5.45314410000000e01,
                5.12683850000000e01,
                4.23425800000000e01,
                3.37346300000000e01,
                2.67484370000000e01,
                2.13755400000000e01,
                1.72987970000000e01,
                1.41966540000000e01,
                1.18128320000000e01,
                9.95782900000000e00,
                8.49495000000000e00,
                6.38022500000000e00,
                4.96511800000000e00,
                3.97752800000000e00,
                3.26330400000000e00,
                2.73096000000000e00,
                1.87188600000000e00,
                1.37761400000000e00,
                8.55767000000000e-01,
                5.95676000000000e-01,
                3.10731000000000e-01,
                1.94832000000000e-01,
            ],
            [
                3.04586930000000e01,
                2.99832590000000e01,
                2.86718190000000e01,
                2.46351360000000e01,
                2.02683100000000e01,
                1.64561420000000e01,
                1.33810200000000e01,
                1.09693570000000e01,
                9.08968500000000e00,
                7.61891900000000e00,
                6.45826200000000e00,
                5.53271600000000e00,
                4.17823400000000e00,
                3.26053500000000e00,
                2.61453300000000e00,
                2.14448900000000e00,
                1.79262800000000e00,
                1.22238900000000e00,
                8.93420000000000e-01,
                5.46634000000000e-01,
                3.75078000000000e-01,
                1.90310000000000e-01,
                1.17204000000000e-01,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
        ],
        [
            [
                1.96135110000000e01,
                1.93396950000000e01,
                1.85777950000000e01,
                1.61740460000000e01,
                1.34828010000000e01,
                1.10662650000000e01,
                9.07644200000000e00,
                7.49185000000000e00,
                6.24199200000000e00,
                5.25468100000000e00,
                4.46958500000000e00,
                3.83971900000000e00,
                2.91197500000000e00,
                2.27960600000000e00,
                1.83280500000000e00,
                1.50693100000000e00,
                1.26259400000000e00,
                8.65866000000000e-01,
                6.36480000000000e-01,
                3.94016000000000e-01,
                2.73614000000000e-01,
                1.42940000000000e-01,
                9.02880000000000e-02,
            ],
            [
                2.22041430000000e01,
                2.18891090000000e01,
                2.10218000000000e01,
                1.83279640000000e01,
                1.53337320000000e01,
                1.26407210000000e01,
                1.04119420000000e01,
                8.62659600000000e00,
                7.21050800000000e00,
                6.08629700000000e00,
                5.18841100000000e00,
                4.46526700000000e00,
                3.39502200000000e00,
                2.66154500000000e00,
                2.14111000000000e00,
                1.76030300000000e00,
                1.47408400000000e00,
                1.00818500000000e00,
                7.38339000000000e-01,
                4.53257000000000e-01,
                3.12198000000000e-01,
                1.60439000000000e-01,
                1.00216000000000e-01,
            ],
            [
                2.45118610000000e01,
                2.41774360000000e01,
                2.32503900000000e01,
                2.03440110000000e01,
                1.70929990000000e01,
                1.41530500000000e01,
                1.17050130000000e01,
                9.73202400000000e00,
                8.15838200000000e00,
                6.90302900000000e00,
                5.89622500000000e00,
                5.08245900000000e00,
                3.87292300000000e00,
                3.04008300000000e00,
                2.44704700000000e00,
                2.01195800000000e00,
                1.68428900000000e00,
                1.14980800000000e00,
                8.39773000000000e-01,
                5.12298000000000e-01,
                3.50671000000000e-01,
                1.77901000000000e-01,
                1.10127000000000e-01,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
        ],
        [
            [
                1.46510610000000e01,
                1.45166850000000e01,
                1.41329320000000e01,
                1.28305660000000e01,
                1.12118050000000e01,
                9.61104600000000e00,
                8.18172600000000e00,
                6.96587200000000e00,
                5.95419400000000e00,
                5.11935000000000e00,
                4.43107300000000e00,
                3.86193900000000e00,
                2.99351500000000e00,
                2.37889500000000e00,
                1.93244700000000e00,
                1.60004400000000e00,
                1.34690400000000e00,
                9.28616000000000e-01,
                6.82769000000000e-01,
                4.20290000000000e-01,
                2.89583000000000e-01,
                1.48974000000000e-01,
                9.34510000000000e-02,
            ],
            [
                1.72630540000000e01,
                1.70983080000000e01,
                1.66294740000000e01,
                1.50531340000000e01,
                1.31168290000000e01,
                1.12193720000000e01,
                9.53560200000000e00,
                8.10913000000000e00,
                6.92542000000000e00,
                5.95043800000000e00,
                5.14768600000000e00,
                4.48451200000000e00,
                3.47342900000000e00,
                2.75821200000000e00,
                2.23872700000000e00,
                1.85189500000000e00,
                1.55725800000000e00,
                1.07036000000000e00,
                7.84299000000000e-01,
                4.79385000000000e-01,
                3.28088000000000e-01,
                1.66454000000000e-01,
                1.03381000000000e-01,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
        ],
        [
            [
                1.11080370000000e01,
                1.10394140000000e01,
                1.08402330000000e01,
                1.01295640000000e01,
                9.17337000000000e00,
                8.14874700000000e00,
                7.16548200000000e00,
                6.27576300000000e00,
                5.49600600000000e00,
                4.82400800000000e00,
                4.24944600000000e00,
                3.75948600000000e00,
                2.98395600000000e00,
                2.41282400000000e00,
                1.98521700000000e00,
                1.65931000000000e00,
                1.40654400000000e00,
                9.79774000000000e-01,
                7.23518000000000e-01,
                4.45684000000000e-01,
                3.06022000000000e-01,
                1.55748000000000e-01,
                9.70350000000000e-02,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
        ],
        [
            [
                3.66617327000000e02,
                1.95240726000000e02,
                8.38654450000000e01,
                2.88051330000000e01,
                1.59216120000000e01,
                1.09496410000000e01,
                8.40358000000000e00,
                6.84316000000000e00,
                5.76666800000000e00,
                4.96403800000000e00,
                4.33444400000000e00,
                3.82376200000000e00,
                3.04279100000000e00,
                2.47565500000000e00,
                2.04945700000000e00,
                1.72141300000000e00,
                1.46410500000000e00,
                1.02220300000000e00,
                7.51686000000000e-01,
                4.54431000000000e-01,
                3.04549000000000e-01,
                1.45801000000000e-01,
                8.62690000000000e-02,
            ],
            [
                5.34389170000000e01,
                4.78463210000000e01,
                3.77399140000000e01,
                2.34699070000000e01,
                1.63225240000000e01,
                1.23576000000000e01,
                9.86988100000000e00,
                8.15796800000000e00,
                6.90010800000000e00,
                5.93217900000000e00,
                5.16253500000000e00,
                4.53588800000000e00,
                3.58047400000000e00,
                2.89303400000000e00,
                2.38155600000000e00,
                1.99132100000000e00,
                1.68746600000000e00,
                1.17038400000000e00,
                8.56880000000000e-01,
                5.15114000000000e-01,
                3.43926000000000e-01,
                1.63594000000000e-01,
                9.63540000000000e-02,
            ],
            [
                1.12876996300000e02,
                1.11538255900000e02,
                1.07820122600000e02,
                9.61458563000000e01,
                8.30747922000000e01,
                7.11307898000000e01,
                6.09421945000000e01,
                5.24432551000000e01,
                4.53906629000000e01,
                3.95298970000000e01,
                3.46393638000000e01,
                3.05368708000000e01,
                2.41382573000000e01,
                1.94781015000000e01,
                1.60067586000000e01,
                1.33663894000000e01,
                1.13195232000000e01,
                7.86103630000000e00,
                5.78110580000000e00,
                3.52496960000000e00,
                2.39403530000000e00,
                1.18793800000000e00,
                7.24506800000000e-01,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
        ],
        [
            [
                1.67333120000000e02,
                1.38735082000000e02,
                9.23660100000000e01,
                4.10298690000000e01,
                2.25025050000000e01,
                1.45451620000000e01,
                1.04632190000000e01,
                8.07237600000000e00,
                6.52670800000000e00,
                5.45001800000000e00,
                4.65619400000000e00,
                4.04504800000000e00,
                3.16189500000000e00,
                2.55249700000000e00,
                2.10735500000000e00,
                1.76981400000000e00,
                1.50697100000000e00,
                1.05693900000000e00,
                7.80721000000000e-01,
                4.75018000000000e-01,
                3.19568000000000e-01,
                1.53813000000000e-01,
                9.14010000000000e-02,
            ],
            [
                1.58150883000000e02,
                1.11646160000000e02,
                6.79213530000000e01,
                3.39702430000000e01,
                2.13038760000000e01,
                1.50163380000000e01,
                1.13779670000000e01,
                9.04828500000000e00,
                7.44314000000000e00,
                6.27428200000000e00,
                5.38612100000000e00,
                4.68859600000000e00,
                3.66419700000000e00,
                2.95060000000000e00,
                2.42857600000000e00,
                2.03347500000000e00,
                1.72675900000000e00,
                1.20448100000000e00,
                8.86210000000000e-01,
                5.36396000000000e-01,
                3.59609000000000e-01,
                1.72051000000000e-01,
                1.01783000000000e-01,
            ],
            [
                4.78971840000000e01,
                4.58022250000000e01,
                4.07933190000000e01,
                2.96764790000000e01,
                2.15460190000000e01,
                1.62269040000000e01,
                1.26953380000000e01,
                1.02550730000000e01,
                8.49733900000000e00,
                7.18321100000000e00,
                6.16916500000000e00,
                5.36588300000000e00,
                4.18011400000000e00,
                3.35367600000000e00,
                2.75086200000000e00,
                2.29640100000000e00,
                1.94500200000000e00,
                1.35006900000000e00,
                9.89971000000000e-01,
                5.96596000000000e-01,
                3.98837000000000e-01,
                1.89903000000000e-01,
                1.11947000000000e-01,
            ],
            [
                9.28563023000000e01,
                9.11707612000000e01,
                8.67243129000000e01,
                7.42666422000000e01,
                6.20928688000000e01,
                5.21273713000000e01,
                4.43017181000000e01,
                3.81421847000000e01,
                3.32177260000000e01,
                2.92098267000000e01,
                2.58942119000000e01,
                2.31129142000000e01,
                1.87302605000000e01,
                1.54634027000000e01,
                1.29627169000000e01,
                1.10083621000000e01,
                9.45458820000000e00,
                6.73356950000000e00,
                5.02603660000000e00,
                3.09950610000000e00,
                2.10151100000000e00,
                1.01842800000000e00,
                6.04571900000000e-01,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
        ],
        [
            [
                1.25679905000000e02,
                1.08314439000000e02,
                7.72929700000000e01,
                3.71320260000000e01,
                2.07670580000000e01,
                1.34119080000000e01,
                9.58113500000000e00,
                7.33530900000000e00,
                5.89310800000000e00,
                4.89899500000000e00,
                4.17454400000000e00,
                3.62291800000000e00,
                2.83578800000000e00,
                2.29845300000000e00,
                1.90741300000000e00,
                1.61064000000000e00,
                1.37874700000000e00,
                9.78477000000000e-01,
                7.29628000000000e-01,
                4.49933000000000e-01,
                3.05279000000000e-01,
                1.48484000000000e-01,
                8.86520000000000e-02,
            ],
            [
                4.33830910000000e01,
                4.50959100000000e01,
                3.95276970000000e01,
                2.89987430000000e01,
                2.13879050000000e01,
                1.62717510000000e01,
                1.27943430000000e01,
                1.03540150000000e01,
                8.58135000000000e00,
                7.25175300000000e00,
                6.22586900000000e00,
                5.41477400000000e00,
                4.22212600000000e00,
                3.39479700000000e00,
                2.79290600000000e00,
                2.33938800000000e00,
                1.98837600000000e00,
                1.39191900000000e00,
                1.02826900000000e00,
                6.26756000000000e-01,
                4.22133000000000e-01,
                2.02671000000000e-01,
                1.19720000000000e-01,
            ],
            [
                4.57861990000000e01,
                4.43266490000000e01,
                4.07084650000000e01,
                3.17823730000000e01,
                2.42343690000000e01,
                1.87383620000000e01,
                1.48308240000000e01,
                1.20175160000000e01,
                9.94467200000000e00,
                8.37872300000000e00,
                7.16720900000000e00,
                6.20952100000000e00,
                4.80607100000000e00,
                3.83943900000000e00,
                3.14169700000000e00,
                2.61978900000000e00,
                2.21842600000000e00,
                1.54214500000000e00,
                1.13370000000000e00,
                6.86573000000000e-01,
                4.60519000000000e-01,
                2.19799000000000e-01,
                1.29409000000000e-01,
            ],
            [
                2.57885399000000e01,
                2.55284328000000e01,
                2.48018055000000e01,
                2.24847965000000e01,
                1.98432083000000e01,
                1.74046421000000e01,
                1.53140812000000e01,
                1.35610819000000e01,
                1.20932360000000e01,
                1.08561134000000e01,
                9.80390740000000e00,
                8.90049270000000e00,
                7.43459940000000e00,
                6.30201960000000e00,
                5.40614130000000e00,
                4.68440250000000e00,
                4.09437510000000e00,
                3.01858830000000e00,
                2.30950380000000e00,
                1.46972410000000e00,
                1.01456920000000e00,
                5.01317600000000e-01,
                2.99017900000000e-01,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
        ],
        [
            [
                1.14724364000000e02,
                9.97786920000000e01,
                7.33046090000000e01,
                3.75872700000000e01,
                2.20065650000000e01,
                1.46330060000000e01,
                1.06399730000000e01,
                8.22787200000000e00,
                6.64410900000000e00,
                5.53560200000000e00,
                4.72020800000000e00,
                4.09647100000000e00,
                3.20585000000000e00,
                2.60046000000000e00,
                2.16237700000000e00,
                1.83130700000000e00,
                1.57315300000000e00,
                1.12714000000000e00,
                8.48046000000000e-01,
                5.30392000000000e-01,
                3.63333000000000e-01,
                1.78704000000000e-01,
                1.06889000000000e-01,
            ],
            [
                4.60919720000000e01,
                4.24892580000000e01,
                3.76213730000000e01,
                2.80117340000000e01,
                2.08457830000000e01,
                1.59626110000000e01,
                1.26095600000000e01,
                1.02373540000000e01,
                8.50349200000000e00,
                7.19736700000000e00,
                6.18692700000000e00,
                5.38703000000000e00,
                4.21070800000000e00,
                3.39560600000000e00,
                2.80318900000000e00,
                2.35678200000000e00,
                2.01084100000000e00,
                1.42053200000000e00,
                1.05761600000000e00,
                6.52206000000000e-01,
                4.42777000000000e-01,
                2.14914000000000e-01,
                1.27531000000000e-01,
            ],
            [
                4.87114030000000e01,
                4.72968810000000e01,
                4.36774280000000e01,
                3.44392690000000e01,
                2.65310300000000e01,
                2.07154850000000e01,
                1.65179260000000e01,
                1.34481710000000e01,
                1.11565010000000e01,
                9.40841800000000e00,
                8.04737700000000e00,
                6.96762100000000e00,
                5.38295500000000e00,
                4.29339200000000e00,
                3.50973600000000e00,
                2.92571200000000e00,
                2.47792100000000e00,
                1.72560700000000e00,
                1.27179600000000e00,
                7.74044000000000e-01,
                5.21222000000000e-01,
                2.50091000000000e-01,
                1.47455000000000e-01,
            ],
            [
                3.18693190000000e01,
                3.15954595000000e01,
                3.08154120000000e01,
                2.81936583000000e01,
                2.49990546000000e01,
                2.19123454000000e01,
                1.92042984000000e01,
                1.69162029000000e01,
                1.50030479000000e01,
                1.34005228000000e01,
                1.20488331000000e01,
                1.08986824000000e01,
                9.05589400000000e00,
                7.65297260000000e00,
                6.55545490000000e00,
                5.67802830000000e00,
                4.96428430000000e00,
                3.66802500000000e00,
                2.81448870000000e00,
                1.80073880000000e00,
                1.24824160000000e00,
                6.20475600000000e-01,
                3.70969000000000e-01,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
        ],
        [
            [
                1.00991061000000e02,
                8.86597800000000e01,
                6.66115730000000e01,
                3.55163660000000e01,
                2.12160720000000e01,
                1.42442310000000e01,
                1.04067670000000e01,
                8.06782700000000e00,
                6.52487000000000e00,
                5.44255800000000e00,
                4.64584900000000e00,
                4.03644500000000e00,
                3.16696100000000e00,
                2.57673600000000e00,
                2.15007700000000e00,
                1.82776100000000e00,
                1.57631400000000e00,
                1.14067900000000e00,
                8.66090000000000e-01,
                5.49443000000000e-01,
                3.79977000000000e-01,
                1.89162000000000e-01,
                1.13662000000000e-01,
            ],
            [
                4.47007430000000e01,
                4.20873530000000e01,
                3.71472140000000e01,
                2.74044260000000e01,
                2.03770970000000e01,
                1.56299000000000e01,
                1.23710770000000e01,
                1.00613500000000e01,
                8.36990500000000e00,
                7.09379000000000e00,
                6.10549400000000e00,
                5.32255900000000e00,
                4.17051400000000e00,
                3.37198000000000e00,
                2.79152500000000e00,
                2.35400000000000e00,
                2.01471000000000e00,
                1.43443000000000e00,
                1.07572900000000e00,
                6.71070000000000e-01,
                4.59190000000000e-01,
                2.25196000000000e-01,
                1.34181000000000e-01,
            ],
            [
                4.38589710000000e01,
                4.19185700000000e01,
                3.79612250000000e01,
                2.94769420000000e01,
                2.26653000000000e01,
                1.77162500000000e01,
                1.41578990000000e01,
                1.15615470000000e01,
                9.62566000000000e00,
                8.14924700000000e00,
                6.99890600000000e00,
                6.08501000000000e00,
                4.73976600000000e00,
                3.81014900000000e00,
                3.13777700000000e00,
                2.63376400000000e00,
                2.24503700000000e00,
                1.58558800000000e00,
                1.18211400000000e00,
                7.31698000000000e-01,
                4.98251000000000e-01,
                2.42727000000000e-01,
                1.44110000000000e-01,
            ],
            [
                3.94919722000000e01,
                3.90027923000000e01,
                3.76740133000000e01,
                3.36693555000000e01,
                2.93313719000000e01,
                2.54515734000000e01,
                2.22023666000000e01,
                1.95294838000000e01,
                1.73268203000000e01,
                1.54949224000000e01,
                1.39540832000000e01,
                1.26434247000000e01,
                1.05397592000000e01,
                8.93221310000000e00,
                7.66974050000000e00,
                6.65695470000000e00,
                5.83065590000000e00,
                4.32391520000000e00,
                3.32701160000000e00,
                2.13700280000000e00,
                1.48504450000000e00,
                7.40465000000000e-01,
                4.43134600000000e-01,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
        ],
        [
            [
                8.14204420000000e01,
                7.03861320000000e01,
                5.10334860000000e01,
                2.66035920000000e01,
                1.64401450000000e01,
                1.15586160000000e01,
                8.79566200000000e00,
                7.04043900000000e00,
                5.83447500000000e00,
                4.95845200000000e00,
                4.29489900000000e00,
                3.77549000000000e00,
                3.01503100000000e00,
                2.48474900000000e00,
                2.09373500000000e00,
                1.79381900000000e00,
                1.55705200000000e00,
                1.14096500000000e00,
                8.74779000000000e-01,
                5.63401000000000e-01,
                3.93951000000000e-01,
                1.99185000000000e-01,
                1.20434000000000e-01,
            ],
            [
                4.53318020000000e01,
                4.24171170000000e01,
                3.70714340000000e01,
                2.69188730000000e01,
                1.98754030000000e01,
                1.52233940000000e01,
                1.20588400000000e01,
                9.82118900000000e00,
                8.18202500000000e00,
                6.94416600000000e00,
                5.98470000000000e00,
                5.22419900000000e00,
                4.10473300000000e00,
                3.32842200000000e00,
                2.76364600000000e00,
                2.33737100000000e00,
                2.00624700000000e00,
                1.43812600000000e00,
                1.08517900000000e00,
                6.84155000000000e-01,
                4.71994000000000e-01,
                2.34308000000000e-01,
                1.40349000000000e-01,
            ],
            [
                5.64761320000000e01,
                5.54404440000000e01,
                5.27176090000000e01,
                4.51454930000000e01,
                3.76466880000000e01,
                3.12740070000000e01,
                2.60862050000000e01,
                2.19197000000000e01,
                1.85802620000000e01,
                1.58937900000000e01,
                1.37180050000000e01,
                1.19412500000000e01,
                9.26070000000000e00,
                7.37782400000000e00,
                6.01168600000000e00,
                4.99175600000000e00,
                4.21121300000000e00,
                2.90831000000000e00,
                2.13071400000000e00,
                1.28740000000000e00,
                8.63157000000000e-01,
                4.11026000000000e-01,
                2.40639000000000e-01,
            ],
            [
                1.19606790000000e02,
                1.17361180000000e02,
                1.11454000000000e02,
                9.52456700000000e01,
                7.97390500000000e01,
                6.69517800000000e01,
                5.67007000000000e01,
                4.84921200000000e01,
                4.18757900000000e01,
                3.64928900000000e01,
                3.20685600000000e01,
                2.83948300000000e01,
                2.27080700000000e01,
                1.85713200000000e01,
                1.54707700000000e01,
                1.30875400000000e01,
                1.12163200000000e01,
                7.98167000000000e00,
                5.97081000000000e00,
                3.70561000000000e00,
                2.52625000000000e00,
                1.23285000000000e00,
                7.32560000000000e-01,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
        ],
        [
            [
                8.21201120000000e01,
                7.30648270000000e01,
                5.65578050000000e01,
                3.18457630000000e01,
                1.95848590000000e01,
                1.33420540000000e01,
                9.81973300000000e00,
                7.64161200000000e00,
                6.19316200000000e00,
                5.17339800000000e00,
                4.42219500000000e00,
                3.84826300000000e00,
                3.03201600000000e00,
                2.48034300000000e00,
                2.08247500000000e00,
                1.78186500000000e00,
                1.54685200000000e00,
                1.13710800000000e00,
                8.75749000000000e-01,
                5.68843000000000e-01,
                4.00345000000000e-01,
                2.04123000000000e-01,
                1.23665000000000e-01,
            ],
            [
                3.75942320000000e01,
                3.65102540000000e01,
                3.37065530000000e01,
                2.63778710000000e01,
                2.00194940000000e01,
                1.54093840000000e01,
                1.21689910000000e01,
                9.86091000000000e00,
                8.17464000000000e00,
                6.90899400000000e00,
                5.93481100000000e00,
                5.16786200000000e00,
                4.04863600000000e00,
                3.27988800000000e00,
                2.72438500000000e00,
                2.30694000000000e00,
                1.98348300000000e00,
                1.42909600000000e00,
                1.08400600000000e00,
                6.89557000000000e-01,
                4.78865000000000e-01,
                2.39760000000000e-01,
                1.43940000000000e-01,
            ],
            [
                4.88093290000000e01,
                4.80980790000000e01,
                4.61748290000000e01,
                4.04031130000000e01,
                3.41760690000000e01,
                2.86218290000000e01,
                2.39924040000000e01,
                2.02296980000000e01,
                1.71934700000000e01,
                1.47402990000000e01,
                1.27472650000000e01,
                1.11157910000000e01,
                8.64759300000000e00,
                6.90860800000000e00,
                5.64377100000000e00,
                4.69746600000000e00,
                3.97187500000000e00,
                2.75713200000000e00,
                2.02905100000000e00,
                1.23492900000000e00,
                8.32427000000000e-01,
                3.99451000000000e-01,
                2.34594000000000e-01,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
        ],
        [
            [
                6.51578920000000e01,
                5.74961000000000e01,
                4.33419800000000e01,
                2.38760970000000e01,
                1.51156130000000e01,
                1.07673250000000e01,
                8.27135400000000e00,
                6.66860500000000e00,
                5.55504300000000e00,
                4.73758400000000e00,
                4.11318700000000e00,
                3.62171900000000e00,
                2.89995800000000e00,
                2.39730900000000e00,
                2.02804800000000e00,
                1.74566200000000e00,
                1.52297300000000e00,
                1.13059900000000e00,
                8.77305000000000e-01,
                5.76370000000000e-01,
                4.09227000000000e-01,
                2.11859000000000e-01,
                1.29411000000000e-01,
            ],
            [
                3.45401790000000e01,
                3.35667420000000e01,
                3.11228640000000e01,
                2.47676090000000e01,
                1.90811590000000e01,
                1.48373870000000e01,
                1.17962700000000e01,
                9.60201500000000e00,
                7.98444800000000e00,
                6.76255100000000e00,
                5.81772400000000e00,
                5.07152700000000e00,
                3.97973300000000e00,
                3.22880800000000e00,
                2.68622500000000e00,
                2.27867200000000e00,
                1.96295400000000e00,
                1.42147200000000e00,
                1.08348600000000e00,
                6.95087000000000e-01,
                4.86081000000000e-01,
                2.46407000000000e-01,
                1.48956000000000e-01,
            ],
            [
                4.59056800000000e01,
                4.52093150000000e01,
                4.33396340000000e01,
                3.77811330000000e01,
                3.18440890000000e01,
                2.66022340000000e01,
                2.22699010000000e01,
                1.87694260000000e01,
                1.59553430000000e01,
                1.36865850000000e01,
                1.18454300000000e01,
                1.03389430000000e01,
                8.05960900000000e00,
                6.45247300000000e00,
                5.28228300000000e00,
                4.40575600000000e00,
                3.73283800000000e00,
                2.60385700000000e00,
                1.92485400000000e00,
                1.18058400000000e00,
                8.00768000000000e-01,
                3.88414000000000e-01,
                2.29532000000000e-01,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
        ],
        [
            [
                6.07910330000000e01,
                5.62385650000000e01,
                4.63237860000000e01,
                2.83000530000000e01,
                1.80784830000000e01,
                1.25506200000000e01,
                9.33295200000000e00,
                7.30603800000000e00,
                5.94163900000000e00,
                4.97294500000000e00,
                4.25527900000000e00,
                3.70505000000000e00,
                2.92124000000000e00,
                2.39257700000000e00,
                2.01312100000000e00,
                1.72786300000000e00,
                1.50570100000000e00,
                1.11912900000000e00,
                8.71549000000000e-01,
                5.77190000000000e-01,
                4.12665000000000e-01,
                2.16447000000000e-01,
                1.33319000000000e-01,
            ],
            [
                3.36766540000000e01,
                3.22795850000000e01,
                2.98110510000000e01,
                2.36860370000000e01,
                1.83057380000000e01,
                1.42980140000000e01,
                1.14150610000000e01,
                9.32445800000000e00,
                7.77579400000000e00,
                6.60083900000000e00,
                5.68888000000000e00,
                4.96636400000000e00,
                3.90557600000000e00,
                3.17379600000000e00,
                2.64434200000000e00,
                2.24650400000000e00,
                1.93831900000000e00,
                1.40967900000000e00,
                1.07921300000000e00,
                6.97843000000000e-01,
                4.91238000000000e-01,
                2.52109000000000e-01,
                1.53592000000000e-01,
            ],
            [
                3.30681610000000e01,
                3.18814040000000e01,
                2.93779300000000e01,
                2.36057900000000e01,
                1.86463550000000e01,
                1.49145580000000e01,
                1.21627890000000e01,
                1.01071300000000e01,
                8.53951700000000e00,
                7.31909700000000e00,
                6.35093100000000e00,
                5.56997400000000e00,
                4.40054000000000e00,
                3.57867900000000e00,
                2.97754600000000e00,
                2.52327700000000e00,
                2.17059400000000e00,
                1.56626900000000e00,
                1.19075600000000e00,
                7.61939000000000e-01,
                5.32588000000000e-01,
                2.70644000000000e-01,
                1.64092000000000e-01,
            ],
            [
                4.47198600000000e01,
                4.39726200000000e01,
                4.19679160000000e01,
                3.61202890000000e01,
                3.00864670000000e01,
                2.49191710000000e01,
                2.07437800000000e01,
                1.74226860000000e01,
                1.47811930000000e01,
                1.26668970000000e01,
                1.09594050000000e01,
                9.56680700000000e00,
                7.46559000000000e00,
                5.98668600000000e00,
                4.91031600000000e00,
                4.10382300000000e00,
                3.48422900000000e00,
                2.44290100000000e00,
                1.81456100000000e00,
                1.12227600000000e00,
                7.66421000000000e-01,
                3.76273000000000e-01,
                2.23999000000000e-01,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
        ],
        [
            [
                6.51471670000000e01,
                5.97497700000000e01,
                4.84286590000000e01,
                2.85849020000000e01,
                1.78269450000000e01,
                1.21955640000000e01,
                8.98660600000000e00,
                6.99426900000000e00,
                5.66753100000000e00,
                4.73357700000000e00,
                4.04637700000000e00,
                3.52237000000000e00,
                2.78014900000000e00,
                2.28208400000000e00,
                1.92562200000000e00,
                1.65807000000000e00,
                1.44982800000000e00,
                1.08715000000000e00,
                8.53784000000000e-01,
                5.73310000000000e-01,
                4.14084000000000e-01,
                2.20813000000000e-01,
                1.37377000000000e-01,
            ],
            [
                3.32010460000000e01,
                3.19092910000000e01,
                2.93670970000000e01,
                2.31912300000000e01,
                1.78686070000000e01,
                1.39453180000000e01,
                1.11368280000000e01,
                9.10419900000000e00,
                7.59921800000000e00,
                6.45706700000000e00,
                5.56992600000000e00,
                4.86641700000000e00,
                3.83209800000000e00,
                3.11748100000000e00,
                2.60002500000000e00,
                2.21114800000000e00,
                1.90998400000000e00,
                1.39370100000000e00,
                1.07097200000000e00,
                6.97587000000000e-01,
                4.94156000000000e-01,
                2.56639000000000e-01,
                1.57607000000000e-01,
            ],
            [
                4.38557940000000e01,
                4.29928330000000e01,
                4.07502500000000e01,
                3.44926310000000e01,
                2.83244810000000e01,
                2.32253070000000e01,
                1.92045670000000e01,
                1.60592920000000e01,
                1.35864050000000e01,
                1.16233040000000e01,
                1.00473580000000e01,
                8.76765800000000e00,
                6.84502100000000e00,
                5.49655200000000e00,
                4.51675100000000e00,
                3.78301100000000e00,
                3.21920300000000e00,
                2.27030700000000e00,
                1.69578800000000e00,
                1.05899300000000e00,
                7.28823000000000e-01,
                3.62709000000000e-01,
                2.17752000000000e-01,
            ],
            [
                4.69971430000000e01,
                4.57683980000000e01,
                4.26546550000000e01,
                3.48257600000000e01,
                2.80599290000000e01,
                2.28623880000000e01,
                1.88881430000000e01,
                1.58119240000000e01,
                1.33988200000000e01,
                1.14815020000000e01,
                9.93936200000000e00,
                8.68445800000000e00,
                6.79374100000000e00,
                5.46344200000000e00,
                4.49453500000000e00,
                3.76764200000000e00,
                3.20831300000000e00,
                2.26534700000000e00,
                1.69336700000000e00,
                1.05836200000000e00,
                7.28677000000000e-01,
                3.62770000000000e-01,
                2.17810000000000e-01,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
        ],
        [
            [
                5.17659850000000e01,
                4.64291690000000e01,
                3.60204980000000e01,
                2.05952700000000e01,
                1.32155350000000e01,
                9.45907400000000e00,
                7.29601200000000e00,
                5.91457500000000e00,
                4.95930200000000e00,
                4.25831300000000e00,
                3.72082200000000e00,
                3.29501000000000e00,
                2.66292900000000e00,
                2.21718600000000e00,
                1.88718900000000e00,
                1.63387400000000e00,
                1.43378100000000e00,
                1.08048600000000e00,
                8.50958000000000e-01,
                5.73910000000000e-01,
                4.16221000000000e-01,
                2.23936000000000e-01,
                1.40169000000000e-01,
            ],
            [
                3.22640590000000e01,
                3.07643190000000e01,
                2.73346460000000e01,
                1.99931860000000e01,
                1.46605450000000e01,
                1.11745880000000e01,
                8.85786700000000e00,
                7.25047400000000e00,
                6.08560200000000e00,
                5.20914100000000e00,
                4.52904300000000e00,
                3.98794400000000e00,
                3.18565600000000e00,
                2.62383500000000e00,
                2.21170700000000e00,
                1.89835800000000e00,
                1.65316700000000e00,
                1.22660600000000e00,
                9.54929000000000e-01,
                6.34040000000000e-01,
                4.55265000000000e-01,
                2.41516000000000e-01,
                1.50087000000000e-01,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
        ],
        [
            [
                4.48764280000000e01,
                4.24015380000000e01,
                3.65011020000000e01,
                2.40580460000000e01,
                1.59961690000000e01,
                1.13275720000000e01,
                8.51259800000000e00,
                6.70501100000000e00,
                5.47505100000000e00,
                4.59628000000000e00,
                3.94260600000000e00,
                3.43996900000000e00,
                2.72160700000000e00,
                2.23550200000000e00,
                1.88609700000000e00,
                1.62355200000000e00,
                1.41945600000000e00,
                1.06572100000000e00,
                8.39896000000000e-01,
                5.69878000000000e-01,
                4.16179000000000e-01,
                2.27177000000000e-01,
                1.43800000000000e-01,
            ],
            [
                2.92304490000000e01,
                2.86434220000000e01,
                2.70389880000000e01,
                2.22870810000000e01,
                1.75546960000000e01,
                1.38059590000000e01,
                1.10322270000000e01,
                8.99763800000000e00,
                7.48581600000000e00,
                6.33990400000000e00,
                5.45287200000000e00,
                4.75237600000000e00,
                3.72866300000000e00,
                3.02649400000000e00,
                2.52104600000000e00,
                2.14306100000000e00,
                1.85157700000000e00,
                1.35475100000000e00,
                1.04599100000000e00,
                6.89336000000000e-01,
                4.93942000000000e-01,
                2.62494000000000e-01,
                1.63864000000000e-01,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
        ],
        [
            [
                5.62798430000000e01,
                5.19167870000000e01,
                4.32310870000000e01,
                2.81416200000000e01,
                1.88462820000000e01,
                1.32994650000000e01,
                9.86004500000000e00,
                7.61939800000000e00,
                6.08946200000000e00,
                5.00076400000000e00,
                4.19818200000000e00,
                3.58847600000000e00,
                2.73474400000000e00,
                2.17388400000000e00,
                1.78181100000000e00,
                1.49440900000000e00,
                1.27581200000000e00,
                9.08619000000000e-01,
                6.83973000000000e-01,
                4.30069000000000e-01,
                2.95904000000000e-01,
                1.45899000000000e-01,
                8.67970000000000e-02,
            ],
            [
                5.33046110000000e01,
                4.99067250000000e01,
                4.26926500000000e01,
                2.92253470000000e01,
                2.04243950000000e01,
                1.48882280000000e01,
                1.12916180000000e01,
                8.85922700000000e00,
                7.15005500000000e00,
                5.90733000000000e00,
                4.97638800000000e00,
                4.26073500000000e00,
                3.24712500000000e00,
                2.57514500000000e00,
                2.10367300000000e00,
                1.75795900000000e00,
                1.49545200000000e00,
                1.05673900000000e00,
                7.90728000000000e-01,
                4.93305000000000e-01,
                3.37804000000000e-01,
                1.65477000000000e-01,
                9.80990000000000e-02,
            ],
            [
                4.06953470000000e01,
                3.86598060000000e01,
                3.49271010000000e01,
                2.70292080000000e01,
                2.05104160000000e01,
                1.57311360000000e01,
                1.23171900000000e01,
                9.86263900000000e00,
                8.06552100000000e00,
                6.72101700000000e00,
                5.69315300000000e00,
                4.89126300000000e00,
                3.73910500000000e00,
                2.96593100000000e00,
                2.42005600000000e00,
                2.01868700000000e00,
                1.71374100000000e00,
                1.20497700000000e00,
                8.97962000000000e-01,
                5.57065000000000e-01,
                3.80155000000000e-01,
                1.85367000000000e-01,
                1.09629000000000e-01,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
        ],
        [
            [
                4.16184280000000e01,
                3.99833160000000e01,
                3.59872960000000e01,
                2.66103970000000e01,
                1.92286830000000e01,
                1.41743150000000e01,
                1.07638470000000e01,
                8.41795000000000e00,
                6.75879600000000e00,
                5.55148200000000e00,
                4.64931800000000e00,
                3.95882700000000e00,
                2.98875600000000e00,
                2.35350800000000e00,
                1.91313900000000e00,
                1.59373600000000e00,
                1.35348100000000e00,
                9.56617000000000e-01,
                7.18490000000000e-01,
                4.52963000000000e-01,
                3.13250000000000e-01,
                1.56123000000000e-01,
                9.35260000000000e-02,
            ],
            [
                4.04520440000000e01,
                3.90264160000000e01,
                3.55809840000000e01,
                2.73666530000000e01,
                2.05342330000000e01,
                1.55791490000000e01,
                1.20769830000000e01,
                9.58215400000000e00,
                7.77082700000000e00,
                6.42647700000000e00,
                5.40667100000000e00,
                4.61706000000000e00,
                3.49439000000000e00,
                2.75119700000000e00,
                2.23287100000000e00,
                1.85582200000000e00,
                1.57196200000000e00,
                1.10377900000000e00,
                8.24316000000000e-01,
                5.15407000000000e-01,
                3.54562000000000e-01,
                1.75462000000000e-01,
                1.04725000000000e-01,
            ],
            [
                4.04418220000000e01,
                3.92545360000000e01,
                3.62478860000000e01,
                2.86222220000000e01,
                2.19792320000000e01,
                1.69925560000000e01,
                1.33626540000000e01,
                1.07138950000000e01,
                8.75397100000000e00,
                7.27768300000000e00,
                6.14487900000000e00,
                5.25994300000000e00,
                3.99001800000000e00,
                3.14218300000000e00,
                2.54800200000000e00,
                2.11469300000000e00,
                1.78817200000000e00,
                1.24999500000000e00,
                9.29818000000000e-01,
                5.78012000000000e-01,
                3.96169000000000e-01,
                1.95088000000000e-01,
                1.16142000000000e-01,
            ],
            [
                3.76716300000000e01,
                3.68525860000000e01,
                3.46926590000000e01,
                2.86826580000000e01,
                2.28485090000000e01,
                1.81179570000000e01,
                1.44936950000000e01,
                1.17568160000000e01,
                9.68318100000000e00,
                8.09467700000000e00,
                6.86063800000000e00,
                5.88770700000000e00,
                4.47840200000000e00,
                3.52955100000000e00,
                2.86131700000000e00,
                2.37269300000000e00,
                2.00402900000000e00,
                1.39637300000000e00,
                1.03561500000000e00,
                6.40959000000000e-01,
                4.38122000000000e-01,
                2.15038000000000e-01,
                1.27832000000000e-01,
            ],
            [
                3.49443880000000e01,
                3.44589550000000e01,
                3.30932300000000e01,
                2.86849650000000e01,
                2.36815050000000e01,
                1.92193090000000e01,
                1.56074480000000e01,
                1.27869910000000e01,
                1.06029230000000e01,
                8.90459500000000e00,
                7.57106900000000e00,
                6.51142400000000e00,
                4.96439500000000e00,
                3.91546900000000e00,
                3.17374000000000e00,
                2.63014800000000e00,
                2.21956400000000e00,
                1.54272500000000e00,
                1.14152200000000e00,
                7.04137000000000e-01,
                4.80353000000000e-01,
                2.35271000000000e-01,
                1.39760000000000e-01,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
        ],
        [
            [
                3.09622720000000e01,
                3.02682480000000e01,
                2.84117290000000e01,
                2.31419060000000e01,
                1.80459760000000e01,
                1.40238200000000e01,
                1.10354630000000e01,
                8.83746300000000e00,
                7.20650300000000e00,
                5.97746000000000e00,
                5.03520700000000e00,
                4.30040400000000e00,
                3.24961900000000e00,
                2.55212000000000e00,
                2.06624000000000e00,
                1.71393000000000e00,
                1.44979100000000e00,
                1.01720000000000e00,
                7.61236000000000e-01,
                4.79810000000000e-01,
                3.32960000000000e-01,
                1.67380000000000e-01,
                1.00787000000000e-01,
            ],
            [
                3.29857230000000e01,
                3.22738720000000e01,
                3.03903080000000e01,
                2.50725470000000e01,
                1.98545550000000e01,
                1.56403290000000e01,
                1.24395230000000e01,
                1.00416420000000e01,
                8.23630300000000e00,
                6.86026300000000e00,
                5.79580100000000e00,
                4.95975200000000e00,
                3.75489700000000e00,
                2.94911900000000e00,
                2.38519900000000e00,
                1.97521500000000e00,
                1.66745600000000e00,
                1.16353100000000e00,
                8.66261000000000e-01,
                5.41615000000000e-01,
                3.73843000000000e-01,
                1.86653000000000e-01,
                1.12054000000000e-01,
            ],
            [
                3.45403260000000e01,
                3.38506380000000e01,
                3.20374310000000e01,
                2.68393630000000e01,
                2.15730010000000e01,
                1.71996430000000e01,
                1.38049410000000e01,
                1.12190870000000e01,
                9.24731500000000e00,
                7.72964400000000e00,
                6.54663900000000e00,
                5.61188900000000e00,
                4.25605000000000e00,
                3.34363900000000e00,
                2.70261500000000e00,
                2.23551800000000e00,
                1.88449100000000e00,
                1.30968000000000e00,
                9.71287000000000e-01,
                6.03554000000000e-01,
                4.14892000000000e-01,
                2.06085000000000e-01,
                1.23448000000000e-01,
            ],
            [
                3.55626970000000e01,
                3.49738250000000e01,
                3.33553240000000e01,
                2.84265670000000e01,
                2.31867600000000e01,
                1.86947170000000e01,
                1.51290090000000e01,
                1.23689250000000e01,
                1.02393320000000e01,
                8.58559500000000e00,
                7.28773700000000e00,
                6.25679400000000e00,
                4.75295900000000e00,
                3.73549300000000e00,
                3.01826300000000e00,
                2.49459700000000e00,
                2.10064900000000e00,
                1.45539500000000e00,
                1.07606500000000e00,
                6.65378000000000e-01,
                4.55874000000000e-01,
                2.25499000000000e-01,
                1.34845000000000e-01,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
        ],
        [
            [
                2.57234860000000e01,
                2.52967560000000e01,
                2.41266960000000e01,
                2.05754680000000e01,
                1.68021780000000e01,
                1.35652820000000e01,
                1.09952140000000e01,
                9.00463900000000e00,
                7.46670800000000e00,
                6.27013900000000e00,
                5.32908600000000e00,
                4.58007400000000e00,
                3.48494800000000e00,
                2.74246500000000e00,
                2.21860000000000e00,
                1.83606600000000e00,
                1.54837500000000e00,
                1.07751800000000e00,
                8.00872000000000e-01,
                5.00784000000000e-01,
                3.46626000000000e-01,
                1.74616000000000e-01,
                1.05570000000000e-01,
            ],
            [
                2.85144970000000e01,
                2.80475240000000e01,
                2.67740720000000e01,
                2.29293920000000e01,
                1.88329680000000e01,
                1.52899050000000e01,
                1.24503800000000e01,
                1.02324530000000e01,
                8.50695000000000e00,
                7.15705300000000e00,
                6.09079500000000e00,
                5.23917500000000e00,
                3.98922600000000e00,
                3.13850900000000e00,
                2.53676600000000e00,
                2.09669000000000e00,
                1.76546900000000e00,
                1.22338600000000e00,
                9.05468000000000e-01,
                5.62191000000000e-01,
                3.87153000000000e-01,
                1.93667000000000e-01,
                1.16708000000000e-01,
            ],
            [
                3.09890680000000e01,
                3.05032140000000e01,
                2.91715810000000e01,
                2.51156940000000e01,
                2.07515920000000e01,
                1.69397500000000e01,
                1.38556780000000e01,
                1.14267060000000e01,
                9.52422900000000e00,
                8.02791900000000e00,
                6.84103100000000e00,
                5.88989100000000e00,
                4.48875000000000e00,
                3.53167800000000e00,
                2.85310700000000e00,
                2.35611400000000e00,
                1.98175400000000e00,
                1.36893600000000e00,
                1.00995100000000e00,
                6.23645000000000e-01,
                4.27779000000000e-01,
                2.12840000000000e-01,
                1.27954000000000e-01,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
        ],
        [
            [
                2.08160780000000e01,
                2.05760200000000e01,
                1.98987130000000e01,
                1.76813900000000e01,
                1.50736970000000e01,
                1.26318500000000e01,
                1.05528970000000e01,
                8.85248100000000e00,
                7.48129000000000e00,
                6.37741600000000e00,
                5.48489400000000e00,
                4.75815300000000e00,
                3.66763600000000e00,
                2.90823700000000e00,
                2.36241000000000e00,
                1.95875100000000e00,
                1.65260300000000e00,
                1.14794600000000e00,
                8.50671000000000e-01,
                5.29731000000000e-01,
                3.66379000000000e-01,
                1.85432000000000e-01,
                1.12745000000000e-01,
            ],
            [
                2.37818040000000e01,
                2.35043600000000e01,
                2.27232600000000e01,
                2.01781530000000e01,
                1.71975750000000e01,
                1.44112140000000e01,
                1.20390110000000e01,
                1.00975330000000e01,
                8.53096900000000e00,
                7.26930500000000e00,
                6.24902600000000e00,
                5.41823500000000e00,
                4.17168200000000e00,
                3.30375400000000e00,
                2.68001900000000e00,
                2.21884600000000e00,
                1.86919200000000e00,
                1.29331900000000e00,
                9.54754000000000e-01,
                5.90606000000000e-01,
                4.06397000000000e-01,
                2.04111000000000e-01,
                1.23635000000000e-01,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
        ],
        [
            [
                1.68771250000000e01,
                1.67404080000000e01,
                1.63473440000000e01,
                1.49868570000000e01,
                1.32465280000000e01,
                1.14802080000000e01,
                9.86979900000000e00,
                8.47732400000000e00,
                7.30350500000000e00,
                6.32437400000000e00,
                5.50960500000000e00,
                4.83026600000000e00,
                3.78251300000000e00,
                3.03136600000000e00,
                2.47978000000000e00,
                2.06532800000000e00,
                1.74727600000000e00,
                1.21644100000000e00,
                9.00720000000000e-01,
                5.59163000000000e-01,
                3.86125000000000e-01,
                1.95908000000000e-01,
                1.19708000000000e-01,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
        ],
        [
            [
                4.10157065000000e02,
                2.14362942000000e02,
                9.22189500000000e01,
                3.30762760000000e01,
                1.91702550000000e01,
                1.36453490000000e01,
                1.06953320000000e01,
                8.81150100000000e00,
                7.46995300000000e00,
                6.44873800000000e00,
                5.63812400000000e00,
                4.97666300000000e00,
                3.96199600000000e00,
                3.22444600000000e00,
                2.66975100000000e00,
                2.24210500000000e00,
                1.90591700000000e00,
                1.32629000000000e00,
                9.69886000000000e-01,
                5.77583000000000e-01,
                3.80457000000000e-01,
                1.74357000000000e-01,
                9.92380000000000e-02,
            ],
            [
                6.21046880000000e01,
                5.53737420000000e01,
                4.35682870000000e01,
                2.74983580000000e01,
                1.95497690000000e01,
                1.50663500000000e01,
                1.21785660000000e01,
                1.01413920000000e01,
                8.61582600000000e00,
                7.42685800000000e00,
                6.47409400000000e00,
                5.69490600000000e00,
                4.50314600000000e00,
                3.64354900000000e00,
                3.00247700000000e00,
                2.51197500000000e00,
                2.12885700000000e00,
                1.47371900000000e00,
                1.07433700000000e00,
                6.37708000000000e-01,
                4.19426000000000e-01,
                1.91938000000000e-01,
                1.09190000000000e-01,
            ],
            [
                1.26631002900000e02,
                1.25155905800000e02,
                1.21074278800000e02,
                1.08348290100000e02,
                9.41247762000000e01,
                8.10337905000000e01,
                6.97439741000000e01,
                6.02269348000000e01,
                5.22628997000000e01,
                4.56040488000000e01,
                4.00235464000000e01,
                3.53278801000000e01,
                2.79808202000000e01,
                2.26114560000000e01,
                1.85992009000000e01,
                1.55379934000000e01,
                1.31579386000000e01,
                9.12000870000000e00,
                6.68124080000000e00,
                4.03092980000000e00,
                2.70539160000000e00,
                1.30528100000000e00,
                7.78174900000000e-01,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
        ],
        [
            [
                2.07095983000000e02,
                1.67406264000000e02,
                1.07539519000000e02,
                4.68864590000000e01,
                2.62027860000000e01,
                1.74151700000000e01,
                1.28603380000000e01,
                1.01317340000000e01,
                8.31698100000000e00,
                7.01560000000000e00,
                6.03054500000000e00,
                5.25541100000000e00,
                4.10954200000000e00,
                3.30419000000000e00,
                2.71155600000000e00,
                2.26172600000000e00,
                1.91230400000000e00,
                1.31856100000000e00,
                9.58995000000000e-01,
                5.67999000000000e-01,
                3.73306000000000e-01,
                1.70832000000000e-01,
                9.72390000000000e-02,
            ],
            [
                2.03756962000000e02,
                1.36252038000000e02,
                7.93342830000000e01,
                3.90709150000000e01,
                2.48495540000000e01,
                1.78598820000000e01,
                1.37760240000000e01,
                1.11115300000000e01,
                9.23478700000000e00,
                7.83828800000000e00,
                6.75670000000000e00,
                5.89384500000000e00,
                4.60589400000000e00,
                3.69680500000000e00,
                3.02818600000000e00,
                2.52173300000000e00,
                2.12926400000000e00,
                1.46470600000000e00,
                1.06382900000000e00,
                6.29274000000000e-01,
                4.13377000000000e-01,
                1.89124000000000e-01,
                1.07656000000000e-01,
            ],
            [
                5.67366690000000e01,
                5.38312150000000e01,
                4.72695200000000e01,
                3.39461020000000e01,
                2.48182410000000e01,
                1.89521460000000e01,
                1.50374310000000e01,
                1.22916810000000e01,
                1.02772390000000e01,
                8.74330900000000e00,
                7.53998500000000e00,
                6.57351000000000e00,
                5.12558400000000e00,
                4.10352600000000e00,
                3.35357500000000e00,
                2.78717400000000e00,
                2.34949900000000e00,
                1.61135500000000e00,
                1.16811500000000e00,
                6.89506000000000e-01,
                4.52465000000000e-01,
                2.06769000000000e-01,
                1.17643000000000e-01,
            ],
            [
                1.16450584900000e02,
                1.14196884400000e02,
                1.08296355500000e02,
                9.21203844000000e01,
                7.67209726000000e01,
                6.43033634000000e01,
                5.45977463000000e01,
                4.69458079000000e01,
                4.08022639000000e01,
                3.57806868000000e01,
                3.16136150000000e01,
                2.81128216000000e01,
                2.25997820000000e01,
                1.85077567000000e01,
                1.53957648000000e01,
                1.29813495000000e01,
                1.10757782000000e01,
                7.77573520000000e00,
                5.73458160000000e00,
                3.46766380000000e00,
                2.31329690000000e00,
                1.08425470000000e00,
                6.26241500000000e-01,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
        ],
        [
            [
                1.56581653000000e02,
                1.33409657000000e02,
                9.46810390000000e01,
                4.71887390000000e01,
                2.78621270000000e01,
                1.88348770000000e01,
                1.39092620000000e01,
                1.08900460000000e01,
                8.87302200000000e00,
                7.43526700000000e00,
                6.35855000000000e00,
                5.52113900000000e00,
                4.30147300000000e00,
                3.45666000000000e00,
                2.83992600000000e00,
                2.37340800000000e00,
                2.01126100000000e00,
                1.39457700000000e00,
                1.01905100000000e00,
                6.07535000000000e-01,
                4.00891000000000e-01,
                1.84354000000000e-01,
                1.05142000000000e-01,
            ],
            [
                1.26805232000000e02,
                8.87747170000000e01,
                6.41464690000000e01,
                4.02998810000000e01,
                2.82499780000000e01,
                2.10643660000000e01,
                1.64186290000000e01,
                1.32334170000000e01,
                1.09441490000000e01,
                9.23395200000000e00,
                7.91513400000000e00,
                6.87132700000000e00,
                5.33303700000000e00,
                4.26363900000000e00,
                3.48554600000000e00,
                2.90025500000000e00,
                2.44859600000000e00,
                1.68616400000000e00,
                1.22660600000000e00,
                7.27519000000000e-01,
                4.78764000000000e-01,
                2.19488000000000e-01,
                1.25019000000000e-01,
            ],
            [
                5.19455750000000e01,
                5.04162010000000e01,
                4.65373240000000e01,
                3.66790590000000e01,
                2.81986330000000e01,
                2.19785510000000e01,
                1.75295770000000e01,
                1.43039920000000e01,
                1.19077650000000e01,
                1.00810740000000e01,
                8.65470100000000e00,
                7.51709700000000e00,
                5.83101000000000e00,
                4.65556800000000e00,
                3.80042400000000e00,
                3.15798000000000e00,
                2.66301600000000e00,
                1.82965900000000e00,
                1.32898800000000e00,
                7.86886000000000e-01,
                5.17375000000000e-01,
                2.36961000000000e-01,
                1.34916000000000e-01,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
        ],
        [
            [
                1.29164925000000e02,
                1.12911526000000e02,
                8.42744150000000e01,
                4.52123570000000e01,
                2.76899320000000e01,
                1.90856380000000e01,
                1.42390790000000e01,
                1.12024000000000e01,
                9.14477600000000e00,
                7.66666600000000e00,
                6.55636900000000e00,
                5.69281800000000e00,
                4.43821100000000e00,
                3.57263000000000e00,
                2.94220100000000e00,
                2.46547800000000e00,
                2.09497800000000e00,
                1.46169000000000e00,
                1.07345400000000e00,
                6.44436000000000e-01,
                4.27085000000000e-01,
                1.97477000000000e-01,
                1.12889000000000e-01,
            ],
            [
                5.95329360000000e01,
                5.90731440000000e01,
                4.93004260000000e01,
                3.56901590000000e01,
                2.65930640000000e01,
                2.04777520000000e01,
                1.62621680000000e01,
                1.32552040000000e01,
                1.10380980000000e01,
                9.35433900000000e00,
                8.04238500000000e00,
                6.99736300000000e00,
                5.44959300000000e00,
                4.36986000000000e00,
                3.58254500000000e00,
                2.98906100000000e00,
                2.53000900000000e00,
                1.75184200000000e00,
                1.27987300000000e00,
                7.63597000000000e-01,
                5.04335000000000e-01,
                2.32273000000000e-01,
                1.32563000000000e-01,
            ],
            [
                5.37033680000000e01,
                5.23694770000000e01,
                4.88771380000000e01,
                3.94788990000000e01,
                3.09424830000000e01,
                2.44286920000000e01,
                1.96266710000000e01,
                1.60687640000000e01,
                1.33881100000000e01,
                1.13281120000000e01,
                9.71375200000000e00,
                8.42539000000000e00,
                6.51986700000000e00,
                5.19778200000000e00,
                4.24038300000000e00,
                3.52359000000000e00,
                2.97255400000000e00,
                2.04608400000000e00,
                1.48923200000000e00,
                8.84724000000000e-01,
                5.83020000000000e-01,
                2.67810000000000e-01,
                1.52673000000000e-01,
            ],
            [
                3.36465243000000e01,
                3.34038388000000e01,
                3.27056564000000e01,
                3.02880677000000e01,
                2.72060499000000e01,
                2.40984692000000e01,
                2.12765610000000e01,
                1.88296599000000e01,
                1.67447048000000e01,
                1.49743210000000e01,
                1.34663529000000e01,
                1.21742122000000e01,
                1.00904600000000e01,
                8.49696860000000e00,
                7.24913790000000e00,
                6.25269610000000e00,
                5.44411070000000e00,
                3.98368700000000e00,
                3.03069740000000e00,
                1.91212500000000e00,
                1.31098130000000e00,
                6.38883100000000e-01,
                3.76642400000000e-01,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
        ],
        [
            [
                1.12586822000000e02,
                9.89946210000000e01,
                7.55219100000000e01,
                4.25430350000000e01,
                2.68101620000000e01,
                1.87904950000000e01,
                1.41713590000000e01,
                1.12319370000000e01,
                9.21659400000000e00,
                7.75567000000000e00,
                6.65086200000000e00,
                5.78748000000000e00,
                4.52792700000000e00,
                3.65640200000000e00,
                3.02062700000000e00,
                2.53908600000000e00,
                2.16406900000000e00,
                1.52024400000000e00,
                1.12262400000000e00,
                6.79094000000000e-01,
                4.52131000000000e-01,
                2.10232000000000e-01,
                1.20456000000000e-01,
            ],
            [
                5.59986780000000e01,
                6.08749560000000e01,
                5.06953400000000e01,
                3.56643390000000e01,
                2.64531740000000e01,
                2.04359360000000e01,
                1.62988900000000e01,
                1.33351670000000e01,
                1.11377280000000e01,
                9.46049500000000e00,
                8.14846300000000e00,
                7.10041800000000e00,
                5.54435200000000e00,
                4.45694300000000e00,
                3.66320700000000e00,
                3.06418200000000e00,
                2.60011600000000e00,
                1.81073800000000e00,
                1.32912200000000e00,
                7.98216000000000e-01,
                5.29355000000000e-01,
                2.45055000000000e-01,
                1.40174000000000e-01,
            ],
            [
                5.13329100000000e01,
                4.90284950000000e01,
                4.46433950000000e01,
                3.53677840000000e01,
                2.76830280000000e01,
                2.19413960000000e01,
                1.77220800000000e01,
                1.45880150000000e01,
                1.22159700000000e01,
                1.03838810000000e01,
                8.94104400000000e00,
                7.78435100000000e00,
                6.06376900000000e00,
                4.86195100000000e00,
                3.98657800000000e00,
                3.32771100000000e00,
                2.81867300000000e00,
                1.95629600000000e00,
                1.43271500000000e00,
                8.58157000000000e-01,
                5.68318000000000e-01,
                2.62695000000000e-01,
                1.50175000000000e-01,
            ],
            [
                3.92699458000000e01,
                3.89559085000000e01,
                3.80619736000000e01,
                3.50545164000000e01,
                3.13566941000000e01,
                2.77212247000000e01,
                2.44670081000000e01,
                2.16658391000000e01,
                1.92870190000000e01,
                1.72695766000000e01,
                1.55513454000000e01,
                1.40783331000000e01,
                1.17000325000000e01,
                9.87760540000000e00,
                8.44728700000000e00,
                7.30240410000000e00,
                6.37109830000000e00,
                4.68229740000000e00,
                3.57425340000000e00,
                2.26575690000000e00,
                1.55819610000000e00,
                7.62596600000000e-01,
                4.50549400000000e-01,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
        ],
        [
            [
                8.01166370000000e01,
                7.20033490000000e01,
                5.63464510000000e01,
                3.33622730000000e01,
                2.22521730000000e01,
                1.63666450000000e01,
                1.28045350000000e01,
                1.04296810000000e01,
                8.73526800000000e00,
                7.46562600000000e00,
                6.47893400000000e00,
                5.69048600000000e00,
                4.51151600000000e00,
                3.67586500000000e00,
                3.05662100000000e00,
                2.58261000000000e00,
                2.21064100000000e00,
                1.56625600000000e00,
                1.16414700000000e00,
                7.10637000000000e-01,
                4.75829000000000e-01,
                2.22808000000000e-01,
                1.28023000000000e-01,
            ],
            [
                5.73696220000000e01,
                5.36619600000000e01,
                4.64519190000000e01,
                3.37721100000000e01,
                2.53796990000000e01,
                1.98008640000000e01,
                1.59255030000000e01,
                1.31223040000000e01,
                1.10249000000000e01,
                9.41078800000000e00,
                8.13896200000000e00,
                7.11669300000000e00,
                5.58783400000000e00,
                4.51138800000000e00,
                3.72146500000000e00,
                3.12292100000000e00,
                2.65769300000000e00,
                1.86257000000000e00,
                1.37424400000000e00,
                8.31550000000000e-01,
                5.54164000000000e-01,
                2.58173000000000e-01,
                1.48084000000000e-01,
            ],
            [
                6.72624950000000e01,
                6.60303950000000e01,
                6.27575620000000e01,
                5.35269770000000e01,
                4.43751560000000e01,
                3.66776440000000e01,
                3.04829790000000e01,
                2.55527440000000e01,
                2.16261800000000e01,
                1.84804960000000e01,
                1.59392930000000e01,
                1.38670690000000e01,
                1.07428020000000e01,
                8.54724900000000e00,
                6.95237100000000e00,
                5.76015200000000e00,
                4.84681200000000e00,
                3.32111900000000e00,
                2.41149700000000e00,
                1.43031900000000e00,
                9.42506000000000e-01,
                4.33342000000000e-01,
                2.47221000000000e-01,
            ],
            [
                5.71122440000000e01,
                5.45507140000000e01,
                4.98607540000000e01,
                4.05094150000000e01,
                3.27396620000000e01,
                2.66350470000000e01,
                2.19139730000000e01,
                1.82593580000000e01,
                1.54061580000000e01,
                1.31523240000000e01,
                1.13489830000000e01,
                9.88754400000000e00,
                7.69395700000000e00,
                6.15407600000000e00,
                5.03264600000000e00,
                4.19072100000000e00,
                3.54246100000000e00,
                2.45026400000000e00,
                1.79141500000000e00,
                1.07189800000000e00,
                7.09912000000000e-01,
                3.28404000000000e-01,
                1.87852000000000e-01,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
        ],
        [
            [
                9.29387160000000e01,
                8.19452450000000e01,
                6.33698580000000e01,
                3.73296730000000e01,
                2.43564850000000e01,
                1.74779390000000e01,
                1.34110250000000e01,
                1.07755340000000e01,
                8.94297900000000e00,
                7.59866000000000e00,
                6.57120300000000e00,
                5.76050700000000e00,
                4.56317000000000e00,
                3.72271100000000e00,
                3.10245200000000e00,
                2.62813700000000e00,
                2.25567600000000e00,
                1.60850800000000e00,
                1.20228900000000e00,
                7.40278000000000e-01,
                4.98615000000000e-01,
                2.35388000000000e-01,
                1.35759000000000e-01,
            ],
            [
                7.58730320000000e01,
                6.59104100000000e01,
                5.19040420000000e01,
                3.47083320000000e01,
                2.54784390000000e01,
                1.97433960000000e01,
                1.58501840000000e01,
                1.30603640000000e01,
                1.09826550000000e01,
                9.38757600000000e00,
                8.13204800000000e00,
                7.12294200000000e00,
                5.61214100000000e00,
                4.54574700000000e00,
                3.76095100000000e00,
                3.16463200000000e00,
                2.69992900000000e00,
                1.90260500000000e00,
                1.41027600000000e00,
                8.59403000000000e-01,
                5.75519000000000e-01,
                2.69922000000000e-01,
                1.55294000000000e-01,
            ],
            [
                5.85751980000000e01,
                5.77047570000000e01,
                5.53283600000000e01,
                4.81684600000000e01,
                4.05340630000000e01,
                3.38274610000000e01,
                2.83028200000000e01,
                2.38467240000000e01,
                2.02669430000000e01,
                1.73809560000000e01,
                1.50378770000000e01,
                1.31192270000000e01,
                1.02118960000000e01,
                8.15709400000000e00,
                6.65750300000000e00,
                5.53212700000000e00,
                4.66707700000000e00,
                3.21520400000000e00,
                2.34437000000000e00,
                1.39879700000000e00,
                9.25315000000000e-01,
                4.27669000000000e-01,
                2.44583000000000e-01,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
        ],
        [
            [
                6.42873650000000e01,
                5.82984130000000e01,
                4.66241190000000e01,
                2.89081460000000e01,
                1.98860070000000e01,
                1.49414970000000e01,
                1.18820490000000e01,
                9.80673700000000e00,
                8.30509100000000e00,
                7.16690300000000e00,
                6.27368600000000e00,
                5.55360600000000e00,
                4.46385600000000e00,
                3.67925100000000e00,
                3.08944800000000e00,
                2.63222600000000e00,
                2.26948200000000e00,
                1.63170900000000e00,
                1.22667300000000e00,
                7.61368000000000e-01,
                5.15611000000000e-01,
                2.45321000000000e-01,
                1.42030000000000e-01,
            ],
            [
                4.57015170000000e01,
                4.41640550000000e01,
                4.00828620000000e01,
                3.09952860000000e01,
                2.38618350000000e01,
                1.88259100000000e01,
                1.52521470000000e01,
                1.26439180000000e01,
                1.06826650000000e01,
                9.16764200000000e00,
                7.96970900000000e00,
                7.00338800000000e00,
                5.55018900000000e00,
                4.51873200000000e00,
                3.75562400000000e00,
                3.17284100000000e00,
                2.71652600000000e00,
                1.92813000000000e00,
                1.43705600000000e00,
                8.82577000000000e-01,
                5.94137000000000e-01,
                2.80742000000000e-01,
                1.62118000000000e-01,
            ],
            [
                5.36449610000000e01,
                5.29021650000000e01,
                5.08530030000000e01,
                4.45291150000000e01,
                3.76245730000000e01,
                3.14884170000000e01,
                2.64097500000000e01,
                2.23040630000000e01,
                1.90002040000000e01,
                1.63321480000000e01,
                1.41620830000000e01,
                1.23817320000000e01,
                9.67636000000000e00,
                7.75701100000000e00,
                6.35123800000000e00,
                5.29275300000000e00,
                4.47662300000000e00,
                3.10065900000000e00,
                2.27046100000000e00,
                1.36304700000000e00,
                9.05393000000000e-01,
                4.20911000000000e-01,
                2.41416000000000e-01,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
        ],
        [
            [
                6.81542450000000e01,
                6.29960050000000e01,
                5.20807400000000e01,
                3.29144330000000e01,
                2.21117060000000e01,
                1.61257920000000e01,
                1.25115460000000e01,
                1.01406800000000e01,
                8.47880700000000e00,
                7.25251500000000e00,
                6.31084900000000e00,
                5.56475900000000e00,
                4.45639700000000e00,
                3.67174000000000e00,
                3.08731400000000e00,
                2.63616200000000e00,
                2.27861500000000e00,
                1.64868700000000e00,
                1.24626500000000e00,
                7.79926000000000e-01,
                5.31143000000000e-01,
                2.54701000000000e-01,
                1.48012000000000e-01,
            ],
            [
                4.33417530000000e01,
                4.14841810000000e01,
                3.75198890000000e01,
                2.90651560000000e01,
                2.25178410000000e01,
                1.78848750000000e01,
                1.45797210000000e01,
                1.21532300000000e01,
                1.03179030000000e01,
                8.89238600000000e00,
                7.75967000000000e00,
                6.84195200000000e00,
                5.45423500000000e00,
                4.46280300000000e00,
                3.72512600000000e00,
                3.15888900000000e00,
                2.71348400000000e00,
                1.93885900000000e00,
                1.45243000000000e00,
                8.98552000000000e-01,
                6.07894000000000e-01,
                2.89287000000000e-01,
                1.67629000000000e-01,
            ],
            [
                3.77442490000000e01,
                3.66313080000000e01,
                3.40210470000000e01,
                2.79047180000000e01,
                2.26219420000000e01,
                1.85364410000000e01,
                1.54279090000000e01,
                1.30366770000000e01,
                1.11653460000000e01,
                9.67529300000000e00,
                8.46973000000000e00,
                7.48021400000000e00,
                5.96564500000000e00,
                4.87380200000000e00,
                4.05877200000000e00,
                3.43310200000000e00,
                2.94171300000000e00,
                2.09062900000000e00,
                1.55971100000000e00,
                9.59748000000000e-01,
                6.47266000000000e-01,
                3.06922000000000e-01,
                1.77624000000000e-01,
            ],
            [
                5.07362600000000e01,
                4.94436100000000e01,
                4.62123700000000e01,
                3.77336800000000e01,
                3.00265600000000e01,
                2.41196600000000e01,
                1.97259100000000e01,
                1.64228700000000e01,
                1.38898500000000e01,
                1.19075300000000e01,
                1.03272700000000e01,
                9.04681000000000e00,
                7.11814000000000e00,
                5.75356000000000e00,
                4.75065000000000e00,
                3.99069000000000e00,
                3.40031000000000e00,
                2.39202000000000e00,
                1.77261000000000e00,
                1.08191000000000e00,
                7.26270000000000e-01,
                3.42440000000000e-01,
                1.97700000000000e-01,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
        ],
        [
            [
                6.08864630000000e01,
                5.68478940000000e01,
                4.78540600000000e01,
                3.09841900000000e01,
                2.10472500000000e01,
                1.54485530000000e01,
                1.20425860000000e01,
                9.79846900000000e00,
                8.22043200000000e00,
                7.05298900000000e00,
                6.15453100000000e00,
                5.44129600000000e00,
                4.37911500000000e00,
                3.62471200000000e00,
                3.06090200000000e00,
                2.62403100000000e00,
                2.27641500000000e00,
                1.65983800000000e00,
                1.26224900000000e00,
                7.96723000000000e-01,
                5.45738000000000e-01,
                2.63964000000000e-01,
                1.54104000000000e-01,
            ],
            [
                4.02110290000000e01,
                3.85072500000000e01,
                3.48932240000000e01,
                2.72138020000000e01,
                2.12371640000000e01,
                1.69805470000000e01,
                1.39260910000000e01,
                1.16707350000000e01,
                9.95519800000000e00,
                8.61561800000000e00,
                7.54603300000000e00,
                6.67574000000000e00,
                5.35271100000000e00,
                4.40164100000000e00,
                3.69023600000000e00,
                3.14153600000000e00,
                2.70799300000000e00,
                1.94892200000000e00,
                1.46810300000000e00,
                9.15494000000000e-01,
                6.22708000000000e-01,
                2.98713000000000e-01,
                1.73825000000000e-01,
            ],
            [
                5.29449710000000e01,
                5.18101820000000e01,
                4.88650090000000e01,
                4.09527250000000e01,
                3.35198470000000e01,
                2.75254650000000e01,
                2.28486080000000e01,
                1.92026620000000e01,
                1.63345560000000e01,
                1.40509400000000e01,
                1.22094700000000e01,
                1.07060500000000e01,
                8.42729300000000e00,
                6.80857800000000e00,
                5.61765600000000e00,
                4.71548500000000e00,
                4.01518100000000e00,
                2.82110200000000e00,
                2.08915200000000e00,
                1.27457000000000e00,
                8.55733000000000e-01,
                4.03884000000000e-01,
                2.33396000000000e-01,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
        ],
        [
            [
                5.41989880000000e01,
                4.90489660000000e01,
                3.89829400000000e01,
                2.39821320000000e01,
                1.66050290000000e01,
                1.26373760000000e01,
                1.01995360000000e01,
                8.54373700000000e00,
                7.33660700000000e00,
                6.41165500000000e00,
                5.67721200000000e00,
                5.07846900000000e00,
                4.15926900000000e00,
                3.48605300000000e00,
                2.97201700000000e00,
                2.56737300000000e00,
                2.24140100000000e00,
                1.65407700000000e00,
                1.26859700000000e00,
                8.09553000000000e-01,
                5.58150000000000e-01,
                2.72162000000000e-01,
                1.59464000000000e-01,
            ],
            [
                3.66000980000000e01,
                3.51208740000000e01,
                3.16461790000000e01,
                2.40228290000000e01,
                1.83425350000000e01,
                1.44988310000000e01,
                1.18463360000000e01,
                9.93788700000000e00,
                8.50817500000000e00,
                7.40024400000000e00,
                6.51790400000000e00,
                5.79956900000000e00,
                4.70307600000000e00,
                3.90825300000000e00,
                3.30794200000000e00,
                2.84026100000000e00,
                2.46705200000000e00,
                1.80341800000000e00,
                1.37438300000000e00,
                8.70389000000000e-01,
                5.97548000000000e-01,
                2.89925000000000e-01,
                1.69525000000000e-01,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
        ],
        [
            [
                5.12430300000000e01,
                4.83502990000000e01,
                4.15746300000000e01,
                2.77890000000000e01,
                1.91321820000000e01,
                1.41382230000000e01,
                1.10784560000000e01,
                9.05878000000000e00,
                7.63783100000000e00,
                6.58590300000000e00,
                5.77533700000000e00,
                5.13071200000000e00,
                4.16751600000000e00,
                3.47985900000000e00,
                2.96302600000000e00,
                2.56009200000000e00,
                2.23732900000000e00,
                1.65787500000000e00,
                1.27729600000000e00,
                8.21518000000000e-01,
                5.69810000000000e-01,
                2.80660000000000e-01,
                1.65459000000000e-01,
            ],
            [
                3.59140330000000e01,
                3.51566180000000e01,
                3.31068480000000e01,
                2.71969530000000e01,
                2.15145310000000e01,
                1.71191360000000e01,
                1.38992970000000e01,
                1.15355770000000e01,
                9.76483500000000e00,
                8.40546800000000e00,
                7.33689400000000e00,
                6.47880700000000e00,
                5.19307900000000e00,
                4.28098500000000e00,
                3.60360500000000e00,
                3.08266900000000e00,
                2.67103300000000e00,
                1.94699200000000e00,
                1.48315700000000e00,
                9.40672000000000e-01,
                6.47242000000000e-01,
                3.15697000000000e-01,
                1.85340000000000e-01,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
        ],
        [
            [
                7.29150960000000e01,
                6.60753600000000e01,
                5.33578280000000e01,
                3.35644110000000e01,
                2.24687340000000e01,
                1.61472430000000e01,
                1.23105260000000e01,
                9.82457900000000e00,
                8.11739400000000e00,
                6.88605600000000e00,
                5.96108400000000e00,
                5.24254000000000e00,
                4.19959900000000e00,
                3.47789100000000e00,
                2.94725400000000e00,
                2.53980300000000e00,
                2.21683900000000e00,
                1.64307100000000e00,
                1.26903700000000e00,
                8.21496000000000e-01,
                5.72970000000000e-01,
                2.84411000000000e-01,
                1.68182000000000e-01,
            ],
            [
                6.85448320000000e01,
                6.33499550000000e01,
                5.29158640000000e01,
                3.51620400000000e01,
                2.44638730000000e01,
                1.80151280000000e01,
                1.39204010000000e01,
                1.11780650000000e01,
                9.25134400000000e00,
                7.84065700000000e00,
                6.77107700000000e00,
                5.93590200000000e00,
                4.72092800000000e00,
                3.88215400000000e00,
                3.26904800000000e00,
                2.80164500000000e00,
                2.43388400000000e00,
                1.78778400000000e00,
                1.37227900000000e00,
                8.81481000000000e-01,
                6.12040000000000e-01,
                3.02117000000000e-01,
                1.78219000000000e-01,
            ],
            [
                5.07622140000000e01,
                4.80385490000000e01,
                4.30567370000000e01,
                3.28278830000000e01,
                2.47634540000000e01,
                1.90651230000000e01,
                1.50969960000000e01,
                1.22851460000000e01,
                1.02375520000000e01,
                8.70314900000000e00,
                7.52200800000000e00,
                6.59065200000000e00,
                5.22529700000000e00,
                4.27908400000000e00,
                3.58801800000000e00,
                3.06281800000000e00,
                2.65126800000000e00,
                1.93344900000000e00,
                1.47632500000000e00,
                9.41874000000000e-01,
                6.51306000000000e-01,
                3.19858000000000e-01,
                1.88263000000000e-01,
            ],
            [
                4.11871070000000e01,
                4.04130170000000e01,
                3.82892500000000e01,
                3.19210850000000e01,
                2.54481130000000e01,
                2.02225040000000e01,
                1.63010840000000e01,
                1.33954500000000e01,
                1.12196820000000e01,
                9.55973800000000e00,
                8.26700600000000e00,
                7.23999200000000e00,
                5.72551300000000e00,
                4.67287700000000e00,
                3.90459100000000e00,
                3.32212600000000e00,
                2.86717900000000e00,
                2.07824300000000e00,
                1.57982400000000e00,
                1.00201800000000e00,
                6.90445000000000e-01,
                3.37563000000000e-01,
                1.98291000000000e-01,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
        ],
        [
            [
                5.73040270000000e01,
                5.44476260000000e01,
                4.77957070000000e01,
                3.36841460000000e01,
                2.37376670000000e01,
                1.73960520000000e01,
                1.33024310000000e01,
                1.05620400000000e01,
                8.65256100000000e00,
                7.27081700000000e00,
                6.23660200000000e00,
                5.43930400000000e00,
                4.29886300000000e00,
                3.52664600000000e00,
                2.97010000000000e00,
                2.54978200000000e00,
                2.22089600000000e00,
                1.64468000000000e00,
                1.27287000000000e00,
                8.28859000000000e-01,
                5.81241000000000e-01,
                2.91260000000000e-01,
                1.73220000000000e-01,
            ],
            [
                5.37298320000000e01,
                5.14329790000000e01,
                4.60716700000000e01,
                3.42024090000000e01,
                2.51302790000000e01,
                1.89316540000000e01,
                1.47246270000000e01,
                1.18066270000000e01,
                9.72179900000000e00,
                8.18631000000000e00,
                7.02280600000000e00,
                6.11830500000000e00,
                4.81557100000000e00,
                3.93033300000000e00,
                3.29296800000000e00,
                2.81327900000000e00,
                2.43969300000000e00,
                1.79073300000000e00,
                1.37696800000000e00,
                8.89143000000000e-01,
                6.20382000000000e-01,
                3.08887000000000e-01,
                1.83171000000000e-01,
            ],
            [
                5.33912050000000e01,
                5.14589370000000e01,
                4.67536920000000e01,
                3.57231120000000e01,
                2.68682930000000e01,
                2.05832790000000e01,
                1.61845180000000e01,
                1.30610500000000e01,
                1.07905050000000e01,
                9.09733300000000e00,
                7.80311700000000e00,
                6.79103200000000e00,
                5.32634600000000e00,
                4.32882200000000e00,
                3.61139100000000e00,
                3.07301400000000e00,
                2.65531700000000e00,
                1.93471900000000e00,
                1.47971100000000e00,
                9.48820000000000e-01,
                6.59233000000000e-01,
                3.26462000000000e-01,
                1.93115000000000e-01,
            ],
            [
                4.81721000000000e01,
                4.69654470000000e01,
                4.38406630000000e01,
                3.54940690000000e01,
                2.77965480000000e01,
                2.18303470000000e01,
                1.74239690000000e01,
                1.41866160000000e01,
                1.17798410000000e01,
                9.95758700000000e00,
                8.55008300000000e00,
                7.44147400000000e00,
                5.82695600000000e00,
                4.72279700000000e00,
                3.92807200000000e00,
                3.33239200000000e00,
                2.87126300000000e00,
                2.07947500000000e00,
                1.58312900000000e00,
                1.00886400000000e00,
                6.98273000000000e-01,
                3.44076000000000e-01,
                2.03065000000000e-01,
            ],
            [
                4.43809730000000e01,
                4.36657010000000e01,
                4.16751380000000e01,
                3.54583760000000e01,
                2.87575380000000e01,
                2.30706960000000e01,
                1.86492860000000e01,
                1.52988620000000e01,
                1.27583260000000e01,
                1.08093490000000e01,
                9.29044400000000e00,
                8.08674200000000e00,
                6.32426500000000e00,
                5.11454400000000e00,
                4.24317000000000e00,
                3.59059300000000e00,
                3.08630300000000e00,
                2.22370000000000e00,
                1.68620000000000e00,
                1.06873800000000e00,
                7.37222000000000e-01,
                3.61662000000000e-01,
                2.13001000000000e-01,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
        ],
        [
            [
                4.48358450000000e01,
                4.35130560000000e01,
                4.00926450000000e01,
                3.11774780000000e01,
                2.34511520000000e01,
                1.78471750000000e01,
                1.39239600000000e01,
                1.11566290000000e01,
                9.16275000000000e00,
                7.68987300000000e00,
                6.57446800000000e00,
                5.70983800000000e00,
                4.47254600000000e00,
                3.64044700000000e00,
                3.04723700000000e00,
                2.60441900000000e00,
                2.26163500000000e00,
                1.66934600000000e00,
                1.29207000000000e00,
                8.44220000000000e-01,
                5.94297000000000e-01,
                2.99911000000000e-01,
                1.79120000000000e-01,
            ],
            [
                4.59916410000000e01,
                4.47450290000000e01,
                4.15208600000000e01,
                3.29820310000000e01,
                2.53160810000000e01,
                1.95590470000000e01,
                1.54150740000000e01,
                1.24297230000000e01,
                1.02444980000000e01,
                8.61116600000000e00,
                7.36347300000000e00,
                6.39020700000000e00,
                4.98950200000000e00,
                4.04402900000000e00,
                3.36987100000000e00,
                2.86762800000000e00,
                2.48011700000000e00,
                1.81507100000000e00,
                1.39587000000000e00,
                9.04307000000000e-01,
                6.33322000000000e-01,
                3.17504000000000e-01,
                1.89055000000000e-01,
            ],
            [
                4.66496880000000e01,
                4.55197710000000e01,
                4.25927060000000e01,
                3.46039430000000e01,
                2.70775160000000e01,
                2.12059700000000e01,
                1.68636310000000e01,
                1.36742900000000e01,
                1.13067400000000e01,
                9.51884300000000e00,
                8.14276800000000e00,
                7.06350600000000e00,
                5.50248200000000e00,
                4.44521500000000e00,
                3.69097200000000e00,
                3.12980800000000e00,
                2.69787900000000e00,
                1.96045500000000e00,
                1.49948000000000e00,
                9.64316000000000e-01,
                6.72307000000000e-01,
                3.35084000000000e-01,
                1.98984000000000e-01,
            ],
            [
                4.67552750000000e01,
                4.58323020000000e01,
                4.33346180000000e01,
                3.60394380000000e01,
                2.87272660000000e01,
                2.27845200000000e01,
                1.82688140000000e01,
                1.48903330000000e01,
                1.23496050000000e01,
                1.04129670000000e01,
                8.91232900000000e00,
                7.72964200000000e00,
                6.01132600000000e00,
                4.84383100000000e00,
                4.01037400000000e00,
                3.39080200000000e00,
                2.91477400000000e00,
                2.10536900000000e00,
                1.60279000000000e00,
                1.02417100000000e00,
                7.11207000000000e-01,
                3.52647000000000e-01,
                2.08912000000000e-01,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
        ],
        [
            [
                3.87558670000000e01,
                3.78891050000000e01,
                3.55765770000000e01,
                2.90541470000000e01,
                2.27985480000000e01,
                1.78842260000000e01,
                1.42354170000000e01,
                1.15477160000000e01,
                9.54863700000000e00,
                8.03755800000000e00,
                6.87454200000000e00,
                5.96311300000000e00,
                4.64774800000000e00,
                3.76039700000000e00,
                3.12993900000000e00,
                2.66244900000000e00,
                2.30343600000000e00,
                1.69100600000000e00,
                1.30674600000000e00,
                8.55446000000000e-01,
                6.04504000000000e-01,
                3.07588000000000e-01,
                1.84646000000000e-01,
            ],
            [
                4.12800660000000e01,
                4.04036870000000e01,
                3.80648030000000e01,
                3.14147320000000e01,
                2.49165410000000e01,
                1.97095440000000e01,
                1.57789570000000e01,
                1.28463230000000e01,
                1.06436490000000e01,
                8.96628100000000e00,
                7.66803300000000e00,
                6.64638300000000e00,
                5.16612700000000e00,
                4.16478400000000e00,
                3.45306500000000e00,
                2.92597300000000e00,
                2.52212200000000e00,
                1.83678700000000e00,
                1.41053100000000e00,
                9.15473000000000e-01,
                6.43469000000000e-01,
                3.25143000000000e-01,
                1.94556000000000e-01,
            ],
            [
                4.33767540000000e01,
                4.25220370000000e01,
                4.02233370000000e01,
                3.35679210000000e01,
                2.69051580000000e01,
                2.14529440000000e01,
                1.72695530000000e01,
                1.41098870000000e01,
                1.17148730000000e01,
                9.87844500000000e00,
                8.44971400000000e00,
                7.32103300000000e00,
                5.67961400000000e00,
                4.56618400000000e00,
                3.77425400000000e00,
                3.18817600000000e00,
                2.73986800000000e00,
                1.98210200000000e00,
                1.51404800000000e00,
                9.75382000000000e-01,
                6.82368000000000e-01,
                3.42670000000000e-01,
                2.04449000000000e-01,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
        ],
        [
            [
                3.25364480000000e01,
                3.20135530000000e01,
                3.05701660000000e01,
                2.61371840000000e01,
                2.14024280000000e01,
                1.73505230000000e01,
                1.41439250000000e01,
                1.16664030000000e01,
                9.75575000000000e00,
                8.27122400000000e00,
                7.10460100000000e00,
                6.17598500000000e00,
                4.81539000000000e00,
                3.88671000000000e00,
                3.22413900000000e00,
                2.73306200000000e00,
                2.35710700000000e00,
                1.72069900000000e00,
                1.32603500000000e00,
                8.67499000000000e-01,
                6.14098000000000e-01,
                3.14104000000000e-01,
                1.89286000000000e-01,
            ],
            [
                3.55939760000000e01,
                3.50391840000000e01,
                3.35058920000000e01,
                2.87725970000000e01,
                2.36664920000000e01,
                1.92510560000000e01,
                1.57268020000000e01,
                1.29864250000000e01,
                1.08631350000000e01,
                9.20764500000000e00,
                7.90326700000000e00,
                6.86298000000000e00,
                5.33598900000000e00,
                4.29255000000000e00,
                3.54824800000000e00,
                2.99725600000000e00,
                2.57624800000000e00,
                1.86664100000000e00,
                1.42986400000000e00,
                9.27513000000000e-01,
                6.53057000000000e-01,
                3.31671000000000e-01,
                1.99205000000000e-01,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
        ],
        [
            [
                2.73277050000000e01,
                2.70110760000000e01,
                2.61157860000000e01,
                2.31734500000000e01,
                1.97140260000000e01,
                1.64952160000000e01,
                1.37782840000000e01,
                1.15745650000000e01,
                9.81069500000000e00,
                8.39986600000000e00,
                7.26542600000000e00,
                6.34582400000000e00,
                4.97184400000000e00,
                4.01692100000000e00,
                3.32862500000000e00,
                2.81598600000000e00,
                2.42300900000000e00,
                1.75954700000000e00,
                1.35132700000000e00,
                8.81958000000000e-01,
                6.24687000000000e-01,
                3.20697000000000e-01,
                1.93838000000000e-01,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
        ],
        [
            [
                5.37089754000000e02,
                2.51203112000000e02,
                1.04671685000000e02,
                4.01908390000000e01,
                2.49381150000000e01,
                1.83967650000000e01,
                1.45779860000000e01,
                1.19651660000000e01,
                1.00264350000000e01,
                8.52341700000000e00,
                7.32702900000000e00,
                6.35743600000000e00,
                4.89904300000000e00,
                3.87425900000000e00,
                3.13018400000000e00,
                2.57515100000000e00,
                2.15154400000000e00,
                1.45013000000000e00,
                1.03843900000000e00,
                6.03657000000000e-01,
                3.92712000000000e-01,
                1.77663000000000e-01,
                1.00685000000000e-01,
            ],
            [
                6.57018290000000e01,
                5.98918430000000e01,
                4.93703130000000e01,
                3.38726930000000e01,
                2.52509890000000e01,
                1.98576040000000e01,
                1.61061580000000e01,
                1.33278610000000e01,
                1.11931740000000e01,
                9.51363600000000e00,
                8.16926100000000e00,
                7.07825800000000e00,
                5.43926000000000e00,
                4.29143900000000e00,
                3.46094500000000e00,
                2.84332000000000e00,
                2.37310200000000e00,
                1.59680800000000e00,
                1.14249000000000e00,
                6.63665000000000e-01,
                4.31652000000000e-01,
                1.95261000000000e-01,
                1.10658000000000e-01,
            ],
            [
                1.59005327000000e02,
                1.57143621200000e02,
                1.51973178700000e02,
                1.35703765900000e02,
                1.17315318700000e02,
                1.00248265200000e02,
                8.54662885000000e01,
                7.30126871000000e01,
                6.26425221000000e01,
                5.40415555000000e01,
                4.69052446000000e01,
                4.09663710000000e01,
                3.18279948000000e01,
                2.52977404000000e01,
                2.05185492000000e01,
                1.69398730000000e01,
                1.42032476000000e01,
                9.66429160000000e00,
                6.99425050000000e00,
                4.16118630000000e00,
                2.77310010000000e00,
                1.32857300000000e00,
                7.90336900000000e-01,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
        ],
        [
            [
                2.88240883000000e02,
                2.20124081000000e02,
                1.31490276000000e02,
                5.52586600000000e01,
                3.15893280000000e01,
                2.16257080000000e01,
                1.63339130000000e01,
                1.30455460000000e01,
                1.07783530000000e01,
                9.10509600000000e00,
                7.81333700000000e00,
                6.78506200000000e00,
                5.25660000000000e00,
                4.18638000000000e00,
                3.40653300000000e00,
                2.82115400000000e00,
                2.37119000000000e00,
                1.61745600000000e00,
                1.16820800000000e00,
                6.86284000000000e-01,
                4.49036000000000e-01,
                2.04432000000000e-01,
                1.16151000000000e-01,
            ],
            [
                3.09571607000000e02,
                1.75354583000000e02,
                9.46066250000000e01,
                4.60830780000000e01,
                3.00147260000000e01,
                2.20684410000000e01,
                1.72886740000000e01,
                1.40639130000000e01,
                1.17253160000000e01,
                9.94724600000000e00,
                8.55104000000000e00,
                7.42908200000000e00,
                5.75113700000000e00,
                4.57356400000000e00,
                3.71613100000000e00,
                3.07359400000000e00,
                2.58060200000000e00,
                1.75702300000000e00,
                1.26766100000000e00,
                7.44016000000000e-01,
                4.86682000000000e-01,
                2.21586000000000e-01,
                1.25920000000000e-01,
            ],
            [
                6.69605790000000e01,
                6.30034800000000e01,
                5.48221920000000e01,
                3.97272000000000e01,
                2.96372990000000e01,
                2.30260300000000e01,
                1.84860590000000e01,
                1.52106190000000e01,
                1.27502140000000e01,
                1.08439290000000e01,
                9.33164400000000e00,
                8.10961600000000e00,
                6.27530700000000e00,
                4.98602800000000e00,
                4.04750200000000e00,
                3.34481500000000e00,
                2.80624000000000e00,
                1.90801200000000e00,
                1.37538500000000e00,
                8.06474000000000e-01,
                5.27292000000000e-01,
                2.39946000000000e-01,
                1.36310000000000e-01,
            ],
            [
                1.55509439600000e02,
                1.52295719800000e02,
                1.43911013300000e02,
                1.21214868800000e02,
                1.00052144000000e02,
                8.32245940000000e01,
                7.01280996000000e01,
                6.07626607000000e01,
                5.15155269000000e01,
                4.47636011000000e01,
                3.91938022000000e01,
                3.45522205000000e01,
                2.73444515000000e01,
                2.21012480000000e01,
                1.81884416000000e01,
                1.52025580000000e01,
                1.28788334000000e01,
                8.92669920000000e00,
                6.52941530000000e00,
                3.91031940000000e00,
                2.59462960000000e00,
                1.20813450000000e00,
                6.95728000000000e-01,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
        ],
        [
            [
                2.15814022000000e02,
                1.76844927000000e02,
                1.18315876000000e02,
                5.65506640000000e01,
                3.37025040000000e01,
                2.32152200000000e01,
                1.74335570000000e01,
                1.38111350000000e01,
                1.13289880000000e01,
                9.51733000000000e00,
                8.13430900000000e00,
                7.04370200000000e00,
                5.43821400000000e00,
                4.32310500000000e00,
                3.51394700000000e00,
                2.90796400000000e00,
                2.44282100000000e00,
                1.66480900000000e00,
                1.20177400000000e00,
                7.05655000000000e-01,
                4.61628000000000e-01,
                2.10118000000000e-01,
                1.19325000000000e-01,
            ],
            [
                1.74170367000000e02,
                1.09810479000000e02,
                7.84184010000000e01,
                4.83320410000000e01,
                3.38987960000000e01,
                2.54468050000000e01,
                1.99742230000000e01,
                1.61822840000000e01,
                1.34194490000000e01,
                1.13279880000000e01,
                9.69745500000000e00,
                8.39670500000000e00,
                6.46838700000000e00,
                5.12691500000000e00,
                4.15577300000000e00,
                3.43094200000000e00,
                2.87647400000000e00,
                1.95351700000000e00,
                1.40721100000000e00,
                8.24504000000000e-01,
                5.38860000000000e-01,
                2.45048000000000e-01,
                1.39111000000000e-01,
            ],
            [
                6.66599540000000e01,
                6.43784460000000e01,
                5.87168170000000e01,
                4.51581050000000e01,
                3.43061210000000e01,
                2.66622110000000e01,
                2.12769290000000e01,
                1.73778510000000e01,
                1.44673110000000e01,
                1.22338560000000e01,
                1.04793230000000e01,
                9.07384300000000e00,
                6.98499200000000e00,
                5.53089600000000e00,
                4.47899300000000e00,
                3.69476400000000e00,
                3.09554700000000e00,
                2.09973500000000e00,
                1.51141300000000e00,
                8.84879000000000e-01,
                5.78122000000000e-01,
                2.62823000000000e-01,
                1.49185000000000e-01,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
        ],
        [
            [
                6.31803350000000e01,
                6.08655150000000e01,
                5.56077000000000e01,
                4.29730420000000e01,
                3.28160560000000e01,
                2.56410650000000e01,
                2.05717660000000e01,
                1.68914020000000e01,
                1.41378050000000e01,
                1.20210120000000e01,
                1.03558470000000e01,
                9.02048500000000e00,
                7.03304800000000e00,
                5.64667500000000e00,
                4.64109900000000e00,
                3.88877300000000e00,
                3.31133700000000e00,
                2.34206500000000e00,
                1.75764800000000e00,
                1.11110500000000e00,
                7.73722000000000e-01,
                3.91875000000000e-01,
                2.36510000000000e-01,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
        ],
        [
            [
                2.53607583000000e02,
                1.85347808000000e02,
                1.17313120000000e02,
                5.14986990000000e01,
                2.95194860000000e01,
                2.01469030000000e01,
                1.52121030000000e01,
                1.21925180000000e01,
                1.01406100000000e01,
                8.64175500000000e00,
                7.49101000000000e00,
                6.57628200000000e00,
                5.21196200000000e00,
                4.24696600000000e00,
                3.53458000000000e00,
                2.99242200000000e00,
                2.56990900000000e00,
                1.84614800000000e00,
                1.39982200000000e00,
                8.96355000000000e-01,
                6.29215000000000e-01,
                3.22538000000000e-01,
                1.96051000000000e-01,
            ],
            [
                6.12373490000000e01,
                5.89335430000000e01,
                5.39743400000000e01,
                4.19343430000000e01,
                3.21281250000000e01,
                2.51481370000000e01,
                2.02000000000000e01,
                1.66031610000000e01,
                1.39109010000000e01,
                1.18406070000000e01,
                1.02112030000000e01,
                8.90351000000000e00,
                6.95418800000000e00,
                5.59081900000000e00,
                4.59918400000000e00,
                3.85537200000000e00,
                3.28320500000000e00,
                2.32025800000000e00,
                1.73850600000000e00,
                1.09523900000000e00,
                7.60711000000000e-01,
                3.84219000000000e-01,
                2.31825000000000e-01,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
        ],
        [
            [
                2.24576218000000e02,
                1.79268440000000e02,
                1.14550986000000e02,
                5.07711900000000e01,
                2.90959830000000e01,
                1.98086410000000e01,
                1.49251210000000e01,
                1.19483050000000e01,
                9.93387400000000e00,
                8.46736000000000e00,
                7.34394000000000e00,
                6.45192800000000e00,
                5.12153500000000e00,
                4.17902200000000e00,
                3.48147700000000e00,
                2.94918400000000e00,
                2.53332900000000e00,
                1.81871500000000e00,
                1.37683500000000e00,
                8.78329000000000e-01,
                6.14662000000000e-01,
                3.13830000000000e-01,
                1.90548000000000e-01,
            ],
            [
                5.98908920000000e01,
                5.78663720000000e01,
                5.30214580000000e01,
                4.12308960000000e01,
                3.16026170000000e01,
                2.47396280000000e01,
                1.98738380000000e01,
                1.63389450000000e01,
                1.36950980000000e01,
                1.16632880000000e01,
                1.00646540000000e01,
                8.78159200000000e00,
                6.86776900000000e00,
                5.52717300000000e00,
                4.55023800000000e00,
                3.81602600000000e00,
                3.25023400000000e00,
                2.29582400000000e00,
                1.71804900000000e00,
                1.07906600000000e00,
                7.47553000000000e-01,
                3.76280000000000e-01,
                2.26803000000000e-01,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
        ],
        [
            [
                2.16554028000000e02,
                1.74068560000000e02,
                1.12065720000000e02,
                4.99521540000000e01,
                2.85964740000000e01,
                1.94194800000000e01,
                1.46027420000000e01,
                1.16781260000000e01,
                9.70729400000000e00,
                8.27738400000000e00,
                7.18443500000000e00,
                6.31755700000000e00,
                5.02455500000000e00,
                4.10684500000000e00,
                3.42575300000000e00,
                2.90446600000000e00,
                2.49607800000000e00,
                1.79172900000000e00,
                1.35468300000000e00,
                8.61084000000000e-01,
                6.00580000000000e-01,
                3.05096000000000e-01,
                1.84887000000000e-01,
            ],
            [
                5.79857080000000e01,
                5.60520210000000e01,
                5.14036550000000e01,
                4.01715870000000e01,
                3.09043600000000e01,
                2.42360810000000e01,
                1.94864830000000e01,
                1.60303390000000e01,
                1.34446280000000e01,
                1.14577250000000e01,
                9.89453600000000e00,
                8.63972900000000e00,
                6.76673100000000e00,
                5.45262800000000e00,
                4.49308200000000e00,
                3.77044900000000e00,
                3.21250500000000e00,
                2.26889800000000e00,
                1.69621200000000e00,
                1.06229800000000e00,
                7.33940000000000e-01,
                3.67879000000000e-01,
                2.21370000000000e-01,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
        ],
        [
            [
                2.09482163000000e02,
                1.69326427000000e02,
                1.09749627000000e02,
                4.91677750000000e01,
                2.81221600000000e01,
                1.90508730000000e01,
                1.42954700000000e01,
                1.14178440000000e01,
                9.48623200000000e00,
                8.08952000000000e00,
                7.02453300000000e00,
                6.18102600000000e00,
                4.92349400000000e00,
                4.02998900000000e00,
                3.36542400000000e00,
                2.85552400000000e00,
                2.45509800000000e00,
                1.76220600000000e00,
                1.33086200000000e00,
                8.43075000000000e-01,
                5.86070000000000e-01,
                2.96116000000000e-01,
                1.79013000000000e-01,
            ],
            [
                6.04975550000000e01,
                5.68914260000000e01,
                5.17310830000000e01,
                4.01100700000000e01,
                3.07211290000000e01,
                2.40196790000000e01,
                1.92720050000000e01,
                1.58320160000000e01,
                1.32674100000000e01,
                1.13021990000000e01,
                9.75927700000000e00,
                8.52250500000000e00,
                6.67838100000000e00,
                5.38480300000000e00,
                4.43956400000000e00,
                3.72688800000000e00,
                3.17593100000000e00,
                2.24236100000000e00,
                1.67461900000000e00,
                1.04571200000000e00,
                7.20426000000000e-01,
                3.59399000000000e-01,
                2.15795000000000e-01,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
        ],
        [
            [
                2.03211190000000e02,
                1.65077409000000e02,
                1.07694135000000e02,
                4.84835280000000e01,
                2.77173710000000e01,
                1.87379040000000e01,
                1.40329820000000e01,
                1.11932480000000e01,
                9.29334700000000e00,
                7.92376800000000e00,
                6.88192600000000e00,
                6.05800600000000e00,
                4.83071400000000e00,
                3.95829100000000e00,
                3.30841000000000e00,
                2.80882100000000e00,
                2.41573500000000e00,
                1.73369900000000e00,
                1.30794300000000e00,
                8.25945000000000e-01,
                5.72379000000000e-01,
                2.87715000000000e-01,
                1.73530000000000e-01,
            ],
            [
                5.83846820000000e01,
                5.55074830000000e01,
                4.89596600000000e01,
                3.55239180000000e01,
                2.62422590000000e01,
                2.02406920000000e01,
                1.62113610000000e01,
                1.33691670000000e01,
                1.12734740000000e01,
                9.67058600000000e00,
                8.40804700000000e00,
                7.39002000000000e00,
                5.85590400000000e00,
                4.76354900000000e00,
                3.95437600000000e00,
                3.33707600000000e00,
                2.85511600000000e00,
                2.02818700000000e00,
                1.51874500000000e00,
                9.49133000000000e-01,
                6.53054000000000e-01,
                3.24660000000000e-01,
                1.94604000000000e-01,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
        ],
        [
            [
                1.41842064000000e02,
                1.16857104000000e02,
                8.24531150000000e01,
                4.28638860000000e01,
                2.64230410000000e01,
                1.85963810000000e01,
                1.42465310000000e01,
                1.15139220000000e01,
                9.63325200000000e00,
                8.25009800000000e00,
                7.18309000000000e00,
                6.33112900000000e00,
                5.05146100000000e00,
                4.13673000000000e00,
                3.45418200000000e00,
                2.92950500000000e00,
                2.51698900000000e00,
                1.80237700000000e00,
                1.35725700000000e00,
                8.54586000000000e-01,
                5.90978000000000e-01,
                2.96218000000000e-01,
                1.78451000000000e-01,
            ],
            [
                5.99521870000000e01,
                5.76299620000000e01,
                5.23452910000000e01,
                4.04588930000000e01,
                3.08901980000000e01,
                2.40499010000000e01,
                1.92156040000000e01,
                1.57302290000000e01,
                1.31464310000000e01,
                1.11770130000000e01,
                9.63780500000000e00,
                8.40850800000000e00,
                6.58232400000000e00,
                5.30507700000000e00,
                4.37277700000000e00,
                3.66985300000000e00,
                3.12612800000000e00,
                2.20359200000000e00,
                1.64166900000000e00,
                1.01918400000000e00,
                6.98284000000000e-01,
                3.45109000000000e-01,
                2.06276000000000e-01,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
        ],
        [
            [
                2.29301596000000e02,
                1.48757206000000e02,
                8.38992590000000e01,
                3.77525280000000e01,
                2.30411680000000e01,
                1.64030610000000e01,
                1.27361960000000e01,
                1.04183080000000e01,
                8.80725100000000e00,
                7.60955400000000e00,
                6.67573100000000e00,
                5.92255000000000e00,
                4.77603100000000e00,
                3.94318200000000e00,
                3.31330000000000e00,
                2.82364900000000e00,
                2.43507800000000e00,
                1.75400700000000e00,
                1.32456900000000e00,
                8.35127000000000e-01,
                5.77030000000000e-01,
                2.88271000000000e-01,
                1.73283000000000e-01,
            ],
            [
                5.57777620000000e01,
                5.39540020000000e01,
                4.94627260000000e01,
                3.85259830000000e01,
                2.95462910000000e01,
                2.31049190000000e01,
                1.85294200000000e01,
                1.52134150000000e01,
                1.27449150000000e01,
                1.08576310000000e01,
                9.37930100000000e00,
                8.19653300000000e00,
                6.43561500000000e00,
                5.20046300000000e00,
                4.29628000000000e00,
                3.61260800000000e00,
                3.08233500000000e00,
                2.17904300000000e00,
                1.62617600000000e00,
                1.01100800000000e00,
                6.92793000000000e-01,
                3.42077000000000e-01,
                2.04287000000000e-01,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
        ],
        [
            [
                2.32465673000000e02,
                1.35183600000000e02,
                8.01286950000000e01,
                3.77486970000000e01,
                2.32434510000000e01,
                1.65330840000000e01,
                1.27969630000000e01,
                1.04341740000000e01,
                8.79664700000000e00,
                7.58424800000000e00,
                6.64286600000000e00,
                5.88634500000000e00,
                4.73935800000000e00,
                3.90914100000000e00,
                3.28244100000000e00,
                2.79571500000000e00,
                2.40962300000000e00,
                1.73302200000000e00,
                1.30647200000000e00,
                8.20768000000000e-01,
                5.65311000000000e-01,
                2.80990000000000e-01,
                1.68537000000000e-01,
            ],
            [
                6.04090430000000e01,
                5.59872550000000e01,
                5.03819660000000e01,
                3.85219880000000e01,
                2.93573150000000e01,
                2.28882210000000e01,
                1.83247830000000e01,
                1.50311820000000e01,
                1.25861420000000e01,
                1.07203330000000e01,
                9.26066600000000e00,
                8.09373800000000e00,
                6.35719100000000e00,
                5.13893300000000e00,
                4.24646700000000e00,
                3.57100200000000e00,
                3.04657100000000e00,
                2.15196800000000e00,
                1.60368300000000e00,
                9.93567000000000e-01,
                6.78619000000000e-01,
                3.33268000000000e-01,
                1.98535000000000e-01,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
        ],
        [
            [
                1.74357971000000e02,
                1.45347573000000e02,
                9.83386140000000e01,
                4.56653390000000e01,
                2.61535730000000e01,
                1.75697070000000e01,
                1.30686310000000e01,
                1.03734350000000e01,
                8.59091500000000e00,
                7.32063600000000e00,
                6.36334500000000e00,
                5.61117500000000e00,
                4.49540000000000e00,
                3.70146200000000e00,
                3.10663800000000e00,
                2.64584800000000e00,
                2.28037500000000e00,
                1.63871500000000e00,
                1.23293700000000e00,
                7.70103000000000e-01,
                5.27188000000000e-01,
                2.59120000000000e-01,
                1.54548000000000e-01,
            ],
            [
                5.24790850000000e01,
                5.09455980000000e01,
                4.70541390000000e01,
                3.71641820000000e01,
                2.86862320000000e01,
                2.24764090000000e01,
                1.80300540000000e01,
                1.48000680000000e01,
                1.23955370000000e01,
                1.05586820000000e01,
                9.12128100000000e00,
                7.97221700000000e00,
                6.26256200000000e00,
                5.06320800000000e00,
                4.18431100000000e00,
                3.51873100000000e00,
                3.00161000000000e00,
                2.11844700000000e00,
                1.57644700000000e00,
                9.73047000000000e-01,
                6.62046000000000e-01,
                3.22782000000000e-01,
                1.91548000000000e-01,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
        ],
        [
            [
                1.69508670000000e02,
                1.41831130000000e02,
                9.64854630000000e01,
                4.49898390000000e01,
                2.57372660000000e01,
                1.72457070000000e01,
                1.27960440000000e01,
                1.01383860000000e01,
                8.38671100000000e00,
                7.14280300000000e00,
                6.20826100000000e00,
                5.47568300000000e00,
                4.39108000000000e00,
                3.61982100000000e00,
                3.04145100000000e00,
                2.59265800000000e00,
                2.23601600000000e00,
                1.60797100000000e00,
                1.20938600000000e00,
                7.53586000000000e-01,
                5.14264000000000e-01,
                2.51088000000000e-01,
                1.49174000000000e-01,
            ],
            [
                5.09243700000000e01,
                4.94869020000000e01,
                4.58178160000000e01,
                3.63744420000000e01,
                2.81606380000000e01,
                2.20904510000000e01,
                1.77252050000000e01,
                1.45487700000000e01,
                1.21834110000000e01,
                1.03771780000000e01,
                8.96465100000000e00,
                7.83621500000000e00,
                6.15843800000000e00,
                4.98189600000000e00,
                4.11948400000000e00,
                3.46593100000000e00,
                2.95768200000000e00,
                2.08823200000000e00,
                1.55348300000000e00,
                9.57121000000000e-01,
                6.49644000000000e-01,
                3.15081000000000e-01,
                1.86384000000000e-01,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
        ],
        [
            [
                1.64874479000000e02,
                1.38503417000000e02,
                9.47797640000000e01,
                4.44385580000000e01,
                2.54312120000000e01,
                1.70158970000000e01,
                1.26028120000000e01,
                9.96976100000000e00,
                8.23785800000000e00,
                7.01094500000000e00,
                6.09128300000000e00,
                5.37175000000000e00,
                4.30843700000000e00,
                3.55316700000000e00,
                2.98672700000000e00,
                2.54685000000000e00,
                2.19692700000000e00,
                1.57962000000000e00,
                1.18703700000000e00,
                7.37597000000000e-01,
                5.01822000000000e-01,
                2.43644000000000e-01,
                1.44367000000000e-01,
            ],
            [
                5.09258390000000e01,
                4.93627740000000e01,
                4.56624910000000e01,
                3.61857370000000e01,
                2.79704110000000e01,
                2.19122080000000e01,
                1.75625150000000e01,
                1.44018520000000e01,
                1.20514680000000e01,
                1.02590760000000e01,
                8.85912800000000e00,
                7.74197700000000e00,
                6.08303300000000e00,
                4.92092000000000e00,
                4.06939700000000e00,
                3.42402700000000e00,
                2.92195100000000e00,
                2.06231800000000e00,
                1.53298700000000e00,
                9.42288000000000e-01,
                6.37974000000000e-01,
                3.07983000000000e-01,
                1.81768000000000e-01,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
        ],
        [
            [
                1.63737907000000e02,
                1.37401600000000e02,
                9.38094750000000e01,
                4.37828040000000e01,
                2.49508110000000e01,
                1.66301360000000e01,
                1.22781120000000e01,
                9.69057700000000e00,
                7.99551700000000e00,
                6.79961800000000e00,
                5.90647700000000e00,
                5.20973300000000e00,
                4.18284800000000e00,
                3.45442900000000e00,
                2.90778300000000e00,
                2.48257400000000e00,
                2.14361700000000e00,
                1.54357700000000e00,
                1.16033200000000e00,
                7.20056000000000e-01,
                4.88756000000000e-01,
                2.36061000000000e-01,
                1.39457000000000e-01,
            ],
            [
                5.41811670000000e01,
                5.23584220000000e01,
                4.81909980000000e01,
                3.77829980000000e01,
                2.88680310000000e01,
                2.23694590000000e01,
                1.77640250000000e01,
                1.44601420000000e01,
                1.20316690000000e01,
                1.01983910000000e01,
                8.77875600000000e00,
                7.65394500000000e00,
                5.99678800000000e00,
                4.84458500000000e00,
                4.00400300000000e00,
                3.36838900000000e00,
                2.87439800000000e00,
                2.02867100000000e00,
                1.50736000000000e00,
                9.24831000000000e-01,
                6.24659000000000e-01,
                3.00011000000000e-01,
                1.76532000000000e-01,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
        ],
        [
            [
                1.36853067000000e02,
                1.04297562000000e02,
                7.65562240000000e01,
                4.02834860000000e01,
                2.41515190000000e01,
                1.64764390000000e01,
                1.23100420000000e01,
                9.77904900000000e00,
                8.09874700000000e00,
                6.90305300000000e00,
                6.00503900000000e00,
                5.30187500000000e00,
                4.26212700000000e00,
                3.52279100000000e00,
                2.96734800000000e00,
                2.53507400000000e00,
                2.19037200000000e00,
                1.57976600000000e00,
                1.18919500000000e00,
                7.39303000000000e-01,
                5.02156000000000e-01,
                2.42392000000000e-01,
                1.43037000000000e-01,
            ],
            [
                4.89452970000000e01,
                4.76317230000000e01,
                4.42461460000000e01,
                3.53576300000000e01,
                2.74507560000000e01,
                2.15311680000000e01,
                1.72508500000000e01,
                1.41326890000000e01,
                1.18136070000000e01,
                1.00470280000000e01,
                8.66949600000000e00,
                7.57215500000000e00,
                5.94627400000000e00,
                4.80975200000000e00,
                3.97776700000000e00,
                3.34722100000000e00,
                2.85639800000000e00,
                2.01473100000000e00,
                1.49524600000000e00,
                9.14589000000000e-01,
                6.15755000000000e-01,
                2.93829000000000e-01,
                1.72238000000000e-01,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
        ],
        [
            [
                1.06281621000000e02,
                9.54891650000000e01,
                7.53034870000000e01,
                4.41393100000000e01,
                2.81355730000000e01,
                1.96843670000000e01,
                1.47522820000000e01,
                1.16120870000000e01,
                9.47172100000000e00,
                7.93305200000000e00,
                6.77927000000000e00,
                5.88432600000000e00,
                4.58937300000000e00,
                3.69990000000000e00,
                3.05367200000000e00,
                2.56536800000000e00,
                2.18566200000000e00,
                1.53481900000000e00,
                1.13342500000000e00,
                6.85922000000000e-01,
                4.56814000000000e-01,
                2.12349000000000e-01,
                1.21565000000000e-01,
            ],
            [
                8.24536570000000e01,
                7.05184470000000e01,
                5.67403060000000e01,
                3.88993780000000e01,
                2.83733700000000e01,
                2.15865770000000e01,
                1.69965970000000e01,
                1.37660430000000e01,
                1.14103040000000e01,
                9.63816500000000e00,
                8.26846300000000e00,
                7.18478900000000e00,
                5.59175200000000e00,
                4.48812200000000e00,
                3.68632200000000e00,
                3.08273400000000e00,
                2.61577000000000e00,
                1.82225800000000e00,
                1.33831900000000e00,
                8.04595000000000e-01,
                5.33952000000000e-01,
                2.47249000000000e-01,
                1.41340000000000e-01,
            ],
            [
                5.02657100000000e01,
                4.92005530000000e01,
                4.63604080000000e01,
                3.83345580000000e01,
                3.05672240000000e01,
                2.43724470000000e01,
                1.96879820000000e01,
                1.61687550000000e01,
                1.34975460000000e01,
                1.14368740000000e01,
                9.81887900000000e00,
                8.52644900000000e00,
                6.61392300000000e00,
                5.28633700000000e00,
                4.32413500000000e00,
                3.60274700000000e00,
                3.04716300000000e00,
                2.10963600000000e00,
                1.54280500000000e00,
                9.22793000000000e-01,
                6.10691000000000e-01,
                2.81919000000000e-01,
                1.60974000000000e-01,
            ],
            [
                3.27095574000000e01,
                3.24889582000000e01,
                3.18527540000000e01,
                2.96320422000000e01,
                2.67617762000000e01,
                2.38245539000000e01,
                2.11219459000000e01,
                1.87537050000000e01,
                1.67198153000000e01,
                1.49828615000000e01,
                1.34971673000000e01,
                1.22201143000000e01,
                1.01536814000000e01,
                8.56780590000000e00,
                7.32236890000000e00,
                6.32536850000000e00,
                5.51455270000000e00,
                4.04554690000000e00,
                3.08335080000000e00,
                1.94969570000000e00,
                1.33826180000000e00,
                6.52706100000000e-01,
                3.84735500000000e-01,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
        ],
        [
            [
                8.89256120000000e01,
                8.19318660000000e01,
                6.73277280000000e01,
                4.19543150000000e01,
                2.77130410000000e01,
                1.98298060000000e01,
                1.50833980000000e01,
                1.19897820000000e01,
                9.84274900000000e00,
                8.27819600000000e00,
                7.09351900000000e00,
                6.16849800000000e00,
                4.82273000000000e00,
                3.89528500000000e00,
                3.22073800000000e00,
                2.71072100000000e00,
                2.31381100000000e00,
                1.63207000000000e00,
                1.20993400000000e00,
                7.36572000000000e-01,
                4.92529000000000e-01,
                2.30227000000000e-01,
                1.32140000000000e-01,
            ],
            [
                6.93801270000000e01,
                6.26525490000000e01,
                5.23321990000000e01,
                3.72824880000000e01,
                2.78804010000000e01,
                2.16007000000000e01,
                1.72276620000000e01,
                1.40778720000000e01,
                1.17401200000000e01,
                9.95828100000000e00,
                8.56796300000000e00,
                7.46062900000000e00,
                5.82313000000000e00,
                4.68377000000000e00,
                3.85432200000000e00,
                3.22912300000000e00,
                2.74487700000000e00,
                1.92018300000000e00,
                1.41531200000000e00,
                8.55543000000000e-01,
                5.69873000000000e-01,
                2.65231000000000e-01,
                1.51976000000000e-01,
            ],
            [
                5.31343510000000e01,
                5.01385310000000e01,
                4.53135370000000e01,
                3.61734470000000e01,
                2.85997780000000e01,
                2.27928480000000e01,
                1.84525250000000e01,
                1.52001580000000e01,
                1.27291810000000e01,
                1.08187030000000e01,
                9.31475100000000e00,
                8.11035900000000e00,
                6.32209400000000e00,
                5.07557400000000e00,
                4.16863600000000e00,
                3.48613200000000e00,
                2.95855400000000e00,
                2.06304200000000e00,
                1.51718900000000e00,
                9.14582000000000e-01,
                6.08263000000000e-01,
                2.82613000000000e-01,
                1.61831000000000e-01,
            ],
            [
                3.80167314000000e01,
                3.77505450000000e01,
                3.69868016000000e01,
                3.43581519000000e01,
                3.10182858000000e01,
                2.76354658000000e01,
                2.45337826000000e01,
                2.18145582000000e01,
                1.94741943000000e01,
                1.74704983000000e01,
                1.57528316000000e01,
                1.42738200000000e01,
                1.18766483000000e01,
                1.00346794000000e01,
                8.58712110000000e00,
                7.42756500000000e00,
                6.48379490000000e00,
                4.77093670000000e00,
                3.64564910000000e00,
                2.31440540000000e00,
                1.59298990000000e00,
                7.80097700000000e-01,
                4.60791800000000e-01,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
        ],
        [
            [
                7.26835210000000e01,
                6.65725390000000e01,
                5.45218660000000e01,
                3.51042250000000e01,
                2.43743050000000e01,
                1.81885020000000e01,
                1.42758210000000e01,
                1.16114380000000e01,
                9.69405000000000e00,
                8.25528100000000e00,
                7.14008700000000e00,
                6.25312900000000e00,
                4.93736700000000e00,
                4.01405200000000e00,
                3.33487400000000e00,
                2.81745600000000e00,
                2.41255400000000e00,
                1.71235600000000e00,
                1.27537600000000e00,
                7.81421000000000e-01,
                5.24674000000000e-01,
                2.46604000000000e-01,
                1.41895000000000e-01,
            ],
            [
                5.79535230000000e01,
                5.43254100000000e01,
                4.73716060000000e01,
                3.52077750000000e01,
                2.69133880000000e01,
                2.11900880000000e01,
                1.71120840000000e01,
                1.41184440000000e01,
                1.18610010000000e01,
                1.01176970000000e01,
                8.74295800000000e00,
                7.63877100000000e00,
                5.99128800000000e00,
                4.83553900000000e00,
                3.98990600000000e00,
                3.35035800000000e00,
                2.85373600000000e00,
                2.00506000000000e00,
                1.48311600000000e00,
                9.01211000000000e-01,
                6.02382000000000e-01,
                2.81695000000000e-01,
                1.61765000000000e-01,
            ],
            [
                6.99811980000000e01,
                6.87138070000000e01,
                6.53381200000000e01,
                5.57596720000000e01,
                4.62137800000000e01,
                3.81741940000000e01,
                3.17064340000000e01,
                2.65625450000000e01,
                2.24690330000000e01,
                1.91923040000000e01,
                1.65475190000000e01,
                1.43927290000000e01,
                1.11480040000000e01,
                8.87121300000000e00,
                7.21917300000000e00,
                5.98509300000000e00,
                5.03998700000000e00,
                3.46094500000000e00,
                2.51839100000000e00,
                1.49907700000000e00,
                9.90365000000000e-01,
                4.56914000000000e-01,
                2.60989000000000e-01,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
        ],
        [
            [
                7.09067150000000e01,
                6.57037140000000e01,
                5.52189840000000e01,
                3.68309030000000e01,
                2.56365300000000e01,
                1.90080410000000e01,
                1.48342930000000e01,
                1.20225100000000e01,
                1.00181560000000e01,
                8.52435400000000e00,
                7.37162100000000e00,
                6.45726500000000e00,
                5.10347300000000e00,
                4.15443500000000e00,
                3.45646200000000e00,
                2.92461200000000e00,
                2.50819500000000e00,
                1.78696700000000e00,
                1.33540900000000e00,
                8.22419000000000e-01,
                5.54132000000000e-01,
                2.61705000000000e-01,
                1.50927000000000e-01,
            ],
            [
                6.32047780000000e01,
                5.80228720000000e01,
                4.88925050000000e01,
                3.46221050000000e01,
                2.58457800000000e01,
                2.01387260000000e01,
                1.61920480000000e01,
                1.33396770000000e01,
                1.12072140000000e01,
                9.56827000000000e00,
                8.27902200000000e00,
                7.24458400000000e00,
                5.70112000000000e00,
                4.61679100000000e00,
                3.82164700000000e00,
                3.21873000000000e00,
                2.74926700000000e00,
                1.94326300000000e00,
                1.44421300000000e00,
                8.83388000000000e-01,
                5.92938000000000e-01,
                2.78790000000000e-01,
                1.60491000000000e-01,
            ],
            [
                6.19391170000000e01,
                6.10033150000000e01,
                5.84522600000000e01,
                5.08001250000000e01,
                4.26897350000000e01,
                3.55953060000000e01,
                2.97653350000000e01,
                2.50690300000000e01,
                2.12990290000000e01,
                1.82612110000000e01,
                1.57959520000000e01,
                1.37781660000000e01,
                1.07227960000000e01,
                8.56555100000000e00,
                6.99263200000000e00,
                5.81304600000000e00,
                4.90671700000000e00,
                3.38575300000000e00,
                2.47285600000000e00,
                1.47970000000000e00,
                9.80863000000000e-01,
                4.54545000000000e-01,
                2.60157000000000e-01,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
        ],
        [
            [
                5.96083520000000e01,
                5.62806020000000e01,
                4.88648650000000e01,
                3.41600550000000e01,
                2.44374970000000e01,
                1.84318460000000e01,
                1.45524170000000e01,
                1.18947470000000e01,
                9.97754900000000e00,
                8.53551500000000e00,
                7.41426600000000e00,
                6.51906800000000e00,
                5.18303400000000e00,
                4.23810400000000e00,
                3.53849200000000e00,
                3.00269500000000e00,
                2.58153900000000e00,
                1.84847600000000e00,
                1.38678400000000e00,
                8.58869000000000e-01,
                5.80842000000000e-01,
                2.75736000000000e-01,
                1.59430000000000e-01,
            ],
            [
                4.66731420000000e01,
                4.42599930000000e01,
                4.09119690000000e01,
                3.27985670000000e01,
                2.58416100000000e01,
                2.06679230000000e01,
                1.68773970000000e01,
                1.40534960000000e01,
                1.19009790000000e01,
                1.02230790000000e01,
                8.88848900000000e00,
                7.80799500000000e00,
                6.17928800000000e00,
                5.02319400000000e00,
                4.16949100000000e00,
                3.51911800000000e00,
                3.01105300000000e00,
                2.13566500000000e00,
                1.59158900000000e00,
                9.77624000000000e-01,
                6.58111000000000e-01,
                3.10741000000000e-01,
                1.79266000000000e-01,
            ],
            [
                5.58892400000000e01,
                5.51763930000000e01,
                5.31894280000000e01,
                4.69039320000000e01,
                3.98479720000000e01,
                3.34618590000000e01,
                2.81191240000000e01,
                2.37725720000000e01,
                2.02616430000000e01,
                1.74199010000000e01,
                1.51054600000000e01,
                1.32052620000000e01,
                1.03167870000000e01,
                8.26805900000000e00,
                6.76855400000000e00,
                5.64038500000000e00,
                4.77114900000000e00,
                3.30681000000000e00,
                2.42360900000000e00,
                1.45753600000000e00,
                9.69385000000000e-01,
                4.51254000000000e-01,
                2.58814000000000e-01,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
        ],
        [
            [
                5.15493740000000e01,
                4.92234270000000e01,
                4.37106450000000e01,
                3.17225470000000e01,
                2.32089290000000e01,
                1.77566590000000e01,
                1.41614650000000e01,
                1.16653050000000e01,
                9.84689600000000e00,
                8.46843400000000e00,
                7.38947300000000e00,
                6.52295700000000e00,
                5.21995100000000e00,
                4.29010100000000e00,
                3.59658600000000e00,
                3.06230100000000e00,
                2.64031600000000e00,
                1.90130400000000e00,
                1.43258000000000e00,
                8.92678000000000e-01,
                6.06114000000000e-01,
                2.89262000000000e-01,
                1.67658000000000e-01,
            ],
            [
                4.27200080000000e01,
                4.13931980000000e01,
                3.83655160000000e01,
                3.10080660000000e01,
                2.46653650000000e01,
                1.99066380000000e01,
                1.63877970000000e01,
                1.37425380000000e01,
                1.17090270000000e01,
                1.01115020000000e01,
                8.83181100000000e00,
                7.78909300000000e00,
                6.20442700000000e00,
                5.06892400000000e00,
                4.22411800000000e00,
                3.57671300000000e00,
                3.06859100000000e00,
                2.18798500000000e00,
                1.63707300000000e00,
                1.01125000000000e00,
                6.83268000000000e-01,
                3.24225000000000e-01,
                1.87475000000000e-01,
            ],
            [
                4.01998410000000e01,
                3.90125180000000e01,
                3.63126410000000e01,
                3.01829760000000e01,
                2.48286850000000e01,
                2.05587890000000e01,
                1.72259500000000e01,
                1.46163560000000e01,
                1.25495230000000e01,
                1.08901200000000e01,
                9.53965300000000e00,
                8.42657900000000e00,
                6.71653000000000e00,
                5.48100300000000e00,
                4.55878500000000e00,
                3.85175200000000e00,
                3.29745000000000e00,
                2.34009300000000e00,
                1.74462500000000e00,
                1.07276400000000e00,
                7.22965000000000e-01,
                3.42056000000000e-01,
                1.97551000000000e-01,
            ],
            [
                4.32638615000000e01,
                4.18727089000000e01,
                3.89775692000000e01,
                3.25354682000000e01,
                2.68687902000000e01,
                2.23369089000000e01,
                1.87845502000000e01,
                1.59853930000000e01,
                1.37519014000000e01,
                1.19455547000000e01,
                1.04662014000000e01,
                9.24090100000000e00,
                7.35007680000000e00,
                5.98076910000000e00,
                4.95942580000000e00,
                4.17820690000000e00,
                3.56758880000000e00,
                2.51852190000000e00,
                1.87068390000000e00,
                1.14514850000000e00,
                7.69974000000000e-01,
                3.63500000000000e-01,
                2.09807900000000e-01,
            ],
            [
                4.93567100000000e01,
                4.81701200000000e01,
                4.53609500000000e01,
                3.80546700000000e01,
                3.10840500000000e01,
                2.54572400000000e01,
                2.11008600000000e01,
                1.77296600000000e01,
                1.50901300000000e01,
                1.29932400000000e01,
                1.13032400000000e01,
                9.92272000000000e00,
                7.82659000000000e00,
                6.33341000000000e00,
                5.23207000000000e00,
                4.39610000000000e00,
                3.74621000000000e00,
                2.63603000000000e00,
                1.95404000000000e00,
                1.19322000000000e00,
                8.01050000000000e-01,
                3.77310000000000e-01,
                2.17510000000000e-01,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
        ],
        [
            [
                4.11424820000000e01,
                3.93180510000000e01,
                3.50148090000000e01,
                2.58710280000000e01,
                1.95216660000000e01,
                1.54256100000000e01,
                1.26507620000000e01,
                1.06590770000000e01,
                9.16098700000000e00,
                7.99296200000000e00,
                7.05658500000000e00,
                6.28921900000000e00,
                5.10744900000000e00,
                4.24226100000000e00,
                3.58455400000000e00,
                3.07052100000000e00,
                2.66005600000000e00,
                1.93194200000000e00,
                1.46414100000000e00,
                9.19320000000000e-01,
                6.27191000000000e-01,
                3.01238000000000e-01,
                1.75140000000000e-01,
            ],
            [
                4.05572290000000e01,
                3.93599010000000e01,
                3.65944450000000e01,
                2.97359090000000e01,
                2.37699580000000e01,
                1.92758940000000e01,
                1.59444510000000e01,
                1.34329020000000e01,
                1.14953860000000e01,
                9.96727400000000e00,
                8.73815000000000e00,
                7.73250900000000e00,
                6.19532700000000e00,
                5.08569200000000e00,
                4.25475900000000e00,
                3.61444400000000e00,
                3.10953500000000e00,
                2.22916600000000e00,
                1.67460000000000e00,
                1.04033200000000e00,
                7.05579000000000e-01,
                3.36580000000000e-01,
                1.95126000000000e-01,
            ],
            [
                5.49491410000000e01,
                5.39578470000000e01,
                5.13088730000000e01,
                4.37409950000000e01,
                3.62053630000000e01,
                2.99365010000000e01,
                2.49624590000000e01,
                2.10441630000000e01,
                1.79395030000000e01,
                1.54543750000000e01,
                1.34423040000000e01,
                1.17944940000000e01,
                9.28885300000000e00,
                7.50404600000000e00,
                6.18918000000000e00,
                5.19273000000000e00,
                4.41938400000000e00,
                3.10193800000000e00,
                2.29555200000000e00,
                1.39924100000000e00,
                9.38656000000000e-01,
                4.41943000000000e-01,
                2.54795000000000e-01,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
        ],
        [
            [
                3.77290460000000e01,
                3.61091840000000e01,
                3.22722340000000e01,
                2.40716250000000e01,
                1.83385860000000e01,
                1.46143630000000e01,
                1.20774260000000e01,
                1.02474000000000e01,
                8.86353200000000e00,
                7.77833100000000e00,
                6.90316800000000e00,
                6.18170500000000e00,
                5.06130400000000e00,
                4.23217000000000e00,
                3.59575500000000e00,
                3.09415800000000e00,
                2.69073400000000e00,
                1.96836700000000e00,
                1.49945100000000e00,
                9.48102000000000e-01,
                6.49744000000000e-01,
                3.13943000000000e-01,
                1.83017000000000e-01,
            ],
            [
                3.66153320000000e01,
                3.54187520000000e01,
                3.25691470000000e01,
                2.59574740000000e01,
                2.05780280000000e01,
                1.66720520000000e01,
                1.38374270000000e01,
                1.17244450000000e01,
                1.01016410000000e01,
                8.82157700000000e00,
                7.78878200000000e00,
                6.93957600000000e00,
                5.62959000000000e00,
                4.67078500000000e00,
                3.94290900000000e00,
                3.37491900000000e00,
                2.92203400000000e00,
                2.12037200000000e00,
                1.60658500000000e00,
                1.00931900000000e00,
                6.89252000000000e-01,
                3.31686000000000e-01,
                1.93041000000000e-01,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
        ],
        [
            [
                3.71668150000000e01,
                3.59903170000000e01,
                3.29876470000000e01,
                2.55237630000000e01,
                1.95407590000000e01,
                1.54358360000000e01,
                1.26124980000000e01,
                1.05949600000000e01,
                9.09278100000000e00,
                7.93340900000000e00,
                7.01166600000000e00,
                6.26092900000000e00,
                5.11084700000000e00,
                4.27070200000000e00,
                3.63066400000000e00,
                3.12809400000000e00,
                2.72441000000000e00,
                2.00091400000000e00,
                1.52954700000000e00,
                9.72200000000000e-01,
                6.68634000000000e-01,
                3.24657000000000e-01,
                1.89663000000000e-01,
            ],
            [
                3.55596890000000e01,
                3.49453750000000e01,
                3.32600440000000e01,
                2.82046230000000e01,
                2.30451020000000e01,
                1.88299000000000e01,
                1.56024300000000e01,
                1.31484490000000e01,
                1.12575930000000e01,
                9.77249900000000e00,
                8.58312600000000e00,
                7.61332200000000e00,
                6.13489200000000e00,
                5.06782900000000e00,
                4.26636700000000e00,
                3.64573700000000e00,
                3.15351200000000e00,
                2.28667500000000e00,
                1.73310200000000e00,
                1.09028100000000e00,
                7.45568000000000e-01,
                3.59628000000000e-01,
                2.09532000000000e-01,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
        ],
        [
            [
                7.54787320000000e01,
                6.69797680000000e01,
                5.27293310000000e01,
                3.32800020000000e01,
                2.31647510000000e01,
                1.73598020000000e01,
                1.37123950000000e01,
                1.12540670000000e01,
                9.50152100000000e00,
                8.19426400000000e00,
                7.18282600000000e00,
                6.37673200000000e00,
                5.17061000000000e00,
                4.30891400000000e00,
                3.66126000000000e00,
                3.15661100000000e00,
                2.75283000000000e00,
                2.03008800000000e00,
                1.55796600000000e00,
                9.96420000000000e-01,
                6.88351000000000e-01,
                3.36572000000000e-01,
                1.97454000000000e-01,
            ],
            [
                7.37909520000000e01,
                6.72077030000000e01,
                5.51633950000000e01,
                3.66818870000000e01,
                2.61091350000000e01,
                1.97299200000000e01,
                1.56034900000000e01,
                1.27753400000000e01,
                1.07414800000000e01,
                9.21915300000000e00,
                8.04129800000000e00,
                7.10460700000000e00,
                5.71070800000000e00,
                4.72403500000000e00,
                3.98954400000000e00,
                3.42237300000000e00,
                2.97221600000000e00,
                2.17529000000000e00,
                1.66110100000000e00,
                1.05612900000000e00,
                7.27234000000000e-01,
                3.54235000000000e-01,
                2.07480000000000e-01,
            ],
            [
                5.12159910000000e01,
                4.90618590000000e01,
                4.45281440000000e01,
                3.45954290000000e01,
                2.66152220000000e01,
                2.08897950000000e01,
                1.68343740000000e01,
                1.39090070000000e01,
                1.17406120000000e01,
                1.00876440000000e01,
                8.79457600000000e00,
                7.75969800000000e00,
                6.21359100000000e00,
                5.11883200000000e00,
                4.30618100000000e00,
                3.68121600000000e00,
                3.18737900000000e00,
                2.31917400000000e00,
                1.76382600000000e00,
                1.11586400000000e00,
                7.66199000000000e-01,
                3.71962000000000e-01,
                2.17545000000000e-01,
            ],
            [
                4.44232940000000e01,
                4.35695950000000e01,
                4.12468990000000e01,
                3.44223640000000e01,
                2.76300950000000e01,
                2.21919640000000e01,
                1.81026400000000e01,
                1.50481770000000e01,
                1.27356250000000e01,
                1.09495660000000e01,
                9.54117100000000e00,
                8.40869900000000e00,
                6.71183600000000e00,
                5.51013900000000e00,
                4.62014500000000e00,
                3.93796500000000e00,
                3.40087000000000e00,
                2.46203900000000e00,
                1.86588700000000e00,
                1.17527900000000e00,
                8.04987000000000e-01,
                3.89627000000000e-01,
                2.27581000000000e-01,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
        ],
        [
            [
                6.32905510000000e01,
                5.95286430000000e01,
                5.12607860000000e01,
                3.54025850000000e01,
                2.51394190000000e01,
                1.87947900000000e01,
                1.47040930000000e01,
                1.19322080000000e01,
                9.96605900000000e00,
                8.51454700000000e00,
                7.40562500000000e00,
                6.53344300000000e00,
                5.25180400000000e00,
                4.35525800000000e00,
                3.69198300000000e00,
                3.18089800000000e00,
                2.77500500000000e00,
                2.05301200000000e00,
                1.58234400000000e00,
                1.02015200000000e00,
                7.09050000000000e-01,
                3.49772000000000e-01,
                2.06012000000000e-01,
            ],
            [
                5.74725650000000e01,
                5.48466790000000e01,
                4.88575900000000e01,
                3.61749940000000e01,
                2.68405620000000e01,
                2.05425950000000e01,
                1.62594910000000e01,
                1.32605030000000e01,
                1.10893760000000e01,
                9.46618900000000e00,
                8.21680000000000e00,
                7.23019200000000e00,
                5.77807000000000e00,
                4.76435800000000e00,
                4.01795600000000e00,
                3.44613000000000e00,
                2.99469100000000e00,
                2.19896400000000e00,
                1.68604700000000e00,
                1.08003100000000e00,
                7.47917000000000e-01,
                3.67330000000000e-01,
                2.15955000000000e-01,
            ],
            [
                5.30414450000000e01,
                5.10751360000000e01,
                4.68366890000000e01,
                3.67990540000000e01,
                2.83107680000000e01,
                2.21045460000000e01,
                1.76826350000000e01,
                1.44967630000000e01,
                1.21481600000000e01,
                1.03717920000000e01,
                8.99446400000000e00,
                7.90205400000000e00,
                6.28981700000000e00,
                5.16440700000000e00,
                4.33795800000000e00,
                3.70723100000000e00,
                3.21139900000000e00,
                2.34341000000000e00,
                1.78887200000000e00,
                1.13953200000000e00,
                7.86588000000000e-01,
                3.84835000000000e-01,
                2.25880000000000e-01,
            ],
            [
                5.31115280000000e01,
                5.17198390000000e01,
                4.81733620000000e01,
                3.88959490000000e01,
                3.04802980000000e01,
                2.40395110000000e01,
                1.93203190000000e01,
                1.58625500000000e01,
                1.32876830000000e01,
                1.13287250000000e01,
                9.80506000000000e00,
                8.59500400000000e00,
                6.80965900000000e00,
                5.56665400000000e00,
                4.65744700000000e00,
                3.96662000000000e00,
                3.42593700000000e00,
                2.48575000000000e00,
                1.89006200000000e00,
                1.19814500000000e00,
                8.24767000000000e-01,
                4.02192000000000e-01,
                2.35743000000000e-01,
            ],
            [
                5.00879780000000e01,
                4.92042630000000e01,
                4.67719060000000e01,
                3.93982430000000e01,
                3.17542100000000e01,
                2.54539200000000e01,
                2.06426050000000e01,
                1.70297710000000e01,
                1.42980180000000e01,
                1.21992850000000e01,
                1.05566110000000e01,
                9.24686700000000e00,
                7.30882600000000e00,
                5.95818100000000e00,
                4.97134600000000e00,
                4.22316300000000e00,
                3.63913000000000e00,
                2.62816900000000e00,
                1.99160700000000e00,
                1.25705300000000e00,
                8.63129000000000e-01,
                4.19611000000000e-01,
                2.45634000000000e-01,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
        ],
        [
            [
                5.11916750000000e01,
                4.94069930000000e01,
                4.49458450000000e01,
                3.41505430000000e01,
                2.55045870000000e01,
                1.95073500000000e01,
                1.53898030000000e01,
                1.24998210000000e01,
                1.04110930000000e01,
                8.85611700000000e00,
                7.66604400000000e00,
                6.73220800000000e00,
                5.37009900000000e00,
                4.42929800000000e00,
                3.74180800000000e00,
                3.21750400000000e00,
                2.80442200000000e00,
                2.07574200000000e00,
                1.60336200000000e00,
                1.03904500000000e00,
                7.25343000000000e-01,
                3.60305000000000e-01,
                2.12972000000000e-01,
            ],
            [
                5.16147800000000e01,
                5.00629560000000e01,
                4.61204110000000e01,
                3.61339090000000e01,
                2.76118910000000e01,
                2.14077340000000e01,
                1.70101490000000e01,
                1.38592580000000e01,
                1.15510200000000e01,
                9.81742900000000e00,
                8.48324100000000e00,
                7.43290300000000e00,
                5.89826100000000e00,
                4.83942200000000e00,
                4.06838800000000e00,
                3.48311900000000e00,
                3.02435400000000e00,
                2.22175700000000e00,
                1.70704200000000e00,
                1.09884900000000e00,
                7.64135000000000e-01,
                3.77815000000000e-01,
                2.22885000000000e-01,
            ],
            [
                5.17479250000000e01,
                5.04406230000000e01,
                4.70464190000000e01,
                3.79441110000000e01,
                2.96097990000000e01,
                2.32406220000000e01,
                1.85881070000000e01,
                1.51912320000000e01,
                1.26725630000000e01,
                1.07660510000000e01,
                9.29142800000000e00,
                8.12703400000000e00,
                6.42269700000000e00,
                5.24726200000000e00,
                4.39347300000000e00,
                3.74770300000000e00,
                3.24354200000000e00,
                2.36739000000000e00,
                1.81049100000000e00,
                1.15854300000000e00,
                8.02863000000000e-01,
                3.95302000000000e-01,
                2.32788000000000e-01,
            ],
            [
                5.15178550000000e01,
                5.04932930000000e01,
                4.77156380000000e01,
                3.95948620000000e01,
                3.15084490000000e01,
                2.50123180000000e01,
                2.01276560000000e01,
                1.64983230000000e01,
                1.37774350000000e01,
                1.17031450000000e01,
                1.00914150000000e01,
                8.81518200000000e00,
                6.94372700000000e00,
                5.65301100000000e00,
                4.71719300000000e00,
                4.01134800000000e00,
                3.46205400000000e00,
                2.51267300000000e00,
                1.91372600000000e00,
                1.21813200000000e00,
                8.41532000000000e-01,
                4.12771000000000e-01,
                2.42684000000000e-01,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
        ],
        [
            [
                4.57354800000000e01,
                4.45177550000000e01,
                4.13554830000000e01,
                3.29793560000000e01,
                2.55092680000000e01,
                1.99242900000000e01,
                1.58977680000000e01,
                1.29790260000000e01,
                1.08242560000000e01,
                9.19845200000000e00,
                7.94452400000000e00,
                6.95705000000000e00,
                5.51674500000000e00,
                4.52715400000000e00,
                3.80978500000000e00,
                3.26723400000000e00,
                2.84296000000000e00,
                2.10141800000000e00,
                1.62452400000000e00,
                1.05638500000000e00,
                7.39915000000000e-01,
                3.69568000000000e-01,
                2.19067000000000e-01,
            ],
            [
                4.79831520000000e01,
                4.68085170000000e01,
                4.37444240000000e01,
                3.54613210000000e01,
                2.78088110000000e01,
                2.19082420000000e01,
                1.75604940000000e01,
                1.43629380000000e01,
                1.19797160000000e01,
                1.01702660000000e01,
                8.76912400000000e00,
                7.66311500000000e00,
                6.04791000000000e00,
                4.93906800000000e00,
                4.13749200000000e00,
                3.53359500000000e00,
                3.06340600000000e00,
                2.24766200000000e00,
                1.72831700000000e00,
                1.11622400000000e00,
                7.78724000000000e-01,
                3.87089000000000e-01,
                2.28990000000000e-01,
            ],
            [
                4.99757880000000e01,
                4.88536140000000e01,
                4.59097740000000e01,
                3.77785020000000e01,
                2.99993350000000e01,
                2.38231110000000e01,
                1.91794330000000e01,
                1.57185060000000e01,
                1.31162960000000e01,
                1.11291240000000e01,
                9.58457400000000e00,
                8.36254200000000e00,
                6.57531800000000e00,
                5.34867000000000e00,
                4.46367200000000e00,
                3.79888700000000e00,
                3.28306700000000e00,
                2.39348200000000e00,
                1.83184200000000e00,
                1.17592700000000e00,
                8.17450000000000e-01,
                4.04576000000000e-01,
                2.38896000000000e-01,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
        ],
        [
            [
                3.91638670000000e01,
                3.84250150000000e01,
                3.64213580000000e01,
                3.05411780000000e01,
                2.46134160000000e01,
                1.97657890000000e01,
                1.60524090000000e01,
                1.32471470000000e01,
                1.11156700000000e01,
                9.47457100000000e00,
                8.19094700000000e00,
                7.17052700000000e00,
                5.67114900000000e00,
                4.63787200000000e00,
                3.89044200000000e00,
                3.32772000000000e00,
                2.88999700000000e00,
                2.13108100000000e00,
                1.64717800000000e00,
                1.07344200000000e00,
                7.53916000000000e-01,
                3.78491000000000e-01,
                2.25015000000000e-01,
            ],
            [
                4.23026280000000e01,
                4.15366110000000e01,
                3.94596880000000e01,
                3.33254640000000e01,
                2.70380510000000e01,
                2.18068890000000e01,
                1.77463530000000e01,
                1.46509070000000e01,
                1.22850030000000e01,
                1.04566080000000e01,
                9.02329900000000e00,
                7.88256600000000e00,
                6.20596000000000e00,
                5.05206600000000e00,
                4.21960500000000e00,
                3.59502800000000e00,
                3.11106700000000e00,
                2.27754600000000e00,
                1.75103500000000e00,
                1.13325900000000e00,
                7.92697000000000e-01,
                3.95998000000000e-01,
                2.34932000000000e-01,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
        ],
        [
            [
                3.36514050000000e01,
                3.31852420000000e01,
                3.18852830000000e01,
                2.77786920000000e01,
                2.32154680000000e01,
                1.91736050000000e01,
                1.58877090000000e01,
                1.32945880000000e01,
                1.12595530000000e01,
                9.65442000000000e00,
                8.37609000000000e00,
                7.34625100000000e00,
                5.81372400000000e00,
                4.74763600000000e00,
                3.97422400000000e00,
                3.39240700000000e00,
                2.94105500000000e00,
                2.16305400000000e00,
                1.67079000000000e00,
                1.09041100000000e00,
                7.67685000000000e-01,
                3.87330000000000e-01,
                2.30968000000000e-01,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
            [
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
                0.00000000000000e00,
            ],
        ],
    ],
    dtype=torch.float64,
)
refascale = torch.tensor(
    [
        [
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            1.00000000000000,
            0.50000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            1.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            1.00000000000000,
            1.00000000000000,
            0.25000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            1.00000000000000,
            1.00000000000000,
            1.00000000000000,
            0.25000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            1.00000000000000,
            1.00000000000000,
            1.00000000000000,
            1.00000000000000,
            0.50000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            1.00000000000000,
            1.00000000000000,
            0.50000000000000,
            0.50000000000000,
            0.50000000000000,
            0.16666666666667,
            1.00000000000000,
        ],
        [
            1.00000000000000,
            1.00000000000000,
            0.50000000000000,
            1.00000000000000,
            0.50000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            1.00000000000000,
            1.00000000000000,
            1.00000000000000,
            0.50000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            1.00000000000000,
            1.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            1.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            1.00000000000000,
            1.00000000000000,
            0.25000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            1.00000000000000,
            1.00000000000000,
            1.00000000000000,
            0.25000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            1.00000000000000,
            1.00000000000000,
            1.00000000000000,
            1.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            1.00000000000000,
            1.00000000000000,
            1.00000000000000,
            0.50000000000000,
            0.50000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            1.00000000000000,
            1.00000000000000,
            0.50000000000000,
            1.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            1.00000000000000,
            1.00000000000000,
            1.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            1.00000000000000,
            1.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            1.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            1.00000000000000,
            1.00000000000000,
            0.25000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            1.00000000000000,
            1.00000000000000,
            1.00000000000000,
            0.25000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            1.00000000000000,
            1.00000000000000,
            1.00000000000000,
            1.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            1.00000000000000,
            1.00000000000000,
            1.00000000000000,
            1.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            1.00000000000000,
            1.00000000000000,
            1.00000000000000,
            1.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            1.00000000000000,
            1.00000000000000,
            1.00000000000000,
            1.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            1.00000000000000,
            1.00000000000000,
            1.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            1.00000000000000,
            1.00000000000000,
            1.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            1.00000000000000,
            1.00000000000000,
            1.00000000000000,
            1.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            1.00000000000000,
            1.00000000000000,
            1.00000000000000,
            1.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            1.00000000000000,
            1.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            1.00000000000000,
            1.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            1.00000000000000,
            1.00000000000000,
            1.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            1.00000000000000,
            1.00000000000000,
            1.00000000000000,
            1.00000000000000,
            1.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            1.00000000000000,
            1.00000000000000,
            1.00000000000000,
            1.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            1.00000000000000,
            1.00000000000000,
            1.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            1.00000000000000,
            1.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            1.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            1.00000000000000,
            1.00000000000000,
            0.25000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            1.00000000000000,
            1.00000000000000,
            1.00000000000000,
            0.25000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            1.00000000000000,
            1.00000000000000,
            1.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            1.00000000000000,
            1.00000000000000,
            1.00000000000000,
            1.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            1.00000000000000,
            1.00000000000000,
            1.00000000000000,
            1.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            1.00000000000000,
            1.00000000000000,
            1.00000000000000,
            1.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            1.00000000000000,
            1.00000000000000,
            1.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            1.00000000000000,
            1.00000000000000,
            1.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            1.00000000000000,
            1.00000000000000,
            1.00000000000000,
            1.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            1.00000000000000,
            1.00000000000000,
            1.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            1.00000000000000,
            1.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            1.00000000000000,
            1.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            1.00000000000000,
            1.00000000000000,
            1.00000000000000,
            1.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            1.00000000000000,
            1.00000000000000,
            1.00000000000000,
            1.00000000000000,
            1.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            1.00000000000000,
            1.00000000000000,
            1.00000000000000,
            1.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            1.00000000000000,
            1.00000000000000,
            1.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            1.00000000000000,
            1.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            1.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            1.00000000000000,
            1.00000000000000,
            0.25000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            1.00000000000000,
            1.00000000000000,
            1.00000000000000,
            0.25000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            1.00000000000000,
            1.00000000000000,
            1.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            1.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            1.00000000000000,
            1.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            1.00000000000000,
            1.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            1.00000000000000,
            1.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            1.00000000000000,
            1.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            1.00000000000000,
            1.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            1.00000000000000,
            1.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            1.00000000000000,
            1.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            1.00000000000000,
            1.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            1.00000000000000,
            1.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            1.00000000000000,
            1.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            1.00000000000000,
            1.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            1.00000000000000,
            1.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            1.00000000000000,
            1.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            1.00000000000000,
            1.00000000000000,
            1.00000000000000,
            1.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            1.00000000000000,
            1.00000000000000,
            1.00000000000000,
            1.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            1.00000000000000,
            1.00000000000000,
            1.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            1.00000000000000,
            1.00000000000000,
            1.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            1.00000000000000,
            1.00000000000000,
            1.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            1.00000000000000,
            1.00000000000000,
            1.00000000000000,
            1.00000000000000,
            1.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            1.00000000000000,
            1.00000000000000,
            1.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            1.00000000000000,
            1.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            1.00000000000000,
            1.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            1.00000000000000,
            1.00000000000000,
            1.00000000000000,
            1.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            1.00000000000000,
            1.00000000000000,
            1.00000000000000,
            1.00000000000000,
            1.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            1.00000000000000,
            1.00000000000000,
            1.00000000000000,
            1.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            1.00000000000000,
            1.00000000000000,
            1.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            1.00000000000000,
            1.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            1.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
    ],
    dtype=torch.float64,
)
refscount = torch.tensor(
    [
        [
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            1.00000000000000,
            4.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            1.00000000000000,
            2.00000000000000,
            4.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            1.00000000000000,
            2.00000000000000,
            3.00000000000000,
            6.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            1.00000000000000,
            2.00000000000000,
            4.00000000000000,
            6.00000000000000,
            6.00000000000000,
            1.00000000000000,
        ],
        [
            0.00000000000000,
            1.00000000000000,
            2.00000000000000,
            3.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            1.00000000000000,
            2.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            1.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            1.00000000000000,
            4.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            1.00000000000000,
            2.00000000000000,
            4.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            1.00000000000000,
            2.00000000000000,
            3.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            1.00000000000000,
            2.00000000000000,
            4.00000000000000,
            6.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            1.00000000000000,
            2.00000000000000,
            3.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            1.00000000000000,
            2.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            1.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            1.00000000000000,
            4.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            1.00000000000000,
            2.00000000000000,
            4.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            2.00000000000000,
            3.00000000000000,
            1.50000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            2.00000000000000,
            4.00000000000000,
            4.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            2.00000000000000,
            3.00000000000000,
            5.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            2.00000000000000,
            12.00000000000000,
            6.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            2.00000000000000,
            11.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            2.00000000000000,
            10.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            2.00000000000000,
            3.00000000000000,
            9.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            2.00000000000000,
            8.00000000000000,
            8.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            1.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            2.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            1.00000000000000,
            2.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            1.00000000000000,
            2.00000000000000,
            3.00000000000000,
            4.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            1.00000000000000,
            2.00000000000000,
            3.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            1.00000000000000,
            2.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            1.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            1.00000000000000,
            4.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            1.00000000000000,
            2.00000000000000,
            4.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            2.00000000000000,
            3.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            2.00000000000000,
            4.00000000000000,
            4.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            2.00000000000000,
            3.00000000000000,
            5.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            2.00000000000000,
            12.00000000000000,
            6.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            2.00000000000000,
            11.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            2.00000000000000,
            10.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            2.00000000000000,
            3.00000000000000,
            5.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            2.00000000000000,
            8.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            1.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            2.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            1.00000000000000,
            2.00000000000000,
            3.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            1.00000000000000,
            2.00000000000000,
            3.00000000000000,
            4.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            1.00000000000000,
            2.00000000000000,
            3.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            1.00000000000000,
            2.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            1.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            1.00000000000000,
            4.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            1.00000000000000,
            2.00000000000000,
            4.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            2.00000000000000,
            3.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            3.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            3.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            3.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            3.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            3.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            2.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            3.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            3.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            3.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            3.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            3.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            3.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            3.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            3.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            2.00000000000000,
            4.00000000000000,
            4.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            2.00000000000000,
            3.00000000000000,
            5.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            2.00000000000000,
            12.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            2.00000000000000,
            11.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            2.00000000000000,
            10.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            2.00000000000000,
            3.00000000000000,
            4.00000000000000,
            5.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            2.00000000000000,
            8.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            1.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            2.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            1.00000000000000,
            2.00000000000000,
            3.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            1.00000000000000,
            2.00000000000000,
            3.00000000000000,
            4.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            1.00000000000000,
            2.00000000000000,
            3.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            1.00000000000000,
            2.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            1.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
        [
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
            0.00000000000000,
        ],
    ],
    dtype=torch.float64,
)
refsys = torch.tensor(
    [
        [0, 0, 0, 0, 0, 0, 0],
        [1, 1, 0, 0, 0, 0, 0],
        [1, 0, 0, 0, 0, 0, 0],
        [1, 1, 17, 0, 0, 0, 0],
        [1, 1, 1, 9, 0, 0, 0],
        [1, 1, 1, 1, 1, 0, 0],
        [1, 1, 1, 1, 1, 1, 2],
        [1, 1, 1, 1, 1, 0, 0],
        [1, 1, 1, 1, 0, 0, 0],
        [1, 1, 0, 0, 0, 0, 0],
        [1, 0, 0, 0, 0, 0, 0],
        [1, 1, 17, 0, 0, 0, 0],
        [1, 1, 1, 9, 0, 0, 0],
        [1, 1, 1, 1, 0, 0, 0],
        [1, 1, 1, 1, 1, 0, 0],
        [1, 1, 1, 1, 0, 0, 0],
        [1, 1, 1, 0, 0, 0, 0],
        [1, 1, 0, 0, 0, 0, 0],
        [1, 0, 0, 0, 0, 0, 0],
        [1, 1, 17, 0, 0, 0, 0],
        [1, 1, 1, 9, 0, 0, 0],
        [1, 1, 1, 11, 0, 0, 0],
        [1, 1, 1, 11, 0, 0, 0],
        [1, 1, 1, 11, 0, 0, 0],
        [1, 1, 1, 8, 0, 0, 0],
        [1, 1, 1, 0, 0, 0, 0],
        [1, 1, 1, 0, 0, 0, 0],
        [1, 1, 1, 1, 0, 0, 0],
        [1, 1, 1, 1, 0, 0, 0],
        [1, 1, 0, 0, 0, 0, 0],
        [1, 1, 0, 0, 0, 0, 0],
        [1, 1, 1, 0, 0, 0, 0],
        [1, 1, 1, 1, 1, 0, 0],
        [1, 1, 1, 1, 0, 0, 0],
        [1, 1, 1, 0, 0, 0, 0],
        [1, 1, 0, 0, 0, 0, 0],
        [1, 0, 0, 0, 0, 0, 0],
        [1, 1, 17, 0, 0, 0, 0],
        [1, 1, 1, 9, 0, 0, 0],
        [1, 1, 1, 0, 0, 0, 0],
        [1, 1, 1, 11, 0, 0, 0],
        [1, 1, 1, 11, 0, 0, 0],
        [1, 1, 1, 1, 0, 0, 0],
        [1, 1, 1, 0, 0, 0, 0],
        [1, 1, 1, 0, 0, 0, 0],
        [1, 1, 1, 1, 0, 0, 0],
        [1, 1, 1, 0, 0, 0, 0],
        [1, 1, 0, 0, 0, 0, 0],
        [1, 1, 0, 0, 0, 0, 0],
        [1, 1, 1, 1, 0, 0, 0],
        [1, 1, 1, 1, 1, 0, 0],
        [1, 1, 1, 1, 0, 0, 0],
        [1, 1, 1, 0, 0, 0, 0],
        [1, 1, 0, 0, 0, 0, 0],
        [1, 0, 0, 0, 0, 0, 0],
        [1, 1, 17, 0, 0, 0, 0],
        [1, 1, 1, 9, 0, 0, 0],
        [1, 1, 1, 0, 0, 0, 0],
        [1, 0, 0, 0, 0, 0, 0],
        [1, 1, 0, 0, 0, 0, 0],
        [1, 1, 0, 0, 0, 0, 0],
        [1, 1, 0, 0, 0, 0, 0],
        [1, 1, 0, 0, 0, 0, 0],
        [1, 1, 0, 0, 0, 0, 0],
        [1, 1, 0, 0, 0, 0, 0],
        [1, 1, 0, 0, 0, 0, 0],
        [1, 1, 0, 0, 0, 0, 0],
        [1, 1, 0, 0, 0, 0, 0],
        [1, 1, 0, 0, 0, 0, 0],
        [1, 1, 0, 0, 0, 0, 0],
        [1, 1, 0, 0, 0, 0, 0],
        [1, 1, 0, 0, 0, 0, 0],
        [1, 1, 1, 11, 0, 0, 0],
        [1, 1, 1, 11, 0, 0, 0],
        [1, 1, 1, 0, 0, 0, 0],
        [1, 1, 1, 0, 0, 0, 0],
        [1, 1, 1, 0, 0, 0, 0],
        [1, 1, 1, 1, 1, 0, 0],
        [1, 1, 1, 0, 0, 0, 0],
        [1, 1, 0, 0, 0, 0, 0],
        [1, 1, 0, 0, 0, 0, 0],
        [1, 1, 1, 1, 0, 0, 0],
        [1, 1, 1, 1, 1, 0, 0],
        [1, 1, 1, 1, 0, 0, 0],
        [1, 1, 1, 0, 0, 0, 0],
        [1, 1, 0, 0, 0, 0, 0],
        [1, 0, 0, 0, 0, 0, 0],
    ],
    dtype=torch.long,
)
refc = torch.tensor(
    [
        [0, 0, 0, 0, 0, 0, 0],
        [3, 1, 0, 0, 0, 0, 0],
        [3, 0, 0, 0, 0, 0, 0],
        [3, 1, 1, 0, 0, 0, 0],
        [3, 1, 1, 1, 0, 0, 0],
        [3, 1, 1, 1, 1, 0, 0],
        [3, 3, 1, 3, 1, 3, 3],
        [3, 3, 1, 1, 3, 0, 0],
        [3, 3, 1, 3, 0, 0, 0],
        [3, 1, 0, 0, 0, 0, 0],
        [3, 0, 0, 0, 0, 0, 0],
        [3, 1, 1, 0, 0, 0, 0],
        [3, 1, 1, 1, 0, 0, 0],
        [3, 1, 1, 1, 0, 0, 0],
        [3, 1, 1, 1, 1, 0, 0],
        [3, 1, 1, 1, 0, 0, 0],
        [3, 1, 1, 0, 0, 0, 0],
        [3, 1, 0, 0, 0, 0, 0],
        [3, 0, 0, 0, 0, 0, 0],
        [3, 1, 1, 0, 0, 0, 0],
        [3, 1, 1, 1, 0, 0, 0],
        [3, 1, 1, 1, 0, 0, 0],
        [3, 1, 1, 1, 0, 0, 0],
        [3, 1, 1, 1, 0, 0, 0],
        [3, 1, 1, 1, 0, 0, 0],
        [3, 1, 1, 0, 0, 0, 0],
        [3, 1, 1, 0, 0, 0, 0],
        [3, 1, 1, 1, 0, 0, 0],
        [3, 1, 1, 1, 0, 0, 0],
        [3, 1, 0, 0, 0, 0, 0],
        [3, 1, 0, 0, 0, 0, 0],
        [3, 1, 1, 0, 0, 0, 0],
        [3, 1, 1, 1, 1, 0, 0],
        [3, 1, 1, 1, 0, 0, 0],
        [3, 1, 1, 0, 0, 0, 0],
        [3, 1, 0, 0, 0, 0, 0],
        [3, 0, 0, 0, 0, 0, 0],
        [3, 1, 1, 0, 0, 0, 0],
        [3, 1, 1, 1, 0, 0, 0],
        [3, 1, 1, 0, 0, 0, 0],
        [3, 1, 1, 1, 0, 0, 0],
        [3, 1, 1, 1, 0, 0, 0],
        [3, 1, 1, 1, 0, 0, 0],
        [3, 1, 1, 0, 0, 0, 0],
        [3, 1, 1, 0, 0, 0, 0],
        [3, 1, 1, 1, 0, 0, 0],
        [3, 1, 1, 0, 0, 0, 0],
        [3, 1, 0, 0, 0, 0, 0],
        [3, 1, 0, 0, 0, 0, 0],
        [3, 1, 1, 1, 0, 0, 0],
        [3, 1, 1, 1, 1, 0, 0],
        [3, 1, 1, 1, 0, 0, 0],
        [3, 1, 1, 0, 0, 0, 0],
        [3, 1, 0, 0, 0, 0, 0],
        [3, 0, 0, 0, 0, 0, 0],
        [3, 1, 1, 0, 0, 0, 0],
        [3, 1, 1, 1, 0, 0, 0],
        [3, 1, 1, 0, 0, 0, 0],
        [1, 0, 0, 0, 0, 0, 0],
        [3, 1, 0, 0, 0, 0, 0],
        [3, 1, 0, 0, 0, 0, 0],
        [3, 1, 0, 0, 0, 0, 0],
        [3, 1, 0, 0, 0, 0, 0],
        [3, 1, 0, 0, 0, 0, 0],
        [3, 1, 0, 0, 0, 0, 0],
        [3, 1, 0, 0, 0, 0, 0],
        [3, 1, 0, 0, 0, 0, 0],
        [3, 1, 0, 0, 0, 0, 0],
        [3, 1, 0, 0, 0, 0, 0],
        [3, 1, 0, 0, 0, 0, 0],
        [3, 1, 0, 0, 0, 0, 0],
        [3, 1, 0, 0, 0, 0, 0],
        [3, 1, 1, 1, 0, 0, 0],
        [3, 1, 1, 1, 0, 0, 0],
        [3, 1, 1, 0, 0, 0, 0],
        [3, 1, 1, 0, 0, 0, 0],
        [3, 1, 1, 0, 0, 0, 0],
        [3, 1, 1, 1, 1, 0, 0],
        [3, 1, 1, 0, 0, 0, 0],
        [3, 1, 0, 0, 0, 0, 0],
        [3, 1, 0, 0, 0, 0, 0],
        [3, 1, 1, 1, 0, 0, 0],
        [3, 1, 1, 1, 1, 0, 0],
        [3, 1, 1, 1, 0, 0, 0],
        [3, 1, 1, 0, 0, 0, 0],
        [3, 1, 0, 0, 0, 0, 0],
        [3, 0, 0, 0, 0, 0, 0],
    ]
)
secscale = torch.tensor(
    [
        [0.00000000000000],
        [0.50000000000000],
        [0.00000000000000],
        [0.00000000000000],
        [0.00000000000000],
        [0.00000000000000],
        [0.16666670000000],
        [1.00000000000000],
        [1.00000000000000],
        [0.50000000000000],
        [0.50000000000000],
        [0.50000000000000],
        [0.00000000000000],
        [0.00000000000000],
        [0.00000000000000],
        [0.00000000000000],
        [0.00000000000000],
        [0.50000000000000],
    ],
    dtype=torch.float64,
)
secalpha = torch.tensor(
    [
        [
            0.00000000000000e00,
            0.00000000000000e00,
            0.00000000000000e00,
            0.00000000000000e00,
            0.00000000000000e00,
            0.00000000000000e00,
            0.00000000000000e00,
            0.00000000000000e00,
            0.00000000000000e00,
            0.00000000000000e00,
            0.00000000000000e00,
            0.00000000000000e00,
            0.00000000000000e00,
            0.00000000000000e00,
            0.00000000000000e00,
            0.00000000000000e00,
            0.00000000000000e00,
            0.00000000000000e00,
            0.00000000000000e00,
            0.00000000000000e00,
            0.00000000000000e00,
            0.00000000000000e00,
            0.00000000000000e00,
        ],
        [
            5.44151600000000e00,
            5.39127200000000e00,
            5.24667800000000e00,
            4.74625700000000e00,
            4.11220500000000e00,
            3.48279900000000e00,
            2.92562600000000e00,
            2.45860200000000e00,
            2.07639000000000e00,
            1.76603500000000e00,
            1.51389800000000e00,
            1.30807400000000e00,
            9.98777000000000e-01,
            7.83360000000000e-01,
            6.28681000000000e-01,
            5.14505000000000e-01,
            4.28148000000000e-01,
            2.86767000000000e-01,
            2.04727000000000e-01,
            1.18756000000000e-01,
            7.72270000000000e-02,
            3.49350000000000e-02,
            1.97880000000000e-02,
        ],
        [
            5.44151600000000e00,
            5.39127200000000e00,
            5.24667800000000e00,
            4.74625700000000e00,
            4.11220500000000e00,
            3.48279900000000e00,
            2.92562600000000e00,
            2.45860200000000e00,
            2.07639000000000e00,
            1.76603500000000e00,
            1.51389800000000e00,
            1.30807400000000e00,
            9.98777000000000e-01,
            7.83360000000000e-01,
            6.28681000000000e-01,
            5.14505000000000e-01,
            4.28148000000000e-01,
            2.86767000000000e-01,
            2.04727000000000e-01,
            1.18756000000000e-01,
            7.72270000000000e-02,
            3.49350000000000e-02,
            1.97880000000000e-02,
        ],
        [
            0.00000000000000e00,
            0.00000000000000e00,
            0.00000000000000e00,
            0.00000000000000e00,
            0.00000000000000e00,
            0.00000000000000e00,
            0.00000000000000e00,
            0.00000000000000e00,
            0.00000000000000e00,
            0.00000000000000e00,
            0.00000000000000e00,
            0.00000000000000e00,
            0.00000000000000e00,
            0.00000000000000e00,
            0.00000000000000e00,
            0.00000000000000e00,
            0.00000000000000e00,
            0.00000000000000e00,
            0.00000000000000e00,
            0.00000000000000e00,
            0.00000000000000e00,
            0.00000000000000e00,
            0.00000000000000e00,
        ],
        [
            0.00000000000000e00,
            0.00000000000000e00,
            0.00000000000000e00,
            0.00000000000000e00,
            0.00000000000000e00,
            0.00000000000000e00,
            0.00000000000000e00,
            0.00000000000000e00,
            0.00000000000000e00,
            0.00000000000000e00,
            0.00000000000000e00,
            0.00000000000000e00,
            0.00000000000000e00,
            0.00000000000000e00,
            0.00000000000000e00,
            0.00000000000000e00,
            0.00000000000000e00,
            0.00000000000000e00,
            0.00000000000000e00,
            0.00000000000000e00,
            0.00000000000000e00,
            0.00000000000000e00,
            0.00000000000000e00,
        ],
        [
            0.00000000000000e00,
            0.00000000000000e00,
            0.00000000000000e00,
            0.00000000000000e00,
            0.00000000000000e00,
            0.00000000000000e00,
            0.00000000000000e00,
            0.00000000000000e00,
            0.00000000000000e00,
            0.00000000000000e00,
            0.00000000000000e00,
            0.00000000000000e00,
            0.00000000000000e00,
            0.00000000000000e00,
            0.00000000000000e00,
            0.00000000000000e00,
            0.00000000000000e00,
            0.00000000000000e00,
            0.00000000000000e00,
            0.00000000000000e00,
            0.00000000000000e00,
            0.00000000000000e00,
            0.00000000000000e00,
        ],
        [
            6.85832590000000e01,
            6.75115260000000e01,
            6.46123080000000e01,
            5.61286650000000e01,
            4.74318310000000e01,
            3.99459190000000e01,
            3.37814890000000e01,
            2.87553020000000e01,
            2.46561470000000e01,
            2.12992860000000e01,
            1.85340330000000e01,
            1.62406480000000e01,
            1.27133690000000e01,
            1.01832050000000e01,
            8.31946400000000e00,
            6.91337900000000e00,
            5.82981000000000e00,
            4.01066000000000e00,
            2.92309200000000e00,
            1.74948000000000e00,
            1.16548300000000e00,
            5.52306000000000e-01,
            3.24202000000000e-01,
        ],
        [
            1.38928580000000e01,
            1.37335660000000e01,
            1.32948950000000e01,
            1.19342710000000e01,
            1.04022050000000e01,
            8.97061900000000e00,
            7.72181400000000e00,
            6.66356800000000e00,
            5.77723400000000e00,
            5.03713400000000e00,
            4.41817300000000e00,
            3.89844100000000e00,
            3.08722400000000e00,
            2.49563300000000e00,
            2.05397900000000e00,
            1.71704600000000e00,
            1.45495700000000e00,
            1.00954500000000e00,
            7.39563000000000e-01,
            4.44560000000000e-01,
            2.96150000000000e-01,
            1.39252000000000e-01,
            8.09340000000000e-02,
        ],
        [
            1.29390420000000e01,
            1.28215110000000e01,
            1.24887870000000e01,
            1.13861750000000e01,
            1.00547130000000e01,
            8.75930600000000e00,
            7.60552200000000e00,
            6.61665900000000e00,
            5.78238600000000e00,
            5.08169900000000e00,
            4.49248400000000e00,
            3.99496300000000e00,
            3.21171900000000e00,
            2.63338300000000e00,
            2.19604000000000e00,
            1.85807800000000e00,
            1.59187400000000e00,
            1.13062300000000e00,
            8.43739000000000e-01,
            5.21230000000000e-01,
            3.53997000000000e-01,
            1.71631000000000e-01,
            1.01558000000000e-01,
        ],
        [
            1.03975870000000e01,
            1.03144230000000e01,
            1.00802310000000e01,
            9.31504800000000e00,
            8.40270200000000e00,
            7.50951200000000e00,
            6.69391100000000e00,
            5.97006900000000e00,
            5.33618200000000e00,
            4.78453000000000e00,
            4.30545700000000e00,
            3.88919800000000e00,
            3.21005900000000e00,
            2.68788400000000e00,
            2.27986700000000e00,
            1.95595300000000e00,
            1.69502800000000e00,
            1.22959000000000e00,
            9.30673000000000e-01,
            5.84862000000000e-01,
            4.00895000000000e-01,
            1.95985000000000e-01,
            1.16024000000000e-01,
        ],
        [
            1.16125430000000e01,
            1.15410500000000e01,
            1.13332410000000e01,
            1.05895270000000e01,
            9.58863000000000e00,
            8.52284100000000e00,
            7.51063500000000e00,
            6.60431400000000e00,
            5.81642800000000e00,
            5.14065500000000e00,
            4.56368500000000e00,
            4.07092400000000e00,
            3.28581300000000e00,
            2.69945300000000e00,
            2.25275600000000e00,
            1.90595100000000e00,
            1.63202700000000e00,
            1.15658300000000e00,
            8.60973000000000e-01,
            5.29497000000000e-01,
            3.58275000000000e-01,
            1.72584000000000e-01,
            1.01807000000000e-01,
        ],
        [
            8.14554930000000e00,
            8.10580810000000e00,
            7.99030830000000e00,
            7.57564330000000e00,
            7.01093960000000e00,
            6.39728550000000e00,
            5.79853810000000e00,
            5.24522490000000e00,
            4.74762460000000e00,
            4.30595100000000e00,
            3.91611670000000e00,
            3.57257100000000e00,
            3.00184110000000e00,
            2.55356710000000e00,
            2.19679300000000e00,
            1.90886090000000e00,
            1.67338120000000e00,
            1.24357280000000e00,
            9.59040000000000e-01,
            6.18656200000000e-01,
            4.31327600000000e-01,
            2.15901700000000e-01,
            1.29191200000000e-01,
        ],
        [
            0.00000000000000e00,
            0.00000000000000e00,
            0.00000000000000e00,
            0.00000000000000e00,
            0.00000000000000e00,
            0.00000000000000e00,
            0.00000000000000e00,
            0.00000000000000e00,
            0.00000000000000e00,
            0.00000000000000e00,
            0.00000000000000e00,
            0.00000000000000e00,
            0.00000000000000e00,
            0.00000000000000e00,
            0.00000000000000e00,
            0.00000000000000e00,
            0.00000000000000e00,
            0.00000000000000e00,
            0.00000000000000e00,
            0.00000000000000e00,
            0.00000000000000e00,
            0.00000000000000e00,
            0.00000000000000e00,
        ],
        [
            0.00000000000000e00,
            0.00000000000000e00,
            0.00000000000000e00,
            0.00000000000000e00,
            0.00000000000000e00,
            0.00000000000000e00,
            0.00000000000000e00,
            0.00000000000000e00,
            0.00000000000000e00,
            0.00000000000000e00,
            0.00000000000000e00,
            0.00000000000000e00,
            0.00000000000000e00,
            0.00000000000000e00,
            0.00000000000000e00,
            0.00000000000000e00,
            0.00000000000000e00,
            0.00000000000000e00,
            0.00000000000000e00,
            0.00000000000000e00,
            0.00000000000000e00,
            0.00000000000000e00,
            0.00000000000000e00,
        ],
        [
            0.00000000000000e00,
            0.00000000000000e00,
            0.00000000000000e00,
            0.00000000000000e00,
            0.00000000000000e00,
            0.00000000000000e00,
            0.00000000000000e00,
            0.00000000000000e00,
            0.00000000000000e00,
            0.00000000000000e00,
            0.00000000000000e00,
            0.00000000000000e00,
            0.00000000000000e00,
            0.00000000000000e00,
            0.00000000000000e00,
            0.00000000000000e00,
            0.00000000000000e00,
            0.00000000000000e00,
            0.00000000000000e00,
            0.00000000000000e00,
            0.00000000000000e00,
            0.00000000000000e00,
            0.00000000000000e00,
        ],
        [
            0.00000000000000e00,
            0.00000000000000e00,
            0.00000000000000e00,
            0.00000000000000e00,
            0.00000000000000e00,
            0.00000000000000e00,
            0.00000000000000e00,
            0.00000000000000e00,
            0.00000000000000e00,
            0.00000000000000e00,
            0.00000000000000e00,
            0.00000000000000e00,
            0.00000000000000e00,
            0.00000000000000e00,
            0.00000000000000e00,
            0.00000000000000e00,
            0.00000000000000e00,
            0.00000000000000e00,
            0.00000000000000e00,
            0.00000000000000e00,
            0.00000000000000e00,
            0.00000000000000e00,
            0.00000000000000e00,
        ],
        [
            0.00000000000000e00,
            0.00000000000000e00,
            0.00000000000000e00,
            0.00000000000000e00,
            0.00000000000000e00,
            0.00000000000000e00,
            0.00000000000000e00,
            0.00000000000000e00,
            0.00000000000000e00,
            0.00000000000000e00,
            0.00000000000000e00,
            0.00000000000000e00,
            0.00000000000000e00,
            0.00000000000000e00,
            0.00000000000000e00,
            0.00000000000000e00,
            0.00000000000000e00,
            0.00000000000000e00,
            0.00000000000000e00,
            0.00000000000000e00,
            0.00000000000000e00,
            0.00000000000000e00,
            0.00000000000000e00,
        ],
        [
            3.05968154000000e01,
            3.02907908000000e01,
            2.94281025000000e01,
            2.65588368000000e01,
            2.30571447000000e01,
            1.96470649000000e01,
            1.66420247000000e01,
            1.41130996000000e01,
            1.20267253000000e01,
            1.03165485000000e01,
            8.91401090000000e00,
            7.75901400000000e00,
            6.00422430000000e00,
            4.76712340000000e00,
            3.87056220000000e00,
            3.20390050000000e00,
            2.69658780000000e00,
            1.85880400000000e00,
            1.36658250000000e00,
            8.41173700000000e-01,
            5.79582400000000e-01,
            2.98188300000000e-01,
            1.87057200000000e-01,
        ],
    ],
    dtype=torch.float64,
)
