"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.IntegTesting = exports.Demo = void 0;
const path = require("path");
const lambda = require("@aws-cdk/aws-lambda");
const s3 = require("@aws-cdk/aws-s3");
const cdk = require("@aws-cdk/core");
const index_1 = require("./index");
class Demo extends cdk.Construct {
    constructor(scope, id) {
        super(scope, id);
        const bucket = new s3.Bucket(this, 'DemoBucket');
        // prepare the Function
        const fn = new index_1.Function(this, 'Handler', {
            code: lambda.Code.fromAsset(path.join(__dirname, '../aws-lambda-extensions/s3-logs-extension-demo/functionsrc')),
            runtime: lambda.Runtime.PYTHON_3_8,
            handler: 'lambda_function.lambda_handler',
            memorySize: 128,
            environment: {
                S3_BUCKET_NAME: bucket.bucketName,
            },
        });
        bucket.grantWrite(fn);
        // plug the `s3-logs-extension` in the lambda function
        fn.addExtension(new index_1.S3LogsExtension(this, 'S3BucketExtention').extension);
        // print the function name
        new cdk.CfnOutput(this, 'FunctionName', { value: fn.functionName });
        // print the S3 bucket name
        new cdk.CfnOutput(this, 'S3LogBucketName', { value: bucket.bucketName });
    }
}
exports.Demo = Demo;
// export class IntegTesting {
//   readonly stack: cdk.Stack[];
//   constructor() {
//     const app = new cdk.App();
//     const env = {
//       region: process.env.CDK_DEFAULT_REGION,
//       account: process.env.CDK_DEFAULT_ACCOUNT,
//     };
//     const stack = new cdk.Stack(app, 'demo-stack', { env });
//     new Demo(stack, 'Demo');
//     this.stack = [stack];
//   }
// }
class IntegTesting {
    constructor() {
        const app = new cdk.App();
        const env = {
            region: process.env.CDK_DEFAULT_REGION,
            account: process.env.CDK_DEFAULT_ACCOUNT,
        };
        const stack = new cdk.Stack(app, 'demo-stack', { env });
        this.stack = [stack];
    }
}
exports.IntegTesting = IntegTesting;
//# sourceMappingURL=data:application/json;base64,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