"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.StackWithDynamicSource = void 0;
// Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
// SPDX-License-Identifier: Apache-2.0
const aws_cdk_lib_1 = require("aws-cdk-lib");
/**
 * If you are using a dynamic location for assets and pass those as a variable
 * in your top stack, this allows you to continue passing those down
 */
class StackWithDynamicSource extends aws_cdk_lib_1.NestedStack {
    static updateBaseParams(scope, props) {
        if (props.assetsBucketsParameterName !== undefined) {
            let currentNode = scope;
            while (currentNode !== undefined && !(currentNode instanceof aws_cdk_lib_1.Stack)) {
                currentNode = currentNode.node.scope;
            }
            if (currentNode !== undefined) {
                let assetsBucket = currentNode.node.tryFindChild(props.assetsBucketsParameterName);
                if (assetsBucket !== undefined &&
                    assetsBucket instanceof aws_cdk_lib_1.CfnParameter) {
                    if (props.parameters === undefined) {
                        let tmp = {
                            parameters: {},
                            timeout: props.timeout,
                            notificationArns: props.notificationArns,
                            removalPolicy: props.removalPolicy,
                            description: props.description,
                        };
                        if (tmp.parameters !== undefined) {
                            tmp.parameters[props.assetsBucketsParameterName] =
                                assetsBucket.valueAsString;
                            if (props.assetsBucketPrefixParameterName !== undefined) {
                                let assetsBucketPrefix = currentNode.node.tryFindChild(props.assetsBucketPrefixParameterName);
                                if (assetsBucketPrefix !== undefined &&
                                    assetsBucketPrefix instanceof aws_cdk_lib_1.CfnParameter) {
                                    tmp.parameters[props.assetsBucketPrefixParameterName] =
                                        assetsBucketPrefix.valueAsString;
                                }
                            }
                        }
                        return tmp;
                    }
                    else {
                        props.parameters[props.assetsBucketsParameterName] =
                            assetsBucket.valueAsString;
                        if (props.assetsBucketPrefixParameterName !== undefined) {
                            let assetsBucketPrefix = currentNode.node.tryFindChild(props.assetsBucketPrefixParameterName);
                            if (assetsBucketPrefix !== undefined &&
                                assetsBucketPrefix instanceof aws_cdk_lib_1.CfnParameter) {
                                props.parameters[props.assetsBucketPrefixParameterName] =
                                    assetsBucketPrefix.valueAsString;
                            }
                        }
                    }
                }
            }
        }
        return props;
    }
    constructor(scope, id, props) {
        super(scope, id, StackWithDynamicSource.updateBaseParams(scope, props));
        let currentNode = this;
        while (currentNode !== undefined && !(currentNode instanceof aws_cdk_lib_1.Stack)) {
            currentNode = currentNode.node.scope;
        }
        if (currentNode !== undefined) {
            if (props.assetsBucketsParameterName !== undefined) {
                new aws_cdk_lib_1.CfnParameter(currentNode, props.assetsBucketsParameterName, {
                    type: 'String',
                });
            }
            if (props.assetsBucketPrefixParameterName !== undefined) {
                new aws_cdk_lib_1.CfnParameter(currentNode, props.assetsBucketPrefixParameterName, {
                    type: 'String',
                });
            }
        }
    }
}
exports.StackWithDynamicSource = StackWithDynamicSource;
//# sourceMappingURL=data:application/json;base64,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