import { NestedStack, NestedStackProps } from 'aws-cdk-lib';
import { Construct } from 'constructs';
export interface NestedStackWithDynamicSourceProps extends NestedStackProps {
    assetsBucketsParameterName?: string;
    assetsBucketPrefixParameterName?: string;
}
/**
 * If you are using a dynamic location for assets and pass those as a variable
 * in your top stack, this allows you to continue passing those down
 */
export declare class StackWithDynamicSource extends NestedStack {
    private static updateBaseParams;
    constructor(scope: Construct, id: string, props: NestedStackWithDynamicSourceProps);
}
