"use strict";
// Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
// SPDX-License-Identifier: Apache-2.0
Object.defineProperty(exports, "__esModule", { value: true });
exports.OutlierDetectionAlgorithm = void 0;
/**
 * Available algorithms for performing outlier detection
 */
var OutlierDetectionAlgorithm;
(function (OutlierDetectionAlgorithm) {
    /**
     * Defines using a static value to compare skew in faults or
     * high latency responses.
     *
     * A good default threshold for this is .7 meaning one AZ
     * is responsible for 70% of the total errors or high latency responses
     */
    OutlierDetectionAlgorithm["STATIC"] = "STATIC";
    /**
     * Uses the chi squared statistic to determine if there is a statistically
     * significant skew in fault rate or high latency distribution
     *
     * A normal default threshold for this is 0.05, which means there is a 5% or
     * less chance of the skew in errors or high latency responses occuring
     */
    OutlierDetectionAlgorithm["CHI_SQUARED"] = "CHI_SQUARED";
    /**
     * Uses z-score to determine if the skew in faults or high latency respones
     * exceeds a defined number of standard devations
     *
     * A good default threshold value for this is 2, meaning the outlier value is outside
     * 95% of the normal distribution. Using 3 means the outlier is outside 99.7% of
     * the normal distribution.
     */
    OutlierDetectionAlgorithm["Z_SCORE"] = "Z_SCORE";
    /**
     * Uses Interquartile Range Method to determine an outlier for faults or latency
     *
     * No threshold is required for this method and will be ignored
     */
    OutlierDetectionAlgorithm["IQR"] = "IQR";
    /**
     * Median Absolute Deviation (MAD) to determine an outlier for faults or latency
     *
     * A common default value threshold 3
     */
    OutlierDetectionAlgorithm["MAD"] = "MAD";
})(OutlierDetectionAlgorithm || (exports.OutlierDetectionAlgorithm = OutlierDetectionAlgorithm = {}));
//# sourceMappingURL=data:application/json;base64,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