"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.MetricsHelper = void 0;
const aws_lambda_1 = require("aws-cdk-lib/aws-lambda");
class MetricsHelper {
    /**
   * Increments a str by one char, for example
   * a -> b
   * z -> aa
   * ad -> ae
   *
   * This wraps at z and adds a new 'a'
   * @param str
   * @returns
   */
    static nextChar(str) {
        if (!str || str.length == 0) {
            return 'a';
        }
        let charA = str.split('');
        if (charA[charA.length - 1] === 'z') {
            return (MetricsHelper.nextChar(str.substring(0, charA.length - 1)) + 'a');
        }
        else {
            return (str.substring(0, charA.length - 1) +
                String.fromCharCode(charA[charA.length - 1].charCodeAt(0) + 1));
        }
    }
    static isNotEmpty(obj) {
        return obj !== undefined && obj !== null && Object.keys(obj).length > 0;
    }
}
exports.MetricsHelper = MetricsHelper;
MetricsHelper.PythonRuntime = aws_lambda_1.Runtime.PYTHON_3_13;
//# sourceMappingURL=data:application/json;base64,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