"use strict";
// Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
// SPDX-License-Identifier: Apache-2.0
Object.defineProperty(exports, "__esModule", { value: true });
exports.LatencyMetricType = void 0;
/**
 * The type of latency metric
 */
var LatencyMetricType;
(function (LatencyMetricType) {
    /**
     * Successful response latency
     */
    LatencyMetricType["SUCCESS_LATENCY"] = "Success_Latency";
    /**
     * Fault response latency
     */
    LatencyMetricType["FAULT_LATENCY"] = "Fault_Latency";
    /**
     * ALB target response time
     */
    LatencyMetricType["TARGET_LATENCY"] = "TargetResponseTime";
})(LatencyMetricType || (exports.LatencyMetricType = LatencyMetricType = {}));
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiTGF0ZW5jeU1ldHJpY1R5cGUuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi8uLi9zcmMvdXRpbGl0aWVzL0xhdGVuY3lNZXRyaWNUeXBlLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7QUFBQSxxRUFBcUU7QUFDckUsc0NBQXNDOzs7QUFFdEM7O0dBRUc7QUFDSCxJQUFZLGlCQWVYO0FBZkQsV0FBWSxpQkFBaUI7SUFDM0I7O09BRUc7SUFDSCx3REFBbUMsQ0FBQTtJQUVuQzs7T0FFRztJQUNILG9EQUErQixDQUFBO0lBRS9COztPQUVHO0lBQ0gsMERBQXFDLENBQUE7QUFDdkMsQ0FBQyxFQWZXLGlCQUFpQixpQ0FBakIsaUJBQWlCLFFBZTVCIiwic291cmNlc0NvbnRlbnQiOlsiLy8gQ29weXJpZ2h0IEFtYXpvbi5jb20sIEluYy4gb3IgaXRzIGFmZmlsaWF0ZXMuIEFsbCBSaWdodHMgUmVzZXJ2ZWQuXG4vLyBTUERYLUxpY2Vuc2UtSWRlbnRpZmllcjogQXBhY2hlLTIuMFxuXG4vKipcbiAqIFRoZSB0eXBlIG9mIGxhdGVuY3kgbWV0cmljXG4gKi9cbmV4cG9ydCBlbnVtIExhdGVuY3lNZXRyaWNUeXBlIHtcbiAgLyoqXG4gICAqIFN1Y2Nlc3NmdWwgcmVzcG9uc2UgbGF0ZW5jeVxuICAgKi9cbiAgU1VDQ0VTU19MQVRFTkNZID0gJ1N1Y2Nlc3NfTGF0ZW5jeScsXG5cbiAgLyoqXG4gICAqIEZhdWx0IHJlc3BvbnNlIGxhdGVuY3lcbiAgICovXG4gIEZBVUxUX0xBVEVOQ1kgPSAnRmF1bHRfTGF0ZW5jeScsXG5cbiAgLyoqXG4gICAqIEFMQiB0YXJnZXQgcmVzcG9uc2UgdGltZVxuICAgKi9cbiAgVEFSR0VUX0xBVEVOQ1kgPSBcIlRhcmdldFJlc3BvbnNlVGltZVwiXG59XG4iXX0=