"use strict";
// Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
// SPDX-License-Identifier: Apache-2.0
Object.defineProperty(exports, "__esModule", { value: true });
exports.AvailabilityMetricType = void 0;
/**
 * Different availability metric types
 */
var AvailabilityMetricType;
(function (AvailabilityMetricType) {
    /**
     * The success rate, i.e. (successful responses) / (successful + fault responses) * 100
     */
    AvailabilityMetricType["SUCCESS_RATE"] = "Success_Rate";
    /**
     * The number of success responses as an absolute value
     */
    AvailabilityMetricType["SUCCESS_COUNT"] = "Success_Count";
    /**
     * The fault rate, i.e. (fault responses) / (successful + fault responses) * 100
     */
    AvailabilityMetricType["FAULT_RATE"] = "Fault_Rate";
    /**
     * The number of fault responses as an absolute value
     */
    AvailabilityMetricType["FAULT_COUNT"] = "Fault_Count";
    /**
     * The number of requests received that resulted in either a fault or success. This
     * does not include "error" responses that would be equivalent to 4xx responses.
     */
    AvailabilityMetricType["REQUEST_COUNT"] = "Request_Count";
})(AvailabilityMetricType || (exports.AvailabilityMetricType = AvailabilityMetricType = {}));
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiQXZhaWxhYmlsaXR5TWV0cmljVHlwZS5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uLy4uL3NyYy91dGlsaXRpZXMvQXZhaWxhYmlsaXR5TWV0cmljVHlwZS50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiO0FBQUEscUVBQXFFO0FBQ3JFLHNDQUFzQzs7O0FBRXRDOztHQUVHO0FBQ0gsSUFBWSxzQkEwQlg7QUExQkQsV0FBWSxzQkFBc0I7SUFDaEM7O09BRUc7SUFDSCx1REFBNkIsQ0FBQTtJQUU3Qjs7T0FFRztJQUNILHlEQUErQixDQUFBO0lBRS9COztPQUVHO0lBQ0gsbURBQXlCLENBQUE7SUFFekI7O09BRUc7SUFDSCxxREFBMkIsQ0FBQTtJQUUzQjs7O09BR0c7SUFDSCx5REFBK0IsQ0FBQTtBQUNqQyxDQUFDLEVBMUJXLHNCQUFzQixzQ0FBdEIsc0JBQXNCLFFBMEJqQyIsInNvdXJjZXNDb250ZW50IjpbIi8vIENvcHlyaWdodCBBbWF6b24uY29tLCBJbmMuIG9yIGl0cyBhZmZpbGlhdGVzLiBBbGwgUmlnaHRzIFJlc2VydmVkLlxuLy8gU1BEWC1MaWNlbnNlLUlkZW50aWZpZXI6IEFwYWNoZS0yLjBcblxuLyoqXG4gKiBEaWZmZXJlbnQgYXZhaWxhYmlsaXR5IG1ldHJpYyB0eXBlc1xuICovXG5leHBvcnQgZW51bSBBdmFpbGFiaWxpdHlNZXRyaWNUeXBlIHtcbiAgLyoqXG4gICAqIFRoZSBzdWNjZXNzIHJhdGUsIGkuZS4gKHN1Y2Nlc3NmdWwgcmVzcG9uc2VzKSAvIChzdWNjZXNzZnVsICsgZmF1bHQgcmVzcG9uc2VzKSAqIDEwMFxuICAgKi9cbiAgU1VDQ0VTU19SQVRFID0gJ1N1Y2Nlc3NfUmF0ZScsXG5cbiAgLyoqXG4gICAqIFRoZSBudW1iZXIgb2Ygc3VjY2VzcyByZXNwb25zZXMgYXMgYW4gYWJzb2x1dGUgdmFsdWVcbiAgICovXG4gIFNVQ0NFU1NfQ09VTlQgPSAnU3VjY2Vzc19Db3VudCcsXG5cbiAgLyoqXG4gICAqIFRoZSBmYXVsdCByYXRlLCBpLmUuIChmYXVsdCByZXNwb25zZXMpIC8gKHN1Y2Nlc3NmdWwgKyBmYXVsdCByZXNwb25zZXMpICogMTAwXG4gICAqL1xuICBGQVVMVF9SQVRFID0gJ0ZhdWx0X1JhdGUnLFxuXG4gIC8qKlxuICAgKiBUaGUgbnVtYmVyIG9mIGZhdWx0IHJlc3BvbnNlcyBhcyBhbiBhYnNvbHV0ZSB2YWx1ZVxuICAgKi9cbiAgRkFVTFRfQ09VTlQgPSAnRmF1bHRfQ291bnQnLFxuXG4gIC8qKlxuICAgKiBUaGUgbnVtYmVyIG9mIHJlcXVlc3RzIHJlY2VpdmVkIHRoYXQgcmVzdWx0ZWQgaW4gZWl0aGVyIGEgZmF1bHQgb3Igc3VjY2Vzcy4gVGhpc1xuICAgKiBkb2VzIG5vdCBpbmNsdWRlIFwiZXJyb3JcIiByZXNwb25zZXMgdGhhdCB3b3VsZCBiZSBlcXVpdmFsZW50IHRvIDR4eCByZXNwb25zZXMuXG4gICAqL1xuICBSRVFVRVNUX0NPVU5UID0gJ1JlcXVlc3RfQ291bnQnLFxufVxuIl19