"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.MetricDimensions = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
// Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
// SPDX-License-Identifier: Apache-2.0
/**
 * Provides the ability to get operation specific metric dimensions
 * for metrics at the regional level as well as Availability Zone level
 */
class MetricDimensions {
    constructor(staticDimensions, availabilityZoneIdKey, regionKey) {
        this.staticDimensions = staticDimensions;
        this.availabilityZoneIdKey = availabilityZoneIdKey;
        this.regionKey = regionKey;
    }
    /**
     * Gets the zonal dimensions for these metrics by combining the static
     * metric dimensions with the keys provided for Availability Zone and
     * optional Region, expected to return something like
     * {
     *   "Region": "us-east-1",
     *   "AZ-ID": "use1-az1",
     *   "Operation": "ride",
     *   "Service": "WildRydes"
     * }
     * @param availabilityZoneId
     * @param region
     */
    zonalDimensions(availabilityZoneId, region) {
        let tmp = {};
        Object.assign(tmp, this.staticDimensions);
        tmp[this.availabilityZoneIdKey] = availabilityZoneId;
        if (this.regionKey !== undefined) {
            tmp[this.regionKey] = region;
        }
        return tmp;
    }
    /**
     * Gets the regional dimensions for these metrics by combining the static
     * metric dimensions with the keys provided the optional Region key,
     * expected to return something like
     * {
     *   "Region": "us-east-1",
     *   "Operation": "ride",
     *   "Service": "WildRydes"
     * }
     * @param region
     */
    regionalDimensions(region) {
        let tmp = {};
        Object.assign(tmp, this.staticDimensions);
        if (this.regionKey !== undefined) {
            tmp[this.regionKey] = region;
        }
        return tmp;
    }
}
exports.MetricDimensions = MetricDimensions;
_a = JSII_RTTI_SYMBOL_1;
MetricDimensions[_a] = { fqn: "@cdklabs/multi-az-observability.MetricDimensions", version: "0.0.1-alpha.14" };
//# sourceMappingURL=data:application/json;base64,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