import { Dashboard, IAlarm } from 'aws-cdk-lib/aws-cloudwatch';
import { ILogGroup } from 'aws-cdk-lib/aws-logs';
import { Construct } from 'constructs';
import { IInstrumentedServiceMultiAZObservability } from './IInstrumentedServiceMultiAZObservability';
import { InstrumentedServiceMultiAZObservabilityProps } from './props/InstrumentedServiceMultiAZObservabilityProps';
import { IServiceAlarmsAndRules } from '../alarmsandrules/IServiceAlarmsAndRules';
/**
 * An service that implements its own instrumentation to record
 * availability and latency metrics that can be used to create
 * alarms, rules, and dashboards from
 */
export declare class InstrumentedServiceMultiAZObservability extends Construct implements IInstrumentedServiceMultiAZObservability {
    /**
     * Key represents the operation name and the value is the set
     * of zonal alarms and rules for that operation. The values themselves
     * are dictionaries that have a key for each AZ ID.
     */
    private readonly perOperationAlarmsAndRules;
    /**
     * Index into the dictionary by operation name, then by Availability Zone Id
     * to get the alarms that indicate an AZ shows isolated impact from availability
     * or latency as seen by either the server-side or canary. These are the alarms
     * you would want to use to trigger automation to evacuate an AZ.
     */
    readonly perOperationZonalImpactAlarms: {
        [key: string]: {
            [key: string]: IAlarm;
        };
    };
    /**
     * The alarms and rules for the overall service
     */
    readonly serviceAlarms: IServiceAlarmsAndRules;
    /**
     * The dashboards for each operation
     */
    readonly operationDashboards?: Dashboard[];
    /**
     * The service level dashboard
     */
    readonly serviceDashboard?: Dashboard;
    /**
     * The AZ mapper custom resource used to map AZ Ids to Names and vice a versa
     */
    private readonly azMapper;
    /**
     * If the service is configured to have canary tests created, this will
     * be the log group where the canary's logs are stored.
     *
     * @default - No log group is created if the canary is not requested.
     */
    readonly canaryLogGroup?: ILogGroup;
    private readonly outlierDetectionFunction?;
    constructor(scope: Construct, id: string, props: InstrumentedServiceMultiAZObservabilityProps);
}
