import { IFunction } from 'aws-cdk-lib/aws-lambda';
import { ILogGroup } from 'aws-cdk-lib/aws-logs';
import { Construct } from 'constructs';
import { IOutlierDetectionFunction } from './IOutlierDetectionFunction';
import { OutlierDetectionFunctionProps } from './props/OutlierDetectionFunctionProps';
export declare class OutlierDetectionFunction extends Construct implements IOutlierDetectionFunction {
    /**
     * The z-score function
     */
    function: IFunction;
    /**
     * The log group where the canarty logs will be sent
     */
    logGroup: ILogGroup;
    constructor(scope: Construct, id: string, props: OutlierDetectionFunctionProps);
}
