"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ZonalLatencyMetrics = void 0;
// Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
// SPDX-License-Identifier: Apache-2.0
const aws_cdk_lib_1 = require("aws-cdk-lib");
const aws_cloudwatch_1 = require("aws-cdk-lib/aws-cloudwatch");
const AvailabilityAndLatencyMetrics_1 = require("./AvailabilityAndLatencyMetrics");
const MetricsHelper_1 = require("../utilities/MetricsHelper");
class ZonalLatencyMetrics {
    /**
     * Creates a zonal latency metric
     * @param props
     * @returns
     */
    static createZonalLatencyMetrics(props) {
        return AvailabilityAndLatencyMetrics_1.AvailabilityAndLatencyMetrics.createLatencyMetrics(props, props.metricDetails.metricDimensions.zonalDimensions(props.availabilityZoneId, aws_cdk_lib_1.Fn.ref('AWS::Region')));
    }
    /**
     * Creates an average zonal latency metric
     * @param props
     * @returns
     */
    static createZonalAverageLatencyMetric(props) {
        return AvailabilityAndLatencyMetrics_1.AvailabilityAndLatencyMetrics.createAverageLatencyMetric(props, props.metricDetails.metricDimensions.zonalDimensions(props.availabilityZoneId, aws_cdk_lib_1.Fn.ref('AWS::Region')));
    }
    /**
     * Creates a count of high latency metric
     * @param props
     * @returns
     */
    static createZonalCountLatencyMetric(props) {
        return AvailabilityAndLatencyMetrics_1.AvailabilityAndLatencyMetrics.createLatencyCountMetric(props, props.metricDetails.metricDimensions.zonalDimensions(props.availabilityZoneId, aws_cdk_lib_1.Fn.ref('AWS::Region')));
    }
    /**
     * Creates a count of high latency responses for all critical operations
     * @param props
     * @returns
     */
    static createZonalServiceLatencyMetrics(props, includeAZCountAggregate) {
        if (includeAZCountAggregate) {
            let usingMetrics = {};
            let operationMetrics = [];
            let keyPrefix = MetricsHelper_1.MetricsHelper.nextChar();
            props.latencyMetricProps.forEach((prop, index) => {
                let operationZonalMetric = this.createZonalCountLatencyMetric(prop);
                operationMetrics.push(operationZonalMetric);
                usingMetrics[`${keyPrefix}${index}`] = operationZonalMetric;
                keyPrefix = MetricsHelper_1.MetricsHelper.nextChar(keyPrefix);
            });
            if (Object.keys(usingMetrics).length == 1) {
                operationMetrics.push(Object.values(usingMetrics)[0]);
            }
            else {
                let math = new aws_cloudwatch_1.MathExpression({
                    usingMetrics: usingMetrics,
                    period: props.period,
                    label: props.label,
                    expression: Object.keys(usingMetrics).join('+'),
                });
                operationMetrics.splice(0, 0, math);
            }
            return operationMetrics;
        }
        else {
            return props.latencyMetricProps.map((prop) => {
                return this.createZonalCountLatencyMetric(prop);
            });
        }
    }
}
exports.ZonalLatencyMetrics = ZonalLatencyMetrics;
//# sourceMappingURL=data:application/json;base64,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