import { IMetric } from 'aws-cdk-lib/aws-cloudwatch';
import { ServiceLatencyMetricProps } from './props/ServiceLatencyMericProps';
import { ZonalLatencyMetricProps } from './props/ZonalLatencyMetricProps';
export declare class ZonalLatencyMetrics {
    /**
     * Creates a zonal latency metric
     * @param props
     * @returns
     */
    static createZonalLatencyMetrics(props: ZonalLatencyMetricProps): IMetric[];
    /**
     * Creates an average zonal latency metric
     * @param props
     * @returns
     */
    static createZonalAverageLatencyMetric(props: ZonalLatencyMetricProps): IMetric;
    /**
     * Creates a count of high latency metric
     * @param props
     * @returns
     */
    static createZonalCountLatencyMetric(props: ZonalLatencyMetricProps): IMetric;
    /**
     * Creates a count of high latency responses for all critical operations
     * @param props
     * @returns
     */
    static createZonalServiceLatencyMetrics(props: ServiceLatencyMetricProps, includeAZCountAggregate?: boolean): IMetric[];
}
