import { IMetric } from 'aws-cdk-lib/aws-cloudwatch';
import { ServiceAvailabilityMetricProps } from './props/ServiceAvailabilityMetricProps';
import { ZonalAvailabilityMetricProps } from './props/ZonalAvailabilityMetricProps';
export declare class ZonalAvailabilityMetrics {
    /**
     * Creates a zonal service level availability metrics, one metric for
     * each operation at the zonal level and the service.
     * @param props
     * @returns The metric at index 0 is the metric math expression for the whole service. The following metrics
     * are the metrics for each operation included in the request availability metric props.
     */
    static createZonalServiceAvailabilityMetrics(props: ServiceAvailabilityMetricProps): IMetric[];
    /**
     * Creates a zonal availability metric
     * @param props
     * @returns
     */
    static createZonalAvailabilityMetric(props: ZonalAvailabilityMetricProps): IMetric;
}
