"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.NetworkLoadBalancerMetrics = void 0;
const aws_cloudwatch_1 = require("aws-cdk-lib/aws-cloudwatch");
class NetworkLoadBalancerMetrics {
    /**
     * Creates a regional processed bytes metric for the specified load balancer
     * @param loadBalancerFullName
     * @param period
     * @returns
     */
    static createRegionalNetworkLoadBalancerProcessedBytesMetric(loadBalancerFullName, period) {
        return new aws_cloudwatch_1.Metric({
            metricName: 'ProcessedBytes',
            namespace: 'AWS/NetworkELB',
            unit: aws_cloudwatch_1.Unit.COUNT,
            period: period,
            statistic: 'Sum',
            dimensionsMap: {
                LoadBalancer: loadBalancerFullName,
            },
            label: 'ProcessedBytes',
        });
    }
    /**
     * Creates a zonal processed bytes metric for the specified load balancer
     * @param loadBalancerFullName
     * @param availabilityZoneName
     * @param period
     * @returns
     */
    static createZonalNetworkLoadBalancerProcessedBytesMetric(loadBalancerFullName, availabilityZoneName, period) {
        return new aws_cloudwatch_1.Metric({
            metricName: 'ProcessedBytes',
            namespace: 'AWS/NetworkELB',
            unit: aws_cloudwatch_1.Unit.COUNT,
            period: period,
            statistic: 'Sum',
            dimensionsMap: {
                LoadBalancer: loadBalancerFullName,
                AvailabilityZone: availabilityZoneName,
            },
            label: 'ProcessedBytes',
        });
    }
}
exports.NetworkLoadBalancerMetrics = NetworkLoadBalancerMetrics;
//# sourceMappingURL=data:application/json;base64,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