import { Duration } from 'aws-cdk-lib';
import { IMetric } from 'aws-cdk-lib/aws-cloudwatch';
export declare class NetworkLoadBalancerMetrics {
    /**
     * Creates a regional processed bytes metric for the specified load balancer
     * @param loadBalancerFullName
     * @param period
     * @returns
     */
    static createRegionalNetworkLoadBalancerProcessedBytesMetric(loadBalancerFullName: string, period: Duration): IMetric;
    /**
     * Creates a zonal processed bytes metric for the specified load balancer
     * @param loadBalancerFullName
     * @param availabilityZoneName
     * @param period
     * @returns
     */
    static createZonalNetworkLoadBalancerProcessedBytesMetric(loadBalancerFullName: string, availabilityZoneName: string, period: Duration): IMetric;
}
