import { IMetric } from 'aws-cdk-lib/aws-cloudwatch';
import { AvailabilityMetricProps } from './props/AvailabilityMetricProps';
import { LatencyMetricProps } from './props/LatencyMetricProps';
/**
 * Class for creating availability and latency metrics that can be used in alarms and graphs
 */
export declare class AvailabilityAndLatencyMetrics {
    /**
     * General purpose method to create availability metrics
     * @param props
     * @param dimensions
     * @returns
     */
    static createAvailabilityMetric(props: AvailabilityMetricProps, dimensions: {
        [key: string]: string;
    }): IMetric;
    /**
     * General purpose method to create latency metrics, the reason this creates an array of metrics while the
     * equivalent availability metric method doesn't is because in availability, we can just sum the count of different
     * metric names while for latency we can't sum the count because that's not what's being measured. It allows the
     * caller to decide if they only want to take the first name, or average all of the names
     * (like SuccessLatency and BigItemSuccessLatency).
     *
     * @param props
     * @param dimensions
     * @returns
     */
    static createLatencyMetrics(props: LatencyMetricProps, dimensions: {
        [key: string]: string;
    }): IMetric[];
    /**
     * Takes all of the success or failure latency metric names and creates an average of those
     * names, if there's only 1 name, it just returns that metric
     * @param props
     * @param dimensions
     */
    static createAverageLatencyMetric(props: LatencyMetricProps, dimensions: {
        [key: string]: string;
    }): IMetric;
    /**
     * Creates a count of high latency metrics for either SuccessLatency or FaultLatency, will total
     * the count of requests that exceed a threshold you define in your statistic, like TC(200:) across
     * all metric names that are part of either Success or Fault latency.
     * @param props
     * @returns
     */
    static createLatencyCountMetric(props: LatencyMetricProps, dimensions: {
        [key: string]: string;
    }): IMetric;
}
