import { IMetric } from "aws-cdk-lib/aws-cloudwatch";
import { IApplicationLoadBalancer } from "aws-cdk-lib/aws-elasticloadbalancingv2";
import { ZonalApplicationLoadBalancerLatencyMetricProps } from "../basic_observability/props/ZonalApplicationLoadBalancerLatencyMetricProps";
import { ZonalApplicationLoadBalancerAvailabilityMetricProps } from "../basic_observability/props/ZonalApplicationLoadBalancerAvailabilityMetricProps";
import { Duration } from "aws-cdk-lib";
import { RegionalApplicationLoadBalancerAvailabilityMetricProps } from "../basic_observability/props/RegionalApplicationLoadBalancerAvailabilityMetricProps";
import { RegionalApplicationLoadBalancerLatencyMetricProps } from "../basic_observability/props/RegionalApplicationLoadBalancerLatencyMetricProps";
import { AvailabilityZoneMapper } from "../azmapper/AvailabilityZoneMapper";
export declare class ApplicationLoadBalancerMetrics {
    /**
     * Gets the TargetResponseTime latency for the ALB
     * targets
     * @param props The request props
     * @returns The TargetResponseTime metric for the ALB in the specified AZ
     */
    static getPerAZLatencyMetric(props: ZonalApplicationLoadBalancerLatencyMetricProps): IMetric;
    /**
     * Gets either the successful, fault, or total count metrics
     * for the load balancer targets across all of the provided
     * ALBs in each AZ.
     * @param albs The ALBs to aggregate the count of
     * @param props The request props
     * @returns The total count of sucess, faults, or total requests in the specified AZ
     */
    static getPerAZAvailabilityMetricCountAggregate(albs: IApplicationLoadBalancer[], props: ZonalApplicationLoadBalancerAvailabilityMetricProps): IMetric;
    /**
     * Gets a specified availability metric in the specified AZ for the ALB
     * @param alb The ALB
     * @param props The request props
     * @returns The metric requested
     */
    static getPerAZAvailabilityMetric(alb: IApplicationLoadBalancer, props: ZonalApplicationLoadBalancerAvailabilityMetricProps): IMetric;
    /**
     * Gets the ALBs specified availability metric at the regional level (only looks
     * at the regional dimension for the targets, not per AZ)
     * @param alb The ALB
     * @param props The request props
     * @returns The regional availability metric requested
     */
    static getRegionalAvailabilityMetric(alb: IApplicationLoadBalancer, props: RegionalApplicationLoadBalancerAvailabilityMetricProps): IMetric;
    /**
     * Gets the ALB's TargetResponseTime metric at the regional level (only looks
     * at the regional dimension for the targets, not per AZ)
     * @param props  The request props
     * @returns
     */
    static getRegionalLatencyMetric(props: RegionalApplicationLoadBalancerLatencyMetricProps): IMetric;
    /**
     * Calculates the total number of faults for all ALBs combined per AZ
     * @param albs The ALBs to aggregate
     * @param period The period of time to calculate the metrics
     * @param azMapper The AZ mapper function so the metrics are correctly labeled with their AZ ID
     * @returns
     */
    static getTotalAlbFaultCountPerZone(albs: IApplicationLoadBalancer[], period: Duration, azMapper: AvailabilityZoneMapper, prefix?: string): {
        [key: string]: IMetric;
    };
    /**
     * Calculates the total number of faults for all ALBs combined per AZ
     * @param albs The ALBs to aggregate
     * @param period The period of time to calculate the metrics
     * @param azMapper The AZ mapper function so the metrics are correctly labeled with their AZ ID
     * @returns
     */
    static getTotalAlbSuccessCountPerZone(albs: IApplicationLoadBalancer[], period: Duration, azMapper: AvailabilityZoneMapper): {
        [key: string]: IMetric;
    };
    /**
     * Calculates the total number of processed bytes for all ALBs in each zone
     * @param albs
     * @param period
     * @param azMapper
     * @returns
     */
    static getTotalAlbRequestsPerZone(albs: IApplicationLoadBalancer[], period: Duration, azMapper: AvailabilityZoneMapper, prefix?: string): {
        [key: string]: IMetric;
    };
    /**
     * Calculates the total number of processed bytes for all ALBs in each zone
     * @param albs
     * @param period
     * @param azMapper
     * @returns
     */
    static getTotalAlbProcessedBytesPerZone(albs: IApplicationLoadBalancer[], period: Duration, azMapper: AvailabilityZoneMapper): {
        [key: string]: IMetric;
    };
    /**
     * Calculates a weighted approximation of the latency at the provided statistic for all ALBs
     * in each zone.
     * @param albs
     * @param statistic
     * @param period
     * @param azMapper
     * @returns
     */
    static getTotalAlbLatencyPerZone(albs: IApplicationLoadBalancer[], statistic: string, period: Duration, azMapper: AvailabilityZoneMapper): {
        [key: string]: IMetric;
    };
    /**
     * Calculates the fault rate per AZ
     * @param requestsPerZone
     * @param faultsPerZone
     * @param period
     * @param azMapper
     * @returns The fault rate per AZ using the AZ name letter as the key for each metric
     */
    static getTotalAlbFaultRatePerZone(albs: IApplicationLoadBalancer[], period: Duration, azMapper: AvailabilityZoneMapper): {
        [key: string]: IMetric;
    };
    /**
     * Creates a zonal processed bytes metric for the specified load balancer
     * @param loadBalancerFullName
     * @param availabilityZoneName
     * @param period
     * @returns IMetric
     */
    static getPerAZProcessedBytesMetric(alb: IApplicationLoadBalancer, availabilityZone: string, availabilityZoneId: string, period: Duration, addLoadBalancerArnToLabel?: boolean): IMetric;
    /**
     * Creates a zonal processed bytes metric for the specified load balancer
     * @param loadBalancerFullName
     * @param availabilityZoneName
     * @param period
     * @returns IMetric
     */
    static getRegionalProcessedBytesMetric(alb: IApplicationLoadBalancer, period: Duration, addLoadBalancerArn?: boolean): IMetric;
}
