import { Dashboard } from 'aws-cdk-lib/aws-cloudwatch';
import { Construct } from 'constructs';
import { IServiceAvailabilityAndLatencyDashboard } from './IServiceAvailabilityAndLatencyDashboard';
import { ServiceAvailabilityAndLatencyDashboardProps } from './props/ServiceAvailabilityAndLatencyDashboardProps';
/**
 * Creates a service level availability and latency dashboard
 */
export declare class ServiceAvailabilityAndLatencyDashboard extends Construct implements IServiceAvailabilityAndLatencyDashboard {
    private static generateTPSWidgets;
    private static generateServerSideAndCanaryAvailabilityWidgets;
    private static generateServerSideAndCanaryLatencyWidgets;
    private static generateAvailabilityWidgets;
    private static generateLatencyMetricWidgets;
    private static createRegionalAvailabilityMetricProps;
    private static createRegionalLatencyMetricProps;
    private static createZonalAvailabilityMetricProps;
    private static createZonalLatencyMetricProps;
    private static generateLoadBalancerWidgets;
    /**
     * The service level dashboard
     */
    dashboard: Dashboard;
    constructor(scope: Construct, id: string, props: ServiceAvailabilityAndLatencyDashboardProps);
}
