import { Dashboard } from 'aws-cdk-lib/aws-cloudwatch';
import { Construct } from 'constructs';
import { IOperationAvailabilityAndLatencyDashboard } from './IOperationAvailabilityAndLatencyDashboard';
import { OperationAvailabilityAndLatencyDashboardProps } from './props/OperationAvailabilityAndLatencyDashboardProps';
/**
 * Creates an operation level availability and latency dashboard
 */
export declare class OperationAvailabilityAndLatencyDashboard extends Construct implements IOperationAvailabilityAndLatencyDashboard {
    private static createTopLevelAggregateAlarmWidgets;
    private static createAvailabilityWidgets;
    private static createLatencyWidgets;
    private static createApplicationLoadBalancerWidgets;
    private static createNetworkLoadBalancerWidgets;
    /**
     * The operation level dashboard
     */
    dashboard: Dashboard;
    private azMapper;
    constructor(scope: Construct, id: string, props: OperationAvailabilityAndLatencyDashboardProps);
}
