"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ContributorInsightsWidget = void 0;
// Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
// SPDX-License-Identifier: Apache-2.0
const aws_cdk_lib_1 = require("aws-cdk-lib");
const aws_cloudwatch_1 = require("aws-cdk-lib/aws-cloudwatch");
/**
 * A Contributor Insight dashboard widget
 */
class ContributorInsightsWidget extends aws_cloudwatch_1.ConcreteWidget {
    /**
     * Creates the widget
     * @param props
     */
    constructor(props) {
        super(props.width === undefined ? 6 : props.width, props.height === undefined ? 6 : props.height);
        this.properties = props;
    }
    /**
     * Converts the widget into an array of JSON objects (not string), this returns
     * a single item in the array
     * @returns An array of dictionaries
     */
    toJson() {
        return [
            {
                type: 'metric',
                width: this.width,
                height: this.height,
                x: this.x,
                y: this.y,
                properties: {
                    insightRule: {
                        maxContributorCount: this.properties.topContributors,
                        orderBy: this.properties.orderStatistic,
                        ruleName: this.properties.insightRule.attrRuleName,
                    },
                    region: this.properties.region !== undefined
                        ? this.properties.region
                        : aws_cdk_lib_1.Fn.ref('AWS::Region'),
                    legend: {
                        position: this.properties.legendPosition,
                    },
                    view: 'timeSeries',
                    period: this.properties.period.toSeconds(),
                    title: this.properties.title,
                    accountId: this.properties.accountId,
                },
            },
        ];
    }
}
exports.ContributorInsightsWidget = ContributorInsightsWidget;
//# sourceMappingURL=data:application/json;base64,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