"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.CanaryTest = void 0;
// Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
// SPDX-License-Identifier: Apache-2.0
const aws_cdk_lib_1 = require("aws-cdk-lib");
const aws_events_1 = require("aws-cdk-lib/aws-events");
const aws_events_targets_1 = require("aws-cdk-lib/aws-events-targets");
const constructs_1 = require("constructs");
class CanaryTest extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        this.timedEventRules = {};
        this.metricNamespace = props.operation.canaryMetricDetails
            ? props.operation.canaryMetricDetails.canaryAvailabilityMetricDetails
                .metricNamespace
            : 'canary/metrics';
        props.operation.service.availabilityZoneNames.forEach((availabilityZoneName, index) => {
            let availabilityZoneId = props.azMapper.availabilityZoneIdFromAvailabilityZoneLetter(availabilityZoneName.substring(availabilityZoneName.length - 1));
            let scheme = props.operation.service.baseUrl.split(':')[0];
            let url = scheme +
                '://' +
                availabilityZoneName +
                '.' +
                props.loadBalancer.loadBalancerDnsName +
                props.operation.path;
            let data = {
                parameters: {
                    methods: props.httpMethods !== undefined
                        ? props.httpMethods
                        : props.operation.httpMethods,
                    url: url,
                    postData: props.postData === undefined ? '' : props.postData,
                    headers: props.headers === undefined ? {} : props.headers,
                    operation: props.operation.operationName,
                    faultBoundaryId: availabilityZoneId,
                    faultBoundary: 'az',
                    metricNamespace: this.metricNamespace,
                    requestCount: props.requestCount,
                },
            };
            this.timedEventRules[availabilityZoneId] = new aws_events_1.Rule(this, 'AZ' + index + props.operation.operationName + 'TimedEvent', {
                schedule: aws_events_1.Schedule.expression(props.schedule),
                enabled: true,
                targets: [
                    new aws_events_targets_1.LambdaFunction(props.function, {
                        event: aws_events_1.RuleTargetInput.fromObject(data),
                    }),
                ],
            });
        });
        let scheme = props.operation.service.baseUrl.split(':')[0];
        let url = scheme +
            '://' +
            props.loadBalancer.loadBalancerDnsName +
            props.operation.path;
        let data = {
            parameters: {
                methods: props.httpMethods !== undefined
                    ? props.httpMethods
                    : props.operation.httpMethods,
                url: url,
                postData: props.postData === undefined ? '' : props.postData,
                headers: props.headers === undefined ? {} : props.headers,
                operation: props.operation.operationName,
                faultBoundaryId: aws_cdk_lib_1.Fn.ref('AWS::Region'),
                faultBoundary: 'region',
                metricNamespace: this.metricNamespace,
                requestCount: props.regionalRequestCount,
            },
        };
        this.timedEventRules[aws_cdk_lib_1.Fn.ref('AWS::Region')] = new aws_events_1.Rule(this, 'RegionalTimedEvent', {
            schedule: aws_events_1.Schedule.expression(props.schedule),
            enabled: true,
            targets: [
                new aws_events_targets_1.LambdaFunction(props.function, {
                    event: aws_events_1.RuleTargetInput.fromObject(data),
                }),
            ],
        });
    }
}
exports.CanaryTest = CanaryTest;
//# sourceMappingURL=data:application/json;base64,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